/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.sessions.Session;

public class JAXBElementRootConverter
implements XMLConverter {
    private Class declaredType;
    private XMLConverter nestedConverter;

    public JAXBElementRootConverter(Class declaredType) {
        this.declaredType = declaredType;
    }

    public Converter getNestedConverter() {
        return this.nestedConverter;
    }

    public void setNestedConverter(XMLConverter nestedConverter) {
        this.nestedConverter = nestedConverter;
    }

    @Override
    public void initialize(DatabaseMapping mapping, Session session) {
        if (this.nestedConverter != null) {
            this.nestedConverter.initialize(mapping, session);
        }
    }

    @Override
    public Object convertDataValueToObjectValue(Object dataValue, Session session) {
        return this.convertDataValueToObjectValue(dataValue, session, null);
    }

    @Override
    public Object convertDataValueToObjectValue(Object dataValue, Session session, XMLUnmarshaller unmarshaller) {
        if (this.nestedConverter != null) {
            dataValue = this.nestedConverter.convertDataValueToObjectValue(dataValue, session, unmarshaller);
        }
        if (dataValue instanceof JAXBElement) {
            return dataValue;
        }
        if (dataValue instanceof XMLRoot) {
            XMLRoot root = (XMLRoot)dataValue;
            QName name = new QName(root.getNamespaceURI(), root.getLocalName());
            dataValue = root.getObject();
            if (dataValue == null) {
                return this.createJAXBElement(name, Object.class, dataValue);
            }
            return this.createJAXBElement(name, this.declaredType, dataValue);
        }
        return dataValue;
    }

    @Override
    public Object convertObjectValueToDataValue(Object objectValue, Session session) {
        return this.convertObjectValueToDataValue(objectValue, session, null);
    }

    @Override
    public Object convertObjectValueToDataValue(Object objectValue, Session session, XMLMarshaller marshaller) {
        ClassDescriptor desc;
        if (this.nestedConverter != null) {
            objectValue = this.nestedConverter.convertObjectValueToDataValue(objectValue, session, marshaller);
        }
        if (objectValue instanceof JAXBElement && ((desc = session.getDescriptor(objectValue)) == null || objectValue instanceof WrappedValue)) {
            JAXBElement element = (JAXBElement)objectValue;
            XMLRoot root = new XMLRoot();
            root.setLocalName(element.getName().getLocalPart());
            root.setNamespaceURI(element.getName().getNamespaceURI());
            root.setObject(element.getValue());
            return root;
        }
        return objectValue;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    private JAXBElement createJAXBElement(QName qname, Class theClass, Object value) {
        if (value != null && value instanceof JAXBElement) {
            return (JAXBElement)value;
        }
        if (ClassConstants.XML_GREGORIAN_CALENDAR.isAssignableFrom(theClass)) {
            theClass = ClassConstants.XML_GREGORIAN_CALENDAR;
        } else if (ClassConstants.DURATION.isAssignableFrom(theClass)) {
            theClass = ClassConstants.DURATION;
        }
        return new JAXBElement(qname, theClass, value);
    }
}

