/**
 * External Data Declarations for SmartClient Showcase Samples
 * ============================================================
 *
 * IMPORTANT: This file MUST be kept up to date whenever ANY sample adds a new static dataset,
 * DataSource, or global variable. Failing to update this file will cause TypeScript compilation
 * errors (TS2304 "Cannot find name") when the sample is converted to TypeScript.
 *
 * This file declares global variables that are loaded by the Showcase framework
 * at runtime before individual samples execute. These include:
 * - Test data arrays (eventData, animalTree, etc.)
 * - DataSource instances loaded from .ds.xml files
 * - Shared UI components and layouts
 * - Drawing constants and configuration
 * - Sample-specific functions
 *
 * MAINTENANCE:
 * When TypeScript compilation reports "Cannot find name 'xxx'" (TS2304),
 * add the missing identifier to the appropriate section below.
 *
 * Run this command to find missing identifiers:
 *   npx tsc --noEmit 2>&1 | grep TS2304 | sort -u
 *
 * SAMPLE-SPECIFIC PROPERTIES:
 * For properties that are custom to a sample (callbacks, state, etc.) and not
 * part of the SmartClient framework API, use the second parameter to create():
 *
 *   isc.IButton.create({
 *       title: "Save"
 *   }, {
 *       saveEditPane: function() { ... }
 *   });
 *
 * The second parameter is untyped, so custom properties work without type errors.
 * See TypeScriptSampleConversion.md for the full pattern including custom interfaces.
 */

// =============================================================================
// TEST DATA ARRAYS - loaded by Showcase from separate data files
// =============================================================================
declare var animalData: any;
declare var animalTree: any;
declare var carFeatures: any;
declare var carModels: any;
declare var categoryTree: any;
declare var chartData: any;
declare var commonGradients: any;
declare var componentTree: any;
declare var countryData: any;
declare var countryData1: any;
declare var countryData2: any;
declare var countryDataHilites: any;
declare var dayLaneData: any;
declare var employeeData: any;
declare var employeeTree: any;
declare var eventData: any;
declare var eventOverlapData: any;
declare var events: any;
declare var exampleData: any;
declare var exampleText: any;
declare var government_descriptions: any;
declare var htmlFragments: any;
declare var populationData: any;
declare var presetDateRangeData: any;
declare var productData: any;
declare var propertyDocs: any;
declare var stockQuotes: any;

// =============================================================================
// DATASOURCE INSTANCES - loaded from .ds.xml files by Showcase
// =============================================================================
declare var ai_dashboards: any;
declare var cityIncludeFromHB: any;
declare var cityIncludeFromJPA: any;
declare var cityIncludeFromSQL: any;
declare var cityManyToOneSimpleHB: any;
declare var cityManyToOneSimpleJPA: any;
declare var cityOneToManyHB: any;
declare var cityOneToManyJPA: any;
declare var CM_Employee: any;
declare var CM_OrderLine: any;
declare var CM_Payment: any;
declare var countryOneToManyHB: any;
declare var countryOneToManyJPA: any;
declare var countryTransactions: any;
declare var customerOrderMessages: any;
declare var customerOrders: any;
declare var customBinaryField: any;
declare var customDataSource_user: any;
declare var dynamicDSFields: any;
declare var dynamicReporting_orderItem: any;
declare var employees: isc.DataSource;
declare var employeesByTeam: any;
declare var employeesCO: any;
declare var employees_template: any;
declare var filteredAggregation_orderItem: any;
declare var filterOnServer: isc.DataSource;
declare var gridUserViewState: any;
declare var imageProcessing: any;
declare var itemLocalDS: any;
declare var largeValueMap_orderItem: any;
declare var largeValueMap_orderItemHB: any;
declare var mediaLibrary: any;
declare var mediaLibraryHB: any;
declare var mediaLibraryJPA: any;
declare var moneyTransfer: any;
declare var moneyTransferFK: any;
declare var orderDS: any;
declare var Order_AggregatedField: any;
declare var OrderLine_FormulaField: any;
declare var orderItemLocalDS: any;
declare var ormDataSource_country: any;
declare var queuedAdd_order: any;
declare var queuedAdd_orderItem: any;
declare var rbCountryTransactions: any;
declare var reusableORMDataSource_supplyItem: any;
declare var staff: any;
declare var supplyCategory: isc.DataSource;
declare var supplyCatalog: any;
declare var supplyItem: isc.DataSource;
declare var supplyItemCustom: any;
declare var supplyItemDMI: any;
declare var supplyItemDownload: any;
declare var supplyItemExport: any;
declare var supplyItemHB: any;
declare var supplyItemHBAutoDerive: any;
declare var supplyItemJPAAutoDerive: any;
declare var supplyItemSpringDMI: any;
declare var supplyItemWithOps: any;
declare var tasks: any;
declare var teams: any;
declare var worldDSExport: any;
declare var worldDSExportCustom: any;
declare var worldDSExportWithFormats: any;
declare var worldHB: any;
declare var worldJPA2: any;

// =============================================================================
// UI COMPONENTS - created by samples or Showcase framework
// =============================================================================
declare var actionBar: any;
declare var addButton: any;
declare var advancedFilter: any;
declare var animals: any;
declare var auditedList: any;
declare var auditForm: any;
declare var auditList: any;
declare var basicCubeGrid: any;
declare var bindButton: any;
declare var bookmarkForm: any;
declare var bottomContainer: any;
declare var boundForm: any;
declare var boundList: any;
declare var boundList1: any;
declare var boundList2: any;
declare var builtinViewsMenu: any;
declare var buttonAI: any;
declare var buttonLayout: any;
declare var buttonPdf: any;
declare var buttonPreview: any;
declare var buttons: any;
declare var carDataLabel: any;
declare var categoryDS: any;
declare var chunksPath: any;
declare var clearButton: any;
declare var collapseBtn: any;
declare var colorBox: any;
declare var container: any;
declare var contentEditor: any;
declare var countriesGrid: any;
declare var countryDS: any;
declare var countryFilter: any;
declare var countryForm: any;
declare var countryGrid: any;
declare var countryList: any;
declare var countryList1: any;
declare var countryList2: any;
declare var criteriaForm: any;
declare var cssButton: any;
declare var customMapsSampleForm: any;
declare var customMapsSampleLayout: any;
declare var databoundMapsSampleLayout: any;
declare var dataForm: any;
declare var deleteBtn: any;
declare var destroyAndRecreateButton: any;
declare var directionForm: isc.DynamicForm;
declare var drawCurve: any;
declare var drawItemProperties: any;
declare var drawLine: any;
declare var drawLinePath: any;
declare var drawOval: any;
declare var drawPolygon: any;
declare var drawRect: any;
declare var drawTriangle: any;
declare var dsFieldEditList: any;
declare var dsRequest: any;
declare var dynamicChart: any;
declare var dynamicChartLayout: any;
declare var editCanvas: any;
declare var editPane: any;
declare var editTab: any;
declare var eventListener: any;
declare var eventsForm: any;
declare var eventTracker: any;
declare var expandBtn: any;
declare var exportForm: any;
declare var favoritesForm: any;
declare var featureExplorer_exampleViewer: any;
declare var fillScreenWindow: any;
declare var filterBuilder: any;
declare var filterForm: any;
declare var filterGrid: any;
declare var flowLayout: any;
declare var form: any;
declare var form1: any;
declare var formContainer: any;
declare var generateUpdatesButton: any;
declare var getDataURLButton: any;
declare var gMapsDS: any;
declare var greenStar: any;
declare var help1: any;
declare var hLayout: any;
declare var hlayout: any;
declare var htmlCanvas: any;
declare var ID_gaugeSample_gaugeValueConfigItem: any;
declare var imageViewer: any;
declare var imgButton: any;
declare var instantUI: any;
declare var interactiveCenterMapsSampleForm: any;
declare var interactiveCenterMapsSampleLayout: any;
declare var itemForm: any;
declare var itemList: any;
declare var itemsStack: any;
declare var itemViewer: isc.DetailViewer;
declare var label1: any;
declare var label2: any;
declare var labelCategory: any;
declare var lgIssues: any;
declare var lgScienceStudies: any;
declare var lgWorld: any;
declare var list1: any;
declare var list2: any;
declare var listGrid: any;
declare var listPalette: any;
declare var longMessageButton: any;
declare var mainLayout: any;
declare var mainPane: any;
declare var markersVisibilityMapsSampleLayout: any;
declare var mediaListGrid: any;
declare var mediaTileGrid: any;
declare var menuButton: any;
declare var menuButtonStack: any;
declare var myBox: any;
declare var myList1: any;
declare var myList2: any;
declare var myPane: any;
declare var myTree1: any;
declare var myTree2: any;
declare var navBar: any;
declare var orderGrid: any;
declare var ordersListGrid: any;
declare var outputFields: any;
declare var pageLayout: any;
declare var paneRotation: any;
declare var partsTree1: any;
declare var partsTree2: any;
declare var portal: any;
declare var portalContentArea: any;
declare var portalLayout: any;
declare var preferenceForm: any;
declare var preferenceSelectItem: any;
declare var printContainer: any;
declare var printGrid: any;
declare var printStack: any;
declare var printViewer: any;
declare var projectForm: any;
declare var projectSelector: any;
declare var recentDateRange: any;
declare var refGrid: any;
declare var removeButton: any;
declare var report: any;
declare var saveBtn: any;
declare var saveButton: any;
declare var saveForm: any;
declare var scienceStudiesLayout: any;
declare var searchForm: any;
declare var selectedSupplyItems: any;
declare var serverCount: any;
declare var setupSpoofing: any;
declare var shapesRotation: any;
declare var show: any;
declare var showComponentXMLButton: any;
declare var slidersForm: any;
declare var snapshotImg: any;
declare var sortForm: any;
declare var staticMapsSampleLayout: any;
declare var statusPane: any;
declare var statusReport: any;
declare var stockChart: any;
declare var stockQuotesChart: any;
declare var stretchButton: any;
declare var sundriesSupplyItemsList: any;
declare var supplyGrid: any;
declare var supplyItemList: any;
declare var supplyList: any;
declare var tabSet: any;
declare var teamForm: any;
declare var teamMembers: any;
declare var teamMembers2: any;
declare var teamShuttle: any;
declare var textBox: any;
declare var textCanvas: any;
declare var tilePalette: any;
declare var toolbarViewsMenu: any;
declare var toolStrip: any;
declare var topContainer: any;
declare var totalsLabel: any;
declare var touchButton: any;
declare var treeForm: any;
declare var tutorialButton: any;
declare var tutorialLaunchWindow: any;
declare var uploadForm: any;
declare var userDetailViewer: any;
declare var userIssuesLayout: any;
declare var validatedTab: any;
declare var valuesLabel: any;
declare var viewAsList: any;
declare var viewAsTiles: any;
declare var viewer: any;
declare var vLayout: any;
declare var vlayout: any;
declare var worldDS: any;
declare var worldLayout: any;
declare var xmlLayout: any;

// =============================================================================
// DRAWING CONSTANTS - used in drawing samples
// =============================================================================
declare var DEFAULT_ARROW_HEAD_STYLE: any;
declare var DEFAULT_DIRECTION: any;
declare var DEFAULT_LINE_CAP: any;
declare var DEFAULT_LINE_COLOR: any;
declare var DEFAULT_LINE_PATTERN: any;
declare var DEFAULT_LINE_WIDTH: any;

// =============================================================================
// SAMPLE-SPECIFIC FUNCTIONS AND VARIABLES
// =============================================================================
declare var createMainUI: any;
declare var createUI: any;
declare var currentUser: any;
declare var data: any;
declare var editNew: any;
declare var infix: any;
declare var initialZoomLevel: any;
declare var item: any;
declare var lastUpdated: any;
declare var node: any;
declare var placeholder: any;
declare var record: any;
declare var reload: any;
declare var scrollTop: any;
declare var clampedScrollTop: any;
declare var USE_YAHOO_FINANCE: any;
declare var value: any;

// =============================================================================
// STARTER APP INSTANCES
// =============================================================================
declare var accountsStarterApp: any;
declare var dashboardStarterApp: any;
declare var issueTrackingApp: any;
declare var orderManagementApp: any;

// =============================================================================
// THIRD-PARTY LIBRARY GLOBALS
// =============================================================================
declare var google: any;
declare var FCKeditor: any;
declare var TextItem: any;

// =============================================================================
// ISC NAMESPACE EXTENSIONS - missing from generated smartclient.d.ts
// =============================================================================
declare namespace isc {
    // isAn utilities
    namespace isAn {
        function Array(obj: any): boolean;
        function Object(obj: any): boolean;
        function Instance(obj: any): boolean;
        var emptyObject: any;
        var emptyString: any;
    }

    // Math utilities
    namespace Math {
        function random(): number;
    }

    // Canvas static methods
    interface CanvasStatic {
        registerCrossFrameDrags(): void;
    }

    // Browser properties
    interface BrowserStatic {
        hasNativeDrag: boolean;
        isIE: boolean;
        version: number;
    }

    // EventHandler properties
    interface EventHandlerStatic {
        lastEvent: any;
        mouseDownEvent: any;
    }
}
