isc.ListGrid.create({
    ID: "grid",
    width: "100%", height: "100%",
    dataSource: "worldDS", dataFetchMode: "local", autoFetchData: true,
    sortField: "countryName",
    showFilterEditor: true,
    filterViaAIMode: "aiAssist"
});

var exampleFilterDescriptions = [
    "population less than 1 million",
    "in South America",
    "nationhood prior to 1900",
    "area more than 500K square miles",
    "country name starts with a vowel",
    "member of the G8"
];

isc.VLayout.create({
    width: "100%",
    height: "100%",
    members: [
        isc.HLayout.create({
            width: "100%",
            height: "*",
            members: [isc.Label.create({height: "30", contents: "Examples: ", autoFit: true})].concat(exampleFilterDescriptions.map(function (exampleFilterDescription) {
                return isc.IButton.create({
                    title: "\"" + exampleFilterDescription + "\"",
                    prompt: exampleFilterDescription,
                    autoFit: true,
                    click : function () {
                        grid.filterViaAI(exampleFilterDescription);
                    }
                });
            }))
            .concat([ 
              isc.IButton.create({
                title:"Custom Prompt",
                click: function () {
                    grid.showAIFilterWindow();
                }
              })
            ]),
            membersMargin: 6
        }),
        grid
    ],
    membersMargin: 12
});

