/* Auto-Generated React */
import React from 'react';
import 'smartclient-lgpl/release';
import 'smartclient-lgpl/skins/Tahoe';

import { SC, Button, Shuttle, VLayout } from 'smartclient-lgpl/react';

// a "render target" can be defined to allow JSX to be loaded dynamically into an existing application.  This Showcase sets a
// render target of "showcaseSample" so each JSX file can be loaded and later removed when the user is done with the sample.
let target = SC.getRenderTarget() || "showcaseSample";

let onShowCurrentTeamMembersClick = function () {
    var team = teamShuttle.getSelectedRecords();
    if (team.length == 0)
        isc.say('Team is empty');
    else {
        var notificationString = 'Current team members:<ul>';
        for (var member of team) {
            notificationString += '<li>' + member.Name + ' (' + member.Email + ')</li>';
        }
        notificationString += '</ul>';
        isc.say(notificationString);
    }
};

var employeeData = [
    {
        'OrgUnit': 'Management',
        'Email': 'cmadigan@server.com',
        'EmployeeId': 4,
        'Name': 'Charles Madigen'
    },
    {
        'OrgUnit': 'Management',
        'Email': 'tkane@server.com',
        'teams': [
            3,
            2
        ],
        'EmployeeId': 182,
        'Name': 'Tamara Kane'
    },
    {
        'OrgUnit': 'Management',
        'Email': 'jlittle@server.com',
        'EmployeeId': 183,
        'Name': 'Joan Little'
    },
    {
        'OrgUnit': 'Management',
        'Email': 'kamirov@server.com',
        'teams': [5],
        'EmployeeId': 184,
        'Name': 'Kirill Amirov'
    },
    {
        'OrgUnit': 'Management',
        'Email': 'rshu@server.com',
        'teams': [
            1,
            4
        ],
        'EmployeeId': 185,
        'Name': 'Rui Shu'
    },
    {
        'OrgUnit': 'Management',
        'Email': 'jgarrison@server.com',
        'EmployeeId': 186,
        'Name': 'John Garrison'
    },
    {
        'OrgUnit': 'Management',
        'Email': 'alippman@server.com',
        'teams': [1],
        'EmployeeId': 187,
        'Name': 'Abigail Lippman'
    },
    {
        'OrgUnit': 'Management',
        'Email': 'rleger@server.com',
        'EmployeeId': 188,
        'Name': 'Rogine Leger'
    },
    {
        'OrgUnit': 'Management',
        'Email': 'gporter@server.com',
        'EmployeeId': 189,
        'Name': 'Gene Porter'
    },
    {
        'OrgUnit': 'Management',
        'Email': 'cfinley@server.com',
        'EmployeeId': 190,
        'Name': 'Carol Finley'
    }
];

// SC.render() calls ReactDOM.render() in React pre-18, and
// ReactDOM.createRoot().render() in React 18+, to avoid deprecation warnings.
SC.render(
    <VLayout membersMargin="5" width="100%" height="100%">
        <members>
            <Shuttle ID="teamShuttle" data={employeeData} valueField="EmployeeId" sourceGridTitle="Staff" targetGridTitle="Team Members">
                <fields>
                	<name>Name</name>
                </fields>
                <fields>
                	<name>Email</name>
                </fields>
            </Shuttle>
            <Button layoutAlign="center" title="Show Current Team Members" width="200" click={onShowCurrentTeamMembersClick}/>
        </members>
    </VLayout>,
    document.getElementById(target)
);
