/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.base.Reflection;
import com.isomorphic.log.Logger;

public class GraalJSEngine {
    private static Logger log = new Logger(GraalJSEngine.class.getName());
    private static final String CONTEXT_CLASS = "org.graalvm.polyglot.Context";
    private static final String CONTEXT_BUILDER_CLASS = "org.graalvm.polyglot.Context$Builder";
    private static final String VALUE_CLASS = "org.graalvm.polyglot.Value";
    private static final String SOURCE_CLASS = "org.graalvm.polyglot.Source";
    private static final String LANGUAGE = "js";
    private static Boolean graalAvailable = null;
    private Object context;

    public static boolean isAvailable() {
        if (graalAvailable != null) {
            return graalAvailable;
        }
        try {
            Reflection.classForName(CONTEXT_CLASS);
            graalAvailable = true;
            log.info("GraalJS is available in classpath");
            return true;
        }
        catch (Exception e) {
            graalAvailable = false;
            log.debug("GraalJS not available: " + e.getMessage());
            return false;
        }
    }

    public static boolean isEnabled() {
        String useGraal = System.getenv("DEV_USE_GRAAL");
        return "true".equalsIgnoreCase(useGraal);
    }

    public GraalJSEngine() {
        this(true);
    }

    public GraalJSEngine(boolean allowHostAccess) {
        if (!GraalJSEngine.isAvailable()) {
            throw new RuntimeException("GraalJS is not available in classpath. Add Graal JARs to lib/devenv/ and enable with 'go --graal' or 'docker-go --graal'");
        }
        try {
            Object builder = Reflection.invokeStaticMethod(CONTEXT_CLASS, "newBuilder", new Object[]{new String[]{LANGUAGE}});
            if (allowHostAccess) {
                builder = Reflection.invokeMethod(builder, "allowAllAccess", true);
            }
            this.context = Reflection.invokeMethod(builder, "build", new Object[0]);
            log.debug("GraalJS context created successfully");
        }
        catch (Exception e) {
            log.error("Failed to create GraalJS context: " + e.getMessage());
            throw new RuntimeException("Failed to create GraalJS context", e);
        }
    }

    public Object eval(String script) {
        if (this.context == null) {
            throw new IllegalStateException("Engine is closed or not initialized");
        }
        try {
            Object value = Reflection.invokeMethod(this.context, "eval", LANGUAGE, script);
            return Reflection.invokeMethod(value, "as", Object.class);
        }
        catch (Exception e) {
            log.error("JavaScript evaluation failed: " + e.getMessage());
            throw new RuntimeException("JavaScript evaluation failed: " + e.getMessage(), e);
        }
    }

    public void putBinding(String name, Object value) {
        if (this.context == null) {
            throw new IllegalStateException("Engine is closed or not initialized");
        }
        try {
            Object bindings = Reflection.invokeMethod(this.context, "getBindings", LANGUAGE);
            Reflection.invokeMethod(bindings, "putMember", name, value);
            log.debug("Bound variable '" + name + "' to JavaScript context");
        }
        catch (Exception e) {
            log.error("Failed to bind variable '" + name + "': " + e.getMessage());
            throw new RuntimeException("Failed to bind variable: " + e.getMessage(), e);
        }
    }

    public Object getBinding(String name) {
        if (this.context == null) {
            throw new IllegalStateException("Engine is closed or not initialized");
        }
        try {
            Object bindings = Reflection.invokeMethod(this.context, "getBindings", LANGUAGE);
            Object member = Reflection.invokeMethod(bindings, "getMember", name);
            if (member == null) {
                return null;
            }
            return Reflection.invokeMethod(member, "as", Object.class);
        }
        catch (Exception e) {
            log.error("Failed to get binding '" + name + "': " + e.getMessage());
            throw new RuntimeException("Failed to get binding: " + e.getMessage(), e);
        }
    }

    public void close() {
        if (this.context != null) {
            try {
                Reflection.invokeMethod(this.context, "close", new Object[0]);
                log.debug("GraalJS context closed");
            }
            catch (Exception e) {
                log.warn("Error closing GraalJS context: " + e.getMessage());
            }
            finally {
                this.context = null;
            }
        }
    }

    public boolean isOpen() {
        return this.context != null;
    }
}

