# SmartClient API Reference (Part 2 of 2)

[← Back to Part 1](reference.md)

---

## Type: Alignment

### Description
—

### Values

| Value | Description |
|-------|-------------|
| Canvas.CENTER | Center within container. |
| Canvas.LEFT | Stick to left side of container. |
| Canvas.RIGHT | Stick to right side of container. |

### Groups

- appearance

---
## Type: AnimateShowEffectId

### Description
String specifying effect to apply during an animated show or hide.

### Values

| Value | Description |
|-------|-------------|
| "slide" | content slides into or out of view as the widget grows or shrinks |
| "wipe" | content is revealed or wiped as the widget grows or shrinks |
| "fade" | widget's opacity smoothly fades into or out of view |
| "fly" | widget moves into position from offscreen |

---
## Type: ArrowStyle

### Description
Supported styles for arrowheads.

### Values

| Value | Description |
|-------|-------------|
| "block" | Filled triangle. |
| "open" | Two lines are drawn on each side of the path. |

---
## Type: Autofit

### Description
Possible values to change the behavior of how data will fill the ListGrid.

### Values

| Value | Description |
|-------|-------------|
| "vertical" | expand vertically to accommodate records. |
| "horizontal" | expand horizontally to accommodate fields. |
| "both" | expand horizontally and vertically to accommodate content. |

### Groups

- autoFitData

---
## Type: AutoFitIconFieldType

### Description
How should fields of [type:"icon"](#type-listgridfieldtype) be sized by default?

### Values

| Value | Description |
|-------|-------------|
| "none" | Apply no special sizing to icon fields - treat them like any other field in the grid |
| "iconWidth" | size the field to accommodate the width of the icon |
| "title" | size the field to accommodate the title (or the width of the icon if it exceeds the width of the title. |

### Groups

- autoFitFields

---
## Type: AutoFitWidthApproach

### Description
How should field width be determined when [ListGridField.autoFitWidth](classes/ListGridField.md#attr-listgridfieldautofitwidth) is true?

### Values

| Value | Description |
|-------|-------------|
| "value" | Size field to fit to the data value(s) contained in the field. |
| "title" | Size field to fit the field title |
| "both" | Size field to fit either the field title or the data values in the field (whichever requires more space). |

### Groups

- autoFitFields

---
## Type: AutoTestLocator

### Description
An AutoTestLocator is a string generated by the [AutoTest](classes/AutoTest.md#class-autotest) class to reliably identify an interactive element in a SmartClient application. Locators allow integration with automated testing tools. For an overview of automated testing in SmartClient, see the documentation topic [here](kb_topics/automatedTesting.md#kb-topic-automated-testing).

AutoTestLocators are designed to work across browsers, SmartClient versions, and even major changes to your application's UI. They do not rely on the DOM structure, and are intended to be able to identify the target element reliably without requiring pervasive explicitly specified [component IDs](classes/Canvas.md#attr-canvasid).

The [AutoTest](classes/AutoTest.md#class-autotest) class is responsible for creating locator strings corresponding to DOM elements, SmartClient components or other objects, and for resolving locators back to those objects at runtime.

A locator for an element may be retrieved via [AutoTest.getLocator](classes/AutoTest.md#classmethod-autotestgetlocator), or by using the [locator shortcut tool](classes/AutoTest.md#classmethod-autotestinstalllocatorshortcut), or the _"Show AutoTest Locators"_ link on the _Results_ tab of the SmartClient [Developer Console](kb_topics/debugging.md#kb-topic-debugging).

Stored locators may be resolved to target elements via [AutoTest.getElement](classes/AutoTest.md#classmethod-autotestgetelement) (or resolved to target objects via [AutoTest.getObject](classes/AutoTest.md#classmethod-autotestgetobject)).

**Best Practices for building applications with reliable locators**

Developers should be aware of certain considerations that can make generated AutoTestLocators more reliable when designing their application.

The [reliableLocators](kb_topics/reliableLocators.md#kb-topic-generating-reliable-autotestlocators) overview topic covers general recommendations to ensure that AutoTestLocators are robust and reliable within your app.

The [portableAutoTests](kb_topics/portableAutoTests.md#kb-topic-writing-autotests-for-multiple-environments) topic discusses considerations around recording and playing back test scripts over different environments with changes to data or user interface, and the capabilities SmartClient offers to address these considerations.
## Type: Axis

### Description
An axis or "side" of a table.

### Values

| Value | Description |
|-------|-------------|
| "row" | Row axis |
| "column" | Column axis |

---
## Type: BackgroundRepeat

### Description
Possible values for [Canvas.backgroundRepeat](classes/Canvas.md#attr-canvasbackgroundrepeat).

### Values

| Value | Description |
|-------|-------------|
| Canvas.REPEAT | Tile the background image horizontally and vertically. |
| Canvas.NO_REPEAT | Don't tile the background image at all. |
| Canvas.REPEAT_X | Repeat the background image horizontally but not vertically. |
| Canvas.REPEAT_Y | Repeat the background image vertically but not horizontally. |

### Groups

- appearance

---
## Type: CacheSyncStrategy

### Description
Indicates the strategy to be used for [automatic cache synchronization](kb_topics/cacheSynchronization.md#kb-topic-automatic-cache-synchronization), for a given [DataSource](classes/DataSource.md#attr-datasourcecachesyncstrategy), [OperationBinding](classes/OperationBinding.md#attr-operationbindingcachesyncstrategy) or [DSRequest](classes/DSRequest.md#attr-dsrequestcachesyncstrategy).

### Values

| Value | Description |
|-------|-------------|
| "refetch" | Obtain cache sync values by refetching the record we just updated or added. If the DataSource contains [primary key fields](classes/DataSource.md#method-datasourcegetprimarykeyfields) of type `sequence`, the framework will first attempt to obtain values for those fields - see [sequenceMode](#type-sequencemode).

This is the most complete and foolproof way to get cache sync data, because we pick up any changes to the record that were applied by the persistence layer - for example database default values, values applied by database triggers or transformations applied to the record we sent by a remote REST service or legacy program call. However, it is also the least performant, since it involves a full refetch of the data. This is the default strategy for [SQL DataSources](kb_topics/sqlDataSource.md#kb-topic-sql-datasources) and [custom DataSources](kb_topics/writeCustomDataSource.md#kb-topic-custom-server-datasources). It is also the strategy used for [Hibernate](kb_topics/hibernateIntegration.md#kb-topic-integration-with-hibernate) and [JPA](kb_topics/jpaIntegration.md#kb-topic-integration-with-jpa) DataSources, though for these two, it is implemented inherently by the ORM system and you should not attempt to change it. See the [cache synchronization overview](kb_topics/cacheSynchronization.md#kb-topic-automatic-cache-synchronization) for details |
| "requestValuesPlusSequences" | Obtain cache sync values by merging the request values on top of the request's [oldValues](classes/DSRequest.md#attr-dsrequestoldvalues). If the DataSource contains [primary key fields](classes/DataSource.md#method-datasourcegetprimarykeyfields) of type `sequence`, the framework will then attempt to obtain values for those fields - see [sequenceMode](#type-sequencemode) - and merge those values into the cache sync data as well. This strategy avoids a data refetch, which may be a significant performance gain (though please see the note in the `sequenceMode` documentation regarding Oracle as a special case in this regard). Despite the name, this strategy is also suitable and effective for situations where your keys are not sequences - for example, when they are GUIDs or when they are user-entered codes. In this case, we simply do not attempt to resolve sequence values, and since the key values are already included in the request values, everything works

Note, if no `oldValues` are available and the updated record is [incomplete](classes/DataSource.md#attr-datasourcesparseupdates), or if the combination of `oldValues` and values is missing a value for a [required field](classes/DataSourceField.md#attr-datasourcefieldrequired) for any other reason, this strategy will return incomplete cache sync data. For details of what we do in these circumstances, see the "CacheSyncStrategy" section of the [cache synchronization overview](kb_topics/cacheSynchronization.md#kb-topic-automatic-cache-synchronization) |
| "responseValues" | This strategy simply returns the data returned by the add or update operation, as the cache sync data. This only makes sense for `DataSource` types that return a value for an update operation. This may include generic DataSources and `RestConnector`s, depending entirely on what the implementation returns. It specifically does not include [SQL DataSources](kb_topics/sqlDataSource.md#kb-topic-sql-datasources), because SQL/JDBC update operations do not return a value (other than the number of affected records).

This is the default strategy for [RestConnector](kb_topics/serverRestConnector.md#kb-topic-server-side-rest-connector)s, because it was the default way we did cache sync for that DataSource type before `CacheSyncStrategy` was introduced (and also because it is the ideal strategy for REST services that return the record-as-updated). See [DataSource.cacheSyncStrategy](classes/DataSource.md#attr-datasourcecachesyncstrategy) for details of how to change the default strategy for a given dataSource type. |
| "none" | This strategy does not attempt to derive cache sync data at all. No response data is sent back to the caller, and the response is marked for [cache invalidation](classes/DSResponse.md#attr-dsresponseinvalidatecache) |

### See Also

- [cacheSynchronization](kb_topics/cacheSynchronization.md#kb-topic-automatic-cache-synchronization)

---
## Type: CacheSyncTiming

### Description
Indicates the timing strategy to be used for [automatic cache synchronization](kb_topics/cacheSynchronization.md#kb-topic-automatic-cache-synchronization), for a given [DataSource](classes/DataSource.md#attr-datasourcecachesynctiming), [OperationBinding](classes/OperationBinding.md#attr-operationbindingcachesynctiming) or [DSRequest](classes/DSRequest.md#attr-dsrequestcachesynctiming). This property controls the "when" of cache synchronization; the "how" is controlled by [CacheSyncStrategy](reference_2.md#type-cachesyncstrategy).

**NOTE:** `CacheSyncTiming` is intended to allow applications to defer cache synchronization to the point where response data is actually requested; the primary aim of this is to avoid doing cache sync altogether in cases where the response data is never requested. There are some mainstream types of request where we know that the response data unequivocally _is_ required, and for these requests a global default `CacheSyncTiming` will be overridden to "immediate" by SmartClient because there is no point in deferring cache sync when we know for sure it will eventually be needed. Thus, cache sync will always run immediately regardless of the default `cacheSyncTiming` setting in these cases:

*   Requests sent from a client
*   Server-created requests that copy an `RPCManager` across from a client-originated request, either by specifying it in the `DSRequest` constructor, or by calling `dsRequest.setRPCManager()`

The above only applies to the global default `cacheSyncTiming`: a `cacheSyncTiming` set explicitly at the [DataSource](classes/DataSource.md#attr-datasourcecachesynctiming), [operation](classes/OperationBinding.md#attr-operationbindingcachesynctiming) or [request](classes/DSRequest.md#attr-dsrequestcachesynctiming) level will usually be honored. However, even an explicit `cacheSyncTiming` setting on the DataSource, operation or request will be ignored in situations where it could break a framework feature if we honored it. These situations are:

*   Requests where [automatic auditing](classes/DataSource.md#attr-datasourceaudit) is in force
*   Requests on a dataSource with one-to-many or many-to-many relations, where the update means that SmartClient must update foreign keys on the related dataSources to maintain relation integrity

In both these cases, we cannot allow the cache sync to be deferred because it is possible that a deferred cache sync fetch would never be invoked - indeed, that is the whole point of allowing cache sync to be deferred - and in that case, key processes would fail to run.

### Values

| Value | Description |
|-------|-------------|
| "immediate" | Obtain cache sync values immediately after the update operation returns |
| "lazy" | Defer running cache sync until the first time `getData()` is called on the server-side `DSResponse`. As described above, the point of deferring cache sync is to avoid running it at all in cases where nothing needs the response data (and thus nothing calls `getData()`). In addition to the above-listed cases where we know that cache sync is _always_ going to be required, there are other cases where `getData()` will be called, even if your application code doesn't do so. Some examples:

*   If logging levels are set such that the framework is logging response data
*   If you have a [multiple](classes/DataSourceField.md#attr-datasourcefieldmultiple) field in your dataSource and its value requires transformation because of [multipleStorage](classes/DataSourceField.md#attr-datasourcefieldmultiplestorage) or [transformMultipleFields](classes/DataSource.md#attr-datasourcetransformmultiplefields) settings

In these cases, and others where the response data is required, the cache sync process will be deferred to later in the process, but it will run. |

### See Also

- [cacheSynchronization](kb_topics/cacheSynchronization.md#kb-topic-automatic-cache-synchronization)

---
## Type: CellRecordMode

### Description
When [canSelectCells](classes/ListGrid_1.md#attr-listgridcanselectcells) is true, whether [getSelection()](classes/ListGrid_2.md#method-listgridgetselection) on a [DataBoundComponent](#interface-databoundcomponent) or individual [CellSelection](classes/CellSelection.md#class-cellselection) should return one record per selected cell, as with [CubeGrid](classes/CubeGrid.md#class-cubegrid), or one record per row that has any selected cells, as with [ListGrid](classes/ListGrid_1.md#class-listgrid).

### Values

| Value | Description |
|-------|-------------|
| "cell" | getSelection returns one record for each selected cell via [getCellRecord()](classes/ListGrid_2.md#method-listgridgetcellrecord) |
| "row" | getSelection returns distinct records for each row with one or more selected cells |

### Groups

- selection

---
## Type: ClientUniquenessCheckCondition

### Description
For a validator of type `isUnique` in a component listing multiple records such as a ListGrid, can we use the component's fetched data set to check for uniqueness? Used by [Validator.checkComponentData](classes/Validator.md#attr-validatorcheckcomponentdata).

It is possible to check for uniqueness against a ListGrid's data set and "shortcut" the validation process in a couple of cases:

*   If the grid has a complete data set from the DataSource, we can determine whether a record is unique or not by examining that data without ever querying the DataSource.
*   Even if the grid is only displaying a partial data set from the DataSource, if the user-entered value collides with another loaded record's value, we can assert that the value is **not** unique.  
    However, if the data set is not complete we can only shortcut validation when we find a collision. If we don't find a loaded record with a matching value, the DataSource will still need to be queried to definitively determine whether the value is unique.

Note that component data will **only** be consulted if the component is bound to a dataSource and has its data object set to a [ResultSet](classes/ResultSet.md#class-resultset). Additionally, with the exception of the special `"forceBoth"` setting, component data will only be used to determine uniqueness if the following conditions are met:

*   The default fetch operation was used (e.g listGrid.fetchOperation has not been set)
*   The data object was automatically created by the component [while fetching data](classes/ListGrid_2.md#method-listgridfetchdata), as opposed to manually instantiated by the application developer. This is because with a hand-created ResultSet, you could provide any set of records you want, so we don't know if they are an exact match for the default fetch operation on the DataSource.

Also note that, as with any validator understood by the server, uniqueness checking will always be enforced on the server as part of a save operation once data is committed.  
The `checkComponentData` setting simply allows developers to optimize performance by catching duplicate values on the client before the save operation is sent to the server, or avoid hitting the server at all during [validation without saving](classes/DynamicForm.md#method-dynamicformvalidate) in cases where this is possible.

### Values

| Value | Description |
|-------|-------------|
| "none" | Never consult cached component data. Uniqueness checking will be performed directly against the dataSource data set only. |
| "earlyFailOnly" | If the component has a partial or complete data cache that meets the conditions outlined above, check for another existing record in the cache with an identical field value. If one is found, the validator will fail on the client. If no match is found, standard validation will proceed against the dataSource's full data set. |
| "both" | If the component has a [complete data cache](classes/ResultSet.md#method-resultsetallrowscached) that meets the conditions outlined above, uniqueness checking will be performed against this data set only rather than querying the dataSource to check for uniqueness. |
| "forceBoth" | _\[Advanced Setting\]_ As with `checkComponentData:"both"`, if a component has a [complete data cache](classes/ResultSet.md#method-resultsetallrowscached), uniqueness checking will be peformed against this data set instead of querying the dataSource. However unlike `checkComponentData:"both"`, the `"forceBoth"` setting enables this behavior even if the component's data object has a custom fetch operation specified, or was created explicitly by application code instead of being automatically created as part of the standard `fetchData()` flow. |

---
## Type: ConnectorOrientation

### Description
Supported styles of connector orientations.

### Values

| Value | Description |
|-------|-------------|
| "horizontal" | Tail segments are always horizontal; best for left-to-right connectors |
| "vertical" | Tail segments are always vertical; best for top-to-bottom connectors |
| "auto" | Tail segments flip orientation according to longer axis of bounding box: if the bounding box is wider than it is tall, center segment is vertical |

### Groups

- line

---
## Type: ConnectorStyle

### Description
Supported styles of connector styles.

### Values

| Value | Description |
|-------|-------------|
| "diagonal" | Center segment is drawn diagonally between tail connector segments |
| "rightAngle" | Center segment is drawn perpendicular to tail connector segments |

### Groups

- line

---
## Type: Constant

### Description
A string used to define the value of a class attribute when it's referenced as one of the potential values of an enum type. For example, one documented value of [Overflow](#type-overflow) is [Canvas.HIDDEN](classes/Canvas.md#classattr-canvashidden), which is itself a class attribute with type `Constant` and the value "hidden".

---
## Type: ContentsType

### Description
What type of content is being displayed within the [HTMLFlow](classes/HTMLFlow.md#class-htmlflow)? This content may come from the [contentsURL](classes/HTMLFlow.md#attr-htmlflowcontentsurl) or be directly specified as [HTMLFlow.contents](classes/HTMLFlow.md#attr-htmlflowcontents).

### Values

| Value | Description |
|-------|-------------|
| "page" | The HTML content is treated as a standalone document and displayed in an isolated context using an IFRAME. |
| "fragment" | The HTML content is treated as a snippet designed to integrate into the main page and is directly inserted into the DOM. |

### See Also

- [HTMLFlow.contentsType](classes/HTMLFlow.md#attr-htmlflowcontentstype)

---
## Type: Criteria

### Description
Criteria for selecting only a matching set of records from a DataSource. Criteria can be applied on the client and server. Unless configured otherwise, criteria will generally be applied client-side by [ResultSet](classes/ResultSet.md#class-resultset)s via [ResultSet.applyFilter](classes/ResultSet.md#method-resultsetapplyfilter).

Client- and server-side systems built into SmartClient understand two criteria formats by default: simple key-value pairs (Criteria) or the [AdvancedCriteria](#object-advancedcriteria) format.

Simple key-value Criteria are represented via a JavaScript Object where each property specifies the name and required value for a field. Multiple legal values for a field can be provided as an Array. For example:

```
 var criteria = {
    field1 : "value1",
    field2 : ["value2", "value3"]
 }
 
```
Would select all records where field1 has value "value1" and where field2 has _either_ "value2" or "value3".

Use [DataSource.combineCriteria](classes/DataSource.md#classmethod-datasourcecombinecriteria) to combine two Criteria objects (including Criteria and AdvancedCriteria) or [DataSource.convertCriteria](classes/DataSource.md#classmethod-datasourceconvertcriteria) to convert simple Criteria to the AdvancedCriteria format.

When writing custom client and server-side filtering logic, criteria must be a JavaScript Object but the properties of that Object can contain whatever data you want. When sent to the SmartClient server, the Java representation of the criteria is described [here](classes/RPCRequest.md#attr-rpcrequestdata). When sent to other servers, the [operationBinding.dataProtocol](reference_2.md#type-dsprotocol) affects the format.

### See Also

- [CriteriaPolicy](reference_2.md#type-criteriapolicy)

---
## Type: CriteriaCombineOperator

### Description
The logical operator to use when combining criteria objects with the [DataSource.combineCriteria](classes/DataSource.md#classmethod-datasourcecombinecriteria) method.

### Values

| Value | Description |
|-------|-------------|
| "and" | — |
| "or" | — |

---
## Type: CriteriaPolicy

### Description
—

### Values

| Value | Description |
|-------|-------------|
| "dropOnChange" | Cache is dropped whenever criteria changes. |
| "dropOnShortening" | Cache is retained as long as the only changes to criteria make the criteria more restrictive as determined by [ResultSet.compareCriteria](classes/ResultSet.md#method-resultsetcomparecriteria). |

---
## Type: CSSColor

### Description
CSS color specification applied to a specific HTML element on this page.

This is a string matching the syntax as specified in CSS1, and can be formatted in one of the following ways:

*   A keyword color, “white”
*   Six-digit hex notation, “#ffffff”
*   Three-digit hex notation, “#fff”
*   8-bit decimal notation, “rgb(255, 255, 255)”
*   Percentage notation, “rgb(100%, 100%, 100%)”

Note that when working with [FacetChart](classes/FacetChart.md#class-facetchart)s, it's required that colors be specified using the six-digit hex format listed above, rather than any of the others, since the Framework needs to perform math on the subfields. Affected properties include [FacetChart.dataColors](classes/FacetChart.md#attr-facetchartdatacolors), and affected methods include overrides of [FacetChart.getDataColor](classes/FacetChart.md#method-facetchartgetdatacolor) and [FacetChart.getDataLineColor](classes/FacetChart.md#method-facetchartgetdatalinecolor).

### Groups

- appearance

---
## Type: CSSText

### Description
A String of CSS that can be added directly to a `style` attribute.

---
## Type: DataLineType

### Description
Algorithms for drawing lines between points.

### Values

| Value | Description |
|-------|-------------|
| "straight" | simple straight lines between points that are adjacent in the dataset |
| "smooth" | smooth spline curve between points that are adjacent in the dataset |

---
## Type: DataPath

### Description
String specifying a nested data field structure.

**NOTE: the dataPath feature is intended to help certain legacy architectures, such as systems that work in terms of exchanging large messages with several different entity types in one message, and are incapable of providing separate access to each entity type. Don't use dataPath if this is not your situation.**

_If you are not forced by legacy issues to use hierarchical data structures, we recommend:_

_*   If a subobject exists just to bundle several related fields together, and is not a separate entity (cannot be separately created or separately referenced by other objects), "flatten" the fields using features such as [DataSourceField.valueXPath](classes/DataSourceField.md#attr-datasourcefieldvaluexpath).
*   If a subobject is actually a separate entity, make a DataSource for it and use operations on that DataSource to load and modify it.
    
    For example, when representing a sales order with a "deliveryAddress" (consisting of multiple fields), you'd typically want an "orders" dataSource to define the fields for the order as a whole, and an "address" dataSource to define the structure of the deliveryAddress object.
    
    It may seem like a good idea to work with a single hierarchical order object, where the "deliveryAddress" attribute is set to a sub-object that matches the structure defined in the "address" dataSource. DataPaths could be used to extract individual address fields for editing in a form alongside other fields from the order, and edits would be saved via a simple "add" or "update" operation, passing in the modified nested data object.
    
    In fact, this has a number of disadvantages. Since there is no call to the "update" operation on the "address" subobject, the address will be modified without the normal features of a dataSource update. You can't specify [security rules](classes/DataSource.md#attr-datasourcerequiresauthentication), [DMI](kb_topics/dmiOverview.md#kb-topic-direct-method-invocation) logic, [request modifiers](reference_2.md#object-dsrequestmodifier), and no logging or [auditing](classes/DataSource.md#attr-datasourceaudit) will run.  
    The same "bypassing" problem occurs, in perhaps worse form, if a subobject does not yet exist and the framework creates it automatically, skipping a DataSource "add" operation that may have established defaults, not been allowed for the user, etc.
    
    Loading and saving nested data objects as a single hierarchical block also offers no advantages in terms of performance or simplicity.  
    The [queuing](classes/RPCManager.md#classmethod-rpcmanagerstartqueue) system makes it extremely easy to load and save multiple types of entities in a single HTTP request, and takes far less code to implement properly as multiple DataSource operations, with equivalent or better performance.
    
    Loading arrays of related objects (such as all LineItems in an Order) as a hierarchical object has the further drawback that paging cannot be used for the list of related objects, and all such objects will not participate in [automatic cache synchronization](classes/ResultSet.md#class-resultset).
    _

_In short, we do not recommend structuring your data as a hierarchy of nested data objects and using dataPath to navigate these structures unless you are forced to by a legacy system that doesn't allow separate operations on each entity type._

**How to use dataPaths**

Each dataPath string is a slash-delimited set of field identifiers, for example `"id1/id2/id3"`. DataPaths may be applied directly to a [component](classes/Canvas.md#attr-canvasdatapath), and/or to a databound component field specification. A datapath denotes a path to a nested field value in a hierarchical structure, giving developers the opportunity to easily view or edit nested data structures. Specifically:

*   if the component is viewing or editing a record, the value for fields will be derived from a nested structure of records
*   if the component is bound to a dataSource, field attributes may be picked up by following the dataPath to a field definition on another dataSource

**Examples:**  
If a dynamicForm is defined with the following fields:
```
    [
      { name:"name" },
      { name:"street", dataPath:"address/street" }
    ]
 
```
If the `"name"` field is set to _"Joe Smith"_ and the `"street"` field is set to _"1221 High Street"_, when the values for this form are retrieved via a `getValues()` call they will return an object in the following format:
```
    {name:"Joe Smith", address:{street:"1221 High Street"}}
 
```

For databound components, dataPath also provides a way to pick up field attributes from nested dataSources. Given the following dataSource definitions:

```
  isc.DataSource.create({
      ID:"contacts",
      fields:[
          {name:"name"},
          {name:"email"},
          {name:"organization"},
          {name:"phone"},
          {name:"address", type:"Address"}
      ]
  });
 
  isc.DataSource.create({
      ID:"Address",
      fields:[
          {name:"street"},
          {name:"city"},
          {name:"state"},
          {name:"zip"}
      ]
  });
  
```
and a databound component bound to the 'contacts' dataSource, specifying a field with a dataPath of `"address/street"` would ensure the field attributes were derived from the "street" field of the 'Address' dataSource.

dataPaths are also cumulative. In other words if a component has a specified dataPath, the dataPath of any fields it contains will be appended to that component level path when accessing data. For example the following form:

```
 isc.DynamicForm.create({
     dataPath:"contact",
     fields:[
          {dataPath:"address/email"}
     ]
 });
 
```
Might be used to edit a data structure similar to this:
```
{contact:{name:'Ed Jones', address:{state:"CA", email:"ed@ed.jones.com"}}}
```
Nested canvases can also have dataPaths specified, which will similarly be combined. See the [Canvas.dataPath](classes/Canvas.md#attr-canvasdatapath) attribute for more information and examples of this.

### See Also

- [Canvas.ruleScope](classes/Canvas.md#attr-canvasrulescope)

---
## Type: DataSourceTemplateReferenceMode

### Description
Indicates the mode to use for resolving templated references in a DataSource's configuration file. See [DataSource.allowTemplateReferences](classes/DataSource.md#attr-datasourceallowtemplatereferences) for an overview of configuration templating.

### Values

| Value | Description |
|-------|-------------|
| "none" | Indicates that no resolution of templated references should be done |
| "configOnly" | Indicates that a simple find-and-replace process should resolve templated references. In this mode, the system looks for references strictly like the one below, and replaces them with the referenced property from your `server.properties` file. So if your `server.properties` file contained an entry like this:
```
     database.name: MyDatabase
 
```
the below example would cause `dbName` to be resolved as `MyDatabase`
```
     dbName="$config['database.name']"
 
```
(Note, you can use a different token than "`$config`" if you need to - see [templateConfigToken](classes/DataSource.md#attr-datasourcetemplateconfigtoken)) |
| "all" | Indicates that full Velocity processing will be used to resolve templated references. This allows you to use all of Velocity's template-handling features - for example, conditional blocks and iteration - and so is more powerful than the simple "configOnly" option above. Note, however, that this templating is necessarily limited by the fact that it takes place during DataSource initialization, when there is not a lot of context available for templating purposes - you have the "`$config`" object, as with "configOnly", and some of the other variables listed in the [Velocity overview](kb_topics/velocitySupport.md#kb-topic-velocity-context-variables), but nothing relating to [DSRequest](reference_2.md#object-dsrequest)s |

### See Also

- [DataSource.templateConfigToken](classes/DataSource.md#attr-datasourcetemplateconfigtoken)

---
## Type: DateFieldLayout

### Description
The direction in which an item should lay out it's fields.

### Values

| Value | Description |
|-------|-------------|
| "horizontal" | fields are placed horizontally |
| "vertical" | fields are placed vertically |

---
## Type: DateItemSelectorFormat

### Description
Order of pickers and which pickers are present when using a DateItem with [DateItem.useTextField](classes/DateItem.md#attr-dateitemusetextfield) false.

### Values

| Value | Description |
|-------|-------------|
| DateItem.DAY_MONTH_YEAR | Output fields in day, month, year order. |
| DateItem.MONTH_DAY_YEAR | Output fields in month, day, year order. |
| DateItem.YEAR_MONTH_DAY | Output fields in year, month, day order. |
| DateItem.DAY_MONTH | Output only day, month fields. |
| DateItem.MONTH_DAY | Output only month, day fields. |
| DateItem.YEAR_MONTH | Output only year, month fields. |
| DateItem.MONTH_YEAR | Output only month, year fields. |

---
## Type: DefaultSampleRecord

### Description
Some interfaces, for example the [FieldPicker](classes/FieldPicker.md#class-fieldpicker) and [HiliteEditor](classes/HiliteEditor.md#class-hiliteeditor) widgets, can use data from an associated DataBoundComponent to express live sample values at runtime.

### Values

| Value | Description |
|-------|-------------|
| "first" | Uses the first record in the DataBoundComponent as sample data |
| "firstOpenLeaf" | Uses the first open leaf-node in the DataBoundComponent as sample data |

---
## Type: Direction

### Description
—

### Values

| Value | Description |
|-------|-------------|
| Canvas.UP | above |
| Canvas.DOWN | below |
| Canvas.LEFT | to the left of |
| Canvas.RIGHT | to the right of |

### Groups

- appearance

---
## Type: DisplayNodeType

### Description
Flag passed to functions as displayNodeType, telling the function whether it should work on folders, leaves or both at once.

### Values

| Value | Description |
|-------|-------------|
| null/unset | operate on both folders and leaves |
| "folders" | operate on folders only, ignoring leaves |
| "leaves" | operate on leaves only, ignoring folders |

### Groups

- ancestry

---
## Type: DragAppearance

### Description
Different types of effects for showing dragging behavior.

### Values

| Value | Description |
|-------|-------------|
| "none" | No default drag appearance is indicated. Your custom dragging routines should implement some behavior that indicates that the user is in a dragging situation, and where the mouse is. |
| "tracker" | A "drag tracker" object is automatically shown and moved around with the mouse. This is generally set to an icon that represents what is being dragged. The default tracker is a 10 pixel black square, but you can customize this icon. This dragAppearance is not recommended for use with drag resizing or drag moving. |
| "target" | The target object is actually moved, resized, etc. in real time. This is recommended for drag repositioning, but not for drag resizing of complex objects. |
| "outline" | An outline the size of the target object is moved, resized, etc. with the mouse. This is recommended for drag resizing, especially for objects that take a significant amount of time to draw. |

### Groups

- dragdrop

---
## Type: DrawPosition

### Description
—

### Values

| Value | Description |
|-------|-------------|
| "beforeBegin" | insert before the target element |
| "afterBegin" | insert as the target element's first child |
| "beforeEnd" | insert as the target element's last child |
| "afterEnd" | insert after the target element |
| "replace" | replace the target element |

---
## Type: DSCallback

### Description
A [Callback](#type-callback) to evaluate when a DataSource request completes.

The parameters available in the DSCallback expression are:

*   dsResponse: a [DSResponse](classes/DSResponse.md#class-dsresponse) instance with metadata about the returned data
*   data: data returned to satisfy the DataSource request. See the [DataSource operations](kb_topics/dataSourceOperations.md#kb-topic-datasource-operations) topic for expected results for each type of DataSource operation
*   dsRequest: the [DSRequest](reference_2.md#object-dsrequest) that was sent. You can use [DSRequest.clientContext](classes/DSRequest.md#attr-dsrequestclientcontext) to track state during the server turnaround.

For example, if you had a DynamicForm with ID "myForm" and you wanted to retrieve a record from a DataSource "myUsers", where each record has a "userId" field:
```
     myUsers.fetchData({ userId : "fred" }, "myForm.setValues(data)");
 
```
or
```
     myUsers.fetchData({ userId : "fred" }, function (dsResponse, data, dsRequest) {
                                              myForm.setValues(data);
                                            });
 
```

Note that if the request encounters a low-level error (such as 500 server error), by default the callback will **not** be fired, instead, [DataSource.handleError](classes/DataSource.md#method-datasourcehandleerror) is called to invoke the default system-wide error handling. Set [willHandleError](classes/RPCRequest.md#attr-rpcrequestwillhandleerror):true to have your callback invoked regardless of whether there are errors, however, make sure your callback properly handles malformed responses when [DSResponse.status](classes/DSResponse.md#attr-dsresponsestatus) is non-zero.

---
## Type: DSDataFormat

### Description
Indicates the format to be used for HTTP requests and responses when fulfilling DSRequests (eg, when [DataSource.fetchData](classes/DataSource.md#method-datasourcefetchdata) is called).

Note that [request queuing](classes/RPCManager.md#classmethod-rpcmanagerstartqueue) is only available for "iscServer" requests.

### Values

| Value | Description |
|-------|-------------|
| "iscServer" | Make an HTTP request in a format recognized by the ISC server and expect ISC server response format. [Server-side integration](kb_topics/serverDataIntegration.md#kb-topic-server-datasource-integration) can then be used to connect to any kind of data store or web service. |
| "xml" | Expect XML responses. Request format depends on the setting for [protocol](classes/OperationBinding.md#attr-operationbindingdataprotocol). This is the correct setting when consuming RSS feeds, XML web services (whether SOAP, REST, XML-RPC or custom format), and XML flat files directly from the browser.

Values for "date", "time" or "datetime" fields in responses should be specified in the applicable [XML Schema date format](http://www.w3.org/TR/xmlschema-2/#dateTime). If no timezone is explicitly specified, dates / datetimes received by the client are assumed to be GMT. Note that "date" type fields represent logical dates and may omit time information entirely, and "time" type fields may omit date information. See [Date and Time Format and storage](kb_topics/dateFormatAndStorage.md#kb-topic-date-and-time-format-and-storage) for more information on how date values are serialized in requests sent to the server.

A DSResponse will be derived from the returned XML via the process described under [DataSource.transformResponse](classes/DataSource.md#method-datasourcetransformresponse). |
| "json" | Expect response in JSON [(Java Script Object Notation)](http://json.org) format, ready to be eval()'d. Response should either be a naked object literal:
```
     { "property":"value1", "property2" : "value2", ... }
 
```
or a string that evals to return a valid response object:
```
     var response = { "property":"value1", "property2" : "value2", ... }
     response;
 
```

A DSResponse will be derived from the returned JSON via the process described under [DataSource.transformResponse](classes/DataSource.md#method-datasourcetransformresponse).

As with `"xml"` responses, values for "date" or "datetime" fields should be specified as a String in [XML Schema date format](http://www.w3.org/TR/xmlschema-2/#dateTime) and may include a timezone. In the absence of a timezone they will be assumed to be GMT.

Request format depends on the setting for [protocol](classes/OperationBinding.md#attr-operationbindingdataprotocol). See also [XJSONDataSource](classes/XJSONDataSource.md#class-xjsondatasource). |
| "custom" | SmartClient will not attempt to parse the response, instead, [DataSource.transformResponse](classes/DataSource.md#method-datasourcetransformresponse) must be implemented. `transformResponse` will receive the "data" parameter as a String, and must parse this String into an Array of Objects, which should be set as [DSResponse.data](classes/DSResponse.md#attr-dsresponsedata). Request format depends on the setting for [protocol](classes/OperationBinding.md#attr-operationbindingdataprotocol).

Note that, unlike either the "json" or "xml" settings of `dataFormat`, you are responsible for ensuring that parsed values are the correct type, for example, using the JavaScript built-ins `parseInt` and `parseFloat` on integer and decimal values respectively, and using `new Date()` to construct valid Dates. |

### Groups

- clientDataIntegration
- serverDataIntegration

---
## Type: DSProtocol

### Description
[OperationBinding.dataProtocol](classes/OperationBinding.md#attr-operationbindingdataprotocol) affects how the data in the DSRequest ([DSRequest.data](classes/DSRequest.md#attr-dsrequestdata)) is sent to the [DataSource.dataURL](classes/DataSource.md#attr-datasourcedataurl). Listed below are the valid values for [OperationBinding.dataProtocol](classes/OperationBinding.md#attr-operationbindingdataprotocol) and their behavior.

Note that, when using the SmartClient server, data is automatically translated from JavaScript to Java according to the rules described [here](classes/RPCRequest.md#attr-rpcrequestdata); dataProtocol does not apply and is ignored.

If you are integrating with a [REST](classes/RestDataSource.md#class-restdatasource) server that requires the more obscure [RPCRequest.httpMethod](classes/RPCRequest.md#attr-rpcrequesthttpmethod)s of "PUT", "DELETE" or "HEAD", you can specify these httpMethod settings via [OperationBinding.requestProperties](classes/OperationBinding.md#attr-operationbindingrequestproperties). dataProtocol settings that mention "GET" or "POST" are compatible with these additional HTTP methods as well. Typical [operationBindings](classes/DataSource.md#attr-datasourceoperationbindings) for a REST server that uses "PUT" and "DELETE" are as follows:

```
    operationBindings:[
       {operationType:"fetch", dataProtocol:"getParams"},
       {operationType:"add", dataProtocol:"postParams"},
       {operationType:"remove", dataProtocol:"getParams", requestProperties:{httpMethod:"DELETE"}},
       {operationType:"update", dataProtocol:"postParams", requestProperties:{httpMethod:"PUT"}}
    ],
 
```

### Values

| Value | Description |
|-------|-------------|
| "getParams" | Data is added to the dataURL, with each property in the data becoming an HTTP parameter, eg http://service.com/search?keyword=foo |
| "postParams" | Data is POST'd to the dataURL, with each property becoming an HTTP parameter, exactly as an HTML form would submit them if it had one input field per property in the data. |
| "postJSON" | Data is serialized as a JSON string and POST'd to the dataURL. |
| "postXML" | Data is serialized as XML via [DataSource.xmlSerialize](classes/DataSource.md#method-datasourcexmlserialize) and POST'd as the HTTP request body with contentType "text/xml". |
| "soap" | Data is serialized as XML via [DataSource.xmlSerialize](classes/DataSource.md#method-datasourcexmlserialize), wrapped in a SOAP envelope, and POST'd as the HTTP request body with contentType "text/xml". Generally only used in connection with a [WSDL web service](kb_topics/wsdlBinding.md#kb-topic-wsdl-binding). |
| "postMessage" | dsRequest.data is assumed to be a String set up by [DataSource.transformRequest](classes/DataSource.md#method-datasourcetransformrequest) and is POST'd as the HTTP request body. |
| "clientCustom" | This setting entirely bypasses the SmartClient comm system. Instead of the DataSource sending an HTTP request to a URL, the developer is expected to implement [DataSource.transformRequest](classes/DataSource.md#method-datasourcetransformrequest) to perform their own custom logic, and then call [DataSource.processResponse](classes/DataSource.md#method-datasourceprocessresponse) to handle the results of this action. This `dataProtocol` setting can be used to implement access to in-browser resources such as HTML5 "localStorage", native APIs available to applications [packaged as native applications](kb_topics/mobileDevelopment.md#kb-topic-mobile-application-development), or to implement the [DataSource Facade pattern](kb_topics/dsFacade.md#kb-topic-datasource-facade-pattern). |

### Groups

- clientDataIntegration

### See Also

- [OperationBinding.dataProtocol](classes/OperationBinding.md#attr-operationbindingdataprotocol)

---
## Type: DSServerType

### Description
Indicates what SmartClient Server will do with a DataSource request if you call dsRequest.execute() in server code.

If you use a Java-based persistence layer not provided by SmartClient, such as EJB or your own custom object model, you don't need to set `dataSource.serverType` and should follow the [integration instructions](kb_topics/serverDataIntegration.md#kb-topic-server-datasource-integration).

### Values

| Value | Description |
|-------|-------------|
| "sql" | Use SmartClient's [built-in SQL connectors](kb_topics/sqlDataSource.md#kb-topic-sql-datasources) to talk directly to relational databases. |
| "hibernate" | Use Hibernate, either using a real mapped bean or by automatically generating a Hibernate configuration based on a SmartClient DataSource file (_dataSourceID_.ds.xml). See [hibernateIntegration](kb_topics/hibernateIntegration.md#kb-topic-integration-with-hibernate) for details. |
| "jpa" | Use SmartClient's built-in JPA 2.0 connector. |
| "jpa1" | Use SmartClient's built-in JPA 1.0 connector. |
| "rest" | Use SmartClient's built-in [RestConnector](kb_topics/serverRestConnector.md#kb-topic-server-side-rest-connector), which can connect to many different types of REST webservice |
| "odata" | Use SmartClient's built-in [OData DataSource](kb_topics/odataDataSource.md#kb-topic-server-side-odata-datasource). This is a specialized subclass of the `RestConnector` which adds functionality for REST webservices that follow the [OData protocol](https://www.odata.org/) |
| "generic" | Requests will be delivered to the server and you are expected to write Java code to create a valid response. Throws an error if the server side method dsRequest.execute() is called. This is appropriate if you intend an entirely custom implementation, and you want an error thrown if there is an attempt to call an operation you have not implemented. |
| "projectFile" | Requests will be delivered to the server and processed as [FileSource operations](kb_topics/fileSource.md#kb-topic-filesource-operations), using directories or other DataSources which you configure via [DataSource.projectFileKey](classes/DataSource.md#attr-datasourceprojectfilekey) or [DataSource.projectFileLocations](classes/DataSource.md#attr-datasourceprojectfilelocations) |
| "union" | Use SmartClient's built-in [unionDataSource](kb_topics/unionDataSource.md#kb-topic-union-datasources), which assimilates records from multiple member dataSources |

### Groups

- serverDataIntegration

---
## Type: DynamicString

### Description
A [dynamic string](kb_topics/dynamicStrings.md#kb-topic-dynamic-strings).

### Groups

- dynamicStrings

---
## Type: EditCompletionEvent

### Description
What event / user interaction type caused cell editing to complete.

### Values

| Value | Description |
|-------|-------------|
| ListGrid.CLICK_OUTSIDE | User clicked outside editor during edit. |
| ListGrid.CLICK | User started editing another row by clicking on it |
| ListGrid.DOUBLE_CLICK | User started editing another row by double clicking |
| ListGrid.ENTER_KEYPRESS | Enter pressed. |
| ListGrid.ESCAPE_KEYPRESS | User pressed Escape. |
| ListGrid.UP_ARROW_KEYPRESS | Up arrow key pressed. |
| ListGrid.DOWN_ARROW_KEYPRESS | down arrow key. |
| ListGrid.TAB_KEYPRESS | User pressed Tab. |
| ListGrid.SHIFT_TAB_KEYPRESS | User pressed Shift+Tab. |
| ListGrid.EDIT_FIELD_CHANGE | Edit moved to a different field (same row) |
| ListGrid.PROGRAMMATIC | Edit completed via explicit function call |

### Groups

- editing

---
## Type: ElementWaitStyle

### Description
How should [AutoTest.waitForElement](classes/AutoTest.md#classmethod-autotestwaitforelement) determine that the application is ready to retrieve the element?

Note: In most cases `"system"` is the appropriate setting. This will wait for standard SmartClient-initiated asychronous actions to complete, including timer-instantiated actions such as [delayed redraws](classes/Canvas.md#method-canvasmarkforredraw) or actions configured through the [Timer class](classes/Timer.md#class-timer), and oustanding [RPC Requests](classes/RPCManager.md#class-rpcmanager). If the locator cannot be resolved to a clickable element after system quiescence, this usually implies that it will not ever resolve, and there's no need to wait for the timeout to complete and slow down your test suite.

The only time you'd want to use `"element"` would be if your application relies on some asynchronous event that isn't tracked by the SmartClient system. Examples might include waiting for asynchronous actions instantiated by a third-party tool on the page, or waiting for a server notification to come in through the [RealtimeMessaging](kb_topics/messaging.md#kb-topic-real-time-messaging) system.

### Values

| Value | Description |
|-------|-------------|
| "system" | use [AutoTest.waitForSystemDone](classes/AutoTest.md#classmethod-autotestwaitforsystemdone) to wait for actions to complete, then return the result of [AutoTest.getElement](classes/AutoTest.md#classmethod-autotestgetelement), even if this method doesn't resolve to an element. |
| "element" | wait until [AutoTest.getElement](classes/AutoTest.md#classmethod-autotestgetelement) resolves to an element, and the element is [clickable](classes/AutoTest.md#classmethod-autotestiselementclickable). |

---
## Type: EmbeddedPosition

### Description
How a component should be embedded within its record or cell

### Values

| Value | Description |
|-------|-------------|
| "expand" | component should be placed underneath normal record or cell content, expanding the records. Expanding records can result in variable height rows, in which case [virtualScrolling](classes/ListGrid_1.md#attr-listgridvirtualscrolling) should be enabled. |
| "within" | component should be placed within the normal area of the record or cell. Percentage sizes will be treated as percentages of the record and [Canvas.snapTo](classes/Canvas.md#attr-canvassnapto) positioning settings are also allowed and refer to the rectangle of the record or cell. Note that for components embedded within cells, cell align and vAlign will be used if snapTo is unset (so top / left alignment of cell content will map to snapTo of "TL", etc). |

---
## Type: Encoding

### Description
Form encoding types - these translate to Form ENCTYPE parameters.

### Values

| Value | Description |
|-------|-------------|
| DynamicForm.NORMAL | normal form encoding ("application/x-www-form-urlencoded") |
| DynamicForm.MULTIPART | form encoding for forms with INPUT file elements, that is, forms that upload files ("multipart/form-data") |

### Groups

- submitting

---
## Type: EnumTranslateStrategy

### Description
Determines how Java enums are translated to and from Javascript by the SmartClient server.

### Values

| Value | Description |
|-------|-------------|
| "name" | Translates to/from a String matching the constant name. This is the default if not set. |
| "string" | Translates to/from a String matching the `enum.toString()`. |
| "ordinal" | Translates to/from an integer matching the ordinal number of the constant within the enumeration |
| "bean" | Translates to/from a Javascript object containing one property for each property defined within the enum. The constant itself and the ordinal number are included in the JS object. By default they are called "\_constant" and "\_ordinal", but this can be overridden with the [DataSource.enumOrdinalProperty](classes/DataSource.md#attr-datasourceenumordinalproperty) and [DataSource.enumConstantProperty](classes/DataSource.md#attr-datasourceenumconstantproperty) properties |

### See Also

- [DataSource.enumTranslateStrategy](classes/DataSource.md#attr-datasourceenumtranslatestrategy)

---
## Type: ExpansionComponentPoolingMode

### Description
The method of pooling to employ for [expansionComponents](classes/ListGrid_1.md#attr-listgridcanexpandrecords).

### Values

| Value | Description |
|-------|-------------|
| "destroy" | auto-created, built-in components are destroyed when record are [collapsed](classes/ListGrid_2.md#method-listgridcollapserecord). |
| "none" | all expansion components are deparented from the grid when a record is [collapsed](classes/ListGrid_2.md#method-listgridcollapserecord) but are not destroyed. It is the responsibility of the developer to handle component destruction |

---
## Type: ExpansionMode

### Description
When [canExpandRecords](classes/ListGrid_1.md#attr-listgridcanexpandrecords) is true, ExpansionMode dictates the type of UI to be displayed in the expanded portion of the row.

There are a number of builtin ExpansionModes and you can override [getExpansionComponent()](classes/ListGrid_2.md#method-listgridgetexpansioncomponent) to create your own expansion behaviors.

### Values

| Value | Description |
|-------|-------------|
| "detailField" | Show a single field's value in an [HTMLFlow](classes/HTMLFlow.md#class-htmlflow). Field to use is [ListGrid.detailField](classes/ListGrid_1.md#attr-listgriddetailfield). |
| "details" | Show a [DetailViewer](classes/DetailViewer.md#class-detailviewer) displaying those fields from the record which are not already displayed in the grid. |
| "related" | Show a separate [ListGrid](classes/ListGrid_1.md#class-listgrid) containing related-records. See [ListGridRecord.detailDS](classes/ListGridRecord.md#attr-listgridrecorddetailds) and [ListGrid.recordDetailDSProperty](classes/ListGrid_1.md#attr-listgridrecorddetaildsproperty) for more information. |
| "editor" | Show a [DynamicForm](classes/DynamicForm.md#class-dynamicform) to edit those fields from the record which are not already present in the grid. If the record is collapsed with unsaved changes and [ListGrid.expansionEditorShowSaveDialog](classes/ListGrid_1.md#attr-listgridexpansioneditorshowsavedialog) is not set, Edits will be saved automatically, or stored as [editValues](kb_topics/editing.md#kb-topic-grid-editing) if [ListGrid.autoSaveEdits](classes/ListGrid_1.md#attr-listgridautosaveedits) is false. Otherwise, a confirmation dialog is displayed. Can optionally show a [save button](classes/ListGrid_1.md#attr-listgridshowexpansioneditorsavebutton) and [auto-collapse](classes/ListGrid_1.md#attr-listgridexpansioneditorcollapseonsave) when save is pressed. If a record fails validation on save and the field in question is not visible in the grid, the record is automatically expanded and validated to show the errors. |
| "detailRelated" | Show a [DetailViewer](classes/DetailViewer.md#class-detailviewer) displaying those fields from the record not already displayed in the grid, together with a separate [ListGrid](classes/ListGrid_1.md#class-listgrid) containing related-records. |

### Groups

- expansionField

---
## Type: ExportDisplay

### Description
Method to use for displaying the exported data.

### Values

| Value | Description |
|-------|-------------|
| "download" | Show the Save As dialog and download the file |
| "window" | Show the data in a new browser window |
| "return" | Return the data for further programmatic processing in the browser |

---
## Type: ExportFormat

### Description
One of the supported formats for data-export. If you are doing a [client export](classes/ListGrid_2.md#method-listgridexportclientdata) to one of the native spreadsheet formats (xls or ooxml), we also export [hilite-based](reference_2.md#object-hilite) coloring. So, if Hilites are causing a particular cell to be rendered as green text on a blue background, the corresponding cell in the exported spreadsheet document will also be colored that way.

### Values

| Value | Description |
|-------|-------------|
| "xml" | Export data as XML records |
| "json" | Export data as JSON objects. Not allowed as a client-side option. |
| "csv" | Export data in comma-separated format |
| "xls" | Export data in native Microsoft Excel 97 format |
| "ooxml" | Export data in native Microsoft Excel 2007 format (also called XLSX) |
| "custom" | Custom server-side logic will do the export |

---
## Type: ExportImageFormat

### Description
One of the supported formats for image export.

### Values

| Value | Description |
|-------|-------------|
| "png" | Export as PNG |
| "jpeg" | Export as JPEG |

---
## Type: FacetIndentDirection

### Description
Specifies the direction of facet indenting for a [hierarchical](classes/Facet.md#attr-facetistree) facet.

### Values

| Value | Description |
|-------|-------------|
| CubeGrid.DESCENDING | means the top of the hierarchy renders highest (column facet) or leftmost (row facet). For example, the text for the top of a column facet hierarchy will be flush to the top of the header with the hierarchy expanded. |
| CubeGrid.ASCENDING | means that the bottom of the hierarchy renders highest (column facet) or leftmost (row facet). |

### See Also

- [CubeGrid.vTreeFacetIndentDirection](classes/CubeGrid.md#attr-cubegridvtreefacetindentdirection)

---
## Type: FetchMode

### Description
Mode of fetching records from the server.

Generally, "paged" mode should be used unless the maximum number of records is guaranteed to be small.

### Values

| Value | Description |
|-------|-------------|
| "basic" | All records that match the current filter are fetched. Sorting is performed on the client. |
| "paged" | Only requested ranges of records are fetched, with predictive fetch ahead. Sorting is performed on the server. |
| "local" | All records available from the DataSource are fetched. Filtering by search criteria and sorting are both performed on the client. |

### Groups

- fetching

---
## Type: FieldAppearance

### Description
—

### Values

| Value | Description |
|-------|-------------|
| Validator.READONLY | Show in read-only appearance |
| Validator.HIDDEN | Hide field |
| Validator.DISABLED | Disable field |

---
## Type: FieldAuditMode

### Description
—

### Values

| Value | Description |
|-------|-------------|
| "always" | the field value will be saved for all audited adds and updates, regardless of whether it's changed or present in the update |
| "change" | the field value will be saved for all audited adds, and for updates in which the value changed |
| "never" | the field value will never be saved for any DataSource audit operation |

---
## Type: FieldImportStrategy

### Description
Options for how values in the import dataset (for example, the CSV file) are transformed during import if the field is a [foreignKey](classes/DataSourceField.md#attr-datasourcefieldforeignkey) mapped to a [displayField](classes/DataSourceField.md#attr-datasourcefielddisplayfield)

### Values

| Value | Description |
|-------|-------------|
| "key" | The import process expects values in the import dataset to be the real underlying key values, and performs no transformation |
| "display" | The import process expects values in the import dataset to be display values, and it will transform them to the corresponding underlying keys if found |
| "displayRequired" | Same as "display", but results in [validation error](classes/DataSourceField.md#attr-datasourcefieldimportstrategyfailederrormessage) if corresponding underlying keys were not found |
| "auto" | The import process will attempt to discover the best setting to use, based on the values in the first record, and use that setting for every remaining record in the import dataset |

### See Also

- [DataSourceField.importStrategy](classes/DataSourceField.md#attr-datasourcefieldimportstrategy)

---
## Type: FieldState

### Description
An object containing the stored presentation information for the fields of some dataBoundComponent. Information contained in a `FieldState` object includes the visibility and order of the component's fields.  
Note that this object is a JavaScript string, and may be stored (for example) as a blob on the server for state persistence across sessions.

### Groups

- viewState

---
## Type: FieldType

### Description
The types listed below are built-in types that [databound\\n components](#interface-databoundcomponent) understand and treat specially (using type-specific form controls, validators, formatters, sorting logic, etc).

You can declare custom types via [SimpleType.create()](classes/SimpleType.md#class-simpletype), with settings that will influence DataBound components. You can also create your own subclasses of databound components to add further custom, reusable behaviors based on field.type.

`field.type` can also be the ID of another [DataSource](classes/DataSource.md#class-datasource), which allows you to model nested structures such as XML documents (in fact, [XMLTools.loadXMLSchema](classes/XMLTools.md#classmethod-xmltoolsloadxmlschema) models XML schema in this way). Nested DataSource declarations affect how XML and JSON data is deserialized into JavaScript objects in the [client-side integration](kb_topics/clientDataIntegration.md#kb-topic-client-side-data-integration) pipeline, so that you can load complex XML documents and have them deserialized into a correctly typed nested data structure.

Note: to declare related but _separate_ objects, as in an "Account" object that can be related to both a "Contact" object and "Order" objects, use [DataSourceField.foreignKey](classes/DataSourceField.md#attr-datasourcefieldforeignkey), **not** a nested structure declaration.

### Values

| Value | Description |
|-------|-------------|
| "text" | Generic text, e.g. `"John Doe"`. This is the default field type. Use `field.length` to set length. |
| "boolean" | A boolean value, e.g. `true` |
| "integer" | A whole number, e.g. `123` |
| "float" | A floating point (decimal) number, e.g. `1.23` |
| "date" | A logical date, with no time value (such as a holiday or birthday). Represented on the client as a JavaScript `Date` object where time values are ignored. See [dateFormatAndStorage](kb_topics/dateFormatAndStorage.md#kb-topic-date-and-time-format-and-storage) for more information on date display and serialization formats. |
| "time" | A time of day, with no date. Represented on the client as a JavaScript `Date` object in UTC/GMT by default (see also [dateFormatAndStorage](kb_topics/dateFormatAndStorage.md#kb-topic-date-and-time-format-and-storage) and the [Time](classes/Time.md#class-time) class). |
| "datetime" | A date and time, accurate to the [second](classes/DataSourceField.md#attr-datasourcefieldstoremilliseconds). Represented on the client as a JavaScript `Date` object. See also [dateFormatAndStorage](kb_topics/dateFormatAndStorage.md#kb-topic-date-and-time-format-and-storage). |
| "enum" | A text value constrained to a set of legal values specified by the field's [valueMap](classes/DataSourceField.md#attr-datasourcefieldvaluemap), as though a [ValidatorType](#type-validatortype) of "isOneOf" had been declared. |
| "intEnum" | An enum whose values are numeric. |
| "sequence" | If you are using the SmartClient SQL datasource connector, a `sequence` is a unique, increasing whole number, incremented whenever a new record is added. Otherwise, `sequence` behaves identically to `integer`. This type is typically used with `field.primaryKey` to auto-generate unique primary keys. See also [DataSourceField.sequenceName](classes/DataSourceField.md#attr-datasourcefieldsequencename) and [DataSource.sequenceMode](classes/DataSource.md#attr-datasourcesequencemode) |
| "link" | A string representing a well-formed URL. Some components will render this as an HTML link (using an anchor tag for example). |
| "image" | A string representing a well-formed URL that points to an image. Some components will render an IMG tag with the value of this field as the 'src' attribute to render the image. |
| "binary" | Arbitrary binary data. When this field type is present, three additional fields are automatically generated. They are: `<fieldName>`\_filename, `<fieldName>`\_filesize, and `<fieldName>`\_date\_created where `<fieldName>` is the value of the `name` attribute of this field. These fields are marked as [DataSourceField.hidden](classes/DataSourceField.md#attr-datasourcefieldhidden)`:true` to suppress their rendering by default. You can show one or more of these fields by specifying the field with a `hidden:false` override in the fields array of the databound component. _Stream / view file support for custom DataSources_: a custom DataSource or [DMI](classes/DMI.md#class-dmi) must implement the "viewFile" and "downloadFile" operationTypes and return a single Record with a byte\[\] as the field value for the binary field. For more detail see the overview of [Binary Fields](kb_topics/binaryFields.md#kb-topic-binary-fields). |
| "imageFile" | Binary data comprising an image. Causes [ViewFileItem](#class-viewfileitem) to be used when the field is displayed in a form, allowing the image to optionally be displayed inline. |
| "any" | Fields of this type can contain any data value and have no default formatting or validation behavior. This is useful as the [parent type](classes/SimpleType.md#attr-simpletypeinheritsfrom) for SimpleTypes where you do not want any of the standard validation or formatting logic to be inherited from the standard built-in types. |
| "custom" | Synonymous with "any". |
| "modifier" | Fields of this type are automatically populated by the SmartClient Server with the current authenticated userId as part of "add" and "update" operations. By default, fields of this type are hidden and not editable; the server ignores any value that the client sends in a field of this type (but see also [writeToGeneratedFields](classes/DSRequest.md#attr-dsrequestwritetogeneratedfields)). Note that the "authenticated user" can be set explicitly on the server-side `RPCManager` using the `setUserId()` method, or it can come from the servlet API if you are using its built-in authentication scheme. See the server-side Javadocs for `RPCManager`. |
| "modifierTimestamp" | Fields of this type are automatically populated by the SmartClient Server with the current date and time as part of "add" and "update" operations. By default, fields of this type are hidden and not editable; the server ignores any value that the client sends in a field of this type (but see also [writeToGeneratedFields](classes/DSRequest.md#attr-dsrequestwritetogeneratedfields)). |
| "creator" | Fields of this type are automatically populated by the SmartClient Server with the current authenticated userId as part of "add" operations. By default, fields of this type are hidden and not editable; the server ignores any value that the client sends in a field of this type. (but see also [writeToGeneratedFields](classes/DSRequest.md#attr-dsrequestwritetogeneratedfields)). The notes about type "modifier" also apply to fields of this type. |
| "creatorTimestamp" | Fields of this type are automatically populated by the SmartClient Server with the current date and time as part of an "add" operation (when the record is first created). By default, fields of this type are hidden and not editable; the server ignores any value that the client sends in a field of this type (but see also [writeToGeneratedFields](classes/DSRequest.md#attr-dsrequestwritetogeneratedfields)). |
| "password" | Same as "text", but causes [PasswordItem](#class-passworditem) to be used by default for editing (hides typed-in value), and defaults [storeWithhash](classes/DataSourceField.md#attr-datasourcefieldstorewithhash) to "bcrypt" (affecting server operations). |
| "ntext" | A special field type specifically for use with Unicode data in conjunction with the Microsoft SQL Server database. Field type "ntext" implies the use of [sqlStorageStrategy](classes/DataSourceField.md#attr-datasourcefieldsqlstoragestrategy) "ntext"; other than that, this type is identical to "text" |
| "localeInt" | An integer number with locale-based formatting, e.g. `12,345,678`. See [Localized Number Formatting](#kb-topic-localized-number-formatting) for more info. |
| "localeFloat" | A float number with locale-based formatting, e.g. `12,345.67`. See [Localized Number Formatting](#kb-topic-localized-number-formatting) for more info. |
| "localeCurrency" | A float number with locale-based formatting and using currency symbol, e.g. `$12,345.67`. See [Localized Number Formatting](#kb-topic-localized-number-formatting) for more info. |
| "phoneNumber" | A telephone number. Uses [FormItem.browserInputType](classes/FormItem.md#attr-formitembrowserinputtype) "tel" to hint to the device to restrict input. On most mobile devices that have software keyboards, this cause a specialized keyboard to appear which only allows entry of normal phone numbers. When displayed read-only, a "phoneNumber" renders as an HTML link with the "tel:" URL scheme, which will invoke the native phone dialing interface on most mobile devices. In addition, the CSS style "sc\_phoneNumber" is applied.

By default, "phoneNumber" fields do not include validators, however the following validator definition would limit to digits, dashes and the "+" character: xml:

`<validator type="regexp" expression="^(\\(?\\+?\[0-9\]\*\\)?)?\[0-9\_\\- \\(\\)\]\*$" errorMessage="Phone number should be in the correct format e.g. +#(###)###-##-##" />`

or directly in JavaScript:

```
 {type:"regexp", expression:"^(\\(?\\+?[0-9]*\\)?)?[0-9_\\- \\(\\)]*$", 
     errorMessage:"Phone number should be in the correct format e.g. +#(###)###-##-##"}
 
```
and adding "#" and "\*" to the regular expressions above would allow for users to enter special keys sometimes used for extension numbers or pauses |

### See Also

- [ListGridFieldType](#type-listgridfieldtype)
- [FormItemType](#type-formitemtype)

---
## Type: FilteredSelectAllAction

### Description
Governs how the [MultiPickerItem](classes/MultiPickerItem.md#class-multipickeritem) "Select All" and "Deselect All" buttons should act when the user has filtered the set of visible options in the list.

### Values

| Value | Description |
|-------|-------------|
| "disable" | The buttons auto-disable when the list of options is filtered. |
| "all" | Ignore filtering: Always select or deselect the entire set of options including those not currently visible in the filtered list. This option is only available if the entire set of data has been loaded in the client. |
| "whenLoaded" | If the entire (filtered) list is loaded, both Select All and Clear are functional and will update the selection for all items in the filtered list. If a partial list is loaded, these buttons will be disabled. |

---
## Type: FireStyle

### Description
Flags to set automatic removal of events from the page event registry.

### Values

| Value | Description |
|-------|-------------|
| null | Call the registered handler any time the event occurs |
| Page.FIRE_ONCE | Call the registered handler the first time the event occurs, then unregister the handler as though [Page.clearEvent](classes/Page.md#classmethod-pageclearevent) had been called |

### Groups

- EventRegistry

### See Also

- [Page.setEvent](classes/Page.md#classmethod-pagesetevent)

---
## Type: FormItemBaseStyle

### Description
This string is the base CSS class name applied to a FormItem (or some part of a form item). See the [formItem styling overview](kb_topics/formItemStyling.md#kb-topic-formitem-styling) for more information about styling formItems.

The specified style name will be modified as the 'state' of the form item changes. Developers should provide appropriately named CSS classes for each stateful style described below:

*   If [FormItem.showPending](classes/FormItem.md#attr-formitemshowpending) is true, when the current value differs from the value that would be restored by a call to [DynamicForm.resetValues](classes/DynamicForm.md#method-dynamicformresetvalues), this style will have the suffix "Pending" appended to it.
*   If [FormItem.showFocused](classes/FormItem.md#attr-formitemshowfocused) is true, when the form item receives focus, this style will have the suffix "Focused" appended to it.
*   If [FormItem.showOver](classes/FormItem.md#attr-formitemshowover) is true, roll-over will be indicated by appending the suffix "Over" appended to the style name. This applies to the [textBoxStyle](classes/FormItem.md#attr-formitemtextboxstyle) and [controlStyle](classes/FormItem.md#attr-formitemcontrolstyle) only.
*   If [FormItem.showErrorStyle](classes/FormItem.md#attr-formitemshowerrorstyle) is true, if the form item has errors, this style will have the suffix "Error" appended to it.
*   If [FormItem.showDisabled](classes/FormItem.md#attr-formitemshowdisabled) is true, when the form item is disabled, this style will have the suffix "Disabled" appended to it.
*   Finally, if [FormItem.showRTL](classes/FormItem.md#attr-formitemshowrtl) is true, when the form item is in RTL mode, this style will have the suffix "RTL" appended to it.

So for example if the cellStyle for some form item is set to "formCell" and showFocused is true, when the form item receives focus, the form item's cell will have the "formCellFocused" style applied to it.

### Groups

- formItemStyling

---
## Type: FormItemClassName

### Description
Name of a SmartClient Class that subclasses [FormItem](classes/FormItem.md#class-formitem). Some values with this type:

*   ["TextItem"](classes/TextItem.md#class-textitem)
*   ["SliderItem"](classes/SliderItem.md#class-slideritem),
*   ["CanvasItem"](classes/CanvasItem.md#class-canvasitem)

---
## Type: GroupTreeChangeType

### Description
Type of change to the [ListGrid.groupTree](classes/ListGrid_1.md#attr-listgridgrouptree).

### Values

| Value | Description |
|-------|-------------|
| ListGrid.GROUP_BY | [ListGrid.groupBy](classes/ListGrid_2.md#method-listgridgroupby) responsible (grouping fields changed) |
| ListGrid.REGROUP | [ListGrid.regroup](classes/ListGrid_2.md#method-listgridregroup) responsible (grid already grouped) |
| ListGrid.INCREMENTAL | incremental regroup of a single record |

### See Also

- [ListGrid.groupTreeChanged](classes/ListGrid_2.md#method-listgridgrouptreechanged)

---
## Type: HashAlgorithm

### Description
Algorithms to use when hashing field values (see [DataSourceField.storeWithHash](classes/DataSourceField.md#attr-datasourcefieldstorewithhash)). Note that the `MD5` and `SHA` algorithms are deprecated as secure hashes since they are vulnerable to collisions created by an attacker with current technology, though they may still be useful in detecting corruption due to faulty transmission or storage.

### Values

| Value | Description |
|-------|-------------|
| "MD5" | Message Digest algorithm. _Deprecated as a secure hash._ |
| "SHA" | Secure Hashing Algorithm (SHA-1). _Deprecated as a secure hash._ |
| "SHA-256" | Secure Hashing Algorithm (SHA-256). |
| "SHA-512" | Secure Hashing Algorithm (SHA-512). |
| "bcrypt" | bcrypt is a password hashing function designed by Niels Provos and David Mazieres, based on the Blowfish cipher. |
| "none" | Don't hash values. Can be specified to avoid the default algorithm. |

---
## Type: HiliteIconPosition

### Description
Where a [hilite icon](classes/DataBoundComponent.md#attr-databoundcomponenthiliteicons) will be placed relative to normal cell content.

### Values

| Value | Description |
|-------|-------------|
| "before" | icon will be placed before the normal cell contents |
| "after" | icon will be placed after the normal cell contents |
| "replace" | icon will be shown instead of the normal cell contents |

### Groups

- hiliting

---
## Type: HoopSelectionStyle

### Description
Hoop selection modes.

### Values

| Value | Description |
|-------|-------------|
| "encloses" | Components completely enclosed by the hoop are selected |
| "intersects" | Components enclosed or intersected by the hoop are selected |

---
## Type: HoverPersistMode

### Description
Customizes how users can interact with hovers.

### Values

| Value | Description |
|-------|-------------|
| "none" | Hover is dismissed as soon as the mouse moves off the target. This default type of hover cannot offer an interaction because the hover vanishes on mouseOut from the target |
| "underMouse" | the user has a brief window to move the cursor over the hover to prevent it from being dismissed, until mouseOut from the hover, allowing interactive hovers. Note, if you want your hover to disappear as soon as something is clicked (like a link, for example), call [Hover.hide](classes/Hover.md#classmethod-hoverhide) |
| "clickPin" | like "underMouse", but if the user clicks in the hover, it is pinned until the user clicks outside of the hover |
| "autoPin" | like "clickPin", but the hover is pinned as soon as the user places the cursor over the hover, and needs an outside-click to dismiss |

### Groups

- hovers

---
## Type: IconOverTrigger

### Description
Property to govern when the 'over' styling is applied to a formItemIcon.

### Values

| Value | Description |
|-------|-------------|
| "icon" | Show rollover styling and media when the user is over the icon only |
| "textBox" | Show rollover styling and media when the user is over the icon or over the textBox (or control-table, if present) for this icon. Only has an effect when [FormItem.showOver](classes/FormItem.md#attr-formitemshowover) is true. |
| "item" | Show rollover styling and media when the user is over any part of the FormItem, including the entire cell within a DynamicForm table containing the item. |

---
## Type: ImportFormat

### Description
—

### Values

| Value | Description |
|-------|-------------|
| "xml" | XML format: same as that expected by the [adminConsole](kb_topics/adminConsole.md#kb-topic-admin-console) for DataSource [test data](kb_topics/testData.md#kb-topic-test-data) |
| "json" | JSON format: a JSON Array of JSON Objects |
| "csv" | Comma-separated values, or in general delimiter-separated values based on a provided delimiter. |
| "auto" | Auto-detect format |

---
## Type: Integer

### Description
A whole number, for example, 5. Decimal numbers, for example 5.5, are not allowed. Null is allowed.

### See Also

- [int](#type-int)
- [PositiveInteger](#type-positiveinteger)

---
## Type: JoinType

### Description
The type of join to make between two SQL tables when resolving [includeFrom](classes/DataSourceField.md#attr-datasourcefieldincludefrom) fields.

### Values

| Value | Description |
|-------|-------------|
| "inner" | A regular inner join, whereby rows are only included in the resultset where the join can be satisified, so a missing row in the table being joined to results in the entire row being omitted. |
| "outer" | An outer join. All outer joins generated by SmartClient's SQL subsystem are left outer joins, meaning that every row in the join-from (or "left") table that matches the criteria is included, and missing rows in the join-to (or "right") table cause columns to be set to null. |

### Groups

- dataSourceRelations

---
## Type: JSONCircularReferenceMode

### Description
What the [JSONEncoder](classes/JSONEncoder.md#class-jsonencoder) should do when it encounters a circular reference in an object structure.

### Values

| Value | Description |
|-------|-------------|
| "omit" | circular references in Arrays will be represented as a null entry, and objects will have a property with a null value |
| "marker" | leave a string marker, the [JSONEncoder.circularReferenceMarker](classes/JSONEncoder.md#attr-jsonencodercircularreferencemarker), wherever a circular reference is found |
| "path" | leave a string marker _followed by_ the path to the first occurrence of the circular reference from the top of the object tree that was serialized. This potentially allows the original object graph to be reconstructed. |

---
## Type: JSONInstanceSerializationMode

### Description
Controls the output of the JSONEncoder when instances of SmartClient classes (eg a ListGrid) are included in the data to be serialized.

### Values

| Value | Description |
|-------|-------------|
| "long" | instances will be shown as a specially formatted JSON listing the most relevant properties of the instance. Result is not expected to decode()/eval() successfully if instances are included. |
| "short" | instances will be shown in a shorter format via a call to [isc.echoLeaf](classes/isc.md#staticmethod-iscecholeaf). Result is not expected to decode()/eval() successfully if instances are included. |
| "skip" | no output will be shown for instances (as though they were not present in the data). Result should decode()/eval() successfully (depending on other settings) |

---
## Type: KeyName

### Description
Strings to identify the various keys on the keyboard.

*   For alpha keys, the single (uppercase) character value is used, such as "Q"
*   For Numeric keys, the number is used as in a single character string, like "1"
*   Function keys are identified as `"f1"` - `"f12"`
*   Non alpha-numeric character keys (such as the key for "\[" / "{") are identified by their unmodified character value (the value obtained by hitting the key without holding shift down), by default - exceptions are listed below.
*   Additional key names:  
    \- `Space`  
    \- `Tab`  
    \- `Enter`  
    \- `Escape`  
    \- `Backspace`  
    \- `Insert`  
    \- `Delete`  
    \- `Arrow_Up`  
    \- `Arrow_Down`  
    \- `Arrow_Left`  
    \- `Arrow_Right`  
    \- `Home`  
    \- `End`  
    \- `Page_Up`  
    \- `Page_Down`  
    \- `Shift`  
    \- `Ctrl`  
    \- `Alt`

\[Note: Some keys may not be available for capture on every platform\]

---
## Type: LabelAlignment

### Description
—

### Values

| Value | Description |
|-------|-------------|
| DrawLabel.START | Justify label's left edge against its left coordinate (right in RTL configurations) |
| DrawLabel.END | Justify label's right edge against its left coordinate (left in RTL configurations) |
| DrawLabel.CENTER | Center label about its left coordinate |
| DrawLabel.LEFT | Justify label's left edge against its left coordinate |
| DrawLabel.RIGHT | Justify label's right edge against its left coordinate |

---
## Type: LabelRotationMode

### Description
Strategy for determining whether and when to rotate certain labels.

### Values

| Value | Description |
|-------|-------------|
| "never" | do not rotate labels |
| "auto" | rotate labels if needed in order to make them legible and non-overlapping |
| "always" | always rotate labels |

---
## Type: LayoutPolicy

### Description
Policy controlling how the Layout will manage member sizes on this axis.

Note that, by default, Layouts do _not_ automatically expand the size of all members to match a member that overflows the layout on the breadth axis. This means that a [DynamicForm](classes/DynamicForm.md#class-dynamicform) or other component that can't shrink beyond a minimum width will "stick out" of the Layout, wider than any other member and wider than automatically generated components like resizeBars or sectionHeaders (in a [SectionStack](classes/SectionStack.md#class-sectionstack)).

This is by design: matching the size of overflowing members would cause expensive redraws of all members in the Layout, and with two or more members potentially overflowing, could turn minor browser size reporting bugs or minor glitches in custom components into infinite resizing loops.

If you run into this situation, you can either:

*   set the overflowing member to [overflow](classes/Canvas.md#attr-canvasoverflow): "auto", so that it scrolls if it needs more space
*   set the Layout as a whole to [overflow](classes/Canvas.md#attr-canvasoverflow):"auto", so that the whole Layout scrolls when the member overflows
*   define a [resized()](classes/Canvas.md#method-canvasresized) handler to manually update the breadth of the layout
*   set [Layout.minBreadthMember](classes/Layout.md#attr-layoutminbreadthmember) to ensure that the available breadth used to expand all (other) members is artificially increased to match the current breadth of the `minBreadthMember` member; the layout will still be overflowed in this case and the reported size from [Canvas.getWidth](classes/Canvas.md#method-canvasgetwidth) or [Canvas.getHeight](classes/Canvas.md#method-canvasgetheight) won't change, but all members should fill the visible width or height along the breadth axis

For the last approach, given the VLayout `myLayout` and a member `myWideMember`, then we could define the following [resized()](classes/Canvas.md#method-canvasresized) handler on `myLayout`:

```
 resized : function () {
     var memberWidth = myWideMember.getVisibleWidth();
     this.setWidth(Math.max(this.getWidth(), memberWidth + offset));
 }
```
where `offset` reflects the difference in width (due to margins, padding, etc.) between the layout and its widest member. In most cases, a fixed offset can be used, but it can also be computed via the calculation:

```
     myLayout.getWidth() - myLayout.getViewportWidth()
 
```
in an override of [draw()](classes/Canvas.md#method-canvasdraw) for `myLayout`. (That calculation is not always valid inside the [resized()](classes/Canvas.md#method-canvasresized) handler itself.)

Note: the HLayout case is similar- just substitute height where width appears above.

See also [Layout.overflow](classes/Layout.md#attr-layoutoverflow).

### Values

| Value | Description |
|-------|-------------|
| Layout.NONE | Layout does not try to size members on the axis at all, merely stacking them (length axis) and leaving them at default breadth. |
| Layout.FILL | Layout sizes members so that they fill the specified size of the layout. The rules are:

*   Any component given an initial pixel size, programmatically resized to a specific pixel size, or drag resized by user action is left at that exact size
*   Any component that [autofits](classes/Button.md#attr-buttonautofit) is given exactly the space it needs, never forced to take up more.
*   All other components split the remaining space equally, or according to their relative percentages.
*   Any component that declares a [Canvas.minWidth](classes/Canvas.md#attr-canvasminwidth) or [Canvas.minHeight](classes/Canvas.md#attr-canvasminheight) will never be sized smaller than that size
*   Any component that declares a [Canvas.maxWidth](classes/Canvas.md#attr-canvasmaxwidth) or [Canvas.maxHeight](classes/Canvas.md#attr-canvasmaxheight) will never be sized larger than that size

In addition, components may declare that they have [adaptive sizing](classes/Canvas.md#attr-canvascanadaptwidth), and may coordinate with the Layout to render at different sizes according to the amount of available space. |

### See Also

- [Layout.minBreadthMember](classes/Layout.md#attr-layoutminbreadthmember)

---
## Type: ListGridComponent

### Description
Standard component-type displayed within a ListGrid, as contained by [ListGrid.gridComponents](classes/ListGrid_1.md#attr-listgridgridcomponents).

### Values

| Value | Description |
|-------|-------------|
| "filterEditor" | The standard filter-component displayed when [ListGrid.showFilterEditor](classes/ListGrid_1.md#attr-listgridshowfiltereditor) is true |
| "header" | The header-component displayed when [ListGrid.showHeader](classes/ListGrid_1.md#attr-listgridshowheader) is true. |
| "body" | The body component for the grid. |
| "summaryRow" | The summary-row component displayed when [ListGrid.showGridSummary](classes/ListGrid_1.md#attr-listgridshowgridsummary) is true. |

### Groups

- appearance

---
## Type: ListGridFieldState

### Description
An object containing the stored presentation information for the fields of a listGrid. Information contained in a `ListGridFieldState` object includes the visibility and widths of the listGrid's fields.  
Note that this object is a JavaScript string, and may be stored (for example) as a blob on the server for state persistence across sessions.

### Groups

- viewState

---
## Type: ListGridSelectedState

### Description
An object containing the stored selection information for a listGrid. Note that this object is not intended to be interrogated directly, but may be stored (for example) as a blob on the server for state persistence across sessions.

### Groups

- viewState

---
## Type: ListGridUserCriteriaState

### Description
An object containing the stored criteria as applied by the user. Does not include criteria applied in other ways.

### Groups

- viewState

---
## Type: ListGridViewState

### Description
An object containing the "view state" information for a listGrid.

This object contains state information reflecting the following states in the grid:

*   [field state](reference_2.md#type-listgridfieldstate)
*   [sort state](#type-listgridsortstate)
*   [selected state](reference_2.md#type-listgridselectedstate)
*   [group state](#type-listgridgroupstate)
*   [criteria state](reference_2.md#type-listgridusercriteriastate)
*   hilite state
*   filterEditor visibility state

Note that this object is a JavaScript string, and may be stored (for example) as a blob on the server for state persistence across sessions.

### Groups

- viewState

---
## Type: ListStyleType

### Description
The style of list item marker for a list.

### Values

| Value | Description |
|-------|-------------|
| "disc" | A filled, black dot (•) |
| "circle" | An unfilled circle (◦) |
| "square" | A filled, black square (■) |
| "decimal" | Numbers (1., 2., 3., etc.) |
| "upper-roman" | Uppercase Roman numerals (I., II., III., IV., etc.) |
| "lower-roman" | Lowercase Roman numerals (i., ii., iii., iv., etc.) |
| "upper-alpha" | Uppercase letters (A., B., C., etc.) |
| "lower-alpha" | Lowercase letters (a., b., c., etc.) |
| "custom-image" | An image used in place of a marker. |

---
## Type: LoadProjectErrorStatus

### Description
—

### Values

| Value | Description |
|-------|-------------|
| "timeout" | server has not responded within configured request timeout |
| "noResponseFromURL" | can't reach server at [Reify.serverURL](classes/Reify.md#classattr-reifyserverurl) |
| "badReifyServerURL" | no project loader at [Reify.serverURL](classes/Reify.md#classattr-reifyserverurl) |
| "badCredentials" | invalid [Reify.userName](classes/Reify.md#classattr-reifyusername) or [Reify.password](classes/Reify.md#classattr-reifypassword) |
| "projectNotFound" | none of the requested projects were found |
| "servletError" | — |

---
## Type: LoadState

### Description
Trees that dynamically load nodes keep track of whether each node has loaded its children.

### Values

| Value | Description |
|-------|-------------|
| Tree.UNLOADED | children have not been loaded and are not loading |
| Tree.LOADING | currently in the process of loading |
| Tree.FOLDERS_LOADED | folders only are already loaded |
| Tree.LOADED | already fully loaded |
| Tree.LOADED_PARTIAL_CHILDREN | children form a ResultSet having only a partial cache (applies only to the "paged" [fetchMode](classes/ResultTree.md#attr-resulttreefetchmode)) |

### Groups

- loadState

---
## Type: LocatorAttributeType

### Description
Attributes that may be retrieved from [autoTest locators](reference_2.md#type-autotestlocator).

### Values

| Value | Description |
|-------|-------------|
| "element" | DOM Element. May be retrieved from [AutoTest.getElement](classes/AutoTest.md#classmethod-autotestgetelement). |
| "object" | SmartClient Object. Returns the [Canvas](classes/Canvas.md#class-canvas), [FormItem](classes/FormItem.md#class-formitem) or [SectionStackSection](#object-sectionstacksection) for the locator. May be retrieved via [AutoTest.getObject](classes/AutoTest.md#classmethod-autotestgetobject). |
| "value" | Atomic value for the locator. This only applies to locators that refer to the UI to display a value in some data component, such as a ListGrid cell. May be retrieved via [AutoTest.getValue](classes/AutoTest.md#classmethod-autotestgetvalue). |
| "record" | Record for the locator. This only applies to locators that refer to the UI to display a record in some data component, such as a ListGrid cell. |
| "field" | Record for the locator. This only applies to locators that refer to the UI to display the fields of a record in some data component, such as a ListGrid cell. |

---
## Type: LocatorStrategy

### Description
The AutoTest subsystem relies on generating and parsing identifier strings to identify components on the page. A very common pattern is identifying a specific component within a list of possible candidates. There are many many cases where this pattern is used, for example - members in a layout, tabs in a tabset, sections in a section stack.

In order to make these identifiers as robust as possible across minor changes to an application, (such as skin changes, minor layout changes, etc) the system will store multiple pieces of information about a component when generating an identification string to retrieve it from a list of candidates. The system has a default strategy for choosing the order in which to look at these pieces of information but in some cases this can be overridden by setting a `LocatorStrategy`.

By default we use the following strategies in order to identify a component from a list of candidates:

*   `name`: Does not apply in all cases but in cases where a specified `name` attribute has meaning we will use it - for example for [sections in a section stack](classes/SectionStackSection.md#attr-sectionstacksectionname) or [images](classes/Img.md#attr-imgname).
*   `title`: If a title is specified for the component this may be used as a legitimate identifier if it is unique within the component - for example differently titled tabs within a tabset.
*   `index`: Locating by index is typically less robust than by name or title as it is likely to be affected by layout changes on the page.

If an explicit strategy is specified, that will be used to locate the component if possible. If no matching component is found using that strategy, we will continue to try the remaining strategies in order as described above. In other words setting a locatorStrategy to "title" will skip attempting to find a component by name, and instead attempt to find by title - or failing that by index.

In cases where the name is considered definitive, such as for [Tabs](classes/Tab.md#attr-tabname) or [FormItems](classes/FormItem.md#attr-formitemname), no fallback check will occur if a name is provided in the locator but doesn't match a live object - the locator will fail to match anything. Furthermore, in the case of [Tabs](#object-tab), [FormItems](classes/FormItem.md#class-formitem), or collections other than [children of a widget](classes/Canvas.md#attr-canvaschildren), if a title is present in the locator and you haven't specified specified "index" as the strategy, there may be no fallback check using the index if the locator title fails to match.

To avoid the Framework trying to match by name or title where they are assumed definitive and we skip fallback to the remaining locator attributes, you'll need to remove the name or title from the locator in question (or set the locatorStrategy to "index" in the case of the title).

Note that we also support matching by type (see [LocatorTypeStrategy](#type-locatortypestrategy)). Matching by type is used if we were unable to match by name or title or to disambiguate between multiple components with a matching title.

### Values

| Value | Description |
|-------|-------------|
| "name" | Match by name if possible. |
| "title" | Match by title if possible. |
| "index" | Match by index |

### Groups

- autoTest

### See Also

- [ListGrid.locateRowsBy](classes/ListGrid_1.md#attr-listgridlocaterowsby)
- [ListGrid.locateColumnsBy](classes/ListGrid_1.md#attr-listgridlocatecolumnsby)
- [Canvas.locatePeersBy](classes/Canvas.md#attr-canvaslocatepeersby)
- [Canvas.locateChildrenBy](classes/Canvas.md#attr-canvaslocatechildrenby)
- [Layout.locateMembersBy](classes/Layout.md#attr-layoutlocatemembersby)
- [SectionStack.locateSectionsBy](classes/SectionStack.md#attr-sectionstacklocatesectionsby)
- [FormItem.locateItemBy](classes/FormItem.md#attr-formitemlocateitemby)
- [TabSet.locateTabsBy](classes/TabSet.md#attr-tabsetlocatetabsby)

---
## Type: LogicalOperator

### Description
Operators that can evaluate a set of criteria and produce a combined result.

### Values

| Value | Description |
|-------|-------------|
| "and" | true if all criteria are true |
| "or" | true if any criteria are true |
| "not" | true if all criteria are false |

---
## Type: MatchElementSizeMode

### Description
How should a canvas match its target [Canvas.htmlElement](classes/Canvas.md#attr-canvashtmlelement) size?

### Values

| Value | Description |
|-------|-------------|
| "matchElement" | canvas will be sized to match the element |
| "sizeElement" | htmlElement should be sized to match the specified size of the canvas |
| "none" | do not attempt to match the canvas / element size |

---
## Type: MinimalScrollbarContrastSuffix

### Description
—

### Values

| Value | Description |
|-------|-------------|
| "Light" | suffix to apply to [MinimalScrollbar.trackBaseStyle](classes/MinimalScrollbar.md#attr-minimalscrollbartrackbasestyle) and [MinimalScrollbar.thumbBaseStyle](classes/MinimalScrollbar.md#attr-minimalscrollbarthumbbasestyle) to get a light appearance (appropriate for contrasting against a dark background) |
| "Dark" | suffix to apply to [MinimalScrollbar.trackBaseStyle](classes/MinimalScrollbar.md#attr-minimalscrollbartrackbasestyle) and [MinimalScrollbar.thumbBaseStyle](classes/MinimalScrollbar.md#attr-minimalscrollbarthumbbasestyle) to get a dark appearance (appropriate for contrasting against a light background) |

---
## Type: MockDataFormat

### Description
Specifies the format of the mock data.

### Values

| Value | Description |
|-------|-------------|
| "mock" | Mock data in "balsamiq" format |
| "csv" | Mock data in CSV format |
| "xml" | Mock data in XML format |
| "json" | Mock data in JSON format |

---
## Type: MockDSExportValidatorMode

### Description
—

### Values

| Value | Description |
|-------|-------------|
| "all" | export all explicit, client-side validators |
| "standard" | export all explicit, client-side standard (non-custom) validators |
| "none" | export no validators |

---
## Type: MoveKnobPoint

### Description
Specifies the starting point of a move knob with respect to its draw item. The move knob is positioned relative to the move knob point at the [DrawItem.moveKnobOffset](classes/DrawItem.md#attr-drawitemmoveknoboffset).

### Values

| Value | Description |
|-------|-------------|
| "TL" | Top Left corner |
| "TR" | Top Right corner |
| "BL" | Bottom Left corner |
| "BR" | Bottom Right corner |

---
## Type: MultiComboBoxLayoutStyle

### Description
Specifies the layout of the combo box and buttons in a MultiComboBoxItem.

### Values

| Value | Description |
|-------|-------------|
| "flow" | use a [FlowLayout](#class-flowlayout), showing values first, then the text entry area |
| "flowReverse" | use a FlowLayout, with the text entry first and values shown afterwards |
| "horizontal" | Use a horizontal layout with the combo box on the right |
| "horizontalReverse" | Use a horizontal layout with the combo box on the left |
| "vertical" | Use a vertical layout |
| "verticalReverse" | Use a vertical layout with the combo box at the bottom |

### See Also

- [MultiComboBoxItem.layoutStyle](classes/MultiComboBoxItem.md#attr-multicomboboxitemlayoutstyle)

---
## Type: MultiInsertNonMatchingStrategy

### Description
For `SQLDataSource` only, the strategy to use to harmonize multiple records when [addData()](classes/DataSource.md#method-datasourceadddata) is called with a list of records, and [multiInsertStrategy](classes/DataSource.md#attr-datasourcemultiinsertstrategy) "multipleValues" is in force, and the supplied records do not all contain exactly the same fields. Harmonization is necessary because we only specify a single list of fields to the multi-insert, and each of the multiple `VALUES` clauses must exactly match that list of fields or we will get either SQL errors or corrupted inserts, depending on the underlying database

### Values

| Value | Description |
|-------|-------------|
| "dropRecords" | Drop all records in the record list that do not contain exactly the same fields as the first record |
| "dropFields" | Make all records match the first record in the record list, by dropping any fields from the second and subsequent records that are not present on the first record. If the first record in the record list contains values for field(s) that are missing in any other record in the record list, the other record(s) will be padded with nulls. This is similar to the "padWithNulls" setting below, but it only serves to make the second and subsequent records the same as the first, rather than considering all fields on all records |
| "padWithNulls" | Assemble a list of all fields that appear on ANY record in the record list, and ensure that ALL records in the record list include a value for each of those fields by modifying records to specify a null value for any field(s) the record is missing |

---
## Type: MultiInsertStrategy

### Description
For `SQLDataSource` only, the strategy to use to insert multiple records when [addData()](classes/DataSource.md#method-datasourceadddata) is called with a list of records.

### Values

| Value | Description |
|-------|-------------|
| "simple" | Iterate over the supplied list of records and issue a single-record add for each of them |
| "multipleValues" | Generate a single SQL statement that inserts multiple rows, using a database-specific strategy (usually specifying multiple `VALUES` clauses, but Oracle does not support that approach so we implement the same behavior using subselects). Actually, depending on the number of records to insert and the [batch size](classes/DataSource.md#attr-datasourcemultiinsertbatchsize), this strategy may generate more than one SQL statement |

---
## Type: MultiMessageMode

### Description
—

### Values

| Value | Description |
|-------|-------------|
| "stack" | messages of the same [NotifyType](reference_2.md#type-notifytype) are arranged in a stack |
| "replace" | messages of the same [NotifyType](reference_2.md#type-notifytype) replace each other |

---
## Type: MultiWindowEvent

### Description
Various events triggered by any window in the current application.

Aside from the standard event types listed, other types may be supported depending upon whether OpenFin is in use:

*   With OpenFin, [application event types](https://developer.openfin.co/docs/javascript/stable/tutorial-Application.EventEmitter.html) are allowed.
*   Without OpenFin, [HTML Dom Events](https://www.w3schools.com/jsref/dom_obj_event.asp) supported by [window.addEventListener()](https://developer.mozilla.org/en-US/docs/Web/API/EventTarget/addEventListener) are allowed.

### Values

| Value | Description |
|-------|-------------|
| "load" | fires when a window finishes loading |
| "unload" | fires when a window is about to be reloaded or closed |
| "move" | fires when a window is moved |
| "resize" | fires when a window is resized |
| "close" | fires when a window is closed |
| "focus" | fires when a window gets focus |
| "blur" | fires when a window loses focus |
| "activate" | (synonym for "focus") |
| "deactivate" | (synonym for "blur") |

---
## Type: NavigationMethod

### Description
Method of, or reason for, navigation between panes.

### Values

| Value | Description |
|-------|-------------|
| "backClick" | a "back" [NavigationButton](classes/NavigationButton.md#class-navigationbutton) has been clicked |
| "sideClick" | a side panel [NavigationButton](classes/NavigationButton.md#class-navigationbutton) has been clicked |
| "programmatic" | application code called [setCurrentPane()](classes/SplitPane.md#method-splitpanesetcurrentpane), [showNavigationPane()](classes/SplitPane.md#method-splitpaneshownavigationpane), [showListPane()](classes/SplitPane.md#method-splitpaneshowlistpane), [showDetailPane()](classes/SplitPane.md#method-splitpaneshowdetailpane), etc. |
| "navigatePane" | application code directly called [navigatePane()](classes/SplitPane.md#method-splitpanenavigatepane) |
| "selectionChanged" | a seletion change automatically called [navigatePane()](classes/SplitPane.md#method-splitpanenavigatepane) |
| "historyCallback" | browser navigation triggered [SplitPane](classes/SplitPane.md#class-splitpane) navigation |

---
## Type: NotifyType

### Description
An identifier passed to [Notify](classes/Notify.md#class-notify) APIs to group related messages together so that they all use the same behavior and display settings.

### See Also

- [Notify.addMessage](classes/Notify.md#classmethod-notifyaddmessage)
- [Notify.configureMessages](classes/Notify.md#classmethod-notifyconfiguremessages)
- [Notify.dismissMessage](classes/Notify.md#classmethod-notifydismissmessage)

---
## Type: OperatorValueType

### Description
Indicates the kind of value expected in a [Criterion](reference_2.md#object-criterion) that uses this operator.

### Values

| Value | Description |
|-------|-------------|
| "fieldType" | [Criterion.value](classes/Criterion.md#attr-criterionvalue) should contain a value of the same type as the field. |
| "fieldName" | [Criterion.value](classes/Criterion.md#attr-criterionvalue) should be the name of another field in the record |
| "none" | no criterion.value or other setting required (used for operators like isBlank or isNull). |
| "criteria" | [Criterion.criteria](classes/Criterion.md#attr-criterioncriteria) should be an Array of criteria (used for logical operators like "and"). |
| "valueRange" | [Criterion.start](classes/Criterion.md#attr-criterionstart) and [Criterion.end](classes/Criterion.md#attr-criterionend) should contain start and end values, both of the same type as the field. |
| "valueSet" | [Criterion.value](classes/Criterion.md#attr-criterionvalue) should contain an Array of valid field values. |
| "custom" | [Criterion.value](classes/Criterion.md#attr-criterionvalue) should contain a value which is not necessarily the same type as the field (used for regexp and similar operators). [Operator.editorType](classes/Operator.md#attr-operatoreditortype) can be specified as a FormItem to use to enter a value for the criterion. |

### Groups

- advancedFilter

---
## Type: Orientation

### Description
—

### Values

| Value | Description |
|-------|-------------|
| Layout.VERTICAL | members laid out vertically |
| Layout.HORIZONTAL | members laid out horizontally |

### Groups

- orientation

---
## Type: OutputWhen

### Description
The type of condition field must match in order to be fetched from underlying source of data and delivered the client.

### Values

| Value | Description |
|-------|-------------|
| "never" | Field is never delivered, unless explicitly included in [OperationBinding.outputs](classes/OperationBinding.md#attr-operationbindingoutputs). |
| "single" | Field is delivered for a [fetch](classes/OperationBinding.md#attr-operationbindingoperationtype) operation by primary key or as cache sync data after [update](classes/OperationBinding.md#attr-operationbindingoperationtype) or [add](classes/OperationBinding.md#attr-operationbindingoperationtype) operations. In both cases single record is expected to be returned. |
| "whenPresent" | Field is delivered as cache sync data after [update](classes/OperationBinding.md#attr-operationbindingoperationtype) or [add](classes/OperationBinding.md#attr-operationbindingoperationtype) operations only if the client seems to already have it for that record, i.e. it was present in submitted values. |

---
## Type: PageEvent

### Description
Events registerable via [Page.setEvent](classes/Page.md#classmethod-pagesetevent)

### Values

| Value | Description |
|-------|-------------|
| "idle" | Fires repeatedly (every 10 ms by default) when the system is idle (i.e., not busy running other scripts) after the page is loaded. |
| "load" | Fires when the page has finished loading. It corresponds to the browser 'load' event normally handled by window.onload. |
| "unload" | Fires when the page is exited or unloaded. It corresponds to the browser 'unload' event normally handled by window.onunload. |
| "resize" | Fires when the browser window is resized by the user. It corresponds to the browser 'resize' event normally handled by window.onresize. |
| "mouseDown" | Fires when the left mouse button is pressed on the Page. |
| "rightMouseDown" | Fires when the right mouse button is pressed on the Page. |
| "mouseMove" | Fires when the mouse moves on the Page. |
| "mouseUp" | Fires when the left mouse button released on the Page. |
| "click" | Fires when the user clicks the mouse on the Page. |
| "doubleClick" | Fires when the uesr double-clicks on the Page. |
| "showContextMenu" | Fires when the right mouse button is clicked on the page. If your event handler for this event returns false, the native browser context menu will be suppressed.  
Note: On the Macintosh platform, `Command+Click` may be used instead of right-button click to trigger a context menu event.  
On the Opera browser, `Ctrl+Shift+Click` should be used instead of right-button click. |
| "keyPress" | Fires when a user presses a key on the keyboard. |
| "orientationChange" | Fires when the [Page.getOrientation](classes/Page.md#classmethod-pagegetorientation) changes due to browser-window resize or rotation of a mobile device. |
| "fontsLoaded" | Fires when the [FontLoader](classes/FontLoader.md#class-fontloader) completes loading custom fonts. |
| "fontLoadingFailed" | Fires after a timeout if the [FontLoader](classes/FontLoader.md#class-fontloader) fails to load all custom fonts. see classMethod:Page.setEvent() see classMethod:Page.clearEvent() |

---
## Type: PanelPlacement

### Description
Possible placements for pop-up choosers, menus, dialogs or other temporary UIs, which may need to expand to take up additional room for smaller screens.

### Values

| Value | Description |
|-------|-------------|
| "nearOrigin" | classic placement for menus, pop-up lists and pickers in desktop interfaces: near the control that was clicked (a search field, [MenuButton](classes/MenuButton.md#class-menubutton), etc). Note: this setting does not apply when there is no originating control (such as a dialog that appears due to session timeout), in which case centering will generally be used |
| "fillPanel" | fill the nearest containing panel managed by a device-aware layout such as [SplitPane](classes/SplitPane.md#class-splitpane), which will generally be equivalent to "fillScreen" for a [handset-sized device](classes/Browser.md#classattr-browserishandset). Note: this setting does not apply if there is no clear container for the component originating the UI, in which case, "fillScreen" will generally be used. |
| "fillScreen" | fill the entire screen |
| "halfScreen" | fill the bottom half of the screen. This is the default behavior on iOS6/7 for plain HTML `<select>`, but note that native apps rarely use this interface for picking from lists and it is not generally recommended. |
| "none" | this setting disables all panelPlacement sizing and positioning logic. Explicitly specified size and positioning will be used. |

---
## Type: PartialCommitOption

### Description
Action to take if a user attempts to save the dataset produced by a [BatchUploader](classes/BatchUploader.md#class-batchuploader) whilst it still contains errors.

### Values

| Value | Description |
|-------|-------------|
| "allow" | Silently allow the partial commit to proceed (note that this will result in the user losing those records that contain errors) |
| "prevent" | Pop up a message window showing the [BatchUploader.partialCommitError](classes/BatchUploader.md#attr-batchuploaderpartialcommiterror) and prevent the partial commit |
| "prompt" | Pop up a confirmation window with the [BatchUploader.partialCommitPrompt](classes/BatchUploader.md#attr-batchuploaderpartialcommitprompt) and allow the user to choose whether or not to proceed |
| "retain" | Commit any records that are error-free and remove them from the grid. If any records had errors, leave them in the grid and leave the grid visible. If no records had errors, run normal cleanup as we would for "allow". This option allows the user to fix errors iteratively, rather than having to fix everything upfront before committing |

---
## Type: Positioning

### Description
—

### Values

| Value | Description |
|-------|-------------|
| Canvas.ABSOLUTE | The canvas is absolutely positioned with respect to its parent. |
| Canvas.RELATIVE | The canvas is relatively positioned according to the document flow. |

### Groups

- positioning

---
## Type: ProcessValueType

### Description
—

### Values

| Value | Description |
|-------|-------------|
| "string" | values that are not already strings are converted via toString() |
| "boolean" | the strings "true" and "false" become boolean true and false. All other Strings non-empty String values are true, all numbers are true except 0, and all other non-null values are true |
| "decimal" | values are converted via toString() and parsing as a decimal number. Invalid values trigger a transition to the [StateTask.failureElement](classes/StateTask.md#attr-statetaskfailureelement) |
| "integer" | values are converted via toString(), parsing as a number, and rounding to nearest integer. Invalid values trigger a transition to the [StateTask.failureElement](classes/StateTask.md#attr-statetaskfailureelement) |
| "record" | any input which is not already a Record or Map becomes null |
| "array" | generic array type - will convert value to an array of the same type as the existing value |

---
## Type: PromptStyle

### Description
—

### Values

| Value | Description |
|-------|-------------|
| "dialog" | Displays a centered modal prompt with text specified by [RPCRequest.prompt](classes/RPCRequest.md#attr-rpcrequestprompt) |
| "cursor" | Changes the current cursor to the style specified by [RPCRequest.promptCursor](classes/RPCRequest.md#attr-rpcrequestpromptcursor) |

---
## Type: ReadOnlyDisplayAppearance

### Description
Dictates the appearance of form items when [FormItem.canEdit](classes/FormItem.md#attr-formitemcanedit) is set to `false`.

### Values

| Value | Description |
|-------|-------------|
| "static" | Item value should appear within the form as a static block of text, similar to the default appearance of a [StaticTextItem](classes/StaticTextItem.md#class-statictextitem). This appearance may be modified via [FormItem.readOnlyTextBoxStyle](classes/FormItem.md#attr-formitemreadonlytextboxstyle) and [FormItem.clipStaticValue](classes/FormItem.md#attr-formitemclipstaticvalue). |
| "readOnly" | Item should appear unchanged, but user interaction to edit the item will be disallowed. Note that some interactions will be allowed, such as selecting text within a read-only [TextItem](classes/TextItem.md#class-textitem) for copy and paste. Exact implementation may vary by form item type. |
| "disabled" | Item will appear disabled. |

### See Also

- [DynamicForm.readOnlyDisplay](classes/DynamicForm.md#attr-dynamicformreadonlydisplay)
- [FormItem.readOnlyDisplay](classes/FormItem.md#attr-formitemreadonlydisplay)

---
## Type: RecategorizeMode

### Description
Type for controlling when a "recategorize" is applied to records being dropped on a databound component from another databound component.

### Values

| Value | Description |
|-------|-------------|
| "always" | recategorize is always applied |
| "checked" | recategorize if normal checks pass |
| "never" | never recategorize |

---
## Type: RecordComponentPoolingMode

### Description
The method of component-pooling to employ for [recordComponents](classes/ListGrid_1.md#attr-listgridshowrecordcomponents).

### Values

| Value | Description |
|-------|-------------|
| "viewport" | components are destroyed when the record is not being rendered. Best for large datasets where embedded components differ greatly per record. |
| "data" | components are [clear()ed](classes/Canvas.md#method-canvasclear) when not in the viewport, but stay with a record until the record is dropped from cache. Best for guaranteed small datasets. |
| "recycle" | components are pooled and will be passed to [updateRecordComponent()](classes/ListGrid_2.md#method-listgridupdaterecordcomponent) with the `recordChanged` parameter set to true. Best for large datasets where embedded components are uniform across different records and can be efficiently reconfigured to work with a new record |

---
## Type: RecordDropAppearance

### Description
Controls how ListGrid record drop events report their [dropPosition](classes/ListGrid_2.md#method-listgridgetrecorddropposition), and where the drop indicator will be displayed if appropriate.

### Values

| Value | Description |
|-------|-------------|
| ListGrid.OVER | When the user drops onto a record, dropPosition will always be "over" |
| ListGrid.BETWEEN | When the user drops onto a record, dropPosition will be either "before" or "after" depending on whether the mouse was over the top or bottom of the target record |
| ListGrid.BOTH | When the user drops onto a record, if the drop occurs centered over the record, the dropPosition will be reported as "over", otherwise it will be "before" or "after" depending on whether the mouse was over the top or bottom of the target record. |
| ListGrid.BODY | No dropPosition will be reported |

---
## Type: RecordLayout

### Description
Controls the style of TableView record display

### Values

| Value | Description |
|-------|-------------|
| TableView.TITLE_ONLY | Show [title field](classes/TableView.md#attr-tableviewtitlefield) only |
| TableView.TITLE_DESCRIPTION | Show [title](classes/TableView.md#attr-tableviewtitlefield) and [description](classes/TableView.md#attr-tableviewdescriptionfield) fields only |
| TableView.SUMMARY_INFO | Show [title](classes/TableView.md#attr-tableviewtitlefield), [description](classes/TableView.md#attr-tableviewdescriptionfield) and [info](classes/TableView.md#attr-tableviewinfofield) fields only |
| TableView.SUMMARY_DATA | Show [title](classes/TableView.md#attr-tableviewtitlefield), [description](classes/TableView.md#attr-tableviewdescriptionfield) and [data](classes/TableView.md#attr-tableviewdatafield) fields only |
| TableView.SUMMARY_FULL | Show [title](classes/TableView.md#attr-tableviewtitlefield), [description](classes/TableView.md#attr-tableviewdescriptionfield), [info](classes/TableView.md#attr-tableviewinfofield) and [data](classes/TableView.md#attr-tableviewdatafield) fields similar to the iPhoneOS Mail application |

---
## Type: RecordSummaryFunction

### Description
Function to produce a summary value based on field values within a record. Example usage is record-level summaries in ["summary" type ListGrid fields](#type-listgridfieldtype).

Record summary functions may be specified in one of two ways:

*   as an explicit function or executable [StringMethod](kb_topics/stringMethods.md#kb-topic-string-methods-overview). Takes 3 parameters:  
    `record` the record for which the value is being calculated  
    `fields` Array of listGridFields from which summaries should be calculated  
    `summaryField` pointer to the summary type field on which the summary function is being run.
*   The identifier of such a function or string method, either built-in or registered via [DataSource.registerRecordSummaryFunction](classes/DataSource.md#classmethod-datasourceregisterrecordsummaryfunction)

[DataSource.registerRecordSummaryFunction](classes/DataSource.md#classmethod-datasourceregisterrecordsummaryfunction) may be used to expand the set of registered record summary functions.

### Values

| Value | Description |
|-------|-------------|
| sum | Iterates through each field, picking up the numeric field values from the record and summing them. This is the default if [ListGridField.recordSummaryFunction](classes/ListGridField.md#attr-listgridfieldrecordsummaryfunction) is not specified and [ListGridField.getRecordSummary](classes/ListGridField.md#method-listgridfieldgetrecordsummary) is not implemented. |
| avg | Iterates through each field, picking up the numeric field values from the record and calculating the mean value. |
| max | Iterates through each field, picking up the numeric field values from the record and calculating the maximum value. |
| min | Iterates through each field, picking up the numeric field values from the record and calculating the minimum value. |
| multiplier | Iterates through each field, picking up the numeric field values from the record and multiplying them together. |

---
## Type: RegressionLineType

### Description
Supported regression algorithms for fitting the data points of a scatter plot.

### Values

| Value | Description |
|-------|-------------|
| "line" | linear regression |
| "polynomial" | polynomial regression |

---
## Type: RelativeDateRangePosition

### Description
When relative dates are specified in a date range, typically in a RelativeDateItem or DateRangeItem, in order to make the range inclusive or exclusive, it is useful to be able to specify whether we're referring to the start or end of the date in question.

### Values

| Value | Description |
|-------|-------------|
| "start" | Indicates this relative date should be treated as the start of the specified logical date. |
| "end" | Indicates this relative date should be treated as the end of the specified logical date. |

---
## Type: RelativeDateString

### Description
A string of known format used to specify a datetime offset. For example, a RelativeDateString that represents "one year from today" is written as `"+1y"`.

RelativeDateStrings are comprised of the following parts:

*   direction: the direction in which the quantity applies - one of + or -
*   quantity: the number of units of time to apply - a number
*   timeUnit: an abbreviated timeUnit to use - one of ms/MS (millisecond), s/S (second), mn/MN (minute), h/H (hour), d/D (day), w/W (week), m/M (month), q/Q (quarter, 3-months), y/Y (year), dc/DC (decade) or c/C (century).  
    The timeUnit is case sensitive. A lowercase timeUnit implies an exact offset, so `+1d` refers to the current date / time increased by exactly 24 hours. If the timeUnit is uppercase, it refers to the start or end boundary of the period of time in question, so `+1D` would refer to the end of the day (23:39:59:999) tomorrow, and `-1D` would refer to the start of the day (00:00:00:000) yesterday.
*   \[qualifier\]: an optional timeUnit encapsulated in square-brackets and used to offset the calculation - eg. if +1d is "plus one day", +1d\[W\] is "plus one day from the end of the current week". You may also specify another complete RelativeDateString as the \[qualifier\], which offers more control - eg, +1d\[+1W\] indicates "plus one day from the end of NEXT week".

This format is very flexible. Here are a few example relative date strings:  
`+0D`: End of today. There are often multiple ways to represent the same time using this system - for example this could also be written as `-1ms[+1D]`  
`-0D`: Beginning of today.  
`+1W`: End of next week.  
`+1w[-0W]`: Beginning of next week.  
`+1w[-0D]`: Beginning of the current day of next week.

### See Also

- [RelativeDateShortcut](#type-relativedateshortcut)

---
## Type: ReorderPosition

### Description
Controls where a drag-item should be dropped in relation to the target row

### Values

| Value | Description |
|-------|-------------|
| ListGrid.BEFORE | Drop the drag-item before the target-row |
| ListGrid.AFTER | Drop the drag-item after the target-row |
| ListGrid.OVER | Drop the drag-item over (onto) the target-row |

### Groups

- dragdrop

---
## Type: ResizeKnobPoint

### Description
Specifies the position of a resize knob with respect to its draw item.

### Values

| Value | Description |
|-------|-------------|
| "TL" | Top Left corner |
| "TR" | Top Right corner |
| "BL" | Bottom Left corner |
| "BR" | Bottom Right corner |
| "T" | Centered on the top edge |
| "B" | Centered on the bottom edge |
| "R" | Centered on the left edge |
| "L" | Centered on thie right edge |

---
## Type: RESTAuthenticationType

### Description
Enumeration of the supported authentication types for the [RestConnector](kb_topics/serverRestConnector.md#kb-topic-server-side-rest-connector) implementation. Note, all of these authentication types are secure, but only if you use HTTPS

### Values

| Value | Description |
|-------|-------------|
| "basic" | Use a "Basic" HTTP Authorization header. Requires both a [username](classes/RESTAuthentication.md#attr-restauthenticationusername) and a [password](classes/RESTAuthentication.md#attr-restauthenticationpassword), which are combined and Base64-encoded in the HTTP request header. Note, you can also use this auth type for services that allow for Basic authentication using a combination of user and long-lived API key (ie, an API key or token that is generated by the auth server and is used instead of a password for this particular client application, but does not need to be regularly renewed) |
| "bearerToken" | Use a "Bearer" HTTP Authorization header with a bearer token obtained from an OAuth 2.0 client credentials server or other auth scheme that can generate bearer tokens (also known as API tokens or API keys). This auth type can handle both long-lived tokens, such as API keys that are generated once for an application and never change, and so-called "access tokens" that are only valid for a limited period of time - usually no more than a few hours - and must be refreshed when they expire. See [RESTAuthentication.dataSource](classes/RESTAuthentication.md#attr-restauthenticationdatasource) |
| "authHeader" | Use a manually-constructed HTTP Authorization header. This auth type requires an [authentication dataSource](classes/RESTAuthentication.md#attr-restauthenticationdatasource) that returns a record containing a well-formed Authorization header value in a field called "authorizationHeader" (this can be overridden, see the authentication dataSource docs mentioned above) |

### Groups

- serverRestConnector

---
## Type: RowRangeDisplayStyle

### Description
Governs how [ListGrid.getRowRangeDisplayValue](classes/ListGrid_2.md#method-listgridgetrowrangedisplayvalue) formats the row range and row count for display

### Values

| Value | Description |
|-------|-------------|
| "full" | The [ListGrid.fullRowRangeDisplayValue](classes/ListGrid_1.md#attr-listgridfullrowrangedisplayvalue) template will be used to display both row range and row count |
| "brief" | The [ListGrid.briefRowRangeDisplayValue](classes/ListGrid_1.md#attr-listgridbriefrowrangedisplayvalue) template will be used to display both row range and row count |
| "countOnly" | The [ListGrid.getFormattedRowCount](classes/ListGrid_2.md#method-listgridgetformattedrowcount) will be displayed with no other text. |
| "rangeOnly" | The [ListGrid.getFormattedRowRange](classes/ListGrid_2.md#method-listgridgetformattedrowrange) will be displayed with no other text. |

### Groups

- rowRangeDisplay

---
## Type: SavedSearchStoredState

### Description
What should be stored by a saved search?

### Values

| Value | Description |
|-------|-------------|
| "criteria" | only criteria will be stored, even for components that are capable of storing additional viewState. |

---
## Type: ScanMode

### Description
When discovering a tree, the scanMode determines how to scan for the childrenProperty "node": take each node individually "branch": scan direct siblings as a group, looking for best fit "level": scan entire tree levels as a group, looking for best fit

### Values

| Value | Description |
|-------|-------------|
| "node" | take each node individually |
| "branch" | scan direct siblings as a group, looking for best fit |
| "level" | scan entire tree levels as a group, looking for best fit |

---
## Type: SelectionNotificationType

### Description
Enum to indicate selection change notification types. Used by [ListGrid.reselectOnUpdateNotifications](classes/ListGrid_1.md#attr-listgridreselectonupdatenotifications) and [TileGrid.reselectOnUpdateNotifications](classes/TileGrid.md#attr-tilegridreselectonupdatenotifications).

### Values

| Value | Description |
|-------|-------------|
| "none" | No selection change notification should fire |
| "selectionChanged" | [selectionChanged()](classes/ListGrid_2.md#method-listgridselectionchanged) should fire but [selectionUpdated()](classes/ListGrid_2.md#method-listgridselectionupdated) should not fire. |
| "selectionUpdated" | [selectionChanged()](classes/ListGrid_2.md#method-listgridselectionchanged) and [selectionUpdated()](classes/ListGrid_2.md#method-listgridselectionupdated) should both fire. |

---
## Type: SelectionType

### Description
Controls how an object changes state when clicked

### Values

| Value | Description |
|-------|-------------|
| StatefulCanvas.BUTTON | object moves to "down" state temporarily (normal button) |
| StatefulCanvas.CHECKBOX | object remains in "down" state until clicked again (checkbox) |
| StatefulCanvas.RADIO | object moves to "down" state, causing another object to go up (radio) |

### Groups

- state
- event handling

---
## Type: SelectItemsMode

### Description
Controls whether and when individual items are selected when clicking on a form in editMode.

### Values

| Value | Description |
|-------|-------------|
| "item" | select an individual item if the item itself it clicked on, but not its title cell |
| "itemOrTitle" | select an individual item if either the item or its title cell is clicked on. NOTE: this mode is not the default because it can be make it difficult to select the form as a whole |
| "never" | never allow selection of an individual item |

---
## Type: SendMethod

### Description
—

### Values

| Value | Description |
|-------|-------------|
| "GET" | GET method (regular URL encoding) |
| "POST" | POST method (form field encoding) |

### Groups

- communication

---
## Type: SetterPath

### Description
A path expression indicating where and how a nested Object should be updated.

A `SetterPath` is a dot-delimited list of segments, where each segment is a property name. The `SetterPath` can end in an operator that controls how the property update is done:

*   `[]` – append to an Array (creates the Array if missing)
*   `{}` – deep merge into an Object, overwriting existing keys
*   `{?}` – deep merge into an Object, preserving existing keys (non-clobbering)

This syntax is used in [Task.setState](classes/Task.md#method-tasksetstate)/[Process.setStateVariable](classes/Process.md#method-processsetstatevariable).

Missing objects and Arrays are created as needed unless [strictPaths](classes/Task.md#attr-taskstrictpaths) is set, either in the specific API call, or on the [task](classes/Task.md#attr-taskstrictpaths) or [process](classes/Process.md#attr-processstrictpaths) involved. When `strictPaths` is enabled, attempting to traverse through a non-object/Array or a missing segment throws an error instead.

#### Examples
Assume `process.state` starts as:
```
 {
     currentDS: {
         fields: [ { name:"orderId", type:"integer" } ],
         defaults: { timezone:"UTC" }
     }
 }
 
```

*   **Append**  
    `"currentDS.fields[]": { name:"orderDate", type:"date" }`  
    Result: `fields` gains a new element at the end.
*   **Deep merge (clobber)**  
    `"currentDS.defaults{}": { timezone:"PST", dateFormat:"YYYY-MM-DD" }`  
    Result: `timezone` is overwritten to "PST"; `dateFormat` is added.
*   **Deep merge (non-clobber)**  
    `"currentDS.defaults{?}": { timezone:"PST", locale:"en-US" }`  
    Result: existing `timezone:"UTC"` is preserved; `locale` is added.

---
## Type: SettledPromiseStatus

### Description
The eventual state of a settled [Promise](reference_2.md#object-promise).

### Values

| Value | Description |
|-------|-------------|
| "fulfilled" | The `Promise` fulfilled with a value. |
| "rejected" | The `Promise` rejected with a reason. |

---
## Type: SkipJSONValidation

### Description
—

### Values

| Value | Description |
|-------|-------------|
| "full" | Skip validation for all fields. In this mode, valueXPaths and getFieldValue implementations are skipped. |
| "partial" | Skip validation for fields with boolean, numeric, or string-drived types. Note that you must deliver all [DataSourceField.multiple](classes/DataSourceField.md#attr-datasourcefieldmultiple):true values as arrays. |
| "none" | Always do validation. |

---
## Type: SortArrow

### Description
Do we display an arrow for the sorted field ?

### Values

| Value | Description |
|-------|-------------|
| "none" | Don't show a sort arrow at all. |
| "corner" | Display sort arrow in the upper-right corner (above the scrollbar) only. |
| "field" | Display sort arrow above each field header only. |
| "both" | Display sort arrow above each field header AND in corner above scrollbar.BOTH:"both", // NOTE: Canvas establishes this constant |

### Groups

- sorting
- appearance

---
## Type: SortDirection

### Description
—

### Values

| Value | Description |
|-------|-------------|
| "ascending" | Sort in ascending order (e.g. A-Z; larger values later in the list) |
| "descending" | Sort in descending order (e.g. Z-A; larger values earlier in the list) |

### Groups

- sorting

---
## Type: SQLType

### Description
The types of custom query that can be handled by SmartClient's built-in "sql" and "hibernate" DataSources. Note, only applies to [OperationBinding.operationType](classes/OperationBinding.md#attr-operationbindingoperationtype) "custom".

### Values

| Value | Description |
|-------|-------------|
| "query" | The custom SQL or HQL is read-only |
| "update" | The custom SQL or HQL updates data |

### Groups

- customQuerying

---
## Type: StackPersistence

### Description
—

### Values

| Value | Description |
|-------|-------------|
| "none" | older messages disappear as if unrelated |
| "reset" | older messages have their duration timers reset so they stick around as long as the new message if they've got less time left than that message |

---
## Type: StringMethod

### Description
A String containing a valid JavaScript expression that's automatically converted to a function with a return value matching the value of the last statement.

See [stringMethods](kb_topics/stringMethods.md#kb-topic-string-methods-overview) for an example.

---
## Type: SummaryFunction

### Description
This is used for client-side or server-side summaries

*   Client-side: Function to produce a summary value based on an array of records and a field definition. An example usage is the [listGrid summary row](classes/ListGrid_1.md#attr-listgridshowgridsummary), where a row is shown at the bottom of the listGrid containing summary information about each column.
*   Server-side: Function used for getting summarized field value using [Server Summaries feature](kb_topics/serverSummaries.md#kb-topic-server-summaries) or when [Including values from multiple records](classes/DataSourceField.md#attr-datasourcefieldincludefrom)

For the client-side SummaryFunctions may be specified in one of 2 ways:

*   as an explicit function or executable [StringMethod](kb_topics/stringMethods.md#kb-topic-string-methods-overview), which will be passed `records` (an array of records) and `field` (the field definition for which the summary is required).
*   as a standard SummaryFunction identifier

For valid ways to configure SummaryFunctions to use server-side feature see the [Server Summaries overview](kb_topics/serverSummaries.md#kb-topic-server-summaries), including how to implement custom summary functions, not just builtin ones listed here (look for "Custom Aggregation" section).

### Values

| Value | Description |
|-------|-------------|
| sum | _Client:_ iterates through the set of records, picking up and summing all numeric values for the specified field. Returns null to indicate invalid summary value if any non numeric field values are encountered.  
_Server:_ acts exactly like SQL SUM function. |
| avg | _Client:_ iterates through the set of records, picking up all numeric values for the specified field and determining the mean value. Returns null to indicate invalid summary value if any non numeric field values are encountered.  
_Server:_ acts exactly like SQL AVG function. |
| max | _Client:_ iterates through the set of records, picking up all non-null values for the specified field and finding the maximum value, where comparison between values is made:

1.  via [SimpleType.compareValues](classes/SimpleType.md#method-simpletypecomparevalues) if defined for the field's [type](classes/Field.md#attr-fieldtype)
2.  via [DateUtil.compareLogicalDates](classes/DateUtil.md#classmethod-dateutilcomparelogicaldates) if the field type inherits from "date"
3.  via comparison as [logical times](classes/Time.md#classmethod-timecreatelogicaltime) if the field type inherits from "time"
4.  via [DateUtil.compareDates](classes/DateUtil.md#classmethod-dateutilcomparedates) for two values that are both [Date](reference_2.md#object-date)s
5.  otherwise, using traditional methods

Returns null to indicate an invalid summary value or when all source values are null. For best results, ensure that the [Field.type](classes/Field.md#attr-fieldtype) is correctly set.  
_Server:_ acts exactly like the SQL MAX aggregate function. |
| min | _Client:_ iterates through the set of records, picking up all non-null values for the specified field and finding the minimum value, where comparison between values is made:

1.  via [SimpleType.compareValues](classes/SimpleType.md#method-simpletypecomparevalues) if defined for the field's [type](classes/Field.md#attr-fieldtype)
2.  via [DateUtil.compareLogicalDates](classes/DateUtil.md#classmethod-dateutilcomparelogicaldates) if the field type inherits from "date"
3.  via comparison as [logical times](classes/Time.md#classmethod-timecreatelogicaltime) if the field type inherits from "time"
4.  via [DateUtil.compareDates](classes/DateUtil.md#classmethod-dateutilcomparedates) for two values that are both [Date](reference_2.md#object-date)s
5.  otherwise, using traditional methods

Returns null to indicate an invalid summary value or when all source values are null. For best results, ensure that the [Field.type](classes/Field.md#attr-fieldtype) is correctly set.  
_Server:_ acts exactly like the SQL MIN aggregate function. |
| multiplier | _Client:_ iterates through the set of records, picking up all numeric values for the specified field and multiplying them together. Returns null to indicate invalid summary value if any non numeric field values are encountered.  
_Server:_ **not supported**. |
| count | _Client:_ returns a numeric count of the total number of records passed in.  
_Server:_ acts exactly like SQL COUNT function. |
| title | _Client:_ returns `field.summaryValueTitle` if specified, otherwise `field.title`  
_Server:_ **not supported**. |
| first | _Client:_ Currently the same as the **min** function.  
_Server:_ implemented as SQL MIN function. |
| concat | _Client:_ iterates through the set of records, producing a string with each value concatenated to the end.  
_Server:_ implemented as SQL CONCAT function by the Oracle database driver; other SQL drivers perform an additional query to fetch the values for concatenation. This function is also supported for generic dataSources that do not have inherent support for aggregation - see the description of this in the [allowAggregation](classes/DataSource.md#attr-datasourceallowaggregation) documentation. Not supported by JPA or Hibernate dataSources. **Note:** This function is only supported for [DataSourceField.includeSummaryFunction](classes/DataSourceField.md#attr-datasourcefieldincludesummaryfunction); it is **not** supported in other summary contexts, such as [DSRequest.summaryFunctions](classes/DSRequest.md#attr-dsrequestsummaryfunctions). See also [joinPrefix](classes/DataSourceField.md#attr-datasourcefieldjoinprefix), [joinString](classes/DataSourceField.md#attr-datasourcefieldjoinstring) and [joinSuffix](classes/DataSourceField.md#attr-datasourcefieldjoinsuffix) related datasource field attributes. |
| array | _Client:_ The same approach as for "concat"but returning an array of the values, rather than a string concatenation  
_Server:_ The same approach as for "concat", and with the same restrictons and limitations, but returning an array of the values, rather than a string concatenation. |

### Groups

- serverSummaries

---
## Type: TaskInputExpression

### Description
A TaskInputExpression is a way to specify a value in the declarative workflow system ([Process](classes/Process.md#class-process) / [Task](classes/Task.md#class-task)) that is derived from the running [process state](classes/Process.md#attr-processstate), the [output](classes/Task.md#method-tasksetoutput) of a previous task in the process, or from global context such as [ruleScope](classes/Process.md#attr-processrulescope).

For example, in [FormEditNewRecordTask](#class-formeditnewrecordtask), `taskInputExpressions` are allowed in the [initialValues](#attr-formeditnewrecordtaskinitialvalues) specified for the task, making it very easy to build a process that fetches data from the server and populates a form with that data.

Similarly, in [GridFetchDataTask](classes/GridFetchDataTask.md#class-gridfetchdatatask), `taskInputExpressions` are allowed in the [criteria](classes/GridFetchDataTask.md#attr-gridfetchdatataskcriteria) specified for the task, as the [Criterion.value](classes/Criterion.md#attr-criterionvalue) for any criterion.

`TaskInputExpressions` are designed to be visual-tool-friendly so that it's easy to visually wire together processes in the [Workflow Editor](kb_topics/reifyAddWorkflowTask.md#kb-topic-reify-onsite-adding-custom-workflow-tasks).

A TaskInputExpression is a String prefixed with "$input", "$inputRecord", "$ruleScope", "$state" or "$last" followed by an optional dot-separated hierarchical path, which can specify either an atomic data value (String, Number) or Record from the input data. For example, if the [Process.state](classes/Process.md#attr-processstate) represented in JSON were:

```
 {
    orderId:5,
    orderItems: [
       {name:"Pencils", quantity:3, itemId:2344}
    ],
    orderUser: { name:"Henry Winkle", address:"...", ... }
 }
 
```
.. and a task specified an `inputs` of "orderId" and an inputFieldList of "orderItems","orderUser", then:

*   $input is the value 5
*   $inputRecord.orderUser.name is "Henry Winkle"
*   $inputRecord.orderItems\[0\] is the first orderItems Record ({name:"Pencils", ... })

"$ruleScope" can be used to pull values from a [ruleScope](classes/Canvas.md#attr-canvasrulescope) [ruleContext](classes/Canvas.md#method-canvasgetrulecontext) when configured in [Process.ruleScope](classes/Process.md#attr-processrulescope).

*   $ruleScope.property references the ruleContext "property" field

Two others sources of input are "$state" and "$last". The former references the contents of the [Process.state](classes/Process.md#attr-processstate) and the latter the [transient state](classes/Process.md#attr-processstate).

*   $state is the full contents of the process state
*   $state.orderId is the "orderId" field of the process state (5 from the example above)
*   $last is the full output of the previous task executed in the process
*   $last.property is the "property" field of the previous task executed in the process
*   $last\[service\].property or $last\[DSRequestTask\].property references the last "DSRequestTask" output in the "property" field
*   $ruleScope.property references the ruleScope "property" field

The last two sources of input are "$lastRequest" and "$lastResponse". These are the objects `dsRequest` and `dsResponse` representing the last [DSRequestTask](classes/DSRequestTask.md#class-dsrequesttask), [DSFetchTask](#class-dsfetchtask), [DSAddTask](#class-dsaddtask), [DSUpdateTask](#class-dsupdatetask) or [DSRemoveTask](#class-dsremovetask) DataSource operation as returned in the operation's [callback](reference_2.md#type-dscallback). A common usage would be to reference $lastResponse.totalRows to know how many rows were returned from a fetch.

#### Transient state outputs
Most tasks pass the output from the _previous_ task as their output (i.e. passed through) making it easy to refer to earlier output without referencing the task type. Tasks that work with records or interact with the user, however, typically provide task-specific output as detailed below:

*   **DSRequestTask**: the contents of dsResponse.data.
*   **ScriptTask**: the result of [execute()](classes/ScriptTask.md#method-scripttaskexecute) or, for an asynchronous task, the value passed to [setOutput()](classes/ScriptTask.md#method-scripttasksetoutput).
*   **StateTask**: the value assigned to the outputField.
*   **UserTask**: the values of the targetForm or targetVM when the task completes.
*   **AskForValueTask**: an object with "value" and "canceled" properties.
*   **FetchRelatedDataTask**: the first fetched record.
*   **GridFetchDataTask**: the contents of dsResponse.data.
*   **GridTransferSelectedTask**: the first transfered record.
*   **GridSelectRecordsTask**: on a select, the set of newly selected records, even if other records are also selected. On a deselect, the entire set of de-selected records.
*   **FetchRelatedDataTask**: the first fetched related record.
*   **FormSaveDataTask**: an object with "valuesValid" and "errors" properties.
*   **FormValidateValuesTask**: an object with "valuesValid" and "errors" properties.
*   **GetPropertiesTask**: an object with selected properties and values retrieved.

---
## Type: TextMatchStyle

### Description
For "fetch" operations, how simple search criteria should be interpreted for text fields (and to some extent numeric fields, see the notes below). For greater flexibility, use [AdvancedCriteria](#object-advancedcriteria).

### Values

| Value | Description |
|-------|-------------|
| "exact" | case-insensitive exact match ("foo" matches "foo" and "FoO", but not "FooBar") |
| "exactCase" | case-sensitive exact match ("foo" matches only "foo") |
| "substring" | case-insenstive substring match ("foo" matches "foobar" and "BarFoo") |
| "startsWith" | case-insensitive prefix match ("foo" matches "FooBar" but not "BarFoo")

textMatchStyle behavior is consistent across the client and all three of the built-in server DataSource implementations - SQL, Hibernate and JPA - to the maximum extent that is practical. Known inconsistencies, some of which can be tweaked with configuration settings, are described below

*   textMatchStyle can be disabled for any individual field with the [DataSourceField.ignoreTextMatchStyle](classes/DataSourceField.md#attr-datasourcefieldignoretextmatchstyle) declaration. This behavior is consistent across client and server implementations, with the proviso that case-sensitive behavior is inherently inconsistent in the server-side implementations (see below for a more detailed discussion of this)
*   textMatchStyle is forced to "exactCase" for [primaryKey](classes/DataSourceField.md#attr-datasourcefieldprimarykey) fields on `update` and `remove` operations, unless [OperationBinding.allowMultiUpdate](classes/OperationBinding.md#attr-operationbindingallowmultiupdate) is in force. This means that a normal update or remove operation - which is constrained by a unique primaryKey value or combination, to affect only a single data row - will use an equality match on all primaryKey fields. This is desirable because it makes index usage more likely. Note that this means the key values "foo" and "FOO" are distinct, which is a change from previous behavior. For most databases, this change will have no effect because most databases do not by default allow primaryKey values that only differ in case anyway - if a table has a row with a PK of "foo" and you try to insert a row with a PK of "FOO", most databases will fail with a constraint violation. However, if you are using a database hat allows key values that differ only in case, and you need to support this for some reason, you can switch the framework back to the previous behavior by setting property `allow.case.sensitive.pks` to `true` in your `server.properties` file. Note, we do not recommend this; in fact, we do not recommend the use of text primaryKey fields at all. Where you have control ,we would always recommend the use of automatically incrementing numeric sequence keys.
*   textMatchStyle does not apply to boolean or temporal (date, datetime, time) [field types](classes/DataSourceField.md#attr-datasourcefieldtype). Such fields are always checked for equality. If you have a need for more complex matching, such as date-range checking, use AdvancedCriteria
*   Critiera values for temporal fields **must** be real dates (Javascript `Date` objects on the client, instances of `java.util.Date` on the server). Attempting to match against a string or any other type of value will result in an "always fails" clause being generated. This behavior is how the client code has always worked, but is a change for the server-side DataSources, in the interests of consistency. The previous behavior was:
    *   SQLDataSource used to attempt to match the date column to the criteria value provided; if that value was an appropriately-formatted string, that attempt _might_ have worked, but it would be database-specific. If you have an application that depends on this old behavior, you can switch it back on by adding the following to your `server.properties` file: `sql.temporal.fields.require.date.criteria: false`
    *   HibernateDataSource and JPADataSource used to skip such clauses altogether, which results in the opposite behavior (there is an implied "always succeeds" clause, because the clause is not present in the query at all). If you have an application that depends on this old behavior, you can switch it back on by adding the following to your `server.properties` file: `jpa.temporal.fields.require.date.criteria: false` or `hibernate.temporal.fields.require.date.criteria: false`, as appropriate
*   textMatchStyle does not apply to fields used in the joins generated to satisfy [includeFrom](classes/DataSourceField.md#attr-datasourcefieldincludefrom) declarations or entity relations in Hibernate or JPA. Again, such comparisons are always for equality
*   textMatchStyle is applied to numeric fields **only** if the supplied criteria value is a string. So for a numeric field "myNumber", we will match 10, 100, 110 and 1000 if a criteria value of "10" (the quoted string) is supplied, but we will only match 10 if a criteria value of 10 (the actual number) is supplied
    *   This is a change in behavior for the server-side DataSource implementations, in the interests of consistency with the client behavior. Previously, all three of the built-in DataSource implementations applied textMatchStyle to numeric fields regardless of the criteria value's type. If you have an application that depends on this old behavior, you can switch it back on by adding the following to your `server.properties` file: `sql.substring.numeric.criteria: true` or `hibernate.substring.numeric.criteria: true` or `jpa.substring.numeric.criteria: true`, as appropriate
*   "exactCase" matching cannot be made consistent across all database providers because each database has its own idea of whether case-sensitive matching should be the default, and how to switch it on and off (if that is even possible)
    *   Microsoft SQL Server must have case-sensitive matching enabled by setting a case-sensitive collation when the database is created (there are more fine-grained options, but we do not recommend them because of the scope for further inconsistency, where "exactCase" works correctly on table A but not on table B). See [MSDN](http://msdn.microsoft.com/en-us/library/ms175835.aspx) for details
    *   HSQLDB has case sensitivity set with the `SET IGNORECASE` directive - [see here](http://www.hsqldb.org/doc/guide/ch09.html#set_ignorecase-section)
    *   MySQL is case-insensitive, but since it provides an easy way to do per-query, case-sensitive matching in SQL, we work around it for that database, but **only** in SQL DataSources
*   If you are using Hibernate or JPA, whether "exactCase" works as expected depends entirely on the underlying database. Unlike the SQL DataSource, where we have fine-grained control of the SQL that the database executes, we are constrained by what the ORM will allow. This prevents us from compensating for database quirks, like we do with MySQL's case-insensitivity in the SQL DataSource |

---
## Type: TieMode

### Description
what to do if there is more than one possible childrenProperty when using scanMode "branch" or "level" "node": continue, but pick childrenProperty on a per-node basis (will detect mixed) "highest": continue, picking the childrenProperty that occurred most as the single choice "stop": if there's a tie, stop at this level (assume no further children)

### Values

| Value | Description |
|-------|-------------|
| "node" | continue, but pick childrenProperty on a per-node basis (will detect mixed) |
| "highest" | continue, picking the childrenProperty that occurred most as the single choice |
| "stop" | if there's a tie, stop at this level (assume no further children) |

---
## Type: TimeDisplayFormat

### Description
String designating a standard time format for displaying the times associated with dates strings.

### Values

| Value | Description |
|-------|-------------|
| toTime | String will display with seconds and am/pm indicator:`[H]H:MM:SS am|pm`.  
Example: `3:25:15 pm` |
| to24HourTime | String will display with seconds in 24 hour time: `[H]H:MM:SS`.  
Example: `15:25:15` |
| toPaddedTime | String will display with seconds, with a 2 digit hour and am/pm indicator: `HH:MM:SS am|pm`  
Example: `03:25:15 pm` |
| toPadded24HourTime | String will display with seconds, with a 2 digit hour in 24 hour format: `HH:MM:SS`  
Examples: `15:25:15`, `03:16:45` |
| toShortTime | String will have no seconds and be in 12 hour format:`[H]H:MM am|pm`  
Example: `3:25 pm` |
| toShort24HourTime | String will have no seconds and be in 24 hour format: `[H]H:MM`  
Example:`15:25` |
| toShortPaddedTime | String will have no seconds and will display a 2 digit hour, in 12 hour clock format: `HH:MM am|pm`  
Example: `03:25 pm` |
| toShortPadded24HourTime | String will have no seconds and will display with a 2 digit hour in 24 hour clock format: `HH:MM`  
Examples: `15:25`, `03:16` |

---
## Type: TimeUnit

### Description
An enum of time-units available for use with the [RelativeDateItem](classes/RelativeDateItem.md#class-relativedateitem), [TimeItem](classes/TimeItem.md#class-timeitem) and [Calendar](classes/Calendar.md#class-calendar) widgets.

### Values

| Value | Description |
|-------|-------------|
| "millisecond" | a millisecond time-unit |
| "second" | a second time-unit |
| "minute" | a minute time-unit |
| "hour" | an hour time-unit |
| "day" | a day time-unit |
| "week" | a week time-unit |
| "month" | a month time-unit |
| "quarter" | a quarter (3 month) time-unit |
| "year" | a year time-unit |

---
## Type: TitleAlign

### Description
Supported positioning of the chart Title.

### Values

| Value | Description |
|-------|-------------|
| "left" | Align to the left of the chart title header |
| "center" | Align centrally in the chart title header |
| "right" | Align to the right of the chart title header |

### Groups

- chartTitle

---
## Type: TitleOrientation

### Description
Orientation of titles relative to the FormItem being labeled. Can be set a the DynamicForm level as a default, or on individual items.

### Values

| Value | Description |
|-------|-------------|
| "left" | — |
| "top" | — |
| "right" | — |

### Groups

- formTitles

### See Also

- [DynamicForm.titleOrientation](classes/DynamicForm.md#attr-dynamicformtitleorientation)
- [FormItem.titleOrientation](classes/FormItem.md#attr-formitemtitleorientation)

---
## Type: TitleRotationMode

### Description
The different ways in which the [titleLabel](classes/DrawItem.md#attr-drawitemtitlelabel) of a [DrawItem](classes/DrawItem.md#class-drawitem) can be rotated with the item.

**NOTE:** The effect of the "withItemAlwaysUp" and "withLineAlwaysUp" settings is not affected by the global rotation, if any (see [DrawPane.rotation](classes/DrawPane.md#attr-drawpanerotation)).

### Values

| Value | Description |
|-------|-------------|
| "neverRotate" | the `titleLabel` is never rotated with the item. |
| "withItem" | the `titleLabel` is rotated exactly to match the item's rotation (see [DrawItem.rotation](classes/DrawItem.md#attr-drawitemrotation)). |
| "withItemAlwaysUp" | the `titleLabel` is rotated exactly to match the item's rotation, except that at certain rotations, the `titleLabel` is flipped by 180° so that the title text is never upside down. |
| "withLine" | (applies only to [DrawLine](classes/DrawLine.md#class-drawline) and [DrawLinePath](classes/DrawLinePath.md#class-drawlinepath)) the `titleLabel` is rotated to match the line or center segment.

If used on a `DrawItem` that is not a `DrawLine` or `DrawLinePath`, then the effect is the same as "withItem". |
| "withLineAlwaysUp" | (applies only to [DrawLine](classes/DrawLine.md#class-drawline) and [DrawLinePath](classes/DrawLinePath.md#class-drawlinepath)) the `titleLabel` is rotated to match the line or center segment, except that at certain rotations, the `titleLabel` is flipped by 180° so that the title text is never upside down.

If used on a `DrawItem` that is not a `DrawLine` or `DrawLinePath`, then the effect is the same as "withItemAlwaysUp". |

---
## Type: TreeGridOpenState

### Description
An object containing the open state for a treeGrid. Note that this object is not intended to be interrogated directly, but may be stored (for example) as a blob on the server for state persistence across sessions.

### Groups

- viewState

---
## Type: UnionFieldsStrategy

### Description
The strategy used when auto-deriving the fields that make up a UnionDataSource, if no [unionFields](classes/DataSource.md#attr-datasourceunionfields) setting is provided.

### Values

| Value | Description |
|-------|-------------|
| "intersect" | Only create a unioned field where all of the member dataSources have a field with the same name and data type |
| "matching" | Create a unioned field where at least two of the member dataSources have a field with the same name and data type. Any member dataSources that do not have the field will contribute a null value for that field in the unioned dataset |
| "all" | Create a unioned field for every field contributed by every member dataSource. Where there are matching fields on other dataSource(s), we will union the fields as described for "matching". Where a field only exists on one dataSource, all other dataSources will contribute null for that field in the unioned dataset |

### See Also

- [DataSource.unionFields](classes/DataSource.md#attr-datasourceunionfields)

---
## Type: URL

### Description
A Uniform Resource Locator string, as defined by [https://www.w3.org/Addressing/URL/url-spec.html](https://www.w3.org/Addressing/URL/url-spec.html). For example, "https://www.smartclient.com/product/" is a valid `URL`.

---
## Type: ValidationMode

### Description
Mode of validation used for running validation on partially entered data.

### Values

| Value | Description |
|-------|-------------|
| "full" | Assume provided data is complete and run all validation rules |
| "partial" | Validate only the data values that are present ignoring the absence of required fields, validators that refer to fields that are not present, and any conditional validators dependent on fields that are not present. |

---
## Type: ValueClass

### Description
—

### Values

| Value | Description |
|-------|-------------|
| "general" | Any kind of data. Usually this is textual, but not necessarily always so. An example would be a "2-4 sentence summary". |
| "categorical" | A fixed list of categories or nominal values. |
| "ordinal" | An extension of "categorical", where the categories are also strictly ordered. |
| "interval" | Strictly numerical data. |
| "ratio" | An extension of "interval", where 0 means the absence of something, and ratios between values are meaningful. |

---
## Type: ValueMap

### Description
A ValueMap defines the set of legal values for a field, and optionally allows you to provide a mapping from stored values to values as seen by the end user.

A valueMap can be specified as either an Array of legal values, or as an [Object](#type-object) where each property maps a stored value to a user-displayable value. See [DataSourceField.valueMap](classes/DataSourceField.md#attr-datasourcefieldvaluemap) for how to express a ValueMap in [Component XML](kb_topics/componentXML.md#kb-topic-component-xml).

A ValueMap can be entirely static or entirely dynamic, with many options in between. For example, a ValueMap may be:

*   statically defined in a JavaScript or XML file. Such a valueMap changes only when application code is upgraded.
*   generated dynamically by server code when the application first loads, for example, by generating JavaScript or XML dynamically in a .jsp or .asp file. Such a valueMap may be different for each session and for each user.
*   loaded on demand from a DataSource, via the [optionDataSource](classes/PickList.md#attr-picklistoptiondatasource) property, or via a call to [DataSource.fetchData](classes/DataSource.md#method-datasourcefetchdata) where a valueMap is derived dynamically from the returned data (see [DataSource.fetchData](classes/DataSource.md#method-datasourcefetchdata) for an example). Such a valueMap may be updated at any time, for example, every time the user changes a related field while editing data.

See also the [SmartClient Architecture Overview](kb_topics/smartArchitecture.md#kb-topic-smartclient-architecture) to understand the best architecture from a performance and caching perspective.

---
## Type: VelocityExpression

### Description
An expression in the [Velocity Template Language](http://velocity.apache.org/engine/releases/velocity-1.7/user-guide.html) (VTL). For more information on SmartClient's Velocity support, see [Velocity support](kb_topics/velocitySupport.md#kb-topic-velocity-context-variables).

Note that a `VelocityExpression` must often evaluate to a particular type of value to be useful. For example, [DataSource.requires](classes/DataSource.md#attr-datasourcerequires) must evaluate to true or false (Boolean objects or strings containing those two words), and [Mail.messageData](classes/Mail.md#attr-mailmessagedata) must evaluate to a Java `Map` object, or a Java `List` containing only `Map`s.

### Groups

- velocitySupport

---
## Type: ViewName

### Description
The names of the Calendar views.

### Values

| Value | Description |
|-------|-------------|
| "day" | day view |
| "week" | week view |
| "month" | month view |
| "timeline" | timeline view |

---
## Type: Visibility

### Description
—

### Values

| Value | Description |
|-------|-------------|
| Canvas.INHERIT | The widget visibility will match that of its parent (usually visible). |
| Canvas.VISIBLE | The widget will always be visible whether its parent is or not. |
| Canvas.HIDDEN | The widget will always be hidden even when its parent is visible. |

### Groups

- visibility

---
## Type: WaitForType

### Description
—

### Values

| Value | Description |
|-------|-------------|
| "duration" | wait for a specific amount of time |
| "systemDone" | wait for the page to become quiet as reported by [AutoTest.isSystemDone](classes/AutoTest.md#classmethod-autotestissystemdone). |
| "locator" | wait for a specific [AutoTestLocator](reference_2.md#type-autotestlocator) to become ready. |

---
## Type: ZoomStartPosition

### Description
—

### Values

| Value | Description |
|-------|-------------|
| "start" | start at the beginning of the range |
| "end" | start at the end of the range |

### Groups

- zoom

---
## Object: AdaptiveMenuItem

### Description
Object extending [MenuItem](reference_2.md#object-menuitem) and specifying an item in an [AdaptiveMenu](classes/AdaptiveMenu.md#class-adaptivemenu). As with `MenuItems` each `AdaptiveMenuItem` can have a [title](classes/MenuItem.md#attr-menuitemtitle), [icon](classes/MenuItem.md#attr-menuitemicon), [shortcut keys](classes/MenuItem.md#attr-menuitemkeys), optional [MenuItem.submenu](classes/MenuItem.md#attr-menuitemsubmenu) and various other settings, including arbitrary widgets via [MenuItem.embeddedComponent](classes/MenuItem.md#attr-menuitemembeddedcomponent).

Additionally, an `AdaptiveMenuItem` may be displayed either as an item in a regular [Menu](classes/Menu.md#class-menu) or as a [button in a toolstrip](classes/AdaptiveMenu.md#attr-adaptivemenuinlinemenuitem) and will adapt it's appearance according to layout and available space.

As a result of that behavior, the _menu_ parameter passed to methods like [AdaptiveMenuItem.click](classes/AdaptiveMenuItem.md#method-adaptivemenuitemclick) may be null if this item is not currently displayed in a menu. In such cases, developers may call [item.getAdaptiveMenu()](classes/AdaptiveMenuItem.md#method-adaptivemenuitemgetadaptivemenu).

---
## Object: AIContext

### Description
Context object for an AI process.

---
## Object: AIFieldRequest

### Description
Settings that configure requests to AI to generate the values for a field.

---
## Object: AIHoverRequest

### Description
Settings that configure requests to AI to generate the contents of hovers.

---
## Object: AIProgressMessage

### Description
A message relating to progress made in an ongoing build-via-AI operation.

---
## Object: AIResponse

### Description
Represents a response from AI.

---
## Object: Array

### Description
Generic extensions to JavaScript Arrays. You can call these on any Array.

JavaScript's native Array is retrofitted to support the `List` API.

### See Also

- [List](reference_2.md#interface-list)

---
## Object: Boolean

### Description
Boolean object. Attributes, parameters, or return values declared as `Boolean` may be null. Contrast with [boolean](#type-boolean).

---
## Object: BuildHilitesContext

### Description
—

### See Also

- [AI.buildHilites](#classmethod-aibuildhilites)

---
## Object: ClassFactory

### Description
Sets up a real inheritance structure for Javascript objects. We separate out class objects from prototypes, so each gets its own inheritance chain. This allows us to set up superclass calls, maintain class vs. instance variables and more! The ClassFactory is a singleton object that holds the miscellaneous pieces of our inheritance mechanism. Your main interaction with the ClassFactory is to create new classes: `ClassFactory.defineClass("MyClass", "mySuperClass");`

### See Also

- [Class](classes/Class.md#class-class)

---
## Object: ColorStop

### Description
An object containing properties that is used in Gradient types

---
## Object: CoTHistoryEntry

### Description
Any serializable JavaScript Object can be added to the history via [CoTProcess.addHistory](classes/CoTProcess.md#method-cotprocessaddhistory). See [CoTHistory](kb_topics/CoTHistory.md#kb-topic-cothistory) for details on what automatic entries are created by built-in features and how history is used in prompt assembly.

---
## Object: CoTTransition

### Description
Declares an allowed transition to another task.

---
## Object: Criterion

### Description
An object representing a criterion to apply to a record.

A criterion is part of the definition of an [AdvancedCriteria](#object-advancedcriteria) object, which is used to filter records according to search criteria.

A criterion consists of an [Criterion.operator](classes/Criterion.md#attr-criterionoperator) and typically a [fieldName](classes/DataSourceField.md#attr-datasourcefieldname) from a [Record](#object-record) and a [value](classes/Criterion.md#attr-criterionvalue) to compare to. However some operators either don't require a value (eg, isNull) or act on other criteria rather than directly on a [Record](#object-record)'s fields (eg, the "and" and "or" logical operators). Also, it is possible to specify a [Criterion.fieldQuery](classes/Criterion.md#attr-criterionfieldquery) instead of a `fieldName` and/or a [Criterion.valueQuery](classes/Criterion.md#attr-criterionvaluequery) instead of a `value`

A shortcut form is also allowed where only `fieldName` and `value` values are provided. In this case the `operator` is assumed to be "equals".

### Groups

- advancedFilter

---
## Object: DataQuestion

### Description
Represents a data question and either the steps taken in attempting to answer it or the result.

### Groups

- answerEngine

---
## Object: DataQuestionResult

### Description
The result of the data question.

---
## Object: DataSourceField

### Description
Metadata about a DataSourceField, including its type and validators.

---
## Object: Date

### Description
Extensions to the Date class, including added static methods on the Date object, and additional instance methods available on all date instances.

---
## Object: DateRange

### Description
A JavaScript object specifying a range of dates. Values are [start](#attr-daterangestart) and [end](#attr-daterangeend). If either value is omitted, the range is assumed to be open-ended in that direction - so if dateRange.start is omitted, the range will include any date earlier than the value specified in dateRange.end.

---
## Object: DebugOverflowSettings

### Description
Configuration to control how excessive overflow is reported when you're [debugging overflow](classes/Canvas.md#classmethod-canvasstartdebuggingoverflow).

The general approach is that we track a maximum of [maxTrackedOverflows](classes/DebugOverflowSettings.md#attr-debugoverflowsettingsmaxtrackedoverflows) per canvas across a period of [trackingDuration](classes/DebugOverflowSettings.md#attr-debugoverflowsettingstrackingduration), and if a canvas overflows more than [selfOverflowThreshold](classes/DebugOverflowSettings.md#attr-debugoverflowsettingsselfoverflowthreshold) times not due to any child (checked by looking at the [visible rect](classes/Canvas.md#method-canvasgetvisiblewidth) of each child, then we log a message from the affected canvas reporting the threshold was exceeded.

### See Also

- [Canvas.startDebuggingOverflow](classes/Canvas.md#classmethod-canvasstartdebuggingoverflow)
- [Canvas.stopDebuggingOverflow](classes/Canvas.md#classmethod-canvasstopdebuggingoverflow)

---
## Object: DecisionBranch

### Description
Identifies a potential branch within a [MultiDecisionTask](classes/MultiDecisionTask.md#class-multidecisiontask). Each decision has a criteria and a target ProcessElement ID.

---
## Object: DiscoverTreeSettings

### Description
Defines a set of properties that specify how the tree will be explored by [Tree.discoverTree](classes/Tree.md#classmethod-treediscovertree)

---
## Object: DOMElement

### Description
Represents a native DOM element used by the browser.

For example, you can retrieve the DOM element representing the "Set Data" button from ["Empty Grid" Sample](https://www.smartclient.com/smartclient/showcase/?id=emptyGrid) in the SmartClient Feature Explorer using [AutoTest.getElement](classes/AutoTest.md#classmethod-autotestgetelement):

```
 var buttonElement = isc.AutoTest.getElement("scLocator=//testRoot[]/child[Class=IButton||index=1||length=3||classIndex=0||classLength=2||roleIndex=0||roleLength=2||title=Set%20Data||scRole=button]/");
```
This is a more robust way to obtain a DOM element than retreiving it by ID:
```
 var buttonElement = document.getElementById("isc_FZ")
```

### See Also

- [usingSelenium](kb_topics/usingSelenium.md#kb-topic-using-selenium-scripts-selenese)

---
## Object: DrawnValue

### Description
Returns information about how a data value is rendered in a chart.

---
## Object: DSLoadSettings

### Description
Settings to control optional [DataSource loading](classes/DataSource.md#classmethod-datasourceload) features.

### See Also

- [DataSource.load](classes/DataSource.md#classmethod-datasourceload)

---
## Object: DSRequest

### Description
Request sent to the server to initiate a [DataSource operation](kb_topics/dataSourceOperations.md#kb-topic-datasource-operations). All properties which are legal on [RPCRequest](#object-rpcrequest) are legal, in addition to the properties listed here.

### See Also

- [RPCRequest](#object-rpcrequest)

---
## Object: DSRequestModifier

### Description
An object that modifies a dsRequest based on several available values, including preceding responses from the same queue.

**Some elements of this feature are only available with Power or better licenses.** See [smartclient.com/product](http://smartclient.com/product) for details.

You provide a list of DSRequestModifiers as the [OperationBinding.criteria](classes/OperationBinding.md#attr-operationbindingcriteria) or [OperationBinding.values](classes/OperationBinding.md#attr-operationbindingvalues) of an [OperationBinding](classes/OperationBinding.md#class-operationbinding). The ability to modify a request based on responses to earlier requests in the same queue is called [transactionChaining](kb_topics/transactionChaining.md#kb-topic-transaction-chaining).

A DSRequestModifier consists of a [fieldName](classes/DSRequestModifier.md#attr-dsrequestmodifierfieldname), usually a [value](classes/DSRequestModifier.md#attr-dsrequestmodifiervalue) and possibly an [operator](classes/DSRequestModifier.md#attr-dsrequestmodifieroperator) and [start](classes/DSRequestModifier.md#attr-dsrequestmodifierstart) and/or [end](classes/DSRequestModifier.md#attr-dsrequestmodifierend) values (applicable to advanced criteria only). The value, start and end settings can be static, or - with Power or better licenses - they can be expressions in the Velocity template language, which will be resolved at runtime, immediately before the DSRequest is executed.

In addition to the standard [Velocity variables](kb_topics/velocitySupport.md#kb-topic-velocity-context-variables), special Velocity variables are available for the _value_ field when used in a `<values>` declaration - see [DSRequestModifier.value](classes/DSRequestModifier.md#attr-dsrequestmodifiervalue) for details.

See below some examples of [OperationBinding.criteria](classes/OperationBinding.md#attr-operationbindingcriteria) declarations:

```
  <operationBindings>
      <operationBinding operationType="fetch" operationId="...">
          <criteria fieldName="lifeSpan" value="10"/>
          <criteria fieldName="scientificName" value="Gazella thomsoni"/>
      </operationBinding>
      
      <operationBinding operationType="fetch" operationId="...">
          <criteria fieldName="lifeSpan" operator="greaterThan" value="10" />
      </operationBinding>
  
      <operationBinding operationType="fetch" operationId="...">
          <criteria _constructor="AdvancedCriteria" operator="or">
              <criteria>
                  <Criterion fieldName="lifeSpan" operator="greaterThan" value="10" />
                  <Criterion fieldName="scientificName" operator="contains" value="Octopus" />
              </criteria>
          </criteria>
      </operationBinding>
  </operationBindings>
 
```

And an example of [OperationBinding.values](classes/OperationBinding.md#attr-operationbindingvalues) declarations:

```
 <operationBinding operationType="add">
     <values fieldName="orderID" value="$responseData.last('queuedAdd_order','add').orderID" />
 </operationBinding>
 
```

DSRequestModifiers are intended partly as a security mechanism, so like [Declarative Security](kb_topics/declarativeSecurity.md#kb-topic-declarative-security) features, they apply to requests from browsers, but by default do not apply to requests initiated by server code. To have DSRequestModifiers apply to a server-initiated DSRequest, use either setRPCManager() or setClientRequest().

See the [Master/Detail Add Example](https://www.smartclient.com/smartclient-latest/showcase/?id=queuedAdd) to see this in action.

### Groups

- transactionChaining

---
## Object: Field

### Description
Base type representing a field.

Field container implementations may extend this type with additional attributes and/or methods. For example, [DataSource](classes/DataSource.md#class-datasource) uses [DataSourceField](reference_2.md#object-datasourcefield), [DataBoundComponent](#interface-databoundcomponent) uses [DBCField](#object-dbcfield), and [ListGrid](classes/ListGrid_1.md#class-listgrid) uses [ListGridField](reference_2.md#object-listgridfield) (itself an extension of `DBCField`).

In general, `Field` instances should not be shared with multiple field containers.

---
## Object: FileLoader

### Description
This class enables background (deferred) loading and caching of JS, CSS and Image files. It is designed to work standalone from the rest of the SmartClient framework to provide a lightweight caching and loading mechanism for SmartClient modules as well as user-built application modules/fragments.

The most common usage scenarios are:

*   Caching JS, CSS, Image files in the browser in anticipation of a transition to a page that requires these files. For example, a plain HTML (non-SmartClient) login page or landing page can begin caching SmartClient in the background while allowing the user to login, or giving the user something to read. Normally, loading SmartClient or other large JavaScript files would block page loading and display. By loading SmartClient in the background only after a simple HTML landing page has loaded, you can completely eliminate perceived download time associated with loading a rich UI application, making a much larger difference in user experience than any difference in framework/application size.
*   Loading a multi-phase UI. In this scenario, an initial rendering of a page is done with minimal data transfer to the browser. Then JS, CSS, and Image files are fetched in the background to provide richer UI components. During this time the user can continue to normally interact with the initial page. Once loading is complete, the UI is updated with richer components.

The recommended usage pattern is to use the `loadISC` custom tag provided as part of the SmartClient SDK. You can specify `cacheOnly="true"` to loadISC to cache the SmartClient framework in the background or alternately `defer="true"` to load the SmartClient framework and make it available in the current page. You can specify the `onload` attribute of the tag to provide a JavaScript callback to your code that will be called when the framework loading is complete.

If you're not working in a JSP environment, you can use the [FileLoader.cache](classes/FileLoader.md#classmethod-fileloadercache)/[FileLoader.load](classes/FileLoader.md#classmethod-fileloaderload) APIs to accomplish the same effect as the `loadISC` JSP tag.

Additional APIs are provided for performing dynamic caching and loading of other JS, CSS, and Image files to improve the performance of your application. See below.

**You must set `window.isomorphicDir` before loading and using this module unless the default of '../isomorphic/' is acceptable. E.g. if your html file is in your toplevel webroot directory, then your HTML file should say (note the trailing slash):**

```
 <SCRIPT>window.isomorphicDir='isomorphic/'</SCRIPT>
 <SCRIPT SRC=isomorphic/system/modules/ISC_FileLoader.js></SCRIPT>
 
```
In addition, **if you are using Smart GWT**, you must set [modulesDir](classes/FileLoader.md#classattr-fileloadermodulesdir) to "modules/", as follows:
```
   isc.FileLoader.modulesDir = "modules/";
 
```
This module is usable independent of the rest of SmartClient - you can use it on pages that don't load any other modules. In practice, the general pattern is to use this module on static HTML pages such as a login page to pre-cache SmartClient modules, application logic, skin files, and css so that once the user logs in, there's no latency to load the rich UI.

You can also load the FileLoader itself dynamically - see [FileLoader.ensureLoaded](classes/FileLoader.md#classmethod-fileloaderensureloaded)

Note: You can also reference this class via the alias isc.FL

---
## Object: FilterViaAISettings

### Description
Settings to use for filtering a [DataBoundComponent](#interface-databoundcomponent) via AI.

---
## Object: FiscalYear

### Description
An object representing the start of a given Fiscal Year in the current locale.

See [FiscalCalendar](#object-fiscalcalendar) for more information on how FiscalYears are set up and used.

---
## Object: FormItemEventInfo

### Description
An object containing details for mouse events occurring over a FormItem.

---
## Object: GaugeSector

### Description
Represents a sector on the gauge.

---
## Object: Gradient

### Description
Defines a simple gradient vertical gradient between [two](#attr-gradientstartcolor) [colors](#attr-gradientendcolor), or using [colorStops](#attr-gradientcolorstops). See [SimpleGradient](#object-simplegradient), [LinearGradient](#object-lineargradient) and [RadialGradient](#object-radialgradient) for further properties to define more advanced gradients.

---
## Object: GroupSpecifier

### Description
A Javascript object defining the details of a single group operation. Used by the [MultiGroupDialog](classes/MultiGroupDialog.md#class-multigroupdialog) to edit multi-level grouping scenarios for use by components that support grouping.

### Groups

- grouping

---
## Object: GroupSummary

### Description
Group Summary.

---
## Object: HeaderLevel

### Description
Defines one level of headers shown above the event area in a [Timeline](#class-timeline).

---
## Object: HeaderSpan

### Description
A header span appears as a second level of headers in a ListGrid, spanning one or more ListGrid columns and their associated headers.

See [ListGrid.headerSpans](classes/ListGrid_1.md#attr-listgridheaderspans).

In addition to the properties documented here, all other properties specified on the headerSpan object will be passed to the [create()](classes/Class.md#classmethod-classcreate) method of the [ListGrid.headerSpanConstructor](classes/ListGrid_1.md#attr-listgridheaderspanconstructor). This allows you to set properties such as [Button.baseStyle](classes/Button.md#attr-buttonbasestyle) or [StretchImgButton.src](classes/StretchImgButton.md#attr-stretchimgbuttonsrc) directly in a `headerSpan`.

### Groups

- headerSpan

---
## Object: Hilite

### Description
An object representing a user-created and user-modifiable hilite, which can be created and edited with a [HiliteEditor](classes/HiliteEditor.md#class-hiliteeditor) either directly or via the [ListGrid.canEditHilites](classes/ListGrid_1.md#attr-listgridcanedithilites) behavior.

See [hiliting](kb_topics/hiliting.md#kb-topic-hiliting) for an overview.

### Groups

- hiliting

---
## Object: HiliteViaAIResult

### Description
The result of a hilite-via-AI operation.

---
## Object: HiliteViaAISettings

### Description
Settings to use for hiliting a [DataBoundComponent](#interface-databoundcomponent) via AI.

---
## Object: ImgHTMLProperties

### Description
A set of properties that define settings for use in image HTML.

At minimum, an `ImgHTMLProperties` object should include a _src_ and, in most cases, _width_ and _height_ properties in order to render in a controlled manner.

---
## Object: ListGridField

### Description
An ordinary JavaScript object containing properties that configures the display of and interaction with the columns of a [ListGrid](classes/ListGrid_1.md#class-listgrid).

### See Also

- [ListGrid.fields](classes/ListGrid_1.md#attr-listgridfields)
- [ListGrid.setFields](classes/ListGrid_2.md#method-listgridsetfields)

---
## Object: ListGridRecord

### Description
A ListGridRecord is a JavaScript Object whose properties contain values for each [ListGridField](reference_2.md#object-listgridfield). A ListGridRecord may have additional properties which affect the record's appearance or behavior, or which hold data for use by custom logic or other, related components.

For example a ListGrid that defines the following fields:

```
 fields : [
     {name: "field1"},
     {name: "field2"}
 ],
 
```
Might have the following data:

```
 data : [
     {field1: "foo", field2: "bar", customProperty:5},
     {field1: "field1 value", field2: "field2 value", enabled:false}
 ]
 
```
Each line of code in the `data` array above creates one JavaScript Object via JavaScript [object literal](#type-objectliteral) notation. These JavaScript Objects are used as ListGridRecords.

Both records shown above have properties whose names match the name property of a ListGridField, as well as additional properties. The second record will be disabled due to `enabled:false`; the first record has a property "customProperty" which will have no effect by default but which may be accessed by custom logic.

After a ListGrid is created and has loaded data, records may be accessed via [listGrid.getData()](classes/ListGrid_1.md#attr-listgriddata), for example, listGrid.getData().get(0) retrieves the first record. [ListGrid.data](classes/ListGrid_1.md#attr-listgriddata) may be a [ResultSet](classes/ResultSet.md#class-resultset) if the listGrid is bound to a DataSource. ListGridRecords are also passed to many events, such as [cellClick()](classes/ListGrid_2.md#method-listgridcellclick).

A ListGridRecord is always an ordinary JavaScript Object regardless of how the grid's dataset is loaded (static data, java server, XML web service, etc), and so supports the normal behaviors of JavaScript Objects, including accessing and assigning to properties via dot notation:

```
     var fieldValue = record.fieldName;
     record.fieldName = newValue;
 
```

Note however that simply assigning a value to a record won't cause the display to be automatically refreshed - [ListGrid.refreshCell](classes/ListGrid_2.md#method-listgridrefreshcell) needs to be called. Also, consider [editValues vs saved values](kb_topics/editing.md#kb-topic-grid-editing) when directly modifying ListGridRecords.

See the attributes in the API tab for the full list of special properties on ListGridRecords that will affect the grid's behavior.

---
## Object: ListProperties

### Description
Configuration of an HTML list in a [RichTextEditor](classes/RichTextEditor.md#class-richtexteditor).

---
## Object: LoadProjectSettings

### Description
LoadProjectSettings is the bundle of settings that can be passed to loadProject() as the "settings" argument, including optional http parameters for the request to [ProjectLoaderServlet](kb_topics/servletDetails.md#kb-topic-the-core-and-optional-smartclient-servlets).

There is no need to instantiate an LoadProjectSettings instance. Just pass a normal JavaScript object with the desired properties.

---
## Object: LoadScreenSettings

### Description
This is the bundle of settings that can be passed to [RPCManager.loadScreen](classes/RPCManager.md#classmethod-rpcmanagerloadscreen) as the "settings" argument. Some settings can also be passed as separate arguments; if these are present both as separate arguments and in settings, loadScreen() will use the value from the settings.

There is no need to instantiate a `LoadScreenSettings` instance. Just pass a normal JavaScript object with the desired properties.

---
## Object: MenuItem

### Description
Object specifying an item in a [Menu](classes/Menu.md#class-menu). Each `MenuItem` can have a [title](classes/MenuItem.md#attr-menuitemtitle), [icon](classes/MenuItem.md#attr-menuitemicon), [shortcut\\n keys](classes/MenuItem.md#attr-menuitemkeys), optional [MenuItem.submenu](classes/MenuItem.md#attr-menuitemsubmenu) and various other settings. Alternatively, a `MenuItem` can contain an arbitrary widget via [MenuItem.embeddedComponent](classes/MenuItem.md#attr-menuitemembeddedcomponent). MenuItems are specified as plain [JavaScript Objects](#type-object), usually with [ObjectLiteral](#type-objectliteral) notation. For example:
```
 isc.Menu.create({
     items : [
         {title: "item1", click: "alert(1)"},
         {title: "item2"}
     ]
 });
 
```
Do not use `isc.MenuItem.create()` - this is invalid.

Alternatively, Menus support binding to a [DataSource](classes/Menu.md#attr-menudatasource).

As another option, here's a sample of a Menu in [Component XML](kb_topics/componentXML.md#kb-topic-component-xml):

```
 <Menu>
    <items>
        <MenuItem title="item1" click="alert(1)"/>
        <MenuItem title="item2"/>
    </items>
 </Menu>
 
```

---
## Object: MessageID

### Description
Opaque message identifier for messages shown by the [Notify](classes/Notify.md#class-notify) class

---
## Object: MetricSettings

### Description
Defines a set of properties that are applicable to [additional value axes](classes/FacetChart.md#attr-facetchartextraaxismetrics) of a [FacetChart](classes/FacetChart.md#class-facetchart).

These properties behave identically to the same-named properties of FacetChart. Two exceptions are the properties [gradationLineProperties](classes/MetricSettings.md#attr-metricsettingsgradationlineproperties) and [gradationZeroLineProperties](classes/MetricSettings.md#attr-metricsettingsgradationzerolineproperties) because they are used to draw tick marks along an extra value axis instead of lines through the chart rectangle. Also the default behavior of the [dataColors](classes/MetricSettings.md#attr-metricsettingsdatacolors) property is different, in that the default is to use unused colors from, and in the order of, the [main data colors array](classes/FacetChart.md#attr-facetchartdatacolors).

The extra value axes that are not positioned directly adjacent to the [chart rect.](classes/FacetChart.md#attr-facetchartshowchartrect) of the FacetChart may additionally have an axis line to connect the gradation tick marks. Whether to draw this line is controlled by the [showAxisLine](classes/MetricSettings.md#attr-metricsettingsshowaxisline) property, and the properties of the line are specified using [axisLineProperties](classes/MetricSettings.md#attr-metricsettingsaxislineproperties). The default is to draw the axis lines whenever the chart rect. is drawn and to draw the line using the same properties as the lines of the chart rect. (for example, lineColor and lineWidth).

The extra value axis charts may be [single- or multi-facet](classes/MetricSettings.md#attr-metricsettingsmultifacet) charts. If the underlying [data](classes/FacetChart.md#attr-facetchartdata) is multi-facet then the extra value axes may use the facet whose values are labelled on the data axis or the facet used to create the legend (the first and second facets, respectively). Both types of charts vary the first facet to get a data series to plot. Multi-facet charts also vary the second facet, but single-facet charts keep the second facet fixed at a constant [FacetValue](#object-facetvalue).

The exact facet value to use for the second facet is specified using the [fixedFacetValue](classes/MetricSettings.md#attr-metricsettingsfixedfacetvalue) property.

---
## Object: MockDSExportSettings

### Description
Settings used to control the export or serialization of a [DataSource](classes/DataSource.md#class-datasource) by [Reify.getMockDS](classes/Reify.md#classmethod-reifygetmockds).

---
## Object: NavigationBarViewState

### Description
Encapsulates state of a [NavigationBar](classes/NavigationBar.md#class-navigationbar)'s view. A `NavigationBarViewState` object is created to pass to [NavigationBar.setViewState](classes/NavigationBar.md#method-navigationbarsetviewstate) so that multiple properties of the `NavigationBar` can be changed at once.

---
## Object: NodeLocator

### Description
An object containing sufficient context to unambiguously identify a single node in the tree. For normal trees, the node itself - or its ID - is sufficient for this purpose, but for [multi-link trees](classes/Tree.md#method-treeismultilinktree), we also need to know the node's parent, and its position within that parent. For cases where we need to propagate change back up the node's parent chain, in order to maintain a given parent node's openList, the node, parent and position are not enough context; for those cases, we need either the node's position in the tree's openList, or a full path to the node. `NodeLocator` objects contain this extra context, and can be passed to APIs such as [Tree.openFolder](classes/Tree.md#method-treeopenfolder), which would ordinarily accept a parameter of type [TreeNode](reference_2.md#object-treenode).

---
## Object: Point

### Description
X/Y position in pixels, specified as an Array with two members, for example: \[30, 50\]

---
## Object: PortalPosition

### Description
Represents the position of a [Portlet](classes/Portlet.md#class-portlet) within a [PortalLayout](classes/PortalLayout.md#class-portallayout), indicating the column, row, and position within the row.

---
## Object: PrintProperties

### Description
Settings for generating printable HTML for components.

### Groups

- printing

---
## Object: Promise

### Description
Extensions to the `Promise` class, or a polyfill of the ES6 `Promise` class if not provided natively by the browser.

---
## Object: PropertyValue

### Description
Identifies a property name and value to be assigned to a component by the [SetPropertiesTask](classes/SetPropertiesTask.md#class-setpropertiestask).

---
## Object: QualityIndicatedLocator

### Description
An object returned from [AutoTest.getLocatorWithIndicators](classes/AutoTest.md#classmethod-autotestgetlocatorwithindicators) that includes the locator and properties that describe the quality of the locator.

### Groups

- autoTest

---
## Object: SeleneseSettings

### Description
An object used to configure how Selenese is generated by [EventStream.getAsSeleneseHTML](classes/EventStream.md#method-eventstreamgetasselenesehtml) or [EventStream.getAsSeleneseCommands](classes/EventStream.md#method-eventstreamgetasselenesecommands).

### Groups

- experimental

---
## Object: ServerObject

### Description
The ServerObject tells the ISC server how to find or create a server-side object involved in [DMI](kb_topics/dmiOverview.md#kb-topic-direct-method-invocation) (Direct Method Invocation).

A ServerObject declaration appears in the XML definition of a [DataSource](classes/DataSource.md#class-datasource) (for responding to [DSRequest](reference_2.md#object-dsrequest)s) or in an Application configuration file (.app.xml) for responding to [RPCRequest](#object-rpcrequest)s.

NOTE: Please take note of the points made in [this discussion](kb_topics/serverDataSourceImplementation.md#kb-topic-notes-on-server-side-datasource-implementations) of caching and thread-safety issues in server-side DataSources.

### See Also

- [DMI](classes/DMI.md#class-dmi)

---
## Object: SingleSourceAIRequest

### Description
Represents a request to AI from a single [source](#type-aimessagesource) in some context.

---
## Object: SortSpecifier

### Description
An object that defines the details of a single sort operation.

For simple sort specifiers, you can convert between a `SortSpecifier` and the corresponding string format required by [DSRequest.sortBy](classes/DSRequest.md#attr-dsrequestsortby) by calling [DataSource.getSortBy](classes/DataSource.md#classmethod-datasourcegetsortby) and [DataSource.getSortSpecifiers](classes/DataSource.md#classmethod-datasourcegetsortspecifiers).

---
## Object: StockIcon

### Description
An object that represents a known image by mapping a unique [name](classes/StockIcon.md#attr-stockiconname) to an [image-src](classes/StockIcon.md#attr-stockiconsrc). The current image-src may be modified at runtime and developers may use these known images by name in any [image-property](#type-scimgurl) - for example, [icon](classes/StatefulCanvas.md#attr-statefulcanvasicon): "Edit" or [src](classes/Img.md#attr-imgsrc): "Accept" would show whatever image-src is [currently mapped](classes/StockIcon.md#attr-stockiconsrc) to those builtin stockIcons.
```
 isc.Button.create({ icon: "Edit" });
 isc.Img.create({ src: "Edit" });
 
```

It's also possible to extend a known `StockIcon` each time you use it, by stating it's name followed by a colon and any additional settings supported by the [SCSpriteConfig](#type-scspriteconfig) type. For example, you might be mapping the builtin "Edit" icon to a [stylable SVG Symbol](kb_topics/svgSymbols.md#kb-topic-svg-symbols-overview) (the default behavior of the Shiva skin) and have some edge-case that requires you to show it in red, or even upside down:

```
 isc.Img.create({ src: "Edit:color:red;" });
 isc.Img.create({ src: "Edit:rotate:180;" });
 
```

While a `StockIcon` maps a unique name to an image-src, it can also map **_from_** a known file-path via the [fromSrc property](classes/StockIcon.md#attr-stockiconfromsrc). If that attribute is set on a stockIcon, any request for the URL it represents will be mapped to that stockIcon and render its current `src` instead.

Developers may also add custom StockIcons either by calling [addStockIcons()](classes/Media.md#classmethod-mediaaddstockicons) or by passing an existing [IconSet](#object-iconset) to [useMedia()](classes/Media.md#classmethod-mediausemedia), and these can be used in the same way as builtin ones - once installed, code can refer to them by name. Later, the icons can be modified individually or in bulk by calling [updateIconMappings()](classes/Media.md#classmethod-mediaupdateiconmappings) which will update the current src property on the named stockIcons and refresh the UI.

As an example, assume you have multiple projects - each of these has an image in the base dir called "appLogo.png", which is displayed in many places. You could define a StockIcon to map that known file-path to a global name, like this:

```
 isc.Media.addStockIcons([
     {
         name: "AppLogo",
         fromSrc: "[APP]appLogo.png",
         src: null
     }
 ]);
 
```
Now, you can refer to this icon in code by just the name "AppLogo". Because you applied a _fromSrc_, any requests from existing code for that file-path will also be mapped to this StockIcon-name.

So at this point, any code that sets an image-source to either "\[APP\]appLogo.png" or "AppLogo" with render whatever is [currently assigned](classes/StockIcon.md#attr-stockiconsrc) to your new StockIcon. Since there is no **_src_** in the definition, it defaults to the **_fromSrc_** and both will render "\[APP\]appLogo.png".

```
 isc.Button.create({ icon: "[APP]appLogo.png" })
 isc.Button.create({ icon: "AppLogo" })
 
```

In the future, you might refresh the UI in your project and want to update your app-logo image. You can easily [assign new mappings](classes/Media.md#classmethod-mediaupdateiconmappings) to any StockIcon at runtime, and all uses of them will be updated to reflect the new [src](classes/StockIcon.md#attr-stockiconsrc).

```
 // define a mapping for the AppLogo image, to a new SVG symbol from a sprite file
 var newMappings = { "AppLogo": "sprite:svg:[APP]svgIcons.svg#appLogo" };
 
 // apply the mapping - this call will update the src property on the StockIcon 
 // and notify the framework that the icon's been updated, so the UI can update
 isc.Media.updateIconMappings(newMappings);
 
```
Anywhere you use the "AppLogo" icon in your code, by name or path (fromSrc), it will now render the updated mapping and show your SVG symbol instead of the original PNG. In this case, because it's an SVG, you can re-style the base StockIcon each time you use it, perhaps changing it's color for use in different contexts.
```
 // perhaps your logo goes red when a critical app-update is pending
 isc.Img.create({ src: "AppLogo:color:red;" });
 
 // or perhaps you show it as a watermark in the background of the page
 isc.Img.create({ src: "AppLogo:size:500,500;opacity:0.2;" });
 
```

For more information about installing multiple new StockIcons at once, or applying overlays of mappings to existing ones, read about [IconSet](#object-iconset) and [Media.useMedia](classes/Media.md#classmethod-mediausemedia).

### Groups

- media
- stockIcons

---
## Object: StretchItem

### Description
An object representing one of the image segments displayed by a [StretchImg](classes/StretchImg.md#class-stretchimg). Each item of a StretchImg's [items](classes/StretchImg.md#attr-stretchimgitems) array is a StretchItem.

---
## Object: String

### Description
Generic extensions to JavaScript Strings. You can call these on any String.

---
## Object: SystemAIRequest

### Description
Represents a programmer-specified request to AI in some context.

---
## Object: TaskDecision

### Description
Identifies a potential decision (branch) within a [MultiDecisionTask](classes/MultiDecisionTask.md#class-multidecisiontask). Each decision has a criteria and a target ProcessElement ID.

**Deprecated**

---
## Object: TestFunctionResult

### Description
A TestFunctionResult is an ordinary JavaScript Object with properties that indicate the status of an attempt to generate and execute a function for [FormulaBuilder](classes/FormulaBuilder.md#class-formulabuilder) and it's subclasses.

Because TestFunctionResult is always an ordinary JavaScript Object, it supports the normal behaviors of JavaScript Objects, including accessing and assigning to properties via dot notation:

```
     var propValue = testFunctionResult.propName;
     testFunctionResult.propName = newValue;
 
```

### Groups

- formulaFields

---
## Object: TreeNode

### Description
Every node in the tree is represented by a TreeNode object which is an object literal with a set of properties that configure the node.

When a Tree is supplied as [TreeGrid.data](classes/TreeGrid.md#attr-treegriddata) to [TreeGrid](classes/TreeGrid.md#class-treegrid), you can also set properties from [ListGridRecord](reference_2.md#object-listgridrecord) on the TreeNode (e.g. setting [ListGridRecord.enabled](classes/ListGridRecord.md#attr-listgridrecordenabled):`false` on the node).

---
## Object: UISummarySettings

### Description
Settings that control how a widget UI Summary is built.

---
## Object: UserAIRequest

### Description
Represents a user-specified and user-modifiable request to AI in some context. For example, the user's request may be in the context of AI-assisted filtering of a [ListGrid](classes/ListGrid_1.md#class-listgrid); in such a context, the user's request is their description of which records they would like to see.

The user's request is combined with other messages, data, and instructions provided by the framework to create [AIRequest](#object-airequest)s that are sent to the AI engine for the purpose of fulfilling the user's request.

---
## Object: ValidatorDefinition

### Description
Validator definition for a built-in [Validator.type](classes/Validator.md#attr-validatortype).

---
## Object: VisibleMethod

### Description
Defines the method of the [ServerObject](reference_2.md#object-serverobject) if it appears in an [Application declaration file](kb_topics/applicationDeclaration.md#kb-topic-application-declaration-files). Method can refer the `ServerObject` method allowed to be called from the client or can be implemented right in the .app.xml file using the [inline server script](kb_topics/serverScript.md#kb-topic-server-scripting).

---
## Object: WSRequest

### Description
A WSRequest (or "web service request") is an extended RPCRequest with additional properties applicable to WSDL/SOAP web services.

All properties which are legal on [RPCRequest](#object-rpcrequest) are legal on a WSRequest, in addition to the properties listed here.

### See Also

- [RPCRequest](#object-rpcrequest)

---
## Interface: Chart

### Description
Generic Chart properties and interfaces to be mixed into concrete charting implementations.

Components such as the [ListGrid](classes/ListGrid_2.md#method-listgridchartdata) and [CubeGrid](classes/CubeGrid.md#method-cubegridmakechart) expect this interface and can drive charting engines that support it.

Concrete Chart implementations may expose whatever properties they want for configuration, however, to enable easy switching of charting engines (different engines may be used for different end users based on that user's installed plugins), they should support the properties of this interface to the maximum extent possible.

This interface also provides core data model management (see [getValue()](classes/Chart.md#method-chartgetvalue)) for charting engines.

---
## Interface: List

### Description
An interface for an ordered collection of items.

This is the interface that is expected by list-oriented display components such as the ListGrid. The JavaScript native Array object is retrofitted to support the List interface. Also, a valid List can be created by mixing the List interface into any class that supports:

*   for read-only support: get(position), getLength()
*   for modifiable support: set(position), addAt(object, position), removeAt(position)

NOTE: this interface is compatible with the java.util.List interface, except that:

*   for removal by index, removeAt() must be called instead of remove(). In Java, remove() is an overloaded method that takes either an int or Object, whereas in JavaScript, a Number is an Object.
*   Iterators don't exist.

Some methods from the Java List interface have been omitted from the documentation to avoid redundancy.

---
## Interface: PickList

### Description
Interface to show a drop-down list of pickable options. Used by the [SelectItem](classes/SelectItem.md#class-selectitem) and [ComboBoxItem](classes/ComboBoxItem.md#class-comboboxitem) classes. Depending on the value of [PickList.dataSetType](classes/PickList.md#attr-picklistdatasettype), the generated drop down list of options must be an instance of [PickListMenu](classes/PickListMenu.md#class-picklistmenu) or [PickTreeMenu](#class-picktreemenu), or a subclass thereof.

---
