# Reify Overview

[← Back to API Index](../reference.md)

---

## KB Topic: Reify Overview

### Description
Reify is a web-based visual application builder that enables non-developers to build SmartClient screens, and even build complete applications. This is sometimes called a "`Low Code / No Code`" system.

You can use Reify at [Reify.com](https://www.reify.com) ([get a free trial account](https://create.reify.com/users/register.jsp)), or you can use [Reify OnSite](reifyOnSite.md#kb-topic-reify-onsite), which is a version of Reify that can be installed on your own network, behind your firewall, so that your confidential data and designs never leave your network.

Reify can be used to build complete applications, and features push-button managed deployment. Reify applications can also be exported from Reify, and deployed on the standard SmartClient platform (including SmartClient LGPL).

Reify can also be used to build just _parts_ of an application, using a process called _Hybrid Development_, where screens created in Reify can be added to an existing application. To learn more about Hybrid Development, read [Reify for Developers](reifyForDevelopers.md#kb-topic-reify-for-developers).

When using Hybrid Development, Reify screens can be easily added to existing applications, even if those applications aren't based on SmartClient. The loaded screens simply connect to the data services your application already has.

**Low Code Everywhere**

Because Reify is so flexible, you can use it on any kind of project: unlike other Low Code tools, Reify isn't limited to just simpler applications.

For example, you might build the first version of your application completely within Reify, and use push-button managed deployment. Then later, you could export it to deploy it on your own. And, as requirements change, you can switch to Hybrid Development if you need to add screens, functions or data connections that can't be built visually.

At the same time, you can use Reify to incrementally upgrade existing web applications, by adding new screens and replacing existing ones.

Because Reify applications are just SmartClient applications, you can be confident that you will be able to build any kind of application or feature you need - you can never "get stuck" and have to start over with a different technology.

Because Reify lets you deploy on your own if you want to, you will never be trapped by unfair pricing.

The power & flexibility of Reify enables you to get the benefits of the Low Code approach on every project.

**Reify for Mockups & Functional Design**

Reify has several advantages over other tools typically used for mockups or functional design:

1.  _richer, testable mockups_: you can create much richer, more complete, more interactive mockups. You can even use push-button deployment to create a UAT ("User Acceptance Test") environment, without ever having to involve a developer or IT.
2.  _no waste_: Reify "mockups" are actually real screens, ready to use. With all other mockup tools, when it comes to implementation time, you simply throw the mockup away and start over.
3.  _same components for mockup and deployment_: with other mockup tools, the components available in the mockup tool may be different from those available in the real technology. Often, designers create awkward designs because the mockup tool lacks a key component.
4.  _add skins for WYSIWYG design_: you can install custom skins in Reify, so that the mockups created will look exactly the same when deployed.

**Next Steps:**

o Get a [free trial account](https://create.reify.com/users/register.jsp) at [Reify.com](https://www.reify.com) and start building

... or ...

o Read [Reify for Developers](reifyForDevelopers.md#kb-topic-reify-for-developers) to learn more about Hybrid Development

... or ...

o Read more about [Reify OnSite](reifyOnSite.md#kb-topic-reify-onsite) and how to customize it.

### Related

- [EventStream](../classes/EventStream.md#class-eventstream)
- [Reify](../classes/Reify.md#class-reify)

### See Also

- [toolsDeployment](toolsDeployment.md#kb-topic-tools-deployment)
- [reifyCustomComponents](reifyCustomComponents.md#kb-topic-adding-custom-components-to-reify)
- [reifyCustomDataSources](reifyCustomDataSources.md#kb-topic-adding-custom-datasources-to-reify)

---
