import React from 'react';
import { CoTProcess, CoTProcessProps } from './CoTProcess';
import { AsComponentXML } from './core/ReactComponent';


declare interface AUNProps extends CoTProcessProps {

/**
 * See {@link isc.AUN.loopThreshold AUN.loopThreshold}.
 */
loopThreshold?: number;

/**
 * See {@link isc.AUN.mockMode AUN.mockMode}.
 */
mockMode?: boolean;

/**
 * See {@link isc.AUN.getNavigationGraph() AUN.getNavigationGraph()}.
 */
getNavigationGraph?: Function;

/**
 * See {@link isc.AUN.generateTest() AUN.generateTest()}.
 */
generateTest?: Function;

/**
 * See {@link isc.AUN.optionalPrompts AUN.optionalPrompts}.
 */
optionalPrompts?: Object;

/**
 * See {@link isc.AUN.start() AUN.start()}.
 */
start?: Function;

/**
 * See {@link isc.AUN.getPlaywrightTest() AUN.getPlaywrightTest()}.
 */
getPlaywrightTest?: Function;

/**
 * See {@link isc.AUN.introPrompt AUN.introPrompt}.
 */
introPrompt?: string;

/**
 * See {@link isc.AUN.tasks AUN.tasks}.
 */
tasks?: Task[];

/**
 * See {@link isc.AUN.notify() AUN.notify()}.
 */
notify?: Function;

/**
 * See {@link isc.AUN.maxSteps AUN.maxSteps}.
 */
maxSteps?: number;

/**
 * See {@link isc.AUN.enableConversationLogging() AUN.enableConversationLogging()}.
 */
enableConversationLogging?: Function;

/**
 * See {@link isc.AUN.exportMarkdownLog() AUN.exportMarkdownLog()}.
 */
exportMarkdownLog?: Function;

/**
 * See {@link isc.AUN.getCypressTest() AUN.getCypressTest()}.
 */
getCypressTest?: Function;

/**
 * See {@link isc.AUN.goal AUN.goal}.
 */
goal?: string;


children?: React.ReactElement<JSX.IntrinsicElements> |
           React.ReactElement<JSX.IntrinsicElements>[];

}


/**
 * AUN wraps the SmartClient widget class
 * {@link isc.AUN AUN} for React, allowing you to import
 * AUN for use in React JS and JSX.
 * @class
 * @extends CoTProcess
 */
declare class AUN extends CoTProcess {
    props: AsComponentXML<AUNProps>;
}
