/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.datasource.DSParquetGenerator;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.datasource.DynamicDSGenerator;
import com.isomorphic.log.Logger;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.annotation.WebListener;

@WebListener
public class DSParquetGeneratorRegistrar
implements ServletContextListener {
    static Logger log = new Logger(DSParquetGeneratorRegistrar.class);

    public void contextInitialized(ServletContextEvent sce) {
        try {
            Class<?> klass = Class.forName("org.apache.parquet.conf.ParquetConfiguration");
            DataSource.addDynamicDSGenerator((DynamicDSGenerator)new DSParquetGenerator(), "parquet-");
            log.info("Registered DSParquetGenerator");
        }
        catch (ClassNotFoundException cnfe) {
            log.info("Apache Parquet not present - not registering DSParquetGenerator");
        }
        catch (Exception e) {
            log.warn((Object)"Caught exception trying to register DSParquetGenerator", e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        DataSource.removeDynamicDSGenerator("parquet-");
    }
}

