/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.examples.server.customDownload;

import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.RPCManager;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;

public class CustomDownload {
    private Logger log = new Logger(CustomDownload.class);

    public void downloadData(DSRequest dsRequest, RPCManager rpc) {
        DSResponse dsResponse = new DSResponse();
        try {
            rpc.doCustomResponse();
            HttpServletResponse response = rpc.getContext().response;
            response.setHeader("content-disposition", "attachment; filename=downloadDescriptions.txt");
            response.setContentType("text/plain");
            dsResponse = dsRequest.execute();
            List list = dsResponse.getDataList();
            Object result = "";
            for (Map record : list) {
                String itemName = record.get("itemName") == null ? "" : record.get("itemName").toString();
                String description = record.get("description") == null ? "" : record.get("description").toString();
                result = (String)result + itemName + " : " + description + "\r\n\r\n";
            }
            ServletOutputStream out = response.getOutputStream();
            out.write(((String)result).getBytes());
            dsResponse.setStatus(0);
            rpc.send(dsRequest, dsResponse);
        }
        catch (Exception e) {
            this.log.warn((Throwable)e);
            try {
                rpc.sendFailure((Object)dsRequest, e.getMessage());
            }
            catch (Exception er) {
                this.log.warn((Throwable)er);
            }
        }
    }
}

