/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.isomorphic.base.Config;
import com.isomorphic.criteria.AdvancedCriteria;
import com.isomorphic.criteria.Evaluator;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class SCReferenceDataSource
extends BasicDataSource {
    private static final AtomicReference<List<Map<String, Object>>> CACHE = new AtomicReference<Object>(null);
    private static final AtomicReference<Map<String, Object>> RAW_ROOT = new AtomicReference<Object>(null);
    private static final Object LOCK = new Object();
    private static final Set<String> REAL_OWNER_KINDS = new HashSet<String>(Arrays.asList("class", "interface", "object", "type"));
    private static final Set<String> MEMBER_LIST_KEYS = new HashSet<String>(Arrays.asList("classMethods", "staticMethods", "classAttrs", "attrs", "methods"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reload() {
        Object object = LOCK;
        synchronized (object) {
            CACHE.set(null);
            RAW_ROOT.set(null);
        }
    }

    private static String getDocsPath(DSRequest req) {
        String v;
        Object p = req.getParameter("docsPath");
        if (p != null && !(v = String.valueOf(p).trim()).isEmpty()) {
            return v;
        }
        String fallback = "isomorphic/system/reference/referenceDocs.js";
        return fallback;
    }

    @Override
    public DSResponse executeFetch(DSRequest req) throws Exception {
        List<Map<String, Object>> filtered;
        File currentFile;
        Map critForFilter = req.getCriteria();
        String newPath = SCReferenceDataSource.getDocsPath(req);
        File newFile = SCReferenceDataSource.resolveDocsPath(newPath);
        File file = currentFile = RAW_ROOT.get() != null ? (File)RAW_ROOT.get().get("sourceFile") : null;
        if (currentFile == null || !currentFile.equals(newFile)) {
            SCReferenceDataSource.reload();
        }
        this.ensureLoaded(newFile);
        List<Map<String, Object>> all = CACHE.get();
        if (all == null) {
            return SCReferenceDataSource.emptyResponse();
        }
        Evaluator ev = new Evaluator();
        if (critForFilter == null || critForFilter.isEmpty()) {
            filtered = all;
        } else if ("AdvancedCriteria".equals(critForFilter.get("_constructor"))) {
            try {
                AdvancedCriteria ac = Evaluator.parseAdvancedCriteria(critForFilter);
                ArrayList<Map<String, Object>> tmp = new ArrayList<Map<String, Object>>(all.size());
                for (Map<String, Object> rec : all) {
                    if (!ev.valuesMatchCriteria(rec, ac)) continue;
                    tmp.add(rec);
                }
                filtered = tmp;
            }
            catch (Exception ignore) {
                filtered = all;
            }
        } else {
            Map<String, Object> clean = SCReferenceDataSource.sanitizeCriteriaMap(critForFilter);
            if (clean != null) {
                try {
                    AdvancedCriteria ac = Evaluator.parseAdvancedCriteria(clean);
                    ArrayList<Map<String, Object>> tmp = new ArrayList<Map<String, Object>>(all.size());
                    for (Map map : all) {
                        if (!ev.valuesMatchCriteria(map, ac)) continue;
                        tmp.add(map);
                    }
                    filtered = tmp;
                }
                catch (Exception ignore) {
                    filtered = all;
                }
            } else {
                filtered = all;
            }
        }
        int start = (int)Math.max(0L, req.getStartRow());
        int end = (int)(req.getEndRow() > 0L ? Math.min((long)filtered.size(), req.getEndRow()) : (long)filtered.size());
        if (end < start) {
            end = start;
        }
        List<Map<String, Object>> slice = filtered.subList(start, end);
        DSResponse rsp = new DSResponse();
        rsp.setData(slice);
        rsp.setStartRow(start);
        rsp.setEndRow(end);
        rsp.setTotalRows(filtered.size());
        return rsp;
    }

    private static DSResponse emptyResponse() {
        DSResponse rsp = new DSResponse();
        rsp.setData(Collections.emptyList());
        rsp.setStartRow(0L);
        rsp.setEndRow(0L);
        rsp.setTotalRows(0L);
        return rsp;
    }

    private static Map<String, Object> sanitizeCriteriaMap(Object raw) {
        if (!(raw instanceof Map)) {
            return null;
        }
        Map m = (Map)raw;
        if ("AdvancedCriteria".equals(m.get("_constructor"))) {
            return m;
        }
        if (m.containsKey("fieldName")) {
            Object op = m.get("operator");
            Object val = m.get("value");
            if (op == null || m.get("fieldName") == null) {
                return null;
            }
            if (val == null || val instanceof String && ((String)val).isEmpty()) {
                return null;
            }
            return m;
        }
        if (m.containsKey("criteria")) {
            Object crits = m.get("criteria");
            if (crits instanceof List) {
                ArrayList<Map> cleaned = new ArrayList<Map>();
                for (Object c : (List)crits) {
                    if (!(c instanceof Map)) continue;
                    Map cm = (Map)c;
                    Object field = cm.get("fieldName");
                    Object op = cm.get("operator");
                    Object val = cm.get("value");
                    if (field == null || op == null || val == null || val instanceof String && ((String)val).isEmpty()) continue;
                    cleaned.add(cm);
                }
                if (!cleaned.isEmpty()) {
                    LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
                    out.put("_constructor", "AdvancedCriteria");
                    out.put("operator", m.getOrDefault("operator", "and"));
                    out.put("criteria", cleaned);
                    return out;
                }
            }
            return null;
        }
        if (!m.isEmpty()) {
            ArrayList crits = new ArrayList(m.size());
            for (Map.Entry e : m.entrySet()) {
                String field = (String)e.getKey();
                Object val = e.getValue();
                if (val == null || val instanceof String && ((String)val).isEmpty()) continue;
                LinkedHashMap<String, String> one = new LinkedHashMap<String, String>();
                one.put("fieldName", field);
                if (val instanceof List) {
                    one.put("operator", "inSet");
                    one.put("value", (String)val);
                } else if (val instanceof CharSequence) {
                    one.put("operator", "iContains");
                    one.put("value", String.valueOf(val));
                } else {
                    one.put("operator", "equals");
                    one.put("value", (String)val);
                }
                crits.add(one);
            }
            if (!crits.isEmpty()) {
                LinkedHashMap<String, Object> out = new LinkedHashMap<String, Object>();
                out.put("_constructor", "AdvancedCriteria");
                out.put("operator", "and");
                out.put("criteria", crits);
                return out;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureLoaded(File expectedFile) throws Exception {
        if (CACHE.get() != null) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            if (CACHE.get() != null) {
                return;
            }
            if (expectedFile == null || !expectedFile.exists()) {
                throw new IllegalStateException("SCReferenceDataSource: docsPath not found: " + (expectedFile == null ? "(null)" : expectedFile.getAbsolutePath()));
            }
            String js = SCReferenceDataSource.readAll(expectedFile);
            Map<String, Object> root = SCReferenceDataSource.parseDocFile(js);
            root.put("sourceFile", expectedFile);
            RAW_ROOT.set(root);
            List<Map<String, Object>> flattened = SCReferenceDataSource.buildTreeRecords(root);
            CACHE.set(flattened);
        }
    }

    private static File resolveDocsPath(String relativePath) {
        String webRoot = Config.getGlobal().getPath("webRoot");
        if (webRoot == null || webRoot.isEmpty()) {
            webRoot = System.getProperty("user.dir");
            System.err.println("[SCReferenceDS] WARNING: webRoot not found, using user.dir=" + webRoot);
        }
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        File resolved = new File(webRoot, relativePath);
        return resolved;
    }

    private static String readAll(File f) throws Exception {
        StringBuilder sb = new StringBuilder(0x100000);
        try (BufferedReader br = new BufferedReader(new FileReader(f, StandardCharsets.UTF_8));){
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        return sb.toString();
    }

    private static Map<String, Object> parseDocFile(String js) throws Exception {
        String versionObj = SCReferenceDataSource.extractBalancedObject(js, "isc.docVersionInfo");
        String itemsObj = SCReferenceDataSource.extractBalancedObject(js, "isc.docItems");
        ObjectMapper om = new ObjectMapper().configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true).configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true).configure(JsonParser.Feature.ALLOW_COMMENTS, true).configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true).configure(JsonParser.Feature.ALLOW_TRAILING_COMMA, true);
        Map version = versionObj != null ? (Map)om.readValue(versionObj, (TypeReference)new TypeReference<Map<String, Object>>(){}) : Collections.emptyMap();
        Map items = itemsObj != null ? (Map)om.readValue(itemsObj, (TypeReference)new TypeReference<Map<String, Object>>(){}) : Collections.emptyMap();
        LinkedHashMap<String, Object> root = new LinkedHashMap<String, Object>();
        root.put("docVersionInfo", version);
        root.put("docItems", items);
        return root;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String extractBalancedObject(String source, String lhs) {
        int i;
        int anchor = source.indexOf(lhs);
        if (anchor < 0) {
            return null;
        }
        int eq = source.indexOf(61, anchor);
        if (eq < 0) {
            return null;
        }
        int n = source.length();
        for (i = eq + 1; i < n && Character.isWhitespace(source.charAt(i)); ++i) {
        }
        if (i >= n || source.charAt(i) != '{') {
            return null;
        }
        int start = i;
        int depth = 0;
        boolean inSingle = false;
        boolean inDouble = false;
        boolean inTemplate = false;
        boolean inLineComment = false;
        boolean inBlockComment = false;
        while (true) {
            block24: {
                char c;
                block33: {
                    block32: {
                        block31: {
                            block30: {
                                block29: {
                                    block28: {
                                        block26: {
                                            char d;
                                            block27: {
                                                block25: {
                                                    block23: {
                                                        if (i >= n) {
                                                            return null;
                                                        }
                                                        c = source.charAt(i);
                                                        if (!inLineComment) break block23;
                                                        if (c == '\n' || c == '\r') {
                                                            inLineComment = false;
                                                        }
                                                        break block24;
                                                    }
                                                    if (!inBlockComment) break block25;
                                                    if (c == '*' && i + 1 < n && source.charAt(i + 1) == '/') {
                                                        inBlockComment = false;
                                                        ++i;
                                                    }
                                                    break block24;
                                                }
                                                if (inSingle || inDouble || inTemplate || c != '/' || i + 1 >= n) break block26;
                                                d = source.charAt(i + 1);
                                                if (d != '/') break block27;
                                                inLineComment = true;
                                                ++i;
                                                break block24;
                                            }
                                            if (d != '*') break block26;
                                            inBlockComment = true;
                                            ++i;
                                            break block24;
                                        }
                                        if (inDouble || inTemplate || c != '\'' || inSingle) break block28;
                                        inSingle = true;
                                        break block24;
                                    }
                                    if (!inSingle) break block29;
                                    if (c == '\\') {
                                        ++i;
                                        break block24;
                                    } else if (c == '\'') {
                                        inSingle = false;
                                    }
                                    break block24;
                                }
                                if (inSingle || inTemplate || c != '\"' || inDouble) break block30;
                                inDouble = true;
                                break block24;
                            }
                            if (!inDouble) break block31;
                            if (c == '\\') {
                                ++i;
                                break block24;
                            } else if (c == '\"') {
                                inDouble = false;
                            }
                            break block24;
                        }
                        if (inSingle || inDouble || c != '`' || inTemplate) break block32;
                        inTemplate = true;
                        break block24;
                    }
                    if (!inTemplate) break block33;
                    if (c == '\\') {
                        ++i;
                        break block24;
                    } else if (c == '`') {
                        inTemplate = false;
                    }
                    break block24;
                }
                if (c == '{') {
                    if (depth == 0) {
                        start = i;
                    }
                    ++depth;
                } else if (c == '}' && --depth == 0) {
                    int end;
                    int j;
                    for (j = end = i + 1; j < n && Character.isWhitespace(source.charAt(j)); ++j) {
                    }
                    if (j < n && source.charAt(j) == ';') {
                        end = j;
                    }
                    return source.substring(start, end);
                }
            }
            ++i;
        }
    }

    private static List<Map<String, Object>> buildTreeRecords(Map<String, Object> root) {
        ArrayList<Map<String, Object>> out = new ArrayList<Map<String, Object>>();
        Object di = root.get("docItems");
        if (!(di instanceof Map)) {
            return out;
        }
        Map docItems = (Map)di;
        LinkedHashMap<String, Map> itemsByRef = new LinkedHashMap<String, Map>();
        for (Map.Entry e : docItems.entrySet()) {
            if (!(e.getValue() instanceof Map)) continue;
            itemsByRef.put((String)e.getKey(), (Map)e.getValue());
        }
        LinkedHashMap<CallSite, Map<String, Object>> owners = new LinkedHashMap<CallSite, Map<String, Object>>();
        for (Map.Entry e : docItems.entrySet()) {
            String ownerId;
            String refKey = (String)e.getKey();
            if (!(e.getValue() instanceof Map)) continue;
            Map item = (Map)e.getValue();
            String refType = SCReferenceDataSource.refPrefix(refKey);
            String refName = SCReferenceDataSource.localNameFromRef(refKey);
            String itemType = SCReferenceDataSource.strOr(item.get("type"), refType);
            if (!REAL_OWNER_KINDS.contains(itemType) || owners.containsKey(ownerId = itemType + ":" + refName)) continue;
            Map<String, Object> ownerRec = SCReferenceDataSource.rec(ownerId, null, true, refName, itemType, ownerId, null, itemType + ":" + refName);
            owners.put((CallSite)((Object)ownerId), ownerRec);
            out.add(ownerRec);
        }
        for (Map.Entry entry : owners.entrySet()) {
            String ownerName;
            String ownerId = (String)entry.getKey();
            String[] parts = ownerId.split(":", 2);
            String ownerKind = parts.length > 0 ? parts[0] : "";
            String ownerRefKey = ownerKind + ":" + (ownerName = parts.length > 1 ? parts[1] : "");
            Map ownerItem = (Map)itemsByRef.get(ownerRefKey);
            if (ownerItem == null) continue;
            for (String listKey : MEMBER_LIST_KEYS) {
                Object val = ownerItem.get(listKey);
                if (!(val instanceof List)) continue;
                List<String> refs = SCReferenceDataSource.asStringList(val);
                String folderId = ownerId + "/" + listKey;
                String folderFqn = ownerId + "/" + listKey;
                out.add(SCReferenceDataSource.rec(folderId, ownerId, true, listKey, "list", folderFqn, null));
                int i = 0;
                for (String childRef : refs) {
                    String childId;
                    Map childItem = (Map)itemsByRef.get(childRef);
                    String childKind = SCReferenceDataSource.refPrefix(childRef);
                    String childLocalName = SCReferenceDataSource.localNameFromRef(childRef);
                    String childType = childItem != null ? SCReferenceDataSource.strOr(childItem.get("type"), childKind) : childKind;
                    String normalized = SCReferenceDataSource.normalizeKind(childType);
                    String childFqn = childId = folderId + "#" + normalized + ":" + childLocalName;
                    out.add(SCReferenceDataSource.rec(childId, folderId, false, childLocalName, normalized, childFqn, null, childRef));
                    ++i;
                }
            }
        }
        return out;
    }

    private static Map<String, Object> rec(String id, String parentId, boolean isFolder, String name, String kind, String fqName, String value, String ref) {
        LinkedHashMap<String, Object> r = new LinkedHashMap<String, Object>();
        r.put("id", id);
        r.put("parentId", parentId);
        r.put("isFolder", isFolder);
        r.put("name", name);
        r.put("kind", kind);
        r.put("fqName", fqName);
        r.put("value", value);
        if (ref != null) {
            r.put("ref", ref);
        }
        return r;
    }

    private static Map<String, Object> rec(String id, String parentId, boolean isFolder, String name, String kind, String fqName, String value) {
        return SCReferenceDataSource.rec(id, parentId, isFolder, name, kind, fqName, value, null);
    }

    private static String refPrefix(String ref) {
        int idx = ref.indexOf(58);
        return idx > 0 ? ref.substring(0, idx) : null;
    }

    private static String localNameFromRef(String ref) {
        int idx = ref.indexOf(58);
        String rest = idx > 0 ? ref.substring(idx + 1) : ref;
        int dot = rest.indexOf(46);
        return dot > 0 ? rest.substring(dot + 1) : rest;
    }

    private static String strOr(Object a, String fallback) {
        return a != null ? String.valueOf(a) : fallback;
    }

    private static String normalizeKind(String raw) {
        return raw == null ? "item" : raw;
    }

    private static List<String> asStringList(Object v) {
        if (v == null) {
            return Collections.emptyList();
        }
        if (v instanceof List) {
            List raw = (List)v;
            ArrayList<String> out = new ArrayList<String>(raw.size());
            for (Object o : raw) {
                if (o == null) continue;
                out.add(String.valueOf(o));
            }
            return out;
        }
        return Collections.emptyList();
    }

    private static String parentRootForOwnerKind(String kind, String classesRootId, String interfacesRootId, String objectsRootId, String typesRootId, String fallbackRootId) {
        if ("class".equals(kind)) {
            return classesRootId;
        }
        if ("interface".equals(kind)) {
            return interfacesRootId;
        }
        if ("object".equals(kind)) {
            return objectsRootId;
        }
        if ("type".equals(kind)) {
            return typesRootId;
        }
        return fallbackRootId;
    }
}

