/*

  SmartClient Ajax RIA system
  Version v13.1p_2026-02-15/LGPL Deployment (2026-02-15)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/
//>	@class  ScalarViewer
// A DynamicForm subclass for displaying a single value from a data object.
// <P>
// The ScalarViewer will creates a single item based on the specified +link{fieldName} and
// +link{title} in order to display the value for a single field to the user.
// <P>
// The item may be customized via the +link{group:autoChildUsage,autoChild} pattern. 
// See +link{scalarViewer.valueItem}.
// 
//  @inheritsFrom DynamicForm
//  @treeLocation Client Reference/Forms
//  @visibility internal
//<

// create the form as a descendant of the Canvas
isc.ClassFactory.defineClass("ScalarViewer", "DynamicForm");

isc.ScalarViewer.addProperties({

    // Set up for a single item with top-orientated title by default
    numCols:1, colWidths:["*"],

    initWidget : function () {
        var itemConfig = this.getValueItemConfig();
        this.setItems([itemConfig]);
        this.Super("initWidget", arguments);
        this.valueItem = this.getItem(0);
    },
    getValueItemConfig : function () {
        return isc.addProperties(
            {},
            this.valueItemDefaults,
            this.valueItemProperties,
            {title:this.title, name:this.fieldName}
        );
    },

    //> @attr scalarViewer.valueItem (FormItem AutoChild : null : IR)
    // Single item for displaying a value from a data object.
    // <P>
    // This item will have +link{formItem.name,name} set to to 
    // +link{fieldName,this.fieldName} and title set to +link{title,this.title}.
    // <P>
    // Other properties are derived from +link{valueItemDefaults} and
    // +link{valueItemProperties} using the auto-child pattern.
    // 
    // @visibility internal
    //<

    //> @attr scalarViewer.initialSort (Array of SortSpecifier : null : IR)
    // An array of +link{SortSpecifier} objects used to set up the initial sort 
    // configuration for this form.
    // @group sorting
    // @visibility external
    //<
    //initialSort: null,
    
    //> @attr scalarViewer.fieldName (String : "value" : IRW)
    // +link{formItem.name,name} for the +link{valueItem}
    //
    // @setter setFieldName()
    // @visibility internal
    //<
    fieldName:"value",

    //> @method scalarViewer.setFieldName()
    // Set the +link{fieldName} at runtime. This will rebuild
    // the +link{valueItem}.
    //
    // @param name (String) new fieldName to use
    // @visibility internal
    //<
    setFieldName : function (name) {
        this.fieldName = name
        this.setItems([this.getValueItemConfig()]);
        this.valueItem = this.getItem(0);
    },

    //> @attr scalarViewer.title (String : null : IRW)
    // +link{formItem.title,title} for the +link{valueItem}
    //
    // @setter setTitle()
    // @visibility internal
    //<
    // title:null,

    //> @method scalarViewer.setTitle()
    // Set the +link{title} at runtime of the +link{valueItem}
    // at runtime.
    //
    // @param title (String) new title to use
    // @visibility internal
    //<
    setTitle : function (title) {
        this.valueItem.setTitle(title);
    },

    //> @attr scalarViewer.valueItemDefaults (FormItem Properties : {...} : IR)
    // Defaults for the generated +link{valueItem}
    // <P>
    // By default the valueItem will be a StaticTextItem with
    // +link{formItem.titleOrientation,titleOrientation:"top"}
    // @visibility internal
    //<
    // For greater control over the appearance we could use a CanvasItem subclass here
    valueItemDefaults:{
        editorType:"StaticTextItem",
        
        vAlign:"center",
        align:"center",
        titleAlign:"center",
        titleOrientation:"top",
        titleStyle:"headerItem",
        textBoxStyle:"headerItem"
    }

    //> @attr scalarViewer.valueItemProperties (FormItem Properties : null : IR)
    // Optional +link{group:autoChildUsage,autoChild properties} to customize
    // the generated +link{valueItem}.
    // @visibility internal
    //<


});