/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.annotations;

import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.datasource.BasicDataSource;
import com.isomorphic.log.Logger;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.Version;

public class DataSourceAnnotations {
    private static final String CLASS_NAME = DataSourceAnnotations.class.getName();
    private static final Logger log = new Logger(CLASS_NAME);
    public static final String ENTITY_NAME = "extEntityName";
    public static final String IS_EMBEDDED_ID = "extIsEmbeddedId";
    public static final String IS_STATIC = "extIsStatic";
    public static final String IS_FINAL = "extIsFinal";
    public static final String IS_TRANSIENT = "extIsTransient";
    public static final String IS_LAZY = "extIsLazy";
    public static final String PRECISION = "extPrecision";
    public static final String SCALE = "extScale";
    public static final String IS_UNIQUE = "extIsUnique";
    public static final String IS_VERSION = "extIsVersion";
    private static final Map<String, List<Map<String, Object>>> cache = new HashMap<String, List<Map<String, Object>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static Map<String, Object> getDataSourceConfigFromAnnotatedClass(Class c, boolean extended, boolean assumeAnnotations, String serverType, String constructor) throws Exception {
        boolean isEntity;
        log.debug("Generating data source '" + c.getSimpleName() + "' for class " + c.getName());
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("ID", c.getSimpleName());
        if (serverType != null) {
            config.put("serverType", serverType);
        }
        if (constructor != null) {
            config.put("serverConstructor", constructor);
        }
        config.put("beanClassName", c.getName());
        config.put("dropExtraFields", Boolean.TRUE);
        config.put("allowAdvancedCriteria", Boolean.TRUE);
        Config iscConfig = Config.getGlobal();
        if (iscConfig != null) {
            String version = iscConfig.getString("iscVersion") + " " + iscConfig.getString("iscPackageDate");
            config.put("generatedBy", version);
        }
        if (isEntity = DataSourceAnnotations.hasAnnotation(c, Entity.class, MappedSuperclass.class, Embeddable.class)) {
            Map<String, Object> idClassAnnotation;
            Object value;
            Map<String, Object> entityAnnotation = DataSourceAnnotations.getAnnotationParameterValues(c, Entity.class);
            if (extended && entityAnnotation != null && (value = entityAnnotation.get("name")) != null) {
                config.put(ENTITY_NAME, value.toString());
            }
            if ((idClassAnnotation = DataSourceAnnotations.getAnnotationParameterValues(c, IdClass.class)) != null) {
                Class idClass = (Class)idClassAnnotation.get("value");
                config.put("idClassName", idClass.getName());
                config.put(IS_EMBEDDED_ID, Boolean.FALSE);
            }
            Class clazz = c;
            synchronized (clazz) {
                String cacheKey = c.getName() + "*" + extended;
                ArrayList<Map<String, Object>> dsFields = cache.get(cacheKey);
                if (dsFields == null) {
                    Map<String, Object> dsField;
                    log.debug("Read DSFields from class");
                    try {
                        Map<String, Object> superClassDS = DataSourceAnnotations.getDataSourceConfigFromAnnotatedClass(c.getSuperclass(), extended, assumeAnnotations, serverType, constructor);
                        dsFields = (ArrayList<Map<String, Object>>)superClassDS.get("fields");
                        dsFields = new ArrayList<Map<String, Object>>(dsFields);
                    }
                    catch (Exception ex) {
                        dsFields = new ArrayList<Map<String, Object>>();
                    }
                    Field[] fields = c.getDeclaredFields();
                    Method[] methods = c.getMethods();
                    boolean annotatedFields = false;
                    for (Field field : fields) {
                        if (!DataSourceAnnotations.hasAnnotation(field, Id.class, EmbeddedId.class)) continue;
                        log.debug("Fields are annotated.");
                        annotatedFields = true;
                        break;
                    }
                    if (!annotatedFields) {
                        void var19_25;
                        boolean annotatedMethods = false;
                        Method[] methodArray = methods;
                        int n = methodArray.length;
                        boolean bl = false;
                        while (var19_25 < n) {
                            Method method = methodArray[var19_25];
                            if (DataSourceAnnotations.hasAnnotation(method, Id.class, EmbeddedId.class)) {
                                log.debug("Methods are annotated.");
                                annotatedMethods = true;
                                break;
                            }
                            ++var19_25;
                        }
                        if (!annotatedMethods) {
                            log.debug("Neither fields nor methods are annotated. Using fields.");
                            annotatedFields = true;
                        }
                    }
                    if (annotatedFields) {
                        for (AccessibleObject accessibleObject : fields) {
                            log.debug("Generating field '" + DataSourceAnnotations.getPropertyName(accessibleObject) + "' of type " + ((Field)accessibleObject).getType().getName());
                            dsField = DataSourceAnnotations.getDSField(accessibleObject, extended);
                            if (dsField == null) {
                                log.debug("Skipping.");
                                continue;
                            }
                            if (dsField.isEmpty()) {
                                String embeddedPropertyName;
                                HashMap<String, Object> newField;
                                List embeddedFields;
                                Map<Object, Object> embeddedClassDS;
                                String propertyName = DataSourceAnnotations.getPropertyName(accessibleObject);
                                Map<String, Object> annotationValues = DataSourceAnnotations.getAnnotationParameterValues(accessibleObject, Embedded.class);
                                if (annotationValues != null) {
                                    log.debug("Property with embedded fields. Generating subproperties for type " + ((Field)accessibleObject).getType().getName());
                                    embeddedClassDS = new HashMap();
                                    try {
                                        embeddedClassDS = DataSourceAnnotations.getDataSourceConfigFromAnnotatedClass(((Field)accessibleObject).getType(), extended, true, serverType, constructor);
                                    }
                                    catch (Exception ex) {
                                        log.warn((Object)"Caught Exception attempting to derive dataSource config from annotated class", ex);
                                    }
                                    embeddedFields = (List)embeddedClassDS.get("fields");
                                    for (Map embeddedField : embeddedFields) {
                                        newField = new HashMap<String, Object>(embeddedField);
                                        embeddedPropertyName = (String)embeddedField.get("name");
                                        newField.put("name", propertyName + "_" + embeddedPropertyName);
                                        newField.put("valueXPath", ((Field)accessibleObject).getName() + "." + embeddedField.get("name"));
                                        newField.put("useJoin", Boolean.FALSE);
                                        dsFields.add(newField);
                                        log.debug("Updated subproperty field configuration: " + newField);
                                    }
                                    log.debug("Subproperties generated.");
                                    continue;
                                }
                                annotationValues = DataSourceAnnotations.getAnnotationParameterValues(accessibleObject, EmbeddedId.class);
                                if (annotationValues != null) {
                                    config.put("idClassName", ((Field)accessibleObject).getType().getName());
                                    config.put(IS_EMBEDDED_ID, Boolean.TRUE);
                                    log.debug("Property with embedded fields. Generating subproperties for type " + ((Field)accessibleObject).getType().getName());
                                    embeddedClassDS = new HashMap();
                                    try {
                                        embeddedClassDS = DataSourceAnnotations.getDataSourceConfigFromAnnotatedClass(((Field)accessibleObject).getType(), extended, true, serverType, constructor);
                                    }
                                    catch (Exception ex) {
                                        log.warn(ex);
                                    }
                                    embeddedFields = (List)embeddedClassDS.get("fields");
                                    for (Map embeddedField : embeddedFields) {
                                        newField = new HashMap(embeddedField);
                                        embeddedPropertyName = (String)embeddedField.get("name");
                                        newField.put("name", propertyName + "_" + embeddedPropertyName);
                                        newField.put("valueXPath", ((Field)accessibleObject).getName() + "." + embeddedField.get("name"));
                                        newField.put("useJoin", Boolean.FALSE);
                                        newField.put("primaryKey", Boolean.TRUE);
                                        dsFields.add(newField);
                                        log.debug("Updated subproperty field configuration: " + newField);
                                    }
                                    log.debug("Subproperties generated.");
                                    continue;
                                }
                            } else {
                                log.debug("Field configuration generated: " + dsField);
                            }
                            dsFields.add(dsField);
                        }
                    } else {
                        for (AccessibleObject accessibleObject : methods) {
                            log.debug("Generating field '" + DataSourceAnnotations.getPropertyName(accessibleObject) + "' of type " + ((Method)accessibleObject).getReturnType().getName());
                            dsField = DataSourceAnnotations.getDSField(accessibleObject, extended);
                            if (dsField == null) {
                                log.debug("Skipping.");
                                continue;
                            }
                            if (dsField.isEmpty()) {
                                String embeddedPropertyName;
                                HashMap<String, Object> newField;
                                List embeddedFields;
                                Map<Object, Object> embeddedClassDS;
                                String methodName = DataSourceAnnotations.getPropertyName(accessibleObject);
                                Map<String, Object> annotationValues = DataSourceAnnotations.getAnnotationParameterValues(accessibleObject, Embedded.class);
                                if (annotationValues != null) {
                                    log.debug("Property with embedded fields. Generating subproperties for type " + ((Method)accessibleObject).getReturnType().getName());
                                    embeddedClassDS = new HashMap();
                                    try {
                                        embeddedClassDS = DataSourceAnnotations.getDataSourceConfigFromAnnotatedClass(((Method)accessibleObject).getReturnType(), extended, true, serverType, constructor);
                                    }
                                    catch (Exception ex) {
                                        log.warn(ex);
                                    }
                                    embeddedFields = (List)embeddedClassDS.get("fields");
                                    for (Map embeddedField : embeddedFields) {
                                        newField = new HashMap<String, Object>(embeddedField);
                                        embeddedPropertyName = (String)embeddedField.get("name");
                                        newField.put("name", methodName + "_" + embeddedPropertyName);
                                        newField.put("valueXPath", methodName + "." + embeddedField.get("name"));
                                        newField.put("useJoin", Boolean.FALSE);
                                        dsFields.add(newField);
                                        log.debug("Updated subproperty field configuration: " + newField);
                                    }
                                    log.debug("Subproperties generated.");
                                    continue;
                                }
                                annotationValues = DataSourceAnnotations.getAnnotationParameterValues(accessibleObject, EmbeddedId.class);
                                if (annotationValues != null) {
                                    config.put("idClassName", ((Method)accessibleObject).getReturnType().getName());
                                    config.put(IS_EMBEDDED_ID, Boolean.TRUE);
                                    log.debug("Property with embedded fields. Generating subproperties for type " + ((Method)accessibleObject).getReturnType().getName());
                                    embeddedClassDS = new HashMap();
                                    try {
                                        embeddedClassDS = DataSourceAnnotations.getDataSourceConfigFromAnnotatedClass(((Method)accessibleObject).getReturnType(), extended, true, serverType, constructor);
                                    }
                                    catch (Exception ex) {
                                        log.warn(ex);
                                    }
                                    embeddedFields = (List)embeddedClassDS.get("fields");
                                    for (Map embeddedField : embeddedFields) {
                                        newField = new HashMap(embeddedField);
                                        embeddedPropertyName = (String)embeddedField.get("name");
                                        newField.put("name", methodName + "_" + embeddedPropertyName);
                                        newField.put("valueXPath", methodName + "." + embeddedField.get("name"));
                                        newField.put("useJoin", Boolean.FALSE);
                                        newField.put("primaryKey", Boolean.TRUE);
                                        dsFields.add(newField);
                                        log.debug("Updated subproperty field configuration: " + newField);
                                    }
                                    log.debug("Subproperties generated.");
                                    continue;
                                }
                            } else {
                                log.debug("Field configuration generated: " + dsField);
                            }
                            dsFields.add(dsField);
                        }
                    }
                    cache.put(cacheKey, BasicDataSource.sortDSFields(dsFields));
                } else {
                    log.debug("Use cached DSFields");
                }
                config.put("fields", dsFields);
            }
            return config;
        }
        if (!assumeAnnotations) {
            return null;
        }
        throw new Exception("Class is not annotated as entity: " + c.getName());
    }

    public static Map<String, Object> getDSField(Object property, boolean extended) throws Exception {
        Object value;
        HashMap<String, Object> dsField = new HashMap<String, Object>();
        Class<?> propertyType = null;
        String propertyName = DataSourceAnnotations.getPropertyName(property);
        if (propertyName == null) {
            return null;
        }
        int modifiers = 0;
        if (property instanceof Field) {
            propertyType = ((Field)property).getType();
            modifiers = ((Field)property).getModifiers();
        } else if (property instanceof Method) {
            propertyType = ((Method)property).getReturnType();
            modifiers = ((Method)property).getModifiers();
        }
        if ("class".equals(propertyName)) {
            return null;
        }
        if (extended) {
            if (Modifier.isStatic(modifiers)) {
                dsField.put(IS_STATIC, Boolean.TRUE);
            }
            if (Modifier.isFinal(modifiers)) {
                dsField.put(IS_FINAL, Boolean.TRUE);
            }
            if (Modifier.isTransient(modifiers)) {
                dsField.put(IS_TRANSIENT, Boolean.TRUE);
            }
            if (DataSourceAnnotations.hasAnnotation(property, Transient.class)) {
                dsField.put(IS_TRANSIENT, Boolean.TRUE);
            }
        } else {
            if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || Modifier.isTransient(modifiers)) {
                return null;
            }
            if (DataSourceAnnotations.hasAnnotation(property, Transient.class)) {
                return null;
            }
        }
        if (DataSourceAnnotations.hasAnnotation(property, Embedded.class, EmbeddedId.class)) {
            return dsField;
        }
        dsField.put("name", propertyName);
        dsField.put("type", DataSourceAnnotations.dsTypeForJavaType(propertyType));
        Map<String, Object> annotationValues = DataSourceAnnotations.getAnnotationParameterValues(property, Enumerated.class);
        if (annotationValues != null) {
            value = annotationValues.get("value");
            if (value != null && EnumType.STRING.equals(value)) {
                Map<Object, String> values = Reflection.getEnumValues(propertyType, false);
                dsField.put("type", "enum");
                dsField.put("valueMap", values);
            } else {
                Map<Object, String> values = Reflection.getEnumValues(propertyType, true);
                dsField.put("type", "intEnum");
                dsField.put("valueMap", values);
            }
        }
        if ((annotationValues = DataSourceAnnotations.getAnnotationParameterValues(property, Temporal.class)) != null) {
            value = annotationValues.get("value");
            if (TemporalType.DATE.equals(value)) {
                dsField.put("type", "date");
            } else if (TemporalType.TIME.equals(value)) {
                dsField.put("type", "time");
            } else {
                dsField.put("type", "datetime");
            }
        }
        if ((annotationValues = DataSourceAnnotations.getAnnotationParameterValues(property, Basic.class)) != null) {
            value = annotationValues.get("optional");
            if (value != null) {
                if (value instanceof Boolean) {
                    dsField.put("required", (Boolean)value == false);
                }
            } else {
                dsField.put("required", Boolean.FALSE);
            }
            if (extended) {
                value = annotationValues.get("fetch");
                if (value != null) {
                    if (FetchType.LAZY.equals(value)) {
                        dsField.put(IS_LAZY, Boolean.TRUE);
                    } else {
                        dsField.put(IS_LAZY, Boolean.FALSE);
                    }
                } else {
                    dsField.put(IS_LAZY, Boolean.FALSE);
                }
            }
        }
        if ((annotationValues = DataSourceAnnotations.getAnnotationParameterValues(property, Column.class)) != null) {
            value = annotationValues.get("nullable");
            if (value != null) {
                if (value instanceof Boolean) {
                    dsField.put("required", (Boolean)value == false);
                }
            } else {
                dsField.put("required", Boolean.FALSE);
            }
            value = annotationValues.get("insertable");
            dsField.put("canEdit", Boolean.TRUE);
            if (value != null && value instanceof Boolean) {
                dsField.put("canEdit", value);
            }
            if ((value = annotationValues.get("updatable")) != null) {
                if (value instanceof Boolean && Boolean.FALSE.equals(dsField.get("canEdit"))) {
                    dsField.put("canEdit", value);
                }
            } else {
                dsField.put("canEdit", Boolean.TRUE);
            }
            if ((value = annotationValues.get("length")) != null && value instanceof Integer) {
                dsField.put("length", value);
            }
            if (extended) {
                value = annotationValues.get("precision");
                if (value != null && value instanceof Integer) {
                    dsField.put(PRECISION, value);
                }
                if ((value = annotationValues.get("scale")) != null && value instanceof Integer) {
                    dsField.put(SCALE, value);
                }
                value = annotationValues.get("unique");
                dsField.put(IS_UNIQUE, Boolean.FALSE);
                if (value != null && value instanceof Boolean) {
                    dsField.put(IS_UNIQUE, value);
                }
            }
        }
        if ((annotationValues = DataSourceAnnotations.getAnnotationParameterValues(property, Id.class)) != null) {
            dsField.put("primaryKey", Boolean.TRUE);
        }
        if ((annotationValues = DataSourceAnnotations.getAnnotationParameterValues(property, GeneratedValue.class)) != null) {
            if ("integer".equals(dsField.get("type"))) {
                dsField.put("type", "sequence");
            } else {
                dsField.put("autoGenerated", Boolean.TRUE);
            }
            dsField.put("hidden", Boolean.TRUE);
            dsField.put("canEdit", Boolean.FALSE);
            dsField.put("required", Boolean.FALSE);
        }
        if ((annotationValues = DataSourceAnnotations.getAnnotationParameterValues(property, Lob.class)) != null) {
            dsField.put("type", "binary");
        }
        if (extended && (annotationValues = DataSourceAnnotations.getAnnotationParameterValues(property, Version.class)) != null) {
            dsField.put(IS_VERSION, Boolean.TRUE);
        }
        return dsField;
    }

    public static String getPropertyName(Object property) {
        if (property instanceof Field) {
            return ((Field)property).getName();
        }
        if (property instanceof Method) {
            String propertyName = ((Method)property).getName();
            if (propertyName.startsWith("get")) {
                propertyName = propertyName.substring(3);
            } else if (propertyName.startsWith("is")) {
                propertyName = propertyName.substring(2);
            } else {
                return null;
            }
            propertyName = propertyName.substring(0, 1).toLowerCase() + propertyName.substring(1);
            return propertyName;
        }
        return null;
    }

    public static String dsTypeForJavaType(Class type) {
        if (type.isArray()) {
            return "any";
        }
        if (Boolean.TYPE.equals(type)) {
            return "boolean";
        }
        if (Byte.TYPE.equals(type)) {
            return "integer";
        }
        if (Short.TYPE.equals(type)) {
            return "integer";
        }
        if (Integer.TYPE.equals(type)) {
            return "integer";
        }
        if (Long.TYPE.equals(type)) {
            return "integer";
        }
        if (Float.TYPE.equals(type)) {
            return "float";
        }
        if (Double.TYPE.equals(type)) {
            return "float";
        }
        if (Character.TYPE.equals(type)) {
            return "text";
        }
        if (String.class.isAssignableFrom(type)) {
            return "text";
        }
        if (Character.class.isAssignableFrom(type)) {
            return "text";
        }
        if (Reader.class.isAssignableFrom(type)) {
            return "text";
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return "boolean";
        }
        if (Byte.class.isAssignableFrom(type)) {
            return "integer";
        }
        if (Short.class.isAssignableFrom(type)) {
            return "integer";
        }
        if (Integer.class.isAssignableFrom(type)) {
            return "integer";
        }
        if (Long.class.isAssignableFrom(type)) {
            return "integer";
        }
        if (Float.class.isAssignableFrom(type)) {
            return "float";
        }
        if (Double.class.isAssignableFrom(type)) {
            return "float";
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return "integer";
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return "float";
        }
        if (java.util.Date.class.isAssignableFrom(type)) {
            return "datetime";
        }
        if (Calendar.class.isAssignableFrom(type)) {
            return "datetime";
        }
        if (Date.class.isAssignableFrom(type)) {
            return "date";
        }
        if (Time.class.isAssignableFrom(type)) {
            return "time";
        }
        if (Timestamp.class.isAssignableFrom(type)) {
            return "datetime";
        }
        if (type.isEnum()) {
            return "enum";
        }
        if (InputStream.class.isAssignableFrom(type)) {
            return "binary";
        }
        if (File.class.isAssignableFrom(type)) {
            return "binary";
        }
        return "any";
    }

    public static boolean hasAnnotation(Object target, Class ... annotationClasses) {
        Annotation[] annotations = new Annotation[]{};
        if (target instanceof Class) {
            Class c = (Class)target;
            annotations = c.getAnnotations();
        } else if (target instanceof Field) {
            Field f = (Field)target;
            annotations = f.getAnnotations();
        } else if (target instanceof Method) {
            Method m = (Method)target;
            annotations = m.getAnnotations();
        }
        for (Annotation annotation : annotations) {
            for (Class annotationClass : annotationClasses) {
                if (!annotationClass.isInstance(annotation)) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<String, Object> getAnnotationParameterValues(Object target, Class<? extends Annotation> annotationClass) {
        Annotation[] annotations = new Annotation[]{};
        if (target instanceof Class) {
            Class c = (Class)target;
            annotations = c.getAnnotations();
        } else if (target instanceof Field) {
            Field f = (Field)target;
            annotations = f.getAnnotations();
        } else if (target instanceof Method) {
            Method m = (Method)target;
            annotations = m.getAnnotations();
        }
        for (Annotation annotation : annotations) {
            if (!annotationClass.isInstance(annotation)) continue;
            return DataSourceAnnotations.getAnnotationParameterValues(annotation);
        }
        return null;
    }

    public static Map<String, Object> getAnnotationParameterValues(Annotation annotation) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (annotation != null) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            for (Method method : annotationType.getMethods()) {
                String name = method.getName();
                if ("annotationType".equals(name) || "equals".equals(name) || "getClass".equals(name) || "hashCode".equals(name) || "notify".equals(name) || "notifyAll".equals(name) || "toString".equals(name) || "wait".equals(name)) continue;
                Object value = null;
                try {
                    value = method.invoke((Object)annotation, new Object[0]);
                }
                catch (IllegalAccessException ex) {
                    log.warn(ex);
                }
                catch (IllegalArgumentException ex) {
                    log.warn(ex);
                }
                catch (InvocationTargetException ex) {
                    log.warn(ex);
                }
                values.put(method.getName(), value);
            }
        }
        return values;
    }
}

