/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.datasource;

import com.isomorphic.log.Logger;
import java.util.Arrays;

class RelationContext {
    private static Logger log = new Logger(RelationContext.class);
    private String[] queryFK;
    private boolean inverseFKString = false;
    private String[] ds;
    private String[] field;
    private int current = 0;
    private int drafted = -1;

    protected static RelationContext instance(RelationContext ctx) {
        if (ctx == null || ctx.empty() || ctx.finished()) {
            return null;
        }
        RelationContext newCtx = new RelationContext();
        newCtx.queryFK = ctx.queryFK;
        newCtx.inverseFKString = ctx.inverseFKString;
        newCtx.init();
        newCtx.current = ctx.current;
        newCtx.drafted = ctx.drafted;
        return newCtx;
    }

    protected static RelationContext instance(String queryFKString) {
        return RelationContext.instance(queryFKString, false);
    }

    protected static RelationContext instance(String queryFKString, boolean inverseFKString) {
        RelationContext newCtx = new RelationContext();
        if (queryFKString != null && !queryFKString.trim().isEmpty()) {
            newCtx.queryFK = queryFKString.split(":");
            newCtx.inverseFKString = inverseFKString;
            newCtx.init();
        }
        if (!newCtx.empty()) {
            return newCtx;
        }
        return null;
    }

    private RelationContext() {
    }

    private void init() {
        int length = this.queryFK.length;
        if (length > 0) {
            this.ds = new String[length];
            this.field = new String[length];
            if (this.inverseFKString) {
                int start = 0;
                for (int end = length - 1; start < end; ++start, --end) {
                    String temp = this.queryFK[start];
                    this.queryFK[start] = this.queryFK[end];
                    this.queryFK[end] = temp;
                }
            }
            for (int i = 0; i < length; ++i) {
                String instruction = this.queryFK[i];
                String[] parts = instruction.split("\\.");
                if (parts.length == 2) {
                    this.ds[i] = parts[0];
                    this.field[i] = parts[1];
                    continue;
                }
                if (parts.length == 1) {
                    this.ds[i] = null;
                    this.field[i] = parts[0];
                    continue;
                }
                log.debug("Cannot use queryFK fragment: '" + instruction + "', incorrect format.");
                this.queryFK = null;
                this.ds = null;
                this.field = null;
                break;
            }
        }
    }

    protected String ds() {
        if (this.queryFK != null && this.current >= 0 && this.current < this.queryFK.length) {
            return this.ds[this.current];
        }
        return null;
    }

    protected String field() {
        if (this.queryFK != null && this.current >= 0 && this.current < this.queryFK.length) {
            return this.field[this.current];
        }
        return null;
    }

    protected void draft() {
        this.drafted = this.current;
    }

    protected RelationContext cancel() {
        if (this.drafted()) {
            --this.drafted;
        }
        return this;
    }

    protected RelationContext confirm() {
        if (this.drafted()) {
            ++this.current;
        }
        return this;
    }

    protected RelationContext next() {
        this.draft();
        this.confirm();
        return this;
    }

    protected boolean drafted() {
        return this.drafted >= 0 && this.drafted == this.current;
    }

    protected boolean inUse() {
        return this.drafted >= 0 && this.current > this.drafted && this.current < this.queryFK.length;
    }

    protected boolean finished() {
        if (this.empty()) {
            return true;
        }
        return this.current >= this.queryFK.length;
    }

    protected boolean empty() {
        return this.queryFK == null || this.queryFK.length == 0;
    }

    protected void setState(RelationContext ctx) {
        this.current = ctx.current;
        this.drafted = ctx.drafted;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RelationContext{");
        sb.append("queryFK=").append(this.queryFK == null ? "null" : Arrays.asList(this.queryFK).toString());
        sb.append(", inverseFKString=").append(this.inverseFKString);
        sb.append(", ds=").append(this.ds == null ? "null" : Arrays.asList(this.ds).toString());
        sb.append(", field=").append(this.field == null ? "null" : Arrays.asList(this.field).toString());
        sb.append(", current=").append(this.current);
        sb.append(", drafted=").append(this.drafted);
        sb.append('}');
        return sb.toString();
    }
}

