/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.hibernate;

import com.isomorphic.base.Config;
import com.isomorphic.interfaces.IHibernateSpringBridge;
import com.isomorphic.log.Logger;
import com.isomorphic.spring.SpringApplicationContextProvider;
import com.isomorphic.springhibernate3.SessionFactoryUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

public class HibernateSpringBridge
implements IHibernateSpringBridge {
    Logger log = new Logger(HibernateSpringBridge.class.getName());

    public Session getSession(String beanName) throws Exception {
        if (beanName == null) {
            beanName = Config.getGlobal().getString((Object)"hibernate.spring.sessionFactoryBean");
        }
        SessionFactory sf = (SessionFactory)SpringApplicationContextProvider.getInstance().getBean(beanName, SessionFactory.class);
        Session sess = SessionFactoryUtils.getSession((SessionFactory)sf, (boolean)true);
        this.log.debug((Object)("Returning Spring/Hibernate Session '" + sess.hashCode() + "'"));
        return sess;
    }

    public Object getTransaction(String beanName) throws Exception {
        Session sess = this.getSession(beanName);
        this.log.debug((Object)("Returning Spring/Hibernate Transaction '" + sess.getTransaction().hashCode() + "'"));
        return sess.getTransaction();
    }

    public void freeTransaction(String beanName) throws Exception {
        Session sess = this.getSession(beanName);
        sess.close();
    }
}

