/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.autotest;

import com.isomorphic.autotest.WebDriverProvider;
import com.isomorphic.base.Service;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Select;

public abstract class SeleniumScript
extends Service {
    public String webDriver = "Chrome";
    public boolean slowDataEntry = false;
    public int DATA_ENTRY_DELAY_MS = 100;
    protected WebDriver driver = null;
    protected WebElement lastElement = null;

    public void completeInit() throws Exception {
        this.driver = WebDriverProvider.get(this.webDriver);
    }

    protected void _go(String targetPage) {
        this.log.debug((Object)("_go: " + targetPage));
        this.driver.get(targetPage);
        this._waitForBrowserDone();
    }

    protected WebElement _click(String name, By by) {
        return this._click(name, this._focus(name, by));
    }

    protected WebElement _click(String name) {
        return this._click(name, this.lastElement);
    }

    protected WebElement _click(String name, WebElement elem) {
        this.log.debug((Object)("_click: " + elem.toString()));
        this._waitForBrowserDone();
        elem.click();
        this._waitForBrowserDone();
        this.lastElement = elem;
        return this.lastElement;
    }

    protected WebElement _addUpload(String name, By by, File file) {
        return this._addUpload(name, this._focus(name, by), file.getAbsolutePath());
    }

    protected WebElement _addUpload(String name, By by, String absolutePath) {
        return this._addUpload(name, this._focus(name, by), absolutePath);
    }

    protected WebElement _addUpload(String name, File file) {
        return this._addUpload(name, this._focus(this.lastElement), file.getAbsolutePath());
    }

    protected WebElement _addUpload(String name, String absolutePath) {
        return this._addUpload(name, this._focus(this.lastElement), absolutePath);
    }

    protected WebElement _addUpload(String name, WebElement elem, String absolutePath) {
        this._waitForBrowserDone();
        elem.sendKeys(new CharSequence[]{absolutePath});
        this._waitForBrowserDone();
        return elem;
    }

    protected WebElement _input(String name, By by, String value) {
        return this._input(name, this._focus(name, by), value);
    }

    protected WebElement _input(String name, String value) {
        return this._input(name, this._focus(this.lastElement), value);
    }

    protected WebElement _input(String name, WebElement elem, String value) {
        this.log.debug((Object)("_input: " + elem.toString() + " -> " + value));
        this._waitForBrowserDone();
        elem.clear();
        this._waitForBrowserDone();
        if (this.slowDataEntry) {
            for (String s : value.split("")) {
                elem.sendKeys(new CharSequence[]{s});
                this._sleep(this.DATA_ENTRY_DELAY_MS);
            }
            this._waitForBrowserDone();
            this.lastElement = elem;
        } else {
            elem.sendKeys(new CharSequence[]{value});
        }
        this._tab();
        return this.lastElement;
    }

    protected WebElement _select(String name, By by, String value) {
        return this._select(name, this._focus(name, by), value);
    }

    protected WebElement _select(String name, String value) {
        return this._select(name, this.lastElement, value);
    }

    protected WebElement _select(String name, WebElement elem, String value) {
        this.log.debug((Object)("_select: " + elem.toString() + " -> " + value));
        this._waitForBrowserDone();
        new Select(elem).selectByValue(value);
        this._waitForBrowserDone();
        this.lastElement = elem;
        return this.lastElement;
    }

    protected WebElement _tab() {
        this.log.debug((Object)("_tab: " + this.lastElement.toString()));
        this._waitForBrowserDone();
        this.lastElement.sendKeys(new CharSequence[]{Keys.TAB.toString()});
        this._waitForBrowserDone();
        this.lastElement = this.driver.switchTo().activeElement();
        this._waitForBrowserDone();
        return this.lastElement;
    }

    protected WebElement _shiftTab() {
        this.log.debug((Object)("_shiftTab: " + this.lastElement.toString()));
        this._waitForBrowserDone();
        this.lastElement.sendKeys(new CharSequence[]{Keys.chord((CharSequence[])new CharSequence[]{Keys.SHIFT, Keys.TAB}).toString()});
        this._waitForBrowserDone();
        this.lastElement = this.driver.switchTo().activeElement();
        this._waitForBrowserDone();
        return this.lastElement;
    }

    protected boolean _exists(By by) {
        return this._find(by) != null;
    }

    protected WebElement _find(By by) {
        this._waitForBrowserDone();
        try {
            this.lastElement = this.driver.findElement(by);
            return this.lastElement;
        }
        catch (NoSuchElementException ignored) {
            return null;
        }
    }

    protected WebElement _focus() {
        return this._focus(this.lastElement);
    }

    protected WebElement _focus(WebElement elem) {
        this.log.debug((Object)("_focus: " + elem.toString()));
        this._waitForBrowserDone();
        if (elem.isDisplayed() && elem.isEnabled()) {
            ((JavascriptExecutor)this.driver).executeScript("arguments[0].scrollIntoView(true);arguments[0].focus()", new Object[]{elem});
            new Actions(this.driver).moveToElement(elem).perform();
            ((JavascriptExecutor)this.driver).executeScript("arguments[0].focus()", new Object[]{elem});
            this._waitForBrowserDone();
            this.lastElement = elem;
            return this.lastElement;
        }
        return null;
    }

    protected WebElement _focus(By by) {
        return this._focus(null, by);
    }

    protected WebElement _focus(final String name, final By by) {
        this.log.debug((Object)("_focus: " + by.toString()));
        this._waitForBrowserDone();
        FluentWait wait = new FluentWait((Object)this.driver).withTimeout(30L, TimeUnit.SECONDS).pollingEvery(1L, TimeUnit.SECONDS).ignoring(NoSuchElementException.class);
        if (name != null) {
            wait = wait.withMessage((Supplier)new Supplier<String>(){

                @Override
                public String get() {
                    return "Failed while waiting for element with symbolic name: " + name + " at: " + by.toString();
                }
            });
        }
        this.lastElement = (WebElement)wait.until((Function)new Function<WebDriver, WebElement>(){

            @Override
            public WebElement apply(WebDriver driver) {
                WebElement elem = driver.findElement(by);
                if (elem == null) {
                    return null;
                }
                if (elem.isDisplayed() && elem.isEnabled()) {
                    return SeleniumScript.this._focus(elem);
                }
                return null;
            }
        });
        return this.lastElement;
    }

    protected String _readFormField(By by) {
        return this._readFormField(null, by);
    }

    protected String _readFormField(String name, By by) {
        this._focus(name, by);
        return this._readFormField();
    }

    protected String _readFormField() {
        return this._readFormField(this.lastElement);
    }

    protected String _readFormField(WebElement elem) {
        this._waitForBrowserDone();
        return elem.getAttribute("value");
    }

    protected Object _exec(String js) {
        return this._exec(null, js, 4L, TimeUnit.MINUTES);
    }

    protected Object _exec(String js, long time, TimeUnit unit) {
        return this._exec(null, js, time, unit);
    }

    protected Object _exec(String name, String js) {
        return this._exec(name, js, 4L, TimeUnit.MINUTES);
    }

    protected Object _exec(final String name, final String js, long time, TimeUnit unit) {
        this._waitForBrowserDone();
        this.driver.manage().timeouts().pageLoadTimeout(time, unit);
        FluentWait wait = new FluentWait((Object)this.driver).withTimeout(time, unit).pollingEvery(100L, TimeUnit.MILLISECONDS).withMessage((Supplier)new Supplier<String>(){

            @Override
            public String get() {
                return "Failed while waiting for _exec with symbolic name: " + name + "(js: -->" + js + "<--)";
            }
        });
        Object result = wait.until((Function)new Function<WebDriver, Object>(){

            @Override
            public Object apply(WebDriver driver) {
                String script = js;
                if (!js.startsWith("return ")) {
                    script = "window._isc_result = " + js + "; return (_isc_result === null || _isc_result === false) ? 'ISC_NULL_RESULT':_isc_result;";
                }
                return ((JavascriptExecutor)driver).executeScript(script, new Object[0]);
            }
        });
        this._waitForBrowserDone();
        if (result instanceof String && "ISC_NULL_RESULT".equals((String)result)) {
            return null;
        }
        return result;
    }

    protected void _waitForBrowserDone() {
        this.driver.manage().timeouts().pageLoadTimeout(30L, TimeUnit.SECONDS);
        FluentWait wait = new FluentWait((Object)this.driver).withTimeout(30L, TimeUnit.SECONDS).pollingEvery(1L, TimeUnit.SECONDS).withMessage((Supplier)new Supplier<String>(){

            @Override
            public String get() {
                return "Failed while waiting for browserDone";
            }
        });
        wait.until((Function)new Function<WebDriver, Boolean>(){

            @Override
            public Boolean apply(WebDriver driver) {
                String script = "return window.jQuery == null || !jQuery.active";
                Boolean doneWaiting = (Boolean)((JavascriptExecutor)driver).executeScript(script, new Object[0]);
                return doneWaiting;
            }
        });
    }

    protected void _sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected String _stripHTMLPretty(WebElement elem) {
        return this._stripHTMLPretty(elem.getAttribute("innerHTML"));
    }

    protected String _stripHTMLPretty(String s) {
        if (s == null) {
            return null;
        }
        return s.replaceAll("\\<[^>]*?>", " ").replaceAll("[<>\"']", "").replaceAll("\\s+", " ");
    }

    protected List<String> _regexGroups(String text, String regex) {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(text);
        ArrayList<String> groups = new ArrayList<String>();
        if (m.find()) {
            for (int i = 0; i <= m.groupCount(); ++i) {
                groups.add(m.group(i));
            }
            return groups;
        }
        return null;
    }

    protected String _regexGroup(String text, String regex, int groupNum) {
        List<String> groups = this._regexGroups(text, regex);
        if (groups == null || groups.size() - 1 < groupNum) {
            return null;
        }
        return groups.get(groupNum);
    }
}

