/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util.date;

import com.isomorphic.log.Logger;
import com.isomorphic.util.date.DateUtil;
import com.isomorphic.util.date.RelativeDateRangePosition;
import com.isomorphic.util.date.RelativeDateShortcut;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang.math.NumberUtils;

public class RelativeDate
implements Comparable<RelativeDate> {
    private static Logger log = new Logger(RelativeDate.class);
    private RelativeDateRangePosition rangePosition;
    private String direction;
    private RelativeDate qualifier;
    private int value;
    private String period;

    public RelativeDate(RelativeDateShortcut shortcut) {
        this(shortcut.getShortcut());
    }

    public RelativeDate(RelativeDateShortcut shortcut, RelativeDateRangePosition rangePosition) {
        this(shortcut.getShortcut(), rangePosition);
    }

    public RelativeDate(String relativeDate) {
        this(relativeDate, RelativeDateRangePosition.START);
    }

    public RelativeDate(String relativeDate, RelativeDateRangePosition rangePosition) {
        this.rangePosition = rangePosition;
        this.parse(relativeDate);
    }

    public GregorianCalendar getAbsoluteDate(boolean isLogicalDate) {
        return this.getAbsoluteDate(null, isLogicalDate);
    }

    public GregorianCalendar getAbsoluteDate(Date baseDate, boolean isLogicalDate) {
        return this.getAbsoluteDate(baseDate, isLogicalDate, null);
    }

    public GregorianCalendar getAbsoluteDate(Date baseDate, boolean isLogicalDate, TimeZone tz) {
        GregorianCalendar localBaseDate = tz == null ? new GregorianCalendar() : new GregorianCalendar(tz);
        if (baseDate != null) {
            localBaseDate.setTime(baseDate);
        }
        if (this.qualifier != null) {
            List<String> qualifierPeriodOptions = Arrays.asList("S", "MN", "N", "H", "D", "W", "M", "Q", "Y", "YY", "YYYY");
            if (qualifierPeriodOptions.contains(this.qualifier.getPeriod())) {
                localBaseDate = DateUtil.dateAdd(localBaseDate, this.qualifier.getPeriod(), this.qualifier.getValue(), this.qualifier.getMultiplier(), isLogicalDate);
            } else {
                log.warn("Invalid date-offset qualifier provided: " + this.qualifier.getPeriod() + ".  Valid options are: S, MN (or N), H, D, W, M, Q and Y (or YY, YYYY).");
            }
        }
        return DateUtil.dateAdd(localBaseDate, this.getPeriod(), this.getValue(), this.getMultiplier(), isLogicalDate);
    }

    private void parse(String relativeDateString) {
        if (relativeDateString.startsWith("$")) {
            RelativeDateShortcut shortcut = RelativeDateShortcut.parseShortcut(relativeDateString);
            relativeDateString = shortcut.toRelativeDateString(this.rangePosition);
        }
        String direction = relativeDateString.substring(0, 1);
        int bracketIndex = relativeDateString.indexOf("[");
        String qualifier = bracketIndex > 0 ? relativeDateString.substring(bracketIndex) : null;
        String withoutQualifier = qualifier != null ? relativeDateString.substring(1, bracketIndex) : relativeDateString.substring(1);
        String count = "";
        String period = "";
        for (int i = 0; i < withoutQualifier.length(); ++i) {
            char character = withoutQualifier.charAt(i);
            if (Character.isDigit(character)) {
                count = count + character;
                continue;
            }
            period = period + character;
        }
        int countValue = NumberUtils.toInt((String)count, (int)0);
        if (qualifier != null) {
            this.qualifier = new RelativeDate(qualifier.replaceAll("[\\[\\],]", "").toUpperCase());
        }
        this.direction = "+".equals(direction) || "-".equals(direction) ? direction : "+";
        this.value = countValue;
        this.period = period.length() > 0 ? period.replaceAll("[\\[\\]]", "") : direction;
    }

    private int getMultiplier() {
        return "+".equals(this.getDirection()) ? 1 : -1;
    }

    public RelativeDateRangePosition getRangePosition() {
        return this.rangePosition;
    }

    public void setRangePosition(RelativeDateRangePosition rangePosition) {
        this.rangePosition = rangePosition;
    }

    public String getDirection() {
        return this.direction;
    }

    public RelativeDate getQualifier() {
        return this.qualifier;
    }

    public int getValue() {
        return this.value;
    }

    public String getPeriod() {
        return this.period;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public void setQualifier(RelativeDate qualifier) {
        this.qualifier = qualifier;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public void setPeriod(String period) {
        this.period = period;
    }

    public String toString() {
        return "RelativeDate{rangePosition=" + (Object)((Object)this.rangePosition) + ", direction='" + this.direction + '\'' + ", qualifier=" + this.qualifier + ", value=" + this.value + ", period='" + this.period + '\'' + '}';
    }

    @Override
    public int compareTo(RelativeDate other) {
        GregorianCalendar thisCalendar = this.getAbsoluteDate(false);
        GregorianCalendar otherCalendar = other.getAbsoluteDate(false);
        return thisCalendar.compareTo(otherCalendar);
    }
}

