/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.util;

import com.isomorphic.util.IOUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.io.output.ProxyWriter;

public class AtomicFileWriter
extends ProxyWriter {
    protected String fileName;
    protected String tmpFileName;
    private boolean _isClosed = false;

    public AtomicFileWriter(File file) throws IOException {
        super((Writer)new FileWriter(IOUtil.threadSafeTmpFile(file)));
        this.fileName = file.getCanonicalPath();
        this.tmpFileName = IOUtil._threadSafeTmpFileName(this.fileName);
    }

    public AtomicFileWriter(String fileName) throws IOException {
        super((Writer)new FileWriter(IOUtil.threadSafeTmpFileName(fileName)));
        this.fileName = fileName;
        this.tmpFileName = IOUtil._threadSafeTmpFileName(this.fileName);
    }

    public void close() throws IOException {
        if (!this._isClosed) {
            super.close();
            IOUtil.atomicMove(this.tmpFileName, this.fileName);
        }
        this._isClosed = true;
    }
}

