/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.taglib;

import com.isomorphic.auth.DevModeAuthFilter;
import com.isomorphic.io.ISCFile;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.taglib.BaseTag;
import com.isomorphic.taglib.LoadISCTag;
import com.isomorphic.util.DataTools;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class LoadTag
extends BaseTag {
    public String suffix = null;
    public String defer = null;
    public String cacheOnly = null;
    public String onload = null;
    private String version;
    private String versionSource;
    public String isomorphicDir = null;
    public String modulesDir = "system/modules/";
    public String debugModulesDir = "system/modules-debug/";
    public Boolean useDebugModules = null;
    public String versionStyle = null;
    public String isomorphicDevURI = null;
    public String isomorphicURI = null;
    private static final Pattern UNESCAPED_SINGLE_QUOTE_PATTERN = Pattern.compile("(?<!\\\\)'");
    public String relativePathToWebRoot = null;
    public String absolutePathToWebRoot = null;

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setDefer(String defer) {
        this.defer = defer;
    }

    public String getDefer() {
        return this.defer;
    }

    public void setCacheOnly(String cacheOnly) {
        this.cacheOnly = cacheOnly;
    }

    public String getCacheOnly() {
        return this.cacheOnly;
    }

    public void setOnload(String onload) {
        this.onload = onload;
    }

    public String getOnload() {
        return this.onload;
    }

    public synchronized void setVersion(String version) {
        this.version = version;
        this.versionSource = "api";
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionSource() {
        return this.versionSource;
    }

    public synchronized String getVersionFromSource(String source) {
        return this.versionSource != null && this.versionSource.equals(source) ? this.version : null;
    }

    public void setIsomorphicDir(String isomorphicDir) {
        this.isomorphicDir = isomorphicDir;
    }

    public String getIsomorphicDir() {
        return this.isomorphicDir;
    }

    public void setModulesDir(String modulesDir) {
        if (!modulesDir.endsWith("/")) {
            modulesDir = modulesDir + "/";
        }
        this.modulesDir = modulesDir;
    }

    public final String getModulesDir() {
        return this.modulesDir;
    }

    public void setDebugModulesDir(String debugModulesDir) {
        if (!debugModulesDir.endsWith("/")) {
            debugModulesDir = debugModulesDir + "/";
        }
        this.debugModulesDir = debugModulesDir;
    }

    public final String getDebugModulesDir() {
        return this.debugModulesDir;
    }

    public void setUseDebugModules(String useDebugModules) {
        this.useDebugModules = Boolean.valueOf(useDebugModules);
    }

    public String getUseDebugModules() {
        return "" + this.useDebugModules;
    }

    public void setVersionStyle(String versionStyle) {
        this.versionStyle = versionStyle;
    }

    public void setIsomorphicDevURI(String isomorphicDevURI) {
        if (!isomorphicDevURI.endsWith("/")) {
            isomorphicDevURI = isomorphicDevURI + "/";
        }
        this.isomorphicDevURI = isomorphicDevURI;
    }

    public String getIsomorphicDevURI() {
        String uri = this.pageContext.getRequest().getParameter("isomorphicDevURI");
        if (uri != null && DevModeAuthFilter.devModeAuthorized((HttpServletRequest)this.pageContext.getRequest())) {
            return uri;
        }
        return this.isomorphicDevURI;
    }

    public void setIsomorphicURI(String isomorphicURI) {
        if (!isomorphicURI.endsWith("/")) {
            isomorphicURI = isomorphicURI + "/";
        }
        this.isomorphicURI = isomorphicURI;
    }

    protected String safeURI(String URI2) {
        Matcher matcher = UNESCAPED_SINGLE_QUOTE_PATTERN.matcher(URI2);
        return matcher.replaceAll("\\'");
    }

    public String getVersionStyle() {
        if (!config.getBoolean((Object)"isc.addVersionToLoadTags", false)) {
            return "none";
        }
        if (this.versionStyle != null) {
            return this.versionStyle;
        }
        String vs = config.getString("isc.defaultVersionStyle");
        if (vs != null) {
            return vs;
        }
        return "params";
    }

    public String getUnversionedIsomorphicURI() {
        return this.getIsomorphicURI(false);
    }

    public String getIsomorphicURI() {
        return this.getIsomorphicURI(this.getVersionStyle().equals("pathSegment"));
    }

    public String getIsomorphicURI(boolean versioned) {
        if (this.isomorphicURI == null) {
            this.isomorphicURI = (String)this.pageContext.getRequest().getAttribute("isomorphicURI");
        }
        if (this.isomorphicURI == null) {
            this.isomorphicURI = config.getPath("isomorphicURI");
            if ("__AUTODETECT__".equals(this.isomorphicURI) || "__auto__".equals(this.isomorphicURI)) {
                String relativePathToWebRoot = this.getRelativePathToWebRoot();
                this.isomorphicURI = relativePathToWebRoot + config.getPath("isomorphicURIRootRelative");
                this.isomorphicURI = ISCFile.canonicalizePath(this.isomorphicURI);
                if (!this.isomorphicURI.endsWith("/")) {
                    this.isomorphicURI = this.isomorphicURI + "/";
                }
            }
            this.log.debug("isomorphicURI not specified in tag, defaulting to: " + this.isomorphicURI);
            if (!this.isomorphicURI.endsWith("/")) {
                this.isomorphicURI = this.isomorphicURI + "/";
            }
            this.isomorphicURI = this.safeURI(this.isomorphicURI);
            this.pageContext.getRequest().setAttribute("isomorphicURI", (Object)this.isomorphicURI);
        }
        String finalIsomorphicURI = this.isomorphicURI;
        if (versioned) {
            finalIsomorphicURI = finalIsomorphicURI + config.getString("isc.versionPathSegmentPrefix") + "." + this.getIsomorphicVersion() + "/";
        }
        finalIsomorphicURI = this.safeURI(finalIsomorphicURI);
        return finalIsomorphicURI;
    }

    public String getRelativePathToWebRoot() {
        if (this.relativePathToWebRoot != null) {
            return this.relativePathToWebRoot;
        }
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        String uri = ServletTools.getInitialRequestURI(request);
        List<String> pathComponents = DataTools.simpleSplit(uri, "/");
        int count = pathComponents.size() - 1;
        if (uri.endsWith("/")) {
            ++count;
        }
        String relativeComponent = "";
        for (int i = count; i > 0; --i) {
            relativeComponent = relativeComponent + "../";
        }
        return relativeComponent;
    }

    public void setRelativePathToWebRoot(String relativePathToWebRoot) {
        this.relativePathToWebRoot = relativePathToWebRoot;
    }

    public String getAbsolutePathToWebRoot() {
        return this.absolutePathToWebRoot;
    }

    public void setAbsolutePathToWebRoot(String absolutePathToWebRoot) {
        this.absolutePathToWebRoot = absolutePathToWebRoot;
    }

    public String browserPathToFile(String fileName) {
        String absoluePathToWebRoot = this.getAbsolutePathToWebRoot();
        if (this.absolutePathToWebRoot != null) {
            String filePath = ISCFile.canonicalizePath(this.absolutePathToWebRoot + "/" + fileName);
            return filePath;
        }
        String relativePathToWebRoot = this.getRelativePathToWebRoot();
        String filePath = ISCFile.canonicalizePath(relativePathToWebRoot + fileName);
        if (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        return filePath;
    }

    public String versionedBrowserPathToFile(String fileName, String fileExtension) {
        return this.addVersion(this.browserPathToFile(fileName), fileExtension);
    }

    public String versionedBrowserPathToFile(String fileName) {
        return this.addVersion(this.browserPathToFile(fileName));
    }

    @Override
    public void init() {
        super.init();
        boolean defer = "true".equals(this.getDefer());
        boolean cacheOnly = "true".equals(this.getCacheOnly());
        this.getIsomorphicURI();
        ServletRequest req = this.pageContext.getRequest();
        try {
            if (req.getAttribute("_isc_isomorphicDir") == null) {
                String iscDir = this.isomorphicDir;
                if (iscDir == null) {
                    iscDir = this.isomorphicURI;
                }
                this.pageContext.getOut().write("<SCRIPT>window.isomorphicDir=\"" + iscDir + "\";</SCRIPT>\n");
                String versionFromURL = this.getVersionFromSource("url");
                if (versionFromURL != null) {
                    this.pageContext.getOut().write("<SCRIPT>window.isc_versionNumber=\"" + versionFromURL + "\";</SCRIPT>\n");
                }
                req.setAttribute("_isc_isomorphicDir", (Object)Boolean.TRUE);
            }
            if (defer || cacheOnly) {
                List loadedModules = (List)req.getAttribute("_isc_loadedModules");
                if (!(req.getAttribute("_isc_fileLoader") != null || loadedModules != null && loadedModules.contains("FileLoader"))) {
                    this.pageContext.getOut().write("<SCRIPT SRC=" + this.addVersion(this.isomorphicURI + this.getModulesDir() + "ISC_FileLoader.js") + "></SCRIPT>");
                    if (config.getBoolean((Object)"FileLoader.disableCaching", false) && req.getAttribute("enableFileLoaderCaching") == null) {
                        this.pageContext.getOut().write("<SCRIPT>isc.FileLoader.disableCaching=true;</SCRIPT>\n");
                    }
                    req.setAttribute("_isc_fileLoader", (Object)Boolean.TRUE);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)"caught exception sending fileLoader", e);
        }
    }

    protected synchronized String getIsomorphicVersion() {
        String remoteVersion = LoadISCTag.getRemoteSyncVersion();
        if (remoteVersion != null) {
            this.version = remoteVersion;
            this.versionSource = "url";
        }
        if (this.version == null) {
            this.version = config.getString("iscVersionNumber");
            this.versionSource = "config";
        }
        return this.version;
    }

    protected String addVersion(String url) {
        return this.addVersion(url, "js");
    }

    protected String addVersion(String url, String fileExtension) {
        String devMode;
        boolean addVersionParam = true;
        if (!config.getBoolean((Object)"isc.addVersionToLoadTags", false) || "none".equals(this.versionStyle) || "pathSegment".equals(this.versionStyle) || !"params".equals(config.getString("isc.defaultVersionStyle"))) {
            addVersionParam = false;
        }
        if (addVersionParam) {
            String version = this.getIsomorphicVersion();
            String versionParamName = config.getString("isc.versionParamName");
            if (url.indexOf(versionParamName + "=") == -1) {
                url = ServletTools.addQueryParameter(url, versionParamName, version + "." + fileExtension);
            }
        }
        if (!(devMode = config.getString("devMode", "dev")).equals("dev")) {
            url = ServletTools.addQueryParameter(url, "devMode", devMode + "." + fileExtension);
        }
        return url;
    }
}

