/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.sql;

import com.isomorphic.base.Base;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSTransaction;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.rpc.BaseRequest;
import com.isomorphic.rpc.RPCManager;
import com.isomorphic.sql.SQLConnectionManager;
import com.isomorphic.sql.SQLDataSource;
import java.sql.Connection;
import java.sql.SQLException;

public class SQLTransaction
extends Base {
    public static final String CONNECTION_ATTR = "_isc_sql_connection_";
    public static final String DBNAME_ATTR = "_isc_default_dbName";
    private static Logger log = new Logger(SQLTransaction.class.getName());
    private static boolean autoEndTransactions = false;

    public static void setAutoEndTransactions(boolean autoEnd) {
        autoEndTransactions = autoEnd;
    }

    public static boolean startTransaction(RPCManager rpcManager) throws Exception {
        return SQLTransaction.startTransaction(rpcManager.getDsTransaction());
    }

    public static boolean startTransaction(DSTransaction dsTransaction) throws Exception {
        String dbName = null;
        for (BaseRequest baseRequest : dsTransaction.getRequests()) {
            DSRequest dsReq;
            DataSource ds;
            if (!(baseRequest instanceof DSRequest) || !((ds = (dsReq = (DSRequest)baseRequest).getDataSource()) instanceof SQLDataSource)) continue;
            dbName = ((SQLDataSource)ds).getDriver().dbName;
            break;
        }
        if (dbName == null) {
            dbName = config.getString((Object)"sql.defaultDatabase");
        }
        dsTransaction.setAttribute(DBNAME_ATTR, (Object)dbName);
        return SQLTransaction.startTransaction(dsTransaction, dbName);
    }

    public static boolean startTransaction(RPCManager rpcManager, String dbName) throws SQLException {
        return SQLTransaction.startTransaction(rpcManager.getDsTransaction(), dbName);
    }

    public static boolean startTransaction(DSTransaction dsTransaction, String dbName) throws SQLException {
        Connection connection = (Connection)dsTransaction.getAttribute(CONNECTION_ATTR + dbName);
        if (connection == null) {
            connection = SQLConnectionManager.getConnection(dbName);
            connection.setAutoCommit(false);
            dsTransaction.setAttribute(DBNAME_ATTR, (Object)dbName);
            dsTransaction.setAttribute(CONNECTION_ATTR + dbName, (Object)connection);
            log.debug((Object)("Started new " + dbName + " transaction \"" + connection.hashCode() + "\""));
            return true;
        }
        log.debug((Object)("startTransaction called but transaction \"" + connection.hashCode() + "\" was already active - ignoring the startTransaction request"));
        return true;
    }

    public static Connection getConnection(RPCManager rpcManager) throws Exception {
        return SQLTransaction.getConnection(rpcManager.getDsTransaction());
    }

    public static Connection getConnection(DSTransaction dsTransaction) throws Exception {
        for (BaseRequest baseRequest : dsTransaction.getRequests()) {
            DSRequest dsReq;
            DataSource ds;
            if (!(baseRequest instanceof DSRequest) || !((ds = (dsReq = (DSRequest)baseRequest).getDataSource()) instanceof SQLDataSource)) continue;
            String dbName = ((SQLDataSource)ds).getDriver().dbName;
            if (dbName == null) {
                dbName = config.getString((Object)"sql.defaultDatabase");
            }
            dsTransaction.setAttribute(DBNAME_ATTR, (Object)dbName);
            return SQLTransaction.getConnection(dsTransaction, dbName);
        }
        throw new Exception("Could not find a DSRequest for a SQLDataSource in getConnection");
    }

    public static Connection getConnection(RPCManager rpcManager, String dbName) throws Exception {
        return SQLTransaction.getConnection(rpcManager.getDsTransaction(), dbName);
    }

    public static Connection getConnection(DSTransaction dsTransaction, String dbName) throws Exception {
        Connection connection = (Connection)dsTransaction.getAttribute(CONNECTION_ATTR + dbName);
        log.debug((Object)("getConnection() looked for transactional connection for " + dbName + ": " + (connection == null ? " (connection is null)" : " hashcode \"" + connection.hashCode() + "\"")));
        return connection;
    }

    public static void rollbackTransaction(RPCManager rpcManager) throws Exception {
        SQLTransaction.rollbackTransaction(rpcManager.getDsTransaction());
    }

    public static void rollbackTransaction(DSTransaction dsTransaction) throws Exception {
        String dbName = (String)dsTransaction.getAttribute(DBNAME_ATTR);
        SQLTransaction.rollbackTransaction(dsTransaction, dbName);
    }

    public static void rollbackTransaction(RPCManager rpcManager, String dbName) throws Exception {
        SQLTransaction.rollbackTransaction(rpcManager.getDsTransaction(), dbName);
    }

    public static void rollbackTransaction(DSTransaction dsTransaction, String dbName) throws Exception {
        Connection connection = (Connection)dsTransaction.getAttribute(CONNECTION_ATTR + dbName);
        if (connection == null) {
            throw new Exception("No current connection for '" + dbName + "'");
        }
        if (!dsTransaction.isCompleted(dbName)) {
            log.debug((Object)("Rolling back " + dbName + " transaction \"" + connection.hashCode() + "\""));
            connection.rollback();
            dsTransaction.addToCompletedList(dbName);
        }
        if (autoEndTransactions) {
            SQLTransaction.endTransaction(dsTransaction, dbName);
        }
    }

    public static void commitTransaction(RPCManager rpcManager) throws Exception {
        SQLTransaction.commitTransaction(rpcManager.getDsTransaction());
    }

    public static void commitTransaction(DSTransaction dsTransaction) throws Exception {
        String dbName = (String)dsTransaction.getAttribute(DBNAME_ATTR);
        SQLTransaction.commitTransaction(dsTransaction, dbName);
    }

    public static void commitTransaction(RPCManager rpcManager, String dbName) throws Exception {
        SQLTransaction.commitTransaction(rpcManager.getDsTransaction(), dbName);
    }

    public static void commitTransaction(DSTransaction dsTransaction, String dbName) throws Exception {
        Connection connection = (Connection)dsTransaction.getAttribute(CONNECTION_ATTR + dbName);
        if (connection == null) {
            throw new Exception("No current connection for '" + dbName + "'");
        }
        if (!dsTransaction.isCompleted(dbName) && !dsTransaction.isCommitted(dbName)) {
            log.debug((Object)("Committing " + dbName + " transaction \"" + connection.hashCode() + "\""));
            connection.commit();
            if (dsTransaction.isCompleting() && !dsTransaction.isCompleted(dbName)) {
                dsTransaction.addToCompletedList(dbName);
            } else if (!dsTransaction.isCommitted(dbName)) {
                dsTransaction.setCommitted(dbName);
            }
        }
        if (autoEndTransactions) {
            SQLTransaction.endTransaction(dsTransaction, dbName);
        }
    }

    public static boolean isConnectionAvailable(RPCManager rpcManager, String dbName) {
        return SQLTransaction.isConnectionAvailable(rpcManager.getDsTransaction(), dbName);
    }

    public static boolean isConnectionAvailable(DSTransaction dsTransaction, String dbName) {
        return dsTransaction.getAttribute(CONNECTION_ATTR + dbName) != null;
    }

    public static void endTransaction(RPCManager rpcManager) throws Exception {
        SQLTransaction.endTransaction(rpcManager.getDsTransaction());
    }

    public static void endTransaction(DSTransaction dsTransaction) throws Exception {
        String dbName = (String)dsTransaction.getAttribute(DBNAME_ATTR);
        SQLTransaction.endTransaction(dsTransaction, dbName);
    }

    public static void endTransaction(RPCManager rpcManager, String dbName) throws Exception {
        SQLTransaction.endTransaction(rpcManager.getDsTransaction(), dbName);
    }

    public static void endTransaction(DSTransaction dsTransaction, String dbName) throws Exception {
        Connection connection = (Connection)dsTransaction.getAttribute(CONNECTION_ATTR + dbName);
        if (connection == null) {
            throw new Exception("No current connection for '" + dbName + "'");
        }
        log.debug((Object)("Ending " + dbName + " transaction \"" + connection.hashCode() + "\""));
        SQLConnectionManager.free(connection);
        dsTransaction.removeAttribute(DBNAME_ATTR);
        dsTransaction.removeAttribute(CONNECTION_ATTR + dbName);
    }
}

