/*

  SmartClient Ajax RIA system
  Version v13.0p_2026-02-15/EVAL Development Only (2026-02-15)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/

if(window.isc&&window.isc.module_Core&&!window.isc.module_Forms){isc.module_Forms=1;isc._moduleStart=isc._Forms_start=(isc.timestamp?isc.timestamp():new Date().getTime());if(isc._moduleEnd&&(!isc.Log||(isc.Log && isc.Log.logIsDebugEnabled('loadTime')))){isc._pTM={ message:'Forms load/parse time: ' + (isc._moduleStart-isc._moduleEnd) + 'ms', category:'loadTime'};
if(isc.Log && isc.Log.logDebug)isc.Log.logDebug(isc._pTM.message,'loadTime');
else if(isc._preLog)isc._preLog[isc._preLog.length]=isc._pTM;
else isc._preLog=[isc._pTM]}isc.definingFramework=true;


if (window.isc && isc.version != "v13.0p_2026-02-15/EVAL Development Only" && !isc.DevUtil) {
    isc.logWarn("SmartClient module version mismatch detected: This application is loading the core module from "
        + "SmartClient version '" + isc.version + "' and additional modules from 'v13.0p_2026-02-15/EVAL Development Only'. Mixing resources from different "
        + "SmartClient packages is not supported and may lead to unpredictable behavior. If you are deploying resources "
        + "from a single package you may need to clear your browser cache, or restart your browser."
        + (isc.Browser.isSGWT ? " SmartGWT developers may also need to clear the gwt-unitCache and run a GWT Compile." : ""));
}







isc.Canvas.addClassMethods({

//>    @method    Canvas.applyTableResizePolicy()    (A)
// Given a set of items to be shown in a table, this method determines the sizing / positioning
// to be applied to each item.
//
// We factor the placing of titles next to elements into the table here to have them
// automatically take up columns in the output.
//
// Sets up _rowHeights and _colWidths on the items array
// Sets up _size property (2 element array for width,height) and _titleWidth on each item.
//
// @group drawing
//<
// Note:
// The "_rowTable" property stored on the passed-in items can be reused IF no new items are
// visible that were not visible before.  It is up to the calling function to clear out an old
// _rowHeights if necessary.
//
//

applyTableResizePolicy : function (items, totalWidth, totalHeight,
                                   numCols, colWidths, rowHeights, overflowedAsFixed) {
    var logDebug = this.logIsDebugEnabled("tablePolicy"),
        logInfo = this.logIsInfoEnabled("tablePolicy"),
        logPlacement = this.logIsDebugEnabled("tablePlacement");

    // determine row and column start and end coordinates for each item based on rowSpan,
    // colSpan, startRow and endrow properties

    var rowTable = items._rowTable;

    // If we've previously run the resizePolicy and it is still valid, don't do the
    // work again.
    if (!this._tableResizePolicyIsValid(items)) {

        // determine row and column start and end coordinates for each item based on rowSpan,
        // colSpan, startRow and endRow properties
        rowTable = items._rowTable = [];

        var currentRow = 0,
            currentCol = 0
        ;

        // iterate through the items,
        //    placing them in a rowTable according to their rowSpan and colSpan entries
        for (var itemNum = 0; itemNum < items.length; itemNum++) {
            // get a pointer to the item
            var item = items[itemNum];

            // if the item is not visible, skip it
            // NOTE: an algorithm BEFORE this one might want to mark items as invisible
            //            based on a showIf property or something like that
            if (!item.alwaysTakeSpace && !item.visible) continue;

            var itemCols = item.getColSpan(),
                itemRows = item.getRowSpan();

            // if the item has rowSpan == 0 or colSpan == 0, skip it
            //  this lets us ignore items that should be output (and thus are visible)
            //    but don't factor into the table
            if (itemRows == 0 || itemCols == 0) continue;

            if (itemCols == null) itemCols = 1;
            if (itemRows == null) itemRows = 1;

            // make sure the two values are not numeric strings
            if (!isNaN(itemCols)) itemCols = parseInt(itemCols);
            if (!isNaN(itemRows)) itemRows = parseInt(itemRows);

            var requiredCols = itemCols;
            if (itemCols == "*") requiredCols = 1;

            // add another column for a separate cell for left/right oriented titles
            // NOTE: extra cells not added for top or bottom-oriented titles
            var orientation = item.getTitleOrientation();
            if (item.showTitle &&
                (orientation == isc.Canvas.LEFT || orientation == isc.Canvas.RIGHT))
            {
                // NOTE: we assume colSpan * and showTitle:true means at least two columns
                requiredCols += (item.getTitleColSpan() || 1);
                if (itemCols != "*") itemCols += (item.getTitleColSpan() || 1);
            }

            var startRow = (item.isStartRow ? item.isStartRow() : item.startRow),
                endRow = (item.isEndRow ? item.isEndRow() : item.endRow);

            if (logPlacement) {
                this.logDebug("at: " + ["row" + currentRow, "col" + currentCol] +
                              ", item: " + (item.name || item.Class) +
                              // report colSpan "*" separately since the actual number of
                              // columns we'll take up isn't computed til later, requiredCols
                              // just represents the number of columns the item *must* have
                              (itemCols == "*" ? ", colSpan:'*'" : "") +
                              ", required cols:" + requiredCols +
                              (itemRows > 1 ? ", rowSpan:" + itemRows : "") +
                              (startRow ? ", startRow:true" : "") +
                              (endRow ? ", endRow:true" : ""),
                              "tablePlacement");
            }

            var placeRow = null, placeCol = null;



            if (currentCol >= numCols || (startRow && currentCol != 0)) {
                currentRow++;
                currentCol = 0;
                item._startRow = true;
                //this.logWarn("advanced to row: " + currentRow);
            } else { item._startRow = false; }

            // if we're within the table, see if we can place the item in an existing row
            // NOTE: rowSpanning items in this and previous rows means there may be several
            // partially filled rows to look through for sufficient open space for this item.
            if (currentRow < rowTable.length) {
                //this.logWarn("looking in existing rows starting at: " + currentRow);
                // find the next row with available space
                for (; currentRow < rowTable.length; currentRow++) {
                    var rowSlots = rowTable[currentRow];

                    //this.logWarn("trying row: " + currentRow);

                    // no row created yet
                    if (rowSlots == null) break;

                    // look for an open slot
                    for (; currentCol < numCols; currentCol++) {
                        if (rowSlots[currentCol] != null) continue;

                        // check that there are enough open slots in a row to accommodate the
                        // colSpan of this item.  This covers the case of cells reserved by
                        // rowSpanning items in previous rows.
                        for (var j = currentCol; j < numCols; j++) {
                            //this.logWarn("checking at open spot in column: " + currentCol);
                            // ran into an occupied slot before we found a spot
                            if (rowSlots[j] != null) break;

                            if ((j - currentCol) + 1 >= requiredCols) {
                                // there's enough room to accommodate this item starting at
                                // column i on this row.
                                // Note that we don't have to check for cells reserved in rows
                                // beneath us.  Only items from rows above us could possibly
                                // have reserved cells beneath us, and they'd have to reserve
                                // the intervening cells.
                                placeRow = currentRow;
                                placeCol = currentCol;
                                break;
                            }
                        }
                        if (placeCol != null) break;
                    }
                    if (placeCol != null) break;
                    // moving on to new row, go back to first column
                    //this.logWarn("no spot in row: " + currentRow + ", advancing");
                    currentCol = 0;
                    item._startRow = true;
                }
                //if (placeCol != null) this.logWarn("found spot in row: " + currentRow);
            }
            // no spots in existing rows, create a new row
            if (placeCol == null) {
                //this.logWarn("created new row: " + currentRow);
                placeRow = currentRow;
                placeCol = 0;
                item._startRow = true;
                // NOTE: an item with an invalid colSpan which is > numCols will never be
                // placed on an existing row, hence hits this case and ends up at column 0 of a
                // new row.
            }

            currentCol = placeCol;

            // if colSpan is variable, now that we've picked a row we can resolve it
            if (itemCols == "*") itemCols = numCols - currentCol;

            // NOTE: rowSpan of "*" not supported!
            // this is because we don't know how many rows there will be, so we don't
            //    have a good way to assign the item to each row going down (?)
            if (!isc.isA.Number(itemRows)) itemRows = 1;

            // note the shape of this item in the rowTable (fill in the grid)
            // for each row to output

            for (var r = currentRow; r < currentRow + itemRows; r++) {
                // if there's not a column array in that row, create one
                if (!rowTable[r]) rowTable[r] = [];
                // for each column to output
                for (var c = currentCol; c < currentCol + itemCols; c++) {
                    // stick the number of this item in the row
                    rowTable[r][c] = itemNum;
                }
            }

            // have the item remember how many rows and columns it's actually taking up
            // as an array of numbers:   [startCol, startRow, endCol, endRow]
            //    NOTE: endCol and endRow are NOT inclusive
            item._tablePlacement = [placeCol, placeRow,
                                    placeCol + itemCols, placeRow + itemRows];



            // advance currentCol by the number of columns taken up
            currentCol += itemCols;
            // if the item is configured to end its row, advance past the last column in the
            // row, so the next iteration of the loop will start the new row
            if (endRow) currentCol = numCols;

            if (logPlacement) {
                this.logDebug("item: " + (item.name || item.Class) +
                              " placed at: " + ["row" + placeRow, "col" + placeCol] +
                              (item._startRow ? ", marked startRow " : "") +
                              ", rowTable: " + this.echoAll(rowTable), "tablePlacement");
            }
        }

        // at this point, we know the row and column coordinate where each item will be placed


        var emptyRows = [];
        for (var r = 0; r < rowTable.length; r++) {
            var row = rowTable[r];
            if (row == null) break;

            var emptyCells = 0, lastItem = null;
            for (var c = 0; c < row.length; c++) {
                // empty cell
                if (row[c] == null) {
                    emptyCells++;
                    continue;
                }
                // cell spanned by item in previous row
                if (r > 0 && rowTable[r-1] != null && row[c] == rowTable[r-1][c]) continue;

                // occupied cell
                var itemNum = row[c],
                    item = items[itemNum];

                // if we're still in the same colSpanning item, continue
                if (item == lastItem || item == null) continue;

                // mark this item with the number of empty cells and rows that precede it
                item._emptyRows = emptyRows;
                item._emptyCells = emptyCells;
                if (logPlacement && (emptyCells > 0 || emptyRows.length > 0)) {
                    this.logDebug("itemNum:" + itemNum + " (" + (item.name || item.Class) +
                                  ") at: " + ["row" + placeRow, "col" + placeCol] +
                                  " preceded by " +
                                  (emptyCells > 0 ? emptyCells + " empty cells" : "") +
                                  (emptyRows.length > 0 ?
                                     " " + emptyRows.length + " empty rows" : ""),
                                  "tablePlacement");
                }
                // reset the counter
                emptyCells = 0;
                emptyRows = [];
                lastItem = item;
            }
            // if we didn't encounter any items on this row, we need to skip a row
            // Record how many empty cells are in this row
            if (lastItem == null) {
                emptyRows.add(emptyCells + (numCols-row.length));
                emptyCells = 0;
            }
        }
        // if we have empty rows beyond the last item(s) in the table, reduce the
        // rowSpan specification of those items.

        if (emptyRows != null && rowTable.length > 0) {
            var emptyRowCount = emptyRows.length;
            var row = rowTable[rowTable.length-1];
            for (var c = 0; c < row.length; c++) {
                var itemNum = row[c];
                    item = items[itemNum];
                if (item == null) continue;

                var rowSpan = item._tablePlacement[3] - item._tablePlacement[1];
                rowSpan -= emptyRowCount;
                item._rowSpan = rowSpan;
            }

        }
    }

    // if column widths were not specified, calculate them from the rowTable
    if (!colWidths || !isc.isAn.Array(colWidths)) {    // && !items.colWidths) {
        //>DEBUG
        if (!isc.isAn.Array(colWidths)) {
            this.logWarn(" 'colWidths' not an array - Ignoring.", "tableResizePolicy");
        }
        //<DEBUG


        colWidths = [];
    }

    // transform any "*" or "%" items in the colWidths to things the stretchResizeList can deal
    // with.  NOTE: don't modify the passed-in Array
    colWidths = colWidths.duplicate();
    for (var c = 0; c < colWidths.length; c++) {
        //    colWidths[c] = [colMinWidth, rowMaxWidth, colMaxPercent, colStarCount];

        var width = colWidths[c];
        if (isc.isA.String(width)) {
            if (width == "*") colWidths[c] = [0, 10000, 0, 1];
            else if (width.contains("*")) colWidths[c] = [0, 10000, 0, parseInt(width)];
            else if (width.contains("%")) colWidths[c] = [0, 10000, parseInt(width), 0];
            // catch a quoted number and convert it to a real number
            else {
                var parsed = parseInt(width);
                if (parsed == width) {
                    colWidths[c] = parsed;
                } else {
                    this.logWarn("Failed to understand specified colWidth:"+ width);
                    // treat as "*"
                    colWidths[c] = [0,10000,0,1];
                }
            }
        }
    }

    // remember the colWidths in the items
    items.colWidths = colWidths;
    // get real col sizes

    items._colWidths = colWidths = isc.Canvas.stretchResizeList(items.colWidths, totalWidth);


    var cellPaddingHeight;

    // look through all the items in each row and gather:
    // [ min pixel height,
    //   max pixel height,
    //   largest "*" size,
    //   largest percent size ]
    if (!rowHeights) {// && !items.rowHeights) {
        rowHeights = [];

        // for each row in the rowTable
        for (var r = 0; r < rowTable.length; r++) {
            var row = rowTable[r],
                rowMinHeight = null,
                rowMaxHeight = 100000,
                rowMaxPercent = 0,
                rowStarCount = 0
            ;
            if (!row) continue;

            // for each column in that row
            for (var c = 0; c < row.length; c++) {
                // get the item and its preferred height
                var item = items[row[c]];
                if (!item) continue;
                var itemHeight = item.getCellHeight(overflowedAsFixed);

                // if the item takes up more than one row, split evenly amongst its rows ???
                var itemRows = (item._tablePlacement[3] - item._tablePlacement[1]);

                if (logDebug) this.logWarn("item at: " + [r,c] + " has height: " + itemHeight +
                                           ", item is: " + item, "tablePlacement");

                item._isVariableHeight = false;

                // if the itemHeight is a number
                if (isc.isA.Number(itemHeight)) {
                    // NOTE: if the item takes up more than one row, split it evenly across its
                    // rows
                    itemHeight = Math.floor(itemHeight / itemRows);

                    if (logDebug) this.logWarn("item: " + item + " has pixel size: " + itemHeight,
                                               "tablePlacement");

                    // if this is the first item to specify a pixel size, or is larger than any
                    // previous specified size or minimum size, it becomes the new minimum
                    if (rowMinHeight == null || itemHeight > rowMinHeight) {
                        rowMinHeight = itemHeight;
                    }

                    // if this item specifies a pixel size larger than a previously specified
                    // max, raise the max height for the row as a whole
                    if (itemHeight > rowMaxHeight) rowMaxHeight = itemHeight;

                // if the itemHeight is a string (a relative size)
                } else if (isc.isA.String(itemHeight)) {
                    // if height is "*" or "2*"
                    if (itemHeight.contains("*")) {
                        item._isVariableHeight = true;

                        // get the starCount as a number
                        // NOTE: if the item takes up more than one row, split it evenly across
                        // its rows
                        var itemStarCount = (itemHeight == "*" ? 1 : parseFloat(itemHeight))
                                                    / itemRows;

                        if (logDebug) this.logWarn("item: " + item + " has star size: " +
                                            itemStarCount, "tablePlacement");

                        rowStarCount = Math.max(rowStarCount, itemStarCount);

                    // else if height is a percentage
                    } else {
                        item._isVariableHeight = true;

                        // get the percentage as a number
                        // NOTE: if the item takes up more than one row, split it evenly across
                        // its rows
                        var itemPercent = parseFloat(itemHeight) / itemRows;

                        if (logDebug) this.logWarn("item: " + item + " has percent size: " +
                                            itemPercent, "tablePlacement");

                        // and remember it if it's greater than the max percent already seen in
                        // this row
                        if (itemPercent > rowMaxPercent) rowMaxPercent = itemPercent;
                    }

                    // set the cellPaddingHeight lazily; we have a top and bottom cellpadding
                    if (cellPaddingHeight == null) cellPaddingHeight = 2*item.form.cellPadding;

                    // check for minHeight settings on flexible-sized items
                    var itemMinHeight = item.getMinHeight();
                    if (itemMinHeight != null) {
                        itemMinHeight += cellPaddingHeight;

                        // the row must be tall enough to hold an item with minHeight
                        if (itemMinHeight > rowMinHeight) {
                            rowMinHeight = itemMinHeight;
                        }

                        // NOTE: minimums should win out over maximums

                        // allow an item's minHeight to win out over another item's previously
                        // specified maxHeight
                        if (itemMinHeight > rowMaxHeight) {
                            rowMaxHeight = itemMinHeight;
                        }
                    }

                    // check for maxHeight settings on flexible-sized items
                    var itemMaxHeight = item.getMaxHeight();
                    if (itemMaxHeight != null) {
                        itemMaxHeight += cellPaddingHeight;

                        // lower rowMaxHeight only to largest previously specified rowMinHeight
                        if (itemMaxHeight < rowMaxHeight &&
                            rowMinHeight < itemMaxHeight)
                        {
                            rowMaxHeight = itemMaxHeight
                        }
                    }
                }

                // remember the characteristics of this row
                // if a percentage or star was found, remember all the values
                if (rowMaxPercent > 0 || rowStarCount > 0) {
                    // no one set a pixel size or minHeight.  Default to 0
                    if (rowMinHeight == null) rowMinHeight = 0;
                    rowHeights[r] = [rowMinHeight, rowMaxHeight, rowMaxPercent, rowStarCount];
                } else {
                    if (rowMinHeight == null) {
                        // there were no specified sizes for the row (pixel, '*' or percent)
                        rowMinHeight = items._defaultRowHeight || 22;
                    }
                    rowHeights[r] = rowMinHeight;
                }
            }
        }
    }
    // remember the rowHeights in the items
    items.rowHeights = rowHeights;
    // get real row sizes
    items._rowHeights = rowHeights = isc.Canvas.stretchResizeList(items.rowHeights, totalHeight);



    if (logInfo) this.logInfo("\ntotalWidth: " + totalWidth +
                              ", totalHeight: " + totalHeight +
                              "\nspecified sizes:\n" +
                              "cols:" + this.echoAll(items.colWidths) +
                              ", rows: " + this.echoAll(items.rowHeights),
                              "tablePolicy");


    if (logInfo) this.logInfo("\nderived sizes:\n" +
                              "cols:" + this.echoAll(items._colWidths) +
                              ", rows: " + this.echoAll(items._rowHeights),
                              "tablePolicy");

    // we have widths and heights for each column and row.  Now apply those sizes to the items,
    // which may span multiple columns or rows
    // NOTE: we currently only support "*" sizes, not percents
    for (itemNum = 0; itemNum < items.length; itemNum++) {
        item = items[itemNum];
        if (!item.visible) continue;
        var isACanvas = isc.isA.Canvas(item),
            isACanvasItem = !isACanvas && isc.isA.CanvasItem(item),
            width = isACanvasItem ? (item.canvas && item.canvas._userWidth) || item.width : item.getWidth(),
            height = isACanvas ? item.getHeight() : item.getCellHeight(overflowedAsFixed),
            orientation = item.getTitleOrientation(),
            placement = item._tablePlacement,
            // We need the derived title width in order to manage title cell clipping properly
            // in form items. If we're not showing a title, of course this will be zero.
            titleWidth = 0;

        if (placement == null) continue;

        // override item width in linearMode; use linearWidth if set
        if (item.form.linearMode) {
            width = item.linearWidth != null ? item.linearWidth : "*";
        }

        // account for variable width items.  NOTE: we don't support percent widths on items
        if (width == "*" || width == "100%") {
            width = 0;

            var colSpan = item.getTitleColSpan() || 1,
                skipBefore = (item.showTitle && orientation == isc.Canvas.LEFT) ? colSpan : 0,
                skipAfter = (item.showTitle && orientation == isc.Canvas.RIGHT) ? colSpan : 0,
                startCol = placement[0] + skipBefore,
                endCol = Math.min(colWidths.length, placement[2] - skipAfter)

            ;

            //this.logWarn("item ID: " + item.ID + ", startCol: " + startCol +
            //             ", endCol: " + endCol + ", colWidths: " + colWidths);

            for (var c = startCol; c < endCol; c++) {
                width += colWidths[c];
            }

        }

        if (item.showTitle) {
            // calculate titleWidth after star-widths are calculated for "top" orientation
            if (orientation == isc.Canvas.LEFT) {
                titleWidth = colWidths[placement[0]];
            } else if (orientation == isc.Canvas.RIGHT) {
                titleWidth = colWidths[placement[2]];
            } else {
                // vertical orientation - if titleWidth isn't specified, assume item-width
                titleWidth = item.titleWidth || width;
            }
        }

        // account for variable height items
        if (item._isVariableHeight) {
            height = 0;
            var startRow = placement[1], endRow = placement[3];

            // NOTE: don't need logic for extra cells for titles, because extra cells aren't
            // added for top or bottom-oriented titles
            for (var c = startRow; c < endRow; c++) {
                height += rowHeights[c];
            }
        }

        // remember the width and height of the item
        item._size = [width, height];
        // Remember the width of the item title
        item._titleWidth = titleWidth;
    }
},

// This method should determine whether
// - tableResizePolicy has been run on this table already
// - any items visibility have changed since the policy was run
// - any items have been moved within the items array (or items removed / new items introduced)
_tableResizePolicyIsValid : function (items) {

    if (!items._rowTable) return false;
    return true;
},

// Helper method to mark an already run policy as invalid.
invalidateTableResizePolicy : function (items) {
    delete items._rowTable;
    delete items._rowHeights;
    delete items._colWidths;
},


//>    @method    Canvas.stretchResizeList()    (A)
//         Given a list of inputs sizes as:
//            a number
//                or
//            [minSize, maxSize, maxPercent, starCount]
//        and a totalSize, figure out the size of the dynamically sized items
//        according to the totalSize.
//
//        You can use percentages or fixed sizes to go beyond the totalSize
//
//      @group  drawing
//      @param  inputSizes  (Array)   array of sizes (see above)
//      @param  totalSize   (number)  total sizes for the
//      @return             (Array of number)  output sizes (all numbers)
//<
stretchResizeList : function (inputSizes, totalSize) {
    var totalPercent = 0,  // amount "%" items amount to
        starCount = 0,     // number of "*" star items
        totalFixed = 0,    // total space taken up by fixed-size items
        outputSizes = inputSizes.duplicate();

    for (var i = 0; i < inputSizes.length; i++) {
        var size = outputSizes[i];

        if (isc.isA.Number(size)) {
            // fixed size item
            size = Math.max(size,1); // assure at least 1
            totalFixed += size;
            outputSizes[i] = size;
        } else if (size != null) {
            // variable (% / * / both) sized item
            var rowPercent = size[2],
                rowStarCount = size[3]
            ;
            // if a percent without a "*"
            if (rowStarCount == 0) {
                // percentage -- add it to the percentage total
                totalPercent += rowPercent;
            }
            // tracked total amount of "*"s
            starCount += rowStarCount;
        }
    }

    // at this point,
    // - totalFixed is the total of the fixed, absolute sizes
    // - totalPercent is the total percentage numbers (that aren't stars)
    // - starCount is the total number of stars across all rows (even if those rows also have
    //   percents specified)


    // - "stars" are translated to percents, sharing all remaining percent points (of 100)
    //   not allocated to specified percent sizes
    // - stars and percents share all space not allocated to static numbers
    // - if there are any percents or stars, all space is always filled
    if (starCount) {
        var starPercent = 0;
        if (totalPercent < 100) {
            // star sized items share the remaining percent size
            starPercent = (100 - totalPercent) / starCount;
        }

        // assign a percentage to each star item
        //    if a row has both a star and a percentage, keep the larger item

        for (var r = 0; r < inputSizes.length; r++) {
            var size = outputSizes[r];

            if (isc.isA.Number(size)) continue; // skip fixed size items
            var rowPercent = size[2],
                rowStarCount = size[3],
                rowStarPercent = rowStarCount * starPercent;
            // if the total percentage from stars is greater than the fixed percent
            if (rowPercent < rowStarPercent) {
                // change the fixed percent
                size[2] = rowStarPercent;
            }

            // if this item had stars, it has not yet been included in totalPercent (even if it
            // specified both star and percent), so now include it's percent in totalPercent.
            // NB: We rely on "totalPercent" to be correct when we subsequently divy the
            // remainingSpace among items with percents; if it's wrong over/underflow will
            // occur.  However totalPercent does not need to equal 100 because percents are
            // just treated as proportions.
            if (rowStarCount > 0) totalPercent += size[2];
        }
    }

    // at this point,
    // - totalFixed is still the total of the fixed, absolute sizes
    // - totalPercent is the total percentage (including what used to be stars)
    // - we have no stars left

    // if nothing has variable size, we're done
    if (totalPercent <= 0) return outputSizes;

    var remainingSpace = Math.max(0, totalSize - totalFixed);

    //this.logWarn("remaining space: " + remainingSpace +
    //             ", totalPercent: " + totalPercent);

    // apply mins and maximums.  Note if an item gets set to its min or max, the behavior is
    // exactly as though the item had originally specified that fixed size.  remainingSpace is
    // reduced along with the totalPercent it was being divided by.  Note that when this
    // happens for a min, all other items get smaller, or for a max, all other items get
    // larger, so we have to recheck any previous mins or maxs.
    for (var r = 0; r < inputSizes.length; r++) {
        var    pixelsPerPercent = Math.max(0, remainingSpace / totalPercent),
            size = outputSizes[r];

        if (isc.isA.Number(size)) continue;

        var min = size[0];
        if (min == 0) continue;

        var itemPercent = size[2],
            itemPixels = pixelsPerPercent * itemPercent;

        if (itemPixels < min) {
            outputSizes[r] = min;
            remainingSpace -= min;
            totalPercent -= itemPercent;
            // NOTE: we really only have to go back to the last non-zero minimum
            r = 0;
        }
    }

    // check maximums
    for (var r = 0; r < inputSizes.length; r++) {
        var    pixelsPerPercent = Math.max(0, remainingSpace / totalPercent),
            size = outputSizes[r];

        if (isc.isA.Number(size)) continue;

        var max = size[1],
            itemPercent = size[2],
            itemPixels = pixelsPerPercent * itemPercent;

        if (itemPixels > max) {
            outputSizes[r] = max;
            remainingSpace -= max;
            totalPercent -= itemPercent;
            // NOTE: we really only have to go back to the last non-infinite maximum
            r = 0;
        }
    }

    // at this point, all remaining variable-sized items fall within their max and min.  (it's
    // also possible that all variable-sized items have been resolved to their max or min,
    // indicating overflow or underflow)
    pixelsPerPercent = Math.max(0, remainingSpace / totalPercent);
    for (var r = 0; r < inputSizes.length; r++) {
        size = outputSizes[r];
        if (isc.isA.Number(size)) continue;

        // get the percent of the total outstanding percent that goes to this item
        var itemPercent = size[2];
        outputSizes[r] = Math.floor(itemPercent * pixelsPerPercent);
        remainingSpace -= outputSizes[r];
    }



    // assign the remaining space to the last variable-sized item that can accept it
    if (remainingSpace > 0) {
        for (var r = inputSizes.length - 1; r >= 0; r--) {
            size = inputSizes[r];
            // only variable-sized items are eligible to receive it
            if (isc.isA.Number(size)) continue;
            // if this item can take the remaining space, we're done
            var max = size[1];
            if (outputSizes[r] + remainingSpace <= max) {
                outputSizes[r] += remainingSpace;
                break;
            }
        }
        if (r < 0 && this.logIsInfoEnabled("tablePolicy")) {
            this.logInfo("stretchResizeList(): unable to assign " + remainingSpace + "px of " +
                "remaining space to a variable-sized item due to due to specified maximums",
                "tablePolicy");
        }
    }

    // return the output sizes array
    return outputSizes;
}

});    // END isc.Canvas.addMethods()




// ButtonTable: a table of clickable items
isc.ClassFactory.defineClass("ButtonTable",isc.Canvas);
isc.ButtonTable.addProperties({
    //items:null,
    cellSpacing:0,
    cellPadding:2,
    cellBorder:0,
    tableStyle:"menuTable",
    baseButtonStyle:"button",
    backgroundColor:"CCCCCC",
    useEventParts: true
});
isc.ButtonTable.addMethods({
    setItems : function (items) {
        this.items = isc.shallowClone(items);
        this.redraw();
    },
    getInnerHTML : function () {
        var output = isc.SB.create();
        output.append(
            "<TABLE",
                    " CLASS=" , this.tableStyle,
                    // take off space for scrollbar if necessary
                    " WIDTH=" , this.getWidth() - (this.overflow == isc.Canvas.SCROLL || this.overflow == isc.Canvas.AUTO ? this.getScrollbarSize(): 0),
                    " HEIGHT=" , this.getHeight(),
                    " CELLSPACING=", this.cellSpacing,
                    " CELLPADDING=", this.cellPadding,
                    " BORDER=" , this.cellBorder,
                "><TR>");

        for (var r = 0; r < this.items.length; r++) {
            var row = this.items[r];
            output.append("<TR>");

            if (!isc.isAn.Array(row)) row = [row];
            for (var i = 0; i < row.length; i++) {
                var item = row[i];
                if (item.eventPart) {
                    output.append(this.getCellButtonHTML(item.contents,
                                                         item.style, item.disabled, item.selected,
                                                         item.align, item.extraTagStuff,
                                                         item.eventPart, item.eventId));
                } else {
                    output.append(this.getCellHTML(item.contents, item.style, item.align, item.extraTagStuff));
                }
            }
            output.append("</TR>");
        }

        output.append("</TABLE>");

        return output.release(false);
    },

    buttonTableClickMaskDefaults: {
        _constructor: "Canvas",
        width: "100%",
        height: "100%",
        overflow: "hidden",
        click : function () {
            this.creator.hide();
        }
    },

    showModal : function () {
        if (!this.buttonTableClickMask) {
            // show a local clickMask canvas
            this.buttonTableClickMask = this.createAutoChild("buttonTableClickMask");
        }
        this.buttonTableClickMask.show();
        this.buttonTableClickMask.bringToFront();

        // show this menu, unmask it and move it above the local clickMask canvas
        this.show();
        this.unmask();
        this.moveAbove(this.buttonTableClickMask);
    },

    // override hide to hide the clickMask
    hide : function () {
        this.Super("hide", arguments);
        // hide the local clickMask canvas
        if (this.buttonTableClickMask) this.buttonTableClickMask.hide();
    },

    destroy : function () {
        if (this.buttonTableClickMask) {
            // destroy local the clickMask canvas
            this.buttonTableClickMask.destroy();
            this.buttonTableClickMask = null;
        }
        this.Super("destroy", arguments);
    },

    // base style and state.
    // The "base" style can be modified to be "Over", "Selected" or "Disabled"
    // Note that "Over" and "Disabled" are mutex - we apply the standard "over" state to
    // disabled buttons (though we do support the "SelectedOver" state)

    getButtonBaseStyle : function (element) {
        var baseStyle;
        if (element) baseStyle = element.getAttribute("basestyle");
        if (!baseStyle) baseStyle = this.baseButtonStyle;
        return baseStyle;
    },

    getMouseOutStyle : function (element) {
        var baseStyle = this.getButtonBaseStyle(element);
        if (this.buttonIsSelected(element)) {
            baseStyle += "Selected"
        }
        if (this.buttonIsDisabled(element)) {
            baseStyle += "Disabled"
        }
        return baseStyle;
    },

    buttonIsSelected : function (element) {
        return element && element.getAttribute("buttonselected");
    },

    buttonIsDisabled : function (element) {
        return element && element.getAttribute("buttondisabled");
    },


    cellButtonOver : function (element) {
        var style = this.getButtonBaseStyle(element);
        if (this.buttonIsSelected(element))  style += "Selected";
        if (element) element.className = style + "Over";

    },

    cellButtonOut : function (element) {
        if (!element) return;
        element.className = this.getMouseOutStyle(element);
    },

    cellButtonDown : function (element) {
        if (element) {
            var style = this.getButtonBaseStyle(element);
            if (this.buttonIsSelected(element))  style += "Selected";
            style += "Down"
            element.className = style;
        }
    },

    getCellHTML : function (contents, style, align, extraTagStuff) {
        // No need to write basestyle onto this element - we only show dynamic-styling for
        // buttons, not standard cells
        return isc.StringBuffer.concat(
            "<TD ALIGN=" , (align || isc.Canvas.CENTER), " CLASS=" , (style || this.baseButtonStyle + "Disabled") ,
                (extraTagStuff || extraTagStuff), ">",
                contents,
            "</TD>"
        );
    },

    handleMouseDown : function (event) {

        event.touchStartReturnValue = false;

        var element = event.nativeTarget;

        // call CellButtonDown on the table cell, not the contained HTML
        if (element.tagName != "TD") element = element.parentNode;

        // do not call CellButtonDown for clicks on HTML generated by getCellHTML
        if (!element.getAttribute || !element.getAttribute(this._$eventPart)) return;

        this.cellButtonDown(element);
        this.Super("handleMouseDown", arguments);
    },

    handleMouseUp : function (event) {
        var element = event.nativeTarget;

        // call CellButtonOut on the table cell, not the contained HTML
        if (element.tagName != "TD") element = element.parentNode;

        // do not call CellButtonOut for clicks on HTML generated by getCellHTML
        if (!element.getAttribute || !element.getAttribute(this._$eventPart)) return;

        this.cellButtonOut(element);
        this.Super("handleMouseUp", arguments);
    },

    getCellButtonHTML : function (contents, style, selected, disabled, align,
                                  extraTagStuff, eventPart, id) {

        if (style == null) style = this.baseButtonStyle;
        var modifiedStyle = style;

        if (selected) modifiedStyle += "Selected";
        if (disabled) modifiedStyle += "Disabled";

        // always install an eventpart property to distinguish from getCellHTML()
        var eventHTML = " " + this._$eventPart + "=" + (eventPart ? eventPart : "_noHandler");
        if (id != null) eventHTML += " id=" + this.getID() + "_" + eventPart + "_" + id;

        return isc.StringBuffer.concat(
            "<TD ALIGN=" , (align || isc.Canvas.CENTER), " CLASS=" , modifiedStyle,
                " ONMOUSEOVER='" , this.getID() , ".cellButtonOver(this);return false;' ",
                " ONMOUSEOUT='" , this.getID() , ".cellButtonOut(this);return true;'",
                " basestyle='", style, "'",
                (selected ? " buttonselected='true'" : null),
                (disabled ? " buttondisabled='true'" : null),
                (extraTagStuff ? " " + extraTagStuff : null),
                eventHTML + ">",
                contents,
            "</TD>"
        );
    }
});




// This file creates a mini-calendar that is used to pick a date, for example, you might have a
// button next to a form date field that brings this file up.




//>    @class    DateGrid
//
// A ListGrid subclass that manages calendar views.
//
// @inheritsFrom ListGrid
// @treeLocation Client Reference/Forms
// @visibility external
//<
if (isc.ListGrid == null) {
    isc.Log.logInfo("Source for DateGrid included in this module, but required " +
        "superclass (ListGrid) is not loaded. This can occur if the Forms module is " +
        "loaded without the Grids module. DateGrid class will not be defined within " +
        "this page.", "moduleDependencies");
} else {

// create a customized ListGrid to show the days in a month
isc.ClassFactory.defineClass("DateGrid", "ListGrid");

isc.DateGrid.addProperties({
    width: 10,
    height: 10,
    cellHeight: 20,
    minFieldWidth: 20,
    autoFitMaxRows: 5,
    useCellRollOvers: true,
    canSelectCells: true,
    leaveScrollbarGap: false,
    canResizeFields: false,
    headerButtonProperties: {
        padding: 0
    },
    headerHeight: 20,
    canSort: false,
    canEdit: false,

    showSortArrow: isc.ListGrid.NONE,
    showFiscalYear: false,
    showFiscalWeek: false,
    showCalendarWeek: false,

    loadingDataMessage: "",
    alternateRecordStyles: false,

    showHeaderMenuButton: false,
    showHeaderContextMenu: false,

    canSaveSearches:false,

    cellPadding: 0,

    wrapCells: false,

    // we need to locate rows by cell-value, not PK or whatever else
    locateRowsBy: "targetCellValue",

    fiscalYearFieldTitle: "Year",
    weekFieldTitle: "Wk",

    canReorderFields: false,

    bodyProperties: {
        // this should not be needed
        _generated: true,
        canSelectOnRightMouse: false
    },
    autoFitData: "both",

    init : function () {
        // set up all fields
        var weekends = this.getWeekendDays();
        this.shortDayNames = isc.DateUtil.getShortDayNames(3);
        this.shortDayTitles = isc.DateUtil.getShortDayNames(this.dayNameLength);
        this.shortMonthNames = isc.DateUtil.getShortMonthNames();

        var _this = this;
        this.fields = [
            { name: "fiscalYear", type: "number", title: this.fiscalYearFieldTitle,
                width: this.fiscalYearColWidth,
                align: "center", cellAlign: "center", showRollOver: false, showDown: false,
                baseStyle: this.baseFiscalYearStyle,
                headerBaseStyle: this.fiscalYearHeaderStyle || this.baseFiscalYearStyle,
                showIf : function (list, field) {
                    return list.showFiscalYear == true;
                }
            },
            { name: "fiscalWeek", type: "number", title: this.weekFieldTitle,
                width: 25,
                align: "center", showRollOver: false, showDown: false,
                baseStyle: this.baseWeekStyle,
                headerBaseStyle: this.weekHeaderStyle || this.baseWeekStyle,
                showIf : function (list, field) {
                    return list.showFiscalWeek == true;
                }
            },
            { name: "calendarWeek", type: "number", title: this.weekFieldTitle,
                width: 25,
                align: "center", showRollOver: false, showDown: false,
                baseStyle: this.baseWeekStyle,
                headerBaseStyle: this.weekHeaderStyle || this.baseWeekStyle,
                showIf : function (list, field) {
                    return list.showCalendarWeek == true;
                }
            }
        ];
        for (var i=0; i<7; i++) {
            var dayNum = i + this.firstDayOfWeek;
            if (dayNum > 6) dayNum -= 7;

            var isWeekend = weekends.contains(dayNum);
            var obj = { name: this.shortDayNames[dayNum], weekStartOffset: i,
                isWeekend: isWeekend,
                isDateField: true,
                align: "center",
                dayNum: dayNum,
                baseStyle: isWeekend && this.styleWeekends ? this.baseWeekendStyle : this.baseWeekdayStyle,
                headerBaseStyle: isWeekend && this.styleWeekends ? this.weekendHeaderStyle : this.headerBaseStyle,
                showIf : function (list, field) { return list.showWeekends || field.isWeekend == false; }
            };
            this.fields.add(obj);
        }
        // flag fields as generated
        this.fields.setProperty("_generated", true);

        // prepare initial date-range
        if (!this.chosenDate) this.chosenDate = isc.DateUtil.createLogicalDate();
        this.month = this.chosenDate.getMonth();
        this.year = this.chosenDate.getFullYear();
        this.day = this.chosenDate.getDate();

        var monthStart = isc.DateUtil.createLogicalDate(this.year, this.month, 1);
        this.visibleStart = isc.DateUtil.getStartOf(monthStart, "w", null, this.firstDayOfWeek);

        // set up grid data - now always 6 rows, each with a weekStart date
        this.data = [];
        var d = this.visibleStart.duplicate();
        var fiscalCalendar = this.getFiscalCalendar();
        for (var i=1; i<7; i++) {
            // fiscal year object for start date
            var fiscalYear = d.getFiscalYear(fiscalCalendar);
            var weekEndDate = isc.DateUtil.getEndOf(d, "W", true, this.firstDayOfWeek)
            var obj = { name: "week" + i,
                // start/end logical dates for the record
                weekStart: d.duplicate(),
                weekEnd: weekEndDate,
                // fiscalYear for the start date
                fiscalYear: fiscalYear.fiscalYear,
                // fiscalYear for the end date
                fiscalYearEnd: weekEndDate.getFiscalYear(fiscalCalendar).fiscalYear,

                // fiscal week (for the start date)
                fiscalWeek: d.getFiscalWeek(fiscalCalendar, this.firstDayOfWeek),
                // fiscal week end (for the end date)
                fiscalWeekEnd: weekEndDate.getFiscalWeek(fiscalCalendar, this.firstDayOfWeek),

                // calendar week (for the first day of week)
                calendarWeek: d.getWeek(this.firstDayOfWeek)
            };

            for (var j=0; j<7; j++) {
                obj[this.shortDayNames[j]] = j;
            }
            this.data.add(obj);
            d.setDate(d.getDate() + 7);
        }
        return this.Super("init", arguments);
    },

    initWidget : function () {
        // set a flag that causes setChosenDate() to always run on the first execution
        this.firstRun = true;

        this.Super("initWidget", arguments);
    },

    draw : function () {
        var result = this.Super("draw", arguments);
        // switch on space-sharing for rows, after the initial draw, which we use to measure
        // the grid's required/minimum size
        this._cellHeight = "*";
        if (this.refreshOnDraw) {
            // refreshOnDraw is a flag set in refreshUI() if it runs before draw
            delete this.refreshOnDraw;
            this.refreshUI(this.year, this.month, this.chosenDate);
        }
    },

    getTitleField : function () {
        return null;
    },

    getCellAlign : function (record, rowNum, colNum) {
        return "center";
    },

    getBaseStyle : function (record, rowNum, colNum) {
        var field = this.getField(colNum);
        if (field.isWeekend && !this.styleWeekends) return this.baseWeekdayStyle;
        return this.Super("getBaseStyle", arguments);
    },

    getCellStyle : function (record, rowNum, colNum) {
        var field = this.getField(colNum),
            weekNum = this.getRecordWeekNumber(record),
            selected = weekNum == this.selectedWeek
        ;

        if (field.name == "fiscalYear") {
            return !selected ? this.baseFiscalYearStyle : this.selectedWeekStyle;
        } else if (field.name == "fiscalWeek" || field.name == "calendarWeek") {
            return !selected ? this.baseWeekStyle : this.selectedWeekStyle;
        }

        var date = this.getCellDate(record, rowNum, colNum),
            isDisabled = this.dateIsDisabled(date),
            isOtherMonth = date.getMonth() != this.month,
            style = this.Super("getCellStyle", arguments);
        ;

        // If we're undrawn or not visible, no need to worry about special styling for
        // over row
        if (!this.body || !this.body.isDrawn() || !this.body.isVisible()) {
            return style;
        }

        if (this.body._handleDisplayIsNone()) {
            return style;
        }

        if (field.isDateField) {
            if ((isDisabled || isOtherMonth || this.isDisabled())) {

                style = field.isWeekend && this.styleWeekends ? this.disabledWeekendStyle : this.disabledWeekdayStyle;

                var eventRow = this.body.getEventRow(),
                    eventCol = this.body.getEventColumn(),
                    isOver = (eventRow == rowNum && eventCol == colNum),
                    lastSel = this.selectionManager && this.selectionManager.lastSelectedCell,
                    isSelected = lastSel ? lastSel[0] == rowNum && lastSel[1] == colNum :
                                    this.cellSelection ?
                                    this.cellSelection.isSelected(rowNum, colNum) : false,
                    overIndex = style.indexOf("Over"),
                    selectedIndex = style.indexOf("Selected")
                ;

                if (overIndex >= 0) style = style.substring(0, overIndex);
                if (selectedIndex >= 0) style = style.substring(0, selectedIndex);

                if (isSelected) style += "Selected";
                if (isOver) style += "Over";
            }
        }

        return style;
    },

    mouseOut : function () {
        // clear the last hilite
        this.clearLastHilite();
    },

    cellMouseDown : function (record, rowNum, colNum) {
        var date = this.getCellDate(record, rowNum, colNum);
        if (!date) return true;
        if (this.dateIsDisabled(date)) return false;
        return true;
    },

    cellClick : function (record, rowNum, colNum) {
        var date = this.getCellDate(record, rowNum, colNum);
        if (!date) return true;

        if (this.dateIsDisabled(date)) {
            return true;
        }

        // update the local date-parts
        this.year = date.getFullYear();
        this.month = date.getMonth();
        this.day = date.getDate();
        this.chosenDate = isc.DateUtil.createLogicalDate(this.year, this.month, this.day);

        // let the DateChooser know
        this.dateClick(this.year, this.month, this.day);
    },
    dateClick : function (year, month, date) {},

    getRecordWeekNumber : function (record) {
        // allow record-index to be passed, so you can easily get the first one
        if (record == null) return -1;
        if (isc.isA.Number(record)) record = this.data[record];
        return this.showFiscalWeek ? record.fiscalWeek : record.calendarWeek;
    },

    isSelectedWeek : function (record) {
        return this.getRecordWeekNumber(record) == this.selectedWeek;
    },

    cellSelectionChanged : function (cellList) {
        var sel = this.getCellSelection();
        for (var i=0; i<cellList.length; i++) {
            var cell = cellList[i];
            if (sel.cellIsSelected(cell[0], cell[1])) {
                var weekNum = this.getRecordWeekNumber(this.getRecord(cell[0]));
                if (this.selectedWeek != weekNum) {
                    this.setSelectedWeek(weekNum);
                }
                return;
            }
        }
        return;
    },

    getSelectedWeek : function () {
        // return the current selectedWeek, or the first one in the grid, so the
        // DateChooser header always shows the right week
        return this.selectedWeek || this.getRecordWeekNumber(0);
    },

    setSelectedWeek : function (weekNum) {
        this.selectedWeek = weekNum;
        this.markForRedraw();
        this.selectedWeekChanged(this.selectedWeek);
    },
    selectedWeekChanged : function (weekNum) {},

    getWorkingMonth : function () {
        return this.month;
    },
    getSelectedDate : function () {
        return this.chosenDate;
    },

    disableMarkedDates : function () {
        this.disabledDateStrings = {};
        if (this.disabledDates && this.disabledDates.length > 0) {
            for (var i=0; i<this.disabledDates.length; i++) {
                this.disabledDateStrings[this.disabledDates[i].toShortDate()] = true;
            }
        }
    },

    dateIsDisabled : function (date) {
        if (!date) return;
        if (this.disableWeekends && this.dateIsWeekend(date)) return true;
        var disabled = this.disabledDateStrings ?
                this.disabledDateStrings[date.toShortDate()] != null : false;
        return disabled;
    },

    getCellDate : function (record, rowNum, colNum) {
        var field = this.getField(colNum);
        if (field.weekStartOffset == null) return null;
        var rDate = record.weekStart.duplicate();
        rDate.setDate(rDate.getDate() + field.weekStartOffset);
        return rDate;
    },

    dateInView : function (date) {
        if (isc.DateUtil.compareLogicalDates(date, this.visibleStart) > 0) {
            // date before view-start
            return false;
        } else {
            var endDate = isc.DateUtil.createLogicalDate(this.visibleStart);
            endDate = isc.DateUtil.adjustDate(endDate, "+5W")
            if (isc.DateUtil.compareLogicalDates(date, endDate) < 0) {
                // date after view-end
                return false;
            }
        }
        return true;
    },
    selectDateCell : function (date, weekNum) {
        var selection = this.selectionManager;
        if (!this.dateInView(date)) {
            // date outside the current view - clear any current cell-selection
            selection && selection.deselectAll && selection.deselectAll();
            delete selection.lastSelectedCell
            this.body.markForRedraw();

            // and select either the passed weekNum (which comes from a cellClick() in the
            // DateChooser's weekMenu), or the first visible week, for display in the
            // DateChooser header
            this.setSelectedWeek(weekNum != null ? weekNum : this.getRecordWeekNumber(0));

            return;
        }

        var cell = this.getDateCell(date);

        if (!cell) {
            // selected date isn't visible - clear the selection - selected date will be
            // reselected if it re-appears later
            if (selection && selection.deselectAll) selection.deselectAll();
            return;
        }

        if (cell.colNum != null) selection.selectSingleCell(cell.rowNum, cell.colNum);

        // select either the passed weekNum (which comes from a cellClick() in the
        // DateChooser's weekMenu), or the week containing the selected date
        this.setSelectedWeek(weekNum != null ? weekNum : this.getRecordWeekNumber(cell.record));
    },

    getDateCell : function (date) {
        //this.logWarn("in getDateCell()");
        // returns an object with rowNum, colNum and record
        var selection = this.getCellSelection(),
            data = this.data
        ;

        if (date && data && data.length > 0) {
            var dayCount = this.showWeekends == false ? 5 : 7;
            var field = this.getField(this.shortDayNames[date.getDay()]);
            var fieldNum = field ? this.getFieldNum(field.name) : null;
            for (var i=0; i<data.length; i++) {
                var record = data[i];
                var cellDate = record.weekStart.duplicate();
                if (cellDate) {
                    cellDate.setDate(cellDate.getDate() + field.weekStartOffset);
                    if (isc.DateUtil.compareLogicalDates(cellDate, date) == 0) {
                        return { rowNum: i, colNum: fieldNum, record: record };
                    }
                }
            }
        }
    },

    shouldDisableDate : function (date) {
        var result = this.dateIsDisabled(date);
        return result;
    },

    getCellValue : function (record, rowNum, colNum, body) {
        var date = this.getCellDate(record, rowNum, colNum);
        if (date) return date.getDate();
        return this.Super("getCellValue", arguments);
    },

    getFieldTitle : function (fieldId) {
        var f = this.getField(fieldId);
        if (f.weekStartOffset != null) {
            return this.shortDayTitles[f.dayNum];
        }
        return this.Super("getFieldTitle", arguments);
    },

    // override getRowHeight() to make the rows always fill the body when it changes size
    getRowHeight : function (record, rowNum) {
        if (this.body && this._cellHeight == "*") {
            // use the outer-grid's current height, minus it's header height as the viewport
            // this is appropriate because the grid is clipping, and the body's inner height
            // doesn't shrink when the grid does, so neither do its rows
            var viewportHeight = this.getViewportHeight() - this.header.getVisibleHeight();
            var rowCount = this.getTotalRows(),
                rowHeight = Math.floor(viewportHeight / rowCount),
                // final row may be up to (rowCount-1) pixels taller than the other rows
                lastRowHeight = Math.floor(viewportHeight - (rowHeight*(rowCount-1)))
            ;
            if (rowNum == rowCount-1) return lastRowHeight-1;
            return rowHeight;
        }
        return this.Super("getRowHeight", arguments);
    },

    refreshUI : function (year, month, chosenDate, weekNum) {
        if (!this.isDrawn()) {
            // store the params and set a flag that will rerun this method on draw()
            this.year = year;
            this.month = month;
            this.chosenDate = chosenDate;
            this.refreshOnDraw = true;
            return;
        }
        if (this.firstRun || chosenDate && isc.DateUtil.compareLogicalDates(chosenDate, this.chosenDate) != 0) {
            delete this.firstRun;
            // if passed a new chosenDate, call setChosenDate() which navigates the view and
            // selects the date-cell
            this.setChosenDate(chosenDate);
        } else {
            // otherwise, shift to the requested month/year if necessary, and potentially
            // override to select the passed weekNum (from clicks in the DateChooser weekMenu
            this.showMonth(month, year, weekNum);
        }
    },

    // redrawOnResize, so the rows re-fill the vertical space
    redrawOnResize: true,

    setChosenDate : function (chosenDate) {
        // store the chosenDate, for highlighting later
        this.chosenDate = chosenDate.duplicate();
        this.day = this.chosenDate.getDate();
        // shift month if necessary - update this.month/year
        this.showMonth(this.chosenDate.getMonth(), this.chosenDate.getFullYear());
    },

    showMonth : function (month, year, weekNum) {
        //if (this.month == month && this.year == year) return;

        // remove the selected week - recalculated below
        delete this.selectedWeek;

        this.month = month;
        if (year) this.year = year;

        this.monthStart = isc.DateUtil.createLogicalDate(this.year, this.month, 1)
        this.visibleStart = isc.DateUtil.getStartOf(this.monthStart, "w", true,
            this.firstDayOfWeek);

        // iterate over the grid data - now always 6 rows, each with a weekStart date
        var d = this.visibleStart.duplicate()
        var fiscalCalendar = this.getFiscalCalendar();
        for (var i=0; i<6; i++) {
            // fiscal year object for start date
            var fiscalYear = d.getFiscalYear(fiscalCalendar);
            var weekEndDate = isc.DateUtil.getEndOf(d, "W", true, this.firstDayOfWeek);
            isc.addProperties(this.data[i], {
                weekStart: d.duplicate(),
                weekEnd: weekEndDate,
                // fiscalYear for the start date
                fiscalYear: fiscalYear.fiscalYear,
                // fiscalYear for the end date
                fiscalYearEnd: weekEndDate.getFiscalYear(fiscalCalendar).fiscalYear,

                // fiscal week (for the start date)
                fiscalWeek: d.getFiscalWeek(fiscalCalendar, this.firstDayOfWeek),
                // fiscal week end (for the end date)
                fiscalWeekEnd: weekEndDate.getFiscalWeek(fiscalCalendar, this.firstDayOfWeek),

                // calendar week (for the first day of week)
                calendarWeek: isc.DateUtil.adjustDate(d, "+4d").getWeek(this.firstDayOfWeek)
            });
            d.setDate(d.getDate() + 7);
        }
        this.disableMarkedDates();

        // see whether showIf and other details need re-evaluating on the fields
        // always update fields if showFiscalYear is true, because the firstDayOfWeek
        // is different for every year, so the field-titles and weekend-styles always
        // need updating
        var needsFieldUpdate = this.showFiscalYear ||
            (this.showWeekends != this._showWeekends) ||
            (this.showFiscalWeek != this.fieldIsVisible("fiscalWeek")) ||
            (this.showCalendarWeek != this.fieldIsVisible("calendarWeek"))
        ;

        if (needsFieldUpdate) {
            var weekends = this.getWeekendDays();
            var firstDateCol = this.showFiscalYear ? 1 : 0;
            if (this.showFiscalWeek || this.showCalendarWeek) firstDateCol++;
            for (var i=0; i<7; i++) {
                var dayNum = i + this.firstDayOfWeek;
                if (dayNum > 6) dayNum -= 7;

                var isWeekend = weekends.contains(dayNum);
                var obj = { name: this.shortDayNames[dayNum],
                    weekStartOffset: i,
                    isWeekend: isWeekend,
                    isDateField: true,
                    align: "center",
                    dayNum: dayNum,
                    baseStyle: isWeekend && this.styleWeekends ? this.baseWeekendStyle : this.baseWeekdayStyle,
                    headerBaseStyle: isWeekend && this.styleWeekends ? this.weekendHeaderStyle : this.headerBaseStyle,
                    showIf : function (list, field) { return list.showWeekends || field.isWeekend == false; }
                };
                var field = this.fields[firstDateCol + i];
                if (field) isc.addProperties(field, obj);
            }
            this.refreshFields();
        }

        // do an immediate redraw() to update visible fields - needed for autoTests
        if (this.isDrawn()) this.redraw();

        // select the cell for the chosenDate, if it's visible
        this.selectDateCell(this.getSelectedDate(), weekNum)

        // remember showWeekends, to check for a change on the next run through this method
        this._showWeekends = this.showWeekends;
    },

    fiscalYearColWidth: 30,
    getWeekendDays : function () {
        if (!this.weekendDays) this.weekendDays = isc.DateUtil.getWeekendDays();
        return this.weekendDays;
    },
    dateIsWeekend : function (date) {
        if (!date) return false;
        var wd = this.getWeekendDays();
        return date.getDay() == wd[0] || date.getDay() == wd[1];
    },

    getFiscalCalendar : function () {
        return this.fiscalCalendar || isc.DateUtil.getFiscalCalendar();
    },


    // set this to false to allow the DateGrid to NOT always show fiscal week 1 - instead, it
    // may show either the highest partial week or 1, depending on where the fiscalStartDate is
    alwaysShowFirstFiscalWeek: true,
    getWeekRecord : function (date) {
        var fiscalCalendar = this.getFiscalCalendar(),
            // fiscal year object for start date
            fiscalYear = date.getFiscalYear(fiscalCalendar),
            // end of week date
            endDate = isc.DateUtil.dateAdd(date, "d", 6)
        ;

        if (date.logicalDate) endDate.logicalDate = true;

        // use the fourth day of the week to determine which week-number to display
        var weekDate = isc.DateUtil.dateAdd(date, "D", 4);

        var record = {
            // first date within the row
            rowStartDate: date,
            rowEndDate: endDate.duplicate(),

            // fiscalYear for the start date
            fiscalYear: fiscalYear.fiscalYear,
            // fiscalYear for the end date
            fiscalYearEnd: endDate.getFiscalYear(fiscalCalendar).fiscalYear,

            // fiscal week (for the start date)
            fiscalWeek: date.getFiscalWeek(fiscalCalendar, this.firstDayOfWeek),
            // fiscal week end (for the end date)
            fiscalWeekEnd: endDate.getFiscalWeek(fiscalCalendar, this.firstDayOfWeek),

            // calendar week (for the first day of week)
            calendarWeek: weekDate.getWeek(this.firstDayOfWeek),

            weekDate: weekDate
        };



        // If we hit a fiscal week boundary, or a fiscalYear boundary, show the
        // week / year title in which more days in the week fall.

        if (record.fiscalWeek != record.fiscalWeekEnd) {

            var roundUpYear = false,
                roundUpWeek = false;

            if (record.fiscalYear != record.fiscalYearEnd) {
                if (!this.alwaysShowFirstFiscalWeek) {
                    var newYearStartDay =  Date.getFiscalStartDate(endDate, fiscalCalendar).getDay(),
                        delta = newYearStartDay - this.firstDayOfWeek;
                    if (delta < 0) delta += 6;
                    if (delta < 3) roundUpYear = true;
                } else roundUpYear = true;
            }

            if (!roundUpYear) {
                var yearStartDay = Date.getFiscalStartDate(date, fiscalCalendar).getDay(),
                    delta = yearStartDay - this.firstDayOfWeek;
                if (delta < 0) delta += 6;
                if (delta > 0 && delta < 3) roundUpWeek = true;
            }

            if (roundUpYear) {
                record.fiscalYear = record.fiscalYearEnd;
                record.fiscalWeek = 1;
            } else if (roundUpWeek) {
                record.fiscalWeek += 1;
            }



        }

        var year = date.getFullYear(),
            month = date.getMonth(),
            weekendDays = this.getWeekendDays()
        ;
        for (var i=0; i<7; i++) {
            var thisDate = isc.DateUtil.createLogicalDate(year, month, date.getDate() + i, 0);
            //if (this.showWeekends || !weekendDays.contains(thisDate.getDay())) {
                var dayName = this.shortDayNames[thisDate.getDay()];
                record[dayName] = thisDate;
            //}
        }

        return record;
    }
});

} // END of if (isc.ListGrid == null) else case


// This file creates a mini-calendar that is used to pick a date, for example, you might have a
// button next to a form date field that brings this file up.




//>    @class    DateChooser
//
// Simple interactive calendar interface used to pick a date.
// Used by the +link{class:dateItem} class.
//
// @inheritsFrom VLayout
// @treeLocation Client Reference/Forms
// @visibility external
//<

// create a special canvas to show the days in a month
isc.ClassFactory.defineClass("DateChooser", "VLayout");

isc.DateChooser.addProperties({
    // set a default initial height to prevent the SGWT Showcase from stretching a standalone
    // DateChooser to full height of it's TabPane
    height: 1,
    overflow: "visible",

    // set inherentWidth, to prevent the DateChooser from filling it's parent layout -
    // width: "100%" will still work
    inherentWidth: true,
    neverExpandWidth: true,

    // Header
    // ---------------------------------------------------------------------------------------

    //> @attr dateChooser.navigationLayout (AutoChild HLayout : null : IR)
    // An +link{AutoChild} +link{HLayout}, rendered above the +link{class:DateGrid, date grid},
    // and showing a number of widgets for navigating the DateChooser.  These include buttons
    // for moving to the previous +link{dateChooser.previousYearButton, year} or
    // +link{dateChooser.previousMonthButton, month}, the next
    // +link{dateChooser.nextYearButton, year} or +link{dateChooser.nextMonthButton, month},
    // and for selecting a specific +link{dateChooser.yearChooserButton, year},
    // +link{dateChooser.monthChooserButton, month} or
    // +link{dateChooser.weekChooserButton, week}.
    // @visibility external
    //<
    showNavigationLayout:true,
    navigationLayoutConstructor: "HLayout",
    navigationLayoutDefaults: {
        width: 1,
        height: 1,
        layoutAlign: "top",
        align: "center"
    },

    //> @attr DateChooser.closeOnDateClick (Boolean : null : IRW)
    // When editing a "date" value, with no time portion, clicking on a date-cell selects the
    // date and closes the DateChooser.  When a +link{dateChooser.showTimeItem, time portion}
    // is required, however, the +link{dateChooser.applyButton, apply button} must be clicked
    // to close the chooser, by default.
    // <P>
    // Set this attribute to true to have the DateChooser close when a user clicks in a
    // date-cell, even if the +link{dateChooser.timeItem, timeItem} is showing.
    // @visibility external
    //<

    //> @attr DateChooser.showFiscalYearChooser (Boolean : false : IRW)
    // When set to true, show a button that allows the calendar to be navigated by fiscal year.
    // @visibility external
    //<
    showFiscalYearChooser: false,

    //> @attr dateChooser.fiscalYearChooserButton (AutoChild IButton : null : IR)
    // A button shown in the +link{dateChooser.navigationLayout, navigation layout} which,
    // when clicked, shows a picker for selecting a specific fiscal year.
    // @visibility external
    //<
    fiscalYearChooserButtonDefaults: {
        minWidth: 30,
        autoFit: true,
        click : function () {
            this.creator.showFiscalYearMenu();
        },
        autoParent: "navigationLayout",
        align: "center"
    },

    //> @attr DateChooser.showWeekChooser (Boolean : false : IRW)
    // When set to true, show a button that allows the calendar to be navigated by week or
    // fiscal week, depending on the value of +link{showFiscalYearChooser}.
    //
    // @visibility external
    //<
    showWeekChooser: false,

    //> @attr dateChooser.weekChooserButton (AutoChild IButton : null : IR)
    // A button shown in the +link{dateChooser.navigationLayout, navigation layout} which shows
    // a picker for selecting a specific week of the year.  When +link{showFiscalYearChooser}
    // is true, the week number represents a fiscal week number, one offset from the start of
    // the fiscal year.  Otherwise, it represents a week number offset from the start of the
    // calendar year.
    //
    // @visibility external
    //<
    weekChooserButtonDefaults: {
        minWidth: 25,
        autoFit: true,
        click : function () {
            this.creator.showWeekMenu();
        },
        autoParent: "navigationLayout",
        align: "center"
    },

    //> @attr dateChooser.previousYearButton (AutoChild IButton : null : IR)
    // A button shown in the +link{dateChooser.navigationLayout, navigation layout} that shifts
    // the calendar view backward by a year.
    //
    // @visibility external
    //<
    previousYearButtonDefaults: {
        width: 20,
        click : function () {
            this.creator.showPrevYear();
        },
        autoParent: "navigationLayout",
        align: "center",
        noDoubleClicks: true
    },
    //> @attr dateChooser.previousYearButtonAriaLabel (String : "Previous year" : IR)
    // +link{statefulCanvas.ariaLabel,Aria label} for the +link{previousYearButton}.
    //
    // @group i18nMessages
    // @visibility external
    //<
    previousYearButtonAriaLabel:"Previous year",

    //> @attr dateChooser.previousMonthButton (AutoChild IButton : null : IR)
    // A button shown in the +link{dateChooser.navigationLayout, navigation layout} that shifts
    // the calendar view backward by a month.
    //
    // @visibility external
    //<
    previousMonthButtonDefaults: {
        width: 20,
        click : function () {
            this.creator.showPrevMonth();
        },
        autoParent: "navigationLayout",
        align: "center",
        noDoubleClicks: true
    },
    //> @attr dateChooser.previousMonthButtonAriaLabel (String : "Previous month" : IR)
    // +link{statefulCanvas.ariaLabel,Aria label} for the +link{previousMonthButton}.
    //
    // @group i18nMessages
    // @visibility external
    //<
    previousMonthButtonAriaLabel:"Previous month",

    //> @attr dateChooser.monthChooserButton (AutoChild IButton : null : IR)
    // A button shown in the +link{dateChooser.navigationLayout, navigation layout} that shows
    // a picker for selecting a specific month.
    //
    // @visibility external
    //<
    monthChooserButtonDefaults: {
        click : function () {
            this.creator.showMonthMenu();
        },
        autoParent: "navigationLayout",
        align: "center"
    },

    //> @attr dateChooser.yearChooserButton (AutoChild IButton : null : IR)
    // A button shown in the +link{dateChooser.navigationLayout, navigation layout} that shows
    // a picker for selecting a specific calendar year.
    //
    // @visibility external
    //<
    yearChooserButtonDefaults: {
        click : function () {
            this.creator.showYearMenu();
        },
        autoParent: "navigationLayout",
        align: "center"
    },

    //> @attr dateChooser.nextMonthButton (AutoChild IButton : null : IR)
    // A button shown in the +link{dateChooser.navigationLayout, navigation layout} that shifts
    // the calendar view forward by a month.
    //
    // @visibility external
    //<
    nextMonthButtonDefaults: {
        width: 20,
        click : function () {
            this.creator.showNextMonth();
        },
        autoParent: "navigationLayout",
        align: "center",
        noDoubleClicks: true
    },
    //> @attr dateChooser.nextMonthButtonAriaLabel (String : "Next month" : IR)
    // +link{statefulCanvas.ariaLabel,Aria label} for the +link{nextMonthButton}.
    //
    // @group i18nMessages
    // @visibility external
    //<
    nextMonthButtonAriaLabel:"Next month",

    //> @attr dateChooser.nextYearButton (AutoChild IButton : null : IR)
    // A button shown in the +link{dateChooser.navigationLayout, navigation layout} that shifts
    // the calendar view forward by a year.
    //
    // @visibility external
    //<
    nextYearButtonDefaults: {
        width: 20,
        click : function () {
            this.creator.showNextYear();
        },
        autoParent: "navigationLayout",
        align: "center",
        noDoubleClicks: true
    },
    //> @attr dateChooser.nextYearButtonAriaLabel (String : "Next year" : IR)
    // +link{statefulCanvas.ariaLabel,Aria label} for the +link{nextYearButton}.
    //
    // @group i18nMessages
    // @visibility external
    //<
    nextYearButtonAriaLabel:"Next year",

    //> @attr dateChooser.buttonLayout (AutoChild HLayout : null : IR)
    // An +link{AutoChild} +link{HLayout}, rendered below the +link{class:DateGrid, date grid},
    // and showing the +link{dateChooser.todayButton, Today},
    // +link{dateChooser.cancelButton, Cancel} and, when working with "datetime" values,
    // +link{dateChooser.applyButton, Apply} buttons.
    // @visibility external
    //<
    buttonLayoutConstructor: "HLayout",
    buttonLayoutDefaults: {
        width: 1,
        height: 1,
        overflow: "visible",
        align: "center",
        defaultLayoutAlign:"center",
        extraSpace: 2
    },

    //> @attr dateChooser.dateGrid (AutoChild DateGrid : null : IR)
    // A +link{ListGrid} subclass, responsible for rendering the calendar view.
    //
    // @visibility external
    //<
    dateGridDefaults: {
        _constructor: "DateGrid",
        layoutAlign: "top",
        dateClick : function (year, month, date) {
            this.creator.dateClick(year, month, date);
        },
        getSelectedDate : function () {
            return this.creator.chosenDate;
        },
        selectedWeekChanged : function (weekNum) {
            this.creator.updateWeekChooser();
        }
    },

    bottomButtonConstructor:"IButton",

    //> @attr dateChooser.todayButton (AutoChild IButton : null : IR)
    // A button shown below the +link{class:DateGrid, calendar grid} which, when clicked,
    // navigates the calendar to today.
    //
    // @visibility external
    //<
    todayButtonDefaults: {
        padding: 2,
        autoFit: true,
        //autoParent: "buttonLayout",
        click : function () {
            this.creator.todayClick();
        }
    },

    //> @attr dateChooser.cancelButton (AutoChild IButton : null : IR)
    // A button shown below the +link{class:DateGrid, calendar grid} which, when clicked,
    // closes the DateChooser without selecting a value.
    //
    // @visibility external
    //<
    cancelButtonDefaults: {
        padding: 2,
        autoFit: true,
        //autoParent: "buttonLayout",
        click : function () {
            this.creator.cancelClick();
        }
    },

    //> @attr dateChooser.applyButton (AutoChild IButton : null : IR)
    // When a DateChooser is configured for +link{dateChooser.timeItem, a "datetime" value},
    // clicking on a date cell in the +link{dateChooser.dateGrid, grid} will not automatically
    // dismiss the DateChooser canvas.  In this case, use the <code>Apply</code> button to
    // accept the selected date and time and dismiss the chooser.
    //
    // @visibility external
    //<
    applyButtonDefaults: {
        padding: 2,
        autoFit: true,
        //autoParent: "buttonLayout",
        click : function () {
            this.creator.applyClick();
        }
    },

    //> @attr DateChooser.headerHeight (Integer : 20 : IR)
    // Height of the header area (containing the navigation buttons) in pixels.
    // @visibility external
    // @deprecated in favor of +link{dateChooser.navigationLayoutHeight}
    //<

    //> @attr DateChooser.navigationLayoutHeight (int : 20 : IR)
    // Height of the +link{dateChooser.navigationLayout, navigation area}, containing the
    // various buttons for navigating the +link{dateChooser.dateGrid, calendar view}.
    // @visibility external
    //<
    navigationLayoutHeight:20,


    showYearButtons:true,
    showYearChooser:true,
    showMonthButtons:true,
    showMonthChooser:true,

    //> @attr DateChooser.skinImgDir (SCImgURL : "images/common/" : IRWA)
    // Overridden directory where images for this widget (such as the month and year button icons)
    // may be found.
    // @visibility external
    //<
    skinImgDir:"images/common/",

    //> @attr DateChooser.prevYearIcon (URL : "[SKIN]doubleArrow_left.gif" : IR)
    // Icon for the previous year button
    // @see attr:DateChooser.showDoubleYearIcon
    // @visibility external
    //<
    prevYearIcon:"[SKIN]doubleArrow_left.gif",

    //> @attr DateChooser.prevYearIconRTL (URL : null : IRW)
    // Icon for the previous year button if +link{isc.Page.isRTL()} is true.
    // If not set, and the page is in RTL mode, the +link{nextYearIcon} will be
    // used in place of the +link{prevYearIcon} and vice versa.
    // @see attr:DateChooser.showDoubleYearIcon
    // @visibility external
    //<

    //> @attr DateChooser.prevYearIconWidth (int : 14 : IR)
    // Width of the icon for the previous year button
    // @visibility external
    //<
    prevYearIconWidth:14,
    //> @attr DateChooser.prevYearIconHeight (int : 7 : IR)
    // Height of the icon for the previous year button
    // @visibility external
    //<
    prevYearIconHeight:7,

    //> @attr DateChooser.prevMonthIcon (URL : "[SKIN]arrow_left.gif" : IR)
    // Icon for the previous month button
    // @visibility external
    //<
    prevMonthIcon:"[SKIN]arrow_left.gif",

    //> @attr DateChooser.prevMonthIconRTL (URL : null : IR)
    // Icon for the previous month button if +link{isc.Page.isRTL()} is true.
    // If not set, and the page is in RTL mode, the +link{nextMonthIcon} will be
    // used in place of the +link{prevMonthIcon} and vice versa.
    // @visibility external
    //<

    //> @attr DateChooser.prevMonthIconWidth (int : 7 : IR)
    // Width of the icon for the previous month button
    // @visibility external
    //<
    prevMonthIconWidth:7,

    //> @attr DateChooser.prevMonthIconHeight (int : 7 : IR)
    // Height of the icon for the previous month button
    // @visibility external
    //<
    prevMonthIconHeight:7,

    //> @attr DateChooser.nextYearIcon (URL : "[SKIN]doubleArrow_right.gif" : IR)
    // Icon for the next year button
    // @see attr:DateChooser.showDoubleYearIcon
    // @visibility external
    //<
    nextYearIcon:"[SKIN]doubleArrow_right.gif",

    //> @attr DateChooser.nextYearIconRTL (URL : null : IR)
    // Icon for the next year button if +link{isc.Page.isRTL()} is true.
    // If not set, and the page is in RTL mode, the +link{nextYearIcon} will be
    // used in place of the +link{prevYearIcon} and vice versa.
    // @see attr:DateChooser.showDoubleYearIcon
    // @visibility external
    //<

    //> @attr DateChooser.nextYearIconWidth (int : 14 : IR)
    // Width of the icon for the next year button
    // @visibility external
    //<
    nextYearIconWidth:14,

    //> @attr DateChooser.nextYearIconHeight (int : 7 : IRW)
    // Height of the icon for the next year button
    // @visibility external
    //<
    nextYearIconHeight:7,

    //> @attr DateChooser.nextMonthIcon (URL : "[SKIN]arrow_right.gif" : IRW)
    // Icon for the next month button
    // @visibility external
    //<
    nextMonthIcon:"[SKIN]arrow_right.gif",

    //> @attr DateChooser.nextMonthIconRTL (URL : null : IRW)
    // Icon for the next month button
    // @visibility external
    //<

    //> @attr DateChooser.nextMonthIconWidth (int : 7 : IRW)
    // Width of the icon for the next month button if +link{isc.Page.isRTL()} is true.
    // If not set, and the page is in RTL mode, the +link{nextMonthIcon} will be
    // used in place of the +link{prevMonthIcon} and vice versa.
    // @visibility external
    //<
    nextMonthIconWidth:7,

    //> @attr DateChooser.nextMonthIconHeight (int : 7 : IRW)
    // Height of the icon for the next month button
    // @visibility external
    //<
    nextMonthIconHeight:7,

    //> @attr DateChooser.showDoubleYearIcon (boolean : true : IRW)
    // If this property is set to true the previous and next year buttons will render out the
    // previous and next month button icons twice rather than using the
    // +link{DateChooser.prevYearIcon} and +link{DateChooser.nextYearIcon}.
    // <P>
    // Set to <code>true</code> by default as not all skins contain media for the year icons.
    // @visibility external
    //<
    // This is really for back-compat (pre 6.1).
    // We intend to set this to true and provide year icon media in all skins we provide from this
    // point forward, but we don't want to break existing customized skins
    showDoubleYearIcon:true,

    // Pop-up Year & Month Pickers
    // ---------------------------------------------------------------------------------------

    //> @attr DateChooser.yearMenuStyle (CSSStyleName : "dateChooserYearMenu" : IR)
    // Style for the pop-up year menu.
    // @visibility external
    //<
    yearMenuStyle:"dateChooserYearMenu",

    //> @attr DateChooser.startYear (int : 2010 : IR)
    // Earliest year that may be selected.  If this chooser was opened by a
    // +link{class:DateItem}, the default is inherited from +link{dateItem.startDate}.
    // Otherwise, the default is 10 years before today.
    // <P>
    // When opened from a +link{class:RelativeDateItem}, this property and
    // +link{DateChooser.endYear} are defaulted to null, and the year-picker shows
    // years surrounding the current year, according to
    // +link{DateChooser.startYearRange, startYearRange} and
    // +link{DateChooser.endYearRange, endYearRange}.
    // @visibility external
    //<
    startYear: (new Date().getFullYear() - 10),

    //> @attr DateChooser.endYear (int : 2025 : IR)
    // Latest year that may be selected.  If this chooser was opened by a
    // +link{class:DateItem}, the default is inherited from +link{dateItem.endDate}.
    // Otherwise, the default is 5 years after today.
    // <P>
    // When opened from a +link{class:RelativeDateItem}, this property and
    // +link{DateChooser.startYear} are defaulted to null, and the year-picker shows
    // years surrounding the current year, according to
    // +link{DateChooser.startYearRange, startYearRange} and
    // +link{DateChooser.endYearRange, endYearRange}.
    // @visibility external
    //<
    endYear: (new Date().getFullYear() + 5),

    //> @attr DateChooser.startYearRange (Integer : 30 : IR)
    // When +link{dateChooser.startYear, startYear} is unset, this is the years before today
    // that will be available for selection in the year menu.
    // @visibility external
    //<
    startYearRange: 30,

    //> @attr DateChooser.endYearRange (Integer : 10 : IR)
    // When +link{dateChooser.endYear, endYear} is unset, this is the years after today that
    // will be available for selection in the year menu.
    // @visibility external
    //<
    endYearRange: 10,

    //> @attr DateChooser.monthMenuStyle (CSSStyleName : "dateChooserMonthMenu" : IR)
    // Style for the pop-up year menu.
    // @visibility external
    //<
    monthMenuStyle:"dateChooserMonthMenu",

    //> @attr DateChooser.weekMenuStyle (CSSStyleName : "dateChooserWeekMenu" : IR)
    // Style for the pop-up week menu.
    // @visibility external
    //<
    weekMenuStyle:"dateChooserWeekMenu",


    //> @attr dateChooser.buttonLayoutControls (Array of String : (see below) : IR)
    // Array of members to show in the +link{dateChooser.buttonLayout, buttonLayout}.
    // <P>
    // The default value of <code>buttonLayoutControls</code> is an Array of Strings listing
    // the standard buttons in their default order:
    // <pre>
    //    buttonLayoutControls : ["todayButton", "cancelButton", "applyButton"]
    // </pre>
    // You can override <code>buttonLayoutControls</code> to change the order of the standard
    // buttons.  You can also omit standard buttons this way, although it's more efficient to
    // use the related "show" property if available (eg +link{showTodayButton}).
    // <P>
    // By embedding a Canvas directly in this list you can add arbitrary additional controls to
    // the buttonLayout.
    // <P>
    // Note that having added controls to buttonLayoutControls, you can still call APIs directly on
    // those controls to change their appearance, and you can also show() and hide() them if
    // they should not be shown in some circumstances.
    // <P>
    // Tip: custom controls need to set layoutAlign:"center" to appear vertically centered.
    //
    // @visibility external
    //<
    buttonLayoutControls : [ "todayButton", "cancelButton", "applyButton" ],


    // Today / Cancel Buttons
    // ---------------------------------------------------------------------------------------

    //> @attr DateChooser.showTodayButton (Boolean : true : IRW)
    // Determines whether the "Today" button will be displayed, allowing the user to select
    // the current date.
    // @visibility external
    //<
    showTodayButton:true,

    //> @attr DateChooser.showCancelButton (Boolean : false : IRW)
    // Determines whether the "Cancel" button will be displayed.
    // @visibility external
    //<
    showCancelButton:null,

    //> @attr DateChooser.showApplyButton (Boolean : null : IRW)
    // Determines whether the +link{applyButton} will be displayed.
    // @visibility external
    //<

    //> @attr DateChooser.todayButtonTitle  (String:"Today":IRW)
    // Title for "Today" button.
    // @group i18nMessages
    // @visibility external
    //<
    todayButtonTitle:"Today",

    //> @attr DateChooser.cancelButtonTitle  (String:"Cancel":IRW)
    // Title for the cancellation button.
    // @group i18nMessages
    // @visibility external
    //<
    cancelButtonTitle:"Cancel",

    //> @attr DateChooser.applyButtonTitle  (String:"Apply":IRW)
    // Title for the +link{dateChooser.applyButton, Apply} button.
    // @group i18nMessages
    // @visibility external
    //<
    applyButtonTitle:"Apply",

    //> @attr DateChooser.todayButtonHeight  (Integer :null:IRW)
    // If set specifies a fixed height for the Today and Cancel buttons.
    // @visibility external
    //<
    //todayButtonHeight:null,

    // Weekends
    // ---------------------------------------------------------------------------------------

    //> @attr DateChooser.disableWeekends (Boolean : false : IR)
    // Whether it should be valid to pick a weekend day.  If set to true, weekend days appear
    // in disabled style and cannot be picked.
    // <P>
    // Which days are considered weekends is controlled by +link{dateChooser.weekendDays} if
    // set or by +link{DateUtil.weekendDays} otherwise.
    //
    // @visibility external
    //<
    disableWeekends: false,

    //> @attr DateChooser.showWeekends (Boolean : true : IR)
    // Whether weekend days should be shown.  Which days are considered weekends is controlled
    // by +link{dateChooser.weekendDays} if set or by +link{DateUtil.weekendDays} otherwise.
    //
    // @visibility external
    //<
    showWeekends: true,

    //> @attr DateChooser.styleWeekends (Boolean : true : IR)
    // Whether weekend days should be styled differently from weekdays.  If false, suppresses
    // the custom +link{dateChooser.baseWeekendStyle} and +link{dateChooser.weekendHeaderStyle},
    // instead using the +link{dateChooser.baseWeekdayStyle} and
    // +link{dateChooser.weekendHeaderStyle}.
    //
    // @visibility external
    //<
    styleWeekends: true,

    //> @attr dateChooser.weekendDays (Array of int : null : IRW)
    // An array of integer day-numbers that should be considered to be weekend days by this
    // DateChooser instance.  If unset, defaults to the set of days indicated
    // +link{dateUtil.weekendDays, globally}.
    //
    // @group visibility
    // @visibility external
    //<
    getWeekendDays : function () {
        return this.weekendDays || isc.DateUtil.getWeekendDays();
    },


    //> @attr DateChooser.firstDayOfWeek  (int : 0 : IR)
    // Day of the week to show in the first column.  0=Sunday, 1=Monday, ..., 6=Saturday.  The
    // default value for this attribute is picked up from the current locale and can also be
    // altered system-wide with the +link{DateUtil.setFirstDayOfWeek, global setter}.
    //
    // @group i18nMessages, appearance
    // @visibility external
    //<

    firstDayOfWeek:0,

    // Initial value
    // ---------------------------------------------------------------------------------------

    year: isc.DateUtil.getAsDisplayDate(new Date()).getFullYear(),        // full year number
    month: isc.DateUtil.getAsDisplayDate(new Date()).getMonth(),        // 0-11
    chosenDate: isc.DateUtil.getAsDisplayDate(new Date()),    // JS date object -- defaults to today

    // Day Buttons styling
    // ---------------------------------------------------------------------------------------

    //> @attr DateChooser.baseButtonStyle (CSSStyleName : "dateChooserButton" : IRW)
    // Base CSS style applied to this picker's buttons. Will have "Over", "Selected" and "Down"
    // suffix appended as the user interacts with buttons.
    // <P>
    // See +link{group:cellStyleSuffixes} for details on how stateful suffixes are combined with the
    // base style to generate stateful cell styles in Grids.
    //
    // @visibility external
    //<
    baseButtonStyle:"dateChooserButton",

    //> @attr DateChooser.baseWeekdayStyle (CSSStyleName : "dateChooserWeekday" : IRW)
    // Base CSS style applied to weekdays. Will have "Over", "Selected" and "Down"
    // suffix appended as the user interacts with buttons.  Defaults to +link{baseButtonStyle}.
    // <P>
    // See +link{group:cellStyleSuffixes} for details on how stateful suffixes are combined with the
    // base style to generate stateful cell styles in Grids.
    // @visibility external
    //<
    baseWeekdayStyle: "dateChooserWeekday",

    //> @attr DateChooser.baseWeekendStyle (CSSStyleName : "dateChooserWeekend" : IRW)
    // Base CSS style applied to weekends. Will have "Over", "Selected" and "Down"
    // suffix appended as the user interacts with buttons.  Defaults to +link{baseWeekdayStyle}.
    // <P>
    // See +link{group:cellStyleSuffixes} for details on how stateful suffixes are combined with the
    // base style to generate stateful cell styles in Grids.
    // @visibility external
    //<
    baseWeekendStyle: "dateChooserWeekend",

    //> @attr DateChooser.baseFiscalYearStyle (CSSStyleName : "dateChooserFiscalYearCell" : IRW)
    // Base CSS style applied to cells in the +link{showFiscalYearChooser, fiscal year column}.
    // <P>
    // See +link{group:cellStyleSuffixes} for details on how stateful suffixes are combined with the
    // base style to generate stateful cell styles in Grids.
    // @visibility external
    //<
    baseFiscalYearStyle: "dateChooserFiscalYearCell",

    //> @attr DateChooser.fiscalYearHeaderStyle (CSSStyleName : null : IRW)
    // Base CSS style applied to the header of the
    // +link{showFiscalYearChooser, fiscal year column} in the
    // +link{dateChooser.dateGrid, calendar view}.
    // @visibility external
    //<

    //> @attr DateChooser.baseWeekStyle (CSSStyleName : "dateChooserWeekCell" : IRW)
    // Base CSS style applied to cells in the +link{showWeekChooser, fiscal week column}.
    // @visibility external
    //<
    baseWeekStyle: "dateChooserWeekCell",

    //> @attr DateChooser.weekHeaderStyle (CSSStyleName : null : IRW)
    // Base CSS style applied to the header of the
    // +link{showWeekChooser, fiscal or calendar week column} in the
    // +link{dateChooser.dateGrid, calendar view}.
    // @visibility external
    //<

    //> @attr DateChooser.disabledDates (Array of Date : null : IRW)
    // An array of Date instances that should be disabled if they appear in the calendar view.
    // @visibility external
    //<

    //> @attr DateChooser.disabledWeekdayStyle (CSSStyleName : "dateChooserDisabledWeekday" : IRW)
    // Base CSS style applied to weekday dates which have been +link{disabledDates, disabled}.
    // @visibility external
    //<
    disabledWeekdayStyle: "dateChooserDisabledWeekday",

    //> @attr DateChooser.disabledWeekendStyle (CSSStyleName : "dateChooserDisabledWeekend" : IRW)
    // Base CSS style applied to weekend dates which have been +link{disabledDates, disabled}.
    // @visibility external
    //<
    disabledWeekendStyle: "dateChooserDisabledWeekend",

    //> @attr DateChooser.selectedWeekStyle (CSSStyleName : "dateChooserSelectedWeek" : IRW)
    // CSS style applied to the Fiscal Year and Week columns for the currently selected week
    // (the one being displayed in the +link{dateChooser.showWeekChooser, week chooser}).
    // @visibility external
    //<
    selectedWeekStyle: "dateChooserSelectedWeek",

    //> @attr DateChooser.alternateWeekStyles (boolean:null:IRW)
    // Whether alternating weeks should be drawn in alternating styles. If enabled, the cell style
    // for alternate rows will have +link{alternateStyleSuffix} appended to it.
    // @visibility external
    //<

    //> @attr DateChooser.alternateStyleSuffix (String:"Dark":IRW)
    // The text appended to the style name when using +link{alternateWeekStyles}.
    // @visibility external
    //<
    alternateStyleSuffix:"Dark",

    //> @attr DateChooser.headerStyle (CSSStyleName : "dateChooserButtonDisabled" : IRW)
    // CSS style applied to the day-of-week headers. By default this applies to all days of the
    // week. To apply a separate style to weekend headers, set
    // +link{DateChooser.weekendHeaderStyle}
    //
    // @visibility external
    //<
    headerStyle:"dateChooserButtonDisabled",

    //> @attr DateChooser.weekendHeaderStyle (String:null:IRW)
    // Optional CSS style applied to the day-of-week headers for weekend days. If unset
    // +link{DateChooser.headerStyle} will be applied to both weekdays and weekend days.
    // @visibility external
    //<
    //weekendHeaderStyle:null,

    //> @attr DateChooser.baseNavButtonStyle (CSSStyleName : null : IRW)
    // CSS style to apply to navigation buttons and date display at the top of the
    // component. If null, the CSS style specified in +link{baseButtonStyle} is used.
    // @visibility external
    //<

    //> @attr DateChooser.navButtonConstructor (SCClassName : IButton : IRA)
    // Constructor for navigation buttons at the top of the component.
    // @visibility external
    //<
    navButtonConstructor: "IButton",

    //> @attr DateChooser.baseBottomButtonStyle (CSSStyleName : null : IRW)
    // CSS style to apply to the buttons at the bottom of the DateChooser ("Today" and
    // "Cancel").  If null, the CSS style specified in +link{baseButtonStyle} is used.
    // @visibility external
    //<



    useBackMask:true,

    canFocus:true,

    //> @attr DateChooser.useFirstDayOfFiscalWeek (Boolean : true : IRW)
    // When showing the +link{showFiscalYearChooser, fiscal year chooser}, should firstDayOfWeek
    // be defaulted to the same day as the fiscal start date?  If true and a fiscal year
    // starts on a Tuesday, the calendar will display Tuesday to Monday from left to right.
    // @visibility external
    //<
    useFirstDayOfFiscalWeek: true,

    //> @attr dateChooser.timeLayout (AutoChild HLayout : null : IR)
    // An +link{AutoChild} +link{HLayout}, rendered below the +link{class:DateGrid, date grid},
    // and showing the +link{dateChooser.timeItem, timeItem},
    // @visibility internal
    //<
    timeLayoutConstructor: "HLayout",
    timeLayoutDefaults: {
        width: 1,
        height: 1,
        overflow: "visible",
        // have this layout and it's children h-center
        layoutAlign: "center",
        align: "center",
        extraSpace: 1,
        autoDraw: false,
        visibility: "hidden"
    },
    timeFormDefaults: {
        _constructor: "DynamicForm",
        width: 1,
        overflow: "visible"
    },

    //> @attr dateChooser.closeOnEscapeKeypress (boolean : false : IR)
    // Should this dateChooser be dismissed if the user presses the Escape key?
    // @visibility external
    //<
    closeOnEscapeKeypress: false,

    //> @attr dateChooser.timeItem (AutoChild TimeItem : null : R)
    // +link{TimeItem} for editing the time portion of dates.  Visible by default for fields
    // of type "datetime" and can be controlled by setting +link{dateChooser.showTimeItem}.
    //
    // @visibility external
    //<

    //> @attr dateChooser.timeItemProperties (TimeItem Properties : null : IRA)
    // Custom properties to apply to the +link{dateChooser.timeItem,time field} used
    // for editing the time portion of the date.
    // @visibility external
    //<

    //> @attr DateChooser.showTimeItem  (Boolean : null : IRW)
    // Whether to show the +link{dateChooser.timeItem, time field} for editing the time portion
    // of the date.  When unset, the time field is shown automatically if the field type is
    // "datetime".  Note that the item's +link{dateChooser.showSecondItem, second chooser} is
    // not shown by default.
    // @visibility external
    //<
    timeItemDefaults: {
        name: "time",
        editorType: "TimeItem",
        useTextField: false,
        showTitle: false
    },

    //> @attr DateChooser.timeItemTitle  (String : "Time" : IRW)
    // Title for the +link{dateChooser.timeItem,time field}.
    // @group i18nMessages
    // @visibility external
    //<
    timeItemTitle: "Time",

    //> @attr DateChooser.use24HourTime (Boolean : true : IRW)
    // When showing the +link{showTimeItem, time field}, whether the
    // +link{class:TimeItem, TimeItem} should be set to use 24-hour time.  The default is true.
    // @visibility external
    //<
    use24HourTime: true,

    //> @attr DateChooser.fiscalYearFieldTitle  (String : "Year" : IRW)
    // Title for the +link{dateChooser.showFiscalYearChooser,fiscal year} field in the date grid.
    // @group i18nMessages
    // @visibility external
    //<
    fiscalYearFieldTitle: "Year",

    //> @attr DateChooser.weekFieldTitle  (String : "Wk" : IRW)
    // Title for the +link{dateChooser.showWeekChooser,week} field in the date grid.
    // @group i18nMessages
    // @visibility external
    //<
    weekFieldTitle: "Wk"

    //> @attr DateChooser.showSecondItem  (Boolean : null : IRW)
    // When showing the +link{dateChooser.timeItem, time field}, whether to show the "second"
    // picker.  When unset, the second field is not shown.
    // @visibility external
    //<

});

//!>Deferred
isc.DateChooser.addMethods({
    init : function () {
        if (this.showFullScreen()) {
            // make the chooser fill space and clip overflow
            this.width = "100%";
            this.height = "100%";
            this.overflow = "hidden";
        }
        return this.Super("init", arguments);
    },

    initWidget : function () {
        // store local [month/shortMonth]Names arrays
        this.monthNames = isc.DateUtil.getMonthNames();
        this.shortMonthNames = isc.DateUtil.getShortMonthNames();
        if (this.showFiscalYearChooser && this.useFirstDayOfFiscalWeek) {
            var fDate = Date.getFiscalStartDate(isc.DateUtil.getAsDisplayDate(new Date()), this.getFiscalCalendar());
            this.firstDayOfWeek = fDate.getDay();
        }

        // let Cancel and Apply buttons be created, if their "show" attributes are unset
        // and the showTimeItem is true
        if (this.showCancelButton == null) this.showCancelButton = !!this.showTimeItem;
        if (this.showApplyButton == null) this.showApplyButton = !!this.showTimeItem;

        this.Super("initWidget", arguments);

        if (this.headerHeight != null) this.navigationLayoutHeight = this.headerHeight;

        // create the various child widgets and cache their widths
        this.makeNavigationLayout();

        this.makeTimeLayout();

        this.makeButtonLayout();

        this.makeDateGrid();

        // use the widest child as the minBreadthMember
        if (this._navigationLayoutWidth > this._buttonLayoutWidth) {
            if (this._dateGridWidth > this._navigationLayoutWidth) {
                this.minBreadthMember = this.dateGrid;
            } else {
                this.minBreadthMember = this.navigationLayout;
            }
        } else {
            if (this._dateGridWidth > this._buttonLayoutWidth) {
                this.minBreadthMember = this.dateGrid;
            } else {
                this.minBreadthMember = this.buttonLayout;
            }
        }

        this.addMember(this.navigationLayout);

        // if not showing full-screen, add the grid now - for full-screen, this is done at draw()
        if (!this.showFullScreen()) this.addMember(this.dateGrid);

        if (this.showTimeItem == true) {
            this.addMember(this.timeLayout);
            this.timeLayout.setWidth("100%");
            this.timeLayout.show();
        }

        if (!this.allButtonsHidden()) {
            // only show the buttonLayout if there are visible buttons
            this.addMember(this.buttonLayout);
            this.buttonLayout.setWidth("100%");
            this.buttonLayout.show();
        }

        if (this.chosenDate) {
            if (this.showTimeItem) {
                this.chosenTime = isc.DateUtil.getLogicalTimeOnly(this.chosenDate);
            }
            this.chosenDate = isc.DateUtil.getLogicalDateOnly(this.chosenDate);
            this.year = this.chosenDate.getFullYear();
            this.month = this.chosenDate.getMonth();
            this.day = this.chosenDate.getDate();
        }
    },

    makeTimeLayout : function () {
        var item = isc.addProperties({},
                { title: this.timeItemTitle, use24HourTime: this.use24HourTime,
                    showSecondItem: !!this.showSecondItem
                },
                this.timeItemDefaults,
                this.timeItemProperties,
                { name: "time" }
        );
        this.timeForm = this.createAutoChild("timeForm", { top: -1000, autoDraw: false, items: [item] });
        this.timeLayout = this.createAutoChild("timeLayout", { top: -1000, autoDraw: false, members: [this.timeForm] });
        // render offscreen
        this.timeLayout.draw();
        this.timeLayout.show();
        // cache width and set minHeight
        this._timeLayoutWidth = this.timeForm.getVisibleWidth();
        this.timeLayout.minWidth = this._timeLayoutWidth;
        this.timeLayout.minHeight = this.timeForm.getVisibleHeight();
        // stretch the width
        this.timeLayout.clear();
        this.timeLayout.hide();
        this.timeLayout.setWidth("100%");
    },

    makeDateGrid : function () {
        var gridProps = {
            // pass in the chosenDate
            chosenDate: this.chosenDate,
            dayNameLength: this.dayNameLength,
            showFiscalYear: this.showFiscalYearChooser,
            fiscalYearFieldTitle: this.fiscalYearFieldTitle,
            showFiscalWeek: this.showFiscalYearChooser && this.showWeekChooser,
            showCalendarWeek: !this.showFiscalYearChooser && this.showWeekChooser,
            weekFieldTitle: this.weekFieldTitle,
            disabledDates: this.disabledDates,
            firstDayOfWeek: this.firstDayOfWeek,
            headerBaseStyle: this.headerStyle,
            weekendHeaderStyle: this.weekendHeaderStyle || this.headerStyle,
            baseFiscalYearStyle: this.baseFiscalYearStyle,
            fiscalYearHeaderStyle: this.fiscalYearHeaderStyle || this.baseFiscalYearStyle,
            baseWeekStyle: this.baseWeekStyle,
            weekHeaderStyle: this.weekHeaderStyle || this.baseWeekStyle,
            baseWeekdayStyle: this.baseWeekdayStyle || this.baseButtonStyle,
            baseWeekendStyle: this.baseWeekendStyle || this.baseWeekdayStyle || this.baseButtonStyle,
            alternateRecordStyles: this.alternateWeekStyles,
            disabledWeekdayStyle: this.disabledWeekdayStyle,
            disabledWeekendStyle: this.disabledWeekendStyle,
            selectedWeekStyle: this.selectedWeekStyle,
            fiscalCalendar: this.getFiscalCalendar(),
            showWeekends: this.showWeekends,
            styleWeekends: this.styleWeekends,
            disableWeekends: this.disableWeekends,
            weekendDays: this.getWeekendDays(),
            locatorParent: this,
            height: "*",
            startDate: this.getData(),
            top: -1000,
            autoDraw: false,
            align: "center"
        };
        this.dateGrid = this.createAutoChild("dateGrid", gridProps);
        this.dateGrid.draw();
        this.dateGrid.show();
        this._dateGridWidth = this.dateGrid.getVisibleWidth();
        this.dateGridHeight = this.dateGrid.getVisibleHeight();

        // set the minWidth/Height on the dateGrid to it's current size
        this.dateGrid.minWidth = this._dateGridWidth;
        this.dateGrid.minHeight = this.dateGridHeight;

        // set overflow:"hidden" on the grid
        this.dateGrid.setOverflow("hidden");

        // stretch the grid-width
        this.dateGrid.clear();
        this.dateGrid.setWidth("100%");
        this.dateGrid.setHeight("*");
    },

    makeNavigationLayout : function () {
        if (this.showNavigationLayout != false) {
            this.navigationLayout = this.createAutoChild("navigationLayout", {
                top: -1000,
                autoDraw: false,
                width: 1, height: 1, overflow: "visible"
            }, this.navigationLayoutConstructor);

            var members = [];

            if (this.showFiscalYearChooser) {
                this.fiscalYearChooserButton = this.createAutoChild("fiscalYearChooserButton", {
                    baseStyle:(this.baseNavButtonStyle || this.baseButtonStyle),
                    title: this.chosenDate.getFiscalYear(this.getFiscalCalendar()).fiscalYear
                },
                this.navButtonConstructor);
                members.add(this.fiscalYearChooserButton);
            }

            if (this.showWeekChooser) {
                this.weekChooserButton = this.createAutoChild("weekChooserButton", {
                    baseStyle:(this.baseNavButtonStyle || this.baseButtonStyle),
                    title: this.showFiscalYearChooser ?
                            this.chosenDate.getFiscalWeek(this.getFiscalCalendar()) :
                            this.chosenDate.getWeek(this.firstDayOfWeek)
                },
                this.navButtonConstructor);
                members.add(this.weekChooserButton);
            }

            if (this.showYearButtons) {
                this.previousYearButton = this.createAutoChild("previousYearButton", {
                    baseStyle:(this.baseNavButtonStyle || this.baseButtonStyle),
                    title: this.getPreviousYearIconHTML(),
                    ariaLabel : this.previousYearButtonAriaLabel

                },
                this.navButtonConstructor);
                members.add(this.previousYearButton);
            }
            if (this.showMonthButtons != false) {
                this.previousMonthButton = this.createAutoChild("previousMonthButton", {
                    baseStyle:(this.baseNavButtonStyle || this.baseButtonStyle),
                    title: this.getPreviousMonthIconHTML(),
                    ariaLabel : this.previousMonthButtonAriaLabel

                },
                this.navButtonConstructor);
                members.add(this.previousMonthButton);
            }
            if (this.showMonthChooser != false) {
                var width = this.monthChooserButtonDefaults.width,
                    minWidth = this.monthChooserButtonDefaults.minWidth,
                    autoWidth = this._getMonthChooserButtonWidth();
                this.monthChooserButton = this.createAutoChild("monthChooserButton", isc.addProperties({},
                    this.monthChooserButtonDefaults,
                    {
                        baseStyle:(this.baseNavButtonStyle || this.baseButtonStyle),
                        title: this.chosenDate.getShortMonthName(),
                        width: width || autoWidth,
                        minWidth: minWidth || width || autoWidth
                    },
                    this.monthChooserButtonProperties),
                this.navButtonConstructor);
                members.add(this.monthChooserButton);
            }
            if (this.showYearChooser != false) {
                var width = this.yearChooserButtonDefaults.width,
                    minWidth = this.yearChooserButtonDefaults.minWidth,
                    autoWidth = this._getYearChooserButtonWidth();
                this.yearChooserButton = this.createAutoChild("yearChooserButton", isc.addProperties({},
                    this.yearChooserButtonDefaults,
                    {
                        baseStyle:(this.baseNavButtonStyle || this.baseButtonStyle),
                        title: this.chosenDate.getFullYear(),
                        width: width || autoWidth,
                        minWidth: minWidth || width || autoWidth
                    },
                    this.yearChooserButtonProperties),
                this.navButtonConstructor);
                members.add(this.yearChooserButton);
            }
            if (this.showMonthButtons) {
                this.nextMonthButton = this.createAutoChild("nextMonthButton", {
                    baseStyle:(this.baseNavButtonStyle || this.baseButtonStyle),
                    title: this.getNextMonthIconHTML(),
                    ariaLabel : this.nextMonthButtonAriaLabel
                },
                this.navButtonConstructor);
                members.add(this.nextMonthButton);
            }
            if (this.showYearButtons) {
                this.nextYearButton = this.createAutoChild("nextYearButton", {
                    baseStyle:(this.baseNavButtonStyle || this.baseButtonStyle),
                    title: this.getNextYearIconHTML(),
                    ariaLabel : this.nextYearButtonAriaLabel
                },
                this.navButtonConstructor);
                members.add(this.nextYearButton);
            }

            this.navigationLayout.addMembers(members);
            this.navigationLayout.draw();
            this.navigationLayout.show();

            // cache the visibleWidth
            this._navigationLayoutWidth = this.navigationLayout.getVisibleWidth();

            // cache the visibleHeight and set the minHeight
            this.navigationLayoutHeight = this.navigationLayout.getVisibleHeight();
            this.navigationLayout.minHeight = this.navigationLayoutHeight;
            this.navigationLayout.minWidth = this._navigationLayoutWidth;

            // stretch the width
            this.navigationLayout.clear();
            this.navigationLayout.setWidth("100%");
        }
    },

    showControlPropertyMap:{
        todayButton:"showTodayButton",
        cancelButton:"showCancelButton",
        applyButton:"showApplyButton"
    },
    _$body:"body", _$header:"header",
    allButtonsHidden : function () {
        return !this.showTodayButton && !this.showCancelButton && !this.showApplyButton;
    },
    shouldShowButtonLayoutControl : function (component) {
        var property = this.showControlPropertyMap[component];
        if (property == null) {
            this.showControlPropertyMap[component] = property =
                    "show" + component.substring(0,1).toUpperCase + component.substring(1);
        }
        return this[property] != false;
    },
    makeButtonLayout : function (props) {
        //if (this.allButtonsHidden()) return;

        var props = { baseStyle: this.baseBottomButtonStyle || this.baseButtonStyle };
        if (this.todayButtonHeight != null) props.height = this.todayButtonHeight;

        this.todayButtonDefaults.title = this.todayButtonTitle;
        if (props.height) this.todayButtonDefaults.height = props.height;

        this.cancelButtonDefaults.title = this.cancelButtonTitle;
        if (props.height) this.cancelButtonDefaults.height = props.height;

        this.applyButtonDefaults.title = this.applyButtonTitle;
        if (props.height) this.applyButtonDefaults.height = props.height;

        var members = [];

        for (var i = 0; i < this.buttonLayoutControls.length; i++) {
            var component = this.buttonLayoutControls[i],
                liveComponent = null
            ;

            // allow arbitrary canvii to be shoehorned into the grid.
            if (isc.isA.Canvas(component)) {
                liveComponent = component;

            } else if (isc.isA.String(component)) {
                //if (!this.shouldShowButtonLayoutControl(component)) continue;
                var visibility = "visible";
                if (!this.shouldShowButtonLayoutControl(component)) visibility = "hidden";
                // this is one of the builtin buttons
                liveComponent = this[component] = this.createAutoChild(component,
                    isc.addProperties({}, props, { visibility: visibility}), this.bottomButtonConstructor);
                //liveComponent = this.addAutoChild(component, props, this.bottomButtonConstructor);
            }
            // Handle being passed anything you could pass to "addChild" (EG "autoChild:foo") by
            // explicitly calling 'createCanvas'.
            if (component != null && liveComponent == null) {
                liveComponent = this.createCanvas(component);
            }
            members.add(liveComponent);
        }

        this.buttonLayout = this.createAutoChild("buttonLayout", {
            top: -1000,
            autoDraw: false,
            members: members
        }, this.buttonLayoutConstructor);
        this.buttonLayout.draw();
        this.buttonLayout.show();
        this._buttonLayoutWidth = this.buttonLayout.getVisibleWidth();
        this.buttonLayoutHeight = this.buttonLayout.getVisibleHeight();
        this.buttonLayout.minWidth = this._buttonLayoutWidth;
        this.buttonLayout.minHeight = this.buttonLayoutHeight;
        this.buttonLayout.clear();
        this.buttonLayout.hide();
        //this.buttonLayout.width = "100%";
    },

    getUsedHeight : function () {
        var usedHeight = 10;
        if (this.navigationLayout && this.navigationLayout.isVisible()) {
            usedHeight += this.navigationLayout.getVisibleHeight();
        }
        if (this.showTimeItem) {
            usedHeight += this._timeLayoutHeight;
        }
        usedHeight += this._buttonLayoutHeight;

        // include the size of the top and bottom borders
        var pxOffset = (this.border || "").indexOf("px");
        if (pxOffset >= 0) {
            var borderSize = parseInt(this.border.substring(0, pxOffset+1));
            usedHeight += (borderSize * 2);
        }
        return usedHeight;
    },
    draw : function () {
        this.Super("draw", arguments);

        if (this.dateGrid && !this.hasMember(this.dateGrid)) {
            this.dateGrid.clear();
            if (this.showFullScreen()) {
                this.dateGrid.setOverflow("hidden");
                this.dateGrid.setHeight("*")
            }
            this.addMember(this.dateGrid, 1);
        }

        this.updateUI();
    },

    getTimeItem : function () {
        if (this.showTimeItem) return this.timeForm.getItem(0);
    },
    recreateTimeItem : function (value) {
        var item = isc.addProperties({}, { title: this.timeItemTitle,
                    use24HourTime: this.use24HourTime, showSecondItem: !!this.showSecondItem },
                this.timeItemDefaults,
                this.timeItemProperties,
                { value: value }
        );
        this.timeForm.setItems([item]);
    },

    resized : function () {
        // if the chooser was just resized, call placeNear() to make sure it remains on-screen
        // - placeNear() will no-op if there's nothing to do
        this.placeNear(this.getPageLeft(), this.getPageTop());
    },

    handleKeyPress : function () {
        var returnVal = this.Super("handleKeyPress", arguments);
        if (returnVal != false) {
            if ((this.closeOnEscapeKeypress) && ("Escape" == isc.EH.getKey())) {
                this.cancelClick();
            }
        }
    },

    getPreviousYearIconHTML : function () {
        var prevYearIconHTML,
            displayDate = new Date(this.year, this.month, 1),
            disableNextYear = displayDate.getFullYear() == 9999
        ;
        if (this.showDoubleYearIcon) {
            var monthIconHTML = this.getPreviousMonthIconHTML();
            prevYearIconHTML = disableNextYear ? "&nbsp;" :
                   "<NOBR>"+ monthIconHTML + monthIconHTML + "<\/NOBR>";
        } else {
            var icon = this.isRTL() ?
                    this.prevYearIconRTL || this.nextYearIcon : this.prevYearIcon;
            prevYearIconHTML = disableNextYear ? "&nbsp;" :
                        this.imgHTML(icon, this.prevYearIconWidth,
                                         this.prevYearIconHeight);
        }

        return prevYearIconHTML;
    },

    getPreviousMonthIconHTML : function () {
        var icon = this.isRTL() ?
                this.prevMonthIconRTL || this.nextMonthIcon : this.prevMonthIcon,
            monthIconHTML = this.imgHTML(icon, this.prevMonthIconWidth,
                                                 this.prevMonthIconHeight);
        return monthIconHTML;
    },

    getNextMonthIconHTML : function () {
        var icon = this.isRTL() ?
                this.nextMonthIconRTL || this.prevMonthIcon : this.nextMonthIcon,
            monthIconHTML = this.imgHTML(icon, this.nextMonthIconWidth,
                                                 this.nextMonthIconHeight);
        return monthIconHTML;
    },

    getNextYearIconHTML : function () {
        var nextYearIconHTML,
            displayDate = new Date(this.year, this.month, 1),
            disableNextYear = displayDate.getFullYear() == 9999
        ;
        if (this.showDoubleYearIcon) {
            var monthIconHTML = this.getNextMonthIconHTML();
            nextYearIconHTML = disableNextYear ? "&nbsp;" :
                               "<NOBR>"+ monthIconHTML + monthIconHTML + "<\/NOBR>";
        } else {
            var icon = this.isRTL() ?
                    this.nextYearIconRTL || this.prevYearIcon : this.nextYearIcon;
            nextYearIconHTML = disableNextYear ? "&nbsp;" :
                                    this.imgHTML(icon,
                                                 this.nextYearIconWidth,
                                                 this.nextYearIconHeight);
        }

        return nextYearIconHTML;
    },

    // Override show() to show the clickMask if autoClose is true
    // Note: If we're showing this date chooser in a separate window, this is unnecessary, as the
    // user will be unable to click on any part of the window that isn't covered by the date-chooser
    // but will do no harm.
    show : function () {
        var returnVal = this.Super("show", arguments);


        if (this.autoClose) {
            // pass this dateChooser as an unmasked widget to showClickMask because
            // when the dateChooser is shown from a modal window, the dateChooser
            // ends up being masked by its own clickmask for some unknown reason.
            this.showClickMask(this.getID()+".close();", true, this);
            this.bringToFront();
        }
    },

    // picker interface

    //> @method DateChooser.setData()
    // Set the picker to show the given date.
    //
    // @param date (Date) new value
    // @visibility external
    //<
    setData : function (data, autoShowTimeItem) {
        if (!isc.isA.Date(data)) data = new Date();

        var type = "datetime";
        if (this.callingFormItem) {
            type = this.callingFormItem.getType();
        }

        var dateOnly = isc.DateUtil.getLogicalDateOnly(data),
            timeOnly = isc.DateUtil.getLogicalTimeOnly(data)
        ;

        this.year = dateOnly.getFullYear();
        this.month = dateOnly.getMonth();
        this.day = dateOnly.getDate();

        this.chosenDate = dateOnly;
        this.chosenTime = timeOnly;

        if (autoShowTimeItem) {
            // if autoShowTimeItem is true, always show the timeItem for non-logicalDate data
            if (data.logicalDate || !isc.SimpleType.inheritsFrom(type, "datetime")) this.showTimeItem = false;
            else this.showTimeItem = true;
        }
        // set the timeItem's value, if it's there
        var timeItem = this.getTimeItem();
        if (timeItem) timeItem.setValue(this.chosenTime);

        this.updateUI();
    },

    updateGridData : function (weekNum) {
        if (!this.dateGrid) return;

        var date = isc.DateUtil.createLogicalDate(this.year, this.month, 1);

        var fy = isc.DateUtil._getFiscalYearObjectForDate(date),
            fiscalStart = fy.startDate
        ;

        this.dateGrid.showWeekends = this.showWeekends;

        this.dateGrid.showFiscalYear = this.showFiscalYearChooser;
        this.dateGrid.showFiscalWeek = this.showFiscalYearChooser && this.showWeekChooser;
        this.dateGrid.showCalendarWeek = !this.showFiscalYearChooser && this.showWeekChooser;

        if (this.showFiscalYearChooser) {
            if (this.useFirstDayOfFiscalWeek) {
                // if using fiscal startDate.getDay() as firstDayOfWeek, we need to use the
                // fiscalYear in which the startDate exists, not the one in which the start of
                // the month exists
                //var nfy = isc.DateUtil.getFiscalYear(fy.fiscalYear + 1);
                var nfy = isc.DateUtil.getFiscalYear(fy.fiscalYear);
                if (nfy.year < fy.fiscalYear) {
                    nfy = isc.DateUtil.getFiscalYear(nfy.fiscalYear + 1);
                }
                this.dateGrid.firstDayOfWeek = this.firstDayOfWeek = nfy.startDate.getDay();
            }
        }
        // pass the new year and month, and the chosenDate, to grid.refreshUI() - this will
        // call setChosenDate() if the passed chosenDate has changed since the last run, or
        // showMonth() otherwise, if year/month have changed
        // also pass on the weekNum param, which is passed to this method by a cellClick
        // on the weekMenu, via updateUI(), and used by DateGrid to select the week the
        // user chose, rather than the first visible week
        this.dateGrid.refreshUI(this.year, this.month, this.chosenDate, weekNum);
    },

    //> @method DateChooser.getData()
    // Get the current value of the picker.
    // <P>
    // See +link{dataChanged()} for how to respond to the user picking a date.
    //
    // @return (Date) current date
    // @visibility external
    //<

    getData : function () {
        var date = this.chosenDate.duplicate();
        if (this.showTimeItem) {
            date = isc.DateUtil.combineLogicalDateAndTime(date, this.chosenTime);
        }
        return date;
    },

    redraw : function () {
        this.Super("redraw", arguments);
        this.updateUI();
    },

    //> @attr DateChooser.dayNameLength (number : 2 : IR)
    // How long (how many characters) should be day names be. May be 1, 2 or 3 characters.
    // @visibility external
    //<
    dayNameLength:2,

    getDayNames : function () {
        if (isc.DateChooser._dayNames == null) {
            // Don't hard-code day-names -- we need them to be localizeable
            // isc.DateChooser._dayNames = ["Su", "Mo","Tu", "We", "Th", "Fr", "Sa"]
            // Support 1, 2 or 3 chars
            isc.DateChooser._dayNames = [isc.DateUtil.getShortDayNames(1),
                                         isc.DateUtil.getShortDayNames(2),
                                         isc.DateUtil.getShortDayNames(3)];
        }
        return isc.DateChooser._dayNames[this.dayNameLength-1];
    },

    getDayCellButtonHTML : function (date, style, state) {
        // null date == Special case for dates beyond 9999
        // This limit is enforced due to dates greater than 9999 causing a browser crash in IE
        // - also our parsing logic assumes a 4 digit date
        if (date == null)
            return this.getCellButtonHTML("&nbsp;", null, style, false, false, isc.Canvas.CENTER);


        var selected = this.chosenDate &&
                       (isc.DateUtil.compareLogicalDates(date,this.chosenDate) == 0),
            disabled = (date.getMonth() != this.month);

        var partEvent = "dateFromId",
            id = date.getFullYear() + "_" + date.getMonth() + "_" + date.getDate();

        // check for weekends
        if (this.disableWeekends && this.getWeekendDays().contains(date.getDay())) {
            disabled = true;
            partEvent = null;
        }
        return this.getCellButtonHTML(date.getDate(), style, selected, disabled,
                                      isc.Canvas.CENTER, null, partEvent, id);
    },

    dateIsSelected : function (date) {
        return null
    },

    showPrevMonth : function () {
        if (--this.month == -1) {
            this.month = 11;
            this.year--;
        }
        this.updateUI();
    },

    showNextMonth : function () {
        if (++this.month == 12) {
            this.month = 0;
            this.year++;
        }
        this.updateUI();
    },

    updateHeader : function (weekNum, date) {
        if (!this.showNavigationLayout && this.navigationLayout) {
            this.navigationLayout.hide();
        } else if (this.showNavigationLayout) {
            // construct a logical date from the stored parts, if no date passed
            date = date || isc.DateUtil.createLogicalDate(this.year, this.month, this.day);

            if (!this.navigationLayout.isVisible()) this.navigationLayout.show();

            var members = this.navigationLayout.members;
            if (this.showWeekChooser) {
                // get the weekNum from the dateGrid, where it might be defaulted to the first
                // week, if not selecting a specific week
                this.updateWeekChooser();

                if (!this.weekChooserButton.isVisible()) this.weekChooserButton.show();
            } else if (this.weekChooserButton) {
                if (this.weekChooserButton.isVisible()) this.weekChooserButton.hide();
            }

            if (this.showFiscalYearChooser) {
                this.fiscalYearChooserButton.setTitle("" + date.getFiscalYear(this.getFiscalCalendar()).fiscalYear);
                if (!this.fiscalYearChooserButton.isVisible()) this.fiscalYearChooserButton.show();
            } else if (this.fiscalYearChooserButton) {
                if (this.fiscalYearChooserButton.isVisible()) this.fiscalYearChooserButton.hide();
            }

            if (this.showFullMonthInHeader) {
                this.monthChooserButton.setTitle(this.monthNames[this.month]);
            } else {
                this.monthChooserButton.setTitle(this.shortMonthNames[this.month]);
            }

            this.yearChooserButton.setTitle("" + this.getHeaderYearTitle(this.year));
            this.yearChooserButton.redraw();

            var isFirstYear = this.startYear && this.startYear == this.year,
                isLastYear = this.endYear && this.endYear == this.year
            ;
            this.previousYearButton.setDisabled(isFirstYear);
            this.previousMonthButton.setDisabled(isFirstYear && this.month == 0);
            this.nextMonthButton.setDisabled(isLastYear && this.month == 11);
            this.nextYearButton.setDisabled(isLastYear);
        }
    },
    showFullScreen : function () {
        return isc.Browser.isHandset;
    },

    updateUI : function (weekNum) {
        // update month/year button titles
        var date = new Date(this.year, this.month, this.day);

        if (date.getMonth() > this.month) date = isc.DateUtil.getEndOf(new Date(this.year, this.month, 1), "M", true);

        if (!this.showTimeItem) {
            if (this.members.contains(this.timeLayout)) {
                this.removeMember(this.timeLayout);
                this.timeLayout.clear();
            }
        } else if (this.showTimeItem) {
            this.recreateTimeItem(this.chosenTime);
            this.addMember(this.timeLayout, this.members.length-1);
            this.timeLayout.show();
        }

        this.updateButtonLayout();

        this.updateGridData(weekNum);
        this.updateHeader();
    },

    updateButtonLayout : function () {
        if (this.todayButton) {
            if (this.showTodayButton) {
                if (!this.todayButton.isVisible()) this.todayButton.visibility = "visible";
                this.todayButton.show();
            } else if (this.todayButton.isVisible()) {
                this.todayButton.hide();
            }
        }
        if (this.cancelButton) {
            if (this.showCancelButton) {
                if (!this.cancelButton.isVisible()) this.cancelButton.visibility = "visible";
                this.cancelButton.show();
            } else if (this.cancelButton.isVisible()) {
                this.cancelButton.hide();
            }
        }
        if (this.applyButton) {
            if (this.showApplyButton) {
                if (!this.applyButton.isVisible()) this.applyButton.visibility = "visible";
                this.applyButton.show();
            } else if (this.applyButton.isVisible()) {
                this.applyButton.hide();
            }
        }

        if (this.buttonLayout) {
            if (this.allButtonsHidden()) this.buttonLayout.hide();
            else {
                if (!this.buttonLayout.isVisible()) this.buttonLayout.show();

                // hide the border, it's above the timeLayout
                if (this.showTimeItem) this.buttonLayout.setBorder("0px");
                // clear the border, so it falls back to the skin CSS
                else this.buttonLayout.setBorder(null);
            }
         }
    },

    updateWeekChooser : function () {
        if (this.weekChooserButton) {
            this.weekChooserButton.setTitle("" + (this.dateGrid && this.dateGrid.getSelectedWeek()));
        }
    },

    showMonth : function (monthNum) {
        this.month = monthNum;
        if (this.monthMenu) this.monthMenu.hide();
        this.bringToFront();
        this.updateUI();
    },


    //> @method DateChooser.getFiscalCalendar()
    // Returns the +link{FiscalCalendar} object that will be used by this DateChooser.
    //
    // @return (FiscalCalendar) the fiscal calendar for this chooser, if set, or the global
    //            one otherwise
    // @visibility external
    //<
    getFiscalCalendar : function () {
        return this.fiscalCalendar || isc.DateUtil.getFiscalCalendar();
    },

    //> @method DateChooser.setFiscalCalendar()
    // Sets the +link{FiscalCalendar} object that will be used by this DateChooser.  If unset,
    // the +link{DateUtil.getFiscalCalendar, global fiscal calendar} is used.
    //
    // @param [fiscalCalendar] (FiscalCalendar) the fiscal calendar for this chooser
    // @visibility external
    //<
    setFiscalCalendar : function (fiscalCalendar) {
        this.fiscalCalendar = fiscalCalendar;
    },

    showWeek : function (weekNum) {
        var date;
        if (this.showFiscalYearChooser) {
            var displayDate = isc.DateUtil.createLogicalDate(this.year, this.month,
                                                             this.chosenDate.getDate());
            var cal = this.getFiscalCalendar(),
                fiscalStart = Date.getFiscalStartDate(displayDate)
            ;
            date = new Date(fiscalStart.getFullYear(), cal.defaultMonth, cal.defaultDate + (7 * weekNum))
        } else {
            date = new Date(this.year, 0, 1 + (7 * weekNum));
        }

        this.year = date.getFullYear();
        this.month = date.getMonth();
        if (this.weekMenu) this.weekMenu.hide();
        this.bringToFront();
        this.updateUI(weekNum);
    },

    monthMenuFormat: "MMM",
    getMonthText : function (date) {
        // third param here is "customTimezone" - pass false to prevent the passed logical-date
        // from being potentially altered in situations where the browser timezone vs display
        // timezone is larger than 12 hours
        var result = isc.DateUtil.format(date, this.monthMenuFormat, false);
        return result;
    },

    _getMonthChooserTitles : function () {
        var date = isc.Date.createLogicalDate(2001,0,1);
        var arr = [];
        for (var i = 0; i < 12; i++) {
            date.setMonth(i);
            arr.add(this.getMonthText(date));
        }
        return arr;
    },
    _getMonthChooserButtonWidth : function () {
        var arr = this._getMonthChooserTitles(),
            style = (this.baseNavButtonStyle || this.baseButtonStyle) + "Over",
            extraWidth = isc.Element._getHBorderPad(style) * 2,
            maxWidth = isc.Canvas.measureContent("<span style='white-space:nowrap'>"
                         + arr.join("<br>") + "</span>", style) + extraWidth
        ;
        this._monthChooserButtonWidth =  maxWidth;
        return this._monthChooserButtonWidth;
    },

    _getYearChooserButtonWidth : function () {
        var arr = [];
        var start = this.startYear || (this.year - this.startYearRange),
            end = this.endYear || (this.year + this.endYearRange)

        for (var i = start; i <= end; i++) {
            arr.add("" + this.getYearTitle(i));
        }
        var style = (this.baseNavButtonStyle || this.baseButtonStyle) + "Over",
            extraWidth = isc.Element._getHBorderPad(style) * 2,
            maxWidth = isc.Canvas.measureContent(arr.join("<br>"), style) + extraWidth
        ;
        this._yearChooserButtonWidth = maxWidth;
        return this._yearChooserButtonWidth;
    },

    // Menus (monthMenu, dayMenu, yearMenu)


    useButtonTable:false,
    shouldUseButtonTable : function () {
        if (this.useButtonTable != null) return this.useButtonTable;
        // We really want keyboard focus in screenReader mode
        return !isc.screenReader;
    },

    monthMenuConstructor:"DateChooserMenuGrid",
    monthMenuDefaults:{
        cellClick : function (record, rowNum, colNum) {
            if (!record) return;
            this.creator.showMonth(record.eventId);
        }
    },

    showMonthMenu : function () {
        if (!this.monthMenu) {
            // create the menu items using the date.getShortMonthName() for internationalization
            var monthItems = [],
                date = isc.DateUtil.createLogicalDate(2001,0,1);
            for (var i = 0; i < 12; i++) {
                if ((i)%3 == 0) monthItems.add([]);
                date.setMonth(i);
                monthItems[monthItems.length-1].add(
                                    {    contents:this.getMonthText(date),
                                        eventPart: "showMonth",
                                        eventId: i
                                    }
                );
            }
            var monthMenuConfig = {
                styleName:this.monthMenuStyle,
                left:this.monthChooserButton.getPageLeft()+5,
                top:this.getPageTop()+this.navigationLayoutHeight,
                width:Math.min(this.getVisibleWidth(), 120),
                height:Math.min(this.getVisibleHeight()-this.navigationLayoutHeight, 80),
                items:monthItems,
                visibility:isc.Canvas.HIDDEN,
                baseButtonStyle:this.baseButtonStyle,
                dateChooser: this
            };
            if (this.shouldUseButtonTable()) {
                this.monthMenu = isc.MonthChooser.newInstance(monthMenuConfig);
            } else {
                this.monthMenu = this.createAutoChild("monthMenu", monthMenuConfig)
            }
            // (autoDraw is true, so it is drawn, with visibility hidden at this point)
            var left = this.monthChooserButton.getPageLeft() -
                        ((this.monthMenu.getWidth() - this.monthChooserButton.getWidth()) /2);
            this.monthMenu.placeNear(Math.max(left, 0));
        } else {
            // L, T, W, H
            var top = this.getPageTop()+this.navigationLayoutHeight,
                width = Math.min(this.getVisibleWidth(), 120),
                height = Math.min(this.getVisibleHeight()-this.navigationLayoutHeight, 80),
                buttonWidth = this.monthChooserButton.getWidth(),
                left = this.monthChooserButton.getPageLeft() - ((width - buttonWidth)/2)
            ;
            this.monthMenu.resizeTo(width, height);
            this.monthMenu.placeNear(Math.max(left, 0), top);
        }

        // We show the month menu modally.  This means if the user clicks outside it, we
        // will not allow the click to carry on down, so it will hide the month menu (and then
        // dismiss the monthMenu's click mask), but won't fire the click action on the
        // DateChooser's click mask and hide the entire date chooser.
        // As with all modal clickMasks, for us to float the month menu above it, we need the
        // month menu to be a top-level element (which is how it's currently implemented)
        this.monthMenu.showModal();
    },

    weekMenuConstructor:"DateChooserMenuGrid",
    weekMenuDefaults:{
        cellClick : function (record, rowNum, colNum) {
            if (!record) return;
            this.creator.showWeek(record.eventId);
        }
    },

    showWeekMenu : function () {
        if (!this.weekMenu) {
            // create the menu items using the date.getShortMonthName() for internationalization
            var weekItems = [[]],
                date = isc.DateUtil.createLogicalDate(2001,0,1);
            for (var i = 1; i < 53; i++) {
                weekItems[weekItems.length-1].add(
                                    {    contents:"" + i,
                                        eventPart: "showWeek",
                                        eventId: i
                                    }
                    );
                if ((i)%7 == 0) weekItems.add([]);
            }

            var weekMenuConfig = {
                styleName:this.weekMenuStyle,
                left:this.weekChooserButton.getPageLeft()+5,
                top:this.getPageTop()+this.navigationLayoutHeight,
                width:Math.min(this.getVisibleWidth(), 120),
                height:Math.min(this.getVisibleHeight()-this.navigationLayoutHeight, 80),
                items:weekItems,
                visibility:isc.Canvas.HIDDEN,
                baseButtonStyle:this.baseButtonStyle,
                dateChooser: this
            };

            if (this.shouldUseButtonTable()) {
                this.weekMenu = isc.WeekChooser.newInstance(weekMenuConfig);
            } else {
                this.weekMenu = this.createAutoChild("weekMenu", weekMenuConfig)
            }


            // (autoDraw is true, so it is drawn, with visibility hidden at this point)
            var left = this.weekChooserButton.getPageLeft() -
                        ((this.weekMenu.getWidth() - this.weekChooserButton.getWidth()) /2);
            this.weekMenu.setPageLeft(Math.max(left, 0));

        } else {
            // L, T, W, H
            var top = this.getPageTop()+this.navigationLayoutHeight,
                width = Math.min(this.getVisibleWidth(), 120),
                height = Math.min(this.getVisibleHeight()-this.navigationLayoutHeight, 80),
                buttonWidth = this.weekChooserButton.getWidth(),
                left = this.weekChooserButton.getPageLeft() - ((width - buttonWidth)/2)
            ;
            this.weekMenu.setPageRect(Math.max(left, 0), top, width, height);
        }

        this.weekMenu.showModal();
    },

    showPrevYear : function () {
        this.year--;
        this.updateUI();
    },

    showNextYear : function () {
        if (!this.endYear || this.year < this.endYear) {
            this.year++;
            this.updateUI();
        }
    },

    showYear : function (yearNum) {
        if ((this.startYear && yearNum < this.startYear) ||
            (this.endYear && yearNum > this.endYear)) return;
        this.year = yearNum;
        if (this.yearMenu) this.yearMenu.hide();
        this.updateUI();
    },

    showFiscalYear : function (yearNum) {
        var f = isc.DateUtil.getFiscalYear(yearNum, this.getFiscalCalendar());

        this.year = f.year;
        this.month = f.month;
        if (this.yearMenu) this.yearMenu.hide();
        this.updateUI();
    },

    showFiscalYearMenu : function () {
        this.showYearMenu(true);
    },

    yearMenuConstructor:"DateChooserMenuGrid",
    yearMenuDefaults:{
        cellClick : function (record, rowNum, colNum) {
            if (!record) return;
            if (this.fiscal) {
                this.creator.showFiscalYear(record.eventId);
            } else {
                this.creator.showYear(record.eventId);
            }
        }
    },


    showYearMenu : function (fiscal) {
        var component = !fiscal ? this.yearChooserButton : this.fiscalYearChooserButton;

        var start = this.startYear || (this.year - this.startYearRange),
            end = this.endYear || (this.year + this.endYearRange),
            yearDiff = (end - start)
        ;

        // get a colCount appropriate for the yearDiff
        var colCount = Math.round(Math.sqrt(yearDiff));

        var yearItems = [];
        for (var i = 0; i <= (end-start); i++) {
            if ((i)%colCount == 0) yearItems.add([]);
            var year = i+start;
            yearItems[yearItems.length-1].add({
                contents: this.getYearTitle(year),
                eventPart: "showYear",
                eventId: year
            });
        }

        if (!this.yearMenu) {
            var yearMenuConfig = {
                styleName:this.yearMenuStyle,
                top:this.getPageTop()+this.navigationLayoutHeight,
                width:Math.min(this.getVisibleWidth(), (40*colCount)),
                height:Math.min(this.getVisibleHeight()-this.navigationLayoutHeight, 80),
                items:yearItems,
                visibility:isc.Canvas.HIDDEN,
                baseButtonStyle:this.baseButtonStyle,
                dateChooser: this
            };
            if (this.shouldUseButtonTable()) {
                this.yearMenu = isc.YearChooser.newInstance(yearMenuConfig);
            } else {
                this.yearMenu = this.createAutoChild("yearMenu", yearMenuConfig);
            }
            // (autoDraw is true, so it is drawn, with visibility hidden at this point)
            //this.yearMenu.setPageLeft(this.getPageLeft() + ((this.width - this.yearMenu.width)/2));
            var left = component.getPageLeft() - ((this.yearMenu.getWidth() - component.getWidth()) /2);
            this.yearMenu.placeNear(Math.max(left, 0));

        } else {
            // L, T, W, H
            var top = this.getPageTop()+this.navigationLayoutHeight,
                width = Math.min(this.getVisibleWidth(), (40*colCount)),
                height = Math.min(this.getVisibleHeight()-this.navigationLayoutHeight, 80),
                buttonWidth = component.getWidth(),
                left = component.getPageLeft() - ((width - buttonWidth)/2)
            ;

            this.yearMenu.setItems(yearItems);
            this.yearMenu.resizeTo(width, height);
            this.yearMenu.placeNear(Math.max(left, 0), top);
        }
        // fiscal attribute checked in click handler
        this.yearMenu.fiscal = fiscal;

        // Now that we have getYearTitle(), yearItems might have changed since last time we
        // displayed the yearMenu.  So redraw it to be sure
        this.yearMenu.markForRedraw("Redraw to pick up any changes in yearItems");

        //XXX it'd be nice to hilite the current year somehow...
        this.yearMenu.showModal();
    },

    //> @method DateChooser.getYearTitle()
    // Override this method to alter the year representations that are shown in the DateChooser's
    // "Select a year" dropdown.  The default implementation returns the full four-digit
    // Gregorian year (ie, the same value that is passed in)
    //
    // @param year (Integer) The Gregorian year number to derive a display value for
    // @return (String) the value to show for the parameter year
    // @visibility external
    //<

    getYearTitle : function(gregorianYear) {
        return "" + gregorianYear;
    },

    //> @method DateChooser.getHeaderYearTitle()
    // Override this method to alter the year representation shown in the DateChooser's header.
    // The default implementation returns the full four-digit Gregorian year (ie, the same
    // value that is passed in)
    //
    // @param year (Integer) The Gregorian year number to derive a display value for
    // @return (String) the value to show for the parameter year
    // @visibility external
    //<
    getHeaderYearTitle : function(gregorianYear) {
        return "" + gregorianYear;
    },

    dateClick : function (year, month, day, selectNow, closeNow) {
        var date = this.chosenDate = isc.DateUtil.createLogicalDate(year, month, day);
        // set this.month / this.year - this ensures we actually show the selected
        // date if the user hits the today button while viewing another month

        var yearChanged = this.year != year;
        if (yearChanged) this.year = year;
        if (yearChanged || this.month != month) this.showMonth(month);

        this.month = month;
        this.year = year;
        this.day = day;

        if (selectNow) this.dateGrid.selectDateCell(date);

        if (this.showTimeItem) {
            // if we're showing the timeItem, update the local logicalTime with it's current value
            this.chosenTime = this.getTimeItem().getValue();
            if (this.closeOnDateClick != true && closeNow != true) return;
        }

        if (closeNow == false) return;

        this.dataChanged();

        if (window.dateClickCallback) {
            // if it's a string, normalize it to a function
            if (isc.isA.String(window.dateClickCallback)) {
                window.dateClickCallback = isc._makeFunction("date",window.dateClickCallback);
            }
            // and call it, passing the date
            window.dateClickCallback(date)
        }

        if (this.autoHide) this.hide();
        if (this.autoClose) this.close();

        return date;
    },

    // Observable dataChanged function (fired from dateClick)

    //> @method DateChooser.dataChanged()
    // <smartclient>Method to override or observe in order to be notified when a user picks a date value.
    // </smartclient><smartgwt>Add a notification to be fired whenever the data changes.</smartgwt>
    // <P>
    // Has no default behavior (so no need to call Super).
    // <P>
    // Use +link{getData()} to get the current date value.
    //
    // @visibility external
    //<
    dataChanged : function () {
    },

    //> @method DateChooser.cancelClick()
    // Fired when the user clicks the cancel button in this date chooser. Default implementation
    // clears the date chooser.
    // @visibility external
    //<

    cancelClick : function () {
        this.close();
    },

    //> @method DateChooser.todayClick()
    // Fired when the user clicks the Today button. Default implementation will select the current
    // date in the date chooser.
    // @visibility external
    //<

    todayClick : function () {
        // get today in the defaultDisplayTimezone
        var date = isc.DateUtil.today();
        this.dateClick(date.getFullYear(), date.getMonth(), date.getDate(), true);
    },

    //> @method DateChooser.applyClick()
    // Fired when the user clicks the Apply button. Default implementation will select the current
    // date in the date chooser.
    //<
    applyClick : function () {
        var date = this.chosenDate.duplicate();
        this.dateClick(date.getFullYear(), date.getMonth(), date.getDate(), true, true);
    },

    //> @method DateChooser.close()
    // Close the DateChooser.
    //<
    close : function () {
        this.hideClickMask();
        if (this.yearMenu && this.yearMenu.isVisible()) this.yearMenu.hide();
        if (this.monthMenu && this.monthMenu.isVisible()) this.monthMenu.hide();
        if (this.isDrawn()) this.clear();
    },

    dateFromIdClick : function (element, id) {
        var parts = id.split("_");
        if (parts.length != 3) return null;

        var year  = parseInt(parts[0]),
            month = parseInt(parts[1]),
            day   = parseInt(parts[2]);

        return this.dateClick(year, month, day);
    },

    // properties that when changed should update the UI / trigger a redraw
    _$redrawProperties : {
        showTodayButton:true,
        showCancelButton:true,
        showApplyButton:true
    },

    // propertyChanged - fired by setProperties for each modified property.
    propertyChanged : function (propName, value) {
        this.invokeSuper(isc.DateChooser, "propertyChanged", propName, value);
        if (this._$redrawProperties[propName]) this.updateButtonLayout();
    }

});
//!<Deferred




// For efficiency we want to re-use a single date-chooser widget in most cases.
// Add a class method for this
isc.DateChooser.addClassMethods({

    // getSharedDateChooser()   Simple method to return a standard date chooser.
    // Used by the DateItem

    getSharedDateChooser : function (properties, dataType) {
        if (dataType == null) {
            // no type passed - check for showTimeItem and default to "date"
            if (properties && properties.showTimeItem != null) {
                dataType = (properties.showTimeItem ? "datetime" : "date");
            } else dataType = "date";
        }

        var key = "_" + dataType + "GlobalChooser";
        if (!this[key]) {
            this[key] = this.create(properties, {

                _generated:true,
                // When re-using a DateChooser, we're almost certainly displaying it as a
                // floating picker rather than an inline element. Apply the common options for
                // a floating picker
                autoHide:true,
                // don't do this here, it clobbers showCancelButton in the "properties" param
                // (which comes from DateItem.pickerProperties)
                //showCancelButton:true,
                closeOnEscapeKeypress: true

            });
        } else {
            isc.addProperties(this[key], properties);
        }
        return this[key];
    }

});

// ButtonTable based menu components
// Used when useButtonTable is true

isc.ClassFactory.defineClass("WeekChooser", "ButtonTable");
isc.WeekChooser.addMethods({

    showWeekClick : function (element, id) {
        this.dateChooser.showWeek(parseInt(id));
    }

});

isc.ClassFactory.defineClass("MonthChooser", "ButtonTable");
isc.MonthChooser.addMethods({

    showMonthClick : function (element, id) {
        this.dateChooser.showMonth(parseInt(id));
    }

});

isc.ClassFactory.defineClass("YearChooser", "ButtonTable");
isc.YearChooser.addMethods({

    showYearClick : function (element, id) {

        if (this.fiscal) this.dateChooser.showFiscalYear(parseInt(id));
        else this.dateChooser.showYear(parseInt(id));

    }

});

// DateChooserMenuGrid
// This is a replacement for the ButtonTables used to show the
// Week, Day and Year picker menus.
// Supports standard GridRenderer / ListGrid features like focus and keyboard navigation
// This is used if useButtonTable is false
isc.ClassFactory.defineClass("DateChooserMenuGrid", isc.ListGrid);


isc.DateChooserMenuGrid.addProperties({
    cellPadding:2,
    tableStyle:"menuTable",
    backgroundColor:"CCCCCC",

    // We'll never show anything but the body
    showHeader:false,
    gridComponents:[
        "body"
    ],
    canSaveSearches:false,

    // Use cell navigation. We're kind of 'record-per-cell' model here
    canSelectCells:true,

    overflow:"visible",
    bodyOverflow:"visible",

    cellHeight:25,
    fixedRecordHeights:false,
    fixedFieldWidths:false,
    alternateRecordStyles:false,
    alternateFieldStyles:false,

    showSelectedRollOverCanvas:false,
    showRollOverCanvas:false,
    showRollUnderCanvas:false,

    arrowKeyAction:"focus"

});

isc.DateChooserMenuGrid.addMethods({



    useCellRecords:true,
    initWidget : function() {
        var rv = this.Super("initWidget", arguments);
        if (this.items) this.setItems(this.items);
        return rv;
    },

    setItems : function (items, fields) {
        this.items = isc.shallowClone(items);
        var data = [], fields = [];
        for (var i = 0; i < this.items.length; i++) {
            data.add({});
            for (var ii = 0; ii < this.items[i].length; ii++) {
                var fieldName = "field" + ii;
                data[i][fieldName] = this.items[i];
                if (fields.length <= ii) {
                    fields.add({name:fieldName, cellAlign:"center"});
                }
            }
        }
        this.setFields(fields);
        this.setData(data);
    },

    // Override getCellRecord() to return the "item" definition
    getCellRecord : function (rowNum, colNum) {
        if (rowNum == null || colNum == null) return null;
        if (this.items) return this.items[rowNum][colNum]; // Also available as this.data[rowNum][this.getFieldName(colNum)]
    },

    getCellValue : function (record, rowNum, colNum) {

        if (record == null) record = this.getCellRecord(rowNum, colNum);

        return record ? record.contents : this.Super("getCellValue", arguments);
    },


    // Show Modal: Put focus in the menu, bring to front, and dismiss on outside click
    showModal : function () {
        this.showClickMask(
            {target:this, methodName:"handleOutsideClick"},
            "soft",
            this);

        var _this = this;
        this.escapeKeyEvent = isc.Page.registerKey("Escape", function() {_this.handleEscape()});

        this.show();
        this.bringToFront();
        this._showingModal = true;
        this.body.focus();

    },
    handleOutsideClick:function () {
        this.hide();
    },
    handleEscape:function () {
        this.hide();
    },

    // override hide to hide the clickMask
    hide : function () {
        this.Super("hide", arguments);
        if (this._showingModal) {
            this.hideClickMask();
            isc.Page.unregisterKey(this.escapeKeyEvent);
            delete this._showingModal;
        }
    },

    getBaseStyle : function (record, rowNum, colNum) {
        if (this.baseButtonStyle) return this.baseButtonStyle;
        return this.Super("getBaseStyle", arguments);
    }

});



/*---------->    isc.Slider.js    <----------*/

//    The Slider class was developed as an instructional/documentation example of
//    creating a new widget class, covering a broad range of ISC client-side
//    framework concepts and conventions.

// Questions: jeff@isomorphic.com





//----------  Description  ----------
//> @class Slider
//    The Slider class implements a GUI slider widget allowing the user to select a numeric
//  value from within a range by dragging a visual indicator up and down a track.
//    <p>
//  The slider will generate events as the user interacts with it and changes its value.
//  If slider.sliderTarget is specified, moving the slider thumb generates a custom
//    event named 'sliderMove', sent to the sliderTarget.
//  If a <code>sliderMove</code> handler stringMethod is defined on the target, it will be
//  fired when the slider is moved. The second parameter (available via the variable name
//  <code>eventInfo</code> if the handler is a string) is a pointer back to the slider.
//  <p>
//  The slider will also fire a <code>valueChanged()</code> method whenever its value is
//  changed.  This can be observed or overridden on the Slider instance to perform some action.
//
//  @inheritsFrom Canvas
//  @treeLocation Client Reference/Control
//  @visibility external
//  @example slider
//<

//----------  Create the class  ----------
isc.ClassFactory.defineClass("Slider", isc.Canvas);



//----------  Define static properties  ----------
isc.Slider.addClassProperties({
    // isc.Slider.DOWN                   down state for the slider thumb
    DOWN:"down",
    // isc.Slider.UP                     up (enabled) state for the slider thumb
    UP:"",
    // isc.Slider.EVENTNAME              name of event sent to sliderTarget when thumb moved
    EVENTNAME:"sliderMove"
});


//----------  Define instance properties  ----------
isc.Slider.addProperties({

    overflow: "hidden",

    //>    @attr    slider.title        (String : "Set Value" : [IRW])
    // Optional display title for the slider.
    //      @see attr:showTitle
    //      @visibility external
    //<
    title:"Set Value",

    //>    @attr    slider.length        (int : 200 : [IRW])
    // Used to set slider height if vertical, slider width if horizontal.
    // Applied to the slider track, not necessarily the entire widget.
    // Overridden by an explicit width/height specification for the widget.
    //      @visibility external
    //<
    length:200,

    //>    @attr    slider.vertical        (Boolean : true : [IRW])
    // Indicates whether this is a vertical or horizontal slider.
    //      @visibility external
    //      @example slider
    //<
    vertical:true,

    //>    @attr    slider.thumbThickWidth        (int : 23 : [IRW])
    // The dimension of the thumb perpendicular to the slider track.
    //      @visibility external
    //<
    thumbThickWidth:23,

    //>    @attr    slider.thumbThinWidth        (int : 17 : [IRW])
    // The dimension of the thumb parallel to the slider track.
    //      @visibility external
    //<
    thumbThinWidth:17,

    //> @attr slider.trackWidth (int : 7 : [IRW])
    // The thickness of the track. This is the width, for a +link{slider.vertical, vertical}
    // slider, or the height, for a horizontal slider.
    // @visibility external
    //<
    trackWidth:7,

    //> @attr slider.hThumbStyle (CSSStyleName : null : IR)
    // Optional CSS style for the thumb for a +link{slider.vertical, horizontally oriented}
    // slider.
    // <P>
    // Will have the suffix "down" added when the mouse is down on the thumb, and "Disabled"
    // added when the slider is disabled.
    //
    // @visibility external
    //<

    //> @attr slider.vThumbStyle (CSSStyleName : null : IR)
    // Optional CSS style for the thumb for a +link{slider.vertical, vertically oriented}
    // slider.  See +link{hThumbStyle} for state suffixes.
    // @visibility external
    //<

    //> @attr slider.hTrackStyle (CSSStyleName : null : IR)
    // Optional CSS style for the track for a +link{slider.vertical, horizontally oriented}
    // slider.
    // <P>
    // Will have the suffix "Disabled" added when the slider is disabled.
    //
    // @visibility external
    //<

    //> @attr slider.vTrackStyle (CSSStyleName : null : IR)
    // Optional CSS style for the track for a +link{slider.vertical, vertically oriented}
    // slider.
    // <P>
    // Will have the suffix "Disabled" added when the slider is disabled.
    // @visibility external
    //<

    // skinImgDir       subdirectory for slider skin images
    skinImgDir:"images/Slider/",

    //>    @attr    slider.thumbSrc        (String : "thumb.gif" : [IRW])
    // The base filename for the slider thumb images.
    // The filenames for the thumb icons are assembled from this base filename and the state of the
    // thumb, as follows:<br>
    // Assume the thumbSrc is set to <code>{baseName}.{extension}</code><br>
    // The full set of images to be displayed is:<br>
    // For horizontal sliders:
    // <ul>
    // <li><code>h{baseName}.{extension}</code>: default enabled appearance.
    // <li><code>h{baseName}_down.{extension}</code>:  appearance when the slider is enabled and the
    //     thumb is clicked.
    // <li><code>h{baseName}_Disabled.{extension}</code>:  appearance when the slider is disabled.
    // </ul>
    // For vertical sliders:
    // <ul>
    // <li><code>v{baseName}.{extension}</code>: default enabled appearance.
    // <li><code>v{baseName}_down.{extension}</code>:  appearance when the slider is enabled and the
    //     thumb is clicked.
    // <li><code>v{baseName}_Disabled.{extension}</code>:  appearance when the slider is disabled.
    // </ul>
    //      @visibility external
    //<
    thumbSrc:"thumb.gif",

    //>    @attr    slider.trackSrc        (String : "track.gif" : [IRW])
    // The base filename for the slider track images.
    // The filenames for the track icons are assembled from this base filename and the state of the
    // slider, as follows:<br>
    // Assume the trackSrc is set to <code>{baseName}.{extension}</code><br>
    // The full set of images to be displayed is:<br>
    // For horizontal sliders:
    // <ul>
    // <li><code>h{baseName}_start.{extension}</code>: start (left edge) of the track for a slider
    //     that is enabled.
    // <li><code>h{baseName}_stretch.{extension}</code>:  the track for an enabled slider; this may
    //     be centered, tiled, or stretched.
    // <li><code>h{baseName}_end.{extension}</code>:  end (right edge) of the track for a slider
    //     that is enabled.
    // <li><code>h{baseName}_Disabled_start.{extension}</code>: start (left edge) of the track for a slider
    //     that is disabled.
    // <li><code>h{baseName}_Disabled_stretch.{extension}</code>:  the track for a disabled slider; this
    //     may be centered, tiled, or stretched.
    // <li><code>h{baseName}_Disabled_end.{extension}</code>:  end (right edge) of the track for a slider
    //     that is disabled.
    // </ul>
    // For vertical sliders:
    // <ul>
    // <li><code>v{baseName}_start.{extension}</code>: start (bottom edge) of the track for a slider
    //     that is enabled.
    // <li><code>v{baseName}_stretch.{extension}</code>:  the track for an enabled slider; this may
    //     be centered, tiled, or stretched.
    // <li><code>v{baseName}_end.{extension}</code>:  end (top edge) of the track for a slider
    //     that is enabled.
    // <li><code>v{baseName}_Disabled_start.{extension}</code>: start (bottom edge) of the track for a slider
    //     that is disabled.
    // <li><code>v{baseName}_Disabled_stretch.{extension}</code>:  the track for a disabled slider; this
    //     may be centered, tiled, or stretched.
    // <li><code>v{baseName}_end.{extension}</code>:  end (top edge) of the track for a slider
    //     that is disabled.
    // </ul>
    //      @see attr:trackImageType
    //      @visibility external
    //<
    trackSrc:"track.gif",

    //> @attr slider.trackCapSize (int : 6 : [IRW])
    // The height of +link{slider.vertical, vertical} slider start and end images, or width of
    // horizontal slider start and end images.
    // @visibility external
    //<
    trackCapSize:6,

    //>    @attr    slider.trackImageType        (ImageStyle : "stretch" : [IRW])
    // The imageType setting for the slider track.
    //      @see type:ImageStyle
    //      @see attr:stretchImg.imageType
    //      @visibility external
    //<
    trackImageType:isc.Img.STRETCH,

    //> @attr slider.showTitle (Boolean : true : [IRW])
    // Indicates whether the slider's +link{slider.title, title} should be displayed. The
    // default position for the title-label is to the left of a horizontal slider, or above a
    // +link{slider.vertical, vertical} slider.
    // @see attr:title
    // @visibility external
    //<
    showTitle:true,

    //> @attr slider.showRange (Boolean : true : [IRW])
    // Indicates whether labels for the +link{slider.rangeLabel, min and max values} of the
    // slider should be displayed. The default positions for these labels are below the
    // start/end of a horizontal slider, or to the right of the start/end of a
    // +link{slider.vertical, vertical} slider.
    // @see attr:minValueLabel
    // @see attr:maxValueLabel
    // @visibility external
    //<
    showRange:true,

    //> @attr slider.showValue (Boolean : true : [IRW])
    // Indicates whether a +link{slider.valueLabel, label} for the value of the slider should
    // be displayed. The default position for this label is to the right of a
    // +link{slider.vertical, vertical} slider,
    // or below a horizontal slider.
    // @see attr:value
    // @visibility external
    //<
    showValue:true,

    //>    @attr    slider.labelWidth        (int : 50 : [IRW])
    // The width of the labels used to display the minimum, maximum and current values of the
    // slider.
    //      @visibility external
    //<
    labelWidth:50,

    //> @attr slider.labelHeight (int : 20 : [IRW])
    // The height of the labels used to display the
    // +link{slider.rangeLabel, minimum, maximum} and +link{slider.valueLabel, current} values
    // of the slider.
    // @visibility external
    //<
    labelHeight:20,

    //> @attr slider.labelSpacing (int : 5 : [IRW])
    // The space around the labels used to display the
    // +link{slider.rangeLabel, minimum, maximum} and +link{slider.valueLabel, current} values
    // of the slider.
    // @visibility external
    //<
    labelSpacing:5,

    //> @attr slider.vLabelSpacing (Integer : null : [IRW])
    // The space around the labels used to display the
    // +link{slider.rangeLabel, minimum, maximum} and +link{slider.valueLabel, current} values
    // of the slider, when +link{slider.vertical, vertical} is true.  If unset, defaults to
    // +link{slider.labelSpacing}.
    // @visibility external
    //<

    //> @attr slider.hLabelSpacing (Integer : null : [IRW])
    // The space around the labels used to display the
    // +link{slider.rangeLabel, minimum, maximum} and +link{slider.valueLabel, current} values
    // of the slider, when +link{slider.vertical, vertical} is false.  If unset, defaults to
    // +link{slider.labelSpacing}.
    // @visibility external
    //<

    //> @attr slider.titleSpacing (int : 5 : [IRW])
    // The space between the +link{slider.showTitle, title} and the track.
    // @visibility external
    //<
    titleSpacing: 5,

    //> @attr slider.titleStyle (CSSStyleName : "sliderTitle" : IR)
    // CSS style for the +link{slider.title, title-text}, when
    // +link{slider.showTitle, showTitle} is true.
    // @visibility external
    //<
    titleStyle: "sliderTitle",

    //> @attr slider.rangeStyle (CSSStyleName : "sliderRange" : IR)
    // CSS style for the +link{slider.rangeLabel, min and max} range-labels, when
    // +link{slider.showRange, showRange} is true.
    // @visibility external
    //<
    rangeStyle: "sliderRange",

    //> @attr slider.valueStyle (CSSStyleName : "sliderValue" : IR)
    // CSS style for the floating +link{slider.valueLabel, valueLabel}, visible when
    // +link{slider.showValue} is true.
    // @visibility external
    //<
    valueStyle: "sliderValue",

    //> @attr slider.vValueStyle (CSSStyleName : null : IR)
    // Optional CSS style for the floating +link{slider.valueLabel, valueLabel}, visible when
    // +link{slider.showValue} is true and +link{slider.vertical, vertical} is true.
    // @visibility external
    //<

    //> @attr slider.hValueStyle (CSSStyleName : null : IR)
    // Optional CSS style for the floating +link{slider.valueLabel, valueLabel}, visible when
    // +link{slider.showValue} is true and +link{slider.vertical, vertical} is false.
    // @visibility external
    //<

    //> @attr slider.valueTextStyle (CSSStyleName : "sliderValueText" : IR)
    // CSS style for the text in the floating +link{slider.valueLabel, valueLabel},
    // visible when +link{slider.showValue, showValue} is true.
    // @visibility external
    //<
    valueTextStyle: "sliderValueText",

    //XXX need to create and use these CSS styles
    //XXX need mechanism for overriding default layouts

    //>    @attr    slider.value        (float : 1 : [IRW])
    // The slider value. This value should lie between the minValue and maxValue and increases as
    // the thumb is moved up (for a vertical slider) or right (for a horizontal slider) unless
    // flipValues is set to true.
    //      @see attr:minValue
    //      @see attr:maxValue
    //      @see attr:flipValues
    //      @see attr:showValue
    //      @visibility external
    //<
    value:1,

    //>    @attr    slider.minValue        (float : 1 : [IRW])
    // The minimum slider value. The slider value is equal to minValue when the thumb is at the
    // bottom or left of the slider (unless flipValues is true, in which case the minimum value
    // is at the top/right of the slider)
    //      @see attr:slider.flipValues
    //      @visibility external
    //      @example slider
    //<
    minValue:1,

    //>    @attr    slider.minValueLabel        (String : null : [IRW])
    // The text displayed in the label for the minimum value of the slider. If left as null, then
    // slider.minValue will be displayed.
    //      @see attr:showRange
    //      @see attr:minValue
    //      @visibility external
    //<

    //>    @attr    slider.maxValue        (float : 100 : [IRW])
    // The maximum slider value. The slider value is equal to maxValue when the thumb is at the
    // top or right of the slider (unless flipValues is true, in which case the maximum value
    // is at the bottom/left of the slider)
    //      @see attr:slider.flipValues
    //      @visibility external
    //      @example slider
    //<
    maxValue:100,

    //>    @attr    slider.maxValueLabel        (String : null : [IRW])
    // The text displayed in the label for the maximum value of the slider. If left as null, then
    // slider.maxValue will be displayed.
    //      @see attr:showRange
    //      @see attr:maxValue
    //      @visibility external
    //<

    //> @attr slider.numValues (Integer : null : [IRW])
    // The number of discrete values represented by slider. If specified, the range of valid
    // values (between <code>minValue</code> and <code>maxValue</code>) will be divided into
    // this many steps. As the thumb is moved along the track it will only select these values
    // and appear to jump between the steps.
    // @visibility external
    // @example slider
    //<

    //>    @attr slider.roundValues        (Boolean : true : [IRW])
    // Specifies whether the slider value should be rounded to the nearest integer.  If set to
    // false, values will be rounded to a fixed number of decimal places controlled by
    // +link{roundPrecision}.
    //
    //      @visibility external
    //<
    roundValues:true,

    //> @attr slider.roundPrecision (int : 1 : [IRW])
    // If +link{slider.roundValues} is false, the slider value will be rounded to this number of
    // decimal places. If set to null the value will not be rounded
    // @visibility external
    //<
    roundPrecision:1,

    //> @attr slider.flipValues (Boolean : false : [IRW])
    // Specifies whether the value range of the slider should be flipped so that values increase as
    // the thumb is moved down (for a +link{slider.vertical, vertical} slider) or to the left
    // (for a horizontal slider).
    // @visibility external
    //<
    flipValues:false,

    //>    @attr    slider.sliderTarget        (Canvas : null : [IRW])
    // The target widget for the <code>sliderMove</code> event generated when the slider thumb
    // is moved.
    //      @visibility external
    //<

    //>    @attr    slider.canFocus        (Boolean : true : [IRW])
    // Indicates whether keyboard manipulation of the slider is allowed.
    //      @visibility external
    //<
    canFocus:true,

    //>    @attr    slider.stepPercent        (float : 5 : [IRW])
    // The percentage of the total slider that constitutes one discrete step. The slider will move
    // one step when the appropriate arrow key is pressed.
    //      @visibility external
    //<
    stepPercent:5,

    //>    @attr    slider.animateThumb        (Boolean : true : [IRW])
    // Should the thumb be animated to its new position when the value is changed programmatically,
    // or by clicking in the slider track.
    //      @visibility animation
    //      @group animation
    //<
    //animateThumb:false,

    //>    @attr    slider.animateThumbTime        (int : 250 : [IRW])
    // Duration of thumb animation, in milliseconds.
    //      @visibility animation
    //      @group animation
    //<
    animateThumbTime:250,

    //>    @attr    slider.animateThumbInit        (Boolean : false : [IRW])
    // If thumb animation is enabled, should the thumb be animated to its initial value?
    //      @visibility animation
    //      @group animation
    //<
    //animateThumbInit:false,

    // undocumented for now; possibly make this internal
    animateThumbAcceleration:"slowStartandEnd",


    valueChangedOnDrag:true,   // default false may be more appropriate, but has backcompat problems
    valueChangedOnRelease:true, // can set this to false to exactly match the pre-5.5 behavior
    valueChangedOnClick:true // actually on mouseUp, but that is too confusable with thumb release
});



//!>Deferred
//----------  Define instance methods  ----------
isc.Slider.addMethods({

// update the valueLabel (a top-level widget) when the Slider resizes/moves
resized : function () {
    this._updateValueLabel("resized");
},
moved : function () {
    this._updateValueLabel("moved");
},
// also update the valueLabel when the parent resizes/moves/scrolls/changes visibility
parentResized : function () {
    this._updateValueLabel("parentResized");
},
parentMoved : function () {
    this._updateValueLabel("parentMoved");
},
parentScrolled : function () {
    this._updateValueLabel("parentScrolled");
},
parentVisibilityChanged : function (visible) {
    this._updateValueLabel("parentVisibilityChanged");
},

//------  initWidget()
// Extends superclass initWidget() to set slider dimensions, create the track and thumb child
// widgets, and initialize the slider's target, value, and enabled state.
initWidget : function () {
    this.Super("initWidget", arguments);
    // If passed a minValue that's greater than a max value, swap them.
    // If they are equal just leave them for now - we'll always return that value.
    if (!(this.minValue <= this.maxValue)) {
        this.logWarn("Slider specified with minValue:"+ this.minValue
                    + ", greater than maxValue:"+ this.maxValue
                    + " - reversing max and min value.");
        var minValue = this.minValue;
        this.minValue = this.maxValue;
        this.maxValue = minValue;
    }

    // Enforce rounding precision on min/max values.

    if (this.minValue != null) this.minValue = this._getRoundedValue(this.minValue);
    if (this.maxValue != null) this.maxValue = this._getRoundedValue(this.maxValue);

    // Save explicit length in case vertical state is changed
    this._userLength = this.length;

    this._createChildren();
},

_createChildren : function () {
    // calculate canvas width and height according to this.vertical
    this.setUpSize();

    // create track and thumb
    this._createTrackLayout();

    // create title, range, value labels if specified
    if (this.showTitle) this._titleLabel = this.addChild(this._createTitleLabel());
    if (this.showRange) {
        this._minLabel = this.addChild(this._createRangeLabel("min"));
        this._maxLabel = this.addChild(this._createRangeLabel("max"));
    }
    if (this.showValue) {
        this._createValueLabel();
        var l = this._valueLabelLayoutContainer || this._valueLabelLayout;
        l.bringToFront();
        // Ensure the valueLabel is drawn at the correct position by delaying its placement
        // until the Slider as a whole is draw()n
        this._updateValueLabelOnDraw = true;
    }

    // If an event is sent with a null target, the event handling system determines the
    // target based on the last mouse event. We definitely don't want that, so make this
    // slider the target if no target has been specified.


    this.setValue(this.value, !(this.animateThumbInit==true));
},
_refreshChildren : function () {
    // destroy the components and recreate - called when this.vertical changes
    this._destroyChildren();
    this._createChildren();
},
_destroyChildren : function () {
    // destroy all the children if they exist
    this._titleLabel && this._titleLabel.destroy();
    this._track && this._track.destroy();
    this._thumb && this._thumb.destroy();
    this._valueLabel && this._valueLabel.destroy();
    this._minLabel && this._minLabel.destroy();
    this._maxLabel && this._maxLabel.destroy();
    this._valueLabelLayoutContainer && this._valueLabelLayoutContainer.destroy();
    this._valueLabelLayout && this._valueLabelLayout.destroy();

    // clear the refs
    this._titleLabel = this._track = this._thumb = this._valueLabel = this.valueLabel = null;
    this._minLabel = this._maxLabel = null;
    this._valueLabelLayoutContainer = this._valueLabelLayout = null;
},

// override destroy() to call _destroyChildren(), just in case
destroy : function () {
    this._destroyChildren();
    this.Super("destroy", arguments);
},

// setUpSize() - sets up width/height/length (track length)
// If width / height is explicitly specified, determine length from this
// Otherwise determine width/height based on specified length

setUpSize : function () {
    var specifiedWidth = this._userWidth,
        specifiedHeight = this._userHeight,
        thumbThickWidth = this._getThumbThickWidth(),
        thumbThinWidth = this._getThumbThinWidth();

    // If the user didn't specify a width / height, default them based on which components are
    // being shown.
    if (this.vertical) {
        if (specifiedWidth == null) {

            var width = Math.max(thumbThickWidth, this.trackWidth);
            // value shows on one side of the slider, range (min/max labels) show on the
            // other side
            if (this.showValue) width += this.labelWidth + this.labelSpacing;
            if (this.showRange) width += this.labelWidth + this.labelSpacing;

            // Note: titleLabel width is derived from the width of the slider so no need to account
            // for it here

            // If padding is specified, we want to expand enough that it shows around the
            // inner components
            width += this.getHPadding();

            //>DEBUG
            this.logInfo("defaulting width to " + width + "px");
            //<DEBUG
            this.setWidth(width);
            this.updateUserSize(width, this._$width);
        }
        if (specifiedHeight == null) {
            var height = this.length;

            if (this.showTitle) height += this.labelHeight + this.labelSpacing;

            // if we show the floating value label, it can overflow beyond the
            // end of the track - account for this when sizing the widget so we don't
            // overflow by default
            if (this.showValue && (this.labelHeight > thumbThinWidth)) {
                height += (this.labelHeight - thumbThinWidth);
            }

            // If padding/margin are specified, expand to account for them
            height += this.getVPadding() + this.getVMarginSize();

            //>DEBUG
            this.logInfo("no specified height on vertical Slider - defaulting to:" + height +
                         " based on slider.length of " + this.length);
            //<DEBUG
            this.setHeight(height);
            this.updateUserSize(height, this._$height);
        } else {
            // if the user specifies both length and height, let height win.
            // (using innerContentWidth accounts for padding)
            this.length = this.getInnerContentHeight(false);
            if (this.showTitle) this.length -= (this.labelHeight + this.labelSpacing);
            if (this.showValue && (this.labelHeight > thumbThinWidth)) {
                this.length -= (this.labelHeight - thumbThinWidth);
            }
            //>DEBUG
            this.logInfo("setting slider track length to:"+ this.length
                        + ", based on specified height");
            //<DEBUG
        }
    } else {
        if (specifiedHeight == null) {
            var height = Math.max(thumbThickWidth, this.trackWidth);
            if (this.showValue) height += this.labelHeight + this.labelSpacing;
            if (this.showRange) height += this.labelHeight + this.labelSpacing;

            height += this.getVPadding();

            //>DEBUG
            this.logInfo("defaulting height to " + height + "px");
            //<DEBUG
            this.setHeight(height);
            this.updateUserSize(height, this._$height);
        }
        if (specifiedWidth == null) {
            var width = this.length;
            if (this.showTitle) {
                var rect = this._getTrackLayoutPos();
                width += rect[0];
            }
            if (this.showValue && (this.labelWidth > thumbThinWidth)) {
                width += (this.labelWidth - thumbThinWidth);
            }

            // If padding/margin are specified, expand to account for them
            width += this.getHPadding() + this.getHMarginSize();

            //>DEBUG
            this.logInfo("no specified width on horizontal Slider - defaulting to:" + width +
                         " based on slider.length of " + this.length);
            //<DEBUG
            this.setWidth(width);
            this.updateUserSize(width, this._$width);
        } else {

            // if the user specifies both length and width let width win.
            this.length = this.getInnerContentWidth(false);
            if (this.showTitle) {
                var rect = this._getTrackLayoutPos();
                this.length -= rect[0];
            }
            // We don't use labelWidth for the valueLabel - we use a smaller value
            // (undocumented 'hValueWidth' on the assumption that the value will
            // overflow if necessary)
            if (this.showValue && (this.hValueLabelWidth > thumbThinWidth)) {
                // We use a small label width for the horizontal valueLabel and
                // allow the content to overflow if necessary
                this.length -= (this.hValueLabelWidth - thumbThinWidth);
            }
            //>DEBUG
            this.logInfo("setting slider track length to:"+ this.length
                        + ", based on specified width");
            //<DEBUG
        }
    }

    // calculate usable length and step size, in pixels, for use in ongoing calculations

    this._usableLength = this.length - thumbThickWidth;
    if (this.numValues) {
        this.numStops = this.numValues-1;
        if (this.numStops == 0) this.numStops = 1;
        // divide by the number of values, not by that number minus 1
        this._stepSize = this._usableLength/this.numStops;
    }

},

// Override resizeBy to resize the track.
// setWidth / setHeight / setRect et al. fall through to this method
resizeBy : function (deltaX, deltaY) {
    this.Super("resizeBy", arguments);
    if (!this._track) return;

    var vertical = this.vertical;

    if ((vertical && deltaY != 0) || (!vertical && deltaX != 0)) {
        // Update length / usable length for caculations...
        this.length += vertical ? deltaY : deltaX;
        this._usableLength = this.length - this._getThumbThinWidth();
        // resize the track
        if (vertical) this._track.resizeBy(0, deltaY);
        else this._track.resizeBy(deltaX, 0);

        // re-calculate stepSize if numStops is defined
        if (this.numStops) {
            this._stepSize = this._usableLength/this.numStops;
        }

        // fire setValue to update the thumb.
        this.setValue(this.value, true, true); // no animation, no logical value change
        // Also move the max (or min) marker
        if (this.showRange) {
            if (this.vertical) {
                var endMarker = this.flipValues ? this._maxLabel : this._minLabel;
                endMarker.moveBy(0, deltaY);
            } else {
                var endMarker = this.flipValues ? this._minLabel : this._maxLabel;
                endMarker.moveBy(deltaX, 0);
            }
        }
    }
},

//------  _createRangeLabel(minOrMax)

//> @attr slider.rangeLabel (MultiAutoChild Label : null : IR)
// Used to create both of the min and max range-labels, via the +link{AutoChild} pattern, hence
// <code>rangeLabelConstructor</code>, <code>rangeLabelDefaults</code> and
// <code>rangeLabelProperties</code> are valid.
//
// @visibility external
//<
rangeLabelConstructor: "Label",
rangeLabelDefaults: {
    overflow: "hidden",
    wrap: false
},

// Creates, initializes, and returns a new Label widget to be the slider's mix or max value
// label. minOrMax must be the string "min" or "max".
_createRangeLabel : function (minOrMax) {
    var labelLeft, labelTop, labelAlign, labelValign,
        // Should the label be at the start (top / left) or end (bottom/right) of the slider?
        atStartPosition = (this.vertical ? minOrMax == "max" : minOrMax == "min");
    if (this.flipValues) atStartPosition = !atStartPosition;

    // For vertical sliders, range labels appear to the right of the slider track
    // for horizontal sliders, they appear below the slider track.
    if (this.vertical) {
        labelLeft = Math.max(this._getThumbThickWidth(), this.trackWidth) + this.labelSpacing +
                    (this.showValue ? this.labelWidth + this.labelSpacing : 0) +
                    this.getLeftPadding();
        labelAlign = isc.Canvas.LEFT;
        if (atStartPosition) {
            labelTop = this._track.getTop();
            labelValign = isc.Canvas.TOP;
        } else {
            var trackBottom = this._track.getTop() + this._track.getHeight();
            labelTop = trackBottom - this.labelHeight;
            labelValign = isc.Canvas.BOTTOM;
        }
    } else { // this.horizontal
        labelTop = Math.max(this._getThumbThickWidth(), this.trackWidth) + this.labelSpacing +
                    (this.showValue ? this.labelHeight + this.labelSpacing : 0)
                    + this.getTopPadding();


        labelValign = isc.Canvas.TOP;
        if (atStartPosition) {
            labelLeft = this._track.getLeft();
            labelAlign = isc.Canvas.LEFT;
        } else {
            var trackRight = this._track.getLeft() + this._track.getWidth();
            labelLeft = trackRight - this.labelWidth;
            labelAlign = isc.Canvas.RIGHT;
        }
    }

    var rangeLabel = this.createAutoChild("rangeLabel", {
        ID:this.getID()+"_"+minOrMax+"Label",
        left:labelLeft,
        top:labelTop,
        width:this.labelWidth,
        height: this.labelHeight,
        align:labelAlign,
        valign:labelValign,
        styleName:this.rangeStyle

    });
    // set the label contents with a call to setContents(), so a dev can override that method
    // on slider.rangeLabelProperties to apply formatting, for example
    rangeLabel.setContents(minOrMax == "min" ?
        (this.minValueLabel ? this.minValueLabel : this.formatValue(this.minValue, this.rangeFormat)) :
        (this.maxValueLabel ? this.maxValueLabel : this.formatValue(this.maxValue, this.rangeFormat))
    );
    return rangeLabel;
},


//> @attr slider.valueFormat (FormatString : null : IR)
// +link{FormatString} for numeric formatting of the value and range labels.
// @group appearance
// @visibility external
//<

//> @attr slider.rangeFormat (FormatString : null : IR)
// +link{FormatString} for numeric formatting of the range labels.  If unset, defaults to
// +link{slider.valueFormat}
// @group appearance
// @visibility external
//<

formatValue : function (value, format) {
    var result = isc.shallowClone(value);
    // default to this.valueFormat
    format = format || this.valueFormat;
    if (format != null && isc.isA.Number(value)) {
        result = isc.NumberUtil.format(value, format);
    }
    return result;
},


//------  _createTitleLabel()
// Creates, initializes, and returns a new Label widget to be the slider's title label.
_createTitleLabel : function () {
    // Title label will always float at 0,0 within the slider.
    var labelAlign = (this.vertical ? isc.Canvas.CENTER : isc.Canvas.RIGHT);

    return isc.Label.create({
        ID:this.getID()+"_titleLabel",
        autoDraw:false,
        left:this.getLeftPadding(),
        top:this.getTopPadding(),
        width:(this.vertical ? this.getInnerContentWidth(false) : this.labelWidth),
        height:(this.vertical ? this.labelHeight : this.getInnerContentHeight(false)),
        align:labelAlign,
        className:this.titleStyle,
        contents:this.title
    });
},


//------  _createValueLabel()
// Creates, initializes, and returns a new Label widget to be the slider's dynamic value label.
hValueLabelWidth:5,

//> @attr slider.valueLabel (AutoChild Label : null : IR)
// +link{AutoChild} displaying the current value as a floating label when
// +link{slider.showValue, showValue} is true.
//
// @visibility external
//<
valueLabelConstructor: "Label",
valueLabelDefaults: {
    moveWithMaster: false, // We'll explicitly handle moving the valueLabel
    overflow: true,
    wrap: false,
    canFocus: false,
    mouseUp : function () {
        return false;
    }
},

_createValueLabel : function () {
    var labelLeft, labelTop, labelWidth, labelAlign, labelValign;

    var hSpacing = this.hLabelSpacing == null ? this.labelSpacing : this.hLabelSpacing;
    var vSpacing = this.vLabelSpacing == null ? this.labelSpacing : this.vLabelSpacing;

    if (this.vertical) {
        labelLeft = this._thumb.getLeft() - this.labelWidth - hSpacing;
        // align the center of the label with the center of the thumb
        labelTop = this._thumb.getPageTop()
                    + parseInt(this._thumb.getHeight()/2 - (this.labelHeight/2));
        labelAlign = isc.Canvas.RIGHT;
        labelValign = isc.Canvas.CENTER;
        labelWidth = this.labelWidth;
    } else {
        labelLeft = this._thumb.getLeft()
                    + parseInt(this._thumb.getWidth()/2 - this.labelWidth/2);
        labelTop = this._thumb.getPageTop() - this.labelHeight - vSpacing;
        labelAlign = isc.Canvas.CENTER;
        labelValign = isc.Canvas.BOTTOM;
        labelWidth = this.labelWidth;
    }

    var valueStyle = (this.vertical ? this.vValueStyle : this.hValueStyle) || this.valueStyle;

    var layout = this._valueLabelLayout = this.createAutoChild("valueLabelLayout", {
        //_constructor: this.vertical ? "HLayout" : "VLayout",
        _constructor: "StatefulCanvas",
        autoDraw: false,
        left:labelLeft,
        top:labelTop,
        canFocus: false,
        showFocused: false,
        showDown: false,
        slider: this,
        // the _valueLabelLayout is 1px wide in horizontal sliders, and it overflows
        //width: this.vertical ? labelWidth : 1,
        width: 1,
        height:this.labelHeight,
        align:labelAlign,
        defaultLayoutAlign: "center",
        observes:[
            {source:this, message:"handleValueChanged", action:"this._updateValueLabel('handleValueChanged');"}
            //,
            //{source:this, message:"parentMoved", action:"this._updateValueLabel('parentMoved');"}
        ],
        baseStyle: valueStyle
    });
    // deparent the label, it floats at the top level
    layout.deparent();

    if (this.vertical) {
        // put the _valueLabelLayout (which shows the borders) in another canvas
        this._valueLabelLayoutContainer = this.createAutoChild("valueLabelLayoutContainer", {
            _constructor: "HLayout",
            width: this.labelWidth,
            height: this.labelHeight,
            overflow: "hidden",
            align: "right",
            layoutRightMargin: 5
        });
        this._valueLabelLayoutContainer.deparent();
        this._valueLabelLayoutContainer.addMember(this._valueLabelLayout);
    }

    var label = this.createAutoChild("valueLabel", {
        width: 1,
        height: 1,
        overflow: 'visible',
        styleName: this.valueTextStyle,
        contents:this.value
    });

    this._valueLabel = label;
//    this._valueLabelLayout.addMember(label);
    this._valueLabelLayout.addChild(label);
    if (!this.vertical) {
        isc.addMethods(layout, {
            // Override draw() to reposition the label after drawing.
            // we have to do this as we don't know the drawn size of the label until it has been
            // drawn in the DOM, and the desired position depends on the drawn size.
            draw : function () {
                this.Super("draw", arguments);
                this.slider._updateValueLabel();
            }
        });
    };

    return this._valueLabelLayoutContainer || this._valueLabelLayout;
},

draw : function () {
    this.Super("draw", arguments);
    if (this.showActiveTrack) this.updateActiveTrack();
    if (this._updateValueLabelOnDraw) {
        // place the valueLabel after draw, so its offsets are correct
        delete this._updateValueLabelOnDraw;
        this.delayCall("_updateValueLabel");
    }
},

setValueStyle : function (newValueStyle) {
    this.valueStyle = newValueStyle;
    if (this._valueLabel != null) {
        this._valueLabel.setBaseStyle(newValueStyle);
        this._updateValueLabel("setValueStyle");
    }
},


//_createTrackLayout()
// Internal function fired once at init time to create the track and thumb for the slider

_createTrackLayout : function () {

    // Determine the rect for the trackLayout.  We will center the thumb and track along the
    // long axis of this rect.
    var layoutRect = this._getTrackLayoutPos(),
        trackLeft, trackTop,
        trackWidth = (this.vertical ? this.trackWidth : this.length),
        trackHeight = (this.vertical ? this.length : this.trackWidth),
        thumbLeft, thumbTop,
        thumbThickWidth = this._getThumbThickWidth(),
        thumbThinWidth = this._getThumbThinWidth(),
        thumbWidth = (this.vertical ? thumbThickWidth : thumbThinWidth),
        thumbHeight = (this.vertical ? thumbThinWidth : thumbThickWidth)
    ;


    var thumbThicker = thumbThickWidth > this.trackWidth;
    if (thumbThicker) {
        if (this.vertical) {
            thumbLeft = layoutRect[0];
            trackLeft = thumbLeft + parseInt(thumbThickWidth/2 - this.trackWidth/2);
            trackTop = layoutRect[1];
            // Doesn't really matter where we put the thumb vertically - it'll be shifted via
            // 'setValue()'
            thumbTop = layoutRect[1];
        } else {
            thumbTop = layoutRect[1];
            trackTop = thumbTop + parseInt(thumbThickWidth/2 - this.trackWidth/2);
            trackLeft = layoutRect[0];
            thumbLeft = layoutRect[0];
        }
    // track is thicker than the thumb
    } else {
        if (this.vertical) {
            trackLeft = layoutRect[0];
            thumbLeft = trackLeft + parseInt(this.trackWidth/2 - thumbThinWidth/2);
            trackTop = layoutRect[1];
            thumbTop = layoutRect[1];
        } else {
            trackTop = layoutRect[1];
            thumbTop = trackTop + parseInt(this.trackWidth/2 - thumbThinWidth/2);
            trackLeft = layoutRect[0];
            thumbLeft = layoutRect[0];
        }
    }

    //>DEBUG
    this.logDebug("calculated coords for track:"+ [trackLeft, trackTop, trackWidth, trackHeight]);
    this.logDebug("calculated coords for thumb:"+ [thumbLeft, thumbTop, thumbWidth, thumbHeight]);
    //<DEBUG

    this._track = this.addChild(this._createTrack(trackTop, trackLeft, trackWidth, trackHeight));
    // Make the thumb a peer of the track. When the track gets moved, so will the thumb
    // (but the thumb can move without moving the track, of course)
    this._thumb = this._track.addPeer(this._createThumb(thumbTop, thumbLeft, thumbWidth, thumbHeight));
},

// _getTrackLayoutPos()
_getTrackLayoutPos : function () {
    // value floats to the left of a vertical slider and above a horizontal one
    // title floats above a vertical slider and to the left of a horizontal one.
    var spacing = (this.vertical ? this.vTitleSpacing : this.hTitleSpacing) || this.titleSpacing;
    var left = this.vertical ? (this.showValue ? this.labelWidth + this.labelSpacing: 0)
                             : (this.showTitle ? this.labelWidth + spacing: 0),
        // title always floats above a slider
        top = this.vertical ? (this.showTitle ? this.labelHeight + spacing : 0)
                            : (this.showValue ? this.labelHeight + this.labelSpacing: 0);

    left += this.getLeftPadding();
    top += this.getTopPadding();

    // if the valueLabel can overflow the ends of the track (because it's wider or taller
    // than the thumb), add padding at the start of the track to account for it.
    // (We've already accounted for this difference when determining the track length so no
    // need to also account for this on the end of the track)
    if (this.showValue) {
        var thumbThinWidth = this._getThumbThinWidth()
        if (this.vertical && (this.labelHeight > thumbThinWidth)) {
            top += Math.round((this.labelHeight - thumbThinWidth)/2);
        }
        if (this.horizontal && (this.labelWidth > thumbThinWidth)) {
            left += Math.round((this.labelWidth - thumbThinWidth)/2);
        }
    }

    return [left, top];
},

//------  _createTrack()
// Creates, initializes, and returns a new StretchImg widget to be the slider's track.

//> @attr slider.track (AutoChild StretchImg : null : IR)
//<
trackConstructor: "StretchImg", // note: RangeSlider.js gets the trackConstructor instance property
trackDefaults: {
    // prevent Down style
    showDown: false,
    showDisabled: true
},


//> @attr slider.showActiveTrack (Boolean : false : IR)
// Whether to show the +link{slider.activeTrack, activeTrack}, which highlights the 'active'
// portion of a slider, from its minimum to its current +link{slider.value, value}.
// @visibility external
//<
showActiveTrack: false,

//> @attr slider.activeTrackStyle (CSSStyleName : "sliderTrackActive" : IR)
// CSS style used to highlight the +link{slider.showActiveTrack, active} part of the
// slider track.
// <P>
// Will have the suffix "Disabled" added when the slider is disabled.
// @visibility external
//<
activeTrackStyle: 'sliderTrackActive',

//> @attr slider.activeTrack (AutoChild StatefulCanvas : null : IR)
// A styled canvas used to highlight the +link{slider.showActiveTrack, active} part of the
// slider track.
//
// @visibility external
//<
activeTrackConstructor: "StatefulCanvas",
activeTrackDefaults: {
    contents: '',
    // prevent Down style
    showDown: false
},
_createActiveTrack : function (properties) {
    properties = properties || {};
    properties.styleName = this.activeTrackStyle;

    this._activeTrack = this.createAutoChild('activeTrack',
        properties
    );
    this.addChild(this._activeTrack);
},
updateActiveTrack : function () {
    if (!this.showActiveTrack || !this.isDrawn()) return;

    var track = this._track,
        thumb = this._thumb,
        aTrack
    ;


    if (!this._activeTrack) {
        var properties;

        if (this.vertical) {
            var activeTop = Math.round(thumb.getTop() + (thumb.getHeight() / 2));
            var activeHeight = Math.max(0, track.getTop() + track.getHeight() - activeTop);

            properties = {
                top: activeTop,
                left: track.getLeft(),
                width: track.getWidth(),
                height: activeHeight
            };
        } else {
            properties = {
                top: track.getTop(),
                left: track.getLeft(),
                width: Math.round((thumb.getLeft() + (thumb.getWidth()/2)) - track.getLeft()),
                height: track.getHeight()
            };
        }
        this._createActiveTrack(properties);
        aTrack = this._activeTrack;
    } else {
        aTrack = this._activeTrack;
        aTrack.moveTo(track.getLeft(), track.getTop());
        if (this.vertical) {
            var activeTop = thumb.getTop() + (thumb.getHeight() / 2);
            var activeHeight = Math.max(0, track.getTop() + track.getHeight() - activeTop);

            aTrack.setTop(activeTop);
            aTrack.resizeTo(track.getWidth(), activeHeight);
        } else {
            aTrack.resizeTo(Math.round((thumb.getLeft() + (thumb.getWidth()/2)) - aTrack.getLeft()), track.getHeight());
        }
    }

    if (!aTrack.isDrawn()) aTrack.draw();
    else aTrack.redraw();
    aTrack.moveAbove(track);
},

_createTrack : function (top, left, width, height) {

    return this.createAutoChild("track", {
        left:left,
        top:top,
        width:width,
        height:height,
        vertical:this.vertical,

        // image-based appearance: StretchImg props
        capSize:this.trackCapSize,
        src:"[SKIN]" + (this.vertical ? "v" : "h") + this.trackSrc,
        skinImgDir:this.skinImgDir,
        imageType:this.trackImageType,

        // allows a Label to be used with pure CSS styling
        styleName:this[(this.vertical ? "v" : "h") + "TrackStyle"],
        overflow:"hidden",

        // allow the thumb and the track to have focus, but set exclude them from the tab order
        // this allows for bubbling of keypress events after the user has clicked on the thumb or
        // track of the slider
        canFocus:true,
        tabIndex:-1,
        cacheImageSizes: false
        //backgroundColor:"#666666"    // in case images aren't available
    });
},


//------  _createThumb()
// Creates, initializes, and returns a new Img widget to be the slider's thumb.
extraThumbSpace: 2,
touchExtraThumbSpace: 8,
thumbDefaults: {
    _constructor: "Img",
    overflow: "hidden",
    showDisabled: true,

    cursor: isc.Canvas.HAND,
    // We want the thumb to move with the track, but NOT resize with it.
    _resizeWithMaster: false,

    handleMouseDown : function () {
        this.setState(isc.Slider.DOWN);
    },
    handleMouseUp : function () {
        this.setState(isc.Slider.UP);
    },
    handleMouseOut : function () {
        var EH = this.ns.EH;
        // If the mouse leaves the thumb area and the thumb is not being dragged, then
        // reset the state to UP.
        if (!EH.dragging || this !== EH.dragTarget) {
            this.setState(isc.Slider.UP);
        }
    },

    canDrag: true,
    dragAppearance: isc.EventHandler.NONE,
    dragStartDistance: 0, // start drag scrolling on any mouse movement
    handleDragStart : function () {
        var EH = this.ns.EH;
        EH.setDragOffset(-1 * (this.getPageLeft() - EH.mouseDownEvent.x),
                         -1 * (this.getPageTop()  - EH.mouseDownEvent.y));
        this.setState(isc.Slider.DOWN);
    },
    handleDragMove : function () {
        this.creator._thumbMove();
    },
    handleDragStop : function () {
        this.setState(isc.Slider.UP);
        if (this.creator.valueChangedOnRelease) {
            this.creator.handleValueChanged(this.creator.value);
        }
    },

    // allow the thumb and the track to have focus, but exclude them from the tab order.
    // This allows for bubbling of keypress events after the user has clicked on the thumb or
    // track of the slider
    canFocus: true,
    tabIndex: -1,


    showTriggerArea: isc.Browser.isTouch ? true : false
    ,setLeft : function (newLeft) {
        this._updateTriggerArea(newLeft);
        var result = this.Super("setLeft", arguments);
        return result;
    },
    _updateTriggerArea : function (left) {
        if (this.showTriggerArea) {
            // make sure the thumb's triggerArea doesn't cause the slider to overflow
            var trackLeft = this.creator._track.getLeft(),
                trackEnd = trackLeft + this.creator._usableLength,
                thumbWidth = this.getVisibleWidth()
            ;
            if (left-trackLeft <= this.triggerSpace) {
                if (this.triggerAreaLeft == this.triggerSpace) {
                    this.setTriggerAreaLeft(0);
                    this.logInfo("newLeft is " + left + " - clearing triggerAreaLeft", "slider");
                }
            } else if (this.triggerAreaLeft != this.triggerSpace) {
                this.setTriggerAreaLeft(this.triggerSpace);
                this.logInfo("newLeft is " + left + " - restoring triggerAreaLeft", "slider");
            }
            if (left+thumbWidth+this.triggerSpace >= trackEnd) {
                if (this.triggerAreaRight == this.triggerSpace) {
                    this.setTriggerAreaRight(0);
                    this.logInfo("newLeft is " + left + " - clearing triggerAreaRight", "slider");
                }
            } else if (this.triggerAreaRight != this.triggerSpace) {
                this.setTriggerAreaRight(this.triggerSpace);
                this.logInfo("newLeft is " + left + " - restoring triggerAreaRight", "slider");
            }
        }
    }
},
_createThumb : function (top, left, width, height) {
    var extraSpace = (isc.Browser.isTouch ? this.touchExtraThumbSpace : this.extraThumbSpace);
    var thumb = this.createAutoChild("thumb", {
        left: left,
        top: top,
        width: width,
        height: height,

        // image-based appearance: Img props
        src: "[SKIN]" + (this.vertical ? "v" : "h") + this.thumbSrc,
        skinImgDir: this.skinImgDir,

        styleName: this[(this.vertical ? "v" : "h") + "ThumbStyle"],

        triggerSpace: extraSpace,
        triggerAreaTop: extraSpace,
        triggerAreaRight: extraSpace,
        triggerAreaBottom: extraSpace,
        triggerAreaLeft: extraSpace
    });

    return thumb;
},

// Get the slider value associated with provided coords
_getValueFromCoords : function (fromClick, coords, thumbMove) {
    var thumbPosition, rawValue,
        EH = isc.EventHandler;

    if (this.vertical) {
        var trackTop = this._track.getTop(),
            trackEnd = this._usableLength + trackTop;

        // determine the desired position on the track
        thumbPosition = coords[1] - EH.dragOffsetY - this.getPageTop();
        thumbPosition = Math.max(trackTop, Math.min(trackEnd, thumbPosition));
        // for values calculations we want positions relative to trackTop
        var thumbOffset = thumbPosition - trackTop;
        if (this.numStops) {
            // do not round thumbOffset yet, since it is used to calculate the raw value below
            thumbOffset = Math.round(thumbOffset/this._stepSize) * this._stepSize;
            thumbPosition = Math.round(thumbOffset) + trackTop;
        }
        if (thumbPosition == this._thumb.getTop()) return; // no thumb movement
        //>DEBUG
        this.logDebug("drag-moving thumb to:"+ thumbPosition)
        //<DEBUG
        if (fromClick && this.animateThumb) {
            this._thumbAnimation = this._thumb.animateMove(this._thumb.getLeft(), thumbPosition,
                null, this.animateThumbTime, this.animateThumbAcceleration);
        } else if (thumbMove) {
            this._thumb.setTop(thumbPosition);
        }
        rawValue = (this.flipValues ? thumbOffset/this._usableLength : 1-thumbOffset/this._usableLength);

    } else {
        var trackLeft = this._track.getLeft(),
            trackEnd = this._usableLength + trackLeft,
            thumbWidth = this._thumb ? this._thumb.getVisibleWidth() : this.thumbThickWidth
        ;

        thumbPosition = coords[0] - EH.dragOffsetX - this.getPageLeft();
        thumbPosition = Math.max(trackLeft, Math.min(trackEnd, thumbPosition));
        var thumbOffset = thumbPosition - trackLeft;
        if (this.numStops) {
            // do not round thumbOffset yet, since it is used to calculate the raw value below
            thumbOffset = Math.round(thumbOffset/this._stepSize) * this._stepSize;
            thumbPosition = Math.round(thumbOffset) + trackLeft;
        }
        if (thumbPosition == this._thumb.getLeft()) return; // no thumb movement
        //>DEBUG
        this.logDebug("drag-moving thumb to:"+ thumbPosition)
        //<DEBUG
        if (fromClick && this.animateThumb) {
            this._thumbAnimation = this._thumb.animateMove(thumbPosition, this._thumb.getTop(),
                null, this.animateThumbTime, this.animateThumbAcceleration);
        } else if (thumbMove) {
            this._thumb.setLeft(thumbPosition);
        }
        rawValue = (this.flipValues ? 1-thumbOffset/this._usableLength : thumbOffset/this._usableLength);
    }

    if (this.maxValue == this.minValue) return this.minValue;
    var finalValue = rawValue * (this.maxValue - this.minValue) + this.minValue;
    return this._getRoundedValue(finalValue);
},

//------  _thumbMove()
// Called by the dragMove handler for the slider thumb (this._thumb). Calculates
// the new thumb position, and if the position has changed: moves the thumb widget,
// calculates the new slider value (this.value) and sends the 'sliderMove' event
// to the target (this.sliderTarget).
// The 'fromClick' parameter indicates whether this movement is called from a click
// (eg elsewhere on the track) instead of a drag, in which case we might animate the thumb.
_thumbMove : function (fromClick) {
    var EH = this.ns.EH;
    var finalValue = this._getValueFromCoords(fromClick, [EH.getX(), EH.getY()], true);
    if (finalValue != null) this.value = finalValue;

    //>DEBUG
    this.logDebug("slider value from drag-move:" + this.value);
    //<DEBUG

    // NB: second part of this conditional is required because slider.mouseUp calls slider._thumbMove
    if (this.valueChangedOnDrag || !this.valueIsChanging()) {
        this.handleValueChanged(this.value);    // fires observable valueChanged() method
    }

    if (this.sliderTarget) isc.EventHandler.handleEvent(this.sliderTarget, isc.Slider.EVENTNAME, this);
},

_getRoundedValue : function (value) {
    if (this.roundValues) value = Math.round(value);
    else if (this.roundPrecision != null) {
        var multiplier = Math.pow(10, this.roundPrecision);
        value = (Math.round(value * multiplier))/multiplier;
    }
    return value;
},

// forcibly hide the floating label
hideValueLabel : function () {
    var hideThis = this._valueLabelLayoutContainer || this._valueLabelLayout;
    hideThis && hideThis.hide();
},

// _updateValueLabel is called on 'valueChanged' observation when the valueLabel is set up
_updateValueLabel : function (reason) {
    // bail if still pending a draw
    if (this._updateValueLabelOnDraw) return;

    if (!this.isDrawn() || !this._thumb || !this._thumb.isDrawn()) return;

    // bail if offscreen
    if (this.getPageTop() < -100) return;

    // showActiveTrack causes a progressBar-like overlay - see, eg, Tahoe
    if (this.showActiveTrack) this.updateActiveTrack();

    var innerLabel = this._valueLabel;

    if (innerLabel == null) return;

    //this.logWarn("_updateValueLabel - reason '" + reason + "'");

    // if there's a labelLayout, shrink it so it can overflow with the new,
    // potentially-formatted, value
    if (this.labelLayout) this.labelLayout.setWidth(1);
    if (this._valueLabelLayout) this._valueLabelLayout.setWidth(1);

    var value = this.getValue();

    // format the value for display in the valueLabel
    innerLabel.setContents(this.formatValue(value));

    var thumb = this._thumb,
        layoutContainer = this._valueLabelLayoutContainer,
        layout = this._valueLabelLayout
    ;

    if (layoutContainer) layoutContainer.deparent();
    else if (layout) layout.deparent();

    if ((layoutContainer && layoutContainer.isDrawn()) || layout.isDrawn()) {
        if (innerLabel.isDrawn()) innerLabel.redraw("sizing layout");
        else innerLabel.draw();
    }// else return;

    innerLabel.adjustForContent();

    // get the widget being positioned (a canvas or layout depending on this.vertical)
    var moveThis = layoutContainer || this._valueLabelLayoutContainer || this._valueLabelLayout;
    if (!moveThis) {
        this.logInfo("No label container.", "slider");
    }
    // make sure it's drawn
    if (!moveThis.isDrawn()) moveThis.draw();
    else moveThis.redraw();

    var labelWidth = moveThis.getVisibleWidth(),
        labelHeight = moveThis.getVisibleHeight(),
        thumbLeft = thumb.getPageLeft(),
        thumbTop = thumb.getPageTop(),
        thumbWidth = thumb.getVisibleWidth(),
        thumbHeight = thumb.getVisibleHeight(),
        pageScrollWidth = isc.Page.getScrollWidth(),
        pageScrollHeight = isc.Page.getScrollHeight(),
        hSpacing = this.hLabelSpacing == null ? this.labelSpacing : this.hLabelSpacing,
        vSpacing = this.vLabelSpacing == null ? this.labelSpacing : this.vLabelSpacing
    ;

    if (this.vertical) {
        var newTop = parseInt(thumbTop + (thumbHeight/2) - (labelHeight / 2));
        var newLeft = parseInt(thumbLeft - labelWidth - hSpacing);
        if (newTop + labelHeight > pageScrollHeight) {
            newTop = (pageScrollHeight - labelHeight) - 1;
        }
        moveThis.setPageRect(newLeft, newTop, labelWidth, labelHeight);
        if (this.visibleAtPoint(thumbLeft, newTop, true, [moveThis])) {
            moveThis.show();
        } else {
            moveThis.hide();
        }
    } else {

        var newLeft = parseInt(thumbLeft + (thumbWidth/2) - (labelWidth/2));
        var newTop = parseInt(thumbTop - labelHeight - vSpacing);
        if (newLeft + labelWidth > pageScrollWidth) {
            // don't overflow the page to the right
            newLeft = (pageScrollWidth - labelWidth) - 1;
        }
        moveThis.setPageRect(newLeft, newTop, labelWidth, labelHeight);

        // show the label if the top of the Slider is visible, directly above the thumb, but
        // inset by the margin, since visibleAtPoint() returns false for offsets in the margin
        var innerTop = this.getPageTop() + (this.getTopMargin() || 0);
        if (this.visibleAtPoint(thumbLeft, innerTop, true, [moveThis])) {
            moveThis.show();
        } else {
            moveThis.hide();
        }
    }

},


handleMouseUp : function() {

    if (this.valueChangedOnClick) this._thumbMove(true);
},

// get the thumb position from the supplied value, updating the value if requested
_getThumbPositionFromValue : function (newValue, setValue) {
    var rawValue, thumbOffset;
    if (!isc.isA.Number(newValue)) return;

    // Ensure minValue<=newValue<=maxValue.
    newValue = Math.max(this.minValue, (Math.min(newValue, this.maxValue)));

    // Set value, rounding if specified.
    newValue = this._getRoundedValue(newValue);
    if (setValue) this.value = newValue;

    // Calculate rawValue and resulting thumbOffset.
    if (this.minValue == this.maxValue) rawValue = 1;
    else rawValue = (newValue - this.minValue)/(this.maxValue - this.minValue);
    thumbOffset = rawValue * this._usableLength;

    // get the thumb position.
    if (this.vertical) {
        return this._track.getTop() +
            parseInt(this.flipValues ? thumbOffset : this._usableLength - thumbOffset);
    } else {
        return this._track.getLeft() +
            parseInt(this.flipValues ? this._usableLength - thumbOffset : thumbOffset);
    }
},


//------ setValue(newValue)
//> @method slider.setValue()   ([])
// Sets the slider value to newValue and moves the slider thumb to the appropriate position for this
// value. Sends the 'sliderMove' event to the sliderTarget.
//
// @param newValue (float) the new value
// <smartgwt><b>Note:</b>Use Doubles rather Floats when manipulating decimal
// values.  See +link{group:gwtFloatVsDouble} for details</smartgwt>
// @param noAnimation (boolean) do not animate the slider thumb to the new value
// @visibility external
//<
setValue : function (newValue, noAnimation, noValueChange) {

    var thumbPosition = this._getThumbPositionFromValue(newValue, true);
    if (thumbPosition == null) return;

    // Set the thumb position.
    if (this.vertical) {
        if (this.animateThumb && !noAnimation) {
            this._thumbAnimation = this._thumb.animateMove(this._thumb.getLeft(), thumbPosition,
                null, this.animateThumbTime, this.animateThumbAcceleration);
        } else {
            this._thumb.setTop(thumbPosition);
        }
    } else {
        if (this.animateThumb && !noAnimation) {
            this._thumbAnimation = this._thumb.animateMove(thumbPosition, this._thumb.getTop(),
                null, this.animateThumbTime, this.animateThumbAcceleration);
        } else {
            this._thumb.setLeft(thumbPosition);
        }
    }

    if (!noValueChange) {
        // fires observable valueChanged() method and updates activeTrack
        this.handleValueChanged(this.value);
    }

    if (this.sliderTarget) isc.EventHandler.handleEvent(this.sliderTarget, isc.Slider.EVENTNAME, this);
},

//------ getValue()
//>    @method    slider.getValue()   ([])
// Returns the current slider value.
//
// @return    (float)    current slider value
// <smartgwt><b>Note:</b>Use Doubles rather Floats when manipulating decimal
// values.  See +link{group:gwtFloatVsDouble} for details</smartgwt>
// @visibility external
//<
getValue : function () {
    return this.value;
},


//------ valueChanged()
//> @method slider.valueChanged() (A)
// This method is called when the slider value changes. This occurs when the +link{Slider.setValue(),setValue()}
// method is called, or when the slider is moved. <smartclient>Observe this method to be notified when
// </smartclient><smartgwt>Add a notification to be fired whenever </smartgwt>the slider value
// changes.
//
// @param value (double) the new value.
// @see method:class.observe
// @visibility external
// @example slider
//<
valueChanged : function (value) {
},

// handleValueChanged updates the UI (activeTrack) and fires the observable valueChanged() method
handleValueChanged : function (value) {
    this.valueChanged(value);
    this.updateActiveTrack();
},

//> @method slider.valueIsChanging()   ([A])
// Call this method in your +link{slider.valueChanged()} handler to determine whether the
// value change is due to an ongoing drag interaction (true) or due to a thumb-release,
// mouse click, keypress, or programmatic event (false). You may choose to execute temporary or
// partial updates while the slider thumb is dragged, and final updates or persistence of the value
// in response to the other events.
//
// @return  (Boolean)   true if user is still dragging the slider thumb, false otherwise
//
// @visibility external
//<

valueIsChanging : function () {
    var EH = this.ns.EH;
    return (EH.dragging && this._thumb === EH.dragTarget);
},


// HandleKeyPress:
// If Home, End, or the arrow keys are pressed while this slider has focus, move the slider
// appropriately.
// 20050912: Thumb animation is explicitly disabled by setting the noAnimation parameter of
// setValue(), because the thumb jumps around when one of the arrow keys is held down. Not worth
// tracking down, since the effect is already pretty close to an animation in this case.
handleKeyPress : function (event, eventInfo) {

    var keyName = event.keyName;

    // Note: if this.flipValues is true, vertical sliders will start at the top, and increase
    // toward the bottom, horizontal sliders will start at the right and increase towards the
    // left

    // "Home" will move the slider all the way to the min value (may be either end depending on
    // flipValues)
    if (keyName == "Home") {
        this.setValue(this.minValue, true);
        return false;
    }
    // "End" will move the slider all the way to the max value
    if (keyName == "End") {
        this.setValue(this.maxValue, true);
        return false;
    }

    // If an arrow key was pressed, move the slider one step in the direction indicated

    // Calculate one step from this.stepPercent:
    var change = (this.maxValue - this.minValue) * this.stepPercent / 100;
    // if roundValues is enabled, ensure we always move (a change < 1 could be rounded to no
    // change)
    if (this.roundValues && change < 1) change = 1;

    if (this.vertical) {
        if ((this.flipValues && keyName == "Arrow_Up") ||
            (!this.flipValues && keyName == "Arrow_Down"))
        {
            this.setValue(this.getValue() - change, true);
            return false;

        } else if ( (this.flipValues && keyName == "Arrow_Down") ||
                    (!this.flipValues && keyName == "Arrow_Up"))
        {
            this.setValue(this.getValue() + change, true);
            return false
        }

    } else {
        if ((this.flipValues && keyName == "Arrow_Left") ||
            (!this.flipValues && keyName == "Arrow_Right"))
        {
            this.setValue(this.getValue() + change, true)
            return false;

        } else if ( (this.flipValues && keyName == "Arrow_Right") ||
                    (!this.flipValues && keyName == "Arrow_Left"))
        {
            this.setValue(this.getValue() - change, true)
            return false;
        }
    }

    if (this.keyPress) {
        this.convertToMethod("keyPress");
        return this.keyPress(event, eventInfo);
    }
},

// override setCanFocus to set the canFocus property on the track and the thumb as well
setCanFocus : function (canFocus) {
    this.Super("canFocus", arguments);
    if (this._thumb != null) this._thumb.setCanFocus(canFocus);
    if (this._track != null) this._track.setCanFocus(canFocus);

},

//>    @method    slider.setMinValue()   ([])
// Sets the +link{slider.minValue, minimum value} of the slider
//
// @param newValue (float) the new minimum value
// <smartgwt><b>Note:</b>Use Doubles rather Floats when manipulating decimal
// values.  See +link{group:gwtFloatVsDouble} for details</smartgwt>
// @visibility external
//<
setMinValue : function (newValue) {
    newValue = this._getRoundedValue(newValue);
    this.minValue = newValue;
    if (this._minLabel) this._minLabel.setContents(newValue);
    // only update the current value if it's less than the new minValue
    if (this.getValue() < this.minValue) this.setValue(this.minValue);
},

//>    @method    slider.setMaxValue()   ([])
// Sets the +link{slider.maxValue, maximum value} of the slider
//
// @param newValue (float) the new maximum value
// <smartgwt><b>Note:</b>Use Doubles rather Floats when manipulating decimal
// values.  See +link{group:gwtFloatVsDouble} for details</smartgwt>
// @visibility external
//<
setMaxValue : function (newValue) {
    // If we're rounding, round the min/max value as well

    newValue = this._getRoundedValue(newValue);
    this.maxValue = newValue;
    if (this._maxLabel) this._maxLabel.setContents(newValue);
    // only update the current value if it's larger than the new maxValue
    if (this.getValue() > this.maxValue) this.setValue(this.maxValue);
},

//>    @method    slider.setNumValues()   ([])
// Sets the +link{slider.numValues, number of values} for the slider
//
// @param newNumValues (Integer) the new number of values
// <smartgwt><b>Note:</b>Use Doubles rather Floats when manipulating decimal
// values.  See +link{group:gwtFloatVsDouble} for details</smartgwt>
// @visibility external
//<
setNumValues : function (newNumValues) {
    this.numValues = newNumValues;
    this.numStops = this.numValues - 1;
    if (this.numStops == 0) this.numStops = 1;
    // divide by the number of stops
    this._stepSize = this._usableLength/this.numStops;
    this.setValue(this.minValue);
},

//> @method slider.setTitle()
// Sets the +link{title} of the slider
//
// @param newTitle (String) new title for the slider
// @visibility external
//<
setTitle : function (newTitle) {
    this._titleLabel.setContents(newTitle);
},

//> method slider.setLength()
// Sets the +link{length} of the slider
//
// @param newLength (number) the new length to set the slider to
// @visibility external
//<
setLength : function (newLength) {
    this.length = newLength;
    this.setUpSize();
},


//> @method slider.setVertical()
// Sets the +link{vertical} property of the slider
//
// @param isVertical (boolean) is the slider vertical
// @visibility external
//<
setVertical : function (isVertical) {
    this.vertical = isVertical;

    // Reset length so it can be recalculated if needed
    this.length = this._userLength;
    this._userWidth = this._userHeight = null;

    this._refreshChildren();
},

_getThumbThickWidth : function () {
    return (isc.Browser.isTouch && this.touchThumbThickWidth != null ? this.touchThumbThickWidth : this.thumbThickWidth);
},

//> @method slider.setThumbThickWidth()
// Sets the +link{thumbThickWidth} property of the slider
//
// @param newWidth (int) new thumbThickWidth
// @visibility external
//<
setThumbThickWidth : function (newWidth) {
    this.thumbThickWidth = newWidth;
    this._refreshChildren();
},

_getThumbThinWidth : function () {
    return (isc.Browser.isTouch && this.touchThumbThinWidth != null ? this.touchThumbThinWidth : this.thumbThinWidth);
},

//> @method slider.setThumbThinWidth()
// Sets the +link{thumbThinWidth} property of the slider
//
// @param newWidth (int) new thumbThinWidth
// @visibility external
//<
setThumbThinWidth : function (newWidth) {
    this.thumbThinWidth = newWidth;
    this._refreshChildren();
},

//> @method slider.setTrackWidth()
// Sets the +link{trackWidth} property of the slider
//
// @param newWidth (int) new trackWidth
// @visibility external
//<
setTrackWidth : function (newWidth) {
    this.trackWidth = newWidth;
    this._refreshChildren();
},

//> @method slider.setThumbSrc()
// Sets the +link{thumbSrc} property of the slider
//
// @param newSrc (String) new thumbSrc
// @visibility external
//<
setThumbSrc : function (newSrc) {
    this.thumbSrc = newSrc;
    this._refreshChildren();
},

//> @method slider.setTrackSrc()
// Sets the +link{trackSrc} property of the slider
//
// @param newSrc (String) new trackSrc
// @visibility external
//<
setTrackSrc : function (newSrc) {
    this.trackSrc = newSrc;
    this._refreshChildren();
},

//> @method slider.setTrackCapSize()
// Sets the +link{trackCapSize} property of the slider
//
// @param newSize (int) new trackCapSize
// @visibility external
//<
setTrackCapSize : function (newSize) {
    this.trackCapSize = newSize;
    this._refreshChildren();
},

//> @method slider.setTrackImageType()
// Sets the +link{trackImageType} property of the slider
//
// @param newType (ImageStyle) new trackImageType
// @visibility external
//<
setTrackImageType : function (newType) {
    this.trackImageType = newType;
    this._refreshChildren();
},

//> @method slider.setShowTitle()
// Sets the +link{showTitle} property of the slider
//
// @param showTitle (Boolean) show the slider title?
// @visibility external
//<
setShowTitle : function (showTitle) {
    this.showTitle = showTitle;
    this._refreshChildren();
},

//> @method slider.setShowRange()
// Sets the +link{showRange} property of the slider
//
// @param showRange (boolean) show the slider range?
// @visibility external
//<
setShowRange : function (showRange) {
    this.showRange = showRange;
    this._refreshChildren();
},

//> @method slider.setShowValue()
// Sets the +link{showValue} property of the slider
//
// @param showValue (boolean) show the slider value?
// @visibility external
//<
setShowValue : function (showValue) {
    this.showValue = showValue;
    this._refreshChildren();
},

//> @method slider.setLabelWidth()
// Sets the +link{labelWidth} property of the slider
//
// @param labelWidth (int) new label width
// @visibility external
//<
setLabelWidth : function (labelWidth) {
    this.labelWidth = labelWidth;
    this._refreshChildren();
},

//> @method slider.setLabelHeight()
// Sets the +link{labelHeight} property of the slider
//
// @param newHeight (int) new label height
// @visibility external
//<
setLabelHeight : function (newHeight) {
    this.labelHeight = newHeight;
    this._refreshChildren();
},

//> @method slider.setLabelSpacing()
// Sets the +link{labelSpacing} property of the slider
//
// @param labelWidth (int) new label spacing
// @visibility external
//<
setLabelSpacing : function (newSpacing) {
    this.labelSpacing = newSpacing;
    this._refreshChildren();
},

//> @method slider.setMaxValueLabel()
// Sets the +link{maxValueLabel} property of the slider
//
// @param labelText (String) new label text
// @visibility external
//<
setMaxValueLabel : function (labelText) {
    this._maxLabel.setContents(labelText);
},

//> @method slider.setRoundValues()
// Sets the +link{roundValues} property of the slider
//
// @param roundValues (boolean) round slider values?
// @visibility external
//<
setRoundValues : function (roundValues) {
    this.roundValues = roundValues;
    this._refreshChildren();
},

//> @method slider.setRoundPrecision()
// Sets the +link{roundPrecision} property of the slider
//
// @param roundPrecision (int) new round precision
// @visibility external
//<
setRoundPrecision : function (roundPrecision) {
    this.roundPrecision = roundPrecision;
    this._refreshChildren();
},

//> @method slider.setFlipValues()
// Sets the +link{flipValues} property of the slider
//
// @param flipValues (boolean) flip slider values?
// @visibility external
//<
setFlipValues : function (flipValues) {
    this.flipValues = flipValues;
    this._refreshChildren();
},

//> @method slider.setStepPercent()
// Sets the +link{stepPercent} property of the slider
//
// @param stepPercent (float) new slider step percent
// @visibility external
//<
setStepPercent : function (stepPercent) {
    this.stepPercent = stepPercent;
    this._refreshChildren();
}

});


isc.Slider.registerStringMethods({
    valueChanged : "value"
})

//!<Deferred





//> @class RangeSlider
// A "double slider" allowing the user to select a range via two draggable thumbs.
//
// @inheritsFrom Canvas
//@treeLocation Client Reference/Control
//
// @visibility external
//<

//> @attr rangeSlider.startThumb (AutoChild Snapbar : null : IR)
// Thumb for the start of the range.
//
// @visibility external
//<

//> @attr rangeSlider.endThumb (AutoChild Snapbar : null : IR)
// Thumb for the end of the range
//
// @visibility external
//<

//> @method rangeSlider.changed()
// Notification fired when the selected range is changed by the end user.
//
// @param startValue (float) new start value
// @param endValue (float) new end value
// @param isDragging (boolean) whether the user is still in the middle of a drag, so that
//  expensive operations can be avoided if needed
//
// @visibility external
//<

//> @attr rangeSlider.track (AutoChild Canvas : null : IR)
// Optional track of the RangeSlider.  Set <code>showTrack</code> false to avoid showing
// a track so the RangeSlider can be superimposed over something else.
//
// @visibility external
//<

//> @attr rangeSlider.scrollbar (AutoChild Scrollbar : null : IR)
// Optional Scrollbar shown as a second way of adjusting the range.
//
// @visibility external
//<

isc.defineClass("RangeSlider", isc.Canvas);

isc.RangeSlider.addClassProperties({

    _epsilon: 1e-6
});

isc.RangeSlider.addProperties ({

//> @attr rangeSlider.vertical (boolean : false : IR)
// Whether the rangeSlider should be vertical or horizontal.  Default is horizontal.
//
// @visibility external
//<
    vertical: false,

//> @attr rangeSlider.minValue (float : 0 : IRW)
// Set the minimum value (left/top of slider).
//
// @visibility external
//<
    minValue: 0,

//> @attr rangeSlider.maxValue (float : 0 : IRW)
// Set the maximum value (right/bottom of slider).
//
// @visibility external
//<
    maxValue: 0,

//> @attr rangeSlider.startValue (float : 0 : IRW)
// The beginning of the selected range.
//
// @visibility external
//<
    startValue: 0,

//> @attr rangeSlider.endValue (float : 0 : IRW)
// The end of the selected range.
//
// @visibility external
//<
    endValue:0,

 //> @attr rangeSlider.baseStyle (CSSStyleName : "rangeSlider" : IR)
 // Base style name for CSS styles applied to the background of the rangeSlider.  The following
 // suffixes are applied for different areas of the slider:
 // <ul>
 // <li> "Start": area of the slider before the startThumb
 // <li> "Selected": area of the slider between the thumbs (the selected range)
 // <li> "End": area of the slider after the endThumb
 // </ul>
 // .. and the following suffixes are applied in addition according to the slider's dynamic state:
 // <ul>
 // <li> "Over": if the mouse is over the segment
 // <li> "Down": if the mouse is down on the segment
 // </ul>
 // For example, if the mouse is down in the area before the start thumb, that area will have the
 // CSS style "rangeSliderStartDown".
 //
 // @visibility external
 //<
    baseStyle:"rangeSlider",

    overflow:"hidden",
    thumbSize: 7,

    labelStartDefaults: {
        _constructor:isc.Label,
        wrap:false,
        overflow:"hidden"
    },

    startThumbDefaults: {
        _constructor:isc.Snapbar,
        wrap:false,
        overflow:"hidden",
        canDrag:true,
        keepInParentRect: true,
        canCollapse:false,
        showGrip:true,
        showClosedGrip:false,
        _canDragWhenTargetIsHidden:true,

        dragStart : function() {
            this.creator.oldStartValue = this.creator.startValue;
            this.creator.dragpoint = this.creator.vertical?isc.Event.mouseDownEvent.y:isc.Event.mouseDownEvent.x;

            this.creator.isDragging = true;

            this.creator.fireChangedEvent();
        },

        dragMove : function() {
            // get pixel range and convert it to value range
            var val = this.creator.vertical?this.creator.getValuesForPixels(isc.Event.lastEvent.y-this.creator.dragpoint):
                this.creator.getValuesForPixels(isc.Event.lastEvent.x-this.creator.dragpoint);

            this.creator.setStartValue(this.creator.oldStartValue+val);

            this.creator.fireChangedEvent();

            return true;
        },

        dragStop : function() {
            this.creator.isDragging = false;
            this.creator.fireChangedEvent();
        }
     },

    labelDragDefaults: {
        _constructor:isc.Label,
        overflow:"hidden",
        canDrag:true,
        keepInParentRect: true,
        dragAppearance:"none",

        dragMove : function() {

            // get pixel range and convert it to value range
            var val = this.creator.vertical?this.creator.getValuesForPixels(isc.Event.lastEvent.y-this.creator.dragpoint):
                this.creator.getValuesForPixels(isc.Event.lastEvent.x-this.creator.dragpoint);

            this.creator.setValues(this.creator.oldStartValue+val, this.creator.oldEndValue+val);

            this.creator.fireChangedEvent();

            return true;
        },

        dragStart : function() {
            this.creator.oldStartValue = this.creator.startValue;
            this.creator.oldEndValue = this.creator.endValue;

            this.creator.dragpoint = this.creator.vertical?isc.Event.mouseDownEvent.y:isc.Event.mouseDownEvent.x;

            this.creator.isDragging = true;

            this.creator.fireChangedEvent();
        },

        dragStop : function() {
            this.creator.isDragging = false;

            this.creator.fireChangedEvent();
        }
    },

    labelEndDefaults: {
        _constructor:isc.Label,
        overflow:"hidden"
    },

    endThumbDefaults: {
        _constructor:isc.Snapbar,
        canDrag:true,
        overflow:"hidden",
        keepInParentRect: true,
        canCollapse:false,
        showGrip:true,
        _canDragWhenTargetIsHidden:true,

        dragStart : function() {
            this.creator.oldEndValue = this.creator.endValue;
            this.creator.dragpoint = this.creator.vertical?isc.Event.mouseDownEvent.y:isc.Event.mouseDownEvent.x;

            this.creator.isDragging = true;
            this.creator.fireChangedEvent();
        },

        dragMove : function() {
            // get pixel range and convert it to value range
            var val = this.creator.vertical?this.creator.getValuesForPixels(isc.Event.lastEvent.y-this.creator.dragpoint):
                this.creator.getValuesForPixels(isc.Event.lastEvent.x-this.creator.dragpoint);

            this.creator.setEndValue(this.creator.oldEndValue+val);

            if (this.creator.scrollbar) {
                this.creator.scrollbar.moveThumb();
            }

            this.creator.fireChangedEvent();
            return true;
        },


        dragStop : function() {
            this.creator.isDragging = false;

            this.creator.fireChangedEvent();
        }
     },


    scrollbarDefaults: {
        thumbDragStop : function() {
            this.Super("thumbDragStop",    arguments);
            this.creator.thumbdragging = false;
            this.creator.isDragging = false;

            this.creator.updatePositions();
            this.creator.fireChangedEvent();
        },

        thumbDragStart : function() {
            this.Super("thumbDragStart",    arguments);
            this.creator.thumbdragging = true;
            this.creator.isDragging = true;

            this.creator.oldStartValue = this.creator.startValue;
            this.creator.oldEndValue = this.creator.endValue;

            this.creator.dragpoint = this.getEventCoord();
            this.creator.fireChangedEvent();
        }
    }
});

isc.RangeSlider.addClassMethods({

    init : function (a, b, c) {
        this.invokeSuper(isc.RangeSlider, "init", a, b, c);
        if (this != isc.RangeSlider || !isc.Snapbar) return;

        var proto = isc.RangeSlider.getPrototype(),
            gripBreadth = isc.Snapbar.getPrototype().gripBreadth;
        proto.thumbSize = Math.max(proto.thumbSize, gripBreadth);
    }
});

isc.RangeSlider.addProperties({

    // Always use Scrollbar rather than NativeScrollbar
    // even if the default is changed for Canvas

    scrollbarConstructor:"Scrollbar",
    nativeAutoHideScrollbars:false

});

isc.RangeSlider.addMethods ({

    initWidget : function() {
        this.Super("initWidget", arguments);

        // value sanity checks
        if (this.maxValue < this.minValue) {
            var x = this.minValue;
            this.minValue = this.maxValue;
            this.maxValue = x;
        }

        if (this.startValue < this.minValue) {
            this.startValue = this.minValue;
        }

        if (this.endValue > this.maxValue) {
            this.endValue = this.endValue;
        }

        // lazily initialize track defaults
        if (!this.trackDefaults) {
            isc.RangeSlider.setInstanceProperty("trackDefaults", this.getTrackDefaults());
        }

        // create the controls either vertically or horizontally
        if (this.vertical) {
            this.createControls(true);
        }
        else {
            this.createControls();
        }
    },

    // return the default properties for the track.
    getTrackDefaults : function() {

        return {
            overflow:"hidden",
            showDisabled:true,
            cacheImageSizes: false,
            _constructor:isc.Slider.getInstanceProperty("trackConstructor"),
            capSize:isc.Slider.getInstanceProperty("trackCapSize"),
            skinImgDir:isc.Slider.getInstanceProperty("skinImgDir"),
            imageType:isc.Slider.getInstanceProperty("trackImageType"),
            trackSrc : isc.Slider.getInstanceProperty("trackSrc")
        };
    },

    // overwrite resized so track size and thumb positions are updated on resize
    resized : function() {
        this.Super("resized", arguments);

        if (this.showTrack) {
            if (this.vertical) {
                this.track.setWidth(isc.Slider.getInstanceProperty("trackWidth"));
                this.track.setHeight(this.height);
            } else {
                this.track.setHeight(isc.Slider.getInstanceProperty("trackWidth"));
                this.track.setWidth(this.width);
            }
        }

        this.updatePositions();
    },

    // create the child controls and set up the callback functions
    createControls : function(vertical) {
        var that =  this;
        var remaining;
        var trackWidth = isc.Slider.getInstanceProperty("trackWidth");

        if (vertical) {
            this.scrollbar = this.addAutoChild("scrollbar", {
                vertical:true,
                height:"100%"
            });

            if (this.scrollbar) {
                remaining = this.getWidth() - this.scrollbar.getWidth();
                this.scrollbar.setLeft(remaining);
                this.scrollbar.setTop(0);
            } else {
                remaining = this.getWidth()
            }

            this.labelStart = this.addAutoChild("labelStart", {
                width:remaining,
                baseStyle:this.baseStyle+"Start"
            });

            this.labelDrag = this.addAutoChild("labelDrag", {
                width:remaining,
                baseStyle:this.baseStyle+"Selected"
            });

            this.labelEnd = this.addAutoChild("labelEnd", {
                width:remaining,
                baseStyle:that.baseStyle+"End"
            });

            this.startThumb = this.addAutoChild("startThumb", {
                height:this.thumbSize,
                width:remaining,
                target:this.labelStart,
                vertical:false
            });

            this.endThumb = this.addAutoChild("endThumb", {
                height:this.thumbSize,
                width:remaining,
                target:this.labelEnd,
                vertical:false,

                makeLabel:function() {
                    this.Super("makeLabel", arguments);
                    this.label.addMethods({
                        getCustomState : function () {
                            // don't show closed state if showClosedGrip is set to false
                            if (isc.Snapbar.getInstanceProperty("showClosedGrip")) {
                                return "closed";
                            }
                        }
                    });
                }
            });

            this.track = this.addAutoChild("track", {
                left:Math.round(remaining/2-trackWidth/2),
                width:trackWidth,
                height:this.height,
                vertical:this.vertical,

                src:"[SKIN]"+(this.vertical? "v" : "h")+isc.Slider.getInstanceProperty("trackSrc"),
                styleName:isc.Slider.getInstanceProperty((this.vertical ? "v" : "h") + "TrackStyle")
            });
        } else {
            this.scrollbar = this.addAutoChild("scrollbar", {
                vertical:false,
                width:"100%"
            });

            if (this.scrollbar) {
                remaining = this.getHeight() - this.scrollbar.getHeight();
                this.scrollbar.setLeft(0);
                this.scrollbar.setTop(remaining);
            } else {
                remaining = this.getHeight();
            }

            this.labelStart = this.addAutoChild("labelStart", {
                height:remaining,
                baseStyle:this.baseStyle+"Start"
            });

            this.labelDrag = this.addAutoChild("labelDrag", {
                height:remaining,
                baseStyle:this.baseStyle+"Selected"
            });

            this.labelEnd = this.addAutoChild("labelEnd", {
                height:remaining,
                baseStyle:this.baseStyle+"End"
            });

            this.startThumb = this.addAutoChild("startThumb", {
                width:this.thumbSize,
                height:remaining,
                target:this.labelStart
            });

            this.endThumb = this.addAutoChild("endThumb", {
                width:this.thumbSize,
                height:remaining,
                target:this.labelEnd,

                makeLabel:function() {
                    this.Super("makeLabel", arguments);
                    this.label.addMethods({
                        getCustomState : function () {
                            // don't show closed state if showClosedGrip is set to false
                            if (isc.Snapbar.getInstanceProperty("showClosedGrip")) {
                                return "closed";
                            }
                        }
                    });
                }
            });

            this.track = this.addAutoChild("track", {
                top:Math.round(remaining/2-trackWidth/2),
                height:trackWidth,
                width:this.width,
                vertical:this.vertical,

                src:"[SKIN]"+(this.vertical? "v" : "h")+isc.Slider.getInstanceProperty("trackSrc"),
                styleName:isc.Slider.getInstanceProperty((this.vertical ? "v" : "h") + "TrackStyle")
            });

        };

        if (this.track) {
            this.track.sendToBack();
        }

        if (this.scrollbar) {
            this.scrollbar.setScrollTarget(this);
        }

        this.updatePositions();

    },

    // called when mouse-up happens on the control.
    // this is not called when dragging happens
    mouseUp : function() {

        if (this.vertical) {
            var val = this.getOffsetY()-this.startThumb.getHeight();
        } else {
            var val = this.getOffsetX()-this.startThumb.getWidth();
        }

        this.slideSelectedRangeByPoints(val);

        this.fireChangedEvent();
    },

    // slide the selected range to so it's middle point will be at given point
    // values are clamped at  [minValue,maxValue] range
    slideSelectedRangeByPoints : function (pixels) {
        var val = this.getValuesForPixels(pixels);

        // compute it's middle value
        var avg = (this.endValue-this.startValue)/2;

        // simulate dragging so values are clamped instead of ignored if they're
        // outside of bounds
        this.isDragging = true;

        this.setValues(val-avg+this.minValue, val+avg+this.minValue);

        this.isDragging = false;
    },

    // this is called when the user drags the scrollbar
    // scroll the scrollbar to a ratio. If the scrollbar is at either one of its
    // ends, then the entire selected range is slided out - if dragging - or
    // it has both startValue and endValue 0,0 or maxValue, maxValue
    scrollToRatio : function(vertical, ratio, reason) {

        // compute the ratio of how much was thumb dragged vs the track size, since
        // we need to know how much we need to move the selected range towards min or max value

        var dragratio = (this.scrollbar.getEventCoord() - this.dragpoint)/(this.scrollbar.trackSize());
        var val = this.getValueForScrollRatio(dragratio);
        this.setValues(this.oldStartValue+val,this.oldEndValue+val);

        this.fireChangedEvent();
    },

    // scroll by a small amount (20px) when scroll buttons are clicked
    scrollByDelta : function(vertical, direction, reason) {
        var range = this.endValue-this.startValue;

        // compute the value/pixel ratio, without the width/height of the splitter bars
        if (this.vertical) {
            var w = this.getHeight()-this.startThumb.getHeight()-this.endThumb.getHeight();

        } else {
            var w = this.getWidth()-this.startThumb.getWidth()-this.endThumb.getWidth();
        }

        var ratio =  (this.maxValue-this.minValue)/w;

        // compute how much of range is 20 pixels and move the range
        var amount = 20*ratio*direction;

        var start = this.startValue + amount;
        var end = this.endValue + amount;

        // make sure when end is reached, rage is not changed
        if (start<this.minValue) {
            start = this.minValue;
            end = this.minValue + range;
        }

        if (end>this.maxValue) {
            end = this.maxValue;
            start = this.maxValue-range;
        }

        this.isDragging = true;

        this.setValues(start, end);
        this.isDragging = false;
        this.fireChangedEvent();
    },

    // scroll by a viewport (the selected range)
    scrollByPage : function(vertical, direction, reason) {
        // compute the width of viewport and either add it or remove it from
        // the start value and end value
        var amount = Math.max((this.endValue-this.startValue),0)*direction;

        var start = this.startValue + amount;
        var end = this.endValue + amount;

        // make sure when end is reached, rage is not changed
        if (start<this.minValue) {
            start = this.minValue;
            end = this.minValue + Math.abs(amount);
        }

        if (end>this.maxValue) {
            end = this.maxValue;
            start = this.maxValue-Math.abs(amount);
        }

        this.isDragging = true;

        this.setValues(start, end);
        this.isDragging = false;
        this.fireChangedEvent();
    },


    getViewportRatio : function (vertical) {
        var range = this.maxValue - this.minValue,
            selectedRange = 0;
        if (this.thumbdragging) {
            selectedRange = this.oldEndValue - this.oldStartValue;
        } else {
            selectedRange = this.endValue - this.startValue;
        }
        return (Math.abs(range) < isc.RangeSlider._epsilon ? 0 : selectedRange / range);
    },


    getScrollRatio : function (vertical) {
        var range = this.maxValue - this.minValue,
            selectedRange = this.endValue - this.startValue;
        return (
            Math.abs(range - selectedRange) < isc.RangeSlider._epsilon
                ? 0 : (this.startValue - this.minValue) / (range - selectedRange));
    },

    // Convert a scroll ratio to a value.
    getValueForScrollRatio : function(val) {
        return val * (this.maxValue - this.minValue);
    },

    // convert a length in pixels in length in values
    getValuesForPixels : function(val) {

        if (this.vertical) {
            return val*(this.maxValue-this.minValue)/(this.getHeight());
        }
        else {
            return val*(this.maxValue-this.minValue)/(this.getWidth());
        }
    },

    // recompute the position of all components according to the current
    // minValue, maxValue, startValue, endValue
    // this will implicitly resize also the scrollbar in concordance with
    // the ratio of the selected range vs minValue-maxValue range
    updatePositions : function() {

        // compute the pixel/value ratio, without the width/height of the splitter bars
        if (this.vertical) {
            var w = this.getHeight()-this.startThumb.getHeight()-this.endThumb.getHeight();

        } else {
            var w = this.getWidth()-this.startThumb.getWidth()-this.endThumb.getWidth();
        }

        // make sure we have a valid ratio and we don't divide by 0 if this.minValue = this.maxValue
        var ratio = 0;

        if (this.maxValue-this.minValue > 0) {
            ratio =  w/(this.maxValue-this.minValue);
        }

        // compute the width of each segment
        var d1 = Math.round((this.startValue-this.minValue)*ratio);
        var d2 = Math.round((this.endValue-this.startValue)*ratio);
        var d3 = Math.round((this.maxValue-this.endValue)*ratio);
        var sum = Math.round((this.startValue-this.minValue+this.endValue-this.startValue)*ratio);

        if (this.vertical) {

            if (d1 == 0) {
                this.startThumb.target = this.labelDrag;
            } else {
                this.labelStart.show();

                this.labelStart.setTop(0);
                this.labelStart.setHeight(d1);
            }

            if (d2 == 0) {
                this.labelDrag.hide();
            } else {
                this.labelDrag.show();
                this.labelDrag.setHeight(d2);
                this.labelDrag.setTop(d1+this.startThumb.getHeight());
            }

            if (d3 == 0) {
                this.labelEnd.hide();
            } else {
                this.labelEnd.show();
                this.labelEnd.setTop(sum+this.startThumb.getHeight()+this.endThumb.getHeight());
                this.labelEnd.setHeight(d3);
            }

            this.startThumb.setTop(d1);
            this.endThumb.setTop(sum+this.startThumb.getHeight());
        }
        else {

            if (d1 == 0) {
                this.labelStart.hide();
            }
            else {
                this.labelStart.show();

                this.labelStart.setLeft(0);
                this.labelStart.setWidth(d1);
            }

            if (d2 == 0) {
                this.labelDrag.hide();
            }
            else {
                this.labelDrag.show();

                this.labelDrag.setWidth(d2);
                this.labelDrag.setLeft(d1+this.startThumb.getWidth());
            }


            if (d3 == 0) {
                this.labelEnd.hide();
            } else {
                this.labelEnd.show();

                this.labelEnd.setLeft(sum+this.startThumb.getWidth()+this.endThumb.getWidth());
                this.labelEnd.setWidth(d3);
            }

            this.startThumb.setLeft(d1);
            this.endThumb.setLeft(sum+this.startThumb.getWidth());
        }

        if (this.scrollbar) {
            this.scrollbar.setThumb();
        }
    },

    // clamp a given value to the allowed [minValue maxValue] range
    clampToMinMax : function (value) {
        if (value<=this.minValue) {
            value = this.minValue;
        }
        if (value >= this.maxValue) {
            value = this.maxValue;
        }

        return value;
    },

    // check if a value is in the allowed [minValue maxValue] range
    isInMinMaxRange : function(value) {
        if (value<this.minValue) {
            return false;
        }
        if (value > this.maxValue) {
            return false;
        }

        return true;
    },

    // set both startValue and endValue of the selected area simultaneously.
    // if change of values occurs while dragging , then we're clamping to
    // [minValue maxValue] range
    // if no dragging occurs, then change is made by user request and we accept
    setValues : function (startv, endv) {

        if (this.isDragging) {
            startv = this.clampToMinMax(startv);
            endv = this.clampToMinMax(endv);

            this.startValue = startv;
            this.endValue = endv;

            this.updatePositions();
        } else {
            if (this.isInMinMaxRange(startv) && this.isInMinMaxRange(endv) &&
                    startv<=endv) {
                this.startValue = startv;
                this.endValue = endv;

                this.updatePositions();
            }

            // otherwise ignore
        }
    },

    // if change of startValue occurs while dragging , then we're clamping to
    // [minValue maxValue] range
    // if no dragging occurs, then change is made by user request and we accept
    // the values only if they're legal
    setStartValue : function (value) {

        if (this.isDragging) {
            value = this.clampToMinMax(value);
            if (value >= this.endValue) {
                value =  this.endValue;
            }
            this.startValue = value;
            this.updatePositions();
        } else {
            if (this.isInMinMaxRange(value) && value <= this.endValue) {
                this.startValue = value;
                this.updatePositions();
            } else {
                isc.logWarn("Ignoring setStartValue to "+value+" (out of range).");
            }
        }
    },

    // if change of endValue occurs while dragging , then we're clamping to
    // [minValue maxValue] range
    // if no dragging occurs, then change is made by user request and we accept
    // the values only if they're legal
    setEndValue : function( value ) {
        if (this.isDragging) {
            value = this.clampToMinMax(value);
            if (value <= this.startValue) {
                value =  this.startValue;
            }
            this.endValue = value;
            this.updatePositions();
        } else {
            if (this.isInMinMaxRange(value) && value >= this.startValue) {
                this.endValue = value;
                this.updatePositions();
            } else {
                isc.logWarn("Ignoring setEndValue to "+value+" (out of range).");
            }
        }
    },

    getStartValue : function() {
        return this.startValue;
    },

    getEndValue : function() {
        return this.endValue;
    },

    setMinValue : function(value) {
        this.minValue = value;
        this.updatePositions();
    },

    setMaxValue : function (value) {
        this.maxValue = value;
        this.updatePositions();
    },

    getMinValue : function() {
        return this.minValue;
    },

    getMaxValue : function() {
        return this.maxValue;
    },

    fireChangedEvent : function() {
        this.changed(this.startValue, this.endValue, this.isDragging);
    },

    changed : function (startValue, endValue, isDragging) {}
});



(function() {
    var window = {};


/*
The following code is the unchanged, original code of the tinycolor library by Brian Grinstead,
modified only by whitespace stripping and automated obfuscation.  This code, up to the end
marker "=== END ===", is available under the MIT license, reproduced below.

All surrounding code, and all other code that may be delivered together with tinycolor, is
governed by the copyright statements at the top of this file and other files.

The tinycolor project can be found here:

    https://github.com/bgrins/TinyColor/

Isomorphic thanks Brian Grinstead for his excellent work!
*/

/*
Copyright (c), Brian Grinstead, http://briangrinstead.com

Permission is hereby granted, free of charge, to any person obtaining
a copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be
included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
/*
// TinyColor v1.4.1
// https://github.com/bgrins/TinyColor
// Brian Grinstead, MIT License
*/

(function(Math) {

var trimLeft = /^\s+/,
    trimRight = /\s+$/,
    tinyCounter = 0,
    mathRound = Math.round,
    mathMin = Math.min,
    mathMax = Math.max,
    mathRandom = Math.random;

function tinycolor (color, opts) {

    color = (color) ? color : '';
    opts = opts || { };

    // If input is already a tinycolor, return itself
    if (color instanceof tinycolor) {
       return color;
    }
    // If we are called as a function, call using new instead
    if (!(this instanceof tinycolor)) {
        return new tinycolor(color, opts);
    }

    var rgb = inputToRGB(color);
    this._originalInput = color,
    this._r = rgb.r,
    this._g = rgb.g,
    this._b = rgb.b,
    this._a = rgb.a,
    this._roundA = mathRound(100*this._a) / 100,
    this._format = opts.format || rgb.format;
    this._gradientType = opts.gradientType;

    // Don't let the range of [0,255] come back in [0,1].
    // Potentially lose a little bit of precision here, but will fix issues where
    // .5 gets interpreted as half of the total, instead of half of 1
    // If it was supposed to be 128, this was already taken care of by `inputToRgb`
    if (this._r < 1) { this._r = mathRound(this._r); }
    if (this._g < 1) { this._g = mathRound(this._g); }
    if (this._b < 1) { this._b = mathRound(this._b); }

    this._ok = rgb.ok;
    this._tc_id = tinyCounter++;
}

tinycolor.prototype = {
    isDark: function() {
        return this.getBrightness() < 128;
    },
    isLight: function() {
        return !this.isDark();
    },
    isValid: function() {
        return this._ok;
    },
    getOriginalInput: function() {
      return this._originalInput;
    },
    getFormat: function() {
        return this._format;
    },
    getAlpha: function() {
        return this._a;
    },
    getBrightness: function() {
        //http://www.w3.org/TR/AERT#color-contrast
        var rgb = this.toRgb();
        return (rgb.r * 299 + rgb.g * 587 + rgb.b * 114) / 1000;
    },
    getLuminance: function() {
        //http://www.w3.org/TR/2008/REC-WCAG20-20081211/#relativeluminancedef
        var rgb = this.toRgb();
        var RsRGB, GsRGB, BsRGB, R, G, B;
        RsRGB = rgb.r/255;
        GsRGB = rgb.g/255;
        BsRGB = rgb.b/255;

        if (RsRGB <= 0.03928) {R = RsRGB / 12.92;} else {R = Math.pow(((RsRGB + 0.055) / 1.055), 2.4);}
        if (GsRGB <= 0.03928) {G = GsRGB / 12.92;} else {G = Math.pow(((GsRGB + 0.055) / 1.055), 2.4);}
        if (BsRGB <= 0.03928) {B = BsRGB / 12.92;} else {B = Math.pow(((BsRGB + 0.055) / 1.055), 2.4);}
        return (0.2126 * R) + (0.7152 * G) + (0.0722 * B);
    },
    setAlpha: function(value) {
        this._a = boundAlpha(value);
        this._roundA = mathRound(100*this._a) / 100;
        return this;
    },
    toHsv: function() {
        var hsv = rgbToHsv(this._r, this._g, this._b);
        return { h: hsv.h * 360, s: hsv.s, v: hsv.v, a: this._a };
    },
    toHsvString: function() {
        var hsv = rgbToHsv(this._r, this._g, this._b);
        var h = mathRound(hsv.h * 360), s = mathRound(hsv.s * 100), v = mathRound(hsv.v * 100);
        return (this._a == 1) ?
          "hsv("  + h + ", " + s + "%, " + v + "%)" :
          "hsva(" + h + ", " + s + "%, " + v + "%, "+ this._roundA + ")";
    },
    toHsl: function() {
        var hsl = rgbToHsl(this._r, this._g, this._b);
        return { h: hsl.h * 360, s: hsl.s, l: hsl.l, a: this._a };
    },
    toHslString: function() {
        var hsl = rgbToHsl(this._r, this._g, this._b);
        var h = mathRound(hsl.h * 360), s = mathRound(hsl.s * 100), l = mathRound(hsl.l * 100);
        return (this._a == 1) ?
          "hsl("  + h + ", " + s + "%, " + l + "%)" :
          "hsla(" + h + ", " + s + "%, " + l + "%, "+ this._roundA + ")";
    },
    toHex: function(allow3Char) {
        return rgbToHex(this._r, this._g, this._b, allow3Char);
    },
    toHexString: function(allow3Char) {
        return '#' + this.toHex(allow3Char);
    },
    toHex8: function(allow4Char) {
        return rgbaToHex(this._r, this._g, this._b, this._a, allow4Char);
    },
    toHex8String: function(allow4Char) {
        return '#' + this.toHex8(allow4Char);
    },
    toRgb: function() {
        return { r: mathRound(this._r), g: mathRound(this._g), b: mathRound(this._b), a: this._a };
    },
    toRgbString: function() {
        return (this._a == 1) ?
          "rgb("  + mathRound(this._r) + ", " + mathRound(this._g) + ", " + mathRound(this._b) + ")" :
          "rgba(" + mathRound(this._r) + ", " + mathRound(this._g) + ", " + mathRound(this._b) + ", " + this._roundA + ")";
    },
    toPercentageRgb: function() {
        return { r: mathRound(bound01(this._r, 255) * 100) + "%", g: mathRound(bound01(this._g, 255) * 100) + "%", b: mathRound(bound01(this._b, 255) * 100) + "%", a: this._a };
    },
    toPercentageRgbString: function() {
        return (this._a == 1) ?
          "rgb("  + mathRound(bound01(this._r, 255) * 100) + "%, " + mathRound(bound01(this._g, 255) * 100) + "%, " + mathRound(bound01(this._b, 255) * 100) + "%)" :
          "rgba(" + mathRound(bound01(this._r, 255) * 100) + "%, " + mathRound(bound01(this._g, 255) * 100) + "%, " + mathRound(bound01(this._b, 255) * 100) + "%, " + this._roundA + ")";
    },
    toName: function() {
        if (this._a === 0) {
            return "transparent";
        }

        if (this._a < 1) {
            return false;
        }

        return hexNames[rgbToHex(this._r, this._g, this._b, true)] || false;
    },
    toFilter: function(secondColor) {
        var hex8String = '#' + rgbaToArgbHex(this._r, this._g, this._b, this._a);
        var secondHex8String = hex8String;
        var gradientType = this._gradientType ? "GradientType = 1, " : "";

        if (secondColor) {
            var s = tinycolor(secondColor);
            secondHex8String = '#' + rgbaToArgbHex(s._r, s._g, s._b, s._a);
        }

        return "progid:DXImageTransform.Microsoft.gradient("+gradientType+"startColorstr="+hex8String+",endColorstr="+secondHex8String+")";
    },
    toString: function(format) {
        var formatSet = !!format;
        format = format || this._format;

        var formattedString = false;
        var hasAlpha = this._a < 1 && this._a >= 0;
        var needsAlphaFormat = !formatSet && hasAlpha && (format === "hex" || format === "hex6" || format === "hex3" || format === "hex4" || format === "hex8" || format === "name");

        if (needsAlphaFormat) {
            // Special case for "transparent", all other non-alpha formats
            // will return rgba when there is transparency.
            if (format === "name" && this._a === 0) {
                return this.toName();
            }
            return this.toRgbString();
        }
        if (format === "rgb") {
            formattedString = this.toRgbString();
        }
        if (format === "prgb") {
            formattedString = this.toPercentageRgbString();
        }
        if (format === "hex" || format === "hex6") {
            formattedString = this.toHexString();
        }
        if (format === "hex3") {
            formattedString = this.toHexString(true);
        }
        if (format === "hex4") {
            formattedString = this.toHex8String(true);
        }
        if (format === "hex8") {
            formattedString = this.toHex8String();
        }
        if (format === "name") {
            formattedString = this.toName();
        }
        if (format === "hsl") {
            formattedString = this.toHslString();
        }
        if (format === "hsv") {
            formattedString = this.toHsvString();
        }

        return formattedString || this.toHexString();
    },
    clone: function() {
        return tinycolor(this.toString());
    },

    _applyModification: function(fn, args) {
        var color = fn.apply(null, [this].concat([].slice.call(args)));
        this._r = color._r;
        this._g = color._g;
        this._b = color._b;
        this.setAlpha(color._a);
        return this;
    },
    lighten: function() {
        return this._applyModification(lighten, arguments);
    },
    brighten: function() {
        return this._applyModification(brighten, arguments);
    },
    darken: function() {
        return this._applyModification(darken, arguments);
    },
    desaturate: function() {
        return this._applyModification(desaturate, arguments);
    },
    saturate: function() {
        return this._applyModification(saturate, arguments);
    },
    greyscale: function() {
        return this._applyModification(greyscale, arguments);
    },
    spin: function() {
        return this._applyModification(spin, arguments);
    },

    _applyCombination: function(fn, args) {
        return fn.apply(null, [this].concat([].slice.call(args)));
    },
    analogous: function() {
        return this._applyCombination(analogous, arguments);
    },
    complement: function() {
        return this._applyCombination(complement, arguments);
    },
    monochromatic: function() {
        return this._applyCombination(monochromatic, arguments);
    },
    splitcomplement: function() {
        return this._applyCombination(splitcomplement, arguments);
    },
    triad: function() {
        return this._applyCombination(triad, arguments);
    },
    tetrad: function() {
        return this._applyCombination(tetrad, arguments);
    }
};

// If input is an object, force 1 into "1.0" to handle ratios properly
// String input requires "1.0" as input, so 1 will be treated as 1
tinycolor.fromRatio = function(color, opts) {
    if (typeof color == "object") {
        var newColor = {};
        for (var i in color) {
            if (color.hasOwnProperty(i)) {
                if (i === "a") {
                    newColor[i] = color[i];
                }
                else {
                    newColor[i] = convertToPercentage(color[i]);
                }
            }
        }
        color = newColor;
    }

    return tinycolor(color, opts);
};

// Given a string or object, convert that input to RGB
// Possible string inputs:
//
//     "red"
//     "#f00" or "f00"
//     "#ff0000" or "ff0000"
//     "#ff000000" or "ff000000"
//     "rgb 255 0 0" or "rgb (255, 0, 0)"
//     "rgb 1.0 0 0" or "rgb (1, 0, 0)"
//     "rgba (255, 0, 0, 1)" or "rgba 255, 0, 0, 1"
//     "rgba (1.0, 0, 0, 1)" or "rgba 1.0, 0, 0, 1"
//     "hsl(0, 100%, 50%)" or "hsl 0 100% 50%"
//     "hsla(0, 100%, 50%, 1)" or "hsla 0 100% 50%, 1"
//     "hsv(0, 100%, 100%)" or "hsv 0 100% 100%"
//
function inputToRGB(color) {

    var rgb = { r: 0, g: 0, b: 0 };
    var a = 1;
    var s = null;
    var v = null;
    var l = null;
    var ok = false;
    var format = false;

    if (typeof color == "string") {
        color = stringInputToObject(color);
    }

    if (typeof color == "object") {
        if (isValidCSSUnit(color.r) && isValidCSSUnit(color.g) && isValidCSSUnit(color.b)) {
            rgb = rgbToRgb(color.r, color.g, color.b);
            ok = true;
            format = String(color.r).substr(-1) === "%" ? "prgb" : "rgb";
        }
        else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.v)) {
            s = convertToPercentage(color.s);
            v = convertToPercentage(color.v);
            rgb = hsvToRgb(color.h, s, v);
            ok = true;
            format = "hsv";
        }
        else if (isValidCSSUnit(color.h) && isValidCSSUnit(color.s) && isValidCSSUnit(color.l)) {
            s = convertToPercentage(color.s);
            l = convertToPercentage(color.l);
            rgb = hslToRgb(color.h, s, l);
            ok = true;
            format = "hsl";
        }

        if (color.hasOwnProperty("a")) {
            a = color.a;
        }
    }

    a = boundAlpha(a);

    return {
        ok: ok,
        format: color.format || format,
        r: mathMin(255, mathMax(rgb.r, 0)),
        g: mathMin(255, mathMax(rgb.g, 0)),
        b: mathMin(255, mathMax(rgb.b, 0)),
        a: a
    };
}


// Conversion Functions
// --------------------

// `rgbToHsl`, `rgbToHsv`, `hslToRgb`, `hsvToRgb` modified from:
// <http://mjijackson.com/2008/02/rgb-to-hsl-and-rgb-to-hsv-color-model-conversion-algorithms-in-javascript>

// `rgbToRgb`
// Handle bounds / percentage checking to conform to CSS color spec
// <http://www.w3.org/TR/css3-color/>
// *Assumes:* r, g, b in [0, 255] or [0, 1]
// *Returns:* { r, g, b } in [0, 255]
function rgbToRgb(r, g, b){
    return {
        r: bound01(r, 255) * 255,
        g: bound01(g, 255) * 255,
        b: bound01(b, 255) * 255
    };
}

// `rgbToHsl`
// Converts an RGB color value to HSL.
// *Assumes:* r, g, and b are contained in [0, 255] or [0, 1]
// *Returns:* { h, s, l } in [0,1]
function rgbToHsl(r, g, b) {

    r = bound01(r, 255);
    g = bound01(g, 255);
    b = bound01(b, 255);

    var max = mathMax(r, g, b), min = mathMin(r, g, b);
    var h, s, l = (max + min) / 2;

    if(max == min) {
        h = s = 0; // achromatic
    }
    else {
        var d = max - min;
        s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
        switch(max) {
            case r: h = (g - b) / d + (g < b ? 6 : 0); break;
            case g: h = (b - r) / d + 2; break;
            case b: h = (r - g) / d + 4; break;
        }

        h /= 6;
    }

    return { h: h, s: s, l: l };
}

// `hslToRgb`
// Converts an HSL color value to RGB.
// *Assumes:* h is contained in [0, 1] or [0, 360] and s and l are contained [0, 1] or [0, 100]
// *Returns:* { r, g, b } in the set [0, 255]
function hslToRgb(h, s, l) {
    var r, g, b;

    h = bound01(h, 360);
    s = bound01(s, 100);
    l = bound01(l, 100);

    function hue2rgb(p, q, t) {
        if(t < 0) t += 1;
        if(t > 1) t -= 1;
        if(t < 1/6) return p + (q - p) * 6 * t;
        if(t < 1/2) return q;
        if(t < 2/3) return p + (q - p) * (2/3 - t) * 6;
        return p;
    }

    if(s === 0) {
        r = g = b = l; // achromatic
    }
    else {
        var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
        var p = 2 * l - q;
        r = hue2rgb(p, q, h + 1/3);
        g = hue2rgb(p, q, h);
        b = hue2rgb(p, q, h - 1/3);
    }

    return { r: r * 255, g: g * 255, b: b * 255 };
}

// `rgbToHsv`
// Converts an RGB color value to HSV
// *Assumes:* r, g, and b are contained in the set [0, 255] or [0, 1]
// *Returns:* { h, s, v } in [0,1]
function rgbToHsv(r, g, b) {

    r = bound01(r, 255);
    g = bound01(g, 255);
    b = bound01(b, 255);

    var max = mathMax(r, g, b), min = mathMin(r, g, b);
    var h, s, v = max;

    var d = max - min;
    s = max === 0 ? 0 : d / max;

    if(max == min) {
        h = 0; // achromatic
    }
    else {
        switch(max) {
            case r: h = (g - b) / d + (g < b ? 6 : 0); break;
            case g: h = (b - r) / d + 2; break;
            case b: h = (r - g) / d + 4; break;
        }
        h /= 6;
    }
    return { h: h, s: s, v: v };
}

// `hsvToRgb`
// Converts an HSV color value to RGB.
// *Assumes:* h is contained in [0, 1] or [0, 360] and s and v are contained in [0, 1] or [0, 100]
// *Returns:* { r, g, b } in the set [0, 255]
 function hsvToRgb(h, s, v) {

    h = bound01(h, 360) * 6;
    s = bound01(s, 100);
    v = bound01(v, 100);

    var i = Math.floor(h),
        f = h - i,
        p = v * (1 - s),
        q = v * (1 - f * s),
        t = v * (1 - (1 - f) * s),
        mod = i % 6,
        r = [v, q, p, p, t, v][mod],
        g = [t, v, v, q, p, p][mod],
        b = [p, p, t, v, v, q][mod];

    return { r: r * 255, g: g * 255, b: b * 255 };
}

// `rgbToHex`
// Converts an RGB color to hex
// Assumes r, g, and b are contained in the set [0, 255]
// Returns a 3 or 6 character hex
function rgbToHex(r, g, b, allow3Char) {

    var hex = [
        pad2(mathRound(r).toString(16)),
        pad2(mathRound(g).toString(16)),
        pad2(mathRound(b).toString(16))
    ];

    // Return a 3 character hex if possible
    if (allow3Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1)) {
        return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0);
    }

    return hex.join("");
}

// `rgbaToHex`
// Converts an RGBA color plus alpha transparency to hex
// Assumes r, g, b are contained in the set [0, 255] and
// a in [0, 1]. Returns a 4 or 8 character rgba hex
function rgbaToHex(r, g, b, a, allow4Char) {

    var hex = [
        pad2(mathRound(r).toString(16)),
        pad2(mathRound(g).toString(16)),
        pad2(mathRound(b).toString(16)),
        pad2(convertDecimalToHex(a))
    ];

    // Return a 4 character hex if possible
    if (allow4Char && hex[0].charAt(0) == hex[0].charAt(1) && hex[1].charAt(0) == hex[1].charAt(1) && hex[2].charAt(0) == hex[2].charAt(1) && hex[3].charAt(0) == hex[3].charAt(1)) {
        return hex[0].charAt(0) + hex[1].charAt(0) + hex[2].charAt(0) + hex[3].charAt(0);
    }

    return hex.join("");
}

// `rgbaToArgbHex`
// Converts an RGBA color to an ARGB Hex8 string
// Rarely used, but required for "toFilter()"
function rgbaToArgbHex(r, g, b, a) {

    var hex = [
        pad2(convertDecimalToHex(a)),
        pad2(mathRound(r).toString(16)),
        pad2(mathRound(g).toString(16)),
        pad2(mathRound(b).toString(16))
    ];

    return hex.join("");
}

// `equals`
// Can be called with any tinycolor input
tinycolor.equals = function (color1, color2) {
    if (!color1 || !color2) { return false; }
    return tinycolor(color1).toRgbString() == tinycolor(color2).toRgbString();
};

tinycolor.random = function() {
    return tinycolor.fromRatio({
        r: mathRandom(),
        g: mathRandom(),
        b: mathRandom()
    });
};


// Modification Functions
// ----------------------
// Thanks to less.js for some of the basics here
// <https://github.com/cloudhead/less.js/blob/master/lib/less/functions.js>

function desaturate(color, amount) {
    amount = (amount === 0) ? 0 : (amount || 10);
    var hsl = tinycolor(color).toHsl();
    hsl.s -= amount / 100;
    hsl.s = clamp01(hsl.s);
    return tinycolor(hsl);
}

function saturate(color, amount) {
    amount = (amount === 0) ? 0 : (amount || 10);
    var hsl = tinycolor(color).toHsl();
    hsl.s += amount / 100;
    hsl.s = clamp01(hsl.s);
    return tinycolor(hsl);
}

function greyscale(color) {
    return tinycolor(color).desaturate(100);
}

function lighten (color, amount) {
    amount = (amount === 0) ? 0 : (amount || 10);
    var hsl = tinycolor(color).toHsl();
    hsl.l += amount / 100;
    hsl.l = clamp01(hsl.l);
    return tinycolor(hsl);
}

function brighten(color, amount) {
    amount = (amount === 0) ? 0 : (amount || 10);
    var rgb = tinycolor(color).toRgb();
    rgb.r = mathMax(0, mathMin(255, rgb.r - mathRound(255 * - (amount / 100))));
    rgb.g = mathMax(0, mathMin(255, rgb.g - mathRound(255 * - (amount / 100))));
    rgb.b = mathMax(0, mathMin(255, rgb.b - mathRound(255 * - (amount / 100))));
    return tinycolor(rgb);
}

function darken (color, amount) {
    amount = (amount === 0) ? 0 : (amount || 10);
    var hsl = tinycolor(color).toHsl();
    hsl.l -= amount / 100;
    hsl.l = clamp01(hsl.l);
    return tinycolor(hsl);
}

// Spin takes a positive or negative amount within [-360, 360] indicating the change of hue.
// Values outside of this range will be wrapped into this range.
function spin(color, amount) {
    var hsl = tinycolor(color).toHsl();
    var hue = (hsl.h + amount) % 360;
    hsl.h = hue < 0 ? 360 + hue : hue;
    return tinycolor(hsl);
}

// Combination Functions
// ---------------------
// Thanks to jQuery xColor for some of the ideas behind these
// <https://github.com/infusion/jQuery-xcolor/blob/master/jquery.xcolor.js>

function complement(color) {
    var hsl = tinycolor(color).toHsl();
    hsl.h = (hsl.h + 180) % 360;
    return tinycolor(hsl);
}

function triad(color) {
    var hsl = tinycolor(color).toHsl();
    var h = hsl.h;
    return [
        tinycolor(color),
        tinycolor({ h: (h + 120) % 360, s: hsl.s, l: hsl.l }),
        tinycolor({ h: (h + 240) % 360, s: hsl.s, l: hsl.l })
    ];
}

function tetrad(color) {
    var hsl = tinycolor(color).toHsl();
    var h = hsl.h;
    return [
        tinycolor(color),
        tinycolor({ h: (h + 90) % 360, s: hsl.s, l: hsl.l }),
        tinycolor({ h: (h + 180) % 360, s: hsl.s, l: hsl.l }),
        tinycolor({ h: (h + 270) % 360, s: hsl.s, l: hsl.l })
    ];
}

function splitcomplement(color) {
    var hsl = tinycolor(color).toHsl();
    var h = hsl.h;
    return [
        tinycolor(color),
        tinycolor({ h: (h + 72) % 360, s: hsl.s, l: hsl.l}),
        tinycolor({ h: (h + 216) % 360, s: hsl.s, l: hsl.l})
    ];
}

function analogous(color, results, slices) {
    results = results || 6;
    slices = slices || 30;

    var hsl = tinycolor(color).toHsl();
    var part = 360 / slices;
    var ret = [tinycolor(color)];

    for (hsl.h = ((hsl.h - (part * results >> 1)) + 720) % 360; --results; ) {
        hsl.h = (hsl.h + part) % 360;
        ret.push(tinycolor(hsl));
    }
    return ret;
}

function monochromatic(color, results) {
    results = results || 6;
    var hsv = tinycolor(color).toHsv();
    var h = hsv.h, s = hsv.s, v = hsv.v;
    var ret = [];
    var modification = 1 / results;

    while (results--) {
        ret.push(tinycolor({ h: h, s: s, v: v}));
        v = (v + modification) % 1;
    }

    return ret;
}

// Utility Functions
// ---------------------

tinycolor.mix = function(color1, color2, amount) {
    amount = (amount === 0) ? 0 : (amount || 50);

    var rgb1 = tinycolor(color1).toRgb();
    var rgb2 = tinycolor(color2).toRgb();

    var p = amount / 100;

    var rgba = {
        r: ((rgb2.r - rgb1.r) * p) + rgb1.r,
        g: ((rgb2.g - rgb1.g) * p) + rgb1.g,
        b: ((rgb2.b - rgb1.b) * p) + rgb1.b,
        a: ((rgb2.a - rgb1.a) * p) + rgb1.a
    };

    return tinycolor(rgba);
};


// Readability Functions
// ---------------------
// <http://www.w3.org/TR/2008/REC-WCAG20-20081211/#contrast-ratiodef (WCAG Version 2)

// `contrast`
// Analyze the 2 colors and returns the color contrast defined by (WCAG Version 2)
tinycolor.readability = function(color1, color2) {
    var c1 = tinycolor(color1);
    var c2 = tinycolor(color2);
    return (Math.max(c1.getLuminance(),c2.getLuminance())+0.05) / (Math.min(c1.getLuminance(),c2.getLuminance())+0.05);
};

// `isReadable`
// Ensure that foreground and background color combinations meet WCAG2 guidelines.
// The third argument is an optional Object.
//      the 'level' property states 'AA' or 'AAA' - if missing or invalid, it defaults to 'AA';
//      the 'size' property states 'large' or 'small' - if missing or invalid, it defaults to 'small'.
// If the entire object is absent, isReadable defaults to {level:"AA",size:"small"}.

// *Example*
//    tinycolor.isReadable("#000", "#111") => false
//    tinycolor.isReadable("#000", "#111",{level:"AA",size:"large"}) => false
tinycolor.isReadable = function(color1, color2, wcag2) {
    var readability = tinycolor.readability(color1, color2);
    var wcag2Parms, out;

    out = false;

    wcag2Parms = validateWCAG2Parms(wcag2);
    switch (wcag2Parms.level + wcag2Parms.size) {
        case "AAsmall":
        case "AAAlarge":
            out = readability >= 4.5;
            break;
        case "AAlarge":
            out = readability >= 3;
            break;
        case "AAAsmall":
            out = readability >= 7;
            break;
    }
    return out;

};

// `mostReadable`
// Given a base color and a list of possible foreground or background
// colors for that base, returns the most readable color.
// Optionally returns Black or White if the most readable color is unreadable.
// *Example*
//    tinycolor.mostReadable(tinycolor.mostReadable("#123", ["#124", "#125"],{includeFallbackColors:false}).toHexString(); // "#112255"
//    tinycolor.mostReadable(tinycolor.mostReadable("#123", ["#124", "#125"],{includeFallbackColors:true}).toHexString();  // "#ffffff"
//    tinycolor.mostReadable("#a8015a", ["#faf3f3"],{includeFallbackColors:true,level:"AAA",size:"large"}).toHexString(); // "#faf3f3"
//    tinycolor.mostReadable("#a8015a", ["#faf3f3"],{includeFallbackColors:true,level:"AAA",size:"small"}).toHexString(); // "#ffffff"
tinycolor.mostReadable = function(baseColor, colorList, args) {
    var bestColor = null;
    var bestScore = 0;
    var readability;
    var includeFallbackColors, level, size ;
    args = args || {};
    includeFallbackColors = args.includeFallbackColors ;
    level = args.level;
    size = args.size;

    for (var i= 0; i < colorList.length ; i++) {
        readability = tinycolor.readability(baseColor, colorList[i]);
        if (readability > bestScore) {
            bestScore = readability;
            bestColor = tinycolor(colorList[i]);
        }
    }

    if (tinycolor.isReadable(baseColor, bestColor, {"level":level,"size":size}) || !includeFallbackColors) {
        return bestColor;
    }
    else {
        args.includeFallbackColors=false;
        return tinycolor.mostReadable(baseColor,["#fff", "#000"],args);
    }
};


// Big List of Colors
// ------------------
// <http://www.w3.org/TR/css3-color/#svg-color>
var names = tinycolor.names = {
    aliceblue: "f0f8ff",
    antiquewhite: "faebd7",
    aqua: "0ff",
    aquamarine: "7fffd4",
    azure: "f0ffff",
    beige: "f5f5dc",
    bisque: "ffe4c4",
    black: "000",
    blanchedalmond: "ffebcd",
    blue: "00f",
    blueviolet: "8a2be2",
    brown: "a52a2a",
    burlywood: "deb887",
    burntsienna: "ea7e5d",
    cadetblue: "5f9ea0",
    chartreuse: "7fff00",
    chocolate: "d2691e",
    coral: "ff7f50",
    cornflowerblue: "6495ed",
    cornsilk: "fff8dc",
    crimson: "dc143c",
    cyan: "0ff",
    darkblue: "00008b",
    darkcyan: "008b8b",
    darkgoldenrod: "b8860b",
    darkgray: "a9a9a9",
    darkgreen: "006400",
    darkgrey: "a9a9a9",
    darkkhaki: "bdb76b",
    darkmagenta: "8b008b",
    darkolivegreen: "556b2f",
    darkorange: "ff8c00",
    darkorchid: "9932cc",
    darkred: "8b0000",
    darksalmon: "e9967a",
    darkseagreen: "8fbc8f",
    darkslateblue: "483d8b",
    darkslategray: "2f4f4f",
    darkslategrey: "2f4f4f",
    darkturquoise: "00ced1",
    darkviolet: "9400d3",
    deeppink: "ff1493",
    deepskyblue: "00bfff",
    dimgray: "696969",
    dimgrey: "696969",
    dodgerblue: "1e90ff",
    firebrick: "b22222",
    floralwhite: "fffaf0",
    forestgreen: "228b22",
    fuchsia: "f0f",
    gainsboro: "dcdcdc",
    ghostwhite: "f8f8ff",
    gold: "ffd700",
    goldenrod: "daa520",
    gray: "808080",
    green: "008000",
    greenyellow: "adff2f",
    grey: "808080",
    honeydew: "f0fff0",
    hotpink: "ff69b4",
    indianred: "cd5c5c",
    indigo: "4b0082",
    ivory: "fffff0",
    khaki: "f0e68c",
    lavender: "e6e6fa",
    lavenderblush: "fff0f5",
    lawngreen: "7cfc00",
    lemonchiffon: "fffacd",
    lightblue: "add8e6",
    lightcoral: "f08080",
    lightcyan: "e0ffff",
    lightgoldenrodyellow: "fafad2",
    lightgray: "d3d3d3",
    lightgreen: "90ee90",
    lightgrey: "d3d3d3",
    lightpink: "ffb6c1",
    lightsalmon: "ffa07a",
    lightseagreen: "20b2aa",
    lightskyblue: "87cefa",
    lightslategray: "789",
    lightslategrey: "789",
    lightsteelblue: "b0c4de",
    lightyellow: "ffffe0",
    lime: "0f0",
    limegreen: "32cd32",
    linen: "faf0e6",
    magenta: "f0f",
    maroon: "800000",
    mediumaquamarine: "66cdaa",
    mediumblue: "0000cd",
    mediumorchid: "ba55d3",
    mediumpurple: "9370db",
    mediumseagreen: "3cb371",
    mediumslateblue: "7b68ee",
    mediumspringgreen: "00fa9a",
    mediumturquoise: "48d1cc",
    mediumvioletred: "c71585",
    midnightblue: "191970",
    mintcream: "f5fffa",
    mistyrose: "ffe4e1",
    moccasin: "ffe4b5",
    navajowhite: "ffdead",
    navy: "000080",
    oldlace: "fdf5e6",
    olive: "808000",
    olivedrab: "6b8e23",
    orange: "ffa500",
    orangered: "ff4500",
    orchid: "da70d6",
    palegoldenrod: "eee8aa",
    palegreen: "98fb98",
    paleturquoise: "afeeee",
    palevioletred: "db7093",
    papayawhip: "ffefd5",
    peachpuff: "ffdab9",
    peru: "cd853f",
    pink: "ffc0cb",
    plum: "dda0dd",
    powderblue: "b0e0e6",
    purple: "800080",
    rebeccapurple: "663399",
    red: "f00",
    rosybrown: "bc8f8f",
    royalblue: "4169e1",
    saddlebrown: "8b4513",
    salmon: "fa8072",
    sandybrown: "f4a460",
    seagreen: "2e8b57",
    seashell: "fff5ee",
    sienna: "a0522d",
    silver: "c0c0c0",
    skyblue: "87ceeb",
    slateblue: "6a5acd",
    slategray: "708090",
    slategrey: "708090",
    snow: "fffafa",
    springgreen: "00ff7f",
    steelblue: "4682b4",
    tan: "d2b48c",
    teal: "008080",
    thistle: "d8bfd8",
    tomato: "ff6347",
    turquoise: "40e0d0",
    violet: "ee82ee",
    wheat: "f5deb3",
    white: "fff",
    whitesmoke: "f5f5f5",
    yellow: "ff0",
    yellowgreen: "9acd32"
};

// Make it easy to access colors via `hexNames[hex]`
var hexNames = tinycolor.hexNames = flip(names);


// Utilities
// ---------

// `{ 'name1': 'val1' }` becomes `{ 'val1': 'name1' }`
function flip(o) {
    var flipped = { };
    for (var i in o) {
        if (o.hasOwnProperty(i)) {
            flipped[o[i]] = i;
        }
    }
    return flipped;
}

// Return a valid alpha value [0,1] with all invalid values being set to 1
function boundAlpha(a) {
    a = parseFloat(a);

    if (isNaN(a) || a < 0 || a > 1) {
        a = 1;
    }

    return a;
}

// Take input from [0, n] and return it as [0, 1]
function bound01(n, max) {
    if (isOnePointZero(n)) { n = "100%"; }

    var processPercent = isPercentage(n);
    n = mathMin(max, mathMax(0, parseFloat(n)));

    // Automatically convert percentage into number
    if (processPercent) {
        n = parseInt(n * max, 10) / 100;
    }

    // Handle floating point rounding errors
    if ((Math.abs(n - max) < 0.000001)) {
        return 1;
    }

    // Convert into [0, 1] range if it isn't already
    return (n % max) / parseFloat(max);
}

// Force a number between 0 and 1
function clamp01(val) {
    return mathMin(1, mathMax(0, val));
}

// Parse a base-16 hex value into a base-10 integer
function parseIntFromHex(val) {
    return parseInt(val, 16);
}

// Need to handle 1.0 as 100%, since once it is a number, there is no difference between it and 1
// <http://stackoverflow.com/questions/7422072/javascript-how-to-detect-number-as-a-decimal-including-1-0>
function isOnePointZero(n) {
    return typeof n == "string" && n.indexOf('.') != -1 && parseFloat(n) === 1;
}

// Check to see if string passed in is a percentage
function isPercentage(n) {
    return typeof n === "string" && n.indexOf('%') != -1;
}

// Force a hex value to have 2 characters
function pad2(c) {
    return c.length == 1 ? '0' + c : '' + c;
}

// Replace a decimal with it's percentage value
function convertToPercentage(n) {
    if (n <= 1) {
        n = (n * 100) + "%";
    }

    return n;
}

// Converts a decimal to a hex value
function convertDecimalToHex(d) {
    return Math.round(parseFloat(d) * 255).toString(16);
}
// Converts a hex value to a decimal
function convertHexToDecimal(h) {
    return (parseIntFromHex(h) / 255);
}

var matchers = (function() {

    // <http://www.w3.org/TR/css3-values/#integers>
    var CSS_INTEGER = "[-\\+]?\\d+%?";

    // <http://www.w3.org/TR/css3-values/#number-value>
    var CSS_NUMBER = "[-\\+]?\\d*\\.\\d+%?";

    // Allow positive/negative integer/number.  Don't capture the either/or, just the entire outcome.
    var CSS_UNIT = "(?:" + CSS_NUMBER + ")|(?:" + CSS_INTEGER + ")";

    // Actual matching.
    // Parentheses and commas are optional, but not required.
    // Whitespace can take the place of commas or opening paren
    var PERMISSIVE_MATCH3 = "[\\s|\\(]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")\\s*\\)?";
    var PERMISSIVE_MATCH4 = "[\\s|\\(]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")[,|\\s]+(" + CSS_UNIT + ")\\s*\\)?";

    return {
        CSS_UNIT: new RegExp(CSS_UNIT),
        rgb: new RegExp("rgb" + PERMISSIVE_MATCH3),
        rgba: new RegExp("rgba" + PERMISSIVE_MATCH4),
        hsl: new RegExp("hsl" + PERMISSIVE_MATCH3),
        hsla: new RegExp("hsla" + PERMISSIVE_MATCH4),
        hsv: new RegExp("hsv" + PERMISSIVE_MATCH3),
        hsva: new RegExp("hsva" + PERMISSIVE_MATCH4),
        hex3: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
        hex6: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/,
        hex4: /^#?([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})([0-9a-fA-F]{1})$/,
        hex8: /^#?([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})([0-9a-fA-F]{2})$/
    };
})();

// `isValidCSSUnit`
// Take in a single string / number and check to see if it looks like a CSS unit
// (see `matchers` above for definition).
function isValidCSSUnit(color) {
    return !!matchers.CSS_UNIT.exec(color);
}

// `stringInputToObject`
// Permissive string parsing.  Take in a number of formats, and output an object
// based on detected format.  Returns `{ r, g, b }` or `{ h, s, l }` or `{ h, s, v}`
function stringInputToObject(color) {

    color = color.replace(trimLeft,'').replace(trimRight, '').toLowerCase();
    var named = false;
    if (names[color]) {
        color = names[color];
        named = true;
    }
    else if (color == 'transparent') {
        return { r: 0, g: 0, b: 0, a: 0, format: "name" };
    }

    // Try to match string input using regular expressions.
    // Keep most of the number bounding out of this function - don't worry about [0,1] or [0,100] or [0,360]
    // Just return an object and let the conversion functions handle that.
    // This way the result will be the same whether the tinycolor is initialized with string or object.
    var match;
    if ((match = matchers.rgb.exec(color))) {
        return { r: match[1], g: match[2], b: match[3] };
    }
    if ((match = matchers.rgba.exec(color))) {
        return { r: match[1], g: match[2], b: match[3], a: match[4] };
    }
    if ((match = matchers.hsl.exec(color))) {
        return { h: match[1], s: match[2], l: match[3] };
    }
    if ((match = matchers.hsla.exec(color))) {
        return { h: match[1], s: match[2], l: match[3], a: match[4] };
    }
    if ((match = matchers.hsv.exec(color))) {
        return { h: match[1], s: match[2], v: match[3] };
    }
    if ((match = matchers.hsva.exec(color))) {
        return { h: match[1], s: match[2], v: match[3], a: match[4] };
    }
    if ((match = matchers.hex8.exec(color))) {
        return {
            r: parseIntFromHex(match[1]),
            g: parseIntFromHex(match[2]),
            b: parseIntFromHex(match[3]),
            a: convertHexToDecimal(match[4]),
            format: named ? "name" : "hex8"
        };
    }
    if ((match = matchers.hex6.exec(color))) {
        return {
            r: parseIntFromHex(match[1]),
            g: parseIntFromHex(match[2]),
            b: parseIntFromHex(match[3]),
            format: named ? "name" : "hex"
        };
    }
    if ((match = matchers.hex4.exec(color))) {
        return {
            r: parseIntFromHex(match[1] + '' + match[1]),
            g: parseIntFromHex(match[2] + '' + match[2]),
            b: parseIntFromHex(match[3] + '' + match[3]),
            a: convertHexToDecimal(match[4] + '' + match[4]),
            format: named ? "name" : "hex8"
        };
    }
    if ((match = matchers.hex3.exec(color))) {
        return {
            r: parseIntFromHex(match[1] + '' + match[1]),
            g: parseIntFromHex(match[2] + '' + match[2]),
            b: parseIntFromHex(match[3] + '' + match[3]),
            format: named ? "name" : "hex"
        };
    }

    return false;
}

function validateWCAG2Parms(parms) {
    // return valid WCAG2 parms for isReadable.
    // If input parms are invalid, return {"level":"AA", "size":"small"}
    var level, size;
    parms = parms || {"level":"AA", "size":"small"};
    level = (parms.level || "AA").toUpperCase();
    size = (parms.size || "small").toLowerCase();
    if (level !== "AA" && level !== "AAA") {
        level = "AA";
    }
    if (size !== "small" && size !== "large") {
        size = "small";
    }
    return {"level":level, "size":size};
}

window.tinycolor = tinycolor;

// stick tinycolor straight on isc
if (isc) isc.tinycolor = tinycolor;

// Node: Export function
if (typeof module !== "undefined" && module.exports) {
    module.exports = tinycolor;
}
// AMD/requirejs: Define the module
else if (typeof define === 'function' && define.amd) {
    define(function () {return tinycolor;});
}
// Browser: Expose to window
else {
    window.tinycolor = tinycolor;
}

})(Math);

/* === END === */

// make tinycolor available as isc.tinycolor
if (!isc.tinycolor) isc.tinycolor = window.tinycolor;
})();


// Class will not work without the ListGrid
if (isc.ListGrid) {




//>    @class    ScrollingMenu
//
//    Implements a scrollable, user-selectable, menu
//
//  @treeLocation Client Reference/Control
//<


// define us as a subclass of the ListGrid
isc.ClassFactory.defineClass("ScrollingMenu", "ListGrid");

isc.ScrollingMenu.scrollingPickerProperties = {


    minHeight: 1,


    useBackMask:true,

    // Explicitly default canFocus to true.
    canFocus:true,

    showHeader:false,
    // Avoid showing edges.
    showEdges:false,

    autoDraw:false,

    // don't use the default ListGrid component/body styles, which usually have partial borders
    className:"scrollingMenu",
    bodyStyleName:"scrollingMenuBody",

    selectionType:"single",
    leaveScrollbarGap:false,

    // keyboard - we respond to clicks and Enter keypresses identically.
    // Space has no meaning.
    generateClickOnSpace : false,
    generateDoubleClickOnEnter : false,
    generateClickOnEnter : true,
    // By default show as a modal component.
    showModal:true,

    // arrowKeyAction will select by default

    arrowKeyAction:"select",
    //enableSelectOnRowOver: null, // !isc.Browser.isTouch

    // default to filter on keypress if we show a filter editor
    filterOnKeypress:true

};

isc.ScrollingMenu.scrollingPickerMethods = {
    show : function () {

        if (this.showModal) {
            var mode = this.clickMaskMode || (this.formItem && this.formItem.clickMaskMode);
            if (mode == null) {
                // legacy behavior of showing a hard clickMask for modal pickLists
                mode = "hard";
            }
            this.showClickMask({target:this, methodName:"cancel"}, mode, [this]);
        }
        this.Super("show", arguments);
        if (this.showModal) this.body.focus();
    },

    // override recordClick to fire the 'itemClick' method.
    recordClick : function (viewer,record,recordNum,field,fieldNum,value,rawValue) {
        // hide before firing itemClick.
        // This avoids issues with focus, where the itemClick action is expected to put focus
        // somewhere that is masked until this menu hides.
        this.hide();
        // add support for click handlers on the individual rows
        // make itemClick a stringMethod?
        if (record != null) this.itemClick(record);
    },

    // override this for click handling behavior
    itemClick : function (record) {},

    // On RowOver change selection. The user can then use arrow keys to further modify selection
    // This matches behavior in native select item drop-downs.

    rowOver : function (record,rowNum,colNum) {
        if (this.enableSelectOnRowOver) {
            this.selectionManager.selectSingle(record, rowNum);
            this.fireSelectionUpdated();
        }
    },
    createSelectionModel : function (a,b,c,d,e) {
        var returnVal = this.invokeSuper(isc.ScrollingMenu, "createSelectionModel", a,b,c,d,e);
        // Override selection so we can tell the difference between selection from rollOver and
        // from keyboard events / clicks.
        // This is required so we can do the right thing on Enter keypress
        this.selectionManager.addProperties({
            selectOnRowOver : function (record) {
                this.selectSingle(record);
                this.selectionFromMouse = true;
            },

            setSelected : function (record, state) {
                this.selectionFromMouse = false;
                return this.Super("setSelected", arguments);
            }
        });

        return returnVal;
    },
    // Keyboard handling:

    // Override bodyKeyPress to handle firing 'cancel()' on escape click.
    bodyKeyPress : function (event, eventInfo) {
        var keyName = event.keyName;

        if (keyName == this._$Enter) {
            var selection = this.selectionManager;
            if (selection && selection.selectionFromMouse) {
                this.cancel();
                return false;
            }
        }
        if (keyName == "Escape") {
            this.cancel();

            // stop bubbling!
            return false;
        }
        return this.Super("bodyKeyPress", arguments);
    },


    cancel : function () {
        this.hide();
    },

    // Override hide to ensure that the clickMask gets hidden too
    hide : function () {
        this.hideClickMask();
        return this.Super("hide", arguments);
    },

    // Always select the first item in the list *IF* nothing is selected

    _selectFirstOnDataChanged:true,
    dataChanged : function () {
        var returnVal = this.Super("dataChanged", arguments);
        if (!this._selectFirstOnDataChanged) return;

        if (this.data && this.data.getLength() > 0 &&
            this.selectionManager && !this.selectionManager.anySelected() &&
            //FIXME: tweak as appropriate for trees
            (isc.isA.ResultSet==null || !isc.isA.ResultSet(this.data) || this.data.rowIsLoaded(0)))
        {
                this.selectionManager.selectItem(0);
                this.fireSelectionUpdated();
        }
        return returnVal;
    }

};

isc.defer("isc.ScrollingMenu.addProperties({ enableSelectOnRowOver: !isc.Browser.isTouch });");

isc.ScrollingMenu.addProperties(isc.ScrollingMenu.scrollingPickerProperties);
isc.ScrollingMenu.addProperties(isc.ScrollingMenu.scrollingPickerMethods);

isc.ScrollingMenu.changeDefaults("filterEditorDefaults", {
        // If the filter editor is showing, explicitly give it a solid bg color.
        // This prevents things showing through under the transparent background of
        // the filter button image
        backgroundColor:"white",

        // Override editor keypress -- allow the user to move around and select
        // records as expected
        editorKeyPress : function (item, keyName, characterValue) {
            if (keyName == "Arrow_Down") {
                this.sourceWidget._navigateToNextRecord(1);
                return false;
            }
            if (keyName == "Arrow_Up") {
                this.sourceWidget._navigateToNextRecord(-1);
                return false;
            }
            if (keyName == "Enter") {
                this.sourceWidget._generateFocusRecordClick();
                return;
            }
            return this.Super("editorKeyPress", arguments);
        }
});

isc.ScrollingMenu.changeDefaults("bodyDefaults", {

    _readyToSetFocus : function () {
        return this.creator._readyToSetFocus.apply(this.creator, arguments);
    }
});



}

// Class will not work without the TreeGrid
if (isc.TreeGrid) {

// define us as a subclass of the TreeGrid
isc.ClassFactory.defineClass("ScrollingTreeMenu", "TreeGrid");

isc.defer("isc.ScrollingTreeMenu.addProperties({ enableSelectOnRowOver: !isc.Browser.isTouch });");

isc.ScrollingTreeMenu.addProperties(isc.ScrollingMenu.scrollingPickerProperties);
isc.ScrollingTreeMenu.addProperties(isc.ScrollingMenu.scrollingPickerMethods);

isc.ScrollingTreeMenu.addProperties({
    //arrowKeyAction:"move"
});

isc.ScrollingTreeMenu.changeDefaults("filterEditorDefaults", {
        // If the filter editor is showing, explicitly give it a solid bg color.
        // This prevents things showing through under the transparent background of
        // the filter button image
        backgroundColor:"white",

        // Override editor keypress -- allow the user to move around and select
        // records as expected
        editorKeyPress : function (item, keyName, characterValue) {
            if (keyName == "Arrow_Down") {
                this.sourceWidget._navigateToNextRecord(1);
                return false;
            }
            if (keyName == "Arrow_Up") {
                this.sourceWidget._navigateToNextRecord(-1);
                return false;
            }
            if (keyName == "Enter") {
                this.sourceWidget._generateFocusRecordClick();
                return;
            }
            return this.Super("editorKeyPress", arguments);
        }
});

isc.ScrollingTreeMenu.changeDefaults("bodyDefaults", {

    _readyToSetFocus : function () {
        return this.creator._readyToSetFocus.apply(this.creator, arguments);
    }
});

}







//>    @class    DynamicForm
//
// The DynamicForm manages a collection of FormItems which represent user input controls.  The
// DynamicForm provides +link{group:formLayout,layout}, value management, validation and
// databinding for the controls it manages.
// <P>
// <smartgwt>
// To create a DynamicForm, create several +link{FormItem}s and pass them to
// +link{dynamicForm.setItems(),setItems()}.  For example:
// <pre>
//    DynamicForm form = new DynamicForm();
//    TextItem textItem = new TextItem("userName");
//    SelectItem selectItem = new SelectItem("usState");
//    form.setItems(textItem, selectItem);
// </pre>
// </smartgwt>
// <smartclient>
// To create a DynamicForm, set +link{dynamicForm.fields} to an Array of Objects describing the
// FormItems you want to use.  For example:
// <pre>
//    isc.DynamicForm.create({
//        fields:[
//            {name:"userName", type:"text"},  // creates a TextItem
//            {name:"usState", type:"select"}  // creates a SelectItem
//        ]
//    })
// </pre>
// </smartclient>
// The item <code>name</code> is an identifier for the item that must be unique just within
// this form.  It is used:
// <ul>
// <li> as the name under which the item's value is stored in the form (the form's
//      current values are accessible as +link{dynamicForm.getValues,form.getValues()}
// <li> when retrieving the FormItem's current value (via
//      +link{dynamicForm.getValue,form.getValue()})
// <li> to retrieve the item itself via +link{dynamicForm.getItem(),form.getItem()}
// </ul>
// FormItems can also be created by binding the form to a DataSource via
// <code>setDataSource()</code>.  In this case, FormItems are
// chosen based on the data type of the field - see +link{type:FormItemType}.  You can override
// the automatically chosen FormItem via +link{DataSourceField.editorType}.
// <P>
// FormItem lifecycle is managed by the DynamicForm itself. FormItem instances are created
// and destroyed automatically when new fields are added to the form.
// <P>
// When using DataSource binding, you can also add additional FormItems not specified in the
// DataSource, or override any properties on the automatically generated FormItems, without
// having to re-declare any information that comes from the DataSource.  See the QuickStart
// Guide chapter on Data Binding for an overview.
// <P>
// All FormItems share a common set of properties for controlling +link{group:formLayout,form
// layout}.  Other properties common to all FormItems are documented on the +link{FormItem}
// class, and properties specific to particular FormItems are documented on the respective
// FormItems.
// <P>
// NOTE: For very simple forms consisting of exactly one item, you still use a DynamicForm.
// See the "fontSelector" form in the +explorerExample{toolstrip,Toolstrip example}.
//
//  @inheritsFrom Canvas
//  @implements DataBoundComponent
//  @treeLocation Client Reference/Forms
//  @visibility external
//<

// create the form as a descendant of the Canvas
isc.ClassFactory.defineClass("DynamicForm", "Canvas", "DataBoundComponent");

// Synonym for use by ValuesManagers working with distributed 'FormLayouts'
isc.addGlobal("FormLayout", isc.DynamicForm);


//> @groupDef items
// Manipulating the items that belong to a form.
// <BR><br>
// An item manages an atomic value (eg a String, Number, Date, etc) that appears as one of the
// properties in the overall form's values.  Some items exist purely for layout or appearance
// purposes (eg SpacerItem) and do not manage a value.
// @title Form Items
// @visibility external
//<

//> @groupDef values
// Manipulating the values stored in the form.
// @visibility external
//<

//> @groupDef valueMap
// A +link{type:ValueMap} defines the set of legal values for a field, and optionally allows you to provide
// a mapping from stored values to values as seen by the end user.
//
// @visibility external
//<

//> @groupDef validation
// Validation
// @visibility external
//<

//> @groupDef formTitles
// Properties that affect form item title placement and styling.
// @title Form Titles
// @visibility external
//<

//> @groupDef errors
// Validation errors and how they are shown
// @visibility external
//<

//> @groupDef submitting
// Direct submission of forms to a target URL
// <P>
// <b>NOTE:</b> directly submitting forms is only done for specialized purposes, such as
// integration with certain legacy systems.  Normal form usage contacts the server via
// +link{group:dataBoundComponentMethods,DataBound Component Methods}, through the RPCManager system.
// @visibility external
//<

//> @groupDef elements
// Manipulating native form elements
//<


// add constants
isc.DynamicForm.addClassProperties({


    //> @type   FormMethod
    //          Form METHOD parameters - how the form fields are submitted to the server
    // @value  isc.DynamicForm.GET     GET request -- URL encoding (~4K max)
    // @value  isc.DynamicForm.POST    POST request -- separate field encoding (no max)
    // @group  submitting
    // @visibility external
    //<

    //> @classAttr DynamicForm.GET (Constant : "GET" : [R])
    // A declared value of the enum type
    // +link{type:FormMethod,FormMethod}.
    // @visibility external
    // @constant
    //<
    GET:"GET",

    //> @classAttr DynamicForm.POST (Constant : "POST" : [R])
    // A declared value of the enum type
    // +link{type:FormMethod,FormMethod}.
    // @visibility external
    // @constant
    //<
    POST:"POST",

    //> @type   Encoding
    // Form encoding types - these translate to Form ENCTYPE parameters.
    // @value isc.DynamicForm.NORMAL  normal form encoding ("application/x-www-form-urlencoded")
    // @value isc.DynamicForm.MULTIPART  form encoding for forms with INPUT file elements, that
    //                                   is, forms that upload files ("multipart/form-data")
    // @group  submitting
    // @visibility external
    //<
    // NOTE: EncodingTypes has the values that we actually write into the form in HTML.

    //> @classAttr DynamicForm.NORMAL (Constant : "normal" : [R])
    // A declared value of the enum type
    // +link{type:Encoding,Encoding}.
    // @visibility external
    // @constant
    //<
    NORMAL:    "normal",

    //> @classAttr DynamicForm.MULTIPART (Constant : "multipart" : [R])
    // A declared value of the enum type
    // +link{type:Encoding,Encoding}.
    // @visibility external
    // @constant
    //<
    MULTIPART:    "multipart",

    //>    @type    EncodingTypes
    // Form ENCTYPE parameters - how data is encoded when sent to the server.
    // See:  http://www.w3.org/TR/html4/interact/forms.html#adef-enctype
    //            @group    submitting
    // normal form encoding
    NORMAL_ENCODING:    "application/x-www-form-urlencoded",
    // multipart encoding for file upload
    MULTIPART_ENCODING:    "multipart/form-data",
    //<

    // Attributes written into containers for form items / form item elements
    _containsItem : "_containsItem",
    _itemPart : "_itemPart",
    // Options for the itemPart setting
    _element : "_element",
    _textBoxString : "_textBox",
    _controlTableString : "_controlTable",
    _pickerIconCellString : "_pickerIconCell",
    _inlineErrorString : "inlineErrorHandle",
    _title : "_title",

    buildOperatorIndex : function () {
        if (isc.DataSource == null) return;
        var list = isc.getValues(isc.DataSource.getSearchOperators());

        list = list.sortByProperties(["symbol"], [false],
            [function (item, propertyName, context) {
                var value = item[propertyName],
                    length = isc.isA.String(value) ? value.length : 0
                ;

                return length;
            }]
        );

        this._operatorIndex = list.makeIndex("symbol", true);
    },
    getOperatorIndex : function () {
        return this._operatorIndex;
    },

    _defaultItemHoverHTMLImpl : function (item) {
        // Just bail if a native prompt is shown
        if (item.implementsPromptNatively) return null;
        // use renderAsDisabled(), to support both disabled and readOnlyDisplay:"disabled"
        var prompt = (item.renderAsDisabled() ? item.disabledHover : null) ||
                     (item.isReadOnly() ? item.readOnlyHover : null) ||
                     item.prompt;
        if (!prompt && item.parentItem) prompt = isc.DynamicForm._defaultItemHoverHTMLImpl(item.parentItem);
        return prompt
    },

    _defaultValueHoverHTMLImpl : function (item) {

        var returnVal = item.getDisplayValue();

        if (item != null && item.multiple && item.multipleValueSeparator) {
            if (isc.isAn.Array(returnVal)) returnVal = returnVal.join(item.multipleValueSeparator);
        }

        if (returnVal != null) {
            returnVal = "" + returnVal;

            // Don't escape &nbsp; unless that's actually the data value
            var value;
            if (returnVal == item._$nbsp &&
                ((value = item.getValue()) == null || value == isc.emptyString))
            {
                returnVal = "";

            // If escapeHTML is irrelevant (e.g. TextItems), then explicitly escape the value
            // here because mapValueToDisplay() will not.

            } else if (!item.canEscapeHTML) {
                returnVal = returnVal.asHTML();
            }
        }
        return returnVal;
    },

    /*
    ,
    getDefaultOperatorForType : function (type, item, textMatchStyle, field) {
        if (item) {
            var defaultOp = item.getDefaultOperator(textMatchStyle);
            if (defaultOp) return defaultOp;
        }

        var form = item && item.form,
            typeName = type == null ? "text" : isc.isA.String(type) ? type : type.name,
            operator
        ;
        if ((item && (item.valueMap || item.optionDataSource)) ||
            isc.SimpleType.inheritsFrom(typeName, "enum") ||
            isc.SimpleType.inheritsFrom(typeName, "boolean") ||
            isc.SimpleType.inheritsFrom(typeName, "float") ||
            isc.SimpleType.inheritsFrom(typeName, "integer") ||
            isc.SimpleType.inheritsFrom(typeName, "date") ||
            isc.SimpleType.inheritsFrom(typeName, "time"))
        {
            // if a field was passed, and it has validOperators, make sure they include "equals"
            // - if not, use "iEquals" if it's there, or just the first of them otherwise...
            if (field && field.validOperators) {
                if (field.validOperators.contains("equals")) operator = "equals";
                else if (field.validOperators.contains("iEquals")) operator = "iEquals";
                else operator = field.validOperators[0];
            } else {
                operator = "equals";
            }
        } else {
            var defaultOperator = "iContains";
            if (form) {
                defaultOperator = form.defaultSearchOperator ||
                    (form.allowExpressions ? "iContainsPattern" : "iContains");
                // if the default op isn't valid for the field, use the first valid operator
                var ds = form.getDataSource(),
                    theField = field && isc.isA.String(field) ? ds && ds.getField(field) : field,
                    types = ds && ds.getFieldOperators(theField),
                    validOp = types && types.contains(defaultOperator)
                ;
                if (!validOp && types) defaultOperator = types[0];
            }

            operator = isc.DataSource.getCriteriaOperator(null, textMatchStyle, defaultOperator);
        }
        return operator;
    }
    */

    // When creating items in a search form for a multiple:true dataSource field,
    // don't pick up the multiple attribute automatically
    // This may still be applied either by specifying multiple:true on the item
    // config itself or through properties like useMultiSelectForValueMaps

    suppressSearchFormFieldMultiple:true
});



isc.DynamicForm.addProperties({

    // Basic Definition: items and values
    // --------------------------------------------------------------------------------------------

    //>    @attr    dynamicForm.items        (Array of FormItem Properties : null : [IRW])
    // Synonym for +link{attr:dynamicForm.fields}
    //
    // @see attr:dynamicForm.fields
    // @group items
    // @setter setItems()
    // @visibility external
    //<

    //> @attr dynamicForm.fields (Array of FormItem Properties : null : [IRW])
    // An array of field objects, specifying the order, layout, and types of each field in the
    // DynamicForm.
    // <p>
    // When both <code>dynamicForm.fields</code> and <code>dynamicForm.dataSource</code> are
    // set, <code>dynamicForm.fields</code> acts as a set of overrides as explained in
    // +link{attr:DataBoundComponent.fields}.
    // <P>
    // See +link{group:formLayout,Form Layout} for information about how flags specified on
    // the FormItems control how the form is laid out.
    //
    // @see class:FormItem
    // @setter setFields()
    // @group items
    // @visibility external
    //<

    //>    @attr    dynamicForm.defaultItems    (Array of FormItem Properties : null : [ARW])
    // An array of FormItem objects, defining the default set of elements this form
    // creates. (Typically set at a class level on the instance prototype).
    // @group items
    //<
    // NOTE: not external; used for making specialized form subclasses

    //>    @attr    dynamicForm.values        (Object : null : [IRW])
    // An Object containing the initial values of the form as properties, where each
    // propertyName is the name of a +link{items,form item} in the form, and each property
    // value is the value held by that form item.
    // <P>
    // The form's values may contain values that are not managed by any FormItem, and these
    // values will be preserved and available when the form values are subsequently retrieved
    // via +link{getValues()}.
    // <P>
    // Providing values on initialization is equivalent to calling +link{setValues()}.
    // <P>
    // As the user manipulates form items to change values, change events fire
    // +link{formItem.change,on the items} and
    // +link{dynamicForm.itemChange,on the form as a whole}.
    // <P>
    // Note that form values are logical values, for example, the value of a +link{DateItem} is
    // a JavaScript Date object, not a String, even if the user enters the date via a text
    // input.  Likewise the value of a +link{TextItem} or +link{CheckboxItem} that started out
    // null remains null until the user changes it; the value will not be automatically
    // converted to the null string ("") or false respectively, as happens with native HTML
    // elements.
    //
    // @group formValues
    // @visibility external
    //<

    // Table Layout
    // --------------------------------------------------------------------------------------------

    //> @groupDef formLayout
    // <b>FormItem Placement in Columns and Rows</b>
    // <P>
    // With the default tabular layout mechanism, items are laid out in rows from left to
    // right until the number of columns, specified by +link{dynamicForm.numCols,form.numCols},
    // is filled, then a new row is begun.  Flags on FormItems, including
    // +link{FormItem.startRow,startRow}, +link{FormItem.endRow,endRow},
    // +link{FormItem.colSpan,colSpan} and +link{FormItem.rowSpan,rowSpan}, control row and
    // column placement and spanning.
    // <P>
    // Note that the most common form items (TextItem, SelectItem, etc) take up <b>two</b>
    // columns by default: one for the form control itself, and one for it's title.  The
    // default setting of +link{dynamicForm.numCols,form.numCols:2} will result in one TextItem
    // or SelectItem per row.
    // <P>
    // Note also that ButtonItems have both startRow:true and endRow:true by default.  You must
    // set startRow and/or endRow to <code>false</code> on a ButtonItem in order to place a
    // button in the same row as any other item.
    // <P>
    // The log category "tablePlacement" can be enabled from the Developer Console to watch
    // items being placed.  You can also set +link{dynamicForm.cellBorder,form.cellBorder:1} to
    // reveal the table structure for layout troubleshooting purposes.
    // <P>
    // <b>Row and Column Sizing</b>
    // <P>
    // +link{DynamicForm.colWidths} controls the widths of form columns.  FormItems that have
    // "*" for +link{formItem.width} will fill the column.  FormItems with a numeric width will
    // have that width in pixels regardless of the column's specified width, which may cause the
    // column to overflow as described under +link{DynamicForm.fixedColWidths}.
    // <P>
    // For row heights, the largest pixel height specified on any item in the row is taken as a
    // minimum size for the row.  Then, any rows that have "*" or "%" height items will share
    // any height not taken up by fixed-sized items.
    // <P>
    // Individual item heights are controlled by +link{formItem.height,item.height}. This may be specified as
    // an integer (pixel value), or a percentage string, or the special string "*", which
    // indicates an item should fill the available space.<br>
    // Percentages allow developers to determine how the available space in the form
    // is split amongst items. For example if a form has 4 items in a single column,
    // 2 of which have an  absolute pixel height specified, and 2 of which are have
    // heights of <code>"30%"</code> and <code>"70%"</code> respectively, the percentage
    // sized items will split up the available space after the fixed size items have been
    // rendered.<br>
    // Note that +link{formItem.cellHeight,item.cellHeight} may be specified to explicitly control the height of
    // an item's cell. In this case the specified +link{formItem.height,item.height} will govern the size
    // of the item within the cell (and if set to a percentage, this will be interpreted as
    // a percentage of the cellHeight).
    // <P>
    // <b>Managing Overflow</b>
    // <P>
    // Forms often contain labels, data values, or instructional text which can vary in
    // size based on the skin, data values, or internationalization settings.  There are a few
    // ways to deal with a form potentially varying in size:
    // <ol>
    // <li> Allow scrolling when necessary, using +link{Canvas.overflow,overflow:auto}, either
    // on the immediate form, or on some parent.
    // <li> Place the form in a Layout along with a component that can render any specified
    // size, such as a +link{ListGrid}.  In this case, the Layout will automatically shrink the
    // grid in order to accommodate the form.
    // <li> Ensure that the form can always render at a designed minimum size by reducing
    // the number of cases of variable-sized text, and testing remaining cases across all
    // supported skins.  For example, move help text into hovers on help icons, or clip
    // long text values at a maximum length and provide a hover to see the rest.
    // </ol>
    // <P>
    // <b>Adaptive Layout</b>
    // <P>
    // To have various automatic adjustments made to render your form items in a single column,
    // you can use +link{dynamicForm.linearMode,linearMode}.  Importantly, you can have this
    // mode automatically applied to a form on +link{Browser.isHandset, handset devices} by
    // setting +link{dynamicForm.linearOnMobile,linearOnMobile} true.  For further details and
    // the properties that are available to customize this mode, see the
    // +link{dynamicForm.linearMode,linearMode} documentation.
    // <P>
    // Several examples of Form Layout are available +explorerExample{formsLayout,here}.
    //
    // @treeLocation Client Reference/Forms
    // @title Form Layout
    // @see formItem.width
    // @see formItem.height
    // @see dynamicForm.itemLayout
    // @visibility external
    //<


    //> @attr dynamicForm.itemLayout   (FormLayoutType : "table" : IRWA)
    // Layout style to use with this form.
    // <P>
    // The default of "table" uses a tabular layout similar to HTML tables, but with much more
    // powerful control over sizing, item visibility and reflow, overflow handling, etc.
    // <P>
    // <code>itemLayout:"absolute"</code> allows absolute positioning of every form item.  This
    // provides maximum flexibility in placement, with the following limitations:<ul>
    // <li> titles, which normally take up an adjacent cell, are not shown.  Use
    //      StaticTextItems to show titles
    // <li> no automatic reflow when showing or hiding items.  +link{method:FormItem.setLeft()}
    //      and +link{method:FormItem.setTop()} can be used for manual reflow.
    // <li> only pixel and percent sizes are allowed, no "*".  Percent widths mean percentage
    //      of the overall form size rather than the column size
    // <li> with different font styling or internationalized titles, items may overlap that did
    //      not overlap in the skin used at design time
    // </ul>
    //
    // @group formLayout
    // @see group:formLayout
    // @see formItem.width
    // @see formItem.height
    // @visibility absForm
    //<
    //itemLayout:"table",

    //> @attr dynamicForm.flattenItems (boolean : false : IR)
    // If set, the form will set +link{numCols} automatically such that all form items will be
    // laid out in a single row.
    // <P>
    // +link{colWidths} may still be set.  If unset, they will be generated so that all columns
    // showing a title will have +link{titleWidth} and all other columns will have width:"*".
    //
    // @group formLayout
    //<
    flattenItems:false,

    //> @attr dynamicForm.linearMode (Boolean : null : IRW)
    // Switches the entire form to render in a style that is typical for form on a mobile
    // device with one +link{FormItem} per row.
    // <P>
    // The +link{linearOnMobile} attribute allows linear mode to be enabled on
    // mobile interfaces automatically.
    // <P>
    // While <code>linearMode</code> is active, the form's table layout is determined using the
    // following logic:<ul>
    // <li> If +link{titleOrientation} is not explicitly specified, it will be defaulted to
    //      <code>top</code>, causing each item's title to appear above its element.<br>
    //      <b>Note:</b> in linear mode, each item will have the same title orientation.
    //      The item-level +link{formItem.titleOrientation} attribute will be ignored.</li>
    // <li> For those items with a +link{formItem.hint,hint} that support
    //      +link{textItem.showHintInField,showing the hint in the field},
    //      <code>showHintInField</code> will be defaulted true if unset.</li>
    // <li> For items showing validation errors inline, by default
    //      +link{dynamicForm.showErrorText,error text} will be displayed, and
    //      errors will +link{dynamicForm.errorOrientation,be rendered above the item element}.</li>
    // <li> The +link{numCols} property for the form is ignored. The form will render as
    //      a single column of items - or two columns if <code>titleOrientation</code> is
    //      specified as <code>"left"</code> or <code>"right"</code> by default.
    //      To override this, a developer may specify an explicit +link{linearNumCols}
    //      allowing multiple items to potentially be placed next to each other.</li>
    // <li> +link{formItem.width} is ignored and all items receive "*" width unless
    //      +link{formItem.linearWidth} is specified.</li>
    // </ul>
    // Note that if column widths have been specified via +link{colWidths}, but the number
    // of columns doesn't match the number of columns being rendered in linear mode, it will be
    // ignored.
    // <P>
    // If +link{linearAutoSpanItems} is true, each item in linear mode will span the full
    // set of columns by default. With this setting enabled, <code>linearNumCols</code> can
    // be understood as a way to allow some items that are known to not require the full width
    // of the UI to appear next to each other in an otherwise single-column form.
    // <P>
    // When <code>linearAutoSpanItems</code> is enabled, the following properties are available
    // for further customizing the placement and sizing of items in a linear form:
    // <ul>
    // <li> +link{formItem.colSpan} is ignored and defaulted to "*", unless
    //      +link{formItem.linearColSpan} is specified.</li>
    // <li> +link{formItem.startRow} and +link{formItem.endRow} are ignored and
    //      all items will default to <code>startRow:false</code> and <code>endRow:true</code>.
    //      This may be overridden per item via +link{formItem.linearStartRow} and
    //      +link{formItem.linearEndRow}.</li>
    // </ul>
    // For the best appearance, try to get your form to horizontally fill the screen, or almost
    // all of it, on handset-sized devices.  Any kind of fixed width on mobile is probably not
    // going to work as well.  One way to achieve this is by using a +link{SplitPane}.
    // @see linearOnMobile
    // @group formLayout
    // @visibility external
    //<
    setLinearMode : function (linearMode) {
        if (this.linearMode == linearMode) return;
        this.linearMode = linearMode;
        this._setLinearMode(linearMode);
        this.markForRedraw();
    },

    _setLinearMode : function (linearMode) {
        // in linear mode, first save, then default numCols and (potentially) colWidths
        if (linearMode) {
            // configure numCols
            this._numCols = this.numCols;
            this.setNumCols(this.linearNumCols != null ? this.linearNumCols :
                            (this.getTitleOrientation() == isc.Canvas.TOP ? 1 : 2));
            // clear colWidths, if it would conflict with configured numCols
            if (this.colWidths && this.colWidths.length != this.numCols) {
                this._colWidths = this.colWidths, this.colWidths = null;
            }
        // otherwise, if we're switching off linear mode, restore any cached properties
        } else {
            if (this._numCols != null) {
                this.setNumCols(this._numCols);
                delete this._numCols;
            }
            if (this._colWidths) {
                this.setColWidths(this._colWidths);
                delete this._colWidths;
            }
        }
    },

    //> @attr dynamicForm.linearAutoSpanItems (Boolean : true : IRW)
    // When a form is rendered in +link{linearMode}, should each item appear on its own
    // row, spanning the full set of rendered columns by default?
    // @visibility external
    //<
    linearAutoSpanItems:true,

    //> @attr dynamicForm.linearOnMobile (boolean : false : IR)
    // Switches the entire form to render in a style that is typical for form on a
    // +link{Browser.isHandset,handset device} with one +link{FormItem} per row by
    // automatically defaulting +link{linearMode} to <code>true</code> on handsets.
    // <P>
    // <b>Note:</b> This property should not be changed framework-wide via
    // +link{classMethod:addProperties()} as the framework itself assumes and relies upon normal
    // behavior for forms.  If you want most of your forms to use +link{linearMode} on mobile,
    // create a subclass where <code>linearOnMobile</code> defaults to true, and pervasively
    // use that subclass.
    // @group formLayout
    // @visibility external
    //<

    //>    @attr dynamicForm.numCols        (number : 2 : [IRW])
    // The number of columns of titles and items in this form's layout grid. A title and
    // corresponding item each have their own column, so to display two form elements per
    // row (each having a title and item), you would set this property to 4.
    //
    // @group formLayout
    // @visibility external
    //<
    numCols:2,

    //> @attr dynamicForm.linearNumCols (number : null : [IRW])
    // Specifies the +link{numCols,number of columns} when the form is being rendered in
    // +link{linearMode}, overriding any automatically derived value in that mode.
    // @group formLayout
    // @visibility external
    //<

    //>    @attr dynamicForm.fixedColWidths    (Boolean : false : IRW)
    // If true, we ensure that column widths are at least as large as you specify them.  This
    // means that if any single column overflows (due to, eg, a long unbreakable title),
    // the form as a whole overflows.
    // <P>
    // If false, columns will have their specified sizes as long as no column overflows.  If
    // any column overflows, space will be taken from any other columns that aren't filling the
    // available room, until there is no more free space, in which case the form as a whole
    // overflows.
    //
    // @group formLayout
    // @visibility external
    //<

    fixedColWidths:false,

    // fixedRowHeights - undocumented property that causes heights to be written into cells,
    // which, like fixedColumnWidths, puts you into a situation where you're more likely to
    // overflow.
    fixedRowHeights:false,

    //>    @attr    dynamicForm.colWidths        (Array : null : [IRW])
    // An array of widths for the columns of items in this form's layout grid.
    // <P>
    // If specified, these widths should sum to the total width of the form (form.width).
    // If not specified, we assume every other column will contain form item titles, and so
    // should have <code>form.titleWidth</code>, and all other columns should share the
    // remaining space.
    // <P>
    // Acceptable values for each element in the array are:<br>
    // <ul>
    // <li>A number (e.g. 100) representing the number of pixel widths to allocate to a
    //     column.
    // <li>A percent (e.g. 20%) representing the percentage of the total form.width to
    //     allocate to a column.
    // <li>"*" (all) to allocate remaining width (form.width minus all specified column
    //     widths). Multiple columns can use "*", in which case remaining width is divided
    //     between all columns marked "*".
    // </ul>
    // <P>
    // Note that if title columns are left at the default +link{titleWidth} or assigned a fixed
    // width, while the others are configured to use the remaining horizontal space (i.e. with a
    // percent or "*" as described above), then care must be taken if you have long titles with
    // no spaces or +link{wrapItemTitles} is false.
    // <P>
    // Depending on the title font and exact column width applied, the title may overflow its
    // assigned column, causing the form itself to overflow.  If the form's parent has
    // +link{canvas.overflow,overflow}: "auto" and the form has width: "100%" or its parent is
    // a +link{Layout} with +link{Layout.hPolicy,hPolicy}: "fill", this could cause a horizontal
    // scrollbar to appear in a situation where it doesn't seem necessary.
    // <P>
    // If the parent's height is just right so that the space taken by the unwanted horizontal
    // scrollbar introduces a vertical scrollbar, this may even lead to oscillating scrollbars
    // on the parent.  To avoid, you must address the original problem of the title overflowing
    // its assigned column, by widening it, using a smaller font, or allowing wrapping to occur.
    //
    // @group formLayout
    // @visibility external
    // @example columnSpanning
    //<
    colWidths:null,

    //>    @attr dynamicForm.minColWidth        (number : 20 : IRW)
    // Minimum width of a form column.
    // @group formLayout
    // @visibility external
    //<
    minColWidth:20,

    //>    @attr    dynamicForm.cellSpacing        (number : 0 : [IRW])
    // The amount of empty space, in pixels, between form item cells in the layout grid.
    // @group formLayout
    // @visibility internal
    //<

    cellSpacing:0,

    //>    @attr dynamicForm.cellPadding        (number : 2 : [IRW])
    // The amount of empty space, in pixels, surrounding each form item within its cell in
    // the layout grid.
    // @group formLayout
    // @visibility external
    //<
    cellPadding:2,

    //>    @attr dynamicForm.cellBorder        (number : 0 : [IRW])
    // Width of border for the table that form is drawn in. This is primarily used for debugging
    // form layout.
    // @group formLayout
    // @visibility external
    //<
    cellBorder:0,

    // default height for a table row where there are no specified sizes at all (pixel, '*', or
    // percent)
    defaultRowHeight:22,

    //> @attr DynamicForm.sectionVisibilityMode (VisibilityMode : "multiple" : [IRW])
    // If the form has sections, [implemented as +link{SectionItem}s], this attribute controls
    // whether multiple sections can be expanded at once.
    //
    // @see type:VisibilityMode
    // @see class:SectionItem
    // @group formLayout
    // @visibility external
    //<
    sectionVisibilityMode: "multiple",

    // Embedded widgets
    // --------------------------------------------------------------------------------------------
    // Turn on allowContentAndChildren for Canvas Items.
    // NOTE: this has no actual effect unless a CanvasItem is used

    allowContentAndChildren : true,
    separateContentInsertion: true,
    _avoidRedrawFlash:true,
    // necessary because the default determination assumes anything with children doesn't have
    // inherent height
    hasInherentHeight : function () {
        if (this.inherentHeight != null) return this.inherentHeight;
        return (this.overflow == isc.Canvas.VISIBLE || this.overflow == isc.Canvas.CLIP_H);
    },

    // DataBinding
    // --------------------------------------------------------------------------------------------
    //>    @attr    dynamicForm.fieldIdProperty        (String : "name" : IRWA)
    // Name of the column in the fields array that holds the name of the item property that holds
    // the value
    //        @group    data
    //<
    fieldIdProperty:"name",

    //>    @attr    dynamicForm.titleField        (String : "title" : IRWA)
    // Name of the column in the fields array that holds the name of the title property that holds
    // the title
    //        @group    appearance
    //<
    titleField:"title",

    //>    @attr    dynamicForm.showDetailFields (Boolean : true : IR)
    // For databound forms, whether to show fields marked as detail fields.
    // @visibility external
    //<
    showDetailFields: true,

    //>    @attr dynamicForm.longTextEditorThreshold (number : 255 : IRW)
    // When creating form items for fields with text type data, if the specified length of the
    // field exceeds this threshold we will create form item of type
    // <code>this.longTextEditorType</code> (a TextAreaItem by default), rather than a simple
    // text item.  Overridden by explicitly specifying <code>editorType</code> for the field.
    // @group appearance
    // @visibility external
    //<
    longTextEditorThreshold:255,
    //>    @attr dynamicForm.longTextEditorType (String  : "textArea" : IRW)
    // Name of the Form Item class to use for text fields which exceed the
    // longTextEditorThreshold for this form.
    // @group appearance
    // @visibility external
    //<
    longTextEditorType:"textArea",

    // Values formatting

    //> @attr dynamicForm.dateFormatter (DateDisplayFormat : null : IRW)
    // Default +link{DateDisplayFormat} for Date type values displayed in this form.
    // <P>
    // If some field's value is set to a native Date object, how should it be displayed to the
    // user? If specified this is the default display format to use, and will apply to all fields
    // except those specified as +link{formItem.type,type:"time"}
    // (See +link{dynamicForm.timeFormatter}).
    // <P>
    // May be overridden at the component level for fields of type <code>datetime</code> via
    // +link{dynamicForm.datetimeFormatter}.
    // <P>
    // Note that if specified, +link{formItem.dateFormatter} and +link{formItem.timeFormatter}
    // take precedence over the format specified at the component level.
    // <P>
    // If no explicit formatter is specified at the field or component level, dates will be
    // formatted according to the system-wide
    // +link{DateUtil.setShortDisplayFormat(),short date display format} or
    // +link{DateUtil.setShortDatetimeDisplayFormat(),short datetime display format} depending
    // on the specified field type.
    // @visibility external
    //<

    //> @attr dynamicForm.timeFormatter (TimeDisplayFormat : null : IRW)
    // Default +link{TimeDisplayFormat} for +link{formItem.type,type:"time"} field values displayed
    // in this form.
    // <P>
    // Note that if specified, +link{formItem.dateFormatter} and +link{formItem.timeFormatter}
    // take precedence over the format specified at the component level.
    // <P>
    // If no explicit formatter is specified at the field or component level, time values will be
    // formatted according to the system-wide
    // +link{Time.setNormalDisplayFormat(),normal time display format}.
    // specified field type.
    // @visibility external
    //<

    //> @attr dynamicForm.datetimeFormatter (DateDisplayFormat : null : IRW)
    // Default +link{DateDisplayFormat} for Date type values displayed in this form in fields
    // of type <code>datetime</code>.
    // <P>
    // For datetime fields, this attribute will be used instead of +link{dynamicForm.dateFormatter}
    // when formatting Date values.
    // <P>
    // Note that if specified, +link{formItem.dateFormatter} and +link{formItem.timeFormatter}
    // take precedence over the format specified at the component level.
    // <P>
    // If no explicit formatter is specified at the field or component level, datetime field
    // values will be formatted according to the system-wide
    // +link{DateUtil.setShortDatetimeDisplayFormat(),short datetime display format}.
    // @visibility external
    //<

    //>ValuesManager

    //> @groupDef formValuesManager
    // Values Manager references.
    //
    // @title Values Manager
    // @visibility external
    //<

    // ValuesManager
    // ----------------------------------------------------------------------------------------
    //>@attr dynamicForm.valuesManager  (ValuesManager | GlobalId : null : [I])
    // If set at init time, this dynamicForm will be created as a member form of the
    // specified valuesManager.  To update the form's valuesManager after init, use the
    // +link{dynamicForm.setValuesManager, form-level setter}, or the
    // +link{valuesManager.addMember, addMember(form)} /
    // +link{valuesManager.removeMember, removeMember(form)} APIs on
    // <code>ValuesManager</code>.
    // @see class:ValuesManager
    // @setter dynamicForm.setValuesManager()
    // @visibility external
    // @group formValuesManager
    //<

    //>    @method    dynamicForm.setValuesManager()
    // Binds this dynamicForm to a +link{dynamicForm.valuesManager, valuesManager} at runtime.
    // @param valuesManager (ValuesManager | GlobalId) the ValuesManager that controls this
    //                                                 form's values
    // @group formValuesManager
    // @visibility external
    //<
    setValuesManager : function (valuesManager) {
        // if the param is a global ID, get the instance
        if (isc.isA.String(valuesManager)) valuesManager = window[valuesManager];
        // if it's a valuesManager, call addMember() on it, passing this DF instance
        if (isc.isA.ValuesManager(valuesManager)) valuesManager.addMember(this);
        else this.valuesManager = valuesManager;
    },

    // Helper to retrieve the valuesManager at runtime
    // If called before the valuesManager has been associated with this form,
    // or if this.valuesManager has been set to something invalid, returns null
    _getValuesManager : function () {
        var vm = this.valuesManager;
        if (vm != null && isc.isA.ValuesManager(vm) && vm.members && vm.members.contains(this)) return vm;
    },

    //<ValuesManager


    // Title Formatting
    // --------------------------------------------------------------------------------------------

    //> @type  TitleOrientation
    // Orientation of titles relative to the FormItem being labeled.  Can be set a the
    // DynamicForm level as a default, or on individual items.
    //
    // @value  "left"
    // @value  "top"
    // @value  "right"
    // @group formTitles
    // @see DynamicForm.titleOrientation
    // @see FormItem.titleOrientation
    // @visibility external
    //<

    //>    @attr    dynamicForm.titleOrientation    (TitleOrientation : "left" : [IRW])
    // Default orientation for titles for items in this form.  +link{type:TitleOrientation}
    // lists valid options.
    // <P>
    // Note that titles on the left or right take up a cell in tabular
    // +link{group:formLayout,form layouts}, but titles on top do not.
    //
    //      @group  formTitles
    //      @visibility external
    // @example formLayoutTitles
    //<

    //>    @attr dynamicForm.titlePrefix (HTMLString : "" : [IRW])
    // The string pre-pended to the title of every item in this form.  See also +{requiredTitlePrefix} for
    // fields that are required.
    // @group formTitles
    // @visibility external
    //<
    titlePrefix:"",

    //>    @attr dynamicForm.rightTitlePrefix (HTMLString : ":&nbsp;" : [IRW])
    // The string pre-pended to the title of an item in this form if its
    // titleOrientation property is set to "right".
    // @group formTitles
    // @visibility external
    //<
    rightTitlePrefix:":&nbsp;",

    //>    @attr dynamicForm.titleSuffix (HTMLString : "&nbsp;:" : [IRW])
    // The string appended to the title of every item in this form.  See also +{requiredTitleSuffix} for
    // fields that are required.
    // @group formTitles
    // @visibility external
    //<
    titleSuffix:"&nbsp;:",

    //> @attr dynamicForm.rightTitleSuffix (HTMLString : "" : [IRW])
    // The string appended to the title of an item in this form if its titleOrientation
    // property is set to "right".
    // @group formTitles
    // @visibility external
    //<
    rightTitleSuffix:"",

    //>    @attr    dynamicForm.titleWidth        (number | "*": 100 : [IRW])
    //          The width in pixels allocated to the title of every item in this form.  If you
    //          don't specify explicit +link{attr:dynamicForm.colWidths}, you can set this
    //          value to the string "*" to divide the usable space evenly between titles and
    //          fields.
    //      @group  formTitles
    //      @visibility external
    //<
    titleWidth:100,

    //> @attr dynamicForm.clipItemTitles (boolean : false : [IRW])
    // Should the titles for form items be clipped if they are too large for the available
    // space?
    // <p>
    // Can be overridden for individual items via +link{FormItem.clipTitle}.
    // @visibility external
    //<
    clipItemTitles:false,

    //>    @attr    dynamicForm.wrapItemTitles (boolean : null : [IRW])
    // Whether titles for form items should wrap.  If not specified, titles will wrap by
    // default.  Can be overridden for individual items via +link{formItem.wrapTitle}
    // @visibility external
    // @group formTitles
    //<
//    wrapItemTitles:null,

    //> @attr   dynamicForm.showInlineErrors (Boolean : true : [IRW])
    // If true, field errors are written into the form next to the item(s) where the errors
    // occurred.  Errors may appear as text or just an icon (via +link{showErrorText}:false).
    // <P>
    // If false, errors are written at the top of the form.
    // <P>
    // To do some other kind of error display, override +link{showErrors()}.
    //
    // @group validation
    // @visibility external
    //<
    showInlineErrors: true,

    // customization of inline errors appearance on items

    // showErrorIcons doc contains an overview of error styling to be reused as the docs for
    // showErrorText / showErrorStyle as well
    //> @attr dynamicForm.showErrorIcons (Boolean : true : IRW)
    // +link{dynamicForm.showErrorIcons,showErrorIcons},
    // +link{dynamicForm.showErrorText,showErrorText}, +link{dynamicForm.errorOrientation,errorOrientation},
    // and +link{dynamicForm.showErrorStyle,showErrorStyle} control how validation errors are
    // displayed when they are displayed inline in the form (next to the form item where there
    // is a validation error).  To instead display all errors at the top of the form, set
    // +link{dynamicForm.showInlineErrors,showInlineErrors}:false.
    // <P>
    // <code>showErrorIcons</code>, <code>showErrorText</code>, <code>errorOrientation</code>
    // and <code>showErrorStyle</code>
    // are all boolean properties, and can be set on a DynamicForm to control the behavior
    // form-wide, or set on individual FormItems.
    // <P>
    // The HTML displayed next to a form item with errors is generated by
    // +link{FormItem.getErrorHTML()}.
    // The default implementation of that method respects <code>showErrorIcons</code> and
    // <code>showErrorText</code> as follows:
    // <P>
    // <code>showErrorIcons</code>, or <code>showErrorIcon</code> at the FormItem level controls
    // whether an error icon should appear next to fields which have validation errors.  The icon's
    // appearance is governed by +link{FormItem.errorIconSrc}, +link{FormItem.errorIconWidth} and
    // +link{FormItem.errorIconHeight}
    // <P>
    // <code>showErrorText</code> determines whether the text of the validation error should be
    // displayed next to fields which have validation errors. The attribute
    // +link{dynamicForm.showTitlesWithErrorMessages} may be set to prefix error messages with the
    // form item's title + <code>":"</code> (may be desired if the item has
    // +link{formItem.showTitle} set to false).<br>
    // If <code>showErrorText</code> is unset, the error text will be shown if
    // +link{dynamicForm.linearMode} is true (or +link{dynamicForm.linearOnMobile} is true for
    // mobile devices), otherwise it will not be shown.
    // <P>
    // In addition to this:
    // <P>
    // +link{dynamicForm.errorOrientation} controls where the error HTML should appear relative
    // to form items. Therefore the combination of +link{showErrorText}<code>:false</code> and
    // +link{errorOrientation}<code>:"left"</code> creates a compact validation error display
    // consisting of just an icon, to the left of the item with the error message
    // available via a hover (similar appearance to ListGrid validation error display).<br>
    // If <code>errorOrientation</code> is unset, the error orientation will default to "top"
    // if +link{dynamicForm.linearMode} is enabled (or +link{dynamicForm.linearOnMobile} is true
    // for mobile devices) and error text is not showing, "left" otherwise.
    // <P>
    // <code>showErrorStyle</code> determines whether fields  with validation
    // errors should have special styling applied to them. Error styling is achieved by
    // applying suffixes to existing styling applied to various parts of the form item.
    // See +link{type:FormItemBaseStyle}  for more on this.
    //
    // @group  validation
    // @visibility external
    //<
    showErrorIcons: true,

    //> @attr dynamicForm.showErrorText (Boolean : false : IRW)
    // @include dynamicForm.showErrorIcons
    // @group  validation
    // @visibility external
    //<
    showErrorText:null,
    shouldShowErrorText : function () {
        if (this.showErrorText != null) return this.showErrorText;
        if (this.linearMode && this.showInlineErrors) return true;
        return false;
    },

    //> @attr dynamicForm.showErrorStyle (Boolean : true : IRW)
    // @include dynamicForm.showErrorIcons
    // @group  validation
    // @visibility external
    //<
    showErrorStyle: true,

    //> @attr dynamicForm.errorOrientation (Align : "left" : IRW)
    // @include dynamicForm.showErrorIcons
    // @group validation, appearance
    // @visibility external
    //<
    errorOrientation: null,
    getErrorOrientation : function () {
        if (this.errorOrientation != null) {
            return this.errorOrientation;
        }

        if (this.linearMode && this.shouldShowErrorText()) return "top";
        return "left";

    },

    // Enable customization of the error item
    errorItemDefaults : {
        type:"blurb",
        wrap:true,
        showIf:function () {
            return !this.form.showInlineErrors && this.form.hasErrors();
        },
        defaultDynamicValue : function (item,form,values) {
            return form.getErrorsHTML(form.getErrors());
        }
    },
    //> @attr dynamicForm.errorItemProperties (Object : null : [IRA])
    // If +link{dynamicForm.showInlineErrors} is false we show all errors for the form item in
    // a single item rendered at the top of the form.<br>
    // This attribute contains a properties block for this item.
    // @group validation
    // @visibility external
    //<
    //errorItemProperties : {},

    //> @attr dynamicForm.errorItemCellStyle (String  : "formCellError" : [IR])
    // If +link{dynamicForm.showInlineErrors} is false we show all errors for the form item in
    // a single item rendered at the top of the form.<br>
    // This attribute specifies the cellStyle to apply to this item.
    // @group validation
    // @visibility external
    //<
    errorItemCellStyle:"formCellError",

    //> @attr dynamicForm.errorsPreamble (HTMLString :"The following errors were found:" : IR)
    // If +link{dynamicForm.showInlineErrors} is <code>false</code>, all errors for the items
    // in the form are rendered as a single item at the top of the form. This attribute specifies
    // an introductory message rendered out before the individual error messages.
    // @group validation, i18nMessages
    // @visibility external
    //<
    errorsPreamble:"The following errors were found:",

    //>    @attr    dynamicForm.showTitlesWithErrorMessages     (Boolean : false : [IRW])
    //          Indicates whether on validation failure, the error message displayed to the
    //          user should be pre-pended with the title for the item.
    //      @group  validation
    //      @visibility external
    //<
    // This property is referenced by 'formItem.getErrorHTML()'
//    showTitlesWithErrorMessages : false,

    //>    @attr dynamicForm.hiliteRequiredFields (Boolean : true : IRW)
    // Indicates whether the titles of required items in this form should use the special
    // prefix and suffix specified by the +link{dynamicForm.requiredTitlePrefix} and
    // +link{dynamicForm.requiredTitleSuffix} attributes, instead of the standard prefix and suffix.
    // @group formTitles
    // @visibility external
    //<
    hiliteRequiredFields:true,


    // override setHoverFocusKey() and propagate the new value to items that have a child canvas
    setHoverFocusKey : function (hoverFocusKey) {
        this.Super("setHoverFocusKey", arguments);
        if (!this.items) return;
        for (var i=0; i<this.items.length; i++) {
            // check for underscore-prefixed method - this is present on CanvasItems and pushes
            // the new value to the child canvas, unless the item has a local value
            if (this.items[i]._setHoverFocusKey) {
                this.items[i]._setHoverFocusKey(hoverFocusKey);
            }
        }
    },

    // override setHoverPersist() and propagate the new value to items that have a child canvas
    setHoverPersist : function (hoverPersist) {
        this.hoverPersist = hoverPersist;
        if (!this.items) return;
        for (var i=0; i<this.items.length; i++) {
            if (this.items[i]._setHoverPersist) this.items[i]._setHoverPersist(hoverPersist);
        }
    },


    //>    @attr dynamicForm.requiredTitlePrefix (HTMLString : "<b>" : IRW)
    // The string pre-pended to the title of every required item in this form if
    // +link{hiliteRequiredFields} is true.
    // @group formTitles
    // @visibility external
    //<
    requiredTitlePrefix:"<b>",

    //>    @attr dynamicForm.requiredRightTitlePrefix (HTMLString : "<b>:&nbsp;" : IRW)
    // The string pre-pended to the title of every required item in this form if
    // +link{hiliteRequiredFields} is true and the +link{titleOrientation} property is set to "right".
    // @group formTitles
    // @visibility external
    //<
    requiredRightTitlePrefix:"<b>:&nbsp;",

    //>    @attr dynamicForm.requiredTitleSuffix (HTMLString : "&nbsp;:</b>" : [IRW])
    // The string appended to the title of every required item in this form if
    // +link{hiliteRequiredFields} is true.
    // @group  formTitles
    // @visibility external
    //<
    requiredTitleSuffix:"&nbsp;:</b>",

    //>    @attr dynamicForm.requiredRightTitleSuffix (HTMLString : "</b>" : [IRW])
    // The string appended to the title of every required item in this form if
    // +link{hiliteRequiredFields} is true and the +link{titleOrientation} property is set to "right".
    // @group formTitles
    // @visibility external
    //<
    requiredRightTitleSuffix:"</b>",

    //> @attr dynamicForm.requiredMessage (HTMLString : null : [IRW])
    // The required message for required field errors.
    // @group formTitles
    // @visibility external
    //<


    // Generic item defaults
    // ---------------------------------------------------------------------------------------

    //> @attr dynamicForm.canEdit (Boolean : null : IRWA)
    // If set to <code>false</code>, the form will be marked read-only. A widget on the form
    // is editable if either (1) beginning with the widget and continuing up the containment
    // hierarchy, including the form, the first widget to have a non-null <code>canEdit</code>
    // attribute has canEdit:true, or (2) neither the widget nor any parent has a non-null
    // <code>canEdit</code> attribute. This setting allows you to enable or disable the default
    // editability of the form's items at one time.
    // <p>
    // This setting differs from the enabled/disabled state in that most form items will
    // allow copying of the contents while read-only but do not while disabled.
    // <p>
    // Note that a form is considered editable if <code>canEdit</code> is null (default) or
    // <code>true</code>.
    //
    // <smartgwt><P>Note that this property may validly be <code>null</code> as a distinct state
    // from <code>false</code>.  See +link{fieldIsEditable()} for an API that will always
    // return <code>true</code> or <code>false</code> and give a definitive answer as to whether
    // editing is possible.</smartgwt>
    //
    // @see DynamicForm.readOnlyDisplay
    // @group readOnly
    // @visibility external
    //<

    //> @type ReadOnlyDisplayAppearance
    // Dictates the appearance of form items when +link{FormItem.canEdit} is set to
    // <code>false</code>.
    //
    // @value "static" Item value should appear within the form as a static block of text,
    // similar to the default appearance of a +link{StaticTextItem}. This appearance may be
    // modified via +link{FormItem.readOnlyTextBoxStyle} and +link{formItem.clipStaticValue}.
    // @value "readOnly" Item should appear unchanged, but user interaction to edit the item
    // will be disallowed. Note that some interactions will be allowed, such as selecting text
    // within a read-only +link{TextItem} for copy and paste. Exact implementation may vary by
    // form item type.
    // @value "disabled" Item will appear disabled.
    //
    // @see attr:DynamicForm.readOnlyDisplay
    // @see attr:FormItem.readOnlyDisplay
    // @visibility external
    //<

    //> @attr dynamicForm.readOnlyDisplay (ReadOnlyDisplayAppearance : "readOnly" : IRW)
    // If +link{DynamicForm.canEdit} is set to <code>false</code>, how should the items in this
    // form be displayed to the user?
    // <p>
    // Can be overridden via +link{FormItem.readOnlyDisplay} on individual form items.
    // @group appearance
    // @group readOnly
    // @visibility external
    //<
    readOnlyDisplay: "readOnly",

    //> @attr dynamicForm.readOnlyTextBoxStyle (FormItemBaseStyle : "staticTextItem" : IRW)
    // Default +link{FormItem.readOnlyTextBoxStyle} setting for items in this form.
    // @visibility external
    //<
    readOnlyTextBoxStyle: "staticTextItem",

    //> @attr dynamicForm.showImageAsURL (boolean : false : IRW)
    // For fields of +link{type:FormItemType,type:"image"}, if the field is non editable, and
    // being displayed with +link{formItem.readOnlyDisplay,readOnlyDisplay:"static"}, should
    // the value (URL) be displayed as text, or should an image be rendered?
    // <P>
    // May be overridden for individual items via +link{formItem.showImageAsURL}.
    // @visibility external
    //<
    showImageAsURL:false,

    //> @attr dynamicForm.clipStaticValue (Boolean : null : IR)
    // Default +link{FormItem.clipStaticValue} setting for items in this form. When unset, this
    // is equivalent to <code>false</code>.
    // @visibility external
    //<
    //clipStaticValue: null,

    //> @attr dynamicForm.showDeletions (Boolean : null : IRA)
    // Default +link{FormItem.showDeletions} setting for items in this form.
    // @visibility external
    //<
    //showDeletions: null,

    //> @attr dynamicForm.wrapHintText (Boolean : true : IR)
    // Should items within this form that are showing a +link{FormItem.hint} have the hint text
    // wrap? May be overridden at the item level via +link{FormItem.wrapHintText}. If
    // <code>wrapHintText</code> is unset on both the form and item, then the default behavior
    // is not wrapping the hint.
    // <p>
    // This setting does not apply to hints that are +link{TextItem.showHintInField,shown in field}.
    // @see DynamicForm.minHintWidth
    // @visibility external
    //<
    wrapHintText: true,

    //> @attr dynamicForm.minHintWidth (Integer : 80 : IR)
    // Minimum horizontal space made available for +link{formItem.hint} text.
    // Typically this reflects how much space the hint text takes up before it wraps.
    // May be overridden at the item level via +link{FormItem.minHintWidth}.
    // <p>
    // This setting does not apply to hints that are +link{TextItem.showHintInField,shown in field}.
    // @see DynamicForm.wrapHintText
    // @visibility external
    //<
    minHintWidth: 80,


    // Hovers
    // ---------------------------------------------------------------------------------------

    // Turn off standard form item hover handling - we're doing our own custom handling instead.
    canHover:false,

    //> @attr dynamicForm.itemHoverDelay (number : 500 : [IRW])
    // If the user rolls over an item, how long a delay before we fire any hover action / show
    // a hover for that item?
    // @see FormItem.hoverDelay
    // @group Hovers
    // @visibility external
    //<
    itemHoverDelay:500,

    //> @attr dynamicForm.itemHoverWidth (Number | String : null : [IRW])
    // A default width for hovers shown for items
    // @see FormItem.hoverWidth
    // @group Hovers
    // @visibility external
    // @example itemHoverHTML
    //<

    //> @attr dynamicForm.itemHoverHeight (Number | String : null : [IRW])
    // A default height for hovers shown for items
    // @see FormItem.hoverHeight
    // @group Hovers
    // @visibility external
    //<

    //> @attr dynamicForm.itemHoverAlign (Alignment  : null : [IRW])
    // Text alignment for hovers shown for items
    // @see FormItem.hoverAlign
    // @group Hovers
    // @visibility external
    //<

    //> @attr dynamicForm.itemHoverVAlign (Number | String : null : [IRW])
    // Vertical text alignment for hovers shown for items
    // @see FormItem.hoverVAlign
    // @group Hovers
    // @visibility external
    //<

    //> @attr dynamicForm.itemHoverStyle (CSSStyleName  : "formHover" : [IRW])
    // CSS Style for hovers shown for items
    // @see FormItem.hoverStyle
    // @group Hovers
    // @visibility external
    //<
    itemHoverStyle:"formHover",

    //> @attr dynamicForm.itemHoverOpacity (number : null : [IRW])
    // Opacity for hovers shown for items
    // @see FormItem.hoverOpacity
    // @group Hovers
    // @visibility external
    //<

    //> @attr dynamicForm.itemHoverRect (Object : null : [IRWA])
    // Object of the form <code>{left:[value], top:[value], width:[value], height:[value]}</code>
    // for specifying an explicit position for the item hovers to appear.
    // @see FormItem.hoverRect
    // @group Hovers
    // @visibility internal
    //<


    //> @attr dynamicForm.showOldValueInHover (Boolean : null : IRWA)
    // Default setting for the form items' +link{FormItem.showOldValueInHover} setting.
    // @visibility external
    //<

    //> @attr dynamicForm.originalValueMessage (HTMLString : "Original value: $value" : IRWA)
    // Default template HTML string when an item does not set its own +link{FormItem.originalValueMessage}.
    // <p>
    // Variables in the template are substituted as follows:
    // <table border="1">
    // <tr>
    //   <th>Variable</th>
    //   <th>Substitution</th>
    // </tr>
    // <tr>
    //   <td><code>$value</code></td>
    //   <td>The item's old value as stored in the
    //       <smartclient>object</smartclient><smartgwt>map</smartgwt>
    //       returned by +link{method:getOldValues()}.</td>
    // </tr>
    // <tr>
    //   <td><code>$newValue</code></td>
    //   <td>The item's new value.</td>
    // </tr>
    // </table>
    // <p>
    // For <code>$value</code> and <code>$newValue</code>, any formatters or stored/display value
    // mapping will be applied.
    // @group i18nMessages
    // @visibility external
    //<
    originalValueMessage: "Original value: $value",

    // Sizing
    // --------------------------------------------------------------------------------------------

    // we can't perfectly control the drawn sizes of all form elements, hence by default we
    // show overflow.  Our defaultHeight acts as a minimum.
    overflow:isc.Canvas.VISIBLE,
    defaultHeight:20,

    // Validation
    // --------------------------------------------------------------------------------------------
    //>    @attr    dynamicForm.errors        (Object : null : [IRW])
    //          A property list of itemName:errorMessage pairs, specifying the set of error messages
    //          displayed with the corresponding form elements. Each errorMessage may be either a
    //          single string or an array of strings, for example:<br><br>
    //          <code>{fieldName:errors, fieldName:errors}</code><br><br>
    //          where each <code>errors</code> object will be either an error message string or an array
    //          of error message strings.
    // @group validation
    //      @visibility external
    //<

    //> @attr dynamicForm.validateOnChange (Boolean : false : IRW)
    // If true, form fields will be validated when each item's "change" handler is fired
    // as well as when the entire form is submitted or validated.
    // <p>
    // Note that this property can also be set at the item level or on each validator
    // to enable finer granularity validation in response to user interaction.
    // If true at the form or field level, validators not explicitly set with
    // <code>validateOnChange:false</code> will be fired on change - displaying errors and
    // rejecting the change on validation failure.
    // @group validation
    // @visibility external
    // @see FormItem.validateOnChange
    //<

    validateOnChange:false,

    //>@attr dynamicForm.rejectInvalidValueOnChange (boolean : null : IRWA)
    // If validateOnChange is true, and validation fails for an item on change, with no suggested
    // value, should we revert to the previous value, or continue to display the bad value entered
    // by the user. May be set at the item or form level.
    // @visibility external
    //<
    // Introduced for back-compat: pre 7.0beta2 this was the default behavior, so enable this flag
    // at the item or form level if required for backcompat.
    //rejectInvalidValueOnChange:null,

    //> @attr dynamicForm.unknownErrorMessage (HTMLString : "Invalid value" : [IRW])
    // The error message for a failed validator that does not specify its own errorMessage.
    // @group validation, i18nMessages
    // @visibility external
    //<
    // Inherited from DBC
//    unknownErrorMessage : "Invalid value",

    //> @attr dynamicForm.noErrorDetailsMessage (String : "Error during validation; no error details were provided" : IRW)
    // A message to display to the user if server-side validation fails with an error but the
    // server did not provide an error message
    // @group validation, i18nMessages
    // @visibility external
    //<
    // Inherited from DBC
//  noErrorDetailsMessage: "Error during validation; no error details were provided",

    //> @attr dynamicForm.validateOnExit (Boolean : false : IRW)
    // If true, form items will be validated when each item's "editorExit" handler is fired
    // as well as when the entire form is submitted or validated.
    // <P>
    // Note that this property can also be set at the item level to enable finer granularity
    // validation in response to user interaction - if true at either level, validation
    // will occur on editorExit.
    // @visibility external
    // @see formItem.validateOnExit
    //<

    //> @attr dynamicForm.implicitSave (Boolean : false : IRW)
    // When true, indicates that changes to items in this form will be automatically saved on a
    // +link{dynamicForm.implicitSaveDelay, delay}, as well as when the entire form is
    // submitted.  Unless +link{dynamicForm.implicitSaveOnBlur, form.implicitSaveOnBlur} is set
    // to false, changes will also be automatically saved on editorExit for each item.  This
    // attribute can also be set directly on FormItems.
    // @visibility external
    //<

    //> @attr dynamicForm.implicitSaveOnBlur (Boolean : false : IRW)
    // If true, form item values will be automatically saved when each item's "editorExit"
    // handler is fired as well as on a delay and when the entire form is submitted.  This
    // attribute can also be set directly on FormItems.
    // @visibility external
    //<

    //> @attr dynamicForm.implicitSaveDelay (number : 2000 : IRW)
    // When +link{dynamicForm.implicitSave, implicitSave} is true, this attribute dictates the
    // millisecond delay after which form items are automatically saved during editing.
    // @visibility external
    //<
    implicitSaveDelay: 2000,

    //> @attr dynamicForm.stopOnError (boolean : null : IR)
    // Indicates that if validation fails, the user should not be allowed to exit
    // the field - focus will be forced back into the field until the error is corrected.
    // <p>
    // Enabling this property also implies +link{FormItem.validateOnExit} is automatically
    // enabled. If there are server-based validators on this item, setting this property
    // also implies that +link{FormItem.synchronousValidation} is forced on.
    //
    // @visibility external
    //<

    //> @attr  dynamicForm.synchronousValidation (Boolean : false : IR)
    // If enabled, whenever validation is triggered and a request to the server is required,
    // user interactivity will be blocked until the request returns. Can be set for the entire
    // form or individual FormItems.
    // <p>
    // If false, the form will try to avoid blocking user interaction until it is strictly
    // required. That is until the user attempts to use a FormItem whose state could be
    // affected by a server request that has not yet returned.
    //
    // @visibility external
    //<
    synchronousValidation:false,

    // Focus
    // --------------------------------------------------------------------------------------------

    //>    @attr    dynamicForm.autoFocus        (Boolean : false : IRW)
    // If true, when the form is drawn, focus will automatically be put into the first focusable
    // element in the form.<br>
    // Note that to put focus in a different item you can explicitly call
    // <code>dynamicForm.focusInItem(<i>itemName</i>)</code>
    // @group focus
    // @visibility external
    // @see focusInItem()
    //<
    autoFocus:false,

    //> @attr dynamicForm.autoFocusOnError (Boolean : true : IRW)
    // If true, when +link{dynamicForm.validate(),validation} fails focus will automatically
    // be put into the first focusable field which failed validation.
    // @group focus
    // @visibility external
    //<
    autoFocusOnError:true,

    //>    @attr    dynamicForm.selectOnFocus    (Boolean : false : IRW)
    // If this property is set to true, whenever a text-based field in this form
    // (+link{class:TextItem}, +link{class:TextAreaItem}) is given focus programmatically
    // (see +link{DynamicForm.focusInItem()}), all text within the item will be selected.
    // <P>
    // Note that this flag affects only programmatic focus.  It's the normal behavior of text
    // fields to select all text if the user navigates into them via keyboard, or if the user
    // navigates via mouse, to place the text insertion point at the mouse click, and
    // SmartClient preserves these behaviors.  <code>selectOnFocus</code> is only needed for
    // cases like a form within a pop-up dialog that should have the first field selected.
    // <P>
    // If you also want the value to be selected when the user clicks on the field, set
    // +link{dynamicForm.selectOnClick, selectOnClick} instead.
    // <P>
    // If <code>selectOnFocus</code> is false, the selection is not modified on focus - any
    // previous selection within the item will be maintained.
    // <P>
    // May be overridden at the form item level via +link{formItem.selectOnFocus}.
    //
    // @group focus
    // @visibility external
    //<
    selectOnFocus:false,

    //>    @attr    dynamicForm.selectOnClick    (Boolean : false : IRW)
    // If this property is set to true, whenever a text-based field in this form
    // (+link{class:TextItem}, +link{class:TextAreaItem}) is given focus - whether
    // programmatically (see +link{DynamicForm.focusInItem()}), or via a mouse click, all text
    // within the item will be selected.
    // <P>
    // If you only want the value to be selected when on programmatic focus or keyboard
    // navigation (this is the native browser behavior), set
    // +link{dynamicForm.selectOnFocus, selectOnFocus} instead.
    // <P>
    // May be overridden at the form item level via +link{formItem.selectOnClick}.
    //
    // @group focus
    // @visibility external
    //<
    selectOnClick:false,

    //> @attr   dynamicForm.canFocus    (Boolean : true : IRWA)
    // DynamicForms are considered to have focus if any of their form items have focus.
    // Note that setting <code>dynamicForm.canFocus</code> to false will have no effect on
    // whether form items within the form may receive focus. This property will only govern
    // whether the form may receive focus if the form contains no focusable items.
    // @group focus
    // @visibility external
    //<
    // Focus behavior for forms is a little different than for other elements.
    // o _canFocus() always returns true if the form contains any focusable items
    //   (required to allow programmatic focus() on the form / proper keyboard event handling)
    // o Set _useNativeTabIndex to false - we don't want the form to ever have native focus (instead
    //   native focus will always go to the form items).
    //   Note - we don't want to set tabIndex to -1, as the form items will default to having their
    //   form's tabIndex as their own tabIndex.
    // o Set _useFocusProxy to false - same reason as setting _useNativeTabIndex to false.
    // o Override focus() to call focusInItem() (below)
    // o Override _focusChanged() to blur the focus item on a blur() call (below)
    // - see also comments on form item tabIndex in formItem.js
    canFocus : true,
    _useNativeTabIndex:false,
    _useFocusProxy:false,

    // AutoComplete
    // --------------------------------------------------------------------------------------------

    //> @type AutoComplete
    // AutoComplete behavior for +link{formItem,FormItems}.
    // @value "none" Disable browser autoComplete. Note that some browsers will disregard
    //    this setting and still perform native autoComplete for certain items - typically
    //    only for log in / password forms. See the discussion +link{formItem.autoComplete,here}.
    // @value "native" Allow native browser autoComplete.
    // @group autoComplete
    // @visibility external
    //<
    // @value "smart" Enable SmartClient autoComplete feature.  Suppresses browser's
    //                built-in autoComplete feature where applicable.

    //>    @attr    dynamicForm.autoComplete   (AutoComplete : "none" : IRW)
    // Should this form allow browser auto-completion of its items' values?
    // Applies only to items based on native HTML form elements (+link{TextItem},
    // +link{PasswordItem}, etc), and will only have a user-visible impact for browsers
    // where native autoComplete behavior is actually supported and enabled via user settings.
    // <P>
    // This property may be explicitly specified per item via +link{formItem.autoComplete}.
    // <P>
    // Note that even with this value set to <code>"none"</code>, native browser
    // auto-completion may occur for log in forms (forms containing username and
    // +link{PasswordItem,password} fields). This behavior varies by browser, and is
    // a result of an
    // +externalLink{https://www.google.com/search?q=password+ignores+autocomplete+off,intentional change by some browser developers}
    // to disregard the HTML setting <i>autocomplete=off</i> for password items or
    // log-in forms.
    //
    // @see formItem.autoComplete
    // @group autoComplete
    // @visibility external
    //<

    autoComplete:"none",

    //>    @attr    dynamicForm.uniqueMatch   (boolean : true : IRW)
    // When +link{formItem.autoComplete} is set to <code>"smart"</code>,
    // whether to offer only unique matches to the user.
    // <p>
    // Can be individually enabled per TextItem, or if set for the form as a whole, can
    // be set differently for individual items.
    //
    // @see formItem.uniqueMatch
    // @group autoComplete
    // @visibility autoComplete
    //<
    uniqueMatch:true,


    // Spellcheck:
    //>@attr    DynamicForm.browserSpellCheck   (Boolean : true : IRW)
    // If this browser has a 'spellCheck' feature for text-based form item elements, should
    // it be used for items in this form? Can be overridden at the item level via
    // +link{FormItem.browserSpellCheck}
    // <P>
    // Notes:<br>
    // - this property only applies to text based items such as TextItem and TextAreaItem.<br>
    // - this property is not supported on all browsers.
    //
    // @see formItem.browserSpellCheck
    // @visibility external
    //<

    browserSpellCheck:true,

    // Direct Submit
    // --------------------------------------------------------------------------------------------
    //>    @attr dynamicForm.validationURL        (URL : null : IRW)
    // validationURL can be set to do server-side validation against a different URL from where
    // the form will ultimately save, as part of an incremental upgrade strategy for
    // Struts-like applications.
    // <P>
    // If set, calling +link{method:DynamicForm.submit()} causes an RPC to be sent to this URL to
    // perform server-side validation of the form values.  If the validation fails, the
    // validation errors returned by the server are rendered in the form.  If the validation
    // succeeds, the form is submitted to the URL specified by +link{attr:DynamicForm.action}.
    // <p>
    // The form values are available on the server as request parameters (just like a normal form
    // submit) and also as the values of a DSRequest sent as an RPC alongside the normal
    // submit.
    // <p>
    // The expected response to this request is a DSResponse sent via the RPC mechanism.  If
    // validation is successful, an empty response with the STATUS_SUCCESS status code is
    // sufficient.  If there are validation errors, the DSResponse should have the status set to
    // STATUS_VALIDATION_ERROR and the errors should be set on the response via the
    // addError()/setErrorReport() API on DSResponse.  See the javadoc for DSResponse for
    // details.
    //
    // @group validation
    // @visibility external
    // @see DynamicForm.saveData()
    // @see DynamicForm.submit()
    //<

    //>    @attr dynamicForm.disableValidation        (boolean : null : IRW)
    //
    // If set to true, client-side validators will not run on the form when validate() is
    // called.  Server-side validators (if any) will still run on attempted save.
    //
    // @group validation
    // @visibility external
    // @see DynamicForm.saveData()
    // @see DynamicForm.submit()
    //<

    //>    @attr    dynamicForm.action        (URL : "#" : IRW)
    // The URL to which the form will submit its values.
    // <p>
    // <b>NOTE:</b> this is used only in the very rare case that a form is used to submit data
    // directly to a URL.  Normal server contact is through RPCManager.<br>
    // See +link{DynamicForm.canSubmit} for more on this.
    //
    // @see group:operations
    // @see class:RPCManager
    //
    //      @visibility external
    //      @group  submitting
    //<
    //    XXX SHOULD SUPPORT [APP], [ISOMORPHIC], etc. special directories
    // Note: if this property is modified from the class default, and saveData() is called,
    // the rpcManager code will perform its request as a direct submission to the action URL
    // by setting request.directSubmit
    action:"#",

    //>    @attr    dynamicForm.target        (String : null : IRWA)
    // The name of a window or frame that will receive the results returned by the form's
    // action. The default null indicates to use the current frame.
    // <p>
    // <b>NOTE:</b> this is used only in the very rare case that a form is used to submit data
    // directly to a URL.  Normal server contact is through
    // +link{group:dataBoundComponentMethods,DataBound Component Methods}.
    //      @group  submitting
    //      @visibility external
    //<

    //>    @attr    dynamicForm.method        (FormMethod : isc.DynamicForm.POST : [IRW])
    // The mechanism by which form data is sent to the action URL. See FormMethod type
    // for details.
    // <p>
    // <b>NOTE:</b> this is used only in the very rare case that a form is used to submit data
    // directly to a URL.  Normal server contact is through
    // +link{group:dataBoundComponentMethods,DataBound Component Methods}.
    //      @group  submitting
    //      @visibility external
    //<
    method:isc.DynamicForm.POST,

    //>    @attr    dynamicForm.encoding        (Encoding : DynamicForm.NORMAL : IRWA)
    // encoding for the form, use MULTIPART_ENCODING for file upload forms
    // @group submitting
    // @visibility external
    //<
    encoding:isc.DynamicForm.NORMAL_ENCODING,

    //>    @attr    dynamicForm.canSubmit        (Boolean : false : IRWA)
    // Governs whether this form will be used to perform a standard HTML form submission.
    // Note that if true, +link{DynamicForm.submit()} will perform a native HTML submission
    // to the specified +link{DynamicForm.action} URL.<br>
    // Wherever possible we strongly recommend using the
    // +link{group:dataBoundComponentMethods,DataBound Component Methods} to send data to
    // the server as they provide a far more sophisticated interface, with built in
    // options for server validation, required fields, etc.<br>
    // @group    submitting
    // @visibility external
    //<
    // Defaulted to false, as we usually do not want direct submission behavior.
    // Note: if true, and saveData() is called, the rpcManager code will perform its request
    // as a direct submission to the action URL by setting request.directSubmit

    // whether to write the <form> tag

    writeFormTag:true,


    //> @attr   dynamicForm.saveOnEnter (Boolean : false :IRW)
    // If <code>true</code>, when the user hits the Enter key while focused in a text-item in
    // this form, we automatically submit the form to the server using the
    // +link{dynamicForm.submit()} method.
    // @visibility external
    // @group submitting
    //<

    //> @attr dynamicForm.revertValueKey (KeyIdentifier : null : IR)
    // Keyboard shortcut that causes the value of the currently focused form item to be reverted
    // to whatever value would be shown if +link{DynamicForm.resetValues()} were called.
    // @example pendingValues
    // @visibility external
    //<


    //>    @attr    dynamicForm.autoSendTarget        (boolean : false : IRWA)
    // Should we send the form target name to the server automatically?
    //        @group    submitting
    //<
    // if autoSendTarget is true, we automatically add a hidden field to the form that tells the
    // server the name of the target the form was submitting to.  This is useful for
    // re-authentication purposes.

    //>    @attr    dynamicForm.autoSendTargetFieldName        (String : "__target__" : IRWA)
    // Name of the field in which the form target will be set
    //        @group    submitting
    //<
    autoSendTargetFieldName:"__target__",

    // useNativeSelectItems
    // Determines whether items of type "select" or "SelectItem" should be rendered as
    // our ISC SelectItems or NativeSelectItems

    useNativeSelectItems:false,

    //> @attr dynamicForm.operator (OperatorId : "and" : IR)
    // When +link{formItem.operator} has been set for any +link{FormItem} in this form, what
    // logical operator should be applied across the +link{Criterion,criteria} produced by the form
    // items?  Only applicable to forms that have a +link{DataBoundComponent.dataSource,dataSource}.
    //
    // @visibility external
    //<
    operator: "and",

    //> @attr dynamicForm.showComplexFieldsRecursively (Boolean : null : IR)
    // If set, this <code>DynamicForm</code> will set both
    // +link{DataBoundComponent.showComplexFields,showComplexFields} and
    // <code>showComplexFieldsRecursively</code> on any nested component used for showing/editing
    // a complex field.  Thus any of this form's items that handle complex fields will themselves
    // also show complex fields.  This allows for handling of field structures of any complexity.
    // <p>
    // If set, this value automatically sets +link{DataBoundComponent.showComplexFields,showComplexFields}
    // as well.
    //
    // @visibility external
    //<

    //> @attr dynamicForm.nestedEditorType (String : "NestedEditorItem" : IRW)
    // +link{class:FormItem} class to use for any singular (ie, non-list) complex fields
    // on this DynamicForm.
    //
    // @see nestedListEditorType
    // @visibility external
    //<
    nestedEditorType: "NestedEditorItem",

    //> @attr dynamicForm.nestedListEditorType (String : "NestedListEditorItem" : IRW)
    // +link{class:FormItem} class to use for any list-type complex fields on this DynamicForm.
    // List-type fields are denoted by marking them <code>multiple: true</code> in the
    // DataSource.
    //
    // @see nestedEditorType
    // @visibility external
    //<
    nestedListEditorType: "NestedListEditorItem",

    canDropItems: false,
    canAddColumns: true,

    //> @attr dynamicForm.showPending (Boolean : null : IRA)
    // This property applies to all of the items that a form has, and works according to
    // +link{FormItem.showPending}. <P>
    // Also, in a form with showPending:true, an individual +link{FormItem} can set
    // showPending:false and vice versa.
    // @visibility external
    //<
    showPending:null

    //> @attr dynamicForm.dataFetchMode (FetchMode : "paged" : IRW)
    // @include dataBoundComponent.dataFetchMode
    //<

    //> @attr dynamicForm.dataSource (DataSource | ID : null : IRW)
    // @include dataBoundComponent.dataSource
    //<

    //> @attr dynamicForm.defaultSearchOperator (OperatorId : null : IR)
    // Default +link{type:OperatorId,search operator} to use for fields in a form that produces
    // +link{AdvancedCriteria}.  Default is "iContains" unless +link{allowExpressions} is
    // enabled for the form as a whole, in which case the default is
    // +link{dataSource.translatePatternOperators,"iContainsPattern"}.
    // <p>
    // Does not apply to special fields where exact match is obviously the right default
    // setting, such as fields of type:"enum", or fields with a
    // +link{formItem.valueMap,valueMap} or  +link{formItem.optionDataSource,optionDataSource}.
    // <p>
    // <code>defaultSearchOperator</code> also has no effect in a form that does not produce
    // <code>AdvancedCriteria</code> - see +link{dynamicForm.getValuesAsCriteria()} for
    // settings that cause a form to produce AdvancedCriteria.
    // @visibility external
    //<

    //> @method dynamicForm.viewSelectedData()
    // @include dataBoundComponent.viewSelectedData()
    // @group dataBoundComponentMethods
    // @visibility external
    //<
});

// add default methods
isc.DynamicForm.addMethods({


//---------------------------
//    Data initialization
//---------------------------


//>    @method    dynamicForm.initWidget()    (A)
//            initialize the form object
//
//            initializes th list of fields
//            sets up the data (if specified)
//            clears the errors array
//
//        @param    [all arguments]    (Object)    objects with properties to override from default
//<
initWidget : function () {
    if (isc._traceMarkers) arguments.__this = this;

    if (!isc.DynamicForm._operatorIndex) isc.DynamicForm.buildOperatorIndex();

    // does String -> Array conversion if needed
    this.setColWidths(this.colWidths);

    // default linearMode to true on handset devices if linearOnMobile is set
    if (this.linearMode == null && this.linearOnMobile && isc.Browser.isHandset) {
        this.linearMode = true;
    }
    // configure form for linear mode if enabled
    if (this.linearMode) this._setLinearMode(true);

    // call the superclass function
    this.Super("initWidget",arguments);

    // Set this-level showComplexFields if showComplexFieldsRecursively has been set
    if (this.showComplexFieldsRecursively) this.showComplexFields = true;

    // allow for fields instead of items specification
    if (this.fields && this.items == null) this.items = this.fields;

    // If we have a set of 'defaultItems' in an array, and the developer hasn't set the items
    // property, use the defaultItems array instead.
    // Notes:
    // - The 'defaultItems' property would typically be set on the instance prototype this class
    //   (or subclasses).
    // - In each instance we *copy* the defaultItems array into this.items, and avoid manipulating
    //   it directly.  This means specific instances will not write properties out into the
    //   instance prototype's 'defaultItems' array (which would happen if manipulated directly as
    //   it is passed by reference to each instance, so all instances point to the same object)
    // When creating a DynamicForm subclass, for which each instance should show a specific set
    // of items by default, the defaultItems property should be set on the instance prototype.
    // Setting the items property directly on the instance prototype is a bad idea as each
    // instance will then point to the same items array.
    // (Used in Editor.js)
    if (this.defaultItems != null && this.items == null) {
        this.items = [];
        for (var i = 0; i < this.defaultItems.length; i++) {
            this.items[i] = isc.addProperties({}, this.defaultItems[i]);
        }
    }

    // Default values to an empty list.
    if (this.values == null) this.values = {};

    // explicitly call setAction() if the action has been overridden so we set the explicitAction
    // flag
    if (this.action != isc.DynamicForm.getPrototype().action &&
        this.action != null && !isc.isA.emptyString(this.action))
    {
        this.setAction(this.action);
    }


    if (this.valuesManager != null) {
        // If we have a valuesManager and it is a string, check if it's a global ID for a VM
        // and use that - otherwise, initializeValuesManager() will auto-create it later
        if (isc.isA.String(this.valuesManager)) {
            if (window[this.valuesManager]) {
                this.valuesManager = window[this.valuesManager];
            } else if (this.getByLocalId(this.valuesManager)) {
                this.valuesManager = this.getByLocalId(this.valuesManager);
            }
        }

        if (isc.isA.ValuesManager(this.valuesManager)) {
            if (this.dataSource == null && this.valuesManager.dataSource != null) {
                this.dataSource = this.valuesManager.dataSource;
            }
        }
    }

    // If the form or any of its items specify dataPath, but not dataSource, this implies that
    // the form will later be rebound.  This introduces all sorts of implications because the
    // field properties should now inherit from the corresponding dataSource field.  So, we
    // must hold onto the original field config so the rebinding process can use it.

    if (!this.dataSource) {
        var items = this.items || [];
        for (var i = 0; i < items.length; i++) {
            if (items[i] == null) continue;
            if (this.dataPath || items[i].dataPath) {
                this._itemsConfig = isc.shallowClone(items);
                break;
            }
        }
    }

    // make sure this.dataSource is a DS instance
    if (this.dataSource) this.dataSource = this.getDataSource();

    // initialize the list of fields, defaulting to an empty list
    // Note: We set up the items (and set their values / eval defaultDynamicValue) at Form init
    // time so that a developer can define a form and then work with the items before drawing the
    // form using the standard form item APIs.
    // This is in contrast to the approach used (for example) in the ListGrid, where the component
    // parts of the LG (header, body, etc.) are not created until draw in order to minimize the
    // cost associated with changing the dataSource / data /etc. while the widget is undrawn.
    this._setItems(this.items ? this.items : null, true);

    // If we've been marked as disabled explicitly disable all form items.
    if (this.isDisabled()) {
        this.setDisabled(true);
    }

    // initialize the form errors, defaulting to an empty list
    this.setErrors(this.errors ? this.errors : {});

    // initialize the form values, via 'setValues()'
    // this automatically remembers the old values for us as well
        this.setValues(this.values, true);

    // If we have a selectionComponent, call the setter method to set up observation of selection
    if (this.selectionComponent != null) this.setSelectionComponent(this.selectionComponent,true);

},

_destroyItems : function (items) {
    if (!items) return;
    if (!isc.isA.FormItem(items[0])) return;
    items.callMethod("destroy");

    this.destroyOrphanedItems("containing form destroyed");
},

destroy : function () {
    this._removeItemWhenRules();

    if (this.valuesManager && this.valuesManager.removeMember) {
        this.valuesManager.removeMember(this);
    }
    this._destroyItems(this.items);
    this.Super("destroy", arguments);
},

// Override 'setHandleDisabled' to disable / enable all items
setHandleDisabled : function (disabled) {
    if (this.isDrawn()) {
        if (this.redrawOnDisable) this.markForRedraw("setDisabled");
        this._disablingForm = true;
        this.disableKeyboardEvents(disabled);
        delete this._disablingForm;
    }

    var items = this.getItems();
    for (var i = 0; i < items.length; i ++) {

        items[i].updateDisabled(true);
    }
},


disableKeyboardEvents : function (disabled, recursive, disablingForm) {


    var disablingForm = this._disablingForm;
    var wasDisabled = this._keyboardEventsDisabled;
    this.Super("disableKeyboardEvents", arguments);
    // by default disabling the form will also disable all items within it (no need to explicitly
    // suppress keyboard access to them)
    // If the form is not being disabled but just having keyboard access suppressed (EG for
    // a clickMask), notify the form items individually
    if (!disablingForm && (wasDisabled != disabled)) {
        // We'll have FormItem.getGlobalTabIndex() check this attribute.
        this._keyboardEventsDisabled = disabled;
        this.markForRedraw("Disable Keyboard events on items");
    }
},

//>    @method    dynamicForm.applyFieldDefaults()
//        @group    data
//         Selects the appropriate form item type for fields if not specified,
//         based on schema information.
//<
applyFieldDefaults : function (fields) {
    if (fields == null) return;

    for (var i = 0; i < fields.length; i++) {
        var field = fields[i];

        // This null check will avoid JS errors if someone defines an array of fields with
        // a trailing comma in IE
        if (field == null) return;

    }
},

//>    @method dynamicForm.getEditorType()  ([A])
//
// Returns the form item type (Class Name) to be created for some field.<br>
// By default <code>field.editorType</code> will be used if present - otherwise backs off to
// deriving the appropriate form item type from the data type of the field (see
// +link{type:FormItemType} for details).
//
//  @group  editing
//
//  @param  field   (Object)    field definition for which we are deriving form item type.
//  @param [values] (Object)    Current set of values being edited by this form. May be null.
//  @return         (String)  form item type for the field
//  @visibility external
//<
getEditorType : function (field, values) {
    return this.getClass().getEditorType(field, this, values);
},

// getFieldType() - returns the data type for some field.
getFieldType : function (field, values) {

    if (field.type != null &&
      // if field.type is "any", field type is likely driven by another field.
      (field.type != "any" || field.fieldTypeProperty == null))
    {
        return field.type;
    }

    if (field.criteriaField && this.dataSource) {
        var ds = isc.DataSource.get(this.dataSource);
        var criteriaField = ds ? ds.getField(field.criteriaField) : null;
        if (criteriaField) return criteriaField.type;
    }

    // derive type from field definition's optionDataSource
    if (field.optionDataSource && field.getValueFieldName) {
        var ds = isc.DataSource.get(field.optionDataSource);
        var dsField = ds ? ds.getField(field.getValueFieldName()) : null;
        if (dsField) return dsField.type;
    }

    // If a field has no explicit type, but has "fieldTypeProperty" set, this should
    // be another field (of type FieldType), which will drive the type of this field.

    if (field.fieldTypeProperty != null) {
        if (values == null) values = this.values;
        if (values && values[field.fieldTypeProperty] != null) {
            return values[field.fieldTypeProperty];
        }
    }

    return null;
},

_itemChanged : function (item, value) {
    if (!item.suppressItemChanged) {
        if (this.itemChanged != null) {
            this.itemChanged(item, value);
        }
        if (this.valuesManager && this.valuesManager.itemChanged) {
            // fire itemChanged() on the VM, if there is one
            this.valuesManager.itemChanged(item, value);
        }
    }
    if (this._fireRuleContextOnItemChange) {
        this.fireRuleContextChanged(this);
    }
},

_canonicalizeItems : function (itemList) {
    if (itemList != null) {
        for (var i = 0; i < itemList.length; i++) {
            var invalidItem = false;
            if (itemList[i] == null) {
                this.logWarn("Encountered empty entry in items array - removing this entry.")
                invalidItem = true;
            }
            if (isc.isA.Canvas(itemList[i])) {
                this.logWarn("Encountered a Canvas instance:" + itemList[i] + " in the items " +
                             "array - the DynamicForm items array should contain only FormItem " +
                             "definitions. Removing this entry.");
                 invalidItem = true;
            }
            if (invalidItem) {
                itemList.removeAt(i);
                i -= 1;
            }
        }
    }
},

//> @method dynamicForm.setHilites()
// Only supported on ListGrid for now.
// @include dataBoundComponent.setHilites()
// @param hilites (Array of Hilite) Array of hilite objects
// @group hiliting
// @visibility smartclient
//<

//>    @method    dynamicForm.setItems()
// Synonym for +link{DynamicForm.setFields()}
//
// @group elements
// @param itemList        (Array of FormItem Properties)    list of new items to show in the form
// @visibility external
//<
setItems : function (itemList) {
    this._setItems(itemList);
},
alwaysRecreateItems:false,
_setItems:function (itemList, firstInit) {

    // remove invalid items from itemList
    this._canonicalizeItems(itemList);

    // get field data by binding to a DataSource, if we were provided one.  NOTE we do this first
    // because the returned list of items may be a new list
    itemList = this.bindToDataSource(itemList);

    //this.logWarn("itemList is : " + this.echo(itemList) +
//                  ", this.items is : " + this.echo(this.items) + "\n\n" + this.getStackTrace());
    if (!itemList) itemList = [];
    // If the itemList passed in is the same array object as this.items, duplicate it, as
    // the removeItems call (below) will clear out that array if alwaysRecreateItems is true
    else if (itemList == this.items) itemList = itemList.duplicate();

    // If the new array contains our current live items support shifting them in the
    // items array rather than destroying and recreating them
    var oldItems = this.items ? this.items.duplicate() : null;
    if (!firstInit && itemList != null && this.items != null) {

        for (var i = 0; i < itemList.length; i++) {
            var item = itemList[i];
            if ((this.alwaysRecreateItems == false && !item._mustRecreate) && isc.isA.FormItem(item) &&
                this.items.contains(item))
            {
                oldItems.remove(item);
            }
        }
    }

    // Remove existing item *When rules
    if (!firstInit) this._removeItemWhenRules();

    // remove all existing items (destroy FormItem objects we created)
    if (oldItems != null && oldItems.length > 0 && !firstInit) {
        this.removeItems(oldItems);
    }
    this._addItems(itemList, null, true, firstInit);

    // Add/update ruleContext schema details. For firstInit time, the schema is automatically
    // added by draw(). This is only necessary when a new set of fields is applied.
    if (!firstInit) {
        this.addToRuleContextSchema();
    }

    // Create *When rules for new items if needed.
    // Trigger on isc.disableRuleScope even though ruleScope will be null
    // so that individual attempts to define *When criteria will be logged.
    if (this.ruleScope || this.isRuleScope || isc.disableRuleScope) this._createItemWhenRules(this.getItems());
    var rulesEngine = this.getRulesEngine();
    if (!firstInit && rulesEngine) {
        // When resetting rules after initial form creation
        // contextChanged rules need to be fired.
        rulesEngine.processContextChanged();
    }
},

//>    @method    dynamicForm.setFields()
// Set the +link{dynamicForm.fields,items} for this DynamicForm.  Takes an array of item
// definitions, which will be converted to +link{FormItem}s and displayed in the form.
// <P>
// <smartclient>
// Note: Do not attempt to create +link{FormItem} instances directly. This method should be
// passed the raw properties for each item only.
// </smartclient>
// <P>
// Objects passed to <code>setFields()</code> may not be reused in other forms and may not be
// used in subsequent calls to <code>setFields()</code> with the same form, new objects must be
// created instead.
// <P>
// To create a form where some items are conditionally present, rather than repeated calls to
// <code>setFields()</code> or <code>setItems()</code>, you should generally use
// +link{formItem.hide()} and +link{formItem.show()} and/or +link{formItem.showIf} rather than
// calling <code>setItems() or setFields()</code>.  <code>setItems()</code> and
// <code>setFields()</code> are appropriate for dynamically generated forms where there are
// few if any items that are the same each time the form is used.
//
// @param itemList        (Array of FormItem Properties)    list of new items to show in the form
// @group elements
// @visibility external
//<
setFields : function (fieldList) {
    this.setItems(fieldList);
},


//>    @method    dynamicForm.getFields()
// Method to retrieve the +link{dynamicForm.fields, items} for this DynamicForm.
//
// @return (Array of FormItem)
//
// @group elements
// @visibility external
//<
getFields : function () {
    return this.items;
},

// Override the DBC getAllFields method to simply return the items array as well
// (Since we don't maintain a separate completeFields array, and since the default
// getAllFields implementation returns this.fields which is unpopulated for forms)
getAllFields : function () {
    return this.items;
},

//>    @method    dynamicForm.getItems()
// Method to retrieve the +link{dynamicForm.fields, items} for this DynamicForm.
//
// @return (Array of FormItem)
// @group elements
// @visibility external
//<
getItems : function () {
    return this.items;
},

// Override visibleAtPoint to return true if we have any items contained in containerWidgets
// which would be visible at the specified point.

visibleAtPoint : function (x, y, withinViewport, ignoreWidgets) {

    if (this.invokeSuper(isc.DynamicForm, "visibleAtPoint", x,y,withinViewport,ignoreWidgets))
        return true;


    var items = this.items || [],
        containerWidgets = {},
        focusItemIndex = items.indexOf(this.getFocusSubItem());

    for (var i = -1; i < items.length; i++) {

        var itemIndex = i;
        if (i == -1) {
            itemIndex = focusItemIndex;
        // avoid checking the focus item twice
        } else if (itemIndex == focusItemIndex) continue;

        // Catch the case where we had no focusItem;
        if (itemIndex == -1) continue;
        var item = items[itemIndex],
            cw = item.containerWidget;
        if (cw == this || !item.isDrawn() || !item.isVisible()) continue;


        var cwID = cw.getID();
        if (containerWidgets[cwID] == null) {
            containerWidgets[cwID] = cw.visibleAtPoint(x,y,withinViewport, ignoreWidgets);
        }
        if (!containerWidgets[cwID]) continue;


        var PL = item.getPageLeft(),
            PT = item.getPageTop();
        if (PL <= x && (PL + item.getVisibleWidth()) >= x && PT <= y && (PT + item.getVisibleHeight()) >= y) {
            return true;
        }
    }

    return false;
},

// addItems - slot new items into the appropriate position in the items in this DynamicForm

addItems : function (newItems, position) {
    if (!isc.isAn.Array(newItems)) newItems = [newItems];
    if (this.dataSource) {
        var ds = isc.DS.get(this.dataSource);
        for (var i = 0; i < newItems.length; i++) {
            // "name" must be set for combineFieldData to merge in DS field properties
            if (newItems[i].autoName && !newItems[i].name) newItems[i].name = newItems[i].autoName;

            newItems[i] = this.combineFieldData(newItems[i]);

            // on name collision, remove the old item.

            var itemName = newItems[i].name || newItems[i].autoName;
            if (itemName && this.getItem(itemName)) {
                this.removeItem(itemName);
            }


        }
    }
    this.addFieldValidators(newItems);
    if (position == null || position > this.items.length) position = this.items.length;

    this._addItems(newItems, position);

    // Add/update ruleContext schema details
    this.addToRuleContextSchema();
    // And add/update item *When rules
    this._createItemWhenRules(newItems);
},

// This flag is used by DataBoundComponent logic to ensure we pick up
// dataSourceField.editorProperties and apply directly to the fields during the
// bindToDataSource flow
isEditComponent:true,


_$upload : "upload",_$uploadItem:"UploadItem", _$tUploadItem:"TUploadItem",
_$mutex:"mutex",
_addItems : function (newItems, position, fromSetItems, firstInit) {

    this.addingItems = true;

    // adding items will almost always change the tab-index-span used by the form
    // If this increases, we need to catch the case where the tabIndex of our items overlaps
    // the next widget on the page
    var drawn = this.isDrawn();

    //this.logWarn("addItems: " + this.echoAll(newItems));
    // apply type-based field defaults to the items passed in
    // Note: this will not change the type of an already-instantiated form item, so we do this
    // before converting the items init objects to FormItems
    this.applyFieldDefaults(newItems);

    var sectionItems = [];

    // iterate through all the items, creating FormItems from object literals
    var haveUploadFields = false,
        foundFileItem = false,
        mutexSections = (this.sectionVisibilityMode == this._$mutex)
    ;

    for (var itemNum = 0; itemNum < newItems.length; itemNum++) {
        var item = newItems[itemNum];

        // remove any empty items from the list
        if (!item) {
            newItems.removeItem(itemNum);
            itemNum--;
            continue;
        }

        // What if we're passed a live item?
        // - if it's already in our items array
        //  - if alwaysRecreateItems is true continue as normal. It may have already been
        //    destroyed via removeItems. In this case create a new item using this items'
        //    properties as a template. [If its been orphaned but not destroyed this will cause its
        //    destruction thanks to ID collision!]
        //  - otherwise just skip over it and leave it in the items array at the appropriate spot
        // - if it was attached to another form, log an obvious warning!
        var mustCreateItem = true;
        if (isc.isA.FormItem(item)) {
            if (this.alwaysRecreateItems == false && !item._mustRecreate && item.form == this) {
                mustCreateItem = false;
                this.logInfo("setItems() / addItems(): Passed existing item:" + item +
                            ". This item will not be destroyed and recreated.");
            } else {
                if (item.form == this) {
                    this.logInfo("setItems() / addItems(): Passed existing item:" + item +
                                ". This item will be destroyed and recreated.");
                // Being passed a live item from a *different* form implies a coding error
                } else {
                    this.logWarn("setItems() / addItems(): Passed live form item instance:" + item +
                            " currently applied to a different DynamicForm:" + item.form +
                            ". This is unsupported and may lead to unpredictable results.");
                }
            }
        }

        if (mustCreateItem) {
            var itemType = this.getEditorType(item, this.values);
            item._calculatedEditorType = itemType;

            newItems[itemNum] = item = this.createItem(item, itemType);
        }

        if (itemType == this._$upload || itemType == this._$uploadItem ||
                itemType == this._$tUploadItem)
        {
            haveUploadFields = true;
        }

        if (isc.FileItem && isc.isA.FileItem(item) && foundFileItem) {
            this.logWarn("Attempting to creating a form with multiple FileItems. This is " +
                         "not currently supported - only the first file type field value will " +
                         "be committed on submission of this form.");
        }

        // add to list of form sections that should start out hidden
        if (isc.isA.SectionItem(item)) {
            sectionItems.add(item);
            // remember the last visible section for mutex operation

            if (item.sectionExpanded && mutexSections)
                this._lastExpandedSection = item;
        }
    }

    // Actually store the items in this.items

    if (fromSetItems) this.items = newItems
    else this.items.addListAt(newItems, position);


    if (!firstInit) {
        this.setItemValues(this.getValues(), false, true, newItems);
    }

    // enable multipart encoding if upload fields are included
    // NOTE: imperfect: we aren't detecting all the ways you can include an UploadItem, eg
    // editorType:"UploadItem" isn't caught, neither would any subclasses be.
    if (haveUploadFields) this.encoding = isc.DynamicForm.MULTIPART_ENCODING;

    for (var i = 0; i < sectionItems.length; i++) {
        var sectionItem = sectionItems[i],
            isVisible = sectionItem.sectionExpanded;


            if (isVisible && (!mutexSections || (this._lastExpandedSection == sectionItem))) {
                // call expandSection on visible items to ensure that sections defined with an
                // inline items array have added their items to the form.
                sectionItem.expandSection();
            } else {
                // hide form sections for section items that have sectionExpanded property set
                // to false
                // do this as separate for loop to ensure that all form items to be hidden have
                // been initialized
                sectionItem.collapseSection();
            }
    }

    // set the _itemsChanged flag so we recalculate the layout
    this._itemsChanged = true;

    // Call assignItemsTabPosition
    // This handles both shuffling existing items and adding new ones.
    this.assignItemsTabPosition();

    this.markForRedraw("Form items added");

    delete this.addingItems;

},

// there are extra limitations when submitting the form if uploadItems are present
_hasUpload : function () {
    var items = this.items;
    for (var i = 0; i < items.length; i++) {
        if (isc.isAn.UploadItem(items[i])) return true;
    }
    return false;
},

_knownProps : ["name", "editorType", "readOnlyEditorType", "type",
               "valueMap", "defaultValue", "showTitle",
               "left", "top", "width", "height"],
copyKnownProperties : function (target, props, propNames) {
    var undef;
    for (var i = 0; i < propNames.length; i++) {
        var propName = propNames[i],
            value = props[propName];
        if (value !== undef) {
            target[propName] = value;
            delete props[propName];
        }
    }
},
createItem : function (item, type) {

    // We may want to support having the user specify which form an item belongs to before it
    // is initialized as a FormItem instance.  (The specified form will then handle values
    // management, etc.)
    // However this is not currently supported - we'll always have form items point back to the
    // form that created them.
    // (Note: We may want a customizable 'formProperty' property, rather than hard-coding the
    // "form" property)
    if (item.form != null && !(item.form == this.getID() || item.form != this)) {
        this.logWarn("Unsupported 'form' property [" + item.form + "] set on item:" +
                      item + ".  Ignoring.");
    }

    if (item.destroyed && isc.isA.FormItem(item)) {
        this.logWarn("destroyed FormItem passed to setItems()/addItem(): FormItems cannot be " +
                     "re-used with different DynamicForms");
    }

    // warn for a percent width other than "100%", unless using absolute item layout
    if (!this._absPos() && isc.isA.String(item.width) && item.width != "100%" &&
                                                         item.width != "*")
    {
        this.logWarn("Found width:'" + item.width + "' for item " + item.name +
                     ".  Percent sizes other than '100%' (as a synonym for '*') " +
                     "aren't allowed unless using absolute item layout");
    }

    // Handle item.hidden as a synonym for showIf:"false"
    // This matches behavior with ListGrid Fields and is something we supported at one time.

    if (item.showIf == null && item.hidden) {
        item.showIf = "return false";
    }

    // convert from a simple object into a FormItem
    var className = isc.FormItemFactory.getItemClassName(item, type, this),
        classObject = isc.FormItemFactory.getItemClass(className);

    var substituteSpacer = !classObject;
    if (substituteSpacer) {
        this.logWarn("Problem initializing item: " + isc.Log.echo(item) +
                     " - derived FormItem class is: " + className + ".  If this is " +
                     " not a typo, please make sure the relevant module is loaded.  " +
                    "A SpacerItem will be created for this FormItem.");

        classObject = isc.ClassFactory.getClass("SpacerItem", true);
        if (item.showTitle == false) substituteSpacer = false;
    }

    if (this.shouldUseMultiSelectForValueMaps() && item.valueMap != null &&
        item.multiple == null && classObject.isA(isc.SelectItem))
    {
        item.multiple = true;
    }

    // If the classObject is an SGWTFactory, then our type actually pointed
    // to a SmartGWT class, not a SmartClient class. In that case, we need
    // to figure out what SmartClient class to create! We can't just call
    // SGWTFactory.create() in the usual way, because the SGWT side of FormItem
    // only creates a properties block on initialization, and that's what we've
    // got already ... we need to turn it into a real SC FormItem, and this is
    // the only place where that happens.
    if (isc.SGWTFactory && isc.isA.SGWTFactoryObject(classObject)) {
        // First, create the desired SGWT FormItem object. We supply the
        // properties block in case there is something there that is really an
        // SGWT property ...  this allows the SGWT side to define a new
        // property and have it picked up on creation. SGWTFactory will set
        // unknown properties on the JavaScriptObject we get back. Thus, in the
        // ordinary case, we get back a copy of what we put in, but backed by a
        // SmartGWT FormItem.

        // We delete the editorType if supplied with the item, since we want to
        // pick that up from SGWT -- we don't want to clobber what SGWT is about
        // to tell us. We also delete the __module and __ref, if the item is
        // already backed by an SGWT object -- this would only happen if the
        // SGWT FormItem has specified a different editorType by reflection.
        var config = item;
        if (config.editorType || config[isc.gwtRef]) {
            config = isc.addProperties({}, item);
            delete config.editorType;
            delete config[isc.gwtRef];
            delete config[isc.gwtModule];
        }

        var reflectedItem = classObject.create(config);

        // Now, what we have is a normal situation, with a properties block
        // that is backed by a SmartGWT FormItem. So, just call ourselves
        // recursively with the correct type, and everything should happen
        // jut as it should.
        var createdItem = this.createItem(reflectedItem, reflectedItem.editorType);


        // Then reset the jsObj on the SmartGWT side to the actual FormItem,
        // since there are cases where this doesn't happen otherwise.
        classObject.setJsObj(createdItem[isc.gwtRef], createdItem);

        return createdItem;
    }

    var itemConfig = item;
    item = classObject.createRaw();

    // set up a pointer back to this form, and to the containerWidget, which might be a
    // different widget, eg a grid doing inline editing.
    // Note: several FormItem methods assume item.form will be set before init() is called.
    // CanvasItems at least need containerWidget in init as well.
    // set this up as the item's eventParent (for ISC bubbling)
    item.form = item.containerWidget = item.eventParent = this;


    var baseValidators = null;
    if (item["validators"] != null && itemConfig["validators"] != null) {
        baseValidators = item.validators;
    }


    if (isc.Browser.isIE && this.canAlterItems) {
        this.copyKnownProperties(item, itemConfig, this._knownProps);
    }

    if (!itemConfig.name && itemConfig.autoName) itemConfig.name = itemConfig.autoName;

    if (this.autoChildItems) {
        // use the autoChild system to instantiate items with FormItem class-specific defaults


        // ensure an auto-ID is not assigned by the autoChild system
        if (item.ID == null) item.ID = null;

        this._completeCreationWithDefaults(classObject.Class, item, itemConfig);
    } else {
         //this.logWarn("item: " + this.echoLeaf(item) + ", item.form is: " + item.form +
         //             ", itemConfig is: " + this.echo(itemConfig));
        item.completeCreation(itemConfig);

        if (baseValidators != null) {
            // Add base validator(s) to item
            if (!item.validators) {
                item.validators = baseValidators;
            } else {
                if (!isc.isAn.Array(item.validators)) {
                    item.validators = [item.validators];
                }
                // if the field is using the shared, default validators for the type,
                // make a copy before modifying
                if (item.validators._typeValidators) {
                    item.validators = item.validators.duplicate();
                }
                item.validators.addList(baseValidators);
            }
        }
    }


    item.form = this;
    if (item.destroyed) item.destroyed = false;

    // Log a warning if this item has no name, but is expected to save values
    // See comment in formItem.js next to the 'shouldSaveValue' property declaration.
    // (Note: we could put this check into FormItem.init)
    if (item.shouldSaveValue &&
        (item[this.fieldIdProperty] == null ||
         isc.isAn.emptyString(item[this.fieldIdProperty])) &&
        (item.dataPath == null || isc.isAn.emptyString(item.dataPath))
        )
    {

        // 'shouldSaveValue' is a property denoting whether this item should be included
        // in the form's values object.
        // False by default for non-data items.
        this.logWarn(item.getClass() + " form item defined with no '" +
                 this.fieldIdProperty + "' property - Value cannot be validated and will " +
                 "not be saved. To explicitly exclude a form item from the set of values " +
                 "to be saved, set 'shouldSaveValue' to false for this item.")

        item.shouldSaveValue = false;
    }

    // The item may be inheriting its canEdit and/or readOnlyDisplay settings from the form.
    // Need to call updateCanEdit() and updateReadOnlyDisplay() to give the item a chance to
    // update its state for this new form.
    item.updateCanEdit();
    item.updateReadOnlyDisplay();


    if (substituteSpacer && item.titleOrientation != "top") item.colSpan += item.titleColSpan;

    return item;
},

//>    @method    dynamicForm.removeItems()
// Removes some items from this form.
// Marks form to be redrawn.
//
//        @group    elements
//        @param    items   (Array of Object[])  list of form items to remove from the form
//<
removeItems : function (items) {
    if (items == null) return;

    if (!isc.isAn.Array(items)) items = [items];

    // If passed this.items, duplicate it - we want to be able to manipulate this.items without
    // changing the array passed in.
    if (items == this.items) items = this.items.duplicate();
    else {
        items = this.map("getItem", items);
        for (var i = 0; i < items.length; i++) {
            // yank out any items that aren't currently in this form (typically orphaned / destroyed items)
            if (this.items.indexOf(items[i]) == -1) {
                items[i] = null;
            }
        }
    }

    var hasAdvancedCriteria = this._hasAdvancedCriteria();

    // If the form as a whole will return advanced criteria
    // get the criteria from any item(s) being removed and
    // apply them to our "extraAdvancedCriteria"
    // object so we can continue to return the right thing from getValuesAsCriteria()
    // (If an item with the same name is reintroduced, we'll also update from
    // the extraAdvancedCriteria object)

    for (var i = 0 ; i < items.length; i++) {
        var item = items[i];
        if (item == null) continue;

        if (hasAdvancedCriteria) {
            var crit = items[i].getCriterion();
            if (crit != null) {
                if (this._extraAdvancedCriteria == null) {
                    this._extraAdvancedCriteria = {
                        _constructor:"AdvancedCriteria",
                        operator:"and",
                        criteria:[]
                    }
                }
                this._extraAdvancedCriteria.criteria.add(crit);
            }

            delete this.values[items[i].name];
        }
    }

    this.items.removeList(items);

    if (this._orphanedItems == null) {
        this._orphanedItems = [];
    }


    // if we've removed any items from this form, destroy() them too
    var ruleScopeComponent = this.getRuleScopeComponent();

    for (var i = 0; i < items.length; i++) {
        var item = items[i];

        // bad item name passed in, getItem() failed
        if (item == null) continue;

        if (ruleScopeComponent && ruleScopeComponent.rulesEngine && isc.isA.FormItem(item)) {
            if (item.requiredWhen) this._removeWhenRule("setRequired", {formItem:item.name});
            if (item.visibleWhen) this._removeWhenRule("visibility", {formItem:item.name});
            if (item.readOnlyWhen) this._removeWhenRule("readOnly", {formItem:item.name});
            if (item.formula) this._removeWhenRule("formula", {formItem:item.name});
            if (item.textFormula) this._removeWhenRule("textFormula", {formItem:item.name});

            if (item.icons) {
                var icons = item.icons;
                for (var j = 0; j < icons.length; j++) {
                    var icon = icons[j];
                    if (icon.visibleWhen) this._removeWhenRule("visibility", {formItem:item.name, formIconName:j});
                    if (icon.enableWhen) this._removeWhenRule("enable", {formItem:item.name, formIconName:j});
                }
            }
        }

        // If this has sub-items, slot them in after this item in the items array
        if (item.items != null) {
            items.addList(item.items, i+1);
        }

        // don't leave a pointer to a destroyed focus item.
        if (this._focusItem == item) {
            delete this._focusItem;
            delete this._focusItemIcon;
            if (this.hasStableLocalID()) this.provideRuleContext(this.getLocalId() + ".focusField", null, this);
        }


        if (!this.items.contains(item) && isc.isA.FormItem(item)) {
            if (this.isDrawn()) {

                if (item._destroyCanvas) item._destroyCanvas();
                this._orphanedItems.add(item);
            } else {
                item.destroy();
            }
        }
    }

    // set the _itemsChanged flag so we recalculate the layout
    this._itemsChanged = true;
    this.markForRedraw("Form items removed")
},

// canvas overrides
addField : function (field, position) { this.addItems(field, position) },
removeField : function (field) { this.removeItems(field); },

// obvious synonyms for single items
addItem : function (item, position) { this.addItems(item, position); },
removeItem : function (item) { this.removeItems(item); },

// Synonymous addFields / removeFields methods for completeness
addFields : function (items, pos) {
    return this.addItems(items, pos);
},
removeFields : function (items) {
    return this.removeItems(items);
},


// tabIndex management
// ---------------------------------------------------------------------------------------



//> @attr dynamicForm.canTabToIcons  (Boolean : true : IRWA)
// Should users be able to tab into the +link{formItem.icons,icons} and
// +link{formItem.showPickerIcon,picker icon} for items within this form by default?
// <p>
// May be overridden at the item level by +link{formItem.canTabToIcons}.
// <P>
// Developers may also suppress tabbing to individual icons by
// setting +link{formItemIcon.tabIndex} to <code>-1</code>.
//
// @group  formIcons
// @visibility external
//<

canTabToIcons:true,


// Notification method fired for some item when the tab index assigned by the
// tabIndexManager changes.
itemAutoTabIndexUpdated : function (ID) {
    // If we're undrawn we don't have a handle to update
    if (!this.isDrawn()) return;

    var item = window[ID];

   if (this.logIsDebugEnabled("TabIndexManager")) {
        this.logDebug("tab index update notification for item:" + item,
            "TabIndexManager");
    }

    if (item == null || item.destroyed || item.form != this) {
        this.logWarn("auto tab index update notification for item with ID " + ID +
            ", this may be a stale entry as we do not have an item with this " +
            "ID.");
        return;
    }

    // If the item is drawn / visible, update its element tab index
    // (otherwise this will happen lazily on draw)
    if (item._canFocus() && item.isDrawn()) {
        // second parameter notifies the item that this came from the
        // TabIndexManager - it can skip updating its icons etc.
        item._setElementTabIndex(item.getGlobalTabIndex(), true);
    }

    // Notification
    this.itemTabIndexUpdated(item);
},

// Documented in registerStringMethods
itemTabIndexUpdated : function (item) {
},

// Called from FormItem.destroy()
_removeItemFromTabIndexManager : function (item) {
    isc.TabIndexManager.removeTarget(item.ID);
},


//> @method dynamicForm.assignItemsTabPositions()
// This method is called automatically by the DynamicForm when the set of items changes
// and ensures that items show up in the correct tab order positions.
// <P>
// Makes use of +link{dynamicForm.sortItemsIntoTabOrder()} to order the items and ensures
// the items are ordered in the +link{TabIndexManager} correctly.
// @visibility external
//<
// Called from _addItems() (at which stage we have a full set of items - required to
// handle explicit local-tab-indices, etc)
// Also called from explicit 'setTabIndex' on items within this form as they can
// effect the local tab index of other items
assignItemsTabPosition : function () {
    var items = this.items;
    if (!items || items.length == 0) return;

    var orderedItems = this.sortItemsIntoTabOrder();

    // Loop through the final array adding to the TabIndexManager
    for (var i = 0, position = 0; i < orderedItems.length; i++) {
        var item = orderedItems[i];
        // Don't get confused by empty slots due to larger-than-necessary tab indices
        if (item == null) continue;

        // Shift the item in the TabIndexManager tree
        isc.TabIndexManager.moveTarget(item.ID,  this.ID, position);
        position++;

        // Always update the items' elementTabIndex
        // (Even if it isn't drawn, this is stored out for future use)
        if (item._canFocus() && item.globalTabIndex == null && item.tabIndex != -1) {
           item._setElementTabIndex(item.getGlobalTabIndex());
        }
    }

},

//> @method dynamicForm.sortItemsIntoTabOrder()
// Helper method to take our specified items and sort them into their desired
// tab sequence
// <P>
// Default behavior will respect explicitly specified tab index as a local tab
// index, otherwise just use specified order within the items array
// @return (Array of FormItem) Returns an array containing our items in the desired tab sequence.
// @visibility external
//<


sortItemsIntoTabOrder : function () {
    return isc.DynamicForm.sortItemsIntoTabOrder(this.items, this);
},

// Customize 'updateChildTabPosition' - the most common child of a DF is a CanvasItem canvas
// We allow the item to manage that widget's tab position, so avoid tweaking it in response
// to our addChild call, etc.

// getChildTabPosition should only be called for normal (not canvasItem) children
getChildTabPosition : function (child) {
    if (child.canvasItem != null) {
        this.logWarn("Unexpected call to 'getChildTabPosition' for a CanvasItem canvas");
    }

    var totalItems = this.items ? this.items.length : 0;
    var children = this.children,
        childOffset = 0;
    for (var i = 0; i < this.children.length; i++) {

        if (!children[i].updateTabPositionOnReparent) continue;
        if (children[i] == child) break;
        childOffset++;
    }
    return totalItems + childOffset;
},

// Widget level _canFocus
// If this method returns false we will not get keyboard events on the form.
// Therefore check for our items' _canFocus() instead.
// Only respect canFocus:false if we have no focusable items
_canFocus : function (a,b,c,d) {
    // shortcut: allow canFocus:true
    if (this.canFocus == true) return true;
    var items = this.getItems() || [];
    for (var i = 0; i < items.length; i++) {
        if (!isc.isA.FormItem(items[i])) continue;
        if (items[i]._canFocus()) return true;
    }

    return this.invokeSuper(isc.DynamicForm, "_canFocus", a,b,c,d);
},

// Item notifications
// ---------------------------------------------------------------------------------------

// Whenever this DynamicForm is moved, notify all the items that they have been moved.

handleMoved : function (a,b,c,d) {
    this.invokeSuper(isc.DynamicForm, "handleMoved", a,b,c,d);
    this.itemsMoved();
},

handleParentMoved : function (a,b,c,d) {
    this.invokeSuper(isc.DynamicForm, "handleParentMoved", a,b,c,d);
    this.itemsMoved();
},

// Also notify the items if the zIndex is modified
zIndexChanged : function (a,b,c,d) {
    this.invokeSuper(isc.DynamicForm, "zIndexChanged", a,b,c,d);
    this.itemsZIndexChanged();
},

parentZIndexChanged : function (a,b,c,d) {
    this.invokeSuper(isc.DynamicForm, "parentZIndexChanged", a,b,c,d);
    this.itemsZIndexChanged();
},


// Since the container widget for form items manages their position / HTML we need to fire
// a notification function to let them know if they have moved.
// itemsMoved is a helper method to fire 'moved()' on each item in this form.
itemsMoved : function (items) {

    if (items == null) items = this.getItems();
    if (!items) return;
    for (var i = 0; i < items.length; i++) {
        if (items[i].isVisible()) items[i].moved();
    }
},

// When our visibility changes, notify all our items of the visibility change.

itemsVisibilityChanged : function () {
    var items = this.getItems();
    if (!items) return;
    for (var i = 0; i < items.length; i++) {
        if (items[i].visibilityChanged) items[i].visibilityChanged();
    }
},

itemsZIndexChanged : function () {
    var items = this.getItems();
    if (!items) return;
    for (var i = 0; i < items.length; i++) {
        items[i].zIndexChanged();
    }
},

// Override scrollTo to notify our form items that they have moved.
scrollTo : function (left, top, reason) {
    var oldLeft = this.getScrollLeft(),
        oldTop = this.getScrollTop();

    this.Super("scrollTo", arguments);

    // If the scroll position changed, notify our form items that they have moved.
    if (oldLeft != this.getScrollLeft() || oldTop != this.getScrollTop()) this.itemsMoved();
},

//>Animation
// We override scrollTo() which normally causes _canAnimateClip to return false but there's no
// reason for us not to support animateShow() / animateHide() in DynamicForms, so override
// _canAnimateClip to explicitly return true (unless 'canAnimateClip' is set)
_canAnimateClip : function () {
    if (this.canAnimateClip != null) return this.canAnimateClip;
    return true;
},
//<Animation

//> @method dynamicForm.setTitleOrientation()
// Modify this form's +link{titleOrientation} at runtime
// @param orientation (TitleOrientation) new default item titleOrientation
// @group  formTitles
// @visibility external
// @example formLayoutTitles
//<
setTitleOrientation : function (orientation) {
    this.titleOrientation = orientation;
    this._itemsChanged = true;
    this.markForRedraw();
},

// EditMode setters
// ---------------------------------------------------------------------------------------

//>EditMode

setNumCols : function (numCols) {
    this.numCols = numCols;
    this._itemsChanged = true;
    this.markForRedraw();
},
//<EditMode


// AutoComplete
// --------------------------------------------------------------------------------------------

//> @method dynamicForm.setAutoComplete()
// Change the autoCompletion mode for the form as a whole.
//
// @param   newSetting (AutoComplete)  new setting
// @group autoComplete
// @visibility autoComplete
//<

setAutoComplete : function (newSetting) {
    this.autoComplete = newSetting;
    // have items change mode if applicable
    for (var i = 0; i < this.items.length; i++) {
        this.items[i]._handleAutoCompleteChange();
    }
},

/////////
// Form Values handling
// --------------------------------------------------------------------------------------------
//
// From a developers' point of view:
//  - You can initialize a form with form.values set (an array of field / value pairs).
//    - you can include fields that are not in the items array for the form.
//
//  - You can retrieve the entire set of values via form.getValues();
//    - this is basically this.values, so includes values set via setValues() that don't have
//      an associated form item.
//    - In theory this will always show you the visible value in each form element (value-mapped
//      back to the appropriate raw value if applicable).
//
//  - You can set this.values with a call to setValues()
//    - again you can include fields that are not in the items array for the form.
//    - the form will be redrawn to show the changes in the actual form elements
//
//  - form.resetValues() will reset the values to the last values set programmatically via
//    form.setValues or form.setValue();
//
//  - form.clearValues() will set this.values to {}
//    - for form items with a defaultValue or defaultDynamicValue, this will be respected in this
//      case.
//
//  - You can set the value for an individual form item via "form.setValue(item, value);" or
//    "form.getItem(itemName).setValue(value)"
//  - You can retrieve the value for an individual form item via form.getValue(item), or
//    form.getItem(itemName).getValue();
//      - the value retrieved by these getter methods will be determined by looking at the
//        stored formItem._value (set on every 'change' event) first.  If that is not present,
//        this method will fall through to form.getSavedItemValue() which will look for the value
//        in the form.values array, and if it's not there return the default value for the item.
//  These four methods do not allow you to set values in the form.values array for fields that
//  are not included as actual form items.
//
//
// Internally:
//  There are several sets of values to consider:
//  - form.values - the values we return to the user from getValues() calls - should always be in
//    sync with the form item element values, but may include fields that are not in the set of
//    form items.
//  - form._oldValues - which is set up via form.rememberValues().
//    This is used for resetting values on an explicit call to resetValues(), or after a
//    failed validation attempt.
//    form.rememberValues() is called every time a form value is set programmatically - from
//    setValues() and setValue() calls.
//  - formItem._value.  This is the FormItem's internal representation of the form item value.
//    it is updated whenever the value is saved, so on programmatic 'setValue()', on change (and
//    keypress for some widgets).
//    Only used by code in FormItem.js (the form knows nothing each formItem's _value property).
//    Returned by FormItem.getValue().
//    Note - We store _oldValues on the form rather than on each item because:
//    - Having form._oldValues rather than just formItem._oldValue for each item allows us to store
//      values for non-form item fields
//  - The value displayed in the html element for each form item.  This differs from formItem._value
//    in a couple of ways:
//      - for form elements that have valueMaps, the display value will not match the "data" value
//      - form elements grouped into a container where there are multiple form elements for one
//        logical value (such as date items).
//      - Anything where 'mapValueToDisplay()' and 'mapDisplayToValue()' is non trivial (allowing
//        checkboxes to represent values other than true and false, for example)
//      Important:
//      - The value displayed in the element can be out of sync with the _value for a form item,
//        for example while typing in a form item with 'changeOnKeypress' set to false (such as the
//        time item).  The form item is responsible for updating it's _value whenever appropriate
//        via the 'updateValue()' method, as the APIs to get directly at the value stored in the
//        element are not public.
//        *One case where it may not be in sync is items which have to validate / or reformat their
//         element values to , such as time items and date items.
//         If a user is in the process of entering a time into a Time item, the element may display
//         "1:", but the _value will not be updated (and saved in the form item values) until the
//         change handler fires on the element, meaning we won't be interfering with a user's typing
//         by attempting to verify the time on every keypress.
//         In this case, if a developer was to call 'getValue()' on a time item while focus was
//         still in that item (and the user theoretically still typing), the stored time value
//         would be returned, rather that attempting to parse the partially typed value.
//
//  - formItem.defaultValue and formItem.defaultDynamicValue.
//    - whenever an item's value is programmatically set to null, the appropriate default value will
//      be applied to the form item.
//
//  form.values is updated in the following places:
//      - form.setValues().
//        - Sets this.values to the object passed in,
//        - Saves the values in this._oldValues
//        - Calls 'setItemValues()' to take care of updating the values for each form item.
//        - Redraws the form to re-evaluate show-ifs
//        Called by:
//          - init() - call to this.setValues() with this.values or {}.
//          - this.clearValues() - falls through to this.setValues({});
//          - this.resetValues() - falls through to this.setValues(this._oldValues);
//
//      - this.saveItemValue() (Basically used to keep form.values in sync with the values for each
//        form item).
//        - Updates this.values[item] for an item.
//        - Clears the '_valueIsDirty' flag for the form item
//        Called from:
//          - form.elementChanged() (fired from an item's native change handler)
//          - item.handleKeyPress() (fired from a text / textArea item's keyPress handler)
//          - form.getValues() - if the current focus item is marked as dirty, this.values[...] for
//            the item will be updated to match the element value for the dirty form item.  (Other
//            form items than the focus item should not be out of sync because of the
//            elementChanged call to this method above).  Form items are marked as dirty via an
//            '_valueIsDirty' flag, which is set on keyDown in text / textArea type fields only.
//          - item.setValue() - which is called by form.setValue(item, value)
//
//  form._oldValues is updated when form.setValues(), formItem.setValue(), or form.setValue() is
//  called.
//
//  formItem._value (and form.values[item]) are updated via 'formItem.saveValue(newValue)'.
//  This method is called on formItem.setValue() [programmatically updating a form item's value], or
//  formItem.updateValue(), which is called as a result of the native onchange handler for form
//  items as well as the onclick handler for checkbox / radio items, and the onkeypress handler for
//  text items (where changeOnKeypress is true).
//  When these values are updated as a result of user interaction, the change handler will always
//  fire first (due to 'updateValue()').
//
//  The values displayed in the HTML form elements (and sub-elements) is updated by
//  form.setItemValues() and formItem.setElementValue().  Every method that can effect the value
//  of a form item should fall through to these, or force a form redraw (which will also update the
//  values displayed).
//
//  Additional methods on the form:
//      - form.valuesHaveChanged - compares this.getValues() (effectively the current values for
//        each item) with this._oldValues (the values as they were last set via setValue() or
//        setValues()) - used in resetValues() for example.
//
//  Additional methods on the form item:
//      - formItem.resetValue() - this will reset the value of the form item to the value stored in
//        form._oldValues[colName]
//      - formItem.elementChanged() - an internal method fired when the native element changed handler
//        is fired.  This is mentioned above as one of the callers for form.saveItemValue().  It
//        performs some other functions too, such as performing validation on the form item, and
//        setting up errors if necessary.  It has a number of "XXX" type comments and probably
//        warrants reviewing!
//      - formItem.updateValue() - called on change (and keypress if change on keypress is true)
//        determines value (mapped to data value) from element, called 'handleChange()' and
//        'saveValue()'
//      - formItem.handleChange() - internal method fired from updateValue() - will fire validators
//        and change handlers.  If this method returns false, the value in the form item element
//        will not be saved.
//      - formItem.saveValue() - called from 'setValue()' or 'updateValue()', this will save the
//        value passed in as this._value, and update this.form.values[this.name], if the item has
//        been marked as 'shouldSaveValue' true.
//
// Notes:
//  - direct submission of the HTML form drawn out by the dynamicForm widget is supported in a
//    couple of ways
//      - completely standard HTML submission is supported when canSubmit is true.
//        tripped from SubmitItem click, explicit call to "submit()" or "submitForm()".
//        Direct submission of course requires the values for form items to be present in real
//        HTML form elements - we handle this by writing out hidden elements with the intended
//        values where necessary.
//      - We also support an rpcManager direct submit transaction. This is tripped by
//        the saveData() code path if
//          a) this.canSubmit is true
//          b) this.isMultipart() [required for upload fields]
//          c) this.action has been specified.
//      Note that in rpcManager direct submit, the server pays attention to the _transaction
//      parameter, which is a structure that contains the intended field values wherever
//      possible.
//
//////////////////

//> @attr dynamicForm.dataArity (String : "single" : IRWA)
// A DynamicForm is a +link{dataBoundComponent.dataArity,dataArity}:single component.
// @group databinding
// @visibility external
//<
// Used by the valuesManager class
dataArity:"single",


//>    @method    dynamicForm.setValues()
// Replaces the current values of the entire form with the values passed in.
// <P>
// Note: when working with a form that is saving to a DataSource, you would typically call
// either +link{editRecord()} for an existing record, or +link{editNewRecord()} for a new
// record.  In addition to setting the current values of the form, these APIs establish the
// +link{DSRequest.operationType} used to save ("update" vs "add").
// <P>
// Values should be provided as an Object containing the new values as properties, where each
// propertyName is the name of a +link{items,form item} in the form, and each property value is
// the value to apply to that form item via +link{FormItem.setValue()}.
// <P>
// Values with no corresponding form item may also be passed, will be tracked by the form
// and returned by subsequent calls to +link{getValues()}.
// <P>
// Any +link{FormItem} for which a value is not provided will revert to its
// +link{formItem.defaultValue,defaultValue}.  To cause all FormItems to revert to default
// values, pass null.
// <P>
// This method also calls +link{rememberValues()} so that a subsequent later call to
// +link{resetValues()} will revert to the passed values.
//
// @param [newData] (Object) values for the form, or null to reset all items to default values
//
// @group formValues
// @visibility external
//<
setValues : function (newData, initTime, skipRememberValues, skipRuleContextChange) {
    // clear any extra advancedCriteria stored by setValuesAsCriteria()
    // getValuesAsCriteria() should return whatever was passed into this method rather than
    // hanging onto a stale advanced criteria object.
    /*if (this._extraAdvancedCriteria != null) {

        this.logWarn("clearing stored _extraAdvancedCriteria due to setValues. values:"
            + this.echo(newData) + ", old stored crit:" + isc.Comm.serialize(this._extraAdvancedCriteria) +
            " stack:" + this.getStackTrace());
    }*/
    delete this._extraAdvancedCriteria;

    if (isc.isAn.Array(newData)) {
        var useFirst = isc.isA.Object(newData[0]);
        this.logWarn("values specified as an array." +
                    (useFirst ? " Treating the first item in the array as intended values."
                              : " Ignoring specified values (resetting to defaults)."));
        if (useFirst) newData = newData[0];
        else newData= null;
    }

    if (newData == null) {
        newData = {};
    } else {
        // Duplicate the values object passed in.
        // This ensures that we don't directly manipulate a record that may be
        // referenced elsewhere (and vice-versa).

        // Use _duplicateValues() - this performs a recursive duplication using dataPaths to
        // access nested values.
        var clonedData = {};
        isc.DynamicForm._duplicateValues(this, newData, clonedData);
        newData = clonedData;
    }

    // store the new values object
    this._saveValues(newData);

    // If any of our items have a specified 'displayField', call the method to create a
    // special valueMap on that item so the value for that field is displayed rather than
    // the fields own value.

    var items = this.items;

    for (var i = 0; i < items.length; i++) {

        if (items[i].shouldSaveValue && this._useDisplayFieldValue(items[i])) {
            items[i]._displayFieldValueFromFormValues();
        }
    }

    // While setting item values, suppress ruleContext updates so rules aren't processed
    // for each FormItem. RuleContext will be explicitly updated immediately afterwards.
    this._suppressRuleContextUpdates = true;

    // and set the values in the form elements

    this._settingValues = true;
    this.setItemValues(newData, null, initTime);
    if (!initTime) delete this._settingValues;

    delete this._suppressRuleContextUpdates;

    // Update ruleContext with new values
    this.setValuesInRuleContext(skipRememberValues, skipRuleContextChange);

    // remember the values so we can undo things
    if (!skipRememberValues) {
        this.rememberValues();
    } else {
        // If we have a specified rulesEngine, notify it that we're editing a new set of values
        var rulesEngine = this.getRulesEngine();
        if (rulesEngine != null) {
            rulesEngine.processEditStart(this);
        }
    }
    if (initTime) delete this._settingValues;

    // fire valuesChanged if it's been installed
    if (isc.isA.Function(this.valuesChanged)) this.valuesChanged();

    // redraw so that we will re-evaluate showIfs
    this.markForRedraw("setValues");
},

setValuesInRuleContext : function (skipRememberValues, skipRuleContextChange) {
    // when called from Canvas.addToRuleContextSchema() because the form is not visible,
    // no arguments are passed. In this case there is no call to rememberValues so we
    // flag it that way so that ruleContext changes transaction will be completed.
    skipRememberValues = (skipRememberValues == null ? true : skipRememberValues);

    if (this.ruleScope || this.isRuleScope) {
        var ds = this.getDataSource(),
            hasStableID = this.hasStableLocalID() || (this.editNode != null),
            values = this.getValues()
        ;

        if (ds && isc.isA.DataSource(ds) && this._populateSharedRuleContext != false) {
            // Make sure the new values are reported as a 'change' by clearing any current values
            var willFireRuleContextChanged = ((hasStableID &&
                                                (!skipRememberValues || skipRuleContextChange)) ||
                                              (this._fireRuleContextOnItemChange &&
                                                !skipRuleContextChange &&
                                                (this.grid == null || !this._settingValues)));

            this.provideRuleContext(ds.getID(), null, this, null, true);
            this.provideRuleContext(ds.getID(), isc.shallowClone(values),
                this, null, willFireRuleContextChanged);
        }
        if (hasStableID) {
            // Make sure the new values are reported as a 'change' by clearing any current values
            this.provideRuleContext(this.getLocalId() + ".values", null, this, null, true);
            this.provideRuleContext(this.getLocalId() + ".values", isc.shallowClone(values),
                this, null, true);
            this.provideRuleContext(this.getLocalId() + ".hasChanges", false, this, null,
                !skipRememberValues || skipRuleContextChange);
        } else if (this._fireRuleContextOnItemChange &&
            !skipRuleContextChange &&
            (this.grid == null || !this._settingValues))
        {
            this.fireRuleContextChanged(this);
        }
    }
},

// Helper method to detect the case where we a field should display the value from a
// different field (field.displayField) in this form's values object
// The logic behind this is that if we're editing a record from the DataSource, we already have
// both the data value and the display value in the record values we were passed, and
// don't need to perform a fetch against the ds to get another display value.
//
// This is only valid if we have a specified display field and no optionDataSource / valueField
// specified

_useDisplayFieldValue : function (field) {
    if (!field || !field.displayField) return false;

    if (field.useLocalDisplayFieldValue != null) return field.useLocalDisplayFieldValue;


    if (field.optionDataSource != null) return false;


    // If we're looking at a different underlying field on the optionDataSource, even if it's
    // the same dataSource, we don't want the display field value from this record
    if (field.getValueFieldName() != field.getFieldName()) return false;

    return true;
},

// If a (pickList-based) formItem has a specified displayField and no explicit
// optionDataSource, this method returns the default dataSource to use

getDefaultOptionDataSource : function (field) {
    return this.dataSource;
},


//>    @method    dynamicForm.setData()
//            Pass-through to the standard setData interface.
//        @group formValues
//
//        @param    newData        (Object)    data to display in the form
//<
setData : function (newData) {
    this.setValues(newData);
},

// clear validation errors on rebind.  NOTE: should probably go to generic DataBinding
// framework when validation becomes a generic databinding behavior such that individual
// widgets just choose validation presentation.
setDataSource : function (dataSource, fields) {
    // If a dev calls 'setDataSource()' and passes in a subset of our existing fields
    // as a second argument, things get ambiguous.
    // Should an item that represents a field in the new DS change its editor type, for example?
    // Should an item that represented a field in the old DS drop properties derived from the
    // dsField?
    // - Log a warning if this happens

    if (fields != null) {
        var oldDS = this.getDataSource(),
            newDS = isc.DataSource.get(dataSource);

        if (newDS != oldDS) {
            for (var i =0; i < fields.length; i++) {
                var field = fields[i];
                if (isc.isA.FormItem(field)) {
                    var inOldDS = (oldDS && oldDS.getField(field.name) != null),
                        inNewDS = (newDS && newDS.getField(field.name) != null);

                    if (inOldDS || inNewDS) {
                        this.logWarn("setDataSource(): fields argument contains already-created FormItem:" + field +
                            " which represents a dataSource field. This can lead to unexpected results if there are differences" +
                            " between the dsField attributes in the new dataSource vs the current dataSource.");

                    }
                }
            }
        }
    }
    this.Super("setDataSource", arguments);
    this.clearErrors();
},

//>    @method    dynamicForm.rememberValues()
//            Make a snapshot of the current set of values, so we can reset to them later.
//            Creates a new object, then adds all non-method properties of values
//            to the new object.  Use <code>resetValues()</code> to revert to these values.
//          Note that this method is automatically called when the values for this form are
//          set programmatically via a call to +link{DynamicForm.setValues()}.
//
//      @visibility external
//        @group formValues
//
//        @return    (Object)    copy of current form values
//<

rememberValues : function () {
    var values = this.getValues();

    var oldVals = {},
        rememberedDefault = [];

    // Recursively duplicate values so further edits won't manipulate the remembered values
    // directly.
    isc.DynamicForm._duplicateValues(this, values, oldVals, rememberedDefault);

    // Remember the duplicated values object
    this._oldValues = oldVals;
    // rememberedDefault array will contain dataPaths for every item that had its value
    // set to the default in the 'values' object we passed in.
    // We need this information so 'resetValues' can set these items to null and
    // potentially re-evaluate a dynamicDefault rather than resetting to whatever the
    // value is at this moment.
    // [still store the current val for valuesHaveChanged() checks]
    this._rememberedDefault = rememberedDefault;

    this.updatePendingStyles();

    if (this.ruleScope || this.isRuleScope) {
        var ds = this.getDataSource(),
            hasStableID = this.hasStableLocalID() || (this.editNode != null)
        ;

        if (hasStableID) {
            this.provideRuleContext(this.getLocalId() + ".hasChanges", false,
                this, null, this._settingValues);
        }
    }

    return this._oldValues;
},

updatePendingStyles : function () {
    var items = this.items;
    for (var i = 0, numItems = (items == null ? 0 : items.length); i < numItems; ++i) {
        var item = items[i];
        if (!isc.isA.FormItem(item)) continue;
        item.updatePendingStatus(item._value);
    }
},

//>    @method    dynamicForm.resetValues()   ([])
//
// Same as +link{method:DynamicForm.reset()}.
//
// @group formValues
// @visibility external
//<

resetValues : function () {
    // reset the form errors as well as the values
    this.clearErrors();

    // pull the values from form._oldValues into ValuesManager.values
    var values = {};
    isc.DynamicForm._duplicateValues(this, this._oldValues, values);
    // clear any remembered defaults so they get re-eval'd
    if (this._rememberedDefaults != null) {

        for (var i = 0; i < this._rememberedDefaults.length; i++) {
            isc.DynamicForm._clearFieldValue(this._rememberedDefaults[i], values, this);
        }
    }

    this.setValues(values);

},

//>    @method    dynamicForm.clearValues()
// Reset to default form values and clear errors
//        @group formValues
// @visibility external
//<
clearValues : function () {
    var skipRuleContextChange = false;
    if (this.ruleScope || this.isRuleScope) {
        var ds = this.getDataSource(),
            hasStableID = this.hasStableID() || (this.editNode != null)
        ;

        skipRuleContextChange = hasStableID;
    }

    // call setValues() to clear out all our saved values
    this.setValues(null, null, true, skipRuleContextChange);

    // also iterate through every unnamed form item, setting its value to null.

    var items = this.getItems();
    for (var i = 0; i < items.length; i++) {
        if (items[i].shouldSaveValue == false) items[i].setValue(null);
    }

    // reset the form errors
    this.clearErrors();

    // remember the current values for future calls to 'resetValues()'
    this.rememberValues();

    // redraw the form
    this.markForRedraw("clearValues");
},

//>    @method    dynamicForm.valuesHaveChanged() ([])
// Compares the current set of values with the values stored by the call to the
// +link{dynamicForm.rememberValues()} method.  <code>rememberValues()</code> runs when the
// form is initialized and on every call to +link{dynamicForm.setValues()}.
// Returns true if the values have changed, and false otherwise.
// @return    (Boolean)    true if current values do not match remembered values
//
// @see getChangedValues()
// @see getOldValues()
//
// @group formValues
// @visibility external
//<
valuesHaveChanged : function (returnChangedVals, values, oldValues, useActionCache) {
    if (values == null) values = this.getValues();
    // form._oldValues is used to store the values in rememberValues()
    if (oldValues == null) oldValues = this._oldValues || {};

    return isc.DynamicForm.valuesHaveChanged(this, returnChangedVals, values, oldValues, null,
                                             useActionCache);
},

valueHasChanged : function (fieldName) {
    var values = {
            fieldName:this.getValue(fieldName)
        },
        undef,
        oldValues = {
            fieldName:this._oldValues ? this._oldValues[fieldName] : undef
        }
    ;
    return this.valuesHaveChanged(false, values, oldValues);
},

// return the updated form fields - mappings with field values
_getUpdatedFields : function () {
    var fields = [],
        map = this._updatedFields;
    if (map) for (var fieldName in map) {
        var field = map[fieldName];
        if (field) fields.add(field);
    }
    return fields;
},

// return updated DS fields - no mapped value but key names DSF
_getUpdatedDSFields : function () {
    var fields = [],
        map = this._updatedFields;
    if (!map) return fields;

    var ds = this.getDataSource(),
        dsFields = ds.getFields(),
        dataPaths = ds.dataPaths
    ;
    for (var dataPath in map) {
        var field = map[dataPath];
        if (field) continue;
        field = dsFields[dataPath] || dataPaths[dataPath];
        if (field) fields.add(field);
    }
    return fields;
},

// filter the passed values using the update tracking map

_filterWithUpdatedFields : function (values) {
    var filtered = {},
        map = this._updatedFields;
    if (map) for (var fieldName in map) {
        var field = map[fieldName];
        // might be a dataPath; chop off all but the first segment for lookup
        if (!field) {
            var splitPos = fieldName.indexOf("/");
            if (splitPos >= 0) fieldName = fieldName.substring(0, splitPos);
        }
        if (fieldName in values) filtered[fieldName] = values[fieldName];
    }
    return filtered;
},

//> @method dynamicForm.getOldValues() ([])
// Returns the set of values last stored by +link{dynamicForm.rememberValues()}.
// Note that <code>rememberValues()</code> is called automatically by
// +link{dynamicForm.setValues()}, and on form initialization, so this typically contains
// all values as they were before the user edited them.
//
// @return (Object) old values in the form
// @group formValues
// @see getChangedValues()
// @visibility external
//<
getOldValues : function () {
    var oldValues = {};
    isc.addProperties(oldValues, this._oldValues);
    return oldValues;
},


getOldValue : function (itemName) {
    return this.getOldValues()[itemName];
},

//> @method dynamicForm.getChangedValues()  ([])
// Returns all values within this DynamicForm that have changed since
// +link{dynamicForm.rememberValues()} last ran. Note that +link{dynamicForm.rememberValues()}
// runs on dynamicForm initialization, and with every call to +link{dynamicForm.setValues()}
// so this will typically contain all values the user has explicitly edited since then.
// @return (Object) changed values in the form
// @group formValues
// @see getOldValues()
// @visibility external
//<
getChangedValues : function (useActionCache) {
    return this.valuesHaveChanged(true, null, null, useActionCache);
},

//>    @method    dynamicForm.getValues() ([])
// An Object containing the values of the form as properties, where each propertyName is
// the name of a +link{items,form item} in the form, and each property value is the value
// held by that form item.
// <P>
// Note that modifying the returned object is not a supported way of adding or modifying values.
// Instead use +link{setValue()} or +link{setValues()}.
// @return (Object) values in the form
// @see valuesManager.getValues()
// @group formValues
// @visibility external
//<
getValues : function (threadID) {

    // Note: this method will not validate each field - to run validators on all the field, a
    // developer should explicitly call the 'validate()' method on the form (or the item in
    // question).
    // Call updateFocusItemValue() to ensure that if we have focus our values are up to date.
    // This makes sure that all the active field's value is saved when filtering, saving a
    // form, etc.
    this.updateFocusItemValue(threadID);

    return this.values;
},


//> @method updateFocusItemValue()
//  If we're currently focused in an item, who's value has been changed since last being
//  saved in this DynamicForm, call item.updateValue().
//<
updateFocusItemValue : function (threadID) {
    // During redraw we re-render the HTML for the items and then set item values.
    // Never attempt to pick up the values from the item before that process is complete.
    if (!this.isDrawn() || this._redrawInProgress) return;

    // threadID potentially passed from getValues()
    // This allows repeated callers in the same thread to skip repeatedly checking for
    // updates to the focus item element value

    if (threadID != null) {
        if (this._getValuesThreadID == threadID) {
            return;
        }
    }
    this._getValuesThreadID = threadID;


    var focusItem = this.getFocusSubItem();
    if (!this._setValuesPending) {
        var checkAllItems = false;
        var items = this.getItems(),
            itemsToTest = [];
        for (var i = 0; i < items.length; i++) {
            if (isc.isA.PasswordItem(items[i])) {
                checkAllItems = true;
                break;
            } else {


                // Note that item.changeOnKeypress check is required to avoid handling item value that
                // was already handled on key press, so first it is not needed and second it leads to
                // an issue when formatting was applied to item when focus has left the form and getting
                // value here reads formatted value instead of actual value, which leads to validation failure
                // although real value entered into the item was correct, such issue example:
                // - editing item with format: ",##0.00 €"
                // - enter 900.01
                // - make focus leave the form, formatting applies when focus is lost
                // - formatted item displays "900.01 €"
                // - call form.validate() which eventually calls this method: updateFocusItemValue(),
                //   which calls formItem.updateValue, which stores "900.01 €"
                //   string value instead of the "real value", which is float 900.01.
                // - validation fails since string value is not a valid float value
                //
                // So, this check avoids updating the value if it was already updated, which is expected
                // when formItem.changeOnKeypress is true
                if (items[i] == focusItem && focusItem._itemValueIsDirty() && !items[i].changeOnKeypress) {
                    itemsToTest[itemsToTest.length] = items[i];

                } else if (items[i]._getAutoCompleteSetting() == "native") {
                    itemsToTest[itemsToTest.length] = items[i];
                }
            }
        }
        if (checkAllItems) itemsToTest = items;
        for (var i = 0; i < itemsToTest.length; i++) {
            var itemToTest = itemsToTest[i];
            itemToTest.updateValue();
        }
    }
},



//>    @method    dynamicForm.getData()
//            Return the values stored in the form.
//            Pass-through to dynamicForm.getValues();
//        @group    data
//        @return    (Object)    values in the form
//<
getData : function () {
    return this.getValues();
},

//> @method dynamicForm.fetchRelatedData()
// Based on the relationship between the DataSource this component is bound to and the
// DataSource specified as the "schema" argument, call fetchData() to retrieve records in this
// data set that are related to the passed-in record.
// <P>
// Relationships between DataSources are declared via +link{dataSourceField.foreignKey}.
// <P>
// For example, given two related DataSources "orders" and "orderItems", where we want to fetch
// the "orderItems" that belong to a given "order".  "orderItems" should declare a field that
// is a +link{dataSourceField.foreignKey,foreignKey} to the "orders" table (for example, it
// might be named "orderId" with foreignKey="orders.id").  Then, to load the records related to
// a given "order", call fetchRelatedData() on the component bound to "orderItems", pass the
// "orders" DataSource as the "schema" and pass a record from the "orders" DataSource as the
// "record" argument.
//
// @param record              (ListGridRecord) DataSource record
// @param schema              (Canvas | DataSource | ID) schema of the DataSource record, or
//                            DataBoundComponent already bound to that schema
// @param [callback]          (DSCallback)  callback to invoke on completion
// @param [requestProperties] (DSRequest)   additional properties to set on the DSRequest
//                                            that will be issued
//
// @group dataBoundComponentMethods
// @visibility external
//<

//> @groupDef criteriaEditing
// DynamicForms may be used to edit +link{Criteria} or +link{AdvancedCriteria} for filtering
// data from a DataSource.
// <P>
// The main APIs for this are +link{dynamicForm.getValuesAsCriteria()} and
// +link{dynamicForm.setValuesAsCriteria()}.
// <P>
// <code>getValuesAsCriteria()</code> will return an AdvancedCriteria object in the following
// cases:
// <ul>
// <li>The form was previously passed AdvancedCriteria via <code>setValuesAsCriteria()</code></li>
// <li>The form has a specified +link{dynamicForm.operator} of <code>"or"</code></li>
// <li>+link{FormItem.hasAdvancedCriteria()} returns true for some item(s) within the form</li>
// </ul>
// <P>
// <smartclient>
// Note that at the form item level, individual items can support editing of advanced criteria
// via overrides to the +link{formItem.hasAdvancedCriteria()}, +link{formItem.canEditCriterion()},
// +link{formItem.setCriterion()} and +link{formItem.getCriterion()} methods.
// </smartclient>
// <smartgwt>
// Note that at the form item level, individual items can support editing of advanced criteria
// by registering <code>FormItemCanEditCriterionPredicate</code>, <code>FormItemCriterionSetter</code>,
// and <code>FormItemCriterionGetter</code> objects to implement the methods <code>canEditCriterion()</code>,
// <code>setCriterion()</code>, and <code>getCriterion()</code>, respectively.
// </smartgwt>
// <P>
// There is also built-in support for +link{dynamicForm.allowExpressions, expression-parsing}
// in DynamicForms.  This allows expressions, like '&gt;5' (greater than 5) or 'a...c'
// (between a and c) to be edited and generated automatically by appropriate formItems.
// <P>
// Some FormItems have special behavior - for instance, a +link{SelectItem} with
// +link{SelectItem.multiple, multiple:true} will successfully edit and return criteria with an
// <code>inSet</code> operator.
// <P>
// The common pattern of using nested dynamicForms to edit arbitrary advanced criteria has been
// implemented via overrides to these methods in the +link{CanvasItem} class. See
// <smartclient>+link{CanvasItem.getCriterion()}</smartclient>
// <smartgwt><code>CanvasItem.setCriterionGetter()</code></smartgwt> for details.
// <P>
// For completely user-driven advanced criteria editing see also the +link{FilterBuilder} class.
//
// @title Criteria Editing
// @treeLocation Client Reference/Forms
// @visibility external
//<


//>    @method    dynamicForm.getValuesAsCriteria()
// Return search criteria based on the current set of values within this form.
// <p>
// The returned search criteria will be a simple +link{Criteria} object, except for
// in the following cases, in which case an +link{AdvancedCriteria} object will be returned:
// <ul>
// <li>The <code>advanced</code> parameter may be passed to explicitly request a
// <code>AdvancedCriteria</code> object be returned</li>
// <li>If +link{setValuesAsCriteria()} was called with an <code>AdvancedCriteria</code>
//     object, this method will return advanced criteria.</li>
// <li>If +link{dynamicForm.operator} is set to <code>"or"</code> rather than
//     <code>"and"</code> the generated criteria will always be advanced.</li>
// <li>If any item within this form returns true for +link{FormItem.hasAdvancedCriteria()},
//     which can be caused by setting +link{formItem.operator}, and is always true for
//     items such as +link{DateRangeItem}</li>
// <li>If +link{formItem.allowExpressions} is enabled
// </ul>
// The criteria returned will be picked up from the current values for this form. For simple
// criteria, each form item simply maps its value to it's fieldName. See
// <smartclient>+link{formItem.getCriterion()}</smartclient>
// <smartgwt><code>FormItem.setCriterionGetter()</code></smartgwt>
// for details on how form items generate advanced criteria.
// Note that any values or criteria specified via +link{setValues()} or
// +link{setValuesAsCriteria()} which do not correspond to an item within the form will be
// combined with the live item values when criteria are generated.
// <P>
// The returned criteria object can be used to filter data via methods such as
// +link{ListGrid.fetchData()}, +link{DataSource.fetchData()}, or, for more advanced usage,
// +link{ResultSet.setCriteria()}.
// <P>
// Note that any form field which the user has left blank is omitted as criteria, that is,
// a blank field is assumed to mean "allow any value for this field" and not "this field must
// be blank".  Examples of empty values include a blank text field or SelectItem with an empty
// selection.
//
// @param advanced (boolean) if true, return an +link{AdvancedCriteria} object even if the
//   form item values could be represented in a simple +link{Criterion} object.
// @param [textMatchStyle] (TextMatchStyle) This parameter may be passed to indicate whether
//   the criteria are to be applied to a substring match (filter) or exact match (fetch).
//   When advanced criteria are returned this parameter will cause the appropriate
//   <code>operator</code> to be generated for individual fields' criterion clauses.
//
// @group criteriaEditing
// @return (Criteria | AdvancedCriteria) a +link{Criteria} object, or +link{AdvancedCriteria}
//
// @visibility external
//<


_hasAdvancedCriteria : function (omitHiddenCriteria) {
    if (this.operator != "and" || this.allowExpressions) return true;
    if (!omitHiddenCriteria && this._extraAdvancedCriteria != null) return true;
    return this.getItems().callMethod("hasAdvancedCriteria").contains(true);
},

getExtraAdvancedCriteria : function () {

    // returns any criteria applied to this form that couldn't be edited
    return this._extraAdvancedCriteria ? isc.clone(this._extraAdvancedCriteria) : null;
},

getItemValuesAsCriteria : function (advanced, textMatchStyle, returnNulls) {
    // only returns criteria for the current values of accessible FormItems
    if (advanced == null) {

        advanced = this._hasAdvancedCriteria(true);
    }
    // this call will return either a simple criterion object, or an array of each item value
    // as a sub criterion (remapping field name and value according to getCriteraiFieldName()
    // and getCriteriaValue())
    var values = this._getMappedCriteriaValues(advanced, textMatchStyle);
    if (advanced) {
        // remove any empty criteria entries
        values.removeEmpty();
    } else {
        // Simple criteria:
        // - criteria basically == values object
        // - remap specific items according to getCriteriaFieldName() and getCriteriaValue()
        // - pass through DS.filterCriteriaforFormValues() to clear nulls and handle arrays
        if (returnNulls) return values;
        values = isc.DataSource.filterCriteriaForFormValues(values);
    }
    return values;
},

getValuesAsCriteria : function (advanced, textMatchStyle, returnNulls) {

    if (advanced == null) {
        advanced = this._hasAdvancedCriteria();
    }

    // get the criteria for values from fields with an accessible FormItem - this does not
    // include criteria which were too advanced to be edited, even if a field was accessible
    var criteria = this.getItemValuesAsCriteria(advanced, textMatchStyle, returnNulls)

    if (!advanced) {
        // Simple criteria - just return it
        return criteria;
    }

    // Advanced criteria:
    // - top level operator comes from form.operator
    // - if there's static criteria (_extraAdvancedCriteria):
    //    1) if it's operator is the same as the form, use it as the wrapper criteria
    //    2) if not, create a wrapper criteria with the correct operator and add the static crit
    // - add the dynamic criteria (from the live fields) into the wrapper

    var wrapper = { operator:this.operator, _constructor: "AdvancedCriteria", criteria: [] };

    // get the "static" criteria that couldn't be edited
    var staticCrit = this.getExtraAdvancedCriteria();
    if (staticCrit && staticCrit.criteria) {
        // if there's static crit and it's got subCrit, its valid - if it has the same operator,
        // use it as the wrapper - otherwise, add it to the wrapper as a subCrit
        if (staticCrit.operator == this.operator) wrapper = staticCrit;
        else wrapper.criteria.add(staticCrit);
    }

    if (criteria && criteria.length > 0) {
        wrapper.criteria.addList(criteria);
    }

    // don't return nonsensical criteria (advanced crit with no sub-crit)

    var result = isc.DS.checkEmptyCriteria(wrapper);
    return result;
},

// _getMappedCriteriaValues()
// Pick up the criteria field name and criteria value for each item in the form.
//
// Combine this with items from the form values object so we don't omit criteria fields
// without a specified item
_getMappedCriteriaValues : function (advanced, textMatchStyle) {

    // Note we iterate through all the items in the form, but we also need to look at the
    // form's values object, since there may be values set for fields that have no associated
    // item.
    // Cases where this could happen:
    // - setValues() was called, with a simple values object including fields with no item.
    //   In this case this._extraAdvancedCriteria will have been wiped
    // - the items in the form have changed since setValuesAsCriteria() was called.
    var values = isc.addProperties({},this.getValues()),
        simpleCriteria = {},
        advancedCriteria = [];


    var items = this.getFields();
    for (var i = 0; i < items.length; i++) {
        if (!items[i].shouldSaveValue) continue;
        var item = items[i],
            itemName = items[i].getTrimmedDataPath() || items[i].getFieldName(),
            // getCriteriaFieldName already handles trimming data path to be relative to the
            // values within this form
            criterionName = items[i].getCriteriaFieldName();

        // clear the value from the values object if it has an associated item!
        // We do this so we can retain values that don't have an associated item, but for
        // those that do we can remap values to a new criteria field name and a new
        // value via getCriteriaValue()
        isc.Canvas._clearFieldValue(itemName, values);

        if (!advanced) {
            // If the item returns a criteriaFieldName of null, exclude it from the criteria
            // altogether
            if (criterionName != null) {
                // If the values object already contains a value for this "criterionName"
                // because it is a field with both a name and a dataPath, remove the version
                // keyed by name
                if (values[items[i].name]) delete values[items[i].name];

                if (items[i].displayField && items[i]._value == null &&
                        values[items[i].displayField] == items[i].emptyDisplayValue)
                {
                    delete values[items[i].displayField];
                }
                // If we're doing an exact match, ensure we convert from user-entered
                // string to actual type value if this is not a 'substring' / 'startswith'
                // match.
                var convertToType = textMatchStyle == null ||
                                    textMatchStyle == "exact" || textMatchStyle == "equals";
                simpleCriteria[criterionName] = items[i].getCriteriaValue(!convertToType);

            }
        } else {
            var criterion = item.getCriterion(textMatchStyle);
            if (criterion != null) advancedCriteria.add(criterion);
        }
    }
    // overlay the values from actual items on top of the values from the values object.
    if (!advanced) {
        return isc.addProperties(values, simpleCriteria);
    } else {
        for (var fieldName in values) {
            if (advancedCriteria.find("fieldName", fieldName)) continue;
            // we don't want null values adding as criteria elements
            if (values[fieldName] == null) continue;
            advancedCriteria.add({
                // DF's can be used as a filter (substring match) or a fetch (exact match)
                // allow a textMatchStyle param to configure what operator we produce here
                operator:isc.DataSource.getCriteriaOperator(values[fieldName], textMatchStyle),
                fieldName:fieldName,
                value:values[fieldName]
            });
        }
        return advancedCriteria;
    }

},

removeFieldCriteria : function (fieldName, operator, value, criteria) {
    if (!criteria || !criteria.criteria) return false;

    var critArray = criteria.criteria;
    for (var i = critArray.length-1; i>=0; i--) {
        var thisCrit = critArray[i];
        if (thisCrit.criteria) {
            this.removeFieldCriteria(fieldName, operator, value, thisCrit);
            if (thisCrit.criteria.length == 0) critArray.removeAt(i);
        } else {
            if (thisCrit.fieldName == fieldName) {
                // only process stored crit for the specified field
                if (thisCrit.operator != operator || thisCrit.value != value) {
                    // remove if the op or value are different
                    critArray.removeAt(i);
                }
            }
        }
    }
},

// This helper cleans up advancedCriteria entries which are already
// referenced in explicit criteria that'll apply to items
removeExtraAdvancedCriteria : function (criteria) {
    var fieldNames = isc.getKeys(criteria),
        items = this.items
    ;

    for (var i=0; i< fieldNames.length; i++) {
        var fieldName = fieldNames[i],
            value = criteria[fieldName],
            operator = null,
            item = null
        ;

        // find the appropriate formItem using getCriteriaFieldName()
        items.map(function (mapItem) {
            if (fieldName == mapItem.getCriteriaFieldName()) item = mapItem;
        });

        if (item) {
            // get the specified or default operator for the item
            operator = item.getOperator();
            // remove any stored criteria this field that do not exactly match the new (simple)
            // criteria passed in
            this.removeFieldCriteria(fieldName, operator, value, this._extraAdvancedCriteria);
        }
    }
},


// This helper removes extraAdvancedCriteria whose fieldName matches the specified
// fieldNames. We use this in the recordEditor to clear criteria for fields which have been
// hidden but are explicitly defined when the user clears filter using the menu.
// (Of course this is crude and could be tripped up by custom editors, etc)
removeExtraAdvancedCriteriaFields : function (dropCriteriaFields) {
    for (var i = 0; i < dropCriteriaFields.length; i++) {
        this.removeFieldCriteria(dropCriteriaFields[i], null, null, this._extraAdvancedCriteria);
    }
},


//> @method dynamicForm.setValuesAsCriteria()
// This method will display the specified criteria in this form for editing. The criteria
// parameter may be a simple +link{criterion} object or an +link{AdvancedCriteria} object.
// <P>
// For simple criteria, the specified fieldName will be used to apply criteria to form items,
// as with a standard setValues() call.
// <P>
// For AdvancedCriteria, behavior is as follows:
// <ul>
// <li>If the top level operator doesn't match the +link{dynamicForm.operator,operator} for
//  this form, the entire criteria will be nested in an outer advanced criteria object with
//  the appropriate operator.</li>
// <li>Each criterion within AdvancedCriteria will be applied to a form item if
//  +link{formItem.shouldSaveValue} is true for the item and
//  +link{formItem.canEditCriterion()} returns true for the criterion in question. By default
//  this method checks for a match with both the <code>fieldName</code> and <code>operator</code>
//  of the criterion. The criterion is actually passed to the item for editing via
//  <smartclient>+link{formItem.setCriterion()}</smartclient>
//  <smartgwt>the <code>FormItemCriterionSetter</code>'s <code>setCriterion()</code> method</smartgwt>.
//  Note that these methods may be overridden for custom
//  handling. Also note that the default <smartclient>+link{CanvasItem.setCriterion()} implementation</smartclient>
//  <smartgwt><code>FormItemCriterionSetter.setCriterion()</code> implementation
//  used by +link{CanvasItem}</smartgwt> handles editing nested criteria via embedded dynamicForms.</li>
// <li>Criteria which don't map to any form item will be stored directly on the form and
//  recombined with the edited values from each item when +link{getValuesAsCriteria()} is
//  called.</li>
// </ul>
// @param criteria (Criterion) criteria to edit.
//
// @group criteriaEditing
// @visibility external
//<
// advanced parameter used when we're using nested forms to edit advanced criteria. In this
// case we don't have the "AdvancedCriteria" constructor property set on the inner criteria
// but we still want to use the 'advanced' type handling to apply it to our form items.
//
// dropExtraCriteria - used by ListGrid filterEditor to handle the case where there
// are some meaningful criteria applied to fields which aren't defined for the grid
// (or aren't visible, together with the 'dropCriteriaFields' array)
setValuesAsCriteria : function (criteria, advanced, dropExtraCriteria, dropCriteriaFields) {
    var ds = this.getDataSource();
    if (!advanced && !isc.DataSource.isAdvancedCriteria(criteria, ds)) {
        // In this case the criteria passed in is a simple values object of fieldName-> value
        // mappings.
        // We could just do 'setValues(criteria)' and it would work in most cases, however we
        // support having items work with simple criteria but use a different criteria field
        // (EG ComboBoxItem with display field set and addUnknownValues:true).
        // Therefore we want to actually go through all our items and allow them to grab specific
        // criteria they're interested in.
        this._saveValuesAsCriteria(criteria, dropExtraCriteria, dropCriteriaFields);

        var items = this.items || [];
        var itemsToClear = [];


        if (dropExtraCriteria && (!dropCriteriaFields || dropCriteriaFields.length == 0)) {
            delete this._extraAdvancedCriteria;
        } else if (this._extraAdvancedCriteria) {
            if (this._parseExtraCriteria) {
                // RecordEditor uses this - remove any entries in the stored
                // _extraAdvancedCriteria that do not appear in the new criteria
                this.removeExtraAdvancedCriteria(criteria);
                var eAC = this._extraAdvancedCriteria;

                if (dropExtraCriteria && dropCriteriaFields) {
                    this.removeExtraAdvancedCriteriaFields(dropCriteriaFields);
                }

                if (!eAC || !eAC.criteria || eAC.criteria.length == 0) eAC = null;
            } else {
                // normal forms just clear out any stored extra criteria
                delete this._extraAdvancedCriteria;
            }
        }

        for (var i = 0; i < items.length; i++) {
            var item = items[i],
                itemName = item.getFieldName(),
                itemModified = false;
            if (isc.propertyDefined(criteria, itemName) && item.canEditSimpleCriterion(itemName)) {
                item.setSimpleCriterion(criteria[itemName], itemName);
                itemModified = true;
            } else {
                for (var fieldName in criteria) {

                    if (fieldName != itemName && item.canEditSimpleCriterion(fieldName)) {
                        item.setSimpleCriterion(criteria[fieldName], fieldName);
                        itemModified = true;
                        break;
                    }
                }
            }
            if (!itemModified) {
                itemsToClear.add(item);
            }
        }

        // Explicitly empty any items we didn't touch
        for (var i = 0; i < itemsToClear.length; i++) {
            if (!itemsToClear[i].shouldSaveValue) {
                continue;
            }
            itemsToClear[i].clearValue();
        }

        this.rememberValues();
    } else {
        // Wipe out any existing "values" object.
        // We'll update the values for each item that can edit sub-criterion of the criteria
        // passed in below, which will also store their simple value in the values object,
        // but this ensures we don't hang onto values for stale keys.

        var oldValues = this.values;
        this._saveValues({});

        // copy the crit object - we don't want to directly manipulate it and confuse other
        // code
        criteria = isc.clone(criteria);

        var topOperator = criteria.operator;
        if (topOperator != this.operator) {
            // this doesn't necessarily indicate an error but it might be unexpected.
            // Log a warning and wrap in a top level AC object.
            this.logInfo("Dynamic Form editing advanced criteria object:" +
                isc.Comm.serialize(criteria) + ". Form level operator specified as '" +
                this.operator + "' - Criteria returned from this form will be nested in an outer " +
                this.operator + " clause.", "AdvancedCriteria");
            delete criteria._constructor;
            criteria = {
                _constructor:"AdvancedCriteria",
                operator:this.operator,
                criteria:[criteria]
            }
        }

        // We have to determine which items will edit which of the criteria.
        // For each inner criterion - see if we have an item that can edit it. If so,
        // clear it off the stored "extra criteria" and apply it directly to the item for
        // editing. getValuesAsCriteria() will reconstitute it when it runs!
        // Note: Some items have the ability to edit composite ("and" / "or") criteria - for
        // example if editing expressions a user can enter ">1 and <2".
        // This means we can't assume a 1:1 mapping between top level criterion objects and
        // items - we may have to combine multiple top level criteria acting on a particular field
        // into a single composite criterion and apply this to an item.
        // getValuesAsCriteria() simplifies criteria down so we don't need to worry about introducing
        // extra levels of nesting - the returned criteria will be logically equivalent and as
        // simple as possible.

        var items = this.getItems(),
            innerCriteria = criteria.criteria || [],
            assigned = {},
            itemsToClear = {};

        for (var i = 0; i < items.length; i ++) {
            itemsToClear[items[i].getID()] = true;
        }

        for (var i = 0; i < innerCriteria.length; i++) {

            for (var ii = 0; ii < items.length; ii++) {
                if (!items[ii].shouldSaveValue) {
                    itemsToClear[items[ii].getID()] = false;
                    continue;
                }
                var item = items[ii];

                if (this.shouldApplyCriterionToItem(items[ii], innerCriteria[i])) {
//                      this.logWarn("applying advanced criterion:" + isc.Comm.serialize(innerCriteria[i]) +
//                          "to item:" + items[ii]);
                    var itemID = items[ii].getID();
                    if (assigned[itemID] == null) {
                        assigned[itemID] = innerCriteria[i];
                        itemsToClear[itemID] = false;
                    } else {
                        // Do not try to combine criteria for items that express canEditOpaqueValues
                        if (!items[ii].canEditOpaqueValues) {
                            var existingCriteria = assigned[itemID];
                            var compositeCriterion = ds.combineCriteria(
                                existingCriteria, innerCriteria[i],

                                this.operator, null, true);

                            // attempt to compress/flatten the criteria
                            compositeCriterion = isc.DataSource.compressNestedCriteria(compositeCriterion, null, true);


                            if (!item.canEditCriterion(compositeCriterion)) {
                                this.logInfo("setValuesAsCriteria(): criteria include:" +
                                    this.echoFull(existingCriteria) + " and " +
                                    this.echoFull(innerCriteria[i]) + ". Both of these " +
                                    "could be applied to item:" + item +
                                    ". However, the item is unable to edit a composite criterion " +
                                    "resulting from combining these criteria. Therefore " +
                                    this.echoFull(innerCriteria[i]) + " will not be applied to this item",
                                    "AdvancedCriteria");

                                // Don't clear the inner criteria - we'll see if another item can
                                // edit it, otherwise we'll leave it around as "extraAdvancedCriteria"
                                continue;

                            } else {
                                this.logDebug("setValuesAsCriteria(): Combined multiple criteria into " +
                                    "composite criterion:" +
                                    this.echoFull(compositeCriterion) + " and assigned to item:" + item,
                                    "AdvancedCriteria");
                                assigned[itemID] = compositeCriterion;
                                itemsToClear[itemID] = false;
                            }
                        } else {
                            // Leave it around as "extraAdvancedCriteria"
                            continue;
                        }
                    }
                    innerCriteria[i] = null;
                    // no need to go through the rest of the items for this criterion...
                    break;
    //                 } else {
    //                     this.logWarn("Not applying adv criterion:"
    //                      + isc.Comm.serialize(innerCriteria[i]) + " to item:" + items[ii]);
                }


            }
        }
        innerCriteria.removeEmpty();

        // actually call 'setCriterion' to apply the criteria to the items
        for (var itemID in assigned) {
            var item = window[itemID];
            var value = assigned[itemID];
            if (item.canEditOpaqueValues && value) {
                isc.Canvas._saveFieldValue(null, item, value.value, oldValues, this, true, "criteria");
                value.value = isc.Canvas._getFieldValue(null, item, oldValues, this, true, "edit");
            }
            item.setCriterion(value);
        }

        // Clear any editable fields that aren't editing anything specific in the criterion.
        for (var itemID in itemsToClear) {
            if (!itemsToClear[itemID]) continue;
            var item = window[itemID];
            if (item) item.clearValue();
        }
        // store the fields we're not directly editing -- these will be recombined with
        // live values as part of getValuesAsCriteria();

        this._extraAdvancedCriteria = criteria;
    }
},

_saveValuesAsCriteria : function(criteria, dropExtraCriteria, dropCriteriaFields) {
    // if dropExtraCriteria is true, clear all field values that aren't defined in the criteria
    // before saving out the new criteria.
    if (dropExtraCriteria) {
        var undef;
        for (var key in this.values) {
            // Option to specify what extra fields we actually drop

            if (dropCriteriaFields && !dropCriteriaFields.contains(key)) continue;
            if (criteria[key] === undef && this.values[key] !== undef) {
                this.clearValue(key);
            }
        }
    }

    for (var key in criteria) {
        var item = this.getItem(key);
        if (item != null) {
            isc.Canvas._saveFieldValue(key, item, criteria[key], this.values, this, true, "criteria");
        } else {
            this.setValue(key, criteria[key]);
        }
    }

    // Now go through _saveValues() in order to refresh the ValuesManager
    this._saveValues(this.values);
},

shouldApplyCriterionToItem : function (item, criterion) {
    if (item.canEditCriterion(criterion)) return true;
    if (criterion.fieldName != null && criterion.fieldName == item.getCriteriaFieldName()) {
        // This is actually valid - we may have 2 items in the form used to edit the
        // same field with different operators (for example a number range with ">" and "<" operators)
        this.logInfo("Editing AdvancedCriteria in a dynamicForm. Criteria " +
                    "includes a value for field:" + criterion.fieldName +
                    ". This form includes an item " + item + " with the same fieldName" +
                    " but the specified operator '" +
                    criterion.operator + "' does not match the operator for this form item:" +
                    item.getOperator() +
                    ". Original criterion will be retained and combined with any " +
                    "criterion returned from this item.", "AdvancedCriteria");
    }
    return false;
},

//>    @method    dynamicForm.getValuesAsAdvancedCriteria()
// Return an AdvancedCriteria object based on the current set of values within this form.
// <p>
// Similar to +link{dynamicForm.getValuesAsCriteria()}, except the returned criteria object
// is guaranteed to be an AdvancedCriteria object, even if none of the form's fields has a
// specified +link{formItem.operator}
//
// @param [textMatchStyle] (TextMatchStyle) If specified the text match style will be used to
//   generate the appropriate <code>operator</code> for per field criteria.
// @group criteriaEditing
// @return (AdvancedCriteria) a +link{AdvancedCriteria} based on the form's current values
//
// @visibility external
//<
getValuesAsAdvancedCriteria : function (textMatchStyle, returnNulls) {
    return this.getValuesAsCriteria(true, textMatchStyle, returnNulls);

},

//> @attr dynamicForm.isSearchForm (Boolean : false : IRA)
// Is this form a "search form", used to edit filter criteria?
// <P>
// Marking a dynamicForm as a search form may cause differences in appearance, in which
// items are created for various data types, and in behaviors such as validation.
// See the +link{SearchForm} class for more information.
// @visibility internal
//<
// Undocumented for now

//isSearchForm:false,

//> @attr dynamicForm.useMultiSelectForValueMaps (boolean : true : IRW)
// When creating a SelectItem within a Search Form for editing criteria for a field with a ValueMap,
// should the SelectItem default to +link{SelectItem.multiple,multiple:true}?
// <P>
// Note that for ListGrids showing a +link{listGrid.showFilterEditor,filterEditor}, this property
// will be derived from +link{listGrid.useMultiSelectForFilterValueMaps}
// @visibility internal
//<
// Exposed on the SearchForm class
useMultiSelectForValueMaps:true,

shouldUseMultiSelectForValueMaps : function () {
    return (this.useMultiSelectForValueMaps && this.isSearchForm);
},

//>    @method    dynamicForm.getItem()
// Retrieve a +link{FormItem} in this form by it's +link{formItem.name,name},
// +link{formItem.dataPath,dataPath}, or index within
// the +link{dynamicForm.items,items} array.
// <P>
// FormItems that also have a +link{formItem.ID} may be accessed directly as a global variable
// <code>window[itemID]</code> or just <code>itemID</code>
//
// @param itemName (String | int) name of the item you're looking for
//
// @return (FormItem) FormItem object or null if not found
// @see getItem()
// @group items
// @visibility external
//<
getItem : function (itemName, isFieldName) {
    // if passed a null itemName, just bail
    if (itemName == null) return null;

    if (isc.isA.FormItem(itemName)) return itemName;

    var item = isc.Class.getArrayItem(itemName, this.items, this.fieldIdProperty);

    if (item != null) return item;

    // handle being passed a dataPath
    if (isc.isA.String(itemName)) {
        var targetDataPath = isc.DynamicForm._trimDataPath(itemName, this);
        for (var i = 0; i < this.items.length; i++) {
            var path = this.items[i].dataPath;
            path = isc.DynamicForm._trimDataPath(path, this);
            if (path == targetDataPath) return this.items[i];
        }
    }

    // If we couldn't find an item with the same name - check that we weren't passed
    // a quoted index (like the string "0")

    if (!isFieldName && isc.isA.Number(itemName - 1)) {
        return this.items[parseInt(itemName)];
    }

    return null;
},

//>    @method    dynamicForm.getField()   ([])
// Synonym for dynamicForm.getItem()
//
// @param itemName (FieldName) name of the item you're looking for
//
// @return (FormItem) FormItem object or null if not found
// @see getItem()
// @group items
// @visibility external
//<
getField : function (fieldID) {
    return this.getItem(fieldID);
},


//>    @method    dynamicForm.getSubItem()
//            Synonym for getItem()
//        @group    items
//        @param    itemID        (String)    name of the element you're looking for.
//        @return    (Object)    form item object, or null if not found
//      @deprecated As of SmartClient 5.5, use +link{dynamicForm.getItem}.
//<
getSubItem : function (itemID) {
    return this.getItem(itemID);
},

//>    @method    dynamicForm.getItemById()
//    Gets a pointer to a form item from it's global ID.
//    (the form item is also available globally as window[itemID])
//
//        @param    itemID        (String)    ID of the element you're looking for.
//        @return    (Object)    form item object or null if not found
//<
getItemById : function (itemID) {
    var item;

    if (isc.isA.String(itemID)) {
        item = window[itemID];
    } else item = itemID;

    if (isc.isA.FormItem(item)) return item;
    return null;
},


//>    @method    dynamicForm.getValue()  ([])
// Returns the value stored in the form for some field.
//      @visibility external
//        @group formValues
//
//        @param    fieldName (String)    name of the field for which you're retrieving a value. Nested
//          values may be retrieved by passing in a +link{type:DataPath}
//        @return    (Any)    value of the field
//      @example dateItem
//<
getValue : function (fieldName, reason) {

     var item = this.getItem(fieldName);
     if (item) {
         if (item.shouldSaveValue == false) {
             return item.getValue();
         }
         var fieldName = item.getTrimmedDataPath() || item.name;
     }
    return this._getValue(fieldName, reason);
},

_getValue : function (fieldName, reason) {
    return isc.DynamicForm._getFieldValue(fieldName, null, this.values, this, true, reason);
},

//>    @method    dynamicForm.setValue()  ([])
//   Sets the value for some field
//        @group formValues
//
//        @param    fieldName   (String)    Name of the field being updated. A +link{type:DataPath} may
//                          be passed to set nested values
//        @param    value        (String)    New value.
//      @visibility external
//<

storeAtomicValues:false,
setValue : function (fieldName, value, updatingDisplayValue) {
    var item = this.getItem(fieldName, updatingDisplayValue);
    // setValue on the item will update this.values.

    if (item != null) {

        if (item.destroyed) return;

        // Handle this being a field with an 'opaque' data type with a get/set atomic value method
        // If this is the case, extract the atomic value and pass it to the item.
        if (!this.storeAtomicValues && !item.canEditOpaqueValues) {
            var type = item.type ? isc.SimpleType.getType(item.type) : null;
            if (type && type.getAtomicValue && type.updateAtomicValue) {
                // store the new atomic type on our values object

                fieldName = item.getTrimmedDataPath() || item.name;
                this._saveValue(fieldName, value);
                // extract the atomic value which we'll pass to item.setValue()
                value = type.getAtomicValue(value);
            }
        }
        return item.setValue(value);

    } else if (this.values != null) {
        this._saveValue(fieldName, value);
        return value;
    }
},

//> @method dynamicForm.clearValue()
// Clears the value for some field via a call to +link{FormItem.clearValue()} if appropriate.
// If there is no item associated with the field name, the field will just be cleared within
// our stored set of values.
// @param fieldName (String) Name of the field being cleared. A +link{type:DataPath} may be used for
//  clearing details of nested data structures.
// @visibility external
//<
clearValue : function (fieldName) {
    var item = this.getItem(fieldName);
    if (item != null) item.clearValue();
    else if (this.values) isc.DynamicForm._clearFieldValue(fieldName, this.values);
},

//>    @method    dynamicForm.showItem()  ([])
// Show a form item via +link{FormItem.show()}
//        @group formValues
//
//        @param    itemName    (String)    Name of the item to show
//      @visibility external
//<
showItem : function (fieldName) {
    var item = this.getItem(fieldName);
    if (item != null) return item.show();
},

//>    @method    dynamicForm.hideItem()  ([])
// Hide a form item via +link{FormItem.hide()}
//        @group formValues
//
//        @param    itemName    (String)    Name of the item to show
//      @visibility external
//<
hideItem : function (fieldName) {
    var item = this.getItem(fieldName);
    if (item != null) return item.hide();
},

// This flag is used by DataBoundComponent.fieldShouldBeVisible()
_supportsFieldVisibleAttribute:true,

//>    @method    dynamicForm.saveItemValue()
// Save the value passed in in the values array associated with the item.
//        @group formValues
//
//        @param    item        (FormItem)    Item to save value for (cannot be a string or number, etc).
//        @param    value        (String)    New value to set.
//<
saveItemValue : function (item, value) {
    // if this is not supposed to be included in our values array, return
    if (item.shouldSaveValue == false) return;
    var dataFieldID = item.getDataPath() || item.getFieldName();

    if (dataFieldID == null) return;
    if (item.canEditOpaqueValues) {
        // Don't pass in the field object, or it will call updateAtomicValue() even though we
        // know we are dealing with opaque values
        var trimmedDataPath = isc.Canvas._getDataPathFromField(item, this);
        this._saveOpaqueValue(trimmedDataPath, value);
    } else {
        this._saveAtomicValue(item, value);
    }

    // If this is an item with a display field, store the display field value as well.
    // This will update any auto-generated valueMap for the field.


    this.itemDisplayValueModified(item, value);

    //this.logWarn("saveItemValue: " + itemName + ": " + this.echoLeaf(value));
    // Mark the item as no longer being dirty
    item._markValueAsNotDirty();
},

//> @attr DynamicForm.storeDisplayValues (Boolean : true : IRA)
// For editable fields with a specified +link{formItem.displayField} and
// +link{formItem.optionDataSource}, if the user selects a new value (typically from
// PickList based item such as a SelectItem), should the selected displayValue be updated
// on the record being edited in addition to the value for the actual item.<br>
// Note that this only applies for fields using
// +link{formItem.useLocalDisplayFieldValue,local display field values} - typically
// +link{dataSourceField.foreignKey,foreignKey fields} where the display field is
// +link{dataSourceField.includeFrom,included from} another dataSource.
// <P>
// Default value is <code>true</code>. This is typically desirable for editing records
// with a displayField-mapped field, as it ensures the edited record will be be updated
// to contain the correct display value as well as the correct data value. As such, the
// expected display value is available on the record for display (for example in a ListGrid
// cell).
// <P>
// It may not be desirable for an interface specifically intended for
// +link{dynamicForm.getValuesAsCriteria, gathering criteria} - in this case, results ought
// to be limited by an item's actual selected value, not by whatever text is displayed to
// the user.
// <P>
// See +link{dataSourceField.displayField} for more details.
// <P>
// Note: the modified display field value will be passed to the server along with the
// modified foreignKey field value if a
// +link{dynamicForm.saveData(),databound update operation} is performed. This occurs
// even if the displayField is
// +link{dataSourceField.includeFrom,included from another DataSource} and therefore
// read-only. In this case the server will simply ignore the modified display field value.
// This is as expected - a subsequent fetch for the same record would recalculate the
// displayField value on the server using the updated foreignKey field value (and return
// the same display value previously displayed to the user).
// <P>
// This attribute can also be set for +link{formItem.storeDisplayValues, individual items}.
// @visibility external
//<
storeDisplayValues: true,

// Called from saveItemValue, and also called from FormItem._fetchMissingDisplayFieldValueReply
itemDisplayValueModified : function (item, value) {
    var dataFieldID = item.getDataPath() || item.getFieldName();

    if (!this._useDisplayFieldValue(item) || (item.displayField == dataFieldID)) return;


    // storeDisplayValues attribute allows developers to explicitly indicate whether
    // for fields with a valueField and displayField specified, both values should be
    // updated when a user selects a new optionDataSource record.
    if (this.storeDisplayValues == false || item.storeDisplayValues == false) return;

    var displayValue = item.mapValueToDisplay(value);

    // if displayValue was set to {formItem}.emptyDisplayValue, this means that data
    // value is empty (i.e. is null). {formItem} here stands for items that support
    // emptyDisplayValue, like SelectItem/ComboBoxItem/etc, for other items this check
    // would be always false, since emptyDisplayValue would be undefined.
    // So, we do not want to save emptydisplayValue (which can be set to some string as
    // part of UI) as displayField value if data value is empty (null), therefore we save
    // null as value for displayField as well.
    if (displayValue == item.emptyDisplayValue) displayValue = null;

    // If we're bound to a valuesManager the display field should be updated there instead
    // of being updated at the DynamicForm level, since forms inside VM's don't support
    // having values set for fields with no associated item.
    var vm = this._getValuesManager();
    if (vm) {
        vm.setValue(item.displayField, displayValue, true);
    } else {
        this.setValue(item.displayField, displayValue, true);
    }

},

// _saveValue and _saveValues - actually update this.values

_$slash:"/",
// _saveAtomicValue() - this is fired from 'saveItemValue' - IE the user has edited an atomic value
// (a string etc) and we need to save it.
// If the field has a specified simpleType with 'setAtomicType()' we'll make use of it here.
_saveAtomicValue : function (field, value) {
    this._saveValue(field, value, true);
},
_saveOpaqueValue : function (field, value) {
    this._saveValue(field, value, false);
},
_saveValue : function (field, value, isAtomicValue) {


    var fieldName, origFieldName;
    origFieldName = fieldName = field;
    field = this.getField(fieldName);
    var origField = field;
    if (this.storeAtomicValues && (!field || !field.canEditOpaqueValues)) {
        if (isc.isAn.Object(fieldName)) {
            fieldName = field.getTrimmedDataPath() || field[this.fieldIdProperty];
            field = null;
        }
    } else {

        if (!isc.isA.String(fieldName)) {
            // we'll handle extracting the fieldName in DBC._saveFieldValue

            fieldName = null;
        } else {
            if (isAtomicValue) {
                field = this.getField(fieldName);
                if (field == null) {
                    var ds = this.getDataSource();
                    if (ds) field = ds.getField(fieldName) || ds.getFieldForDataPath(fieldName);
                }
            } else {
                field = null;
            }
        }
    }

    isc.DynamicForm._saveFieldValue(fieldName, field, value, this.values, this, true, "updateValue");

    field = origField;



    this._updateRuleScopeValues(field, fieldName, value);

    // If this form is part of a valuesManager, notify that of the change.
    // Note that the presence of a selectionComponent means we skip this - instead of
    // interacting with the VM values object directly, our selectionComponent will interact
    // with the VM values
    var selComponent = this.selectionComponent;
    if (!selComponent && this.valuesManager != null) {
        // If called during init, we may have not yet been added to the valuesManager as a member
        // or vm may be set to an ID, etc
        if (isc.isA.ValuesManager(this.valuesManager) && this.valuesManager.members &&
            this.valuesManager.members.contains(this))
        {
            // Normalize to a string - that's what _updateValue on the VM expects to be passed.
            if (!isc.isA.String(origFieldName)) {
                origFieldName = origFieldName.dataPath || origFieldName.name;
            }
            this.valuesManager._updateValue(origFieldName, value, this);
        }
    }
},

// clearItemValue()
// Internal method to clear the value for some field from the values object for this form.
// Called from item.clearValue()
clearItemValue : function (item) {
    var fieldName = isc.DynamicForm._combineDataPaths(this.dataPath, item.getDataPath() ||
                                                                     item.getFieldName());

    isc.DynamicForm._clearFieldValue(fieldName, this.values);
    this._updateRuleScopeValues(item, fieldName, null);

    if (!this.selectionComponent && isc.isA.ValuesManager(this.valuesManager) &&
         this.valuesManager.members && this.valuesManager.members.contains(this))
    {
        this.valuesManager._clearValue(fieldName, this);
    }
},

_updateRuleScopeValues : function (field, fieldName, value, noChangeEvent) {
    if (this._suppressRuleContextUpdates) return;


    if ((this.grid == null || !this._settingValues) &&
        (this.ruleScope || this.isRuleScope) &&
        (fieldName || (field && field.name)))
    {
        fieldName = fieldName || field.name;
        var ds = this.getDataSource(),
            hasStableID = this.hasStableLocalID() || this.grid || (this.editNode != null)
        ;
        if (ds && isc.isA.DataSource(ds) && this._populateSharedRuleContext != false) {
            this.provideRuleContext(ds.getID() + "." + fieldName, value,
                this, null, noChangeEvent || hasStableID || this._setValuesPending || (!noChangeEvent && this._fireRuleContextOnItemChange));
        }
        if (hasStableID) {
            // Suppress ruleContextChanged events during initial draw. A single event is raised
            // when rememberValues() is called.
            var gridRefreshing = field && field._gridRefresh,
                suppressChangeEvent = this._initialDraw || this._settingValues ||
                                      this._setValuesPending || gridRefreshing
            ;
            this.provideRuleContext(this.getLocalId() + ".values." + fieldName, value,
                this, null, true);
            if (!this._settingValues) {
                var hasChangesPath = this.getLocalId() + ".hasChanges";



                var hasChanges = this.valuesHaveChanged(false, this.values);

                this.provideRuleContext(hasChangesPath, hasChanges,
                    this, null, noChangeEvent || suppressChangeEvent);
            }
        } else if (!noChangeEvent && this._fireRuleContextOnItemChange) {
            this.fireRuleContextChanged(this);
        }
    }
},

// _saveValues() updates this.values with the object passed in

_saveValues : function (values) {

    this.values = values;

    //>ValuesManager    If this form is part of a valuesManager, notify that of each field
    // affected by the change
    if (!this.selectionComponent && isc.isA.ValuesManager(this.valuesManager) &&
         this.valuesManager.members && this.valuesManager.members.contains(this))
    {
        var oldFields = isc.getKeys(this.values);
        for (var fieldName in values) {
            this.valuesManager._updateValue(fieldName, values[fieldName], this);
            oldFields.remove(fieldName);
        }
        // Clear any values in the VM that have been cleared by this
        for (var i = 0; i < oldFields.length; i++) {
            this.valuesManager._clearValue(oldFields[i], this);
        }
    }   //<ValuesManager
},

//>    @method    dynamicForm.getSavedItemValue()
// Save the value passed in in the values array associated with the item.
//        @group formValues
//
//        @param    item        (FormItem)    Form item instance to check for the saved item value
//        @return    (Any)                    Value saved for that item
//<
getSavedItemValue : function (item) {
    // If this is marked as a value we don't want to save, skip it.
    if (item.shouldSaveValue == false) return null;

    var    fieldName = isc.DynamicForm._combineDataPaths(this.dataPath, item.getDataPath() ||
                                                                     item.getFieldName());
    return this._getValue(fieldName);
},


//>    @method    dynamicForm.resetValue()
//        @group formValues
//
//        @param    itemName        (String)    name of the element you're looking for
//<
resetValue : function (itemName) {
    var item = this.getItem(itemName);
    return (item ? item.resetValue() : null);
},



//>    @method    dynamicForm.getValueMap()
//        return the valueMap for a specified item
//        @group formValues
//        @param    itemName        (String)    name of the element you're looking for
//<
getValueMap : function (itemName) {
    var item = this.getItem(itemName);
    return (item ? item.getValueMap() : null);
},

//>    @method    dynamicForm.setValueMap()
// Set the valueMap for a specified item
// @group formValues
// @param itemName (String) itemName of the item upon which the valueMap should be set.
// @param valueMap (ValueMap) new valueMap for the field in question.
// @visibility external
//<
setValueMap : function (itemName, valueMap) {
    var item = this.getItem(itemName);
    return (item ? item.setValueMap(valueMap) : null);
},

//>    @method    dynamicForm.getOptions()
//        Get the options for a specified item.  Pass-through to form.getValueMap()
//        @group formValues
//        @param    itemName        (String)    name of the element you're looking for
//<
getOptions : function (itemName) {
    return this.getValueMap(itemName);
},

//>    @method    dynamicForm.setOptions()
//        Set the options for a specified item.  Pass-through to form.setValueMap()
//        @group formValues
//        @param    itemName        (String)            name of the element you're looking for
//        @param    valueMap    (Array | Object)    new value map to set
//<
setOptions : function (itemName, valueMap) {
    return this.setValueMap(itemName, valueMap);
},

//>    @method    dynamicForm.getForm()
// Return the DOM form object.  Returns null if not found
//
//        @param    [form]        (Form | String | number)    identifier for the form or an actual form
//
//        @return    (Form)    Form object
//<
getForm : function (form) {
    var args = (form == null ? [this.getFormID()] : arguments);
    return this.Super("getForm", args);
},

//>    @method    dynamicForm.getFormID()    (A)
//        @group    drawing
//            return the ID for this form
//
//        @return    (String)    ID for this form in the DOM
//<
_$form:"form",
getFormID : function () {
    return this._getDOMID(this._$form);
},

getSerializeableFields : function(removeFields, keepFields) {
    removeFields = removeFields || [];

    // items and fields are the same thing, but items is deprecated and printing both would
    // produce a backref - so remove one of them
    removeFields.addList(["items"]);

    return this.Super("getSerializeableFields", [removeFields, keepFields], arguments);
},

// Form Sections
// --------------------------------------------------------------------------------------------

//> @attr DynamicForm.canTabToSectionHeaders (boolean : null : IRA)
// If true, the headers for any +link{SectionStackSection.items,SectionItems} will be included in the page's tab
// order for accessibility. May also be set at the item level via +link{SectionItem.canTabToHeader}
// <P>
// If unset, section headers will be focusable if <smartclient>+link{isc.setScreenReaderMode}</smartclient>
// <smartgwt>{@link com.smartgwt.client.util.SC#setScreenReaderMode SC.setScreenReaderMode()}</smartgwt>
// has been called.
// See +link{group:accessibility}.
//
// @visibility external
//<

expandSection : function (sectionID) {
    var section = this.getItem(sectionID);
    if (isc.isA.SectionItem(section)) section.expandSection();
},

collapseSection : function (sectionID) {
    var section = this.getItem(sectionID);
    if (isc.isA.SectionItem(section)) section.collapseSection();
},

// Notification functions fired when a section is about to be expanded or collapsed - allows
// us to handle mutex sections.
_sectionExpanding : function (section) {

    if (this.isDrawn()) {
        this._specifiedNotifyAncestorsOnReflow = this.notifyAncestorsOnReflow;
        this.notifyAncestorsOnReflow = true;
    }

    if (this.sectionVisibilityMode == "mutex" && this._lastExpandedSection &&
         this._lastExpandedSection != section)
    {
        this._lastExpandedSection.collapseSection();
    }
    this._lastExpandedSection = section;
},

_sectionCollapsing : function (section) {
    if (this.isDrawn()) {
        this._specifiedNotifyAncestorsOnReflow = this.notifyAncestorsOnReflow;
        this.notifyAncestorsOnReflow = true;
    }

},

// Validation error management
// --------------------------------------------------------------------------------------------

//> @method dynamicForm.getErrors()
// Returns any errors that are currently visible to the user for this form, without performing
// validation.
//
// @return (Object) Errors are returned as an object of the format<br>
// <code>{fieldName:errors, fieldName:errors}</code><br>
// where each <code>errors</code> object will be either an error message string or an array
// of error message strings.
// @group errors
// @visibility external
//<
getErrors : function () {
    return this.errors;
},


//> @method dynamicForm.getFieldErrors()
// Returns any errors that are currently visible to the user for the specified field in this
// form, without performing validation.
//
// @param fieldName (String) fieldName to check for errors
// @return (String | Array of String) Error message string, or if there is more than one error
//      associated with this field, array of error message strings.
// @group errors
// @visibility external
//<
// Note that the fieldName doesn't have to be associated with a form item - this could be
// a validator on a dataSource field too.
getFieldErrors : function (fieldName) {
    if (!this.errors) return null;
    var dataPath;
    if (isc.isA.FormItem(fieldName)) {
        var formItem = fieldName;
        fieldName = formItem.getFieldName();
        dataPath = this.buildFieldDataPath(this.getFullDataPath(), formItem)
    }
    var err = this.errors[fieldName];
    if (isc.isA.String(err) || isc.isAn.Array(err)) {
        return err;
    }
    if (dataPath != null) {
        //var err = this.getDataPathErrors(dataPath);
        if (isc.isA.String(err) || isc.isAn.Array(err)) return err;
    }
    return null;
},

getDataPathErrors : function (dataPath) {
    var elements = dataPath.split("/");
    var work = this.errors;
    for (var i = 0; i < elements.length; i++) {
        work = work[elements[i]];
        if (!work) return null;
    }
    return work;
},


//>    @method    dynamicForm.setErrors() ([A])
// Setter for validation errors on this form. Errors passed in should be a Javascript object
// of the format<br>
// <code>{fieldName1:errors, fieldName2:errors}</code><br>
// Where the <code>errors</code> value may be either a string (single error message) or an
// array of strings (if multiple errors should be applied to the field in question).
// @param    errors        (Object)    list of errors as an object with the field names as keys
// @param  showErrors  (boolean)
//      If true redraw form to display errors now. Otherwise errors can be displayed by calling
//      +link{DynamicForm.showErrors()}<br>
//      Note: When the errors are shown,
//      +link{dynamicForm.handleHiddenValidationErrors(), handleHiddenValidationErrors()} will
//      be fired for errors on hidden fields, or with no associated formItem.
//        @group    errors
//      @visibility external
//<
setErrors : function (errors, showErrors) {

    var hadErrors = this.hasErrors();
    this.errors = isc.DynamicForm.formatValidationErrors(errors);
    var hasHiddenErrors = false,
        hiddenErrors = {};

    this._updateFormHasErrorsInRuleScope(hadErrors);

    for (var fieldName in this.errors) {
        var item = this.getItem(fieldName);
        if (!item || !item.visible) {
            hiddenErrors[fieldName] = this.errors[fieldName];
            hasHiddenErrors = true;
        }
    }

    // pass in current set of hidden errors - we know they're up to date so no need to
    // call 'getHiddenErrors()' again
    if (showErrors) this.showErrors(this.errors, hiddenErrors);

},

//>    @method    dynamicForm.setError()  ([A])
//          Sets error message(s) for the specified itemName to the error string or array of
//          strings. You must call form.markForRedraw() to display the new error message(s).<br>
//          <b>Note:</b> you can call this multiple times for an individual itemName
//             which will result in an array of errors being remembered.
//
//        @param    itemName        (String)    name of the item to set
//        @param    errorMessage    (String | Array)    error message string or array of strings
//        @group    errors
//      @visibility external
// @deprecated This method has been deprecated as of SmartClient release 5.7.
//  Use +link{DynamicForm.addFieldErrors()} or +link{DynamicForm.setFieldErrors()} instead
//<
setError : function (itemName, errorMessage) {
    var hadErrors = this.hasErrors(),
        oldError = this.errors[itemName];
    if (!oldError) {
        this.errors[itemName] = errorMessage;
    } else {
        if (isc.isA.String(oldError)) this.errors[itemName] = [oldError, errorMessage];
        else this.errors[itemName].add(errorMessage);
    }
    this._updateFormHasErrorsInRuleScope(hadErrors);
},





//>    @method    dynamicForm.addFieldErrors()
// Adds field validation error[s] to the specified field. Errors passed in will be added
// to any existing errors on the field caused by validation or a previous call to this method.
// <br>
// The errors parameter may be passed in as a string (a single error message), or an array of
// strings.<br>
// The showErrors parameter allows the errors to be displayed immediately. Alternatively, call
// +link{DynamicForm.showFieldErrors()} to display the errors for this field.
// @param fieldName (String) field to apply the new errors to
// @param errors (String | Array of String) errors to apply to the field in question
// @param show (boolean) If true this method will fall through to +link{dynamicForm.showFieldErrors}
// to update the display
// @group errors
// @visibility external
//<
// Not clear whether this is necessary in addition to 'setFieldErrors()', but this matches
// the previous 'setError()' method implementation, which was public in 5.6.
addFieldErrors : function (fieldName, errors, showErrors) {
    var hadErrors = this.hasErrors();
    if (!this.errors) this.errors = {};

    this.addValidationError(this.errors, fieldName, errors);

    this._updateFormHasErrorsInRuleScope(hadErrors);

    // Don't bother updating hiddenErrors - this will be updated by
    // showErrors() / showFieldErrors()
    if (showErrors) this.showFieldErrors(fieldName);
},

//>    @method    dynamicForm.setFieldErrors()
// Set field validation error[s] for some field.<br>
// The errors parameter may be passed in as a string (a single error message), or an array of
// strings.<br>
// The showErrors parameter allows the errors to be displayed immediately. Alternatively, an
// explicit call to +link{DynamicForm.showFieldErrors()} will display the errors for this field.
// @param fieldName (String) field to apply the new errors to
// @param errors (String | Array of String) errors to apply to the field in question
// @param show (boolean) If true this method will fall through to +link{dynamicForm.showFieldErrors}
// to update the display
// @group errors
// @visibility external
//<
setFieldErrors : function (fieldName, errors, showErrors) {
    var hadErrors = this.hasErrors();
    if (this.errors == null) this.errors = {};

    // if we'd just be re-applying the same errors, then bail out now
    if (isc.Canvas.compareValues(this.errors[fieldName], errors)) {
        return false;
    }
    this.errors[fieldName] = errors;

    this._updateFormHasErrorsInRuleScope(hadErrors);

    // Don't bother updating hiddenErrors - this will be updated by
    // showErrors() / showFieldErrors()

    if (showErrors) this.showFieldErrors(fieldName);

    return true;
},

//> @method dynamicForm.clearFieldErrors()
// Clear any validation errors on the field passed in.
// @param fieldName (String) field to clear errors from
// @param show (boolean) If true this method will fall through to +link{dynamicForm.showFieldErrors}
// to update the display
// @group errors
// @visibility external
//<
clearFieldErrors : function (fieldName, show, suppressAutoFocus) {
    if (this.errors == null) return;
    if (!this.errors[fieldName]) return;

    delete this.errors[fieldName];
    this._updateFormHasErrorsInRuleScope(true);
    if (show) {
        this.showFieldErrors(fieldName, suppressAutoFocus);
    }
},

// Helper to clear a specific error message from a field's errors.
clearFieldError : function (fieldName, error, show) {
    if (this.errors == null || !this.errors[fieldName]) return;
    var fieldErrors = this.errors[fieldName];
    if (!isc.isAn.Array(fieldErrors)) {
        if (fieldErrors == error) {
            delete this.errors[fieldName];
        }
    } else {
        if (fieldErrors.contains(error)){
            fieldErrors.remove(error);
        }
        if (fieldErrors.length == 0) delete this.errors[fieldName];
    }
    this._updateFormHasErrorsInRuleScope(true);
    if (show) this.showFieldErrors(fieldName);
},

//>    @method    dynamicForm.clearErrors()   ([])
//    Clears all errors for this DynamicForm.
// @param show (boolean) If true, redraw the form to clear any visible error messages.
// @group    errors
// @visibility external
//<
clearErrors : function (show) {
    this.setErrors({}, show);
},


//>    @method    dynamicForm.hasErrors()
// Returns whether there are currently any errors visible to the user for this form, without
// performing validation.
// <P>
// Note that validation errors are set up automatically by validation (see +link{validate()}),
// or may be explicitly set via +link{dynamicForm.setErrors()} or
// +link{dynamicForm.setFieldErrors()}.
// @return (Boolean) true if the form currently has validation errors.
// @group errors
// @visibility external
//<
hasErrors : function () {
    var errors = this.errors;
    if (!errors) return false;
    for (var name in errors) {
        if (errors[name] != null) return true;
    }
    return false;
},

//> @method dynamicForm.hasFieldErrors()
// Returns whether there are currently any errors visible to the user for the specified field in
// this form, without performing any validation.
// <P>
// Note that validation errors are set up automatically by validation (see +link{validate()}),
// or may be explicitly set via +link{dynamicForm.setErrors()} or
// +link{dynamicForm.setFieldErrors()}.
// @param fieldName (String) field to test for validation errors
// @return (Boolean) true if the form has outstanding errors for the field in question.
// @group errors
// @visibility external
//<
hasFieldErrors : function (fieldName) {
    var errors = this.errors;
    return (errors && errors[fieldName] != null);
},


// Drawing and redrawing
// --------------------------------------------------------------------------------------------

//>    @method    dynamicForm.draw()    (A)
// Focuses in the first form field on idle
//
//        @group    drawing
//
//        @param    [document]        (DOM Document)    document to draw in
//
//        @return    ()
//<
_$_delayedSetValues:"_delayedSetValues",
_$_delayedSetValuesFocus:"_delayedSetValuesFocus",
draw : function (a,b,c,d) {
    if (isc._traceMarkers) arguments.__this = this;
    // draw the form as normal
    if (!this.readyToDraw()) return this;

    // Notification that items are about to draw()

    this._itemsDrawing();

    // While drawing, suppress ruleContext updates so rules aren't processed
    // for each FormItem. Once drawing is complete, the delayed setValues() call
    // will take care of updating ruleContext.
    this._suppressRuleContextUpdates = true;

    this.invokeSuper(isc.DynamicForm, this._$draw, a,b,c,d);

    // We've now written all our items into the DOM - notify them that they are drawn!
    this._itemsDrawn();

    // Re-enable ruleContext updates
    delete this._suppressRuleContextUpdates;


    var shouldFocus = this.autoFocus,
        functionName = (!shouldFocus ? this._$_delayedSetValues : this._$_delayedSetValuesFocus);
    this._setValuesPending = true;

    // If there is an outstanding delayed setValues call, cancel it because this new
    // one will take care of the same thing. Don't just let the previous one fire because
    // the new functionName may be different.
    var eventId = this._delayedSetValuesEventId;
    if (eventId != null) {
        isc.Page.clearEvent(isc.EH.IDLE, eventId);
    }
    this._delayedSetValuesEventId = isc.Page.setEvent(isc.EH.IDLE, this, isc.Page.FIRE_ONCE, functionName);


    if (this.position == isc.Canvas.RELATIVE) {
        isc.Page.setEvent(isc.EH.LOAD, this, isc.Page.FIRE_ONCE, "_placeCanvasItems");
    }

    return this;
},

_createItemWhenRules : function (items) {
    var rules = [],
        affectedItems = [],
        ruleScope = this.getRuleScope()
    ;
    for (var i = 0; i < items.length; i++) {
        if (items[i]._createdItemWhenRules) {
            continue;
        }

        var item = items[i],
            rulesCount = rules.length
        ;

        // A canvas inherits ruleScope from its parent but in the case of a FormItem
        // it's not a Canvas and therefore would require an explicit ruleScope setting
        // just like any other non-Canvas instance. To make this process easier,
        // a ruleScope is pushed into the FormItem. Note that this isn't necessary for
        // *When rules or for normal ruleContext updates but is useful for setting a
        // dynamicProperty on a form field.
        if (ruleScope && !item.ruleScope) item.ruleScope = ruleScope;

        if ((!item.showIf && item.visibleWhen) ||
                (!item.requiredIf && item.requiredWhen) ||
                item.readOnlyWhen ||
                (item.formula && !isc.isA.emptyObject(item.formula)) ||
                (item.textFormula && !isc.isA.emptyObject(item.textFormula)))
        {
            // An item with no 'name' defined cannot be assigned to a rule
            // and is ignored. A warning is logged below.
            var badProperties = (item.name == null ? [] : null);
            if (!item.showIf && item.visibleWhen) {
                if (isc.disableRuleScope) {
                    this.logWarn("Attempt to define FormItem visibleWhen criteria while RuleScope has been explicitly disabled (isc.disableRuleScope=true). Criteria will be ignored.")
                    continue;
                }
                if (badProperties) {
                    badProperties.add("visibleWhen");
                } else {
                    rules.add(this._createWhenRule("visibility", item.visibleWhen, {fieldName:item.name}));
                }
            }
            if (!item.requiredIf && item.requiredWhen) {
                if (isc.disableRuleScope) {
                    this.logWarn("Attempt to define FormItem requiredWhen criteria while RuleScope has been explicitly disabled (isc.disableRuleScope=true). Criteria will be ignored.")
                    continue;
                }
                if (badProperties) {
                    badProperties.add("requiredWhen");
                } else {
                    rules.add(this._createWhenRule("setRequired", item.requiredWhen, {fieldName:item.name}));
                }
            }
            if (item.readOnlyWhen) {
                if (isc.disableRuleScope) {
                    this.logWarn("Attempt to define FormItem readOnlyWhen criteria while RuleScope has been explicitly disabled (isc.disableRuleScope=true). Criteria will be ignored.")
                    continue;
                }
                if (badProperties) {
                    badProperties.add("readOnlyWhen");
                } else {
                    var rule = this._createWhenRule("readOnly", item.readOnlyWhen, {fieldName:item.name});
                    rule.fieldAppearance = item.readOnlyDisplay || this.readOnlyDisplay;
                    rules.add(rule);
                }
            }
            if (item.formula || item.textFormula) {
                if (isc.disableRuleScope) {
                    this.logWarn("Attempt to define FormItem " + (item.formula ? "formula" : "textFormula") + " while RuleScope has been explicitly disabled (isc.disableRuleScope=true). Formula will be ignored.")
                    continue;
                }
                if (badProperties) {
                    badProperties.add(item.formula ? "formula" : "textFormula");
                } else {
                    var rule = this._createFormulaRule(item);
                    rules.add(rule);
                }
            }
            if (badProperties) {
                for (var j = 0; j < badProperties.length; j++) {
                    this.logWarn("Form item with no name defined - '" + badProperties[j] + "' is ignored: " + this.echo(item));
                }
            }
        }

        // FormItemIcon rules
        if (item.icons) {
            var icons = item.icons;
            for (var j = 0; j < icons.length; j++) {
                var icon = icons[j];
                if ((!icon.showIf && icon.visibleWhen) || icon.enableWhen) {
                    if (!icon.showIf && icon.visibleWhen) {
                        if (item.name == null) {
                            this.logWarn("Form item icon with no formItem.name defined - 'visibleWhen' is ignored: " + this.echo(icon));
                        } else {
                            rules.add(this._createWhenRule("visibility", icon.visibleWhen,
                                {fieldName:(item.name || item.ID), formIconName:j}));
                        }
                    }
                    if (icon.enableWhen) {
                        if (item.name == null) {
                            this.logWarn("Form item icon with no formItem.name defined - 'enableWhen' is ignored: " + this.echo(icon));
                        } else {
                            // The criteria is for "enable" but the rule is for "disable" so it must be negated.
                            var negatedCriteria = {
                                _constructor: "AdvancedCriteria",
                                operator: "not",
                                criteria: icon.enableWhen
                            };
                            rules.add(this._createWhenRule("enable", negatedCriteria,
                                {fieldName:(item.name || item.ID), formIconName:j}));
                        }
                    }
                }
            }
        }
        if (rules.length != rulesCount) {
            affectedItems.add(item);
        }
    }
    if (rules.length > 0) {
        var rulesEngine = this.getRulesEngine();
        // The rulesEngine may not be accessible yet because the ruleScope
        // is not yet derived.
        if (!rulesEngine) {
            // Note that no item._createdItemWhenRules is set
            return;
        }
        rulesEngine.addMember(this);
        for (var i = 0; i < rules.length; i++) {
            rulesEngine.addRule(rules[i]);
        }
        if (rules.length > 0 && !rulesEngine.members.contains(this)) {
            rulesEngine.addMember(this);
        }
        // Set initial state
        rulesEngine.processContextRules(rules, this);

        for (var i = 0; i < affectedItems.length; i++) {
            affectedItems[i]._createdItemWhenRules = true;
        }
        // If form doesn't have a stable ID have the itemChange event
        // fire ruleContext changed event so rules are processed. This
        // only affects rules that reference only local values.
        if (!this.hasStableLocalID() && this.editNode == null) {
            this._fireRuleContextOnItemChange = true;
        }
    }
},

_removeItemWhenRules : function () {
    var component = this.getRuleScopeComponent();
    if (component && this.items && this.getRulesEngine()) {
        var items = this.items;
        for (var i = 0; i < items.length; i++) {
            var item = items[i],
                itemName = item.getTrimmedDataPath() || item.getFieldName()
            ;
            if (item.requiredWhen) this._removeWhenRule("setRequired", {fieldName:itemName});
            if (item.visibleWhen) this._removeWhenRule("visibility", {fieldName:itemName});
            if (item.readOnlyWhen) this._removeWhenRule("readOnly", {fieldName:itemName});
            if (item.formula) this._removeWhenRule("formula", {fieldName:itemName});
            if (item.textFormula) this._removeWhenRule("textFormula", {fieldName:itemName});

            if (item.icons) {
                var icons = item.icons;
                for (var j = 0; j < icons.length; j++) {
                    var icon = icons[j];
                    if (icon.visibleWhen) this._removeWhenRule("visibility", {fieldName:itemName, formIconName:j});
                    if (icon.enableWhen) this._removeWhenRule("enable", {fieldName:itemName, formIconName:j});
                }
            }
            delete item._createdItemWhenRules;
        }
        delete this._fireRuleContextOnItemChange;
    }
},

_createFormulaRule : function (item) {
    var fieldName = item.name,
        formulaProperty = (item.formula ? "formula" : "textFormula"),
        ruleName = this._getRuleName(formulaProperty, {fieldName:fieldName}),
        target = { component: this, fieldName: fieldName },
        formItemType = item.type || item.defaultType,
        ruleType = (formulaProperty == "formula"
            ? (formItemType == 'date' || formItemType == 'time' ? "populateExpression" : "populate")
            : "populateText"),
        formula = item.formula || item.textFormula
    ;

    return isc.addProperties({
        name: ruleName,
        triggerEvent: "contextChanged",
        type: ruleType,
        internalRule: true,
        overwriteInvalidValue: true,
        autoPopulateClearedFlag: this.autoPopulateClearedFlag,
        formula: formula.text,
        targetRuleScope: this.getRuleScope(),
        allowEscapedKeys: true
    }, target);
},

// Update a live formItem with new *When rule. Used in editMode.
_ruleCriteriaProperties:{
    visibleWhen: { attribute: "visibility", exclusiveProperty: "showIf" },
    requiredWhen: { attribute: "setRequired", exclusiveProperty: "requiredId" },
    readOnlyWhen: { attribute: "readOnly", additionalProperties: { "fieldAppearance": "readOnlyDisplay" }},
    formula: { attribute: "formula" },
    textFormula: { attribute: "textFormula" }
},
_updateItemWhenRule : function (item, criteriaProperty) {
    var properties = this._ruleCriteriaProperties[criteriaProperty];
    if (!properties) return;
    var rulesEngine = this.getRulesEngine();
    if (!rulesEngine) return;
    var targetAttribute = properties.attribute;

    // Remove rule in case it previously existed
    this._removeWhenRule(targetAttribute, {formItem:item.name});
    // Create new rule if criteria is defined
    if (item[criteriaProperty] && (!properties.exclusiveProperty || !item[properties.exclusiveProperty])) {
        if (criteriaProperty == "formula" || criteriaProperty == "textFormula") {
            var rule = this._createFormulaRule(item);
        } else {
            var rule = this._createWhenRule(targetAttribute, item[criteriaProperty], {fieldName:item.name});
        }
        if (properties.additionalProperties) {
            for (var key in properties.additionalProperties) {
                rule[key] = item[properties.additionalProperties[key]];
            }
        }
        rulesEngine.addRule(rule);
    }
    // process rules immediately to pick up changes
    rulesEngine.processContextChanged();
},

_removeFromRuleScope : function () {
    // remove any ruleContext values for this form
    if (this.ruleScope) {
        var ds = this.getDataSource(),
            hasStableID = this.hasStableLocalID() || this.grid || (this.editNode != null)
        ;
        if (ds && isc.isA.DataSource(ds) && this._populateSharedRuleContext != false) {
            this.provideRuleContext(ds.getID(), null, this, null, hasStableID);
        }
        if (hasStableID) this.provideRuleContext(this.getLocalId(), null, this);
    }
    this.Super("_removeFromRuleScope", arguments);
},


//>Safari

_adjustOverflowForPageLoad : function () {
    if (isc.Browser.isSafari) {
        var items = this.getItems();
        if (this.isDrawn() && items) {
            for (var i = 0; i < items.length; i++) {
                items[i]._updateHTMLForPageLoad();
                // If the item the form to redraw completely we don't need individual items to
                // sort out their sizes since they'll get wiped out and redrawn anyway.
                if (this.isDirty()) break;
            }
        }
    }
    return this.Super("_adjustOverflowForPageLoad", arguments);
},
//<Safari

// helper methods fired asynchronously after draw
_delayedSetValues : function () {
    this._createItemWhenRules(this.getItems());

    this.setItemValues(null, true);


    //this.rememberValues();




    if (this.ruleScope || this.isRuleScope) {
        var ds = this.getDataSource(),
            hasStableID = this.hasStableLocalID() || this.editNode != null
        ;
        if (hasStableID) {
            this.provideRuleContext(this.getLocalId() + ".hasChanges", false, this);
        }
    }

    delete this._setValuesPending;
    delete this._delayedSetValuesEventId;

    // If we have a specified rulesEngine, notify it that we're editing a new set of values
    var rulesEngine = this.getRulesEngine();
    if (rulesEngine != null) rulesEngine.processEditStart(this);

    if (this._fireRuleContextOnItemChange) {
        this.fireRuleContextChanged(this);
    }
},

_delayedSetValuesFocus : function () {
    this._delayedSetValues();

    this.delayCall("focus");
},

//>    @method    dynamicForm.redraw()
//        @group    drawing
//<
redraw : function () {

    var recursiveRedraw = this._redrawInProgress;


    this._itemsRedrawing();
    this._redrawInProgress = true;
    // While redrawing, suppress ruleContext updates so rules aren't processed
    // for each FormItem. Once drawing is complete, fire the ruleContext changed event
    // so the rules can be processed one time
    this._suppressRuleContextUpdates = true;


    if (this.__suppressBlurHandler != null) delete this.__suppressBlurHandler;

    // call the superclass method to redraw the form
    this.Super("redraw", arguments);

    // notify our items that they've been redrawn in the DOM.
    this._itemsRedrawn();

    // Re-enable normal ruleContext updates and fire ruleContext changed event to process
    // applicable rules once for the entire form
    delete this._suppressRuleContextUpdates;
    // No need to call fireRuleContextChanged() because the setItemValues() call below
    // will update the items and provide ruleContext updates as needed.

    // If this was a recursive call to redraw, allow the parent thread to clear the flag
    if (!recursiveRedraw) this._redrawInProgress = false;


    this.setItemValues(null, true);


    var scrollLeft, scrollTop, clipHandle;
    if (isc.Browser.isMoz) {
        clipHandle = this.getClipHandle();
        if (clipHandle) {
            scrollLeft = clipHandle.scrollLeft;
            scrollTop = clipHandle.scrollTop;
        }
    }

    if (isc.Browser.isMoz) {
        if (scrollLeft != null && clipHandle.scrollLeft != scrollLeft)
            clipHandle.scrollLeft = scrollLeft;
        if (scrollTop != null && clipHandle.scrollTop != scrollTop)
            clipHandle.scrollTop = scrollTop;
    }

    // Notify all our items that their positions may have been modified by the redraw.
    // This catches the many possible cases where the HTML written into the DF will have
    // changed, causing layout changes to visible form items.

    this.itemsMoved();


    if (this._specifiedNotifyAncestorsOnReflow != null) {
        this.notifyAncestorsOnReflow = this._specifiedNotifyAncestorsOnReflow;
        this._specifiedNotifyAncestorsOnReflow = null;
    }

},

// Notification for each item to tell it we're about to draw it
// Called directly from draw()
_itemsDrawing : function () {

    var items = this.items;
    for (var i = 0; i < items.length; i++) {


        if (items[i]) {
            // re-evaluate 'showIf' on each item
            this.updateItemVisible(items[i]);
            // fire the 'drawing()' notification [essentially "about to draw"]
            if (items[i].visible) items[i].drawing();
        }
    }
},

// Re-evaluate 'showIf' for each item

updateItemVisible : function(item) {
    var visible = item.visible;
    var values = this.values;

    // if the item has a showIf method
    //    evaluate that to see whether the item should be visible or not.
    //    We note if the visible states of any items changes so we can know to recalculate
    //        form layout if visibility of any items has changed.
    if (item.showIf) {
        // CALLBACK API:  available variables:  "item,value,form,values"
        // Convert a string callback to a function
        isc.Func.replaceWithMethod(item, this._$showIf, this._$showIfArgs);

        var value = item.getValue();
        visible = (item.showIf(item,value,this,values) == true);
    }
    if (visible && this.isPrinting) {
        // shouldPrint takes precedence over whether it's a control or not, etc

        if (item.shouldPrint != null) {
            visible = item.shouldPrint;
        } else if (visible && this.currentPrintProperties.omitControls) {
            var omitControls = this.currentPrintProperties.omitControls;
            for (var i = 0; i < omitControls.length; i++) {
                var cName = omitControls[i];
                if (isc.isA[cName] && isc.isA[cName](item)) {
                    visible = false;
                }
            }
        }
    }
    // Remember the visible state directly on the item.
    var changed =  (item.visible != visible);
    if (changed) {
        item.visible = visible;
        // Fire the special 'itemVisibilityChanged' so we know a dynamic 'showIf()' function
        // changed the item visibility
        item.itemVisibilityChanged(visible);
    }

},

// When we draw / redraw, we want to notify our items that their HTML is now present in the DOM

_itemsDrawn : function () {
    // formItems with an optionDataSource will commonly issue a fetch request on draw
    // to pick up display values.
    // Use queuing to minimize server turnarounds when this happens.
    var shouldSendQueue = isc.RPCManager && !isc.RPCManager.startQueue();

    this._initialDraw = true;

    var items = this.items;
    for (var i = 0; i < items.length; i++) {
        if (items[i]) {
            if (items[i].visible) items[i].drawn();
        }
    }
    delete this._initialDraw;

    if (shouldSendQueue) isc.RPCManager.sendQueue();
},

_itemsRedrawn : function () {
    var items = this.items;
    for (var i = 0; i < items.length; i++) {
        var item = items[i];
        if (!item) continue;
        // If an items visibility changed due to showIf() evaluating differently, or
        // this redraw being kicked off by "item.show()" / "item.hide()", we want to fire
        // a cleared() / drawn() notification on the item.
        // Pass in the parameter indicating that this was the item visibility changing, not
        // the form as a whole being cleared/drawn
        if (item.visible) {
            item.isDrawn() ? item.redrawn() : item.drawn(true);
        } else if (item.isDrawn()) {
            item.cleared(true);
        }
    }
    this.destroyOrphanedItems("Delayed destroy of removed items on form redraw");

},

// Called from form.clear() - notify each item it has been cleared
_itemsCleared : function () {
    var items = this.items;
    if (items) {
        for (var i = 0; i < items.length; i++) {
            // The function check here is because we sometimes end up in this function when
            // this.items is still a bunch of config, not a list of FormItems
            if (items[i].isDrawn && items[i].isDrawn()) items[i].cleared();
        }
    }

    this.destroyOrphanedItems("Delayed destroy of removed items on clear");
},

destroyOrphanedItems : function (reason) {
    if (this._orphanedItems != null) {
        this._orphanedItems.callMethod("destroy", [reason]);
        delete this._orphanedItems;
    }
},

// Notify items that are about to be redrawn BEFORE the redraw occurs as well as after

_itemsRedrawing : function () {
    var items = this.items;
    for (var i = 0; i < items.length; i++) {
        var item = items[i];
        if (!item) continue;

        // re-evaluate 'showIf' on each item

        var wasVisible = items[i].isDrawn();
        this.updateItemVisible(items[i]);

        // Call the notifications on items indicating they're about to redraw, draw or clear
        // as appropriate
        // Pass in the itemVisibilityChange argument - this is useful so items can have
        // different logic for reacting to the form as a whole drawing and clearing vs just the item.

        var isVisible = item.visible;
        if (isVisible && wasVisible) item.redrawing();
        else if (isVisible && !wasVisible) item.drawing(true);
        else if (!isVisible && wasVisible) item.clearing(true);
        // No notification required for !isVisible && !isDrawn (was hidden, still is!)
    }
},

modifyContent : function () {
    // NOTE: we have to place Canvas items after the form's table has been redrawn, but before
    // adjustOverflow, so that CanvasItems do not force a shrinking form to stay full size
    this._placeCanvasItems();
},


_placeCanvasItems : function () {
    return this._notifyCanvasItems("placeCanvas", true);
},

// a utility for making notification calls to all CanvasItems
_notifyCanvasItems : function (method, visibleOnly) {
    // don't JS error if CanvasItem not included
    if (!isc.CanvasItem) return;

    for (var i = 0; i < this.items.length; i++) {
        var item = this.items[i];

        if (item && isc.isA.CanvasItem(item) && (!visibleOnly || item.isVisible(true))) {
            item[method]();
        }
    }
},

//> @method    dynamicForm.redrawFormItem()
// Redraw the form item passed in.  This should handle re-evaluating showIf / visible property
// on the item, and width/height, as well as updating the HTML content of the item.
// Default implementation just marks the form for redraw.
//  @param  item    (FormItem)  Form item to be redrawn.
//<

redrawFormItem : function (item, reason) {

    var items = this.getItems();
    if (!item) return;
    while (item.parentItem) item = item.parentItem;
    if (!items.contains(item)) return;

    // Set this._itemsChanged so when we redraw we'll re-run the TableResizePolicy before
    // This is required for showing / hiding items or changing colSpan, etc.

    this._itemsChanged = true;
    this.markForRedraw(item.ID + ": " + (reason ? reason : "redrawFormItem"));
},

// for debugging purposes only
getElementValues : function () {
    var values = {};
    for (var i = 0; i < this.items.length; i++) {
        var item = this.items[i],
            value = item.getDataElement() ? item.getDataElement().value : "[no element]";

        values[item[this.fieldIdProperty]] = value;
    }
    return values;
},


setItemValues : function (values, onRedraw, initTime, items, validating) {

    var shouldSendQueue = isc.RPCManager ? !isc.RPCManager.startQueue() : false;

    // get the item values from the values object if it was not passed in.
    var setToExisting = (values == null);
    if (setToExisting) values = this.getValues();
    if (values == null) values = {};
    // If we're changing the set of items and setValuesAsCriteria has been
    // called, we may have advancedCriteria stored that didn't have an item but now
    // applies to an item that's been added.
    var extraCriteria;
    if (initTime) {
        extraCriteria = this._extraAdvancedCriteria ? this._extraAdvancedCriteria.criteria : null;
    }

    items = items || this.items;
    var undef,
        ds = this.getDataSource(),
        haveValues = values != null && !isc.isAn.emptyObject(values),
        fieldChanges = { /* fieldName -> newFieldValue */ }
    ;

    // Suppress ruleContext updates while setting values so they can all be provided at
    // one time upon completion resulting in a single ruleContextChanged event. To do
    // this, keep up with the fieldChanges.
    var origSuppressRuleContextUpdates = this._suppressRuleContextUpdates;
    this._suppressRuleContextUpdates = true;

    for (var itemNum = 0; itemNum < items.length; itemNum++) {
        var item = items[itemNum];


        if (!item || item.destroyed || item.destroying) {
            continue;
        }


        if (item._skipSetFromForm) {


            if (!this._redrawInProgress) delete item._skipSetFromForm;
            continue;
        }

        var fieldName = item.getFieldName(),
            dataPath = item.getTrimmedDataPath(),
            isSetToDefault = item.isSetToDefaultValue(),

            value = undef;

        if (haveValues) {



            if (dataPath) {
            //    var segments = dataPath.split(isc.slash),
            //        nestedValues = values;
            //    for (var i = 0; i < segments.length-1; i++) {
            //        nestedValues = nestedValues[segments[i]];
            //        if (nestedValues == null) break;
            //    }
            //    if (nestedValues != null) value = nestedValues[segments.last()];
                value = isc.DynamicForm._getFieldValue(dataPath,
                            (item.canEditOpaqueValues || (this.storeAtomicValues && !item.canEditOpaqueValues) ? null : item),
                                    values, this, true, "edit");
            } else if (fieldName) {
                value = isc.DynamicForm._getFieldValue(fieldName,
                            (item.canEditOpaqueValues || (this.storeAtomicValues && !item.canEditOpaqueValues) ? null : item),
                                    values, this, true, "edit");
            }
        }


        if (onRedraw && isc.CanvasItem && isc.isA.CanvasItem(item) &&

            !item._useHiddenDataElement())
        {
            continue;
        }

        var undef,

            isUndefined = ((!fieldName && !dataPath) || value === undef);

        var initValue = null;
        // support initializing form items with a specified 'value'
        if (initTime && isUndefined && item.value != null) {
            initValue = item.value;
            // Ignore the fact that item is set to default if the init-value (item.value)
            // doesn't match the value stored as item._value [which is derived from the default]
            if (initValue != item._value) isSetToDefault = false;
        }

        // If there's no value for the item in the simple values array,
        // but we have something in the 'extraCriteria' object
        // that applies to the item, use setCriteria to apply it

        var setToCriterion = null;
        if (isUndefined && extraCriteria != null) {
            for (var i = 0; i < extraCriteria.length; i++) {

                if (item.canEditCriterion(extraCriteria[i])) {

                    isUndefined = false;

                    if (setToCriterion == null) {
                        setToCriterion = extraCriteria[i];
                    } else {
                        var compositeCriterion = ds.combineCriteria(
                            setToCriterion, extraCriteria[i],
                            this.operator, null, true);

                        if (!item.canEditCriterion(compositeCriterion)) {
                            this.logInfo("setItemValues(): current values include multiple extra criteria " +
                                "that could be applied to form item:" + item +
                                ". Criteria include:" +
                                this.echoFull(setToCriterion) + " and " +
                                this.echoFull(extraCriteria[i]) +
                                ". However, the item is unable to edit a composite criterion " +
                                "resulting from combining these criteria. Therefore " +
                                this.echoFull(extraCriteria[i]) + " will not be applied to this item",
                                "AdvancedCriteria");

                            // Don't clear the extraCriteria criterion- we'll see if another item can
                            // edit it, otherwise we'll leave it around as "extraAdvancedCriteria"
                            continue;

                        } else {
                            this.logInfo("setItemValues(): Combined multiple 'extra' criteria into " +
                                "composite criterion:" +
                                this.echoFull(compositeCriterion) + " and assigned to item:" + item,
                                "AdvancedCriteria");
                            setToCriterion = compositeCriterion;
                        }
                    }
                    // Arrays are passed around by reference in JS so this we're updating
                    // this._extraAdvancedCriteria here
                    extraCriteria.removeAt(i);
                    if (extraCriteria.length == 0) {
                        delete this._extraAdvancedCriteria;
                    } else {
                        // We've directly modified the array, so decrement the counter since
                        // we'll now be pointing at the next entry.
                        i--;
                    }

                    // Don't break - we may be able to apply more than one
                    // "extra" sub-criterion to this item by combining them as a composite crit
                    //break;
                }
            }
        }

        if (item.shouldSaveValue == false) {
            if (!isUndefined) {
                // If the item is marked as shouldSaveValue false, but we've been passed a
                // value for it, assume the developer wants the item store a value in the
                // values array, so turn 'shouldSaveValue' back on for that item.
                //>DEBUG
                this.logInfo("DynamicForm.setValues() passed a value for '" + item[this.fieldIdProperty] + "'." +
                             " The corresponding form item was declared with 'shouldSaveValue' set to " +
                             " false to exclude its value from the form's values object." +
                             " Setting 'shouldSaveValue' to true for this item." +
                             "\n[To avoid seeing this message in the future, set 'shouldSaveValue'" +
                             " to true for any form items whose values are to be managed via " +
                             " form.setValues() / form.getValues().]")
                //<DEBUG
                item.shouldSaveValue = true;
            } else {


                var oldItemValue = (isSetToDefault ? null : item._value);
                if (initValue != null) oldItemValue = initValue;
                item.setValue(oldItemValue, (isSetToDefault ? false : onRedraw));
                if (item.name) fieldChanges[item.name] = oldItemValue;
                continue;
            }

        }

        if (initValue != null) {
            isUndefined = false;
            value = initValue;
        }

        // If the value is undefined, we want to use 'item.clearValue()' to reset to the
        // default value.  Note that in order to cause defaultValues to be re-evaluated on a
        // redraw, if an item has it's default value we need to call clearValue() rather than
        // restoring the old default value.
        if ((isUndefined || (setToCriterion == null && setToExisting && isSetToDefault)) &&
            !validating)
        {


            var undef;
            if (!initTime) {
                if (!item.valueHasChanged() || item._value != value) {
                    item.clearValue();
                    if (item.name && !isSetToDefault) fieldChanges[item.name] = undef;
                    else if (item.name) fieldChanges[item.name] = item._value;
                } else {
                    item.saveValue(value, isSetToDefault);
                    if (item.name) fieldChanges[item.name] = value;
                }
            } else if (initTime && isSetToDefault && item._value !== undef) {
                item.saveValue(item._value, true);
                if (item.name) fieldChanges[item.name] = item._value;
            }

        } else {
            if (setToCriterion != null) {
                item.setCriterion(setToCriterion);


            } else if (!validating || !isUndefined) {

                item.setValue(value, true);
                if (item.name) fieldChanges[item.name] = value;
            }
        }
    }

    // Restore ruleContext updates flag as it was
    this._suppressRuleContextUpdates = origSuppressRuleContextUpdates;

    // If we aren't still suppresing ruleContext updates apply any fieldChanges found.
    // Skip this if form is a grid edit form - let the grid manage it. Otherwise, changes
    // can be made against the form (indirectly) that are recorded in _updatedFields.
    if (!this._suppressRuleContextUpdates && !isc.isAn.emptyObject(fieldChanges) && this.grid == null) {
        // Hold the ruleContextChanged event until all changes have been made to ruleContext
        for (var fieldName in fieldChanges) {
            var field = this.getField(fieldName),
                newFieldValue = fieldChanges[fieldName]
            ;
            if (field) {
                this._updateRuleScopeValues(field, fieldName, newFieldValue, true);
            }
        }
        // Since all _updateRuleScopeValues() calls above suppress ruleContext notifications
        // we need to finish the dangling transaction and fire the event so rules can
        // be processed
        this._endProvideRuleContextTransaction();
    }

    if (shouldSendQueue) isc.RPCManager.sendQueue();

},

// Drawing
// --------------------------------------------------------------------------------------------

_$absolute:"absolute",
_absPos : function () {
    //!DONTCOMBINE
    return this.itemLayout == this._$absolute;
},


setColWidths : function (colWidths) {
    if (colWidths == null) return;
    // handle a comma-separated String
    if (isc.isA.String(colWidths)) {
        var colWidthsArray = colWidths.split(/[, ]+/);
        if (colWidthsArray == null || colWidthsArray.length == 0) {
            this.logWarn("ignoring invalid colWidths string: " + colWidths);
            // wipe it out if it's the value we were created with
            if (colWidths == this.colWidths) this.colWidths = null;
            return;
        }
        colWidths = colWidthsArray;
    // handle an Array of one String where the string is comma-separated.  This happens when
    // coming from Component XML if colWidths is specified as an attribute - the colWidths
    // field needs to be declared multiple="true" to handle the normal XML format for an Array,
    // so the String attribute gets wrapped in an Array
    } else if (isc.isAn.Array(colWidths) && colWidths.length == 1 &&
               isc.isA.String(colWidths[0]))
    {
        var colWidthsArray = colWidths[0].split(/[, ]+/);
        if (colWidthsArray != null || colWidthsArray.length > 1) {
            colWidths = colWidthsArray;
        }
    }
    this.colWidths = colWidths;

    if (this.isDrawn()) this.markForRedraw();
},

//>    @method    dynamicForm.getInnerHTML()    (A)
//            Output the HTML for this form
//        @group    drawing
//
//        @return    (String)                HTML for the form
//<
_$showIf:"showIf",
_$showIfArgs:"item,value,form,values",
_$closeForm:"</FORM>",
_$tablePolicy:"tablePolicy",
_$colWidthEquals:"<COL WIDTH=",


_$topRowTag:((isc.Browser.isIE && !isc.Browser.isIE9) ? "<TR STYLE='position:absolute'>" : "<TR>"),

_$topRowCellEnd:(isc.Browser.isSafari || isc.Browser.isMoz ? "</div></TD>" : "</TD>"),
_$cellStart:"<TD>",
_$cellEnd:"</TD>",
_$rowStart:"<TR>",
_$rowEnd:"</TR>",
_$br:"<br>",
_$tableFormClose:"</TABLE></FORM>",
_$tableClose:"</TABLE>",

getInnerHTML : function (printCallback) {
    if (this.autoDupMethods) this.duplicateMethod("getInnerHTML");

    // get the values and items
    var values = this.values,
        items = this.items
    ;

    // Check Visibility / Disabled State
    // --------------------------------------------------------------------------------------------

    // iterate through the items, marking items as invisible if their .showIf is false
    // keep track if the visibility has changed or not
    var visibilityChanged = false;

    for (var itemNum = 0; itemNum < items.length; itemNum++) {
        var item = items[itemNum],
            drawn = item.isDrawn(),

            // item.visible is set up from showIf() and shouldPrint - handled in
            // itemsDrawing() and itemsRedrawing(), called before this method in the draw()/redraw() flow.
            visible = item.visible;

        if (visible != drawn) {
            // If the item is marked to take up space even when it's hidden, don't reflow
            // on show/hide
            if (!item.alwaysTakeSpace) visibilityChanged = true;
        }
    }

    // if the dynamic visibility for any item(s) has changed, or the _itemsChanged flag has
    // been set, throw away any cached tableResizePolicy for the size of the form elements, etc.
    // We set the _itemsChanged flag when we modify the items array (adding/removing items)
    // or modify other things that invalidate the cache (like changing title orientation,
    // visibility of items, etc)
    if (visibilityChanged || this._itemsChanged) isc.Canvas.invalidateTableResizePolicy(items);
    this._itemsChanged = false;

    // set the required property of any fields that are conditionally required

    this.setRequiredIf();

    // Layout
    // --------------------------------------------------------------------------------------------

    // if flattenItems is set, summing columns, taking into account showTitle and colSpan
    // settings, as well as title orientation (titleOrientation:"top" means the title
    // doesn't take up a column)

    if (this.flattenItems) {
        var flatCols = null;

        for (var itemNum = 0; itemNum < items.length; itemNum++) {
            var item = items[itemNum];

            // if this field is not hidden or if it is and takes space
            // increment the total columns
            if (item.visible || item.alwaysTakeSpace) flatCols++;

            // if this field has a displayed title on the left,
            // increment the total columns
            if (item.showTitle && item.titleOrientation != "top")
                flatCols++;

            // if there is a colSpan set, make a copy of it and nullify it
            item._colSpan = item.colSpan || null;
            item.colSpan = null;
        }

        if (flatCols) {
            this.numCols = flatCols;
            this._itemsChanged = true;
            this.markForRedraw();
        }
    }


    // get a StringBuffer to hold the output
    var output = isc.StringBuffer.create();



    // start the form tag
    if (this.writeFormTag && !this.isPrinting) output.append(this.getFormTagStartHTML());

    if (this._absPos()) {
        output.append(this.getAbsPosHTML());

        // end the form
        output.append(this._$closeForm);

        return output.release(false);
    }

    // start the table
    output.append(this.getTableStartHTML());

    // generate evenly spaced colWidths if no explicit colWidths have been provided and
    // titleWidth is set to *
    if (this.titleWidth == this._$star && !this.colWidths) {
        this.colWidths = [];
        for (var i = 0; i < this.numCols; i++) this.colWidths[i] = this._$star;
    }

    // set up the colWidths array
    var colWidths;

    // if the form has colWidths defined, use those
    if (this.colWidths) {
        colWidths = this.colWidths;
        if (colWidths.length > this.numCols) {
            if (!this._suppressColWidthWarnings) {
                this.logWarn("colWidths Array longer than numCols, using only first " +
                             this.numCols + " column widths");
            }
            colWidths = colWidths.slice(0, this.numCols);
        } else if (colWidths.length < this.numCols) {
            if (!this._suppressColWidthWarnings) {
                this.logWarn("colWidths Array shorter than numCols, remaining columns get '*' size");
            }
            // duplicate the colWidths array in case it comes from *Defaults
            colWidths = colWidths.duplicate();
            for (var i = colWidths.length; i < this.numCols; i++) colWidths[i] = isc.star;
        }
    } else {
        // otherwise create default column widths, based on the assumption that every other
        // column will be full of labels and so should have DF.titleWidth.
        // NOTE: We'll have a column full of labels by default because each item in the form
        // takes up two columns in the table: one for the label, the other for the native form
        // element itself.  We do it this way so that a series of textboxes will line up.
        colWidths = [];

        var totalWidth = this.getInnerContentWidth();

        // Take off cellBorder - this is actually the border of the native HTML <table>
        totalWidth -= (this.cellBorder != null ? this.cellBorder : 0);

        // NOTE: items that actually try to fit within the column width take into account
        // cellSpacing and cellPadding via FormItem.getInnerWidth()

        // if an odd number of columns is specified, assume the last column is an element
        // column, as a column of dangling labels is unlikely.  To produce reasonable layout,
        // a form with an odd number of columns will probably need to specify colWidths..
        var    titleCols = Math.floor(this.numCols/2),
            // total width for all label columns
            totalElementColWidth = totalWidth - (titleCols * this.titleWidth),
            // width of each form element column
            elementColWidth;
        if (this.isPrinting) {
            // When printing don't calculate element column widths based on
            // the DynamicForm size -- the printHTML may be written into a
            // different sized container
            elementColWidth = "*";
        } else {
            elementColWidth =  Math.floor(totalElementColWidth / (this.numCols-titleCols));
            // don't let it get too small
            elementColWidth = Math.max(this.minColWidth, elementColWidth);
        }

        for (var i = 0; i < titleCols; i++) {
            // add a column for the label
            colWidths.add(this.titleWidth);
            // add a column for the form element
            colWidths.add(elementColWidth);
        }
        // for an odd number of columns, take on another element column
        if ((this.numCols % 2) != 0) colWidths.add(elementColWidth);
        if (this.logIsInfoEnabled(this._$tablePolicy)) {
            this.logInfo("totalWidth: " + totalWidth + ", generated colWidths: " + colWidths,
                         this._$tablePolicy);
        }
    }
    // run the tableResizePolicy on the list to set up the table of form items
    //    this assigns sizes to dynamic items as well as populating the structure
    //    that maps items to particular rows/cols
    //   Note: This will set up the _size property on the items as a 2 element array, where
    //   the first element represents the desired width, and the the second the height.
    //   For some items getInnerHTML() will make use of this property to specify the elements
    //   drawn size, though if not available, the standard item.width, item.height will be used
    //   instead.

    var innerWidth = this.getInnerContentWidth(),
        innerHeight = this.getInnerContentHeight();


    if (this.cellSpacing != 0) {
        if (isc.Browser.isMoz) innerHeight -= 2*this.cellSpacing;
        else if (isc.Browser.isSafari) innerHeight -= this.cellSpacing;
    }

    items._defaultRowHeight = this.defaultRowHeight;
    isc.Canvas.applyTableResizePolicy(items, innerWidth, innerHeight,
                                  this.numCols, colWidths);



    var overflowed = false;
    if (isc.CanvasItem) {
        for (var i = 0; i < items.length; i++) {
            var item = items[i];
            if (item.visible && isc.isA.CanvasItem(item) && item.checkCanvasOverflow()) {
                if (!overflowed && this.logIsInfoEnabled(this._$tablePolicy)) {
                    this.logInfo("CanvasItem: " + item + " overflowed, rerunning policy",
                                 this._$tablePolicy);
                }
                overflowed = true;
            }
        }
    }

    if (overflowed) {
        isc.Canvas.applyTableResizePolicy(items, innerWidth, innerHeight,
                                          this.numCols, colWidths, null, true);
    }

    if (!this.isPrinting) {
        colWidths = items._colWidths;
    }

    // output <COL> tags to set the sizes of the columns.

    for (var colNum = 0; colNum < colWidths.length; colNum++) {
        var colWidth = colWidths[colNum];
        // In printing mode we avoided the tableResizePolicy - we expect to see
        // colWidths specified as "*" and titleWidth
        // If "*" just omit writing out a width at all
        if (colWidth == "*") {
            output.append("<COL>");
        } else {
            output.append(this._$colWidthEquals, colWidth, this._$rightAngle);
        }
    }





    // if fixedColWidths is set, force column widths to be respected as minimums by writing
    // out a row of cells with spacers.  <COL> tags on their own won't enforce minimums.
    if (this.isPrinting) {

        output.append("<tr>");
    } else {
        output.append(this._$topRowTag);
    }

    var topRowCellStart = isc.DynamicForm._getTopRowCellStart();
    for (var colNum = 0; colNum < colWidths.length; colNum++) {
        if (!isc.isA.Number(colWidths[colNum])) {
            output.append(topRowCellStart.join(isc.emptyString), this._$topRowCellEnd);
        } else {
            var innerWidth = colWidths[colNum];
            // NOTE: correct for spacing, but *do not* correct for padding, because we write out
            // padding:0px on the cells
            innerWidth -= (this.cellSpacing!= null ? (2 * this.cellSpacing) : 0);


            if (isc.Browser.isIE8Strict) {
                innerWidth -= this.cellPadding != null ? (2* this.cellPadding) : 0;
            }
            // The top row has theoretically a height of zero px, but can actually be visible in IE
            // if it has a bg-color applied to it.
            // We've seen this occur with a stylesheet that globally sets td background-color.
            // handle this by applying standard form cell style

            topRowCellStart[3] = (isc.FormItem ? isc.FormItem.getPrototype().baseStyle : null);

            var spacerHeight = isc.Browser.isIE ? 1 : 0,
                cellStart = topRowCellStart.join(isc.emptyString);
            output.append(cellStart,
                          this.fixedColWidths ? isc.Canvas.spacerHTML(innerWidth,spacerHeight) : null,
                          this._$topRowCellEnd);
        }
    }
    output.append(this._$rowEnd);

    // if this.autoSendTarget is set, add a '__target__' hidden field so that the server knows the
    // name of the frame/window this form is being targeted at.
    if (this.autoSendTarget && this.target) output.append(this._getAutoSendTargetHTML());

    // Draw HTML for Items
    // --------------------------------------------------------------------------------------------



    var len = items.length,
        wentAsync = false;

    var self = this;
    var completeInnerHTMLFun = function completeInnerHTMLFun(htmlOutputs) {
        // append all item outputs
        if (htmlOutputs != null) {
            // since there may be more than 26 outputs, need to push onto output's stream directly.
            var outputStream = output.getArray();
            outputStream.push.apply(outputStream, htmlOutputs);
        }

        // end the current row
        if (len > 0) output.append(self._$rowEnd);

        // end the table and form
        if (self.writeFormTag && !self.isPrinting) output.append(self._$tableFormClose);
        // end just the table
        else output.append(self._$tableClose);

        var HTML = output.release(false);
        if (wentAsync) {
            self.fireCallback(printCallback, "HTML", [HTML]);
            return false;
        } else {
            return HTML;
        }
    };

    // for each item in the list, get HTML output for it and combine the output
    if (len > 0) {
        // Handle this by tracking items to include in the next cell in an array, to be updated
        // in the loop while writing cells out.
        var includeInNextCell = [],
            htmlOutputs = new Array(len),
            completedCount = 0;

        var itemCompletedFun = function itemCompletedFun() {
            if (++completedCount == len) {
                return completeInnerHTMLFun(htmlOutputs);
            }
        };

        var theHTML;
        for (var itemNum = 0; itemNum < len; ++itemNum) {


            var item = items[itemNum],
                itemOutput = isc.SB.create(),
                visible,
                column,
                error,
                value,
                titleOrientation,
                showErrors;

            // if a null item, skip it
            if (!item) {
                theHTML = itemCompletedFun();
                continue;
            }

            visible = item.visible;
            // note that the value of this item can't possibly be dirty anymore
            item._markValueAsNotDirty();

            //>DEBUG
            if (this.logIsDebugEnabled()) this.logDebug("Drawing FormItem: " + item); //<DEBUG

            // if the item has been marked as invisible, skip it unless it's marked to take space
            // even when hidden
            if (!item.alwaysTakeSpace && !visible) {
                theHTML = itemCompletedFun();
                continue;
            }

            // if this item should not take up a cell, we'll include it in the next cell's HTML
            // (Unless we're the last item, in which case, just take up a cell!)
            if ((item.rowSpan == 0 || item.colSpan == 0) && itemNum < len-1) {
                includeInNextCell.add(item);
                theHTML = itemCompletedFun();
                continue;
            }

            // get the error for this form element
            column = item.getFieldName();
            error = item.getErrors();
            value = item.getValue();
            titleOrientation = this.getTitleOrientation(item);

            // if the error is an empty string, null it out
            if (isc.is.emptyString(error)) error = null;

            // if the item should start its row or passes the name boundary
            // output the end and start row tag
            // Note: _startRow attribute set up via Canvas.applyTableResizePolicy()
            if (item._startRow || itemNum == 0) {
                if (itemNum != 0) {
                    itemOutput.append(this._$rowEnd);
                }
                if (item._emptyRows && item._emptyRows.length > 0) {
                    for (var i = 0; i < item._emptyRows.length; i++) {
                        itemOutput.append(this._$rowStart);

                        var numCells = this.numCols;
                        for (var ii = 0; ii < item._emptyRows[i]; ii++) {
                            itemOutput.append(this._$cellStart, "&nbsp;", this._$cellEnd);

                        }
                        itemOutput.append(this._$rowEnd);
                    }
                }
                itemOutput.append(this._$rowStart);
                if (item._emptyCells > 0) {
                    for (var i = 0; i < item._emptyCells; i++) itemOutput.append(this._$cellStart, this._$cellEnd);
                }
            }

            // place title on the left of the item, in its own cell
            if (titleOrientation == isc.Canvas.LEFT) {
                itemOutput.append(this.getTitleCellHTML(item, error));
            }

            // output the tag start for the item if it has a positive row and colSpan
            itemOutput.append(this.getCellStartHTML(item, error));

            // place title on top of the item, with no separate cell
            if (visible && titleOrientation == isc.Canvas.TOP) {
                if (this.shouldClipTitle(item)) {
                    itemOutput.append(this.getTitleCellInnerHTML(item, error, true));
                } else {
                    itemOutput.append(this.getTitleSpanHTML(item, error), this._$br);
                }
            }

            // if there is an error associated with the item, output that
            showErrors = (visible && error && this.showInlineErrors);
            if (showErrors && item.getErrorOrientation() == isc.Canvas.TOP) {
                itemOutput.append(this.getItemErrorHTML(item, error));
            }

            var completeIncludedInnerHTMLFun = (function (itemNum, item, itemOutput, visible, column, error, value, titleOrientation, showErrors) {
                var func = function func(HTML) {
                    itemOutput.append(HTML);

                    // Top and bottom orientation are handled by writing the error HTML out here -- left
                    // and right orientation will be handled as part of formItem.getInnerHTML
                    if (showErrors && item.getErrorOrientation() == isc.Canvas.BOTTOM) {
                        itemOutput.append(self.getItemErrorHTML(item, error));
                    }

                    // append the tag end for the item
                    itemOutput.append(self.getCellEndHTML(item, error));

                    // place title on right of item, in it's own cell
                    if (titleOrientation == isc.Canvas.RIGHT) {
                        itemOutput.append(self.getTitleCellHTML(item, error));
                    }

                    htmlOutputs[itemNum] = itemOutput.release(false);

                    return itemCompletedFun();
                };

                return function (includedHtmlOutputs) {
                    if (includedHtmlOutputs != null) {
                        // since there may be more than 26 included items, we need to push onto
                        // itemOutput's stream directly.
                        var itemOutputStream = itemOutput.getArray();
                        itemOutputStream.push.apply(itemOutputStream, includedHtmlOutputs);
                    }

                    // output the innerHTML for the item
                    if (visible) {
                        // pass in the parameter to write out the hint text and validation errors
                        // along with the form item
                        // Note if validation error orientation is top or bottom we write the error out
                        // as part of this method - otherwise we need to write the error out in the form
                        // item HTML (like the hint)
                        if (self.isPrinting) {
                            var printHTML = item.getPrintHTML(self.currentPrintProperties, func);
                            if (printHTML == null) {
                                return false;
                            } else {
                                return func(printHTML);
                            }
                        } else {
                            return func(item.getInnerHTML(value, true, self.showInlineErrors));
                        }

                    } else return func(isc.Canvas.spacerHTML(item.width, item.height));
                };
            })(itemNum, item, itemOutput, visible, column, error, value, titleOrientation, showErrors);

            // if any items are being 'piggy backed' into this item's cell, write them out now.
            var includedLen = includeInNextCell.length;
            if (includedLen > 0) {
                var includedHtmlOutputs = new Array(includedLen);

                var includedCompletedFun = (function (completeIncludedInnerHTMLFun, includedLen, includedHtmlOutputs) {
                    var includedCompletedCount = 0;
                    return function () {
                        if (++includedCompletedCount == includedLen) {
                            return completeIncludedInnerHTMLFun(includedHtmlOutputs);
                        }
                    };
                })(completeIncludedInnerHTMLFun, includedLen, includedHtmlOutputs);

                for (var m = 0; m < includedLen; ++m) {
                    var includedItem = includeInNextCell[m];

                    if (!includedItem.visible) {
                        includedCompletedFun();
                        continue;
                    }

                    var innerFunc = (function (includedHtmlOutputs, includedCompletedFun, m) {
                        return function (HTML) {
                            includedHtmlOutputs[m] = HTML;
                            return includedCompletedFun();
                        };
                    })(includedHtmlOutputs, includedCompletedFun, m);

                    if (this.isPrinting) {
                        var printHTML = includedItem.getPrintHTML(self.currentPrintProperties, innerFunc);
                        if (printHTML == null) {
                            wentAsync = true;
                        } else {
                            theHTML = innerFunc(printHTML);
                        }
                    } else {
                        theHTML = innerFunc(includedItem.getInnerHTML(includedItem.getValue()));
                    }
                }

                // drop the old 'includeInNextCell' array for the next item.
                includeInNextCell.length = 0;
            } else {
                theHTML = completeIncludedInnerHTMLFun();
            }

            if (theHTML === false) wentAsync = true;
        }

        if (wentAsync) {
            // indicate that we went asynchronous

            return false;
        } else {
            return theHTML;
        }
    } else {
        return completeInnerHTMLFun();
    }
},

// Any children of the form are likely to be canvasItems' canvii which are written out inline
// via code in CanvasItem.js
getPrintChildren : function () {
    return null;
},

// Method to return any canvasItems' canvases contained by this form.

getCanvasItemCanvii : function () {
    var items = this.items || [],
        canvii = [];
    for (var i = 0; i < items.length; i++) {
        if (items[i].isA("CanvasItem") && isc.isA.Canvas(items[i].canvas)) {
            canvii.add(items[i].canvas);
        }
    }
    return canvii;
},

createErrorItem : function () {
    var errorItem = isc.addProperties({cellStyle:this.errorItemCellStyle},
                                      this.errorItemDefaults,
                                      this.errorItemProperties);

    // Make the errorItem focusable in screen reader mode because then the user can tab to
    // the errorItem to have all error messages read at once.
    if (isc.screenReader) errorItem.canFocus = true;

    this.addItems([errorItem], 0);
    this._errorItem = this.getItem(0);
},

//> @method DynamicForm.getErrorsHTML()
// If +link{dynamicForm.showInlineErrors} is false, the form will render all errors in a list at
// the top of the form. This method returns the HTML for this list of errors.
// @param errors (Object) Map of field names to error messages. Each field may contain a single
//                        error message (string) or an array of errors
// @return (HTMLString) error HTML.
// @group validation
// @visibility external
//<
getErrorsHTML : function (errors) {
    if (!errors || isc.isAn.emptyObject(errors)) return isc.emptyString;

    var SB = isc.SB.create(),
        sep = " : ";
    SB.append(this.errorsPreamble, "<ul>");
    for (var field in errors) {
        var item = this.getItem(field),
            message;
        if (item != null) {
            message = item.getErrorMessage(errors[field]);

            SB.append("<li>", item.getTitle(), sep, message, "</li>");

        // Field with no associated item (ds field?) Just display the error as normal
        } else {
            message = errors[field];
            if (isc.isAn.Array(message)) {
                message = "<ul><li>" + message.join("</li><li>") + "</li></ul>";
            }

            SB.append("<li>", field, sep, message, "</li>");
        }
    }
    SB.append("</ul>");
    return SB.release();
},

//> @method dynamicForm.getItemErrorHTML()
// If +link{dynamicForm.showInlineErrors} is true, this method is called for each item in the form
// and returns the error HTML to be written out next to the item.<br>
// Default implementation falls through to +link{FormItem.getErrorHTML()} on the item in question.
// @param item (FormItem) Form item for which the HTML should be retrieved
// @param error (String | Array) Error message to display for the item, or array of error message
//                              strings.
// @group validation
// @visibility external
//<
getItemErrorHTML : function (item, error) {
    return item.getErrorHTML(error);
},

// Helper to generate the input required for the autoSendTarget feature
_$autoSendTargetTemplate:[
      "<INPUT TYPE=HIDDEN NAME='" ,
      , // target field name
      "' VALUE='" ,
      , // target
      "'>"
],
_getAutoSendTargetHTML : function () {
    this._$autoSendTargetTemplate[1] = this.autoSendTargetFieldName;
    this._$autoSendTargetTemplate[3] = this.target;
    return this._$autoSendTargetTemplate.join(isc.emptyString);
},


//>    @method    dynamicForm.getCellStartHTML()    (A)
//            Return the HTML for start tag of this item's cell.
//        @group    drawing
//
//        @param    item    (FormItem)    item in question
//        @param    error    (String)    error for this item
//
//        @return    (HTMLString)    output for the start tag
//<
getCellStartHTML : function (item, error) {
    // get the colSpan for the item, which might be a "*"
    var colSpan = item.getColSpan(),

        rowSpan = item._rowSpan != null ? item._rowSpan : item.getRowSpan();

    // colSpan / rowSpan of zero is handled by writing the form item out into the next form
    // item's cell.
    // However if the last item in a form has rowSpan / colSpan of zero, we need to put it into its
    // own cell, so we should treat it as having rowSpan / colSpan of 1.
    if (colSpan == 0) colSpan = 1;
    if (rowSpan == 0) rowSpan = 1;

    // if the colSpan is a "*", set it appropriately
    if (colSpan == "*") {
        var startCol = (item._tablePlacement ? item._tablePlacement[0] : 0);
        colSpan = (this.numCols - startCol);
    }

    var className = item.getCellStyle();

    // Use the height calculated by tableResizePolicy rather than the specified size (may be
    // null, "*" or a percentage).

    var forceHeight = this.fixedRowHeights || item.shouldFixRowHeight();
    var height = item._size ? item._size[1] : null;

    if (isc.isA.Number(height) && this.cellSpacing != 0) height -= 2*this.cellSpacing;
    if (isc.Browser.isStrict && isc.isA.Number(height) && this.cellPadding != 0) {
        height -= 2*this.cellPadding;
    }
    return this._getCellStartHTML(
        (item.align ? item.align :
                       ((this.form? this.form.isRTL() : this.isRTL()) ? isc.Canvas.RIGHT : isc.Canvas.LEFT)),
        item.getVAlign(),

        className,
        rowSpan,
        colSpan,

        null,

        (forceHeight ? height : null),

        null,
        item.cssText,
        (this.form ? this.form.getID() : this.getID()),
        item.getItemID(),
        item.getFormCellID(),
        item._cellNoWrap()

    );
},

_getCellStartHTML : function (align, vAlign, className, rowSpan, colSpan, width, height,
                              extraStuff, cssText, formID, itemID, cellID, nowrap)
{
    var output = isc.StringBuffer.create(),
        ns = isc._emptyString;

    output.append(
        "<TD ALIGN=", align,
            (vAlign == null ? ns : " VALIGN=" + vAlign),
            (className != null ? " CLASS='" + className + "'" : ns),
            " STYLE='", (cssText != null ? cssText : ns), "'",

            (rowSpan > 1 ? " ROWSPAN=" + rowSpan: ns),
            (colSpan > 1 ? " COLSPAN=" + colSpan : ns),
            (width != null ? " WIDTH=" + width : ns),
            (height != null ? " HEIGHT=" + height : ns),
            (extraStuff != null ? extraStuff : ns)
    );


    // If this is the containing cell for some item, write in ID and 'containsItem' attribute
    // for the item.
    // This method is used for cells containing things other than the form items, such as icons
    // in which case we'll avoid writing in these attributes.
    if (cellID) {
        output.append(" ID=", cellID, " ");
    }
    if (itemID && formID) {

        output.append(isc.DynamicForm._containsItem, "='",itemID,"'");

    }


    output.append(nowrap ? "><NOBR>" : ">");

    return output.release(false);
},

//>    @method    dynamicForm.getCellEndHTML()    (A)
//        @group    drawing
//            Return the HTML for start tag of this item's cell.
//
//        @param    item    (FormItem)    item in question
//        @param    error    (String)    error for this item
//
//        @return    (HTMLString)    output for the start tag
//<
getCellEndHTML : function (item, error) {

    // otherwise return a simple end of cell
    return  this._getCellEndHTML();
},

_getCellEndHTML : function (nowrap) {
    return nowrap ? "</NOBR></TD>" : "</TD>";
},

//>    @method    dynamicForm.getTitleOrientation()    (A)
// Return the orientation of the title for a specific item or the default title orientation if
// no item is passed.
//
// @param [item] (FormItem) item to check
// @return (TitleOrientation) orientation of the title, or null if an item is passed and has no
//                            title
// @visibility external
//<
getTitleOrientation : function (item) {
    if (item && !item.shouldShowTitle()) return null;
    if (this.linearMode) return this.titleOrientation || isc.Canvas.TOP;
    return (item ? item.titleOrientation : null) || this.titleOrientation || isc.Canvas.LEFT;
},

//> @attr dynamicForm.titleAlign (Alignment : null : IRW)
// Default alignment for item titles. If unset default alignment will be derived from
// +link{Page.isRTL(),text direction} as described in +link{dynamicForm.getTitleAlign()}
// @visibility external
//<

//>    @method    dynamicForm.getTitleAlign()    (A)
// Get the alignment for the title for some item. Default implementation is as follows:
// <ul><li>If +link{formItem.titleAlign} is specified, it will be respected</li>
//     <li>If not, and +link{dynamicForm.titleAlign,this.titleAlign} is set, it will be
//         respected</li>
//     <li>Otherwise titles will be aligned according to +link{Page.isRTL(),text direction};
//         for +link{dynamicForm.titleOrientation,titleOrientation} "top", this
//         method returns <code>"left"</code> if text direction is LTR, and
//         <code>"right"</code> if not; for horizontal orientations, this method returns
//         <code>"right"</code> if text direction is LTR, or <code>"left"</code> if text
//         direction is RTL.</li>
// </ul>
// @param item (FormItem) item for which we're getting title alignment
// @return (Alignment) alignment for title
// @visibility external
//<
getTitleAlign : function (item) {
    var form = this.form || this; // for ContainerItem method-stealing hack
    return (item.titleAlign ? item.titleAlign :
            this.titleAlign ? this.titleAlign :
            // textDirection: set the direction of the titles according to the text direction
            // if not specified - for "top" orientation, RTL - otherwise, opposite to RTL
            this.getTitleOrientation(item) == "top" ?
                this.isRTL() ? isc.Canvas.RIGHT : isc.Canvas.LEFT :
                this.isRTL() ? isc.Canvas.LEFT : isc.Canvas.RIGHT);
},

//> @method dynamicForm.getTitleVAlign()  (A)
// Get the vertical alignment for the title for this item
//<

getTitleVAlign : function (item) {
    var valign = (item.titleVAlign ? item.titleVAlign :
                  this.titleVAlign ? this.titleVAlign :
                  isc.Canvas.CENTER);
    return (valign == isc.Canvas.CENTER ? isc.Canvas.MIDDLE : valign);
},

// reinstate this internal default height
titleHeight:15,

// titleHeight / getTitleHeight
// When calculating the size of items for tableResizePolicy, if the title is written into the
// items cell (for titleAlign:top), we need to take the height of the title into account
// so "*" sized items can take up the appropriate amount of space.

getTitleHeight : function (item) {
    var form = this.form || this; // for ContainerItem method-stealing hack

    // return cached height
    if (item._titleHeight != null) return item._titleHeight;

    // default to item/this.titleHeight
    var titleHeight = (item.titleHeight != null ? item.titleHeight : this.titleHeight);

    var titleStyle = item.getTitleStyle();
    if (titleStyle) {
        // if there's a titleStyle, measure its height to include padding
        var title = item.getTitle();
        var opts = {};
        if (this.getTitleOrientation(item) == "top") {
            // titles above fields - getMaxTitleSpace() returns the item's visible-width
            // by default, but can be overridden to return something else - for example,
            // CheckboxItem uses cell-width, since it's visibleWidth is very narrow
            opts.width = item.getMaxTitleSpace();
        }
        if (item.wrapTitle == false || (item.wrapTitle == null && this.wrapItemTitles == false)) {
                // not wrapping - just use a short string to avoid having to deal with overflow
                title = "M";
        }
        var measuredHeight = isc.Canvas.measureContent(title, titleStyle, true, true, opts);
        titleHeight = Math.max(titleHeight, measuredHeight);
    }

    // cache the measured height
    item._titleHeight = titleHeight;

    return item._titleHeight;
},

//> @method dynamicForm.getTitleSpanHTML() (A)
// Return the HTML for a FormItem's title, wrapping in SPAN rather than a table cell so that it
// doesn't affect the table used for Layout
//
// @group drawing
// @param item (FormItem) Item to show title of.
// @param error (String) error message for this item
// @return (HTMLString) HTML output for this element
//<
getTitleSpanHTML : function (item, error) {
    var output = isc.StringBuffer.create();
    output.append("<SPAN ", this._containsItemTitleAttrHTML(item),
                  " style='display:inline-block;",
                  // propagate wrapTitle to top-oriented titles
                  item.wrapTitle ? "" :
                    (item.wrapTitle == false || this.wrapItemTitles == false
                        ? "white-space:nowrap;" : ""),
                  "'",
                  " CLASS='", item.getTitleStyle(),
                  "' ALIGN=", this.getTitleAlign(item),
                  ">");

    // get the actual title from the item
    output.append(this.getTitleHTML(item, error));

    // now end the title span
    output.append("</SPAN>");
    // and return the whole thing
    return output.release(false);
},

// Should a specific form item's title be clipped?
shouldClipTitle : function (item) {
    if (!item || !item.form == this) return false;
    return (item.clipTitle != null ? item.clipTitle : !!this.clipItemTitles);
},

//>    @method    dynamicForm.getTitleCellHTML()    (A)
//            Output a title cell for a FormItem.
//        @group    drawing
//
//        @param    item        (FormItem)    Item to show title of.
//        @param    error        (String)    error message for this item
//
//        @return    (HTMLString)    HTML output for this element
//<

_$heightColon:"height:", _$widthColon:"width:",_$maxWidthColon:"max-width:",
_$maxHeightColon:"max-height:",_$heightColon:"height:",
_$NOBR:"<NOBR>", _$innerTitleTableClose:"</td></tr></TABLE>", _$divClose:"</DIV>", _$tdClose:"</TD>",

_outerTitleCellTemplate:[
    "<TD ", // 0
    , // 1: this._containsItemTitleAttrHTML(item)
    " CLASS='", // 2
    , // 3: className
    "' ALIGN='", // 4
    , // 5: this.getTitleAlign(item)
    "' VALIGN='", // 6
    , // 7: this.getTitleVAlign(item)
    "'", // 8:
    , // 9: possible rowspan
      // NOTE: based on the titleOrientation, this may want to output colSpan OR rowSpan based
      // on the original item size. For now we just respect rowspan
    , // 10: possible colspan
    ">" // 11
],

// When clipping titles, a div is emitted which wraps the block having text-overflow:ellipsis.
// If emitOuterTextOverflow:true, then text-overflow:ellipsis is also applied to the wrapper
// div.
emitOuterTextOverflow: false,

getTitleCellHTML : function (item, error) {
    var output = isc.StringBuffer.create(),
        className = item.getTitleStyle(),
        titleAlign = this.getTitleAlign(item),
        titleVAlign = this.getTitleVAlign(item);

    if (item.showTitle == false) return "";

    // get the item title cell start
    var cellTemplate = this._outerTitleCellTemplate;
    cellTemplate[1] = this._containsItemTitleAttrHTML(item);
    cellTemplate[3] = className;
    cellTemplate[5] = titleAlign;
    cellTemplate[7] = titleVAlign;


    var rowSpan = item._rowSpan;
    if (rowSpan == null) rowSpan = item.getRowSpan();
    if (rowSpan > 1) cellTemplate[9] = " ROWSPAN=" + rowSpan;

    else cellTemplate[9] = null;
    if (item.getTitleColSpan() > 1) cellTemplate[10] = " COLSPAN=" + item.getTitleColSpan();
    else cellTemplate[10] = null;



    output.append(cellTemplate.join(isc.emptyString));

    // titleCellInnerHTML is cached - pass the 3rd param, includeClassName, so the HTML
    // includes the title-style, which may differ for each FormItem and may be either
    // titleStyle or verticalTitleStyle, depending on titleOrientation - includeClassName just
    // causes getTitleCellInnerHTML() to clobber the style-name in the cached HTML-array for
    // each formItem
    output.append(this.getTitleCellInnerHTML(item, error, true));

    // now end the title cell
    output.append(this._$tdClose);

    // and return the whole thing
    return output.release(false);
},

_$top: "top",

// Content of the title cell
getTitleCellInnerHTML : function (item, error, includeClassName) {
    // Use the width / height calculated by TableResizePolicy rather than the specified
    // height / titleWidth properties.
    // Note that this is the total available space for the cell rather than the inner
    // space, so we need to adjust for styling.

    var output = isc.StringBuffer.create(),
        className = item.getTitleStyle(),
        titleAlign = this.getTitleAlign(item),
        titleOrientation = this.getTitleOrientation(item),
        titleWidth = item._titleWidth || null,
        height = item._size ? item._size[1] : null,
        clipTitle = this.shouldClipTitle(item),
        // Unless explicitly specified, wrap unclipped titles, but don't wrap clipped titles
        wrapTitle = (item.wrapTitle != null ? item.wrapTitle :
                    (this.wrapItemTitles != null ? this.wrapItemTitles : !clipTitle));



    // Adjust titleWidth/height for padding applied by this.cellPadding this.cellSpacing, &
    // the title class name
    if (height) {
        if (this.cellSpacing) height -= 2*this.cellSpacing;

        var tPadding, bPadding;
        if (className) {
            tPadding = isc.Element._getTopPadding(className, true);
            bPadding = isc.Element._getBottomPadding(className, true);
        }
        if (tPadding == null) tPadding = this.cellPadding || 0;
        if (bPadding == null) bPadding = this.cellPadding || 0;

        height -= (tPadding + bPadding)

        if (className) height -= isc.Element._getVBorderSize(className);
    }

    if (titleWidth) {
        if (this.cellSpacing) titleWidth -= 2*this.cellSpacing;
        var lPadding, rPadding;
        if (className) {
            lPadding = isc.Element._getLeftPadding(className, true);
            rPadding = isc.Element._getRightPadding(className, true);
        }
        if (lPadding == null) lPadding = this.cellPadding || 0;
        if (rPadding == null) rPadding = this.cellPadding || 0;

        titleWidth -= (lPadding + rPadding)
        titleWidth -= isc.Element._getHBorderSize(className);
    }

    var heightProperty = isc.Browser.isMoz ? this._$maxHeightColon : this._$heightColon,
        widthProperty = isc.Browser.isMoz ? this._$maxWidthColon : this._$widthColon;

    if (clipTitle) {
        if (this._titleClipDivTemplate == null) {
            this._titleClipDivTemplate = [

                "<DIV style='overflow:hidden;display:flex;", // 0
                "white-space:nowrap;",          // 1
                ,                               // 2: possible width
                "' ",                           // 3
                isc.DynamicForm._itemPart,      // 4
                "='",                           // 5
                isc.DynamicForm._title,         // 6
                "' ",                           // 7
                isc.DynamicForm._containsItem,  // 8
                "='",                           // 9
                ,                               // 10: item ID
                , (includeClassName ? "' class='" + className : null) // 11: possible className
                ,"'>"                            // 12
            ];
            if (this.emitOuterTextOverflow) {
                this._titleClipDivTemplate[0] += isc.Browser._textOverflowPropertyName + ":ellipsis;";
            }
        } else {
            if (includeClassName) {
                this._titleClipDivTemplate[11] = "' class='" + className;
            } else {
                this._titleClipDivTemplate[11] = null;
            }
        }

        var divTemplate = this._titleClipDivTemplate;

        if (titleWidth != null) divTemplate[2] = widthProperty + titleWidth + "px;";
        else divTemplate[2] = null;

        divTemplate[10] = item.getID();

        output.append(divTemplate.join(isc.emptyString));

    // use NOBR to suppress wrapping. (white-space:nowrap inside a TD works in Moz but not IE)
    } else if (!wrapTitle) {
        output.append(this._$NOBR);
    }
    // get the actual title from the item
    output.append(this.getTitleHTML(item, error, clipTitle));

    if (clipTitle) {
        output.append(this._$divClose);
    }

    // and return the whole thing
    return output.release(false);
},

// Helper method for item title cell identifiers

_containsItemTitleAttrHTML : function (item) {
    if (!isc.DynamicForm._itemTitleAttrHTML) {
        isc.DynamicForm._itemTitleElementAttrHTML =  [
            " ", isc.DynamicForm._containsItem, "='",
            null,   // item ID
            "' ",
            isc.DynamicForm._itemPart, "='", isc.DynamicForm._title, "' ",
            // Also apply a unique ID so we can grab a pointer to the cell for re-styling
            // without redrawing the form as a whole.
            "ID='",
            , // title cell ID
            "'"
        ];
    }
    isc.DynamicForm._itemTitleElementAttrHTML[3] = item.getItemID();
    // [Item ID is unique]
    isc.DynamicForm._itemTitleElementAttrHTML[10] = this._getTitleCellID(item);
    return isc.DynamicForm._itemTitleElementAttrHTML.join(isc.emptyString);
},

_$titleCell:"_titleCell",
_getTitleCellID : function (item) {
    return this._getDOMID(item.getID() + this._$titleCell);
},

getTitleCell : function (item) {
    if (!this.isDrawn()) return null;
    // Ensure we normalize name etc to an item object.
    item = this.getItem(item);
    if (!item) return null;
    return isc.Element.get(this._getTitleCellID(item));
},

// We support custom state-based styles for item titles.
// This method will apply the current style for the title item's title cell
updateTitleCellState : function (item) {
    var titleCell = this.getTitleCell(item);
    if (titleCell == null) return;
    item = this.getItem(item);

    // Apply the style to the cell, and also redraw the content of the cell.
    // This will handle things like:
    // - applying updated style to inner (clipping) table if necessary
    // - applying / clearing required title prefix / suffix
    // - picking up any custom state-based HTML returned by getTitleHTML()
    titleCell.className = item.getTitleStyle();
    titleCell.innerHTML = this.getTitleCellInnerHTML(item, item.getErrors());
},


_$titleClipper:"_titleClipper",
_getTitleClipperID : function (item) {
    return this._getDOMID(item.getID() + this._$titleClipper);
},

_getTitleClipper : function (item) {
    if (!this.isDrawn()) return null;
    item = this.getItem(item);
    if (!item) return null;
    return isc.Element.get(this._getTitleClipperID(item));
},

//> @method dynamicForm.titleClipped()
// Is the title for the given form item clipped? The form item must have title clipping enabled.
//
// @param item (FormItem) the form item.
// @return (boolean) true if the title is clipped; false otherwise.
// @see attr:dynamicForm.clipItemTitles
// @see attr:formItem.clipTitle
// @visibility external
//<
titleClipped : function (item) {
    var titleClipper = this._getTitleClipper(item);
    return (titleClipper != null &&
            isc.Element.getClientWidth(titleClipper) < titleClipper.scrollWidth);
},



_titleClipperTemplate: [
    "<div style='" + ((isc.Browser.isIE && isc.Browser.version < 11) ? "float:right;" : "order:2;")
         + "'>",               // 0
    ,                                          // 1: extracted HTML tag starts from title prefix
    ,                                          // 2: title suffix
    "</div><div id='",                         // 3
    ,                                          // 4: "titleClipper" DOM ID
    "' style='overflow:hidden;",               // 5
    isc.Browser._textOverflowPropertyName,     // 6
    ":ellipsis",                               // 7
    (isc.Browser.isIE && !isc.Browser.isStrict ? ";width:100%" : ""), // 8
    "'>",                                      // 9 (note that white-space:nowrap is inherited)
    ,                                          // 10: title prefix
    ,                                          // 11: title HTML
    ,                                          // 12: extracted HTML tag ends from title suffix
    "</div>"                                   // 13
],

//>    @method    dynamicForm.getTitleHTML()    (A)
//    Output the HTML for a title for a FormItem.
//        @group    drawing
//
//        @param    item        (FormItem)    Item to show title of.
//        @param    error        (String)    error message for this item
//
//        @return    (HTMLString)    HTML output for this element
//<
getTitleHTML : function (item, error, clipTitle) {

    var output = isc.StringBuffer.create();

    // get the title to display

    var title = item.visible ? item.getTitleHTML() : null;
    if (title) {
        var required = this.isRequired(item, true),
            orientation = this.getTitleOrientation(item),
            leftPrefix = (orientation == isc.Canvas.LEFT || orientation == isc.Canvas.TOP);

        if (clipTitle) {
            var clipperTemplate = this._titleClipperTemplate;

            var prefix,suffix;
            if (required && this.hiliteRequiredFields) {
                prefix = leftPrefix ? this.requiredTitlePrefix : this.requiredRightTitlePrefix;
                suffix = leftPrefix ? this.requiredTitleSuffix : this.requiredRightTitleSuffix;
            } else {
                prefix = leftPrefix ? this.titlePrefix : this.rightTitlePrefix;
                suffix = leftPrefix ? this.titleSuffix : this.rightTitleSuffix;
            }





            // Extract any HTML tags we're opening in the prefix and closing in the suffix
            // Returns a 2-element array containing the isolated opening and closing tags
            var unequalTags = this._resolveUnequalHTMLTags(prefix, suffix);

            // Write out the suffix (plus any unclosed HTML start-tags extracted from the prefix)
            clipperTemplate[1] = unequalTags[0];
            clipperTemplate[2] = suffix;

            // write ID into clipper element
            clipperTemplate[4] = this._getTitleClipperID(item);

            // Write the prefix, then the title, then for any unclosed HTML tags,
            // inject the closing tags (extracted from the suffix)

            clipperTemplate[10] = prefix;
            clipperTemplate[11] = title;
            clipperTemplate[12] = unequalTags[1];
            output.append.apply(output, clipperTemplate);
        } else {
            // if the title is defined, output the titlePrefix + title + titleSuffix
            output.append(
                (required && this.hiliteRequiredFields ?
                    (leftPrefix ? this.requiredTitlePrefix : this.requiredRightTitlePrefix) :
                    (leftPrefix ? this.titlePrefix : this.rightTitlePrefix))
                , title
                , (required && this.hiliteRequiredFields ?
                    (leftPrefix ? this.requiredTitleSuffix : this.requiredRightTitleSuffix) :
                    (leftPrefix ? this.titleSuffix : this.rightTitleSuffix))
            );
        }
    } else {
        // otherwise just output a space
        //    this prevents us from putting colons next to an empty title item
        output.append("&nbsp;");
    }

    // and return the whole thing
    return output.release(false);
},

// Given a title prefix and suffix, extract any HTML tags being opened in the prefix and
// closed in the suffix

_resolveUnequalHTMLTags : function (prefix, suffix) {

    // For performance, use cacheing rather than extracting HTML tags from prefix/suffix
    // every time this method is run!
    if (isc.DynamicForm._unequalTagsInPrefixCache != null) {
        var cachedObject = isc.DynamicForm._unequalTagsInPrefixCache.find("prefix", prefix);
        if (cachedObject && cachedObject.suffix == suffix) {
            return cachedObject.unequalTags;
        }
    }

    // Start by looking for any html end tags in the suffix that don't have a corresponding
    // start tag (in the suffix)

    var openingTagRegex = new RegExp("<\\w.*?>", "g"),
        openingTagsInSuffix = suffix.match(openingTagRegex),
        closingTagRegex = new RegExp("</.*?>", "g"),
        closingTagsInSuffix = suffix.match(closingTagRegex),
        unequalTagNames = {},
        unequalClosingTags = [];

    if (closingTagsInSuffix) {
        for (var i = 0; i < closingTagsInSuffix.length; i++) {
            var closingTag = closingTagsInSuffix[i],
                tagName = closingTag.match("\\w+")[0];

            var foundMatch = false;
            if (openingTagsInSuffix) {
                for (var ii = 0; ii < openingTagsInSuffix.length; ii++) {
                    var openingTag = openingTagsInSuffix[ii];
                    if (openingTag == null) continue;

                    if (openingTag.substring(1,(tagName.length+1)).toLowerCase() == tagName.toLowerCase()) {
                        foundMatch = true;
                        openingTagsInSuffix[ii] = null;
                    }
                }
            }

            // If we didn't find an opening tag in the suffix, it is presumably in the prefix
            // Remember these unmatched closing tags in an array
            if (!foundMatch) {
                // remembering the tag-name simplifies code below to look up the opening tag
                // in the prefix string.
                // Edge case note: It's possible there will be more than one tag of the same type
                // for example
                // prefix : <span className="foo"><span style='font-weight:bold;'>
                // suffix : &nbsp:</span></span>
                // In this case we do need to grab both opening tags (and both closing tags)
                unequalTagNames[tagName.toLowerCase()] = true;
                unequalClosingTags.add(closingTag);

            }
        }
    }

    // At this stage we've got all closing tags in the suffix which don't have a corresponding
    // opening tag.
    // We can assume these are opened in the prefix. Grab that chunk of HTML so we can
    // prepend it to the suffix HTML in its separate element
    var unequalOpeningTags = [];
    for (var tagName in unequalTagNames) {
        // I need to extract any opening tags for the unequal closing tags
        // which don't already have a corresponding closing tag!

        var closingTagIndex = prefix.toLowerCase().lastIndexOf("</" + tagName),
            prefixSubstring = closingTagIndex > 0 ? prefix.substring(closingTagIndex) : prefix;

        // note that this is a global match, and we may legitimately have more than one
        // unmatched opening tag for the tagName in question.
        var openingTagRegex = new RegExp("<" + tagName + ".*?>", "gi");
        var matchingOpeningTags = prefixSubstring.match(openingTagRegex);

        // As noted above, we may legitimately find more than one opening tag of the same
        // type
        if (matchingOpeningTags != null) {
            unequalOpeningTags.addList(matchingOpeningTags);
        } else {
            // If we couldn't find an orphaned opening tag, ignore the orphaned closing
            // tag we detected - this likely implies some incorrect HTML structure in the
            // prefix/suffix pair
            unequalClosingTags[i] = null;
        }
    }
    unequalClosingTags.removeEmpty();

    var result;

    if (unequalClosingTags.length == 0 ||
        (unequalClosingTags.length != unequalOpeningTags.length))
    {
        result = [null,null]
    } else {
        result = [unequalOpeningTags.join(""), unequalClosingTags.join("")];
    }
    // Cache the result
    if (isc.DynamicForm._unequalTagsInPrefixCache == null) {
        isc.DynamicForm._unequalTagsInPrefixCache = [];
    }
    isc.DynamicForm._unequalTagsInPrefixCache.add({
        prefix:prefix,
        suffix:suffix,
        unequalTags:result
    });

    return result;
},


//>    @method    dynamicForm.getFormTagStartHTML()    (A)
//        @group    drawing
//            Return the HTML to start the form object itself.
//        @return    (String)                HTML for the start form tag
//<
_$formTagStartTemplate:[
    "<FORM " ,                              // 0
    "ID",                                   // 1
    "=" ,                                   // 2
    ,                                       // 3: this.getFormID()
    ,                                       // 4: absolute positioning, or null
    " METHOD=",                             // 5
    ,                                       // 6: this.method
    " ACTION='",                            // 7
    ,                                       // 8: this.action
    "' ENCTYPE=",                           // 9
    ,                                       // 10: multipart or normal encoding
    ,                                       // 11: Target= or null
    ,                                       // 12: target or null
    ,                                       // 13: close target quote or null

    " ONSUBMIT='return ",                   // 14
    ,                                       // 15: this.getID()
    "._handleNativeSubmit()' ONRESET='",    // 16
    ,                                       // 17: this.getID()

    // Do our proprietary reset rather than a real native reset.
    // There's no benefit to doing a native reset here, and it breaks certain items such
    // as date items.

    ".resetValues(); return false;'",       // 18


    " STYLE='margin-bottom:0px'",   // 19
    // This is required to send i18n data to server (which assumes UTF-8 encoding)
    " ACCEPT-CHARSET='UTF-8'", //20
    ">"           // 21
],
_$absPosStyle:" STYLE='position:absolute;left:0px;top:0px;'",
_$targetEquals:" TARGET='",
getFormTagStartHTML : function () {
    var template = this._$formTagStartTemplate,
        FormID = this.getFormID(),
        ID = this.getID();
    template[3] = FormID;
    // In order to get an absPos item placed at 0,0 in Moz (but not IE), it's necessary
    // to absolutely position the <FORM> element, or Moz generates an extra line box
    // with this simple structure.  (change font size to verify the extra space is due
    // to a line box)
    // <DIV STYLE='position:absolute;LEFT:0px;TOP:0px;WIDTH:500px;HEIGHT:500px;'
    // ><div style="position:relative;"><form><div
    // style="position: absolute; left: 0px; top: 0px;">foobar</div></form></div>
    if (this._absPos()) template[4] = this._$absPosStyle;
    else template[4] = null;

    template[6] = this.method;
    template[8] = this.action;

    if (this.isMultipart()) template[10] = isc.DynamicForm.MULTIPART_ENCODING;
    else template[10] = isc.DynamicForm.NORMAL_ENCODING;

    if (this.target != null) {
        template[11] = this._$targetEquals;
        template[12] = this.target;
        template[13] = this._$singleQuote;
    } else {
        template[11] = null;
        template[12] = null;
        template[13] = null;
    }


    template[15] = ID;
    template[17] = ID;

    return template.join(isc.emptyString);
},



writeWidthAttribute: false,
_writeWidthAttribute : function () {
    return this.writeWidthAttribute;
},

//>    @method    dynamicForm.getTableStartHTML()    (A)
//        @group    drawing
//            Return the HTML to start the table drawn around this form.
//        @return    (String)                HTML for the start table tag
//<
_$tableStartTemplate:[
    "<TABLE role='presentation' ID='",          // 0
    ,                       // 1:  this._getTableElementID()


    "' WIDTH='",            // 2
    ,                       // 3: innerContentWidth / innerWidth
    "' CELLSPACING='" ,     // 4
    ,                       // 5: this.cellSpacing
    "' CELLPADDING='" ,     // 6
    ,                       // 7: this.cellPadding
    "' BORDER='",           // 8
    ,                       // 9: this.cellBorder


    (isc.Browser.isMoz ? "'><TBODY>" : "'>") // 10
],
_$widthEquals: "' WIDTH='",
getTableStartHTML : function () {
    // This method is also applied to containerItems
    var isForm = isc.isA.DynamicForm(this),
        template = isForm ? this._$tableStartTemplate
                          : isc.DynamicForm.getPrototype()._$tableStartTemplate;
    template[1] = this._getTableElementID();
    if (this.isPrinting) {
        template[2] = isForm ? this._$widthEquals : isc.DynamicForm.getPrototype()._$widthEquals;
        template[3] = "100%";
    } else if (!!this._writeWidthAttribute()) {
        template[2] = isForm ? this._$widthEquals : isc.DynamicForm.getPrototype()._$widthEquals;
        template[3] = (this.getInnerContentWidth != null
                       ? this.getInnerContentWidth()
                       : this.getInnerWidth());
    } else {
        template[3] = template[2] = null;
    }
    template[5] = this.cellSpacing;
    template[7] = this.cellPadding;
    template[9] = this.cellBorder;

    return template.join(isc.emptyString);
},

// Methods to access the table element for this form
_$table:"table",
_getTableElementID : function () {
    return this._getDOMID(this._$table);
},

_getTableElement : function () {
    return isc.Element.get(this._getTableElementID());
},


// Resizing:
// If we're showing any items who's sizes depend on the specified form size,
// redraw on resize to force them to be recalculated and redrawn
layoutChildren : function (a,b,c,d) {
    this.invokeSuper(isc.DynamicForm, "layoutChildren", a,b,c,d);
    var items = this.getItems();
    if (!items) return;
    for (var i = 0; i< items.length; i++) {
        // redraw for any percent sized / "*" width child
        var width = items[i].width, height = items[i].height;
        if (
            (isc.isA.String(width) && (width.contains("%") || width.contains("*"))) ||
             (isc.isA.String(height) && (height.contains("%") || height.contains("*"))) )
        {

            this.markForRedraw("size change with dynamic size children");
            break;
        }
    }
},

getAbsPosHTML : function () {
    var output = isc.SB.create();
    // for each item in the list, get HTML output for it and combine the output
    for (var itemNum = 0, len = this.items.length; itemNum < len; itemNum++) {

        // get a pointer to the item for that field
        var item = this.items[itemNum];
        // if a null item, skip it
        if (!item) continue;
        // note that the value of this item can't possibly be dirty anymore
        item._markValueAsNotDirty();

        // if the item has been marked as invisible, skip it
        if (!item.visible) continue;


        var includeHint = !item._getShowHintInField(),
            includeErrors = this.showInlineErrors
        ;
        output.append(item.getStandaloneItemHTML(item.getValue(), includeHint, includeErrors));
    }

    //this.logWarn("absPos HTML: " + output.toString());

    // Allow the SB to be reused
    return output.release(false);
},



getScrollWidth : function (recalculate) {
    if (this._deferredOverflow) {
        this._deferredOverflow = null;
        this.adjustOverflow("widthCheckWhileDeferred");
    }
    // re-implement caching code
    // Note: important to use the same cache field name because __adjustOverflow() invalidates it.
    if (!recalculate && this._scrollWidth != null) return this._scrollWidth;

    var width;
    // call super the fast way if we don't have absolutely positioned items
    if (!isc.Browser.isIE || !this._absPos() ||
        !(this.isDrawn() || this.handleDrawn()) || this.items == null)
    {
        width = isc.Canvas._instancePrototype.getScrollWidth.call(this, recalculate);
    } else {
        width = 0;
        for (var i = 0; i < this.items.length; i++) {
            var item = this.items[i];
            if (item.visible == false || !item.isDrawn()) continue;

            var handle = item.getAbsDiv();
            if (handle) {
                var itemRight = handle.scrollWidth + item._getPercentCoord(item.left);
                if (itemRight > width) width = itemRight;
            }
        }
    }
    this._scrollWidth = width;
    return width;
},

getScrollHeight : function (recalculate) {
    if (this._deferredOverflow) {
        this._deferredOverflow = null;
        this.adjustOverflow("heightCheckWhileDeferred");
    }
    // re-implement caching code
    // Note: important to use the same cache field name because __adjustOverflow() invalidates it.
    if (!recalculate && this._scrollHeight != null) return this._scrollHeight;

    var height;
    // call super the fast way if we don't have absolutely positioned items
    if (!isc.Browser.isIE || !this._absPos() ||
        !(this.isDrawn() || this.handleDrawn()) || this.items == null)
    {
        height = isc.Canvas._instancePrototype.getScrollHeight.call(this, recalculate);
    } else {
        height = 0;
        for (var i = 0; i < this.items.length; i++) {
            var item = this.items[i];
            if (item.visible == false || !item.isDrawn()) continue;

            var handle = item.getAbsDiv();
            if (handle) {
                var itemBottom = handle.scrollHeight + item._getPercentCoord(item.top, true);
                if (itemBottom > height) height = itemBottom;
            }
        }
    }
    this._scrollHeight = height;
    return height;

},

// Submitting
// --------------------------------------------------------------------------------------------

// _formWillSubmit() - will this form perform a direct submission
// If true we need to ensure we write out native elements for each form item
// (using hidden elements if necessary)
// Note that we need to consider 2 kinds of direct submission:
// - if this.canSubmit is true, and the user hits a submit button (or 'submit()'/ 'submitForm()'
//   are called, we're performing a completely standard HTML direct submission to the
//   action URL specified by the developer
// - We also in some cases use direct submission to convey RPC operations.
//   Cases where this occurs when saveData() is called:
//      - this.canSubmit is true
//      - this.action has been specified (differs from the class prototype value)
//      - isMultipart() is true
// In each of these cases return true to indicate a direct submission will occur
_formWillSubmit : function () {
    return this.canSubmit || this.isMultipart() ||
            (this.action != isc.DynamicForm.getPrototype().action);
},

//>    @method    dynamicForm.submitForm()    ([])
// Submits the form to the URL defined by +link{dynamicForm.action},
// identically to how a plain HTML &lt;form&gt; element would submit data,
// as either an HTTP GET or POST as specified by +link{dynamicForm.method}.
// <P>
// <b>Notes:</b>
// <ul>
// <li>this is used only in the very rare case that a form is used to submit data
// directly to a URL.  Normal server contact is through
// +link{group:dataBoundComponentMethods,DataBound Component Methods}.</li>
// <li>For this method to reliably include values for every field in the grid,
//      +link{DynamicForm.canSubmit} must be set to <code>true</code></li>
// <li>To submit values for fields that do not have an editor, use +link{HiddenItem}
// with a +link{formItem.defaultValue} set.  This is analogous to &lt;input type="hidden"&gt;
// in HTML forms.
// </ul>
//      @visibility external
//        @group    submitting
//<
submitForm : function () {
    if (!this._formWillSubmit()) {
        this.logWarn("Attempt to perform direct submission on DynamicForm where this.canSubmit " +
                     "is false. Please set this property to true, or use the standard databinding " +
                     "interfaces to send data to the server.");
    }

    // If we have a FileItem as an item in this form warn that we won't save its value and ignore
    // it. This is appropriate since FileItemForms are intended to be used with a SC Server backed
    // dataSource only and go through the saveData() codepath. We can't apply our values to the
    // FileItemForm and submit it directly since it doesn't have html form items for our various
    // values so will fail to commit them to the server.
    if (this.getFileItemForm() != null) {
        this.logWarn("Performing a direct submission on a DynamicForm containing a FileItem. " +
                    "Note: This item's value will not be submitted to the server.  FileItems " +
                    "are intended for use with databound forms backed by the SmartClient server " +
                    "only.  If you are not using the SmartClient Databinding subsystem, " +
                    "use an UploadItem rather than a FileItem to submit a file as part of a raw " +
                    "HTTP request. Otherwise use saveData() rather than a direct call to " +
                    "submitForm() to save the full set of values for the form.");
    }
    var items = this.getItems() || [],
        uploadItems = [];
    for (var i = 0; i < items.length; i++) {
        if (isc.isA.UploadItem(items[i])) {
            uploadItems.add(items[i]);
        }
    }
    if (this.checkFileAccessOnSubmit && uploadItems.length > 0) {
        this._verifyFileAccessAndSubmit(uploadItems);
    } else {
        this.submitNativeForm();
    }
},

//> @attr dynamicForm.checkFileAccessOnSubmit (boolean : true : IRWA)
// For dynamicForms containing a +link{FileItem} for uploading files,
// should the browser verify that the file is accessible before submitting
// the uploaded file to the server?
// <P>
// In some cases the browser may not be able to access the selected file.<br>
// This can occur when the file has been modified in the file system after selection in the
// browser, or if the current user doesn't have permission to view the file.
// <P>
// By default, before submitting the file to the server
// the browser will verify that it can access the file's contents and display
// the +link{fileAccessFailedWarning} if file access fails.<br>
// Note that accessing the file's contents is an asynchronous process, so
// form submission is not performed synchronously.
// <P>
// This means that if application code calls +link{saveData()} on a form containing a
// fileItem and then synchronously +link{canvas.clear(),clears} it from the DOM, the upload will
// never be kicked off.<br>
// Setting <code>checkFileAccessOnSubmit</code> to false will suppress the (asynchronous) check,
// and can be used to bypass this limitation, but this is not recommended except as a short term
// backwards-compatibility workaround. Instead we'd recommend using the +link{saveData(),saveData callback}
// to clear the form when the upload has completed. This also gives the user an opportunity to correct
// validation errors and re-submit the form if necessary.
//
// @visibility external
//<
checkFileAccessOnSubmit:true,

_verifyFileAccessAndSubmit : function (items) {
    this._verifyingFileAccess = true;
    var item = items.pop(),
        _this = this;
    item.checkFileAccess(
        function verifyFileAccessCallback (result) {
            if (_this._abortNativeSubmit) {
                delete _this._abortNativeSubmit;
                return;
            }

            // Note result of "null" just indicates there was no selected file - not a failure
            if (result === false) {
                _this.handleFileAccessError(item);
            } else {
                if (items.length > 0) _this._verifyFileAccessAndSubmit(items);
                else {
                    delete _this._verifyingFileAccess;
                    _this.submitNativeForm();
                }
            }
        }
    );
},

submitNativeForm : function () {

    var form = this.getForm();
    if (!form) {
        this.logWarn("Unable to access native form for submission. Verify that this form has been drawn and has not been cleared.");
        // Clear up the RPC prompt / wait cursor if necessary
        this._cleanUpFailedRPCTransaction();
        return;
    }

    // Update the action lazily if necessary - required for the case where it has been modified
    // after draw

    if (form.action != this.action) form.action = this.action;

    // In IE, having a partially populated uploadItem on a form, and then attempting to submit
    // the form via a call to form.submit() throws an Access Denied JS error
    // http://support.microsoft.com/kb/892442
    // Trap this case and log a warning

    try {
        return form.submit();
    } catch (e) {
        this.logWarn("Form submission was unsuccessful. In some browsers this can occur when " +
            "an upload item is present and has an invalid value.\n" + e.message);
        // We could fire a generic 'submission failed' handler here.
        // Developers can override this to warn the user in a way that makes sense for their
        // application.
        this.formSubmitFailed();
    }
},

// when implicitSave is true, this method is called by changed formItems at editorExit(), or
// after a pause in editing specified by implicitSaveDelay
performImplicitSave : function (item, onPause) {
    this.implicitSaveInProgress = true;

    if (item) {
        if (item._shouldUpdateParentItem) {
            item.parentItem.updateValue();
        }
        if (item._fireOnPauseTimer != null) isc.Timer.clear(item._fireOnPauseTimer);
    }

    if (this.awaitingImplicitSave) delete this.awaitingImplicitSave;
    this.logInfo("performImplicitSave called " +
        (!onPause ? "by editorExit()" : "after implicitSaveDelay (" + this.implicitSaveDelay + "ms)") +
        " for item " + item.name + ".");

    var _this = this;

    if (this.valuesManager) {
        // we have a valuesManager - since this is an implicitSave, we want a proper save to occur,
        // so trigger the VM to save, which causes it to gather changed values from all members,
        // including this one.
        this.valuesManager.saveData(function (dsResponse, data) {
            _this._implicitSaveCallback(data); }, {showPrompt: false});
    } else {
        this.saveData(function (dsResponse, data) {
            _this._implicitSaveCallback(data); }, {showPrompt: false});
    }
},

_addItemToImplicitSaveUpdateArray : function (item) {
    var storage = this.valuesManager ? this.valuesManager : this;
    if (!storage.itemsToUpdateState) storage.itemsToUpdateState = [];
    item.awaitingImplicitSave = true;
    storage.itemsToUpdateState.add(item);
    item.updateState();
},

_implicitSaveCallback : function (data) {
    delete this.implicitSaveInProgress;
    var storage = this.valuesManager ? this.valuesManager : this;
    if (storage.itemsToUpdateState) {
        for (var i=0; i< storage.itemsToUpdateState.length; i++) {
            var item = storage.itemsToUpdateState[i];
            delete item.awaitingImplicitSave;
            item.wasAwaitingImplicitSave = true;
            item.updateState();
        }
        delete storage.itemsToUpdateState;
    }
    this.implicitSaveCallback(data);
},



// default empty implementation in case devs switch implicitSave on without providing an override of this
implicitSaveCallback : function (data) {},

//> @attr DynamicForm.formSubmitFailedWarning (String : "Form was unable to be submitted. The most likely cause for this is an invalid value in an upload field." : IRWA)
// Warning to display to the user if an attempt to +link{dynamicForm.submitForm,natively submit} a
// form is unable to submit to the server. The most common cause for this failure is that the user
// has typed an invalid file-path into an upload type field.
// @visibility external
// @group i18nMessages
// @deprecated see +link{formSubmitFailed}
//<
formSubmitFailedWarning:"Form was unable to be submitted. The most likely cause for this is an " +
                        "invalid value in an upload field.",

//> @attr DynamicForm.fileAccessFailedWarning (String : "Unable to access the selected file(s) for upload. Please re-select the file and try again." : IRW)
// Warning to display to the user if a selected file in an UploadItem cannot be accessed.
// This will be displayed on form submission when the browser is unable to access the
// selected file for upload.
// <P>
// Typically this indicates a browser-level security restriction - for example the file has been edited
// on the disk, or had its permissions changed after the user selected it, but before they
// attempted to submit the form.
// <P>
// When this occurs the selected file will be cleared from the upload item and this message will be
// displayed to the user in a +link{isc.warn(),warn dialog}.
// @group i18nMessages
// @visibility external
//<
fileAccessFailedWarning:"Unable to access the selected file for upload. Please re-select the file and try again.",
handleFileAccessError : function (item) {
    if (item != null) {
        item.clearValue();
        isc.warn(this.fileAccessFailedWarning.evalDynamicString(this, {form:this, item:item}));
    }
    this._cleanUpFailedRPCTransaction();
},


//> @method DynamicForm.formSubmitFailed() [A]
// Method called when an attempt to +link{dynamicForm.submitForm,natively submit} a
// form is unable to submit to the server. Default behavior is to display the
// +link{formSubmitFailedWarning} in a warning dialog.
// The most common cause for this failure is that the user
// has typed an invalid file-path into an upload type field.
// <P>
// <b>Note:</b> This is very unlikely to occur with modern versions of IE, which don't allow the
// path of a file to be edited by hand (only selected via file navigation).  It was last seen
// in IE6-7 under Windows XP.
// <P>
// Rather than throwing an exception on the client during submit(),
// normally all failures in native form submission are handled by the server.  For further
// information, see +link{group:upload,File Uploading}.
// @visibility external
// @group i18nMessages
// @deprecated only known to be called in IE6-7, not supported by SmartClient 12+
//<
// Also cleans up pending RPCManager transactions if this form was doing a submit type transaction
formSubmitFailed : function () {
    isc.warn(this.formSubmitFailedWarning);
    this._cleanUpFailedRPCTransaction();
},
_cleanUpFailedRPCTransaction : function () {
    // go a step further - if this was an attempt to commit an RPCManager transaction
    // we can cancel it so we don't hang with a prompt, or pop a timeout warning in a minute or 2
    var transactionText = this.getValues()._transaction;
    if (transactionText != null && isc.RPCManager && isc.XMLTools) {
        var doc = isc.XMLTools.parseXML(this.getValues()._transaction),
            transactionNum;
        if (doc) transactionNum = isc.XMLTools.selectNumber(doc, "//transactionNum");
        if (transactionNum != null) {

            isc.RPCManager.doClearPrompt(transactionNum);
            isc.RPCManager.clearTransaction(transactionNum);
        }

        var transactionItem = this.getItem("_transaction");
        if (transactionItem && isc.isA.HiddenItem(transactionItem)) {
            this.clearValue("_transaction");
        }
    }
},

//> @method DynamicForm.setAction()
// Sets the +link{DynamicForm.action,action} for this form.
// @param action (URL) New action URL
// @visibility external
//<
// @param autoGenerated (boolean) Was this action auto-generated by the SmartClient databinding
// system or explicitly specified by a developer?

setAction : function (action, autoGenerated) {
    this.action = action;
    var form = this.getForm();
    if (form) form.action = action;
    this._explicitAction = !autoGenerated;
},

//> @method DynamicForm.setTarget()
// Sets the +link{DynamicForm.target,target} for this form.
// @param target (String) New submission target
// @visibility external
//<
setTarget : function (target) {
    this.target = target;
    var form = this.getForm();
    if (form) form.target = target;
},


//> @method DynamicForm.setMethod()
// Sets the +link{DynamicForm.method,method} for this form.
// @param method (FormMethod) html form submission method (get or post)
// @visibility external
//<
setMethod : function (method) {
    this.method = method;
    var form = this.getForm();
    if (form) form.method = method;
},


// If we have a FileItem in this form, this helper method will return a pointer to its form
getFileItemForm : function () {
    if (!isc.FileItem) return null;
    var items = this.getItems() || [];
    var seenFileItem = false,
        fileItemCanvas = null;
    for (var i = 0; i < items.length; i++) {
        if (isc.isA.FileItem(items[i])) {

            // If we encounter multiple file items on a form, log a warning (once)
            if (seenFileItem) {
                this._multiFileItemWarningShown = true;
                this.logWarn("This DynamicForm contains more than one item of type FileItem. " +
                    "This is not supported - a DynamicForm can only support a single FileItem.");
                continue;
            }

            var canvas = items[i].canvas;

            // Make sure that the FileItem's canvas is a DynamicForm before returning it because
            // there are cases where the canvas is not a form (for example, if the FileItem is
            // read-only).
            if (isc.isA.DynamicForm(canvas)) {
                seenFileItem = true;

                fileItemCanvas = canvas;
                // If we've already shown the multi-fileItem warning, no need to look
                // at other items and potentially warn again.
                if (this._multiFileItemWarningShown) break;
            }
        }
    }
    return fileItemCanvas;
},

_propagateOperationsToFileItem : function() {
    var form = this.getFileItemForm();
    if (form != null) {
        form.fetchOperation = this.fetchOperation;
        form.updateOperation = this.updateOperation;
        form.addOperation = this.addOperation;
        form.removeOperation = this.removeOperation;
    }
},


// _handleNativeSubmit.
// This method is fired from the onsubmit handler for the HTML form for this DynamicForm widget.
// The onsubmit handler will fire whenever a user action would normally trip a form submission
// These cases are:
// - If there's a submit element on the form and the user clicks it
// - If there's a submit element on the form and the user is focused in a Text item, and
//   hits enter.
// - If there's a single text element in the form only (even if there is no submit item) and
//   the user hits enter while focused in it
// We disallow native submission by returning false from this method in each of these cases
// because:
// - we never write out a native submit element (our submitItem is a buttonItem subclass)
// - we have our own more reliable handling for submitting on Enter keypress, explicitly handled
//   by our keypress handler.
// Note that onsubmit does NOT fire when form.submit() is called programmatically, so this has
// no effect except on the user interactions listed above.
// We can therefore always return false to suppress this event.
_handleNativeSubmit : function () {
    return false;
},



// Validation
// --------------------------------------------------------------------------------------------

//>    @method    dynamicForm.validate()  ([])
// Validates the form without submitting it, and redraws the form to display error messages
// if there are any validation errors. Returns true if validation succeeds, or false if
// validation fails.
// <P>
// For databound forms, any +link{Datasource} field validators will be run even if there is no
// associated item in the form.  Validators will also be run on hidden form items.  In both
// these cases, validation failure can be handled via
// +link{DynamicForm.handleHiddenValidationErrors()}.
// <P>
// If this form has any fields which require server-side validation (see
// +link{Validator.serverCondition}) this will also be initialized. Such validation will
// occur asynchronously.  Developers can use +link{dynamicForm.isPendingAsyncValidation()} and
// +link{dynamicForm.handleAsyncValidationReply()} to detect and respond to asynchronous
// validation.
// <P>
// Note that for silent validation, +link{valuesAreValid()} (client-side) and
// +link{checkForValidationErrors()} (client and server-side) can be used instead.
//
// @param [validateHiddenFields] (boolean) Should validators be processed for non-visible fields
//         such as dataSource fields with no associated item or fields with visibility set to
//         <code>"hidden"</code>?
// @return (boolean) true if validation succeeds, or false if validation fails.
// @visibility external
// @group    validation
// @example formsValidationType
// @see method:valuesManager.validate
//<



// checkValuesOnly parameter - if passed we're not going to store errors on the form or display
// them - simply pick up the error values and return them. Called by the 'valuesAreValid()' method




validate : function (validateHiddenFields, ignoreDSFields, typeValidationsOnly,
                     checkValuesOnly, skipServerValidation, suppressShowErrors, callerContext)
{
    if (this.disableValidation) return true;

    // skip validation if we're databound and our datasource has validation disabled
    if (this.dataSource && this.dataSource.useLocalValidators != null &&
        this.useLocalValidators == false) return true;

    var hadErrorsBefore = this.hasErrors(),   // remember if we had errors before
                                              // so we'll redraw the form if this
                                              // validation pass finds no errors
        errorsFound = false,
        form = this.getForm(),
        hasChanges = false
    ;

    // We need to validate:
    // - form items with validators
    // - values that map to DS fields with validators.
    // (we don't need to worry about values with no associated field as there is no way to
    //  specify validators for such fields)
    var errors = {},
        hiddenErrors = {},
        values = this.getValues(),
        record = this._getRecordForValidation(true, values),
        // fields are returned from ds in {fieldName:fieldObject} format
        dsFields = (validateHiddenFields && !ignoreDSFields && this.dataSource)
                        ? isc.addProperties({}, this.getDataSource().getFields())
                        : null
    ;
    // Validate each form item
    // Note that when validating ContainerItem (e.g. DateItem) form items, only the
    // ContainerItem itself is validated, and not any of its sub-items.
    var validationOptions = {unknownErrorMessage: this.unknownErrorMessage,
                             serverValidationMode: "full"};
    if (typeValidationsOnly)
        validationOptions.typeValidationsOnly = typeValidationsOnly;
    if (skipServerValidation)
        validationOptions.skipServerValidation = skipServerValidation;
    else
        validationOptions.deferServerValidation = true;

    // Wrap field validation in a queue so that server validators are
    // sent as a single request.
    var wasAlreadyQueuing = isc.rpc ? isc.rpc.startQueue() : false;

    // Field objects that require server validation
    var fieldsNeedingServerValidation = [];

    for (var itemNum = 0; itemNum < this.items.length; itemNum++) {
        var fieldErrorsFound = false,
            // get the field item
            item = this.items[itemNum],
            // get the name of this column in the values
            column = item.getFieldName(),
            // get the dataPath so we can perform validation with dataPath

            dp = item.getTrimmedDataPath() || item.getFieldName(),
            // get the value of this item
            value = item.getValue(),
            hidden = !item.visible || isc.isA.HiddenItem(item)
        ;
        if (hidden && !validateHiddenFields) continue;

        if (!column && !dp) {
            if (item.validators != null) {
                // the field has no name and no dataPath - can't apply the validation error - just
                // log a warning instead, and continue
                this.logWarn("Item with index " + itemNum +
                     " has no name or dataPath - can't validate.");
                continue;
            }
        }

        if (item.validators != null) {

            // normalize item.validators to an array.
            if (!isc.isAn.Array(item.validators)) {
                item.validators = [item.validators];
            }

            // Perform actual validation.
            var fieldResult = this.validateField(item, item.validators, value,
                                                 record, validationOptions);
            if (fieldResult != null) {
                if (fieldResult.needsServerValidation) {
                    fieldsNeedingServerValidation.add(item);
                }
                if (fieldResult.errors != null) {
                    fieldErrorsFound = this.addValidationError(errors, column || dp,
                                                                fieldResult.errors);
                    if (fieldErrorsFound) errorsFound = true;
                }

                // if the validator returned a resultingValue, use that as the new value
                // whether the validator passed or failed.  This lets us transform data
                // (such as with the mask validator).
                if (fieldResult.resultingValue != null &&
                    this.compareValues(value, fieldResult.resultingValue, item))
                {
                    // remember that value in the values list
                    value = fieldResult.resultingValue;
                    if (dp) {
                        isc.DynamicForm._saveFieldValue(dp, item, value, values, this, true, "validate");
                    } else if (column) {
                        values[column] = value;
                    }
                    hasChanges = true;
                }
            }
        }

        // If the item is not visible, copy the errors so we can run a method to let the
        // developer handle errors on hidden fields
        // Note that this includes 'hiddenItems' that are not marked as visible:false
        if (hidden && fieldErrorsFound) hiddenErrors[column || dp] = errors[column || dp];

        // Validators applied to an item are a superset of the validators applied to
        // a dataSource field - therefore no need to run DSField validators for this field

        if (dsFields) delete dsFields[column];
    }

    // If we are attached to a rules engine, notify it that we are performing validation.
    // This gives it a chance to re-run any validators it has in its rulesData that apply to
    // our specific fields
    var rulesEngine = this.getRulesEngine();
    if (rulesEngine != null) {
        var rulesErrors = rulesEngine.applyFieldValidators(errors, this);
        if (rulesErrors) errorsFound = true;
    }

    var mustStopOnError = false;


    // Explicitly run through datasource field validators
    if (dsFields) {
        // Unless we're looking at a 'required' or 'requiredIf' field,
        // don't try to validate null values.
        validationOptions.dontValidateNullValue = true;
        // We want to process all validators
        delete validationOptions.typeValidationsOnly;
        // Tell the validation process that we are validating fields that have no matching
        // FormItem, so the conditionallyRequired checks know whether a missing value is
        // definitely missing or needs to be checked on the server
        validationOptions.validatingDsFields = true;

        for (var i in dsFields) {

            var fieldObject = dsFields[i],
                fieldName = i,
                validators = fieldObject.validators
            ;

            if (validators != null) {
                var value = values[fieldName];

                // Validate the dataSource field
                var fieldResult = this.validateField(fieldObject, validators, value,
                                                     values, validationOptions);
                if (fieldResult != null && fieldResult.errors != null) {
                    this.addValidationError(errors, fieldName, fieldResult.errors);
                }
                if (!checkValuesOnly && fieldResult && fieldResult.stopOnError) {
                    var item = this.getItem(fieldName);
                    if (item) {
                        item.setBlockingErrors(fieldResult.errors != null);
                        mustStopOnError = true;
                    }
                }
            }

            if (errors[fieldName] != null) hiddenErrors[fieldName] = errors[fieldName];
        }
    }

    // Perform deferred server validation if needed
    if (fieldsNeedingServerValidation.length > 0) {
        // Note - pass the entire record to the server (may be derived from our parent
        // valuesManager) - this ensures that we have values for all required fields, etc

        this.validateFieldsOnServer(fieldsNeedingServerValidation, record, validationOptions,
                                    callerContext);
    }

    // Submit server validation requests queue
    if (!wasAlreadyQueuing && isc.rpc) isc.rpc.sendQueue();

    //>DEBUG
    if (errorsFound) this.logInfo("Validation errors: " + isc.Log.echoAll(errors));
    //<DEBUG

    if (checkValuesOnly) return (errorsFound ? errors : true);

    // set the error messages for the form whether any were found or not
    this.setErrors(errors);


    // if validation changes values, update the visible values in the form elements, which will
    // automatically update this.values
    if (hasChanges) {
        this.setItemValues(values, null, null, null, true);
        // directly save values for which there are no form elements
        for (var field in values) {
            if (this.getItem(field) == null) this._saveValue(field, values[field]);
        }
    }

    // redraw if we found new errors or if we previously had errors which must be cleared from view
    if (!suppressShowErrors && (errorsFound || hadErrorsBefore)) {
        this.showErrors(errors, hiddenErrors, mustStopOnError);
    }

    return !errorsFound;
},

_getRecordForValidation : function (updateFocusItemValue, defaultValues) {

    var manager = this.valuesManager;
    if (manager != null) {
        var record = updateFocusItemValue ? manager.getValues() :
                         isc.addProperties({}, manager.values);
        if (this.dataPath != null) {
            record = isc.DynamicForm._getFieldValue(this.dataPath, null, record, this, true);
        }
        return record;
    }

    var undef;
    if (defaultValues !== undef) return defaultValues;


    return isc.addProperties({}, updateFocusItemValue ? this.getValues() : this.values);
},

//> @method DynamicForm.valuesAreValid()
// Method to determine whether the current form values would pass validation.
// This method operates client-side, without contacting the server, running validators on the
// form's values and returning a value indicating whether validation was successful.
// <P>
// Unlike +link{DynamicForm.validate()} this method will not store the errors on the DynamicForm
// or display them to the user.
// <P>
// Note that +link{checkForValidationErrors()} allows for checking for server-side errors, and
// finding out what those errors are via a callback.
//
// @param validateHiddenFields (boolean) Should validators be processed for non-visible fields
//         such as dataSource fields with no associated item or fields with visibility set to
//         <code>"hidden"</code>?
// @param [returnErrors] (boolean) If unset, this method returns a simple boolean value indicating
// success or failure of validation. If this parameter is passed, this method will return
// an object mapping each field name to the errors(s) encountered on validation failure, or null
// if validation was successful.
// @return (boolean | Map) Boolean value indicating validation success, or if
// <code>returnErrors</code> was specified, <smartclient>an object mapping</smartclient>
// <smartgwt>a map of</smartgwt> field names to the associated errors, for those fields that
// failed validation, or null if validation succeeded.
// @visibility external
// @group validation
//<
valuesAreValid : function (validateHiddenFields, returnErrors) {
    var errors = this.validate(validateHiddenFields, null, null, true, true);
    if (errors === true) {
        return (returnErrors ? null : true);
    } else {
        return (returnErrors ? errors : false);
    }
},

//> @method Callbacks.ValidationStatusCallback
// A +link{type:Callback} to evaluate when form validation completes.
// <p>
// The available parameters are:
// @param errorMap (Map) null if validation succeeded for all fields, or <smartclient>an
// object mapping</smartclient><smartgwt>a Map of</smartgwt> field names to the associated
// errors, for those fields that failed validation.
//
// @visibility external
//<

//> @method DynamicForm.checkForValidationErrors
// Performs silent validation of the current form values, like +link{valuesAreValid()}.  In
// contrast to +link{valuesAreValid()}, this method allows checking for server-side errors, and
// finding out what the errors are.
// <P>
// The callback must be passed unless server-side validation is being skipped, and If passed,
// it always fires, errors or not, firing synchronously if server validation is skipped.
//
// @param callback (ValidationStatusCallback) callback to invoke after validation is complete
// @param [validateHiddenFields] (boolean) should validators be processed for non-visible fields
//         such as dataSource fields with no associated item or fields with visibility set to
//         <code>"hidden"</code>
// @param [skipServerValidation] (boolean) whether to skip doing server-side validation
//
// @return (Map) null if server-side validation is required, or no errors are present;
// otherwise, <smartclient>an object mapping</smartclient><smartgwt>a Map of</smartgwt> field
// names to the associated errors, for those fields that failed validation.
//
// @visibility external
// @group validation
//<
checkForValidationErrors : function (callback, validateHiddenFields, skipServerValidation) {

    var errors = this.validate(validateHiddenFields, null, null, true, true);
    if (errors === true) errors = null;

    // return immediately if errors detected or skipping server-side validation
    var dataSource = this.getDataSource();
    if (errors || skipServerValidation || !dataSource) {
        if (callback != null) this.fireCallback(callback, "errorMap", [errors]);
        return errors;
    }

    if (!callback) {
        this.logWarn("checkForValidationErrors(): no callback has been provided, but not " +
                     "skipping server-side validation - this is invalid usage");
        return;
    }

    // validate the data on the server
    var values = this.getValues(),
        context = this.buildRequest(null, "validate");
    context.editor = this;

    var form = this;
    dataSource.validateData(values, function (response, data) {
        var errors = response.status == isc.RPCResponse.STATUS_VALIDATION_ERROR &&
                     response.errors ? response.errors : null;
        // translate server error format to editor component error format

        if (errors && !form.reportRawServerErrors) {
            errors = isc.DynamicForm.getSimpleErrors(errors);
        }
        this.fireCallback(callback, "errorMap", [errors]);
    }, context);
},

//> @method DynamicForm.getValidatedValues()
// Call +link{dynamicForm.validate()} to check for validation errors. If no errors are found,
// return the current values for this form, otherwise return null.
// @return (Object) current values or null if validation failed.
// @group errors
// @visibility external
//<
getValidatedValues : function () {
    // validate the form
    // This will cause the form to redraw automatically if it has new errors
    // (or it had errors before and doesn't now).

    if (!this.validate()) return null;
    return this.getValues();
},

//> @method DynamicForm.showErrors()
// If this form has any outstanding validation errors, show them now.<br>
// This method is called when the set of errors is changed by +link{dynamicForm.setErrors()} or
// +link{dynamicForm.validate()}.<br>
// Default implementation will redraw the form to display error messages and call
// +link{DynamicForm.handleHiddenValidationErrors(), handleHiddenValidationErrors()} to
// display errors with no visible field.<br>
// Note that this method may be overridden to perform custom display of validation errors.
// @group errors
// @visibility external
//<
// Additional 'errors' / 'hiddenErrors' parameters
// Used internally when we have just calculated the errors, as well as which fields are visible
// and which are hidden
// contains an object of fieldName to error mappings for fields that are not visible.
// Not public - if this method is being called by the user, always re-calculate which fields are
// visible /hidden. This is cleaner than tracking the hidden errors in a separate object as we'd
// have to update that each time fields were shown / hidden, etc.
showErrors : function (errors, hiddenErrors, forceRefocus) {

    var suppressAutoFocus = (!forceRefocus && !this.autoFocusOnError) || this._suppressAutoFocusOnErrors;
    if (this._suppressAutoFocusOnErrors) delete this._suppressAutoFocusOnErrors;


    var focusItem = this.getFocusItem();
    if (focusItem && focusItem._handlingInput && focusItem.hasFocus) suppressAutoFocus = true;

    var undef;
    if (hiddenErrors === undef) hiddenErrors = this.getHiddenErrors();
    if (errors === undef) errors = this.getErrors();

    // If we have errors and we're not showing them inline, we need to auto-generate a blurb
    // item at the top of the form to display the errors.
    // Do this in showErrors only - this way if showInlineErrors is set to false, and this
    // method is overridden the developer will be suppressing this default approach.
    if (errors && !this.showInlineErrors &&
        (!this._errorItem || this._errorItem.destroyed || !this.items.contains(this._errorItem)))
    {
        this.createErrorItem();
    }

    // Redraw whether there are outstanding errors or not. This means that this method will
    // also clear visible errors that have been resolved.
    this.markForRedraw("Validation Errors Changed");

    if (errors && !isc.isAn.emptyObject(errors) && !suppressAutoFocus) {
        for (var fieldName in errors) {
            var item = this.getItem(fieldName);
            // if an error item was found, set the focus to that item

            if (item && item.isVisible() && item.isDrawn()) {
                this._focusInItemWithoutHandler(item);
                break;
            }
        }
    }
    // if we're showing the blurb at the top of the form scroll it into view.
    // Do this on a delay to allow IE to asynchronously complete focusing in the first error item
    if (!this.showInlineErrors) {
        this.delayCall("scrollIntoView", [0,0], 100);
    }

    if (hiddenErrors) {
        this._handleHiddenValidationErrors(hiddenErrors);
    }
},

getHiddenErrors : function () {
    if (!this.errors) return null;
    var hasHiddenErrors = false, hiddenErrors = {};

    for (var fieldName in this.errors) {
        var item = this.getItem(fieldName);
        if (!item || !item.visible) {
            hasHiddenErrors = true;
            hiddenErrors[fieldName] = this.errors[fieldName];
        }
    }
    return (hasHiddenErrors ? hiddenErrors : null);
},

//> @method DynamicForm.showFieldErrors ()
// If this form has any outstanding validation errors for the field passed in, show them now.
// Called when field errors are set directly via +link{dynamicForm.setFieldErrors()} /
// +link{dynamicForm.addFieldErrors} / +link{dynamicForm.clearFieldErrors()}.<br>
// Default implementation simply falls through to +link{dynamicForm.showErrors()}.
// @param fieldName (String) field to show errors for
// @group errors
// @visibility external
//<
// This can be called if errors are being updated individually on a per field basis.
// Note that calling handleHiddenVlaidationErrors will actually fire the handler and pass in
// the full set of hidden errors. We could have a more fine grained method
// like 'handleHiddenFieldValidationErrors()' instead.

showFieldErrors : function (fieldName, suppressAutoFocus) {
    // 'null' has meaning to showErrors so use explicit undefined instead
    var undef;
    if (suppressAutoFocus) this._suppressAutoFocusOnErrors = true;
    return this.showErrors();
},

// _handleHiddenValidationErrors()
// Internal method to display validation errors when we can't show them in a form.
// This is used to handle
// - errors coming from hidden form items
// - errors coming from a dataSource field for which we have no form item.
_handleHiddenValidationErrors : function (errors) {
    if (errors == null || isc.isAn.emptyObject(errors)) return;

    // If we have an implementation to handle the hidden validation errors, call it now.
    var returnVal;
    if (this.handleHiddenValidationErrors) {
        returnVal = this.handleHiddenValidationErrors(errors);
    }


    // returning false suppresses the log warn statement
    if (returnVal == false) return;

    var errorString = "Validation errors occurred for the following fields " +
                        "with no visible form items:";

    for (var fieldName in errors) {
        var fieldErrors = errors[fieldName];
        if (!isc.isAn.Array(fieldErrors)) fieldErrors = [fieldErrors];
        if (fieldErrors.length == 0) continue;

        errorString += "\n" + fieldName + ":";
        for (var i = 0; i < fieldErrors.length; i++) {
            errorString += (i == 0 ? "- " : "\n - ") + fieldErrors[i];
        }
    }

    this.logWarn(errorString, "validation");
},

isRequired : function (item, ignoreCanEdit) {
    return (
        (ignoreCanEdit ? true : isc.DynamicForm.canEditField(item, this)) &&
            (item.required ||  // marked required is form or DS fields
             item._required || // currently required due to requiredIf
             // XML element is required and we are treating that as meaning required
             this.isXMLRequired(item))
           );
},

//>    @method    dynamicForm.setRequiredIf()    (A)
// Iterate through the items, setting the _required property of any item with a requiredIf
// to correspond to the evaluation that property
//
//            some fields may become required or not required
//        @group    validation
//<

_$requiredIf:"requiredIf",
_$required:"required",
setRequiredIf : function () {
    var values = this.getValues();

    // if any fields have 'requiredIf' set, set their required property now
    for (var itemNum = 0; itemNum < this.items.length; itemNum++) {
        var item = this.items[itemNum],
            validators = item.validators
        ;
        // Ensure if a 'required'/'requiredIf'
        // validator gets removed we don't keep stale "_required" flags around!
        delete item._required;
        // if item is not visible or it has no validators, skip it
        if (!item.visible || !validators || validators.length == 0) continue;

        for (var v = 0; v < validators.length; v++) {
            var validator = validators[v];
            if (!validator) continue;
            var type = isc.Validator.getValidatorType(validator);
            if (type == this._$requiredIf) {
                var value = item.getValue();
                // CALLBACK API:  available variables:  "item,validator,value"
                // Convert a string callback to a function
                if (validator.expression != null && !isc.isA.Function(validator.expression)) {
                    isc.Func.replaceWithMethod(validator, "expression",
                                                     "item,validator,value,record");
                }

                // set the hidden value for item._required according to the results of the
                // expression
                item._required = validator.expression.apply(this, [item, validator, value, values]);
            // if an explicit 'required' validator was specified but the field wasn't marked
            // as required:true, set the _required flag so we still show the required styling
            // on the title, etc.
            } else if (type == this._$required) {
                item._required = true;
            }
        }
    }
},


//special handling of focus is required when a click mask is hidden
_restoreFocusForClickMaskHide : function () {

    this.setFocus(true, true);
},

//>    @method    dynamicForm.setFocusItem()    (A)
//  Internal method used to track which form item last had focus.
//  The focusItem is updated with this method whenever an item receives focus.  When focus()
//  is called on the form, the focusItem will then be given focus.
//  Can be retrieved via 'getFocusSubItem()' [or 'getFocusItem()' if we don't want sub items
//  of containerItems], and cleared via 'clearFocusItem()'
//  Note that the focusItem may not currently have focus - focus could be on another widget.
//  Check formItem.hasFocus to see if an item currently has focus.
//
//        @group eventHandling, focus
//        @param    item (FormItem)    item to focus in
//      @param  [itemIcon] (String) item icon name to focus in
//<
setFocusItem :  function (item, itemIcon) {
    // normalize the item passed in
    item = this.getItem(item);
    this._focusItem = item;
    this._focusItemIcon = itemIcon;
    if (this.hasStableLocalID()) {
        var path = this.getLocalId() + ".focusField",
            value = item && this.isFocused() ? item.name : null,
            currentValue = this._getFromRuleContext(path)
        ;
        if (value != currentValue) this.provideRuleContext(path, value, this);
    }
},

//> @method dynamicForm.isFocused()
// Returns true if this DynamicForm has the keyboard focus.
// <P>
// Unlike standard canvases, for a DynamicForm this method will return true when keyboard
// focus is currently on one of the form's +link{dynamicForm.items,items}.
// <P>
// Note that in some cases the items of a form may be written directly into a different
// +link{formItem.containerWidget, canvas}. In this case the dynamicForm containing the
// items may not have been drawn on the page itself, but this method can still return true
// if one of the items has focus.
// @return (Boolean) whether focus is currently in one of this form's items.
// @visibility external
//<

isFocused : function () {
    if (this.Super("isFocused", arguments) == true) return true;
    var focusItem = this.getFocusItem();
    if (focusItem && isc.isA.CanvasItem(focusItem) && focusItem.isFocused()) {
        return true;
    }
    return false;
},

//>    @method    dynamicForm.getFocusItem()    (A)
// Return the current focus item for this form.
// <P>
// This is the item which either currently has focus, or if focus is not
// currently within this form, would be given focus on a call to
// +link{dynamicForm.focus()}. May return null if this form has never had focus,
// in which case a call to <code>form.focus()</code> would put focus into the
// first focusable item within the the form.
// <P>
// Note that if focus is currently in a sub-item of a +link{DateItem} or +link{RadioGroupItem},
// this method will return the parent item, not the sub-item.
// @return (FormItem) Current focus item within this form. May be null.
// @see dynamicForm.isFocused()
// @see formItem.isFocused()
// @group eventHandling, focus
// @visibility external
//<
getFocusItem : function () {
    var item = this.getFocusSubItem();
    if (item != null) {
        while (item.parentItem != null) {
            item = item.parentItem;
        }
    }
    return item;
},

// For container items, we actually store the focusable sub item rather than
// the containerItem.
// This is what we typically use internally as this is where we'll explicitly put focus
// on redraw, etc.
getFocusSubItem : function () {
    return this._focusItem;
},

getFocusItemIcon : function () {
    return this._focusItemIcon;
},

// Override _readyToFocus() -- if this DF is not drawn, it may still be appropriate to give it
// focus as it's items may be written into a container widget.
_readyToSetFocus : function () {

    // Note: see comment in Canvas._readyToSetFocus() for docs on isc_suppressFocus
    return !this.isDisabled() && !window.isc_suppressFocus;


},

// Disable focusOnMouseDown
// We rely on native focus on mouse down in natively focusable elements (form items, etc)
// and on item-level mouseDown / click handlng for non-focusable elements (select item div, etc)

focusOnMouseDown : function () {
    return;
},

// Override 'setFocus()' to update item focus.

setFocus : function (hasFocus, canTargetIcon) {
    if (!this._readyToSetFocus()) return;
    var visible = this.isVisible();
    if (hasFocus) {

        // focus back in the last focus item if there is one.
        var item = this.getFocusSubItem();
        if (item == null) {
            var items = this.getItems();
            if (items != null) {
                for (var i = 0; i < items.length; i++) {
                    var testItem = items[i];
                    if (testItem._canFocus() && testItem.isDrawn() &&
                        testItem.isVisible() && !testItem.isDisabled())
                    {
                        item = testItem;
                        break;
                    }
                }
            }
        }
        var itemIcon = (canTargetIcon && item ? this.getFocusItemIcon() : null);

        var event = isc.EH.lastEvent;
        if (item != null) {
            // No need to call Super because focusing in the item will trigger the
            // elementFocus() method which updates this.hasFocus, etc.
            return this.focusInItem(item, itemIcon);
        }
    }

    this.Super("setFocus", arguments);
    // Override 'blur()' to take focus away from the focus item, as well as clear out
    // this.hasFocus.
    if (!hasFocus) {

        // Note we use the internal _blurItem() method to avoid clearing out this._focusItem.
        // This means a subsequent 'focus()' call on this form will restore focus to the same
        // item.
        this._blurItem(this.getFocusSubItem());

    }
},

// Override getFocusedTabIndexEntry() to delegate down to the relevant item's focused
// part (text box, icon, etc)

getFocusedTabIndexEntry : function () {
    var focusItem = this.getFocusSubItem();
    if (focusItem == null) {
        return this.Super("getFocusedTabIndexEntry", arguments);
    } else {
        return focusItem._getCurrentFocusTargetID();
    }
},


// Since in dynamicForm focus is essentially delegated to our items, simply no-op if
// the TabIndexManager shiftFocus method attempts to focus in the form itself.
// The items are also registered and can handle shifting focus to themselves directly.
syntheticShiftFocus : function (ID) {
    return false;
},

// Helper - can we currently call 'focus' on an item?
_canFocusInItem : function (item, tabStop) {
    if (isc.isA.String(item)) item = this.getItem(item);
    return item && item._canFocus() && item.isDrawn() && item.isVisible() && !item.isDisabled()
            && (!tabStop || item.tabIndex != -1);
},

// Re-document focus to explain the "focusItem" behavior.
//> @method dynamicForm.focus()
// Give keyboard focus to this form. If this form has had focus before, focus will be
// passed to the item which last had focus (see +link{dynamicForm.getFocusItem()}) -
// otherwise focus will be passed to the first focusable item in the form.
// <P>
// To put focus in a specific item, use +link{dynamicForm.focusInItem()} instead.
// @group   focus
// @visibility external
//<


//>    @method dynamicForm.focusInItem()
// Move the keyboard focus into a particular item.
// @group eventHandling, focus
// @param    itemName     (number | ItemName | FormItem)    Item (or reference to) item to focus in.
// @visibility external
//<
focusInItem : function (itemName, itemIcon) {
    // normalize the item in case it's a number or a string
    if (itemName != null) {
        var item = this.getItem(itemName);
    } else {
        var item = this.getFocusSubItem();
    }
    // if nothing was found to focus in, bail!
    if (!item) {
        if (itemName != null) this.logWarn("couldn't find focus item: " + itemName);
        return;
    }

    // if the item can accept focus
    if (item._canFocus()) {
        // focus in it
        if (!itemIcon) item.focusInItem();
        if (itemIcon && item.focusInIcon) item.focusInIcon(itemIcon);
        if (this._setValuesPending) {
            var theForm = this;
            isc.Page.setEvent("idle",
                              function () { if (!theForm.destroyed) theForm.focusInItem(); },
                              isc.Page.FIRE_ONCE);
        }
    } else {
        // otherwise complain
        this.logWarn("focusInItem: item cannot accept focus: " + item);
    }
},

// removes the form instance's knowledge of the currently focused element, but does not actually
// blur the element
clearFocusItem : function () {
    delete this._focusItem;
    delete this._focusItemIcon;
    if (this.hasStableLocalID()) this.provideRuleContext(this.getLocalId() + ".focusField", null, this);
},


//>    @method    dynamicForm.blurFocusItem()    (A)
//  Fires the blurItem() command on the focused item
//  @group eventHandling, focus
//<

blurFocusItem : function (exitCheck) {
    var focusItem = this.getFocusSubItem();
    if (focusItem != null) {
        this._blurItem(focusItem);
        // clear out the remembered focus item - this is an explicit blur, so we don't want
        // focus to go to that item.
        this.clearFocusItem();
        // if requested, check for a pending checkForEditorExit(), and run if appropriate
        if (exitCheck && isc.FormItem._pendingEditorExitCheck == focusItem) {
            isc.FormItem._pendingEditorExitCheck.checkForEditorExit(true, true);
        }
    }
},

// Internal '_blurItem' method fires the blur method on the item passed in, if it has focus.
// This does not update this._focusItem, so can be used to blur the form entirely without
// losing track of which item has focus
_blurItem : function (item) {
    if (item != null && item.hasFocus) item.blurItem();
},

// _blurFocusItemWithoutHandler
// Internal method to blur the focus item, without triggering its blur handler.
// Will not clear out this._focusItem.

_blurFocusItemWithoutHandler : function () {

    var focusItem = this.getFocusSubItem();
    if (focusItem != null && focusItem.hasFocus) {
        this._suppressBlurHandlerForItem(focusItem);
        this._blurItem(focusItem);

    } else {
        this.logDebug("blur w/o handler: no item to blur");
    }
},

//_focusInItemWithoutHandler
// Internal method to focus in a form item without firing it's focus handler
_focusInItemWithoutHandler : function (item) {
    // If the item is non-focusable, no-op
    if (!item || !this._canFocusInItem(item)) {
        var parentItem;
        if (item && item.parentItem) {
            this._focusInItemWithoutHandler(item.parentItem);
            parentItem = true;
        }
        this.logInfo("_focusInItemWithoutHandler(" + item +
                     "): not calling focus as item not focusable or item already has focus" +
                     (parentItem ? ". Putting focus into containerItem instead." : ""),
                     "nativeFocus")
        return;
    }

    // If the item already has focus, no op
    // Note: In IE hasFocus is not a reliable check - it only gets updated on the asynchronous
    // onfocus handler - look directly at the document.activeElement to see where focus
    // currently is instead.

    var hasFocus = item.hasFocus;
    if (isc.Browser.isIE && !isc.EH.synchronousFocusNotifications) {
        var focusItemInfo = isc.DynamicForm._getItemInfoFromElement(document.activeElement);
        hasFocus = (focusItemInfo && focusItemInfo.item == item);
    }
    if (hasFocus) return;

    this._suppressFocusHandlerForItem(item);

    this.focusInItem(item);
},

// _suppressFocusHandlerForItem()
// Sets a flag to avoid firing focus handlers when an item receives focus. This, together with
// _blurFocusItemWithoutHandler() allows us to silently blur and refocus in an item (EG on redraw)
// Note that this method should ALWAYS be followed by a call to focus in the item in question.
_suppressFocusHandlerForItem : function (item) {

    if (this.__suppressFocusHandler == null) this.__suppressFocusHandler = 0;
    else this.__suppressFocusHandler += 1;
    this.__suppressFocusItem = item;
},

// See _suppressFocusHandlerForItem for related details
_suppressBlurHandlerForItem : function (item) {
    if (this.__suppressBlurHandler == null) this.__suppressBlurHandler = 0;
    else this.__suppressBlurHandler += 1;
},


setOpacity : function (newOpacity, animating, forceFilter, a,b,c) {
    var oldOp = this.opacity;
    this.invokeSuper(isc.DynamicForm, "setOpacity", newOpacity, animating, forceFilter, a,b,c);

    newOpacity = this.opacity;
    if (isc.Browser.isMoz && this.hasFocus &&
        (newOpacity != oldOp) &&
        (newOpacity == null || newOpacity == 100 || oldOp == null || oldOp == 100) )
    {
        var item = this.getFocusSubItem();
        if (item && item._willHandleInput()) {
            this._blurFocusItemWithoutHandler();
            this._focusInItemWithoutHandler(item);
        }
    }
},

// clearingElement
// When a form item is cleared or redrawn, its element will be removed from the DOM
// this is a notification for this.

clearingElement : function (item) {


    if (this.__suppressFocusHandler != null && this.__suppressFocusItem == item) {
        delete this.__suppressFocusHandler;
        delete this.__suppressFocusItem;
    }
    if (this.__suppressBlurHandler != null && (this.getFocusSubItem() == item)) {
        delete this.__suppressBlurHandler;
    }
},

hide : function () {

    if (isc.Browser.isMoz) this._blurItem(this.getFocusSubItem());
    this.Super("hide", arguments);
},

// Override setVisibility to ensure that 'visibilityChanged' notifications are fired on the
// items in this form.
setVisibility : function (newVisibility,a,b,c) {
    this.invokeSuper(isc.DynamicForm, "setVisibility", newVisibility,a,b,c);
    this.itemsVisibilityChanged();
    // If we are shown and we are auto-focus true, focus now
    if (this.isVisible() && this.isDrawn() && this.autoFocus) this.focus();
},


_updateHandleDisplay : function (a, b, c) {
    var result = this.invokeSuper(isc.DynamicForm, "_updateHandleDisplay", a, b, c);
    if (result) this._placeCanvasItems();
    return result;
},

// override 'clear' to notify the form items that they have been hidden.

clear : function () {

    if (this._verifyingFileAccess) {
        this.logWarn("clear(): This form was cleared during an asynchronous operation to upload file. " +
            "Upload will be aborted. Synchronous file upload can be enabled by setting " +
            "'checkFileAccessOnSubmit' to false, but note that this disables logic to verify that " +
            " the uploaded file can be accessed by the browser.");
        this._abortNativeSubmit = true;
        this._cleanUpFailedRPCTransaction();
    }


    if (!this.destroying) {
        // Remove item *When rules from rulesEngine
        // Do this before calling Super() because form will be removed from ruleContext
        // before returning.
        this._removeItemWhenRules();
    }

    this.Super("clear", arguments);

    this.itemsVisibilityChanged()
    this._itemsCleared();
},

// If focus is taken from the form as a whole, ensure the focusItem's HTML element is blurred
_focusChanged : function (hasFocus) {
    this.Super("_focusChanged", arguments);

    if (!this.hasFocus) this._blurItem(this.getFocusSubItem());

    // If losing focus, update ruleContext. Gaining focus will trigger a
    // a formItem focus to update ruleContext.
    if (this.hasStableLocalID() && !hasFocus) {
        if (this.destroying || this.destroyed) {
            this.logInfo("Attempt to provide RuleContext from focus-change during destruction...");
            return;
        }
        this.provideRuleContext(this.getLocalId() + ".focusField", null, this);
    }
},


parentVisibilityChanged : function (newVisibility) {
    //this.logWarn("parentVisibilityChanged, visible: " + this.isVisible());
    if (!this.isVisible() && isc.Browser.isMoz) this._blurItem(this.getFocusSubItem());
    this.Super("parentVisibilityChanged", arguments);
    this.itemsVisibilityChanged();

    // If we are shown due to a parent being shown, and we are auto-focus true, focus now.
    if (this.isVisible() && this.autoFocus) this.focus();
},

// Ensure we allow native text selection within form items.
_allowNativeTextSelection : function (event) {

    if (event == null) event = isc.EH.lastEvent;
    var itemInfo = this._getEventTargetItemInfo(event);

    // For now always allow text selection of form items' cells.
    if (itemInfo.item) {
        var rv = itemInfo.item._allowNativeTextSelection(event, itemInfo);
        if (rv != null) return rv;
    }
    return this.Super("_allowNativeTextSelection", arguments);
},

_allowNativeDrag : function (event) {

    if (event == null) event = isc.EH.lastEvent;
    var itemInfo = this._getEventTargetItemInfo(event);

    // For now always allow text selection of form items' cells.
    if (itemInfo.item) {
        var rv = itemInfo.item._allowNativeDrag(event, itemInfo);
        if (rv != null) return rv;
    }
    return this.Super("_allowNativeDrag", arguments);
},

// Override prepareForDragging
// If the developer is dragging from inside one of our formItems, just disallow it
// This would be really odd UI - if a user drags across a text based item, you'd expect a
// selection to occur, taking precedence over this.canDragReposition.
prepareForDragging : function (a,b,c,d) {
    var EH = this.ns.EH;
    // this would indicate that a child has set itself as the dragTarget, and then
    // prepareForDragging bubbled to this Canvas.  By default, we leave this alone.
    if (EH.dragTarget) return;

    // If the event occurred over the text box / element / control-table of one of our items,
    // return false - We don't want to allow dragging of the form as a whole from within an
    // item - instead we'll support drag selection of the item. We also don't want to allow
    // 'prepareForDragging' to bubble up and allow dragging of a parent.
    var event = EH.lastEvent,
        itemInfo = this._getEventTargetItemInfo(event);
    if (itemInfo.item &&
        (itemInfo.overElement || itemInfo.overTextBox || itemInfo.overControlTable)) return false;

    return this.invokeSuper(isc.DynamicForm, "prepareForDragging", a,b,c,d);
},


// -------------------------------------------------------------------------------------------
// Event handling
// For events that get passed to form items, we will fire the event on the item where it
// occurred, then bubble it up through any parent items. For standard mouse and key events, we
// then allow the event to be fired on the DynamicForm, and bubbled up through the widget
// parent chain.

// -------------------------------------------------------------------------------------------



// Given an event, determine whether it occurred over one of our items.
// Note: we return an object of the following format:   {item:item, overTitle:boolean}
// - if the event occurred over the item's title rather than the item itself, overTitle will
// be true.
_getEventTargetItemInfo : function (event) {

    if (!event) event = isc.EH.lastEvent;



    var target = isc.EH.isMouseEvent(event.eventType) ? event.nativeTarget
                                                      : event.nativeKeyTarget;
    var info = isc.DynamicForm._getItemInfoFromElement(target, this);
    // Copy the item info onto the event object itself so handlers can check what part of the
    // item the event occurred over directly; set the current DOMevent to allow caching
    event.itemInfo          = info;
    event._itemInfoDOMevent = event.DOMevent;
    return info;
},

//> @method dynamicForm.getEventItem ()
// If the current mouse event occurred over an item in this dynamicForm, returns that item.
// @return (FormItem) the current event target item
// @visibility external
//<
getEventItem : function () {
    var info = isc.EH.lastEvent.itemInfo;
    // skip events over titles or over "inactive" elements (EG placeholders in
    // alwaysShowEditors grids...)
    if (info != null && !info.inactiveContext && !info.overTitle) return info.item;
    return null;
},

//> @object FormItemEventInfo
// An object containing details for mouse events occurring over a FormItem.
// @treeLocation Client Reference/Forms/DynamicForm
// @visibility external
//<

//>@attr formItemEventInfo.item (FormItem : null : R)
// Item over which the event occurred.
// @visibility external
//<

//>@attr formItemEventInfo.overTextBox (Boolean : null : R)
// True if the event occurred within the item's +link{formItem.textBoxStyle, textBox}.
// @visibility external
//<

//>@attr formItemEventInfo.overElement (Boolean : null : R)
// True if the event occurred over the item's data or input element.  Note that it can be bad
// practice to implement custom context menus when overElement is true, since this will
// replace browser-default menus that users might expect.
// @visibility external
//<

//>@attr formItemEventInfo.overItem (Boolean : null : R)
// True if the event occurred over the main body of the item (for example the text-box), rather
// than over the title or within the form item's cell in the DynamicForm but outside the
// text box area.
// @visibility external
//<

//>@attr formItemEventInfo.overTitle (Boolean : null : R)
// True if the event occurred over the item's title.
// @visibility external
//<

//>@attr formItemEventInfo.overInlineError (Boolean : null : R)
// True if the event occurred over the form's
// +link{dynamicForm.errorItemProperties, single error item}.
// @visibility external
//<

//>@attr formItemEventInfo.icon (String : null : IR)
// If this event occurred over a formItemIcon this attribute contains the
// +link{formItemIcon.name} for the icon.
//
// @visibility external
//<

//> @method dynamicForm.getEventItemInfo ()
// If the current mouse event occurred over an item, or the title of an item in this
// dynamicForm, return details about where the event occurred.
// @return (FormItemEventInfo) the current event target item details
// @visibility external
//<
getEventItemInfo : function () {
    var itemInfo = this._getEventTargetItemInfo();
    if (itemInfo == null || itemInfo.inactiveContext) return null;
    return {
        item:itemInfo.item,
        // simplify details of which part of the form item received the event
        // since the difference between (EG) textBox and element is implementation dependent
        // only
        overElement: itemInfo.overElement,
        overtextBox: itemInfo.overTextBox,
        overItem: (itemInfo.overElement || itemInfo.overTextBox || itemInfo.overControlTable),
        overTitle: itemInfo.overTitle,
        overInlineError: itemInfo.overInlineError,
        icon: itemInfo.overIcon
    }
},

// Have handleMouseStillDown send a 'mouseStillDown' event to items, if they have a handler
// for it.

handleMouseStillDown : function (event, eventInfo) {
    if (isc._traceMarkers) arguments.__this = this;

    var targetInfo = this._getEventTargetItemInfo(event),
        item = ((targetInfo.overTitle || targetInfo.inactiveContext) ? null : targetInfo.item);

    // avoid double delivery of events if there are nested DynamicForm elements all receiving
    // this event via bubbling - only deliver to item if it's one of ours
    if (item != null) {
        if (item.form != this) return;

        if (item.mouseStillDown) {
            if (item.handleMouseStillDown(event) == false) return false;
        }
    }

},
// also send 'mouseDown' to items

handleMouseDown : function (event, eventInfo) {
    var targetInfo = this._getEventTargetItemInfo(event),
        item = (targetInfo.overTitle ? null : targetInfo.item);

    // store off the mouseDownTarget so we can cancel handleClick if the mouseUpTarget is different
    this._mouseDownTarget = targetInfo;

    if (item != null) {
        // avoid double delivery of events if there are nested DynamicForm elements all receiving
        // this event via bubbling - only deliver to item if it's one of ours
        if (item.form != this) return;

        item.handleMouseDown(event);

        if (targetInfo.overControlTable || targetInfo.overPickerIconCell) {

            return false;
        }


        if (isc.Browser.isSafari && !targetInfo.inactiveContext && targetInfo.overElement
            && isc.isA.CheckboxItem(item))
        {
            item.focusInItem();
        }
    }
},

// Form item mouse event APIs:
// - FormItem.mouseOver(), mouseMove(), mouseOut()
//      Not currently exposed
// - FormItem.titleOver(), titleMove(), titleOut()
//      Not currently exposed - fired if the event occurred over the  title rather than item.
// - FormItem.itemHover(), titleHover()
//      fired after a delay - return false to cancel showing any Hover canvas for the item
// - FormItem.itemHoverHTML() / titleHoverHTML()
//      not implemented by default - returns the HTML to show in the Hover canvas for this
//      item (null will suppress hover canvas). Takes precedence over the equivalent form-level
//      item/titleHoverHTML() methods.
// - Form.itemHoverHTML(item) / titleHoverHTML(item)
//      returns the HTML to show for the Hover canvas for some item.  Default implementation
//      for both methods returns the 'prompt' for the Item.


// _itemMouseEvent - fired in response to mouseMove, mouseOver or mouseOut.
// Fires appropriate handlers on the item.
_itemMouseEvent : function (itemInfo, eventType) {

    var lastMoveItem = this._lastMoveItem,
        wasOverTitle = this._overItemTitle,
        lastOverIcon = this._lastOverIconID,

        item = itemInfo.item,
        overTitle = itemInfo.overTitle,
        overIcon = itemInfo.overIcon
    ;

    // Don't fire mouse events on disabled items - set item to null so we fire mouseOut on
    // the previous item



    // If the event occurred over some 'inactiveEditorHTML' don't fire mouse-move based events
    // at all
    if (itemInfo.inactiveContext != null) {
        item = null;
        overTitle = null;
        overIcon = null;
    }

    // Don't attempt to fire events on items that have been destroyed

    if (lastMoveItem && lastMoveItem.destroyed) {
        lastMoveItem = null;
        this._lastMoveItem = null;
        this._lastOverIconID = null;
        this._overItemTitle = null;
    }
    if (item && item.destroyed) {
        item = null;
        overTitle = null;
        overIcon = null;
    }

    // Remember the information for the next mouse event
    this._lastMoveItem = item;
    this._overItemTitle = overTitle;
    this._lastOverIconID = overIcon;


    if (eventType == isc.EH.MOUSE_OVER) {
        if (item) {
            if (overTitle) item.handleTitleOver();
            else {

                if (overIcon) this._lastOverIconID = null;

//                if (this.editMode) this.showRolloverControls(item);
                item.handleMouseOver();
            }
        }
    } else if (eventType == isc.EH.MOUSE_OUT) {
        if (lastMoveItem) {
            if (wasOverTitle) lastMoveItem.handleTitleOut();
            else {
                if (lastOverIcon) lastMoveItem._iconMouseOut(lastOverIcon);
//                if (this.editMode) this.hideRolloverControls(item);
                lastMoveItem.handleMouseOut();
            }
        }

    // Mouse-Move case is more complex, as the user may have moved within an item, or be moving
    // between items, etc.
    } else {
        var changedItem = (lastMoveItem != item || wasOverTitle != overTitle)

        // In this case the user has switched items.
        // We catch:    - moving between two items' cells (or title cells)
        //              - moving over a new item or title cell
        //              - moving out of an item or title cell
        //              - moving from an item's cell to title (or vice versa)
        if (changedItem) {
            if (lastMoveItem) {
                if (wasOverTitle) lastMoveItem.handleTitleOut();
                else {
                    if (lastOverIcon) lastMoveItem._iconMouseOut(lastOverIcon);
                    lastMoveItem.handleMouseOut();
                }
            }
            if (item) {
                if (overTitle) item.handleTitleOver();
                else {
                    if (overIcon) item._iconMouseOver(overIcon);

                    // If the mouse is over an icon, then _iconMouseOver() was just called. If
                    // _lastPromptIcon was set by _iconMouseOver(), then Hover.setAction() was
                    // called to fire _handleIconHover() on a delay. We don't want to now call
                    // handleMouseOver() because that will reset the Hover action to call
                    // _handleHover() on a delay, thus canceling the icon's prompt.
                    // Note that the error icon is handled specially via _handleErrorIconMouseOver()
                    // and this does not set the _lastPromptIcon because there isn't a FormItemIcon
                    // object for the error icon.

                    if (!overIcon || (item._lastPromptIcon == null && overIcon != item.errorIconName)) {
                        item.handleMouseOver();
                    }
                }
            }

        // In this case we know the user has moved within an item's cell, title cell, or textBox.
        } else if (item) {

//            this.logWarn("overTitle:" + overTitle + ", overIcon: "+ overIcon);
            if (overTitle) item.handleTitleMove();
            else {
                // we may have moved between icons within the item's cell.
                if (lastOverIcon != overIcon) {
                    if (lastOverIcon) item._iconMouseOut(lastOverIcon);
                    if (overIcon) item._iconMouseOver(overIcon);
                } else if (item) {
                    if (overIcon) item._iconMouseMove(overIcon);
                    item.handleMouseMove();
                }
            }
        }
    }
},

// Override 'handleMouseOver' / 'Out' / 'Move' to fire mouseOver / titleOver et al on
// form items.
handleMouseOver : function (event, eventInfo) {
    if (this.mouseOver && this.mouseOver(event, eventInfo) == false) return false;
    this._itemMouseEvent(this._getEventTargetItemInfo(event), isc.EH.MOUSE_OVER);
},

handleMouseMove : function (event, eventInfo) {
    // allow a form-level mouseMove handler to completely suppress item level handling.
    if (this.mouseMove && this.mouseMove(event,eventInfo) == false) return false;
    this._itemMouseEvent(this._getEventTargetItemInfo(event), isc.EH.MOUSE_MOVE);
},

handleMouseOut : function (event, eventInfo) {

    // Explicitly refresh / clear event.itemInfo so we don't have stale "overIcon" etc attributes
    var newTarget = event.target;
    if (isc.isA.DynamicForm(newTarget)) {
        event.itemInfo = newTarget._getEventTargetItemInfo(isc.EH.lastEvent);
    } else {
        event.itemInfo = {};
    }

    // We know if it's a mouseOut that there's no new item!

    this._itemMouseEvent({}, isc.EH.MOUSE_OUT);

    // If there's a form level mouseout handler, ensure we also fire it (and prevent bubbling
    // if appropriate)
    if (this.mouseOut && this.mouseOut(event,eventInfo) == false) return false;
},

// override handleMouseWheel() to stop bubbling if the user is scrolling a textAreaItem

handleMouseWheel : function (event, eventInfo) {
    var itemInfo = this._getEventTargetItemInfo(event),
        item = itemInfo.item;
    if (item && item._stopBubblingMouseWheelEvent(event, eventInfo)) return isc.EH.STOP_BUBBLING;
    return this.Super("handleMouseWheel", arguments);
},

//>    @method    dynamicForm.bubbleItemHandler()
//        Bubble an event up the nested item hierarchy for a particular item.
//        @group    event handling
//        @param    itemID            (number)            Global identifier for the item on which call the handler.
//        @param    handlerName        (String)            Name of the handler to call.
//        @param    [arg1]            (Any)                Optional argument to the call.
//        @param    [arg2]            (Any)                Optional argument to the call.
//        @param    [arg3]            (Any)                Optional argument to the call.
//        @param    [arg4]            (Any)                Optional argument to the call.
//<
bubbleItemHandler : function (itemID, handlerName, arg1, arg2, arg3, arg4) {

    var subItem = this.getItemById(itemID),
        result = null;

    for (; subItem != null; subItem = subItem.parentItem) {
        // if we don't directly hold this form item, don't attempt to send events to it

        if (subItem.form != this) continue;
        if (subItem[handlerName] != null && !isc.isA.Function(subItem[handlerName])) {
            isc.Func.replaceWithMethod(subItem, handlerName, "arg1,arg2,arg3,arg4");
        }

        if (subItem[handlerName] == null) {
            this.logWarn("handler:"+ handlerName + " is not present on itemID " + itemID);
            return false;
        }
        result = subItem[handlerName](arg1, arg2, arg3, arg4);

        // if result is false, bail from the handler!
        if (result == false) return result;
    }

    return result;
},

// helper for bubbling inactiveEditorEvents
// the item will handle actually firing the appropriate named event if it exists
bubbleInactiveEditorEvent : function (item, eventName, itemInfo) {
    return this.bubbleItemHandler(item, "_handleInactiveEditorEvent",
                                    eventName, itemInfo.inactiveContext, itemInfo);
},

//>    @method    dynamicForm.elementChanged()
// Handle a change event from an element.
// <p>
// May cause the form to redraw if the item (or sub-item) has redrawOnChange turned on
//
//        @group    event handling
//
//        @param    itemID            (ItemID)    Reference to the (possibly nested) item that has changed.
//        @return    (boolean)            true == event should proceed normally, false == halt event
//<
elementChanged : function (itemID) {
    // bubble the elementChanged handler up through the item(s) specified.
    var result = this.bubbleItemHandler(itemID, "elementChanged", itemID);
    return (result != false);
},


// Override handleClick to fire click events on the item clicked.
handleClick : function (event, eventInfo) {
    var itemInfo =  this._getEventTargetItemInfo(event);

    var returnVal;
    if (itemInfo && itemInfo.item) {
        var item = itemInfo.item;
        // If the mouse went down over a *different* item, don't fire click on this
        // item.

        var mouseDownInfo = this._mouseDownTarget || {},
            mouseDownItem = this._mouseDownTarget ? this._mouseDownTarget.item : null;
        if (mouseDownItem == itemInfo.item) {
            returnVal = this.handleItemClick(itemInfo, mouseDownInfo);
            // remember the "clickTarget" - we'll check this in double-click
            this._clickTarget = this._mouseDownTarget;
        }
    }
    delete this._mouseDownTarget;
    if (returnVal == false || returnVal == isc.EH.STOP_BUBBLING) return returnVal;
    return this.Super("handleClick", arguments);
},

handleItemClick : function (itemInfo, mouseDownInfo) {
    var returnVal;

    var item = itemInfo.item;

    if (itemInfo.inactiveContext) {
        this.logInfo("Bubbling inactive editor event for " + item.ID, "EventHandler");
        returnVal = this.bubbleInactiveEditorEvent("click", item, itemInfo);
    } else {
        if (this._mouseDownTarget.overTitle && itemInfo.overTitle) {
            this.logInfo("Bubbling handleTitleClick event for " + item.ID, "EventHandler");
            returnVal = this.bubbleItemHandler(item, "handleTitleClick", item);
        } else {

            // If we're over the item itself (essentially the element / text box, or picker),
            // fire click
            // SpacerItem is a special case...
            var isSpacer = item.isA("SpacerItem"),
                overItem = isSpacer || (itemInfo.overElement || itemInfo.overTextBox || itemInfo.overControlTable),
                wasOverItem = isSpacer || (mouseDownInfo.overElement || mouseDownInfo.overTextBox || mouseDownInfo.overControlTable)



            if (mouseDownInfo.overIcon && itemInfo.overIcon && (item.form == this)) {
                if (item._iconClick(itemInfo.overIcon) == false)
                    return false;
                // The picker is written into the main body of the item - other icons are not,
                // so don't fire the standard click handler for them.
                var icon = item.getIcon(itemInfo.overIcon);
                if (icon && icon.writeIntoItem) {
                    overItem = true;
                    wasOverItem = true;
                }
            }

            if (mouseDownInfo.overValueIcon && itemInfo.overValueIcon && (item.form == this)) {
                if (item.valueIconClick != null) {
                    if (item.valueIconClick(this, item, item.getValue()) === false) {
                        return false;
                    }
                }
            }

            if (overItem && wasOverItem) {
                this.logInfo("Bubbling handleClick event for " + item.ID, "EventHandler");
                if (this.bubbleItemHandler(item, "handleClick", item) == false) {
                    returnVal = false;
                }
            }

            if (returnVal != false) {
                // fire cellClick (in addition to click where appropriate unless handleClick() returned
                // false).
                this.logInfo("Bubbling handleCellClick event for " + item.ID, "EventHandler");
                returnVal = this.bubbleItemHandler(item, "handleCellClick", item);
            }
        }
    }
    return returnVal;
},

// Override handleDoubleClick to fire doubleclick events on the item clicked.
handleDoubleClick : function (event, eventInfo) {
    var itemInfo =  this._getEventTargetItemInfo(event),
        mouseDownInfo = this._mouseDownTarget,
        clickInfo = this._clickTarget;
    var returnVal;
    if (itemInfo && itemInfo.item &&
        mouseDownInfo && (mouseDownInfo.item == itemInfo.item))
    {
        if (clickInfo && (clickInfo.item == itemInfo.item)) {
            var item = itemInfo.item;
            if (itemInfo.inactiveContext) {
                returnVal = this.bubbleInactiveEditorEvent(item, "doubleClick", itemInfo);
            } else if (itemInfo.overTitle && mouseDownInfo.overTitle) {
                returnVal = this.bubbleItemHandler(item, "handleTitleDoubleClick", item);
            } else {

                // If we're over the item itself (essentially the element / text box, or picker),
                // fire click
                var overItem = (itemInfo.overElement || itemInfo.overTextBox
                                 || itemInfo.overControlTable),
                    wasOverItem = (mouseDownInfo.overElement || mouseDownInfo.overTextBox
                                 || mouseDownInfo.overControlTable)


                if (itemInfo.overIcon && mouseDownInfo.overIcon) {
                    if (item._iconClick(itemInfo.overIcon) == false) return false;
                    // The picker is written into the main body of the item - other icons are not,
                    // so don't fire the standard click handler for them.
                    var icon = item.getIcon(itemInfo.overIcon);
                    if (icon && icon.writeIntoItem) {
                        overItem = true;
                        wasOverItem = true;
                    }
                }

                if (overItem && wasOverItem) {
                    if (this.bubbleItemHandler(item, "handleDoubleClick", item) == false) {
                        returnVal = false;
                    }
                }
                if (returnVal != false) {
                    // fire cellClick (in addition to click where appropriate unless handleClick() returned
                    // false).
                    returnVal = this.bubbleItemHandler(item, "handleCellDoubleClick", item);
                }
            }
        } else {
            // If the user double clicked with the first click landing in a different
            // item, fire a click on the second item here.
            returnVal = this.handleItemClick(itemInfo, mouseDownInfo || {});
        }
    }
    delete this._mouseDownTarget;
    delete this._clickTarget;

    if (returnVal == false || returnVal == isc.EH.STOP_BUBBLING) return returnVal;
    return this.Super("handleDoubleClick", arguments);
},

handleShowContextMenu : function (event, eventInfo) {
    var itemInfo =  this._getEventTargetItemInfo(event);

    var returnVal;
    if (itemInfo != null && itemInfo.item != null) {

        if (itemInfo.overIcon && isc.Browser.isTouch) returnVal = false;
        else {
            var item = itemInfo.item;
            if (item) {
                // fire the stringMethods, first on the item, then on the form, unless the item
                // cancels by returning false
                if (item.handleShowContextMenu) {
                    returnVal = item.handleShowContextMenu();
                }
                if (returnVal != false && this.showItemContextMenu) {
                    returnVal = this.showItemContextMenu(item);
                }
            }
        }
    }
    if (returnVal == false || returnVal == isc.EH.STOP_BUBBLING) return returnVal;
    return this.Super("handleShowContextMenu", arguments);
},

// Override handleFocusIn() and handleFocusOut() to fire item-level focus/blur notifications
handleFocusIn : function (element, event) {

    var focusedInItem = false;
    if (isc.EH.synchronousFocusNotifications && element != null) {
        var itemInfo = isc.DynamicForm._getItemInfoFromElement(element, this);
        var item = itemInfo ? itemInfo.item : null;
        if (item && !item.disabled) {
            // focusIn occurred on the focus handler - fire standard item focus handling

            if (element == item.getFocusElement()) {
                isc.FormItem.__nativeFocusHandler(element);
                focusedInItem = true;
            // If focus was given to an icon, we also need to fire item level
            // notifications for icon focus

            } else if (itemInfo.overIcon != null) {
                item._iconFocus(itemInfo.overIcon, element)
                focusedInItem = true;
            }
        }
    }
    if (!focusedInItem) {

        this.logDebug("DynamicForm.handleFocusIn(): Received focusin notification for element:" +
                element + ". This doesn't appear to be a focus target for an item, so simply " +
                "recording the event as a widget-level focus on the form itself.", "nativeFocusIn");

        return this.Super("handleFocusIn", arguments);
    }
},

handleFocusOut : function (element, event) {

    var blurredItem = false;
    if (isc.EH.synchronousFocusNotifications && element != null) {

        var itemInfo = isc.DynamicForm._getItemInfoFromElement(element, this),
            item = itemInfo ? itemInfo.item : null;

        if (item) {

            if (element == item.getFocusElement()) {
                isc.FormItem.__nativeBlurHandler(element);
                blurredItem = true;

            } else if (itemInfo.overIcon != null) {
                item._iconBlur(itemInfo.overIcon, element)
                blurredItem = true;
            }
        }
    }
    if (!blurredItem) {
        this.logDebug("DynamicForm.handleFocusOut(): Received focusout notification for element:" +
                element + ". This doesn't appear to be a focus target for an item, so simply " +
                "recording the event as a widget-level blur on the form itself.", "nativeFocusIn");

        return this.Super("handleFocusOut", arguments);
    }
},

//>    @method    dynamicForm.elementFocus()    (A)
// Event fired when the keyboard focus goes to a particular item
// <P>
// Fired from the native focus event on form items.<br>
// This method fires the formItem.elementFocus handler, which will also fire any developer-
// specified focus handler on the appropriate item(s).
//
//        @group eventHandling, focus
//
//        @param    itemID     (ItemID)    item that been focused.
//        @return    (boolean)  true == event should proceed normally, false == halt event
//<
elementFocus : function (element, itemID) {
    var item = this.getItemById(itemID);

    // Set the ISC focus element to this

    if (!this.hasFocus) {
        isc.EventHandler.focusInCanvas(this,null,item);
    }

    var focusItemInfo = isc.DynamicForm._getItemInfoFromElement(element, this);
    var itemIcon = focusItemInfo.overIcon;

    // call setFocusItem on the inner-most item that was focused

    this.setFocusItem(item, itemIcon);

    // bubble the "elementFocus" event up through the event handler(s) for the element
    var result = true,
        suppressHandler = false;

    if (this.__suppressFocusHandler != null) {
        // Catch the case where we get an onfocus handler from a different item to the one
        // on which we are suppressing elementFocus() - this can happen if when focus w/o
        // handler was fired the item already had focus, so its onfocus handler never fired.
        if (this.__suppressFocusItem != item) {

            delete this.__suppressFocusHandler;
            delete this.__suppressFocusItem;
        } else {
            suppressHandler = true;
            this.__suppressFocusHandler -=1;
            if (this.__suppressFocusHandler < 0) {
                delete this.__suppressFocusHandler;
                delete this.__suppressFocusItem;
            }
        }
    }

    result = this.bubbleItemHandler(itemID, "elementFocus", suppressHandler);

    return (result != false);
},

//>    @method    dynamicForm.elementBlur()    (A)
// Event fired when the keyboard blurs from a particular item
// <P>
// If the item has a "blur" handler, this will be fired automatically
//
// @group eventHandling, focus
//
//        @param    itemID    (ItemID)  item that has blurred
//        @return    (boolean)           true == event should proceed normally, false == halt event
//<
elementBlur : function (element, itemID)  {
    if (!isc.isA.FormItem(this.getItemById(itemID))) return;

    // bubble the "elementBlur" event up through the event handler(s) for the element

    var result = true;
    if (this.__suppressBlurHandler == null) result = this.bubbleItemHandler(itemID, "elementBlur");
    else {
        this.__suppressBlurHandler -=1;
        if (this.__suppressBlurHandler < 0) delete this.__suppressBlurHandler;
    }

    // clear any prompt shown from the item
    this.clearPrompt();



    return (result != false);
},



_shouldSaveOnEnter:function () {
    return this.saveOnEnter;
},

_$Enter:"Enter",
_$Backspace:"Backspace",
handleKeyPress : function (event, eventInfo) {
    var EH = this.ns.EH,
        keyName = EH.getKey(event);

    // Special case for Enter keypress: If this.saveOnEnter is true, and the enter keypress
    // occurred in a text item, auto-submit the form
    if (keyName === this._$Enter) {
        if (this._shouldSaveOnEnter()) {
            var item = this.getFocusSubItem();
            // Note that this.submit() will call this.saveData() unless this.canSubmit is true
            if (item && item.shouldSaveOnEnter()) {
                // if the item should update it's parent, do that now - needed for items with
                // a child textItem, like Date/Time/DateTime items
                if (item._shouldUpdateParentItem && item.parentItem) item.parentItem.updateValue();
                this.submit();
            }
            // we always return STOP_BUBBLING on enter keypress (handled below) which is
            // appropriate.
        }
    }

    var revertValueKey = this.revertValueKey,
        focusSubItem = this.getFocusSubItem();
    if (focusSubItem != null &&
        revertValueKey != null &&
        EH._matchesKeyIdentifier(revertValueKey, event))
    {
        var item = focusSubItem;
        while (item.parentItem != null) item = item.parentItem;

        item.storeValue(item._getOldValue(), true);

        // Also clear any hover in case the old value hover is showing.
        isc.Hover.clear();
    }


    if (keyName === this._$Backspace &&
        !isc.DynamicForm.canEditField(focusSubItem, this))
    {
        return false;
    }

    return this.Super("handleKeyPress", arguments);
},

// handleItemKeyPress: Called directly from the formItem keypress handler. Fires the
// 'itemKeypress' notification.
// Note that formItems swallow keypress events for a lot of keys, meaning we won't necessarily
// see a standard canvas "handleKeyPress" even if this method fires
handleItemKeyPress : function (item, keyName, characterValue) {
    if (this.itemKeyPress != null) {
        return this.itemKeyPress(item , keyName , characterValue);
    }
},

// Item Hover HTML
// --------------------------------------------------------------------------------------------

//>@method  dynamicForm.itemHoverHTML()     (A)
//  Retrieves the HTML to display in a hover canvas when the user holds the mouse pointer over
//  some item.  Return null to suppress the hover canvas altogether.<br>
//  Default implementation returns the prompt for the item if defined.<br>
//  Can be overridden via <code>item.itemHoverHTML()</code>
//
//  @group Hovers
//  @see FormItem.prompt
//  @see FormItem.itemHoverHTML()
//  @param item (FormItem)  Item the user is hovering over.
//  @visibility external
//<
itemHoverHTML : isc.DynamicForm._defaultItemHoverHTMLImpl,

//>@method  dynamicForm.titleHoverHTML()     (A)
//  Retrieves the HTML to display in a hover canvas when the user holds the mouse pointer over
//  some item's title.  Return null to suppress the hover canvas altogether.<br>
//  Default implementation returns the prompt for the item if defined.  If no prompt is defined
//  and the item title is clipped, the item title will be shown in a hover by default.<br>
//  Can be overridden by +link{FormItem.titleHoverHTML()}.
//
//  @group Hovers
//  @see FormItem.prompt
//  @see FormItem.titleHoverHTML()
//  @param item (FormItem)  Item the user is hovering over.
//  @return (HTMLString) HTML to be displayed in the hover
//  @visibility external
//<
titleHoverHTML : function (item) {
    if (item.prompt) return item.prompt;
    if (item.showClippedTitleOnHover && this.shouldClipTitle(item) &&
        this.titleClipped(item))
    {
        return item.getTitle();
    }
},

//>@method  dynamicForm.valueHoverHTML()     (A)
//  Retrieves the HTML to display in a hover canvas when the user holds the mousepointer over
//  some item's value.  Return null to suppress the hover canvas altogether.<br>
//  Can be overridden by +link{FormItem.valueHoverHTML()}.
//
//  @group Hovers
//  @see FormItem.valueHoverHTML()
//  @param item (FormItem)  Item the user is hovering over.
//  @visibility external
//<
valueHoverHTML : isc.DynamicForm._defaultValueHoverHTMLImpl,

// Method to actually show the Hover - called from the item when the user has hovered over
// the item.
_showItemHover : function (item, HTML) {
    if (HTML && !isc.is.emptyString(HTML) && item.showHover != false) {
        var properties = this._getItemHoverProperties(item);
        isc.Hover.showForTargetMouseOver(HTML, properties, (item.hoverRect || this.itemHoverRect));
    } else isc.Hover.clearForTargetMouseOut();
},

// Properties to apply to the hover shown for some item.
_getItemHoverProperties : function (item) {
    if (!isc.isA.FormItem(item)) item = this.getItem(item);
    while (item.parentItem != null) item = item.parentItem;

    // Determine whether the hover is being applied to a title, or icon
    var event = isc.EH.lastEvent;
    var itemInfo = this._getEventTargetItemInfo(event);
    var icon = itemInfo.overIcon ? item.getIcon(itemInfo.overIcon) : null,
        overTitle = itemInfo.overTitle;

    var props = this._getHoverProperties();
    if (item) {
        props = isc.addProperties(props, {
            align: (item.hoverAlign != null ? item.hoverAlign : this.itemHoverAlign),
            hoverDelay: (item.hoverDelay != null ? item.hoverDelay : this.itemHoverDelay),
            height: (item.hoverHeight != null ? item.hoverHeight : this.itemHoverHeight),
            opacity: (item.hoverOpacity != null ? item.hoverOpacity : this.itemHoverOpacity),
            baseStyle: (item.hoverStyle != null ? item.hoverStyle : this.itemHoverStyle),
            showHover: (item.showHover != null ? item.showHover : this.showHover),
            valign: (item.hoverVAlign != null ? item.hoverVAlign : this.itemHoverVAlign),
            width: (item.hoverWidth != null ? item.hoverWidth : this.itemHoverWidth),
            wrap: (item.hoverWrap != null ? item.hoverWrap : this.itemHoverWrap),
            autoFitWidth: (item.hoverAutoFitWidth != null ? item.hoverAutoFitWidth :
                this.itemHoverAutoFitWidth != null ? this.itemHoverAutoFitWidth :
                this.hoverAutoFitWidth),
            autoFitMaxWidth: (item.hoverAutoFitMaxWidth || this.itemHoverAutoFitMaxWidth ||
                this.hoverAutoFitMaxWidth),
            focusKey: item.hasOwnProperty("hoverFocusKey") ? item.hoverFocusKey :
                this.hoverFocusKey,
            persistent: item.hasOwnProperty("hoverPersist") ? item.hoverPersist :
                this.hoverPersist
        });
    } else {
        props = isc.addProperties(props, {
            align: this.hoverAlign,
            hoverDelay: this.hoverDelay,
            height: this.hoverHeight,
            opacity: this.hoverOpacity,
            baseStyle: this.hoverStyle,
            valign: this.hoverVAlign,
            width: this.hoverWidth,
            autoFitWidth: this.itemHoverAutoFitWidth != null ? this.itemHoverAutoFitWidth :
                this.hoverAutoFitWidth,
            autoFitMaxWidth: this.itemHoverAutoFitMaxWidth || this.hoverAutoFitMaxWidth,
            focusKey: this.hoverFocusKey,
            persistent: this.hoverPersist
        });
    }

    // Customizations for specific items / parts

    // Hover focus key: Support item.hoverFocusKey, form.titleHoverFocusKey, item.titleHoverFocusKey
    // Used by componentEditor / VB

    var undef;
    if (item.hoverFocusKey !== undef) {
        props.focusKey = item.hoverFocusKey;
    }
    if (overTitle) {
        if (item.titleHoverFocusKey !== undef) props.focusKey = item.titleHoverFocusKey;
        else if (this.titleHoverFocusKey !== undef) props.focusKey = this.titleHoverFocusKey;
    }


    // Allow different icon hoverStyle from the item. Not doc'd and used only by VB.
    if (icon && item.iconHoverStyle) props.baseStyle = item.iconHoverStyle;



    props.moveWithMouse = this.hoverMoveWithMouse;

    return props;
},

// Item Prompts
// --------------------------------------------------------------------------------------------



//>    @method    dynamicForm.showPrompt()    (A)
//        @group    prompt
//            Show a prompt (as dictated by an item, say).
//
//        @param    prompt    (String)            Prompt to show.
//<
showPrompt : function (prompt) {
    window.status = prompt;
},

//>    @method    dynamicForm.clearPrompt()    (A)
//        @group    prompt
//            Clear any form prompt currently showing.
//
//<
clearPrompt : function () {
    window.status = "";
},

// Queries on form properties
// --------------------------------------------------------------------------------------------


// returns true if the form encoding is set to multipart, false otherwise
isMultipart : function () {
    // normal is the default setting; if encoding is set to a value other than this, assume
    // multipart encoding is desired
    return !(this.encoding == isc.DynamicForm.NORMAL ||
             this.encoding == isc.DynamicForm.NORMAL_ENCODING);
},

// Drag and drop
// ---------------------------------------------------------------------------------------

itemIsLastInRow : function (item, rowNum) {
    var rowTable=this.items._rowTable,
        row = rowTable[rowNum],
        index = this.getItems().indexOf(item);

    if (!row || index < 0) return false;

    if (row[this.numCols-1] == index) return true;
    return false;
},

getColumnWidths : function () {
    var rowTable=this.items._rowTable,
        widths = [];

    widths.length = this.numCols;
    // Init the widths array to zeroes to make the population loop simpler
    for (var j = 0; j < widths.length; j++) widths[j] = 0;

    for (var rowCount = 0; rowCount < rowTable.length; rowCount++) {
        var row = rowTable[rowCount];
        for (var i = 0; i < row.length; i++) {
            var item = this.items.get(row[i]);
            if (item.colSpan && item.colSpan > 1) continue;
            if (item.showTitle &&
                  (this.titleOrientation == "left" || !this.titleOrientation)) {
                if (item.getVisibleTitleWidth() > widths[i]) {
                    widths[i] = item.getVisibleTitleWidth();
                }
                i++;
            }
            if (item.width > widths[i]) widths[i] = item.width;
            if (item.showTitle && item.titleOrientation == "right" &&
                  item.getVisibleTitleWidth() > widths[i+1]) {
                widths[++i] = item.getVisibleTitleWidth();
            }
        }
    }
    return widths;
},

getItemTableOffsets : function (item, overrideRowTable) {
    var rowTable = overrideRowTable || this.items._rowTable,
        itemIndex = this.getItems().indexOf(item),
        result = {};

    result.itemIndex = itemIndex

    for (var rowCount = 0; rowCount < rowTable.length; rowCount++) {
        var row = rowTable[rowCount],
            start = row.indexOf(itemIndex),
            end = row.lastIndexOf(itemIndex);

        if (start > -1 && end > -1) {
            if (!result.left || start < result.left) result.left = start;
            if (!result.width || result.width < end - start) result.width = end - start+1;
            if (!result.top || rowCount < result.top) result.top = rowCount;
            if (!result.height || result.height < rowCount - result.top) {
                result.height = rowCount - result.top + 1;
            }
        }
    }

    return result;
},

getItemDropIndex : function (item, dropSide) {
    if (!item) return;
    if (!dropSide) dropSide = "L"; // by default, drop at item.itemIndex

    var offsets = this.getItemTableOffsets(item),
        rowTable = this.items._rowTable;

    if (dropSide == "L") return offsets.itemIndex;
    if (dropSide == "R") {
        if (this.itemIsLastInRow(item) && this.canAddColumns != true) {
            // This isn't really a special case in terms of item drop index - it might end up
            // in new column k rather than wrapping to old column j, but it will still be in
            // index position n.  Leaving in place in case it turns out that something special
            // *is* needed when we have the ability to auto-add columns
            return offsets.itemIndex+1;
        }
        return offsets.itemIndex+1;
    }
    if (dropSide == "T") {
        // if dropping above the top row, drop at the mouse location
        return this.getItemIndexAtTableLocation(
            offsets.top - (offsets.top==0 ? 0 : 1), offsets.left
            );
    }
    if (dropSide == "B") {
        var bottom = offsets.top + offsets.height - 1;
        var itemIndex = this.getItemIndexAtTableLocation(bottom + 1, offsets.left);
        if (itemIndex == null) {
            itemIndex = this.items.length;
        }
        return itemIndex;
    }
},

getItemIndexAtTableLocation : function (rowNum, colNum) {
    var rowTable=this.items._rowTable;

    if (!rowTable[rowNum]) return;
    return rowTable[rowNum][colNum];
},

getItemAtPageOffset : function (x, y) {
    // FIXME - should really cache this value as we're called from mouse movement events, but
    // the caching that was in place was hanging on to stale values
    this.items._currentColWidths = this.getColumnWidths();
    var rowTable=this.items._rowTable,
        widths=this.items._currentColWidths,
        heights=this.items._rowHeights;

    var colNum = this.inWhichPosition(widths,x-this.getPageLeft()),
        rowNum = this.inWhichPosition(heights,y-this.getPageTop());

    colNum = colNum == -1 ? 0 : colNum == -2 ? widths.length : colNum;
    rowNum = rowNum == -1 ? 0 : rowNum == -2 ? heights.length : rowNum;

    if (!rowTable[rowNum]) return null;

    var itemIndex = rowTable[rowNum][colNum],
        item = this.getItem(itemIndex);

    if (item!=null) {
        item._dragRowNum = rowNum;
        item._dragColNum = colNum;
        item._dragItemIndex = itemIndex;
    }

    return item;
},

getNearestItem : function (x, y) {

    var shortest = 9999999999,
        nearestItem;

    this.logDebug("Computing nearest item to (" + x + "," + y + ")", "formItemDragDrop");

    for (var i = 0; i < this.items.length; i++) {
        var item = this.items[i];
        var area = item.getPageRect(true),  // "true" = return a rect including the title
            left = area[0],
            top = area[1],
            width = area[2],
            height = area[3],
            xDelta = 0,
            yDelta = 0;
        if (x >= left && x <= left+width &&
            y >= top && y <= top+height)
        {
            // The cursor is inside this item, so it's obviously the nearest!
            return item;
        }
        if (x > left) {
            if (x > left+width) {
                xDelta = x - (left+width);
            }
        } else {
            xDelta = left - x;
        }
        if (y > top) {
            if (y > top+height) {
                yDelta = y - (top+height);
            }
        } else {
            yDelta = top - y;
        }

        // Compute the straight-line distance to the nearest point of the item's area
        var distance = Math.sqrt(xDelta*xDelta + yDelta*yDelta);

        this.logDebug("Item " + item.name + ": (l,t,w,h) = " + area, "formItemDragDrop");
        this.logDebug("XDelta: " + xDelta + ", yDelta: " + yDelta +
            ", straight line distance: " + distance, "formItemDragDrop");

        if (distance < shortest) {
            this.logDebug("Item " + item.name + ": distance is shorter than " + shortest +
                ", it is now the nearest item", "formItemDragDrop");
            shortest = distance;
            nearestItem = item;
        }
    }

    return nearestItem;
},

dragLineStyle: "dragLine",
showDragLineForItem : function (item, mouseX, mouseY) {
    // make sure the drag line is set up
    this.makeDragLine();

    if (!item) {
        this._dragLine.hide();
        return;
    }

    var itemRect = item.getPageRect(),
        left = itemRect[0],
        top = itemRect[1],
        width = itemRect[2],
        height = item.getVisibleHeight(),
        titlesAt = this.titleOrientation || "left",
        styleName = this.dragLineStyle;

    if (item.showTitle!=false) {
        if (titlesAt == "left" || titlesAt == "right") width +=  item.getVisibleTitleWidth();
        if (titlesAt == "left") left -=  item.getVisibleTitleWidth();
    }

    // Dropping to the right of an item is a special case - we should always show the right-
    // hand dropLine
    var toRight;

    if (mouseX <= left) mouseX = left+1;
    else if (mouseX >= left+width) {
        mouseX = left+width-1;
        toRight = true;
    }

    // Favor top/bottom unless we are within a certain number of pixels of the left or right
    // edge.  This will be 20 pixels or a quarter of the widget width, whichever is the
    // smaller
    var sideExtent = width / 4;
    if (sideExtent > 20) sideExtent = 20;

    if (mouseY <= top) mouseY = top+1;
    else if (mouseY >= top+height) mouseY = top+height-1;

    var lOffset = mouseX - left, lPercent = Math.round(width / lOffset),
        tOffset = mouseY - top, tPercent = Math.round(height / tOffset),
        rOffset = (left+width)-mouseX, rPercent = Math.round(width / rOffset),
        bOffset = (top+height)-mouseY, bPercent = Math.round(height / bOffset),
        side,
        lineHeight, lineWidth, lineLeft, lineTop;

    left--; top--;

    if (toRight || (Math.min(lPercent, rPercent) < Math.min(tPercent, bPercent) &&
                   ((lPercent > rPercent && lOffset < sideExtent) ||
                    (rPercent > lPercent && rOffset < sideExtent)))) {
        // it's left or right, so vertical line
        side = toRight ? "R" : lPercent > rPercent ? "L" : "R";
        lineWidth = 3;
        lineHeight = height;
        lineLeft = side == "L" ? left : left+width-1;
        lineTop = top;
        styleName = this.dragLineStyle + "Vertical";
    }

    if ((item.endRow && side == "R") || (item.startRow && side == "L")) {
        // Targeting L/R beside an item that starts/ends row. Cannot do that
        side = null;
        // Let T/B handle it
    }

    if (!side) {
        // it's top or bottom, so horizontal line
        side = tPercent > bPercent ? "T" : "B";
        lineWidth = width;
        lineLeft = left;
        lineHeight = 3;
        lineTop = side == "T" ? top : top+height-1;
        styleName = this.dragLineStyle;
    }

    item.dropSide = side;

    if (this.itemIsLastInRow(item, item._dragRowNum) && !this.canAddColumns && item.dropSide == "R") {
        // if the item is the last in the row and this.canAddColumns is false, show the noDrop cursor
        this.hideDragLine();
        this.setNoDropIndicator();

        this._oldCursor = this.currentCursor;
        this.setCursor("not-allowed");
    }
    else {
        if (this._noDropIndicatorSet) {
            this.clearNoDropIndicator()
            this.setCursor(this._oldCursor);
        }

        var dims = {left: lineLeft, top: lineTop};
        this.adjustDragLinePosition(dims, item, side);
        lineLeft = dims.left;
        lineTop = dims.top;

        this._dragLine.setStyleName(styleName);
        // resize and reposition the dragLine appropriately
        this._dragLine.resizeTo(lineWidth, lineHeight);
        this._dragLine.setPageRect(lineLeft, lineTop);
        // and stick it on top of everything else
        this._dragLine.bringToFront();
        this._dragLine.show();
    }
},

// Adjust the line position so it doesn't appear that we have two different drop positions (ie,
// to the right of item n and to the left of item n+1).  In fact we DO have these two distinct
// drop positions, but they result in the same thing happening
adjustDragLinePosition : function (dims, item, side) {
    var rowTable = this.items._rowTable,
        index = this.items.indexOf(item),
        row,
        colFrom, colTo;

    for (var i = 0; i < rowTable.length; i++) {
        if (rowTable[i].indexOf(index) != -1) {
            row = i;
            colFrom = rowTable[i].indexOf(index);
            colTo = rowTable[i].lastIndexOf(index);
            break;
        }
    }

    if (row == null || colFrom == null || colTo == null) return;

    if (side == "T") {
        if (row == 0) return;
        if (rowTable[row-1][colFrom] == rowTable[row-1][colTo] &&
            rowTable[row-1][colFrom-1] != rowTable[row-1][colFrom] &&
            rowTable[row-1][colTo+1] != rowTable[row-1][colFrom])
        {
            var rect = this.items[rowTable[row-1][colFrom]].getPageRect(true);
            var otherY = rect[1] + rect[3];
            dims.top -= Math.round((dims.top - otherY) / 2);
        }
    }

    if (side == "B") {
        if (row == rowTable.length - 1) return;
        if (rowTable[row+1][colFrom] == rowTable[row+1][colTo] &&
            rowTable[row+1][colFrom-1] != rowTable[row+1][colFrom] &&
            rowTable[row+1][colTo+1] != rowTable[row+1][colFrom])
        {
            var rect = this.items[rowTable[row+1][colFrom]].getPageRect(true);
            var otherY = rect[1];
            dims.top += Math.round((otherY - dims.top) / 2);
        }
    }

    if (side == "L") {
        if (colFrom == 0) return;
        // Need support for row-spanning columns here
        var rect = this.items[rowTable[row][colFrom-1]].getPageRect(true);
        var otherX = rect[0] + rect[2];
        dims.left -= Math.round((dims.left - otherX) / 2);
    }

    if (side == "R") {
        if (colTo == rowTable[row].length - 1) return;
        // Need support for row-spanning columns here
        var rect = this.items[rowTable[row][colTo+1]].getPageRect(true);
        var otherX = rect[0];
        dims.left += Math.round((otherX - dims.left) / 2);
    }
},

showDragLineForForm : function () {
    // make sure the drag line is set up
    this.makeDragLine();
    this._dragLine.setStyleName(this.dragLineStyle + "Vertical");
    this._dragLine.resizeTo(3, this.getHeight());
    this._dragLine.setPageRect(this.getPageLeft(), this.getPageTop());
    this._dragLine.bringToFront();
    this._dragLine.show();
},

// Field hide/show, enable/disable
// ---------------------------------------------------------------------------------------
// The following enable/disable and show/hide methods are overrides of DBC

enableField : function (fieldName) {
    if (fieldName == null || isc.isAn.emptyString(fieldName)) return;

    var item = this.getItem(fieldName);
    if (item) item.enable();
},

disableField : function (fieldName) {
    if (fieldName == null || isc.isAn.emptyString(fieldName)) return;

    var item = this.getItem(fieldName);
    if (item) item.disable();
},

showField : function (fieldName) {
    if (fieldName == null || isc.isAn.emptyString(fieldName)) return;

    var item = this.getItem(fieldName);
    if (item) item.show();
},

hideField : function (fieldName) {
    if (fieldName == null || isc.isAn.emptyString(fieldName)) return;

    var item = this.getItem(fieldName);
    if (item) item.hide();
},

// A form's "selection chain" is the chain of selectionComponents that control what part of
// a complex nested structure the form is currently editing.  For a form that is editing a
// row from a nested list, this "chain" will consist of one component - it doesn't become a
// chain until we get to lists nested within lists, at which point we can only sensibly decide
// what data the form is editing if we know which record is selected in the outer list *as well
// as* which record is selected in the inner list
//
// This helper method actually returns an array consisting of the indices of selected records
// that describe this form's current position in the data hierarchy, from top to bottom.
getSelectionChain : function () {
    if (!this.selectionComponent) return [];
    var selComponents = [];
    var work = this;
    while (work.selectionComponent) {
        selComponents.add(work.selectionComponent);
        work = work.selectionComponent;
    }
    var indices = [];
    for (var i = selComponents.length - 1; i >= 0; i--) {
        indices.add(selComponents[i].getRecordIndex(selComponents[i].getSelectedRecord()));
    }
    return indices;
},

//> @method dynamicForm.setCanEdit
// Is this form editable or read-only? Setting the form to non-editable causes all
// form items to render as read-only unless a form item is specifically marked as editable
// (the item's +link{formItem.canEdit,canEdit} attribute is <code>true</code>).
//
// @param canEdit (boolean) Can this form be edited?
// @group readOnly
// @see dynamicForm.canEdit
// @visibility external
//<
setCanEdit : function (newValue) {
    this.canEdit = newValue;

    var willRedraw = this.isDrawn();

    // Call updateCanEdit() on our items.
    var items = this.getItems();
    if (items != null) {
        for (var i = 0, len = items.length; i < len; ++i) {
            var item = items[i];

            item.updateCanEdit(willRedraw);
        }
    }

    if (willRedraw) this.markForRedraw("setCanEdit");
},

// Override setFieldCanEdit to setCanEdit on specific items.
setFieldCanEdit : function (fieldName, canEdit) {
    if (fieldName == null || isc.isAn.emptyString(fieldName)) return;

    var field = this.getField(fieldName);
    if (field) {
        if (field.setCanEdit) {
            field.setCanEdit(canEdit);
        } else {
            field.canEdit = canEdit;
            this.redraw();
        }
    }
},

//> @method dynamicForm.fieldIsEditable()
// Can the field be edited?  This method looks at +link{canEdit} for the grid as well as the
// +link{formItem.canEdit} value, to determine whether editing is actually allowed.
// For a detailed discussion, see the documentation at +link{canEdit}.
//
// @param field (FormItem | number | String)  field object or identifier
// @return      (boolean)                     whether field can be edited
//
// @group editing
// @visibility external
//<
fieldIsEditable : function (field) {
    if (!isc.isAn.Object(field)) field = this.getField(field);
    return field ? isc.DynamicForm.canEditField(field, this) : false;
},

//> @method dynamicForm.setReadOnlyDisplay()
// Setter for the +link{readOnlyDisplay} attribute.
// @param appearance (ReadOnlyDisplayAppearance) New read-only display appearance.
// @visibility external
//<
setReadOnlyDisplay : function (appearance) {
    this.readOnlyDisplay = appearance;

    var willRedraw = (this.canEdit == false && this.isDrawn());

    // Call updateReadOnlyDisplay() on our items.
    var items = this.getItems();
    if (items != null) {
        for (var i = 0, len = items.length; i < len; ++i) {
            var item = items[i];

            item.updateReadOnlyDisplay(willRedraw);
        }
    }

    if (willRedraw) this.markForRedraw("setReadOnlyDisplay");
},


// UI Summary for AI
// ---------------------------------------------------------------------------------------

_uiSummaryFieldProperties: isc.DynamicForm._addToSuperClassSummaryProps([
    "disabled"
], "_uiSummaryFieldProperties"),

_uiSummaryDataPropertyName: "values",

getUISummary : function (settings, hierarchyExcluded, thisCanvasExcluded) {
    var summary = this.Super("getUISummary", arguments);

    for (var i = 0; i < this.items.length; i++) {
        var item = this.items[i],
            pickList = item.pickList;
        if (pickList && pickList.formItem == item &&
            pickList.isDrawn() && pickList.isVisible())
        {
            summary.dropDownItem = item.name || i;
            summary.dropDownMenu = pickList.getUISummary(settings, hierarchyExcluded);
            break;
        }
    }
    return summary;
},

_getFieldUISummary : function (formItem, dsField, index, settings) {
    var fieldSummary = this.Super("_getFieldUISummary", arguments);
    if (formItem.hasErrors()) fieldSummary.hasErrors = true;

    // all formItems will be included if focused so mark hidden items
    if (settings.focusComponent == this) {
        if (!this.fieldShouldBeVisible(formItem, index)) {
            fieldSummary.hidden = true;
        }
    }

    return fieldSummary;
}



});    // END isc.DynamicForm.addMethods()



// class methods
isc.DynamicForm.addClassMethods({


// Static method to put a series of items into order based on specified
// tab index (where present)

sortItemsIntoTabOrder : function (items, logTarget) {

    if (logTarget == null) logTarget = this;

    // We want to ensure the auto-allocated tabIndices don't collide with the explicitly
    // specified index of some other form item, so we can't just use items.indexOf(item) for
    // each item.
    var explicitTabIndexArray = [], warnedTIs = {};
    for (var i = 0; i < items.length; i++) {

        var item = items[i], ti = item.tabIndex;
        if (ti != null && ti != -1) {
            // Warn if we have explicit tabIndices that collide

            if (explicitTabIndexArray[ti] != null) {
                if (!warnedTIs[ti]) {
                    logTarget.logWarn("More than one item in this form have an explicitly specified tabIndex of '"
                                + ti + "'. Tab order cannot be guaranteed within this form.");
                    // avoid warning over and over for the same tab index.
                    warnedTIs[ti] = true;
                }
                item._tabIndexCollision = true;
            }
            // Making a sparse array of previously assigned tabIndices.
            explicitTabIndexArray[ti] = item;
        }
    }

    // iterate through a second time actually setting up the local tabIndices
    // We'll do this by setting the local tabIndex to the index in the items array offset by
    // any tab-indices already explicitly populated.
    // (Start with an offset of 1 - we want to use 1-based rather than 0-based tab indices for
    // simplicity)
    var tabIndexOffset = 1,
        orderedItems = [];
    for (var i = 0; i < items.length; i++) {
        var item = items[i];
        // Don't increment the next tabIndex if:
        // - this item has not yet been initialized
        // - this item already has an explicit tabIndex
        // - it can't receive focus

        if (!isc.isA.FormItem(item)) {
            if (logTarget.logIsInfoEnabled("TabIndexManager"))
                logTarget.logInfo("dynamicForm.sortItemsIntoTabOrder() fired before all form items have been initialized"
                             + this.getStackTrace());

            continue;
        }
        if (item.tabIndex != null && !item._tabIndexCollision) {
            orderedItems[item.tabIndex] = item;
            continue;
        }

        tabIndexOffset += 1;
        // Avoid colliding with explicitly specified local tab indices
        while (explicitTabIndexArray[tabIndexOffset] != null) {
            tabIndexOffset += 1;
        }

        item._localTabIndex = tabIndexOffset;

        orderedItems[tabIndexOffset] = item;
    }
    return orderedItems;

},

defaultFieldType:"text",

// Avoid re-instantiating strings every time this method is run
_$link:"link", _$text:"text", _$select:"select", _$checkbox:"checkbox",
_$staticText:"staticText", _$boolean:"boolean", _$integer:"integer",
_$binary:"binary", _$blob:"blob", _$multifile:"multifile", _$multiupload:"multiupload",
_$upload:"upload", _$file:"file",
_$base64Binary: "base64Binary", _$enum:"enum", _$CycleItem:"CycleItem", _$selectOther:"selectOther",
_$relation:"relation", _$nestedEditor:"NestedEditorItem", _$nestedListEditor:"NestedListEditorItem",
_$imageFile:"imageFile", _$viewFileItem:"ViewFileItem",
_$section:"section", _$sectionItem:"SectionItem",
_$button:"button", _$buttonItem:"ButtonItem", _$formItem:"FormItem",
_$datetime:"datetime", _$DateTimeItem:"DateTimeItem",
getEditorType : function (field, widget, values) {

    // choosing which form item type to use:
    // Each field may consist of either entirely properties that were passed in, a mixture
    // of passed-in overrides and DataSource defaults, or entirely DataSource defaults.
    // - if "editorType" is present (or the legacy name "formItemType" for the same
    //   concept), use it regardless of whether it came from passed-in fields or from the
    //   DataSource defaults
    // - _constructor comes from XML translation.  When a field is specified as
    //      <TextItem name="foo" .../>
    //   .. _constructor will be "TextItem".  When a field is just specified as
    //      <field name="foo" type="text" .../>
    //   .. _constructor will have the value "FormItem", which we ignore because FormItem
    //   is an abstract base class, so we want to apply automatic item-choosing.
    if (field._constructor == isc.FormItem.Class) field._constructor = null;

    // Grab the DataSource (if any) for later use
    var ds = widget.getDataSource();

    var canEdit = this.canEditField(field,widget),
        defaultType = this.defaultFieldType,
        editorType = field.editorType
    ;

    if (isc.isA.Class(editorType)) {
        // we were passed a class, not a string - map to the class-name
        editorType = editorType.getClassName();
    }

    // items originating in SGWT may have FormItem as editorType - ignore
    if (editorType == this._$formItem) editorType = null;


    var useConstructor = !field.editNode || isc[field._constructor];

    // NOTE: "formItemType" is a legacy synonym of "editorType"
    var type = (canEdit == false && field.readOnlyEditorType) || editorType ||
               field.formItemType || (useConstructor && field._constructor);
    if (type == null) {
        type = widget && widget.getFieldType ? widget.getFieldType(field, values) : field.type;
    }

    if (type == null) type = defaultType;



    if ((canEdit == false && field.readOnlyEditorType) || editorType ||
        field.formItemType || field._constructor)
    {
        return type;
    }

    var currentType = type;
    var returnType = null;

    var isFileType = (type == this._$binary || type == this._$file || type == this._$imageFile);

    while (currentType) {
        // .. otherwise, "type" has been specified on its own without the more specific
        // "editorType", and could refer either to a data type or form item type.
        // For certain known data types, pick appropriate editors.
        if (type == this._$link) {
            // NOTE: Looking at the canEdit property directly here, because the canEditField()
            // method returns true if there is no explicit setting t5o switch editability off,
            // but for links we need the opposite behavior (they should only be editable if
            // the user code explicitly sets canEdit:true)
            if (this.canEditField(field, widget) && field.canEdit) returnType = this._$text;
            else returnType = this._$link;
        /*
        } else if (!canEdit && isFileType && field.canEdit == false) {

            // Default to using static text items for all canEdit:false fields regardless of data type
            // with the exception of links (which are already non editable)




            if (type == this._$binary || type == this._$file || type == this._$imageFile)
                returnType = this._$viewFileItem;
            // a couple of common special-cases to avoid converting to staticText
            else if (type != this._$section && type != this._$sectionItem &&
                     type != this._$button && type != this._$buttonItem)
            {
                returnType = this._$staticText;
            }
        */
        } else if (type == this._$boolean) {
            var map = field.valueMap;
            // assumption is that if a valueMap is provided, a boolean storage type
            // is being used for a field with two possible values but no obvious true/false
            // aspect, eg, Sex: Male/Female.  In this case, we should show a SelectItem rather
            // than eg a checkbox labeled "Sex"
            if (!isc.isAn.Array(map) && isc.isAn.Object(map)) returnType = this._$select;
            else returnType = this._$checkbox;
        } else if (type == this._$binary || type == this._$blob || type == this._$file ||
            type == this._$imageFile)
        {
            if (field.dataSource) returnType = this._$multifile
            else returnType = this._$file;
        } else if (type == this._$multiupload) {
            returnType = this._$multifile;
        } else if (type == this._$base64Binary) {
            returnType = this._$base64Binary;
        } else if (type == this._$enum) {
            // If we're just showing valueIcons and no type is specified, use a cycle-item rather
            // than a select.
            if (field.showValueIconOnly) returnType = this._$CycleItem
            else returnType = this._$select;
        } else if (isc.DataSource && isc.isA.DataSource(ds) && ds.fieldIsComplexType(field.name)) {
            // Note: if showComplexFields is false, fields of complexType declared in the
            // DataSource never make it to the form.
            returnType = field.multiple ? widget.nestedListEditorType : widget.nestedEditorType;
        } else if (type == this._$datetime) {
            // Need to explicitly translate "datetime" to "DateTimeItem" because of the different
            // casing of time/Time
            returnType = this._$DateTimeItem;
        } else {

            if (currentType && currentType != defaultType && currentType != this._$integer &&
                (currentType == this._$selectOther || (isc.FormItemFactory.getItemClass(currentType) != null)))
            {
                returnType = currentType;
            } else {
                currentType = isc.SimpleType.getType(currentType);
                if (returnType) {
                    break;
                } else if (currentType == null || currentType.inheritsFrom == null) {
                    // if field.type=="text" or field.type==null or field.type is not directly recognized by
                    // getItemClass():


                    // "text" is both a data type and a form item type.  We take it to mean the data
                    // type, and may pick a SelectItem or TextAreaItem instead of a TextItem.  This is
                    // the only case in which setting field.type to the short name of a FormItem type
                    // ("Item" suffix omitted) will not select that form item.  It can be avoided by
                    // setting editorType="text".
                    if (field.dataSource) {
                        // Use a relationItem for databound form items of unspecified type.
                        returnType = this._$relation;
                    } else if (field.valueMap || field.optionDataSource || field.displayField) {
                        // if a field has a valueMap, or an explicit optionDataSource / displayField
                        // [which is essentially a server-side valueMap]
                        // If we're showing valueIcons only, use CycleItem - otherwise default to "select"
                        returnType = (field.showValueIconOnly ? this._$CycleItem : this._$select);

                    } else if (widget &&
                               (field.length && field.length > widget.longTextEditorThreshold))
                    {
                        // for very large text fields, show a textArea.
                        returnType = widget.longTextEditorType;
                    } else {
                        // default anything else to text
                        returnType = defaultType;
                    }
                } else {
                    currentType = currentType.inheritsFrom;
                    type = currentType;
                    returnType = null;
                    continue;
                }
            }
        }
        break;
    }

    return returnType;
},

//> @attr dynamicForm.canEditFieldAttribute
// @include dataBoundComponent.canEditFieldAttribute
// @visibility external
//<

// _getItemInfoFromElement - given some DOM element, determine which (if any) item the
// element is a part of.
// Returns an object of the following format:
//  {item:[formItem object], overTitle:boolean, overElement:boolean }

_$id:"id",
_getItemInfoFromElement : function (target, form) {

    var handle = form ? form.getClipHandle() : document,
        itemInfo = {},
        overPickerIconCell,
        pickerCellTarget,

        containsItem = isc.DynamicForm._containsItem,

        itemPart = isc.DynamicForm._itemPart,

        elementString = isc.DynamicForm._element,
        textBoxString = isc.DynamicForm._textBoxString,
        controlTableString = isc.DynamicForm._controlTableString,
        inlineErrorString = isc.DynamicForm._inlineErrorString,
        pickerIconCellString = isc.DynamicForm._pickerIconCellString,
        titleString = isc.DynamicForm._title,
        eventPartString = "eventpart",
        valueIconString = "valueicon";

    // We mark form items' HTML elements with a 'containsItem' parameter so we can determine
    // which item we're looking at.
    // Iterate up the DOM from the target checking for this attr
    while (target && target != handle && target != document) {

        var itemID = target.getAttribute ? target.getAttribute(containsItem) : null;

        if (target.getAttribute &&
            (target.getAttribute(eventPartString) == valueIconString))
        {
            itemInfo.overValueIcon = true;
        }
        if (target.getAttribute &&
            (target.getAttribute(itemPart) == pickerIconCellString))
        {
            // save details of finding pickerIconCell. If final "over"
            // state is overControlTable this information will be used
            // to change state to appear as if the picker icon was
            // targeted.
            pickerCellTarget = target;
            overPickerIconCell = true;
        }

        if (itemID != null && !isc.isAn.emptyString(itemID)) {
            var item = window[itemID];
            // If the item is part of the given form and is not destroyed, then fill out itemInfo.
            if (item != null && !item.destroyed && (form == null || item.form === form)) {
                itemInfo.item = item;

                // catch the case where it's inactive itemHTML

                var inactiveContext = item._getInactiveContextFromElement(target);
                if (inactiveContext != null) {
                    if (this.logIsDebugEnabled("inactiveEditorHTML")) {
                        this.logDebug("Event occurred over inactive HTML for item:" + item +
                                " inactiveContext:" + this.echo(inactiveContext),
                                "inactiveEditorHTML");
                    }
                    itemInfo.inactiveContext = inactiveContext;
                }

                // We also hang an attribute describing which part of the item an element is
                // so we can determine whether we're looking at the item's title, element or
                // one of it's icons.
                // Options are:
                //  "element" - over a native element like an <input> box
                //  "title" - over the title cell
                //  "textbox" - over the textBox
                //  "controlTable" - control table
                //  Anything else assumed to be an icon ID

                var eventItemPart = target.getAttribute(itemPart);
                if (eventItemPart == elementString) itemInfo.overElement = true;
                else if (eventItemPart == titleString) itemInfo.overTitle = true;
                else if (eventItemPart == textBoxString)itemInfo.overTextBox = true;
                else if (eventItemPart == controlTableString) itemInfo.overControlTable = true;
                else if (eventItemPart == inlineErrorString) itemInfo.overInlineError = true;
                else if (eventItemPart && !isc.isAn.emptyString(eventItemPart))
                    itemInfo.overIcon = eventItemPart;
                // quit the loop so we can return the item info.
                break;
            }
        }

        target = target.parentNode;
    }

    if (overPickerIconCell && itemInfo.overControlTable) {

        target = this._getEventTargetForItemPart(pickerCellTarget);
        if (target != null) {
            var itemID = target.getAttribute ? target.getAttribute(containsItem) : null;
            var item = window[itemID];
            // If the item is part of the given form and is not destroyed, then fill out itemInfo.
            if (item != null && !item.destroyed && (form == null || item.form === form)) {
                var eventItemPart = target.getAttribute(itemPart);
                itemInfo.overIcon = eventItemPart;
                itemInfo.item = item;
                itemInfo.overPickerIconCell = true;
                delete itemInfo.overControlTable;
            }
        }
    }

    return itemInfo;
},

_getEventTargetForItemPart : function (parentNode) {
    var childNodes = parentNode.childNodes,
        itemPart = isc.DynamicForm._itemPart,
        result
    ;
    if (childNodes) {
        for (var i = 0; i < childNodes.length; i++) {
            var target = childNodes[i],
                eventItemPart = target.getAttribute(itemPart);
            if (eventItemPart && !isc.isAn.emptyString(eventItemPart)) {
                result = target;
                break;
            }
            result = this._getEventTargetForItemPart(target, eventItemPart);
            if (result != null) break;
        }
    }
    return result;
},

// helper used by the EventHandler; gets item associated with last event
_getEventTargetItem : function (event) {
    if (!event) event = isc.EH.lastEvent;

    // if cached item info is not set or is stale, recalculate it if target is a DynamicForm

    var target = event.target,
        info = event.itemInfo;
    if (isc.isA.DynamicForm(target) && (!info || event._itemInfoDOMevent != event.DOMevent)) {
        info = target._getEventTargetItemInfo(event);
    }

    // if a valid item is present that belongs to the event, return it
    return info && info.item && info.item.form == target ? info.item : null;
},

// Callable either on server-formatted errors or editor component format errors.
// Response:
//     { fieldName : {errorMessage: value, otherProp: value},
//       anotherFieldName : {errorMessage: value, otherProp: value},
//       ...
//     }
//   Note that error object {} can also be an array of error objects [{}, ...]
getSimpleErrors : function (errors) {
    // If error is in server format, transform the server error report format to the error
    // report expected by an editor component.  Server errors are formatted as:
    // [{ "recordPath" : pathString,
    //    fieldName : errors,
    //    anotherFieldName : errors,
    //  }]
    // Where pathString is a string representing the record (used for flat or hierarchical data
    // on the server).
    // And where the errors for each field have the format
    // { errorMessage : msg, resultingValue : value }
    // or
    // [{ errorMessage : msg, resultingValue : value },
    //  { errorMessage : msg, otherProp : value },  ... ]
    //
    // Editor components expect just { fieldName : errorMessage } - we drop
    // the resultingValue and other properties
    //
    var errorObjects = {};
    // note we support errors for only one row
    if (isc.isAn.Array(errors)) errors = errors[0];

    for (var fieldName in errors) {
        var fieldErrors = errors[fieldName];
        if (fieldName == "recordPath" && !isc.isAn.Object(fieldErrors)) continue;

        if (isc.isAn.Array(fieldErrors)) {
            errorObjects[fieldName] = [];
            for(var i = 0; i < fieldErrors.length; i++) {
                var error = fieldErrors[i];
                errorObjects[fieldName][i] = isc.isAn.Object(error)
                                                ? isc.shallowClone(error)
                                                : {errorMessage: error};
            }
        } else {
            errorObjects[fieldName] = isc.isAn.Object(fieldErrors)
                                          ? isc.shallowClone(fieldErrors)
                                          : {errorMessage: fieldErrors};
        }
    }
    return errorObjects;
},

// Callable either on server-formatted errors or editor component format errors.

formatValidationErrors : function (errors) {
    // If error is in server format, transform the server error report format to the error
    // report expected by an editor component.  Each server error is:
    // { fieldName : errors },
    //   anotherFieldName : errors },
    //   ...
    // }
    // where the errors for each field have the format
    // { errorMessage : msg, resultingValue : value }
    // or
    // [{ errorMessage : msg, resultingValue : value },
    //  { errorMessage : msg, otherProp : value },  ... ]
    //
    // Editor components expect just { fieldName : errorMessage } - we drop
    // the resultingValue and possible other properties
    //

    var errorMessages = {};
    // note we support errors for only one row
    if (isc.isAn.Array(errors)) errors = errors[0];

    for (var fieldName in errors) {
        var fieldErrors = errors[fieldName];
        if (fieldName == "recordPath" && !isc.isAn.Object(fieldErrors)) continue;

        if (isc.isAn.Array(fieldErrors)) {
            errorMessages[fieldName] = [];
            for(var i = 0; i < fieldErrors.length; i++) {
                var error = fieldErrors[i];
                if(isc.isAn.Object(error)) error = error.errorMessage;
                errorMessages[fieldName][i] = error;
            }
        } else {
            errorMessages[fieldName] = isc.isAn.Object(fieldErrors) ? fieldErrors.errorMessage
                                                                    : fieldErrors;
        }
    }
    return errorMessages;
},


// valuesHaveChanged - recursively compares newValues with oldValues, allowing formItem
// compareValues() to run for values with an associated item and handling data paths.
//
// Implemented as a classMethod and used by DynamicForm.valuesHaveChanged
// and ValuesManager.valuesHaveChanged [so the form parameter may be a ValuesManager rather than
// a DynamicForm].
valuesHaveChanged : function (form, returnChangedVals, values, oldValues, rootPath,
                              useActionCache)
{

    var changed = false,
        changedVals = {};

    // A value may have been cleared and the property deleted from `values'. To ensure that we
    // detect the clearing of a value as a change, we need to make sure that `values' is
    // augmented with any properties that exist in `oldValues'.

    var augmentedValues = values,
        undef;
    for (var oldProp in oldValues) {
        if (!(oldProp in values)) {
            // Lazily create a copy of `values' the first time a property is found in `oldValues'
            // that is not in `values'.
            if (augmentedValues === values) augmentedValues = isc.addProperties({}, values);

            augmentedValues[oldProp] = undef;
        }
    }
    values = augmentedValues;

    var fields = useActionCache ? form._getUpdatedFields() : form.getFields().duplicate(),
        dsFields = {};
    if (isc.DataSource && isc.isA.DataSource(form.getDataSource())) {
        dsFields = useActionCache ? form._getUpdatedDSFields() :
                                    form.getDataSource().getFields();
    }

    // Process properties mapped to fields first, since this allows us to quickly deal with
    // items with dataPaths like "topLevel/someSubPath/anEvenDeeperPath" without blind mining

    var pathsProcessed = {};

    // Compare the merged set of fields.
    for (var i = 0;
             i < fields.length || this._mergeDSFields(fields, dsFields, pathsProcessed);
             i++)
    {
        var dataPath = fields[i].dataPath || fields[i].name;
        if (dataPath != null) {  // If null, field has neither a name nor a dataPath - ignore it
            if (pathsProcessed[dataPath]) continue;
            pathsProcessed[dataPath] = fields[i];

            var oldFieldValue = isc.DataSource ?
                                    isc.DataSource.getFieldValue(null, oldValues, dataPath, null, "compare") :
                                    oldValues[dataPath];
            var newFieldValue = isc.DataSource ?
                                    isc.DataSource.getFieldValue(null, values, dataPath, null, "compare") :
                                    values[dataPath];
            var partialPaths = dataPath.split('/');
            if (partialPaths.length > 1) {
                var pPath = "";
                for (var j = 0; j < partialPaths.length; j++) {
                    if (j > 0) pPath += "/";
                    pPath += partialPaths[j];
                    if (!pathsProcessed[pPath]) {
                        pathsProcessed[pPath] = fields[i];
                    }
                }
            }
            if (!form.fieldValuesAreEqual(fields[i], oldFieldValue, newFieldValue)) {
                changed = true;
                if (!returnChangedVals) break;

                changedVals[fields[i].name] = newFieldValue;
            }
        }
    }

    if (changed && !returnChangedVals) {
        return changed;
    }

    // Bail out without diving down through all the non-field values if we are so configured
    if (form.canChangeNonFieldValues === false) {
        return (returnChangedVals ? changedVals : changed);
    }

    if (useActionCache) {

        values    = form._filterWithUpdatedFields(values);
        oldValues = form._filterWithUpdatedFields(oldValues);
    }

    for (var prop in values) {
        // ignore functions
        if (isc.isA.Function(values[prop])) continue;


        if (prop == isc.gwtRef || prop == isc.gwtModule) continue;

        // Skip instances and classes


        if (isc.isAn.Instance(values[prop]) || isc.isA.Class(values[prop])
                                            || (values[prop] && values[prop]._constructor))
        {
            continue;
        }

        var fullPath = rootPath == null ? prop : rootPath + "/" + prop;

        // If we've seen this path before, that will be because it is the dataPath of a declared
        // field - we've already checked it
        if (pathsProcessed[fullPath]) continue;

        // Use compareValues to compare old and new values
        // This will catch cases such as Dates where an '==' comparison is
        // not sufficient.
        // Note: If we have a form item use item.compareValues() in case it has been overridden
        var item = form.getItem(fullPath);
        if (item != null) {
            // ASSERT: This will never happen, we processed all the field-mapped values in the
            // loop above
            //changed = !item.compareValues(values[prop], oldValues[prop]);
            //if (changed && returnChangedVals) changedVals[prop] = values[prop];

        } else {
            var value = values[prop],
                oldValue = oldValues[prop];


            var valIsObj, oldValIsObj;
            if (isc.isA.Number(value) || isc.isA.String(value) || isc.isA.Boolean(value)) {
                valIsObj = false;
            } else {
                valIsObj = isc.isAn.Object(value);
            }
            if (isc.isA.Number(oldValue) || isc.isA.String(oldValue) || isc.isA.Boolean(oldValue)) {
                valIsObj = false;
            } else {
                valIsObj = isc.isAn.Object(oldValue);
            }

            if (valIsObj &&
                !isc.isAn.Array(value) && !isc.isA.Date(value) &&
                oldValIsObj && !isc.isAn.Array(oldValue) && !isc.isA.Date(oldValue))
            {
                var innerChanged = isc.Canvas.valuesHaveChanged(
                                    form, returnChangedVals, values[prop], oldValues[prop], fullPath);
                if (!returnChangedVals && innerChanged) {
                    changed = true;
                    break;
                } else if (!isc.isAn.emptyObject(innerChanged)) {
                    if (changedVals[prop] == null) changedVals[prop] = {};
                    isc.addProperties(changedVals[prop], innerChanged);
                }
            } else {
                changed = !isc.Canvas.compareValues(value, oldValue);
                if (changed && returnChangedVals) changedVals[prop] = value;
            }
        }
        // no need to keep going once we've found a difference
        // unless we've been asked to return the changed values
        if (changed && !returnChangedVals) {
            return true;
        }
    }

    return (returnChangedVals ? changedVals : changed);
},


_mergeDSFields : function (fields, dsFields, pathsProcessed) {

    if (isc.isAn.emptyObject(dsFields) || isc.isAn.emptyArray(dsFields)) return false;

    var startLen = fields.length;

    if (isc.isAn.Array(dsFields)) {
        var fieldArray = dsFields;
        dsFields = {};
        for (var i = 0; i < fieldArray.length; i++) {
            dsFields[fieldArray.name] = fieldArray[i];
        }
    }

    // Merge in any DS fields that do not have corresponding FormItems
    for (var key in dsFields) {
        var dsField = dsFields[key];
        if (dsField.dataPath) {
            if (!pathsProcessed[dsField.dataPath]) fields.add(dsField);

        } else if (dsField.name) {
            if (!pathsProcessed[dsField.name]) fields.add(dsField);
        }
    }

    dsFields = isc.emptyObject;

    return fields.length > startLen;
},

// get filter criteria for a list of filter components (passed as arguments)
getFilterCriteria : function () {
    var criteria = {};
    for (var i = 0; i < arguments.length; i++) {
        var arg = arguments[i];
        if (arg == null) continue;
        if (arg.getValuesAsCriteria == null) {
            this.logInfo("DynamicForm.getFilterCriteria() - unable to call 'getValuesAsCriteria()' on argument:" + this.echo(arg));
            continue;
        }
        isc.addProperties(criteria, arg.getValuesAsCriteria());
    }
    return criteria;
},

// HTML template generation
_getTopRowCellStart : function () {
     if (!this._observingDoublingStrings) {
        isc.Canvas._doublingStringObservers.add({
            target:this,
            methodName:"_doublingStringsChanged"
        });
        this._observingDoublingStrings = true;
    }
    if (this._$topRowCellStart == null) {

        this._$topRowCellStart = [
            "<TD style='",
            isc.Canvas._$noStyleDoublingCSS,
            "font-size:0px;height:0px;overflow:hidden;padding:0px;' class='",
            null,
            "'>",

            (isc.Browser.isSafari || isc.Browser.isMoz ? "<div style='overflow:hidden;height:0px'>" : "")
        ]
    }
    return this._$topRowCellStart;
},
_getTitleInnerTableTemplate : function () {
    if (!this._observingDoublingStrings) {
        isc.Canvas._doublingStringObservers.add({
            target:this,
            methodName:"_doublingStringsChanged"
        });
        this._observingDoublingStrings = true;
    }
    if (this._titleInnerTableTemplate == null) {
        this._titleInnerTableTemplate = [
            "<TABLE height=",   // 0
            , // 1: height
            " border=0 cellspacing=0 cellpadding=0><tr><td class='", // 2
            , // 3: className
            // Override any style attributes that would look wrong double-applied by the className
            "' style='" + isc.Canvas._$noStyleDoublingCSS + "' ALIGN='", // 4
            , // 5: this.getTitleAlign(item)
            "'>",   // 6
            null    // 7: <NOBR>
        ];
    }
    return this._titleInnerTableTemplate;
},

_doublingStringsChanged:function () {
    this._$topRowCellStart = null;
    this._titleInnerTableTemplate = null;
},


//> @attr dynamicForm.allowExpressions (boolean : null : IRW)
// For a form that produces filter criteria
// (see +link{dynamicForm.getValuesAsCriteria,form.getValuesAsCriteria()}), allows the user to
// enter simple expressions in any field in this form that takes text input.
// <P>
// Also note that enabling <code>allowExpressions</code> for an entire form changes the
// +link{defaultSearchOperator} to
// +link{dataSource.translatePatternOperators,"iContainsPattern"},
// so that simple search expressions similar to SQL "LIKE" patterns can be entered in most
// fields.
// <P>
// See +link{formItem.allowExpressions} for details.
//
// @group advancedFilter
// @visibility external
//<

//> @attr dynamicForm.suppressBrowserClearIcons (boolean : false : IRW)
// Default +link{textItem.suppressBrowserClearIcon} value for TextItems within this
// form.
// @visibility external
//<
suppressBrowserClearIcons:false

});
// InlineForms: embedding SmartClient FormItems into native HTML forms.
// See QA/DynamicForm/inlineForms.jsp
// ---------------------------------------------------------------------------------------

isc.defineClass("InlineFormItem", "DynamicForm").addProperties({
    position:"relative",

    // don't write a form tag, so that form items written out join a surrounding HTML
    // form.  Note if we did not set this flag, IE will JS error if you try to insert a form
    // inside a form.  Firefox doesn't mind and the values show up within the outer form.
    // Safari untested.
    writeFormTag:false,

    // write native form fields to carry values for synthetic items, just as with direct submit
    canSubmit:true,

    // only one item, with no title
    numCols: 1,

    // in case the default is switched at the Canvas level
    autoDraw: true


    //redraw : function (a,b,c,d) {
    //    this.invokeSuper(isc.InlineFormItem, this._$redraw, a,b,c,d);
    //    this.getItem(0).getDataElement().form.offsetHeight;
    //}
});

isc.InlineFormItem.addClassMethods({
    // This override of create() does create a form, but applies properties to the (singular)
    // FormItem, so that it's possible to use inline items from XML like so:
    //     <InlineItem name="name" type="type">
    //       <valueMap> ... </valueMap>
    //     </InlineItem>
    // NOTE: it's ordinarily not a good idea to override create to return some kind of
    // "wrapper" component, because in order to be used inline in eg a Layout.members array,
    // create() must return the wrapper component, however in other usage (eg subcomponent
    // creation) the expectation is that create will return an instance of whatever was
    // created.
    create : function (A,B,C,D,E,F,G,H,I,J,K,L,M) {

        var itemProps = isc.addProperties({
            showTitle:false,
            validate : function () { this.form.validate(); },
            destroy : function () { this.form.destroy(); this.Super("destroy", arguments); }
        }, A,B,C,D,E,F,G,H,I,J,K,L,M);

        var theForm = this.createRaw().completeCreation({
            fields : [ itemProps ],
            valuesManager : itemProps.valuesManager
        }, itemProps.formProperties );

        return theForm.getItem(0);
    }
});

isc.DynamicForm.addClassMethods({
    //> @classMethod DynamicForm.makeInlineItem()
    // Return a SmartClient form item suitable for embedding into a normal HTML form.
    // <P>
    // For example, embedding a +link{ComboBoxItem}:
    // <pre>
    // &lt;form name="contactForm" action="/makeContact.jsp"&gt;
    //    &lt;input type="text" name="name"&gt;
    //    &lt;script&gt;isc.DynamicForm.makeInlineItem("title", "comboBox",
    //                       { valueMap:["CEO", "CTO", "CIO", "COO"] })&lt;/script&gt;
    // &lt;/form&gt;
    // </pre>
    // The value managed by the SmartClient form item is then available for direct DOM access
    // just like ordinary HTML &lt;INPUT&gt; elements, and will be submitted normally with the
    // form.
    // <P>
    // This is an advanced API for use in incremental upgrade of older applications, or for
    // unusual form layouts that can't be accommodated by any combination of
    // +link{group:formLayout,form layout}, +link{ValuesManager} and +link{Layout,H/VLayouts}.
    //
    // @param name (String) name of the form field
    // @param type (String) type of the form field, same as +link{FormItem.type}
    // @param props (FormItem) other properties for the created FormItem
    //
    // @group inlineFormItems
    // @visibility inlineFormItems
    //<
    makeInlineItem : function (name, type, props, formProps) {
        return isc.InlineFormItem.create({
            name: name,
            type: type,
            formProperties : formProps
        }, props)
    },

    //> @classMethod DynamicForm.getFormValues()
    // Return the values of a native HTML &lt;form&gt; element as JavaScript object.
    // <P>
    // Each property in the returned object represents a native form element value.  Select
    // multiple items are represented as an Array of the selected values.
    //
    // @param formId (String) DOM ID of the form
    //
    // @group inlineFormItems
    // @visibility inlineFormItems
    //<
    getFormValues : function (formId) {
        return isc.Canvas.getFormValues(formId);
    }

});


isc.DynamicForm.registerStringMethods({

    //> @method dynamicForm.valuesChanged()
    // Handler fired when the entire set of values is replaced, as by a call to
    // +link{setValues}, +link{resetValues} or +link{editRecord}.
    // <P>
    // Note that it is invalid to call such methods from this handler because doing so would
    // result in an infinite loop.
    //
    // @visibility external
    //<
    valuesChanged : "",

    //> @method dynamicForm.itemChanged()
    // Handler fired when there is a changed() event fired on a FormItem within this form.
    // <P>
    // Fires after the change() handler on the FormItem itself, and only if the item did not
    // cancel the change event and chooses to allow it to propagate to the form as a whole.
    //
    // @param    item    (FormItem)    the FormItem where the change event occurred
    // @param    newValue (Any)    new value for the FormItem
    // @visibility external
    //<
    itemChanged : "item,newValue",

    //> @method dynamicForm.itemChange()
    // Handler fired when there is a change() event fired on a FormItem within this form.
    // <P>
    // Fires after the change() handler on the FormItem itself, and only if the item did not
    // cancel the change event and chooses to allow it to propagate to the form as a whole.
    //
    // @param    item    (FormItem)    the FormItem where the change event occurred
    // @param    newValue (Any)    new value for the FormItem
    // @param    oldValue (Any)    value the FormItem had previous to this change() event
    // @return (boolean) return false to cancel the change, or true to allow it
    // @visibility external
    //<
    itemChange : "item,newValue,oldValue",

    //>    @method dynamicForm.itemKeyPress()
    // Handler fired when a FormItem within this form receives a keypress event.
    // <P>
    // Fires after the keyPress handler on the FormItem itself, and only if the item did not
    // cancel the event and chooses to allow it to propagate to the form as a whole.
    //
    // @param    item    (FormItem)    the FormItem where the change event occurred
    // @param    keyName (KeyName)     name of the key that was pressed (EG: "A", "Space")
    // @param   characterValue  (number)    numeric character value of the pressed key.
    // @return (boolean) return false to cancel the keyPress, or true to allow it
    //
    // @visibility external
    //<
    itemKeyPress : "item,keyName,characterValue",

    //> @method dynamicForm.showItemContextMenu
    // Called when the mouse is right-clicked in some formItem.  If the implementation
    // returns false, default browser behavior is cancelled.
    // <P>
    // Note that it can be bad practice to cancel this method if the mouse is over the data
    // element of an item, because doing so would replace the builtin browser-default menus
    // that users may expect.  You can use +link{dynamicForm.getEventItemInfo} to return an
    // +link{FormItemEventInfo, info object} that can be used to determine which part of the
    // item is under the mouse.
    //
    // @param item (FormItem) the form item showing its context menu
    // @return (boolean) return false to cancel default behavior
    // @group eventHandling
    // @visibility external
    //<
    showItemContextMenu : "item",

    //>    @method dynamicForm.submitValues()
    // Triggered when a SubmitItem is included in the form is submitted and gets pressed.
    //
    // @param    values    (Object)        the form values
    // @param    form      (DynamicForm)   the form being submitted
    // @group submitting
    // @see method:dynamicForm.submit()
    // @visibility external
    //<
    submitValues : "values,form",

    //> @method dynamicForm.handleHiddenValidationErrors (A)
    // Method to display validation error messages for fields that are not currently visible
    // in this form.<br>
    // This will be called when validation fails for<br>
    // - a hidden field in this form<br>
    // - if this form is databound, a datasource field with specified validators, for which we
    //   have no specified form item.<br>
    // Implement this to provide custom validation error handling for these fields.<br>
    // By default hidden validation errors will be logged as warnings in the developerConsole.
    // Return false from this method to suppress that behavior.
    // @param   errors (Object) The set of errors returned - this is an object of the form<br>
    //                      &nbsp;&nbsp;<code>{fieldName:errors}</code><br>
    //                      Where the 'errors' object is either a single string or an array
    //                      of strings containing the error messages for the field.
    // @return (boolean) false from this method to suppress that behavior
    // @visibility external
    //<
    handleHiddenValidationErrors:"errors",


    //> @method dynamicForm.itemTabIndexUpdated()
    // Notification method fired when the tab index for some item is modified
    // by the system, due to a change in item layout, or a change in the page's structure
    // (for example as a result of an ancestor being added to a new parent, etc).
    // <P>
    // This only happens for items with an automatically assigned global tab index
    // (i.e.: cases where an explicit +link{formItem.globalTabIndex} has not been
    // specified in application code).
    // <P>
    // Use +link{item.getGlobalTabIndex()} to retrieve the new tab index.
    //
    // @visibility internal
    //<
    // As with canvas.tabIndexUpdated(),
    // Leaving internal for now simply because we don't really have a use case
    // where this is required (though it is useful for internal testing).
    itemTabIndexUpdated:"item"
});

//> @class HandPlacedForm
// This class is a DynamicForm with the default +link{dynamicForm.itemLayout,itemLayout}
// property set to "absolute".
// <P>
// Another synonym is AbsoluteForm.
// @inheritsFrom DynamicForm
// @treeLocation Client Reference/Forms
// @visibility external
//<
isc.ClassFactory.defineClass("HandPlacedForm", "DynamicForm");

isc.HandPlacedForm.addProperties({
    itemLayout: "absolute",
    height: 100,
    snapVGap: 8,
    snapHGap: 8,
    snapHDirection: isc.Canvas.NEAREST,
    snapVDirection: isc.Canvas.NEAREST
});

isc.ClassFactory.defineClass("AbsoluteForm", "HandPlacedForm");







//>    @class  ScalarViewer
// A DynamicForm subclass for displaying a single value from a data object.
// <P>
// The ScalarViewer will creates a single item based on the specified +link{fieldName} and
// +link{title} in order to display the value for a single field to the user.
// <P>
// The item may be customized via the +link{group:autoChildUsage,autoChild} pattern.
// See +link{scalarViewer.valueItem}.
//
//  @inheritsFrom DynamicForm
//  @treeLocation Client Reference/Forms
//  @visibility internal
//<

// create the form as a descendant of the Canvas
isc.ClassFactory.defineClass("ScalarViewer", "DynamicForm");

isc.ScalarViewer.addProperties({

    // Set up for a single item with top-orientated title by default
    numCols:1, colWidths:["*"],

    initWidget : function () {
        var itemConfig = this.getValueItemConfig();
        this.setItems([itemConfig]);
        this.Super("initWidget", arguments);
        this.valueItem = this.getItem(0);
    },
    getValueItemConfig : function () {
        return isc.addPropertiesWithAssign(
            {},
            this.valueItemDefaults,
            this.valueItemProperties,
            {title:this.title, name:this.fieldName}
        );
    },

    //> @attr scalarViewer.valueItem (FormItem AutoChild : null : IR)
    // Single item for displaying a value from a data object.
    // <P>
    // This item will have +link{formItem.name,name} set to to
    // +link{fieldName,this.fieldName} and title set to +link{title,this.title}.
    // <P>
    // Other properties are derived from +link{valueItemDefaults} and
    // +link{valueItemProperties} using the auto-child pattern.
    //
    // @visibility internal
    //<

    //> @attr scalarViewer.initialSort (Array of SortSpecifier : null : IR)
    // An array of +link{SortSpecifier} objects used to set up the initial sort
    // configuration for this form.
    // @group sorting
    // @visibility external
    //<
    //initialSort: null,

    //> @attr scalarViewer.fieldName (String : "value" : IRW)
    // +link{formItem.name,name} for the +link{valueItem}
    //
    // @setter setFieldName()
    // @visibility internal
    //<
    fieldName:"value",

    //> @method scalarViewer.setFieldName()
    // Set the +link{fieldName} at runtime. This will rebuild
    // the +link{valueItem}.
    //
    // @param name (String) new fieldName to use
    // @visibility internal
    //<
    setFieldName : function (name) {
        this.fieldName = name
        this.setItems([this.getValueItemConfig()]);
        this.valueItem = this.getItem(0);
    },

    //> @attr scalarViewer.title (String : null : IRW)
    // +link{formItem.title,title} for the +link{valueItem}
    //
    // @setter setTitle()
    // @visibility internal
    //<
    // title:null,

    //> @method scalarViewer.setTitle()
    // Set the +link{title} at runtime of the +link{valueItem}
    // at runtime.
    //
    // @param title (String) new title to use
    // @visibility internal
    //<
    setTitle : function (title) {
        this.valueItem.setTitle(title);
    },

    //> @attr scalarViewer.valueItemDefaults (FormItem Properties : {...} : IR)
    // Defaults for the generated +link{valueItem}
    // <P>
    // By default the valueItem will be a StaticTextItem with
    // +link{formItem.titleOrientation,titleOrientation:"top"}
    // @visibility internal
    //<
    // For greater control over the appearance we could use a CanvasItem subclass here
    valueItemDefaults:{
        editorType:"StaticTextItem",

        vAlign:"center",
        align:"center",
        titleAlign:"center",
        titleOrientation:"top",
        titleStyle:"headerItem",
        textBoxStyle:"headerItem"
    },

    //> @attr scalarViewer.valueItemProperties (FormItem Properties : null : IR)
    // Optional +link{group:autoChildUsage,autoChild properties} to customize
    // the generated +link{valueItem}.
    // @visibility internal
    //<

    setDataSource : function (dataSource) {
        return this.Super("setDataSource", [dataSource, [this.getValueItemConfig()]]);
    }
});






//> @class FormItem
// A UI component that can participate in a DynamicForm, allowing editing or display of one of
// the +link{dynamicForm.values,values tracked by the form}.
// <P>
// <smartclient>FormItems are never created via the +link{Class.create(),create()} method,
// instead, an Array of plain +link{type:Object,JavaScript objects} are passed as
// +link{DynamicForm.items} when the form is created.</smartclient>
//
// <smartgwt>FormItems do not render themselves, instead, they are provided to a
// +link{DynamicForm} via +link{DynamicForm.setItems()}</smartgwt>
// <p>
// See the +link{DynamicForm} documentation for details and sample code.
//
// @treeLocation Client Reference/Forms/Form Items
// @visibility external
//<
isc.ClassFactory.defineClass("FormItem");

// Copy across the canvas method to generate DOM IDs for the various elements we will be
// creating
isc.FormItem.addMethods({
    // we use getDOMID to generate our elements' unique dom ids
    // If we're writing out 'inactiveHTML' we may be rendering multiple elements on the page
    // with the same 'partName' but we want them to have separate unique IDs. In this
    // case we'll modify the partName to ensure unique IDs for all the inactive elements.
    _inactiveTemplate:[null, "_inactiveContext", null],
    _getDOMID : function (partName, dontCache, dontReuse, inactiveContext) {

        // If we're in the process of writing out inactive HTML, pick up the current
        // inactiveContext ID, or lazily create a new one if we haven't got one yet.

        if (inactiveContext == null && this.isInactiveHTML()) {
            inactiveContext = this._currentInactiveContext;
        }
        // see if this becomes expensive (string concat)
        if (inactiveContext != null) {
            this._inactiveTemplate[0] = partName;
            this._inactiveTemplate[2] = inactiveContext;
            partName = this._inactiveTemplate.join(isc.emptyString);
            if (this.logIsDebugEnabled("inactiveEditorHTML")) {
                this.logDebug("_getDOMID called for inactive HTML -- generated partName:"
                    + partName, "inactiveEditorHTML");
            }

            // ignore 'dontCache' if we're writing out inactive context.

            dontCache = false;

        }
        return isc.Canvas.getPrototype()._getDOMID.apply(this, [partName,dontCache,dontReuse]);
    },

    _getDOMPartName:isc.Canvas.getPrototype()._getDOMPartName,


    _releaseDOMIDs:isc.Canvas.getPrototype()._releaseDOMIDs,
    reuseDOMIDs:false
});

isc.FormItem.addClassMethods({

    //> @classMethod FormItem.create()
    // FormItem.create() should never be called directly, instead, create a +link{DynamicForm}
    // and specify form items via +link{DynamicForm.items,form.items}.
    //
    // @visibility external
    //<
    // Log a warning if called directly
    create : function (A,B,C,D,E,F,G,H,I,J,K,L,M) {
        this.logWarn(
            "Unsupported call to " + this.getClassName() + ".create(). FormItems must be created " +
            "by their containing form. To create form items, use the 'items' property of a DynamicForm " +
            "instance. See documentation for more details."
        );
        // If we're passed properties combine them into a single raw object - if this is then
        // assigned to a form's "items" attribute the developer will likely get the expected
        // behavior.
        // (No need to call Super)
        return isc.addProperties({}, A,B,C,D,E,F,G,H,I,J,K,L,M);
    },

    // getNewTagID() -- a method to broker out IDs for the form element tags, if no name is
    // specified for the form element
    // (If a name is specified we'll use that instead)
    getNewTagID : function () {
        if (this._currentTagIDNumber == null) this._currentTagIDNumber = 0;
        this._currentTagIDNumber += 1;
        return "isc_FormItemElement_ID_" + this._currentTagIDNumber;
    },

    // setElementTabIndex()
    // Given a DOM element (a form item element), and a tabIndex, update the tabIndex on
    // the appropriate element.
    setElementTabIndex : function (element, tabIndex) {
        // Set the tabIndex property on the element
        element.tabIndex = tabIndex;

        // In mozilla setting a tabIndex to -1 is not sufficient to remove it from the
        // page's tab order -- update the 'mozUserFocus' property as well to achieve this
        // if we're passed a desired tabIndex less than zero (or revert this property if
        // necessary from a previous exclusion from the page's tab order)

        if (isc.Browser.isMoz) {
            element.style.MozUserFocus = (tabIndex < 0 ? "ignore" : "normal");
        }
    },



    _aboutToFireNativeElementFocus : function (item) {

        if (!isc.Browser.isIE) return;
        var activeElement = this.getActiveElement();

        if (activeElement && activeElement.tagName == null) activeElement = null;

        // Note: this will work for elements in the DOM that are not part of ISC form items.
        if (activeElement &&
            ((activeElement.tagName.toLowerCase() == this._inputElementTagName &&
              activeElement.type.toLowerCase() == this._textElementType) ||
              activeElement.tagName.toLowerCase() == this._textAreaElementTagName))
        {
            // IE proprietary API
            var range = activeElement.createTextRange();
            range.execCommand("Unselect");
        }
    },


    // Helper method to determine if the item passed in is text based
    _textBasedItem : function (item, checkForPopUp) {
        if (isc.isA.FormItem(item)) item = item.getClassName();

        if (!this._textClassNames) {
            this._textClassNames = {
                text:true,
                TextItem:true,
                textItem:true,
                textArea:true,
                TextAreaItem:true,
                textAreaItem:true
            }
            this._popUpClassNames = {
                popUpTextArea:true,
                PopUpTextAreaItem:true,
                popUpTextAreaItem:true
            }
        }

        return this._textClassNames[item] || (!checkForPopUp || this._popUpClassNames[item]);
    },

    // Native handlers to be applied to elements written into the DOM
    // --------------------------------------------------------------------------------------

    // Focus/blur handelers to be applied to Form item elements.
    // Applied directly to the element, so we need to determine which item we are a part of
    // and call the appropriate focus/blur handler method on that item.
    _nativeFocusHandler : function () {
        if (!window.isc || !isc.DynamicForm) return;

        var useFocusInEvents = (isc.EH.useFocusInEvents &&
                                isc.EH.synchronousFocusNotifications);
        if (useFocusInEvents) return isc.FormItem.__nativeAsyncFocusHandler(this);


        isc.EH._setThread("IFCS");

        var result;
        if (isc.Log.supportsOnError) {
            result = isc.FormItem.__nativeFocusHandler(this);
        } else {
            try {
                result = isc.FormItem.__nativeFocusHandler(this);
            } catch (e) {
                isc.Log._reportJSError(e);
                if (isc.Log.rethrowErrors) {

                    throw e;;
                }

            }
        }
        isc.EH._clearThread();
        return result;
    },

    // If we're using 'onfocusin' to give us synchronous focus notification in IE,
    // the native 'onfocus' notification also fires [asynchronously].
    // We capture this too to handle any cases where native behaviors that we
    // might need to be aware of occur asynchronously on focus

    __nativeAsyncFocusHandler : function (element) {
        var useFocusInEvents = (isc.EH.useFocusInEvents &&
                                isc.EH.synchronousFocusNotifications);
        if (useFocusInEvents) {
            var itemInfo = isc.DynamicForm._getItemInfoFromElement(element),
            item = itemInfo.item;
            if (item) {
                item._handleAsyncFocusNotification();
            }
            return;
        }

    },
    __nativeFocusHandler : function (element) {

        //!DONTCOMBINE
        var itemInfo = isc.DynamicForm._getItemInfoFromElement(element),
            item = itemInfo.item;

        if (item != null) {

            if (item.isDisabled()) {
                element.blur();
                return;
            }


            var EH = this.ns.EH;

            if (EH.mouseDownEvent != null &&
                EH._nativeMouseEventMap[EH.mouseDownEvent.DOMevent.type] === EH.TOUCH_START &&
                this.containerWidget != null &&
                this.containerWidget.isDrawn())
            {
                var mouseDownDOMevent = EH.mouseDownEvent.DOMevent,
                    targetElem = (mouseDownDOMevent.target && (mouseDownDOMevent.target.nodeType == 1 ? mouseDownDOMevent.target
                                                                                                      : mouseDownDOMevent.target.parentElement));
                if (targetElem != null && !this.containerWidget.getClipHandle().contains(targetElem)) {
                    element.blur();
                    return;
                }
            }

            return item._nativeElementFocus(element, item);
        }
        isc.EH._clearThread();
    },

    _nativeBlurHandler : function () {
        // Check for blur being fired on page unload (when the isc object is out of scope)
        if (!window.isc || !isc.DynamicForm) return;
        if (isc.EH.useFocusInEvents && isc.EH.synchronousFocusNotifications) {
            return;
        }

        isc.EH._setThread("IBLR");
        var result;
        if (isc.Log.supportsOnError) {
            result = isc.FormItem.__nativeBlurHandler(this);
        } else {
            try {
                result = isc.FormItem.__nativeBlurHandler(this);
            } catch (e) {
                isc.Log._reportJSError(e);
                if (isc.Log.rethrowErrors) {

                    throw e;;
                }
            }
        }

        isc.EH._clearThread();
        return result;
    },
    __nativeBlurHandler : function (element) {
        //!DONTCOMBINE
        var itemInfo = isc.DynamicForm._getItemInfoFromElement(element),
            item = itemInfo.item;
        if (item && item.hasFocus) {
            return item._nativeElementBlur(element, item);
        }
    },

    // handler for native oncut / onpaste events

    _nativeCut : function (nativeEvent) {
        if (!window.isc) return;
        var element = this,
            itemInfo = isc.DynamicForm._getItemInfoFromElement(element),
            item = itemInfo.item;

        if (item && item.hasFocus) {
            return item._nativeCutPaste(element, item, true, nativeEvent);
        }

    },
    _nativePaste : function (nativeEvent) {
        if (!window.isc) return;
        var element = this,
            itemInfo = isc.DynamicForm._getItemInfoFromElement(element),
            item = itemInfo.item;

        if (item && item.hasFocus) {
            return item._nativeCutPaste(element, item, false, nativeEvent);
        }

    },

    // For some form items we make use of the native onchange handler.
    // This is a single function that will be applied directly to elements as a change handler
    // Currently used by the nativeSelectItem class and the checkboxItem class (and UploadItem)
    _nativeChangeHandler : function () {

        //!DONTCOMBINE
        if (!window.isc || !isc.DynamicForm) return;

        var element = this,
            itemInfo = isc.DynamicForm._getItemInfoFromElement(element),
            item = itemInfo.item;
        if (item) return item._handleElementChanged();
    },

    // Focus / blur handlers applied directly to icons
    _nativeIconFocus : function () {
        //!DONTCOMBINE
        if (isc.EH.useFocusInEvents && isc.EH.synchronousFocusNotifications) return;

        var element = this,
            itemInfo = isc.DynamicForm._getItemInfoFromElement(element),
            item = itemInfo.item,
            iconID = itemInfo.overIcon;
        if (item) {

            if (item.iconIsDisabled(iconID)) element.blur();
            else return item._iconFocus(iconID, element);
        }
    },

    _nativeIconBlur : function () {
        //!DONTCOMBINE
        if (!window.isc) return;
        if (isc.EH.useFocusInEvents && isc.EH.synchronousFocusNotifications) return;

        var element = this,
            itemInfo = isc.DynamicForm._getItemInfoFromElement(element),
            item = itemInfo.item,
            iconID = itemInfo.overIcon;
        if (item && !item.iconIsDisabled(iconID)) return item._iconBlur(iconID, element);
    },

    // Native click handler for icons can just return false. This will cancel navigation.
    // We will fire icon.click() via the standard DynamicForm.handleClick method
    _nativeIconClick : function () {
        return false;
    },


    _testStuckSelectionAfterRedraw : function (formItem) {
        if (!isc.Browser.isIE) return;
        this._testFocusAfterRedrawItem = formItem;
        this.fireOnPause("testStuckSelection", {target:this, methodName:"_testStuckSelection"});
    },
    _testStuckSelection : function () {
        var item = this._testFocusAfterRedrawItem;
        // Focus may have moved elsewhere etc since the refocusAfterRedraw
        if (item == null ||
            item.destroyed ||
            !item.isDrawn() ||
            !item.isVisible() ||
            !item.hasFocus)
        {
            return;
        }
        if (item._IESelectionStuck()) {

            item.focusInItem();
        }
    },

    // Helper method to return a prompt string to show in hovers over error icons
    getErrorPromptString : function (errors) {
        var errorString = "";
        if (!isc.isAn.Array(errors)) errors = [errors];
        for (var i =0; i< errors.length; i++) {
            errorString += (i > 0 ? "<br>" : "") + errors[i].asHTML();
        };
        return errorString;
    },


    // HTML templating involving no-style-doubling string [which may change at runtime]
    _getOuterTableStartTemplate : function () {
        if (!this._observingDoublingStrings) {
            isc.Canvas._doublingStringObservers.add({
                target:this,
                methodName:"_doublingStringsChanged"
            });
            this._observingDoublingStrings = true;
        }
        if (this._$outerTableStartTemplate == null) {
            this._$outerTableStartTemplate = [
                "<TABLE role='presentation' CELLSPACING=0 CELLPADDING=0 BORDER=0 ID='",         // 0
                ,                                                           // 1 [ID for outer table]
                // We'll apply the 'cellStyle' for the item to the outer table as styles won't
                // be inherited by sub elements of the table.
                // Explicitly avoid getting doubled borders etc.
                "' STYLE='" + isc.Canvas._$noStyleDoublingCSS,              // 2
                ,                                                           // 3 [css to override class attrs]
                "' CLASS='",                                                // 4
                ,                                                           // 5 [pick up the cellStyle css class]

                "'><TR>",                                                   // 6
                ,                                                           // 7 Potential first cell for
                                                                            //   error on left...
                // Main cell - If we're showing a picker this will contain the 'control' table
                // If we're not showing a picker, this will contain the 'text box'
                "<TD style='",                                              // 8
                ,                                                           // 9 [possibly css for text box cell]
                "' VALIGN=",                                                // 10

                ,                                                           // 11   [v align]
                ">"                                                         // 12
                // Either the text box element (returned by getElementHTML()) or an inner control table

            ];
        }
        return this._$outerTableStartTemplate;
    },

    _getIconsCellTemplate : function () {
        if (!this._observingDoublingStrings) {
            isc.Canvas._doublingStringObservers.add({
                target:this,
                methodName:"_doublingStringsChanged"
            });
            this._observingDoublingStrings = true;
        }

        if (this._$iconsCellTemplate == null) {
            this._$iconsCellTemplate = [
                "</TD><TD VALIGN=",     // 0
                ,                       // 1 [v align property for icons]


                ,                       // 2
                ,                       // 3 [total icons width]
                " style='" + isc.Canvas._$noStyleDoublingCSS + "line-height:",
                ,                       // 5 iconHeight
                "px' class='",          // 6
                ,                       // 7 Apply standard cell style to the item
                "' ID='",               // 8
                ,                       // 9 ID for cell
                                        //  (allows us to show/hide icons by writing into the cell)
                "'>",                   // 10
                null                    // 11 [icons HTML]
            ];
        }
        return this._$iconsCellTemplate;
    },
    _doublingStringsChanged : function () {
        this._$outerTableStartTemplate = null;
        this._$iconsCellTemplate = null;
    },


    //> @classMethod FormItem.getPickerIcon()
    // Returns a +link{formItemIcon} for a standard picker with skin-specific
    // settings.
    // @param pickerName (PickerIconName) Name of picker icon
    // @param [properties] (FormItemIcon) Properties to apply to new picker icon
    // @return (FormItemIcon) the icon for picker
    // @visibility external
    //<
    getPickerIcon : function (pickerName, properties) {
        var iconSrc = isc.FormItem.standardPickers[pickerName];
        if (!iconSrc) return null;
        iconSrc += "." + isc.pickerImgType;

        var hspace = isc.FormItem.defaultPickerIconSpace || 0,
            height = isc.FormItem.defaultPickerIconHeight || 22
        ;
        return isc.addProperties({ hspace: hspace, height: height, src: iconSrc }, properties);
    }
});

isc.FormItem.addClassProperties({

    _inputElementTagName : "input",
    _textElementType : "text",
    _textAreaElementTagName : "textarea",
    _cellStyleCache: {},
    _rtlCellStyleCache: {},

    //> @classAttr FormItem.defaultPickerIconSpace (Integer : 0 : IR)
    // Default +link{formItemIcon.hspace,hspace} value for pickers
    // created by +link{FormItem.getPickerIcon}.
    // @visibility external
    //<

    //> @classAttr FormItem.defaultPickerIconHeight (Integer : 22 : IR)
    // Default +link{formItemIcon.height,height} value for pickers
    // created by +link{FormItem.getPickerIcon}.
    // @visibility external
    //<

    // Standard pickers used with getPickerIcon
    standardPickers: {
        "clear": "[SKIN]/pickers/clear_picker",
        "comboBox": "[SKIN]/pickers/comboBoxPicker",
        "date": "[SKIN]/pickers/date_picker",
        "refresh": "[SKIN]/pickers/refresh_picker",
        "search": "[SKIN]/pickers/search_picker"
    }
});

isc.FormItem.addProperties({

    // Basics
    // ---------------------------------------------------------------------------------------

    //> @type FormItemClassName
    // Name of a SmartClient Class that subclasses +link{FormItem}.  Some values with this type:
    // <ul><li>+link{TextItem,"TextItem"}
    // <li>+link{SliderItem,"SliderItem"},
    // <li>+link{CanvasItem,"CanvasItem"}
    // </ul>
    //
    // @baseType String
    // @visibility external
    //<

    //> @type FormItemType
    // DynamicForms automatically choose the FormItem type for a field based on the
    // <code>type</code> property of the field.  The table below describes the default FormItem
    // chosen for various values of the <code>type</code> property.
    // <P>
    // You can also set +link{FormItem.editorType,field.editorType} to the classname of a
    // +link{FormItem} to override this default mapping.  You can alternatively override
    // +link{dynamicForm.getEditorType()} to create a form with different rules for which
    // FormItems are chosen.
    // <P>
    // @value "text"    Rendered as a +link{class:TextItem}, unless the length of the field (as
    // specified by +link{attr:dataSourceField.length} attribute) is larger than the value
    // specified by +link{attr:dynamicForm.longTextEditorThreshold}, a
    // +link{class:TextAreaItem} is shown.
    //
    // @value "boolean"   Rendered as a +link{class:CheckboxItem}
    //
    // @value "integer"   Rendered as an +link{class:IntegerItem}, a trivial subclass of
    //                    +link{class:TextItem}, by default.
    //                    Consider setting editorType:+link{SpinnerItem}.
    // @value "float"     Rendered as a +link{class:FloatItem}, a trivial subclass of
    //                    +link{class:TextItem}, by default.
    //                    Consider setting editorType:+link{SpinnerItem}.
    // @value "date"      Rendered as a +link{class:DateItem}
    // @value "time"      Rendered as a +link{class:TimeItem}
    // @value "datetime"  Rendered as a +link{class:DateTimeItem}
    // @value "enum"      Rendered as a +link{class:SelectItem}.  Also true for any field that
    //                    specifies a +link{formItem.valueMap}.
    //                    Consider setting editorType:+link{ComboBoxItem}.
    // @value "sequence"  Same as <code>text</code>
    // @value "link"      If +link{dataSourceField.canEdit}<code>:false</code> is set on the field,
    //                    the value is rendered as a +link{class:LinkItem}.  Otherwise the field
    //                    is rendered as a +link{class:TextItem}.
    // @value "image"     If the field is editable, rendered as a +link{TextItem} to edit the
    //                    URL or partial URL<br>
    //                    If +link{formItem.canEdit,non editable}, and
    //                    +link{dynamicForm.readOnlyDisplay,readOnlyDisplay} is "static", an
    //                    image will be rendered out, deriving the URL from the field value
    //                    combined with +link{formItem.imageURLPrefix} and
    //                    +link{formItem.imageURLSuffix} if present. This behavior may be
    //                    suppressed via +link{dynamicForm.showImageAsURL}, in which case
    //                    the value (URL or partial URL) will be rendered out as static text.
    // @value "imageFile" Rendered as a +link{class:FileItem}, or a +link{ViewFileItem} if not editable
    // @value "binary"    Rendered as a +link{class:FileItem}, or a +link{ViewFileItem} if not editable
    //
    // @see attr:FormItem.type
    // @see type:FieldType
    // @visibility external
    //<

    //> @attr formItem.type (FormItemType : "text" : [IR])
    // The DynamicForm picks a field renderer based on the type of the field (and sometimes other
    // attributes of the field).
    //
    // @see type:FormItemType
    // @see type:FieldType
    // @group appearance
    // @visibility external
    //<
    // Note: FormItem.type should not typically be set at the class level as this is likely
    // to break dynamic data type calculation based on criteriaField or on fieldTypeProperty value.
    // Instead a default may be specified via formItem.defaultType


    //> @attr formItem.editorType (FormItem Class : null : [IR])
    // Name of the FormItem to use for editing, eg "TextItem" or "SelectItem".
    // <P>
    // The type of FormItem to use for editing is normally derived automatically from
    // +link{formItem.type,field.type}, which is the data type of the field, by the rules
    // explained +link{type:FormItemType,here}.
    //
    // @see type:FormItemType
    // @see type:FieldType
    // @group appearance
    // @visibility external
    //<

    getReadOnlyDisplay : function () {
        if (this.readOnlyDisplay != null) return this.readOnlyDisplay;

        // Check container(s)
        var item = this;
        while (item.parentItem != null) {
            item = item.parentItem;
            if (item.readOnlyDisplay != null) return item.readOnlyDisplay;
        }

        var form = this.form;
        if (form != null) {
            return form.readOnlyDisplay;
        }

        return isc.DynamicForm._instancePrototype.readOnlyDisplay;
    },

    //> @method formItem.setReadOnlyDisplay()
    // Setter for +link{FormItem.readOnlyDisplay}.
    // <P>
    // Note that calling this method for a +link{ButtonItem} with +link{ButtonItem.enableWhen}
    // set is an error, since +link{readOnlyDisplay} is then considered to always be "disabled".
    // @param appearance (ReadOnlyDisplayAppearance) new <code>readOnlyDisplay</code> value.
    // @visibility external
    //<
    setReadOnlyDisplay : function (appearance) {
        var oldAppearance = this.getReadOnlyDisplay();
        this.readOnlyDisplay = appearance;
        appearance = this.getReadOnlyDisplay();
        var willRedraw = (oldAppearance !== appearance && this.isReadOnly() && this.isDrawn());
        this.updateReadOnlyDisplay(willRedraw);
        if (willRedraw) this.redraw();
    },

    _origReadOnlyDisplay: null,
    updateReadOnlyDisplay : function (willRedraw) {
        var origReadOnlyDisplay = this._origReadOnlyDisplay;

        var readOnlyDisplay = this._origReadOnlyDisplay = this.getReadOnlyDisplay();

        if (origReadOnlyDisplay !== readOnlyDisplay) {
            this._readOnlyDisplayChanged(readOnlyDisplay, willRedraw);
        }
    },

    _readOnlyDisplayChanged : function (appearance, willRedraw) {
        if (this.readOnlyDisplayChanged != null) this.readOnlyDisplayChanged(appearance);
    },

    //> @method formItem.readOnlyDisplayChanged()
    // Notification method called when +link{FormItem.readOnlyDisplay,readOnlyDisplay} is
    // modified. Developers may make use of this to toggle between read-only appearances for
    // custom <code>FormItem</code> types.
    // @param appearance (ReadOnlyDisplayAppearance) new <code>readOnlyDisplay</code> value
    // @return (boolean)
    //<
    //readOnlyDisplayChanged : null,

    getReadOnlyTextBoxStyle : function () {
        return this.readOnlyTextBoxStyle ||
                    (this.form ? this.form.readOnlyTextBoxStyle : "staticTextItem");
    },

    _getClipStaticValue : function () {
        var item = this;
        do {
            var clipStaticValue = item.clipStaticValue;
            if (clipStaticValue != null) return clipStaticValue;

            item = item.parentElement;
        } while (item != null);

        var form = this.form;
        if (form != null) {
            return !!form.clipStaticValue;
        }

        return !!isc.DynamicForm._instancePrototype.clipStaticValue;
    },

    //> @attr formItem.name (FieldName : null : IR)
    // Name for this form field. Must be unique within the form as well as a valid JavaScript
    // identifier - see +link{FieldName} for details and how to check for validity.
    // <P>
    // The FormItem's name determines the name of the property it edits within the form.
    // <P>
    // Note that an item must have a valid name or +link{formItem.dataPath, dataPath} in order
    // for its value to be validated and/or saved.
    //
    // @group basics
    // @visibility external
    //<

    //> @attr formItem.dataPath (DataPath : null : IR)
    // dataPath for this item. Allows the user to edit details nested data structures in a
    // flat set of form fields
    // <P>
    // <b>NOTE: the dataPath feature is intended to help certain legacy architectures,
    // such as systems that work in terms of exchanging large messages with several different
    // entity types in one message, and are incapable of providing separate access to each
    // entity type.<br>
    // See the +link{type:DataPath,DataPath overview} for more information.</b>
    // <P>
    // Note that an item must have a valid dataPath or +link{formItem.name, name} in order
    // for its value to be validated and/or saved.
    // @visibility external
    //<

    //> @attr formItem.title (HTMLString : null : IRW)
    // User visible title for this form item.
    //
    // @group basics
    // @visibility external
    //<

    //> @attr formItem.defaultValue       (Any : null : IRW)
    // Value used when no value is provided for this item. Note that whenever this item's value
    // is cleared programmatically (for example via <code>item.clearValue()</code> or
    // <code>item.setValue(null)</code>), it will be
    // reverted to the <code>defaultValue</code>.
    // <P>
    // Developers should use the
    // +link{DynamicForm.values} object if their intention is to provide an initial value for a
    // field in a form rather than a value to use in place of <code>null</code>.
    // <P>
    // Developers looking to provide a 'hint' or placeholder value for an empty item may wish to use
    // +link{hint} (possibly in conjunction with +link{textItem.showHintInField}), or +link{prompt}.
    // <P>
    // Note: Some items provide a user interface allowing the user to explicitly clear them - for
    // example a standard TextItem. If such an item has a defaultValue specified, and the user explicitly
    // clears that value, the value of the item will be (correctly) reported as null, and will remain
    // null over form item redraw()s. However any programmatic call to set the value to null
    // (including, but not limited to <code>item.clearValue()</code>, <code>item.setValue(null)</code>,
    //  <code>dynamicForm.setValues(...)</code> with a null value for this field, etc) will
    // reset the item value to its default.
    //
    // @see method:defaultDynamicValue
    // @group basics
    // @visibility external
    // @example fieldEnableDisable
    //<

    //> @attr formItem.value (Any : null : IR)
    // Value for this form item.
    // <smartclient>This value may be set directly on the form item initialization
    // block but is not updated on live items and should not be directly accessed.
    // Once a form item has been created by the dynamicForm use +link{FormItem.setValue()} and
    // +link{FormItem.getValue()} directly.</smartclient>
    // @group basics
    // @visibility external
    //<

    //> @attr formItem.ID (GlobalId : null : IRW)
    // Global identifier for referring to the formItem in JavaScript.  The ID property is
    // optional if you do not need to refer to the widget from JavaScript, or can refer to it
    // indirectly (for example, via <code>form.getItem("<i>itemName</i>")</code>).
    // <P>
    // An internal, unique ID will automatically be created upon instantiation for any formItem
    // where one is not provided.
    //
    // @group basics
    // @visibility external
    //<

    //> @attr formItem.emptyDisplayValue (String : "" : IRW)
    // Text to display when this form item has a null or undefined value.
    // <P>
    // If the formItem has a databound pickList, and its +link{formItem.displayField} or
    // +link{formItem.valueField} (if the former isn't set) has an undefined
    // +link{ListGridField.emptyCellValue,emptyCellValue} setting, that field's
    // <code>emptyCellValue</code> will automatically be set to the <code>emptyDisplayValue</code>.
    //
    // @group display_values
    // @visibility external
    //<
    emptyDisplayValue:"",

    //> @attr formItem.hidden (Boolean : null : IR)
    // Should this form item be hidden? Setting this property to <code>true</code> on
    // an item configuration will have the same effect as having a +link{formItem.showIf()}
    // implementation which returns <code>false</code>.
    // <P>
    // Note this differs slightly from +link{dataSourceField.hidden}. That property
    // will cause the field in question to be omitted entirely from databound
    // components by default. A dataSourceField with <code>hidden</code> set to
    // <code>true</code> can still be displayed in a DynamicForm either by being
    // explicitly included in the specified +link{DynamicForm.items,items array}, or
    // by having +link{DataBoundComponent.showHiddenFields} set to true.
    // In this case, this property will not be inherited onto the FormItem instance,
    // meaning the item will be visible in the form even though the <code>hidden</code>
    // property was set to true on the dataSourceField configuration object.
    //
    // @visibility external
    //<

    // ValueMap
    // -----------------------------------------------------------------------------------------

    //> @attr formItem.valueMap (Array | Object: null : IRW)
    // In a form, valueMaps are used for FormItem types that allow the user to pick from a
    // limited set of values, such as a SelectItem.  The valueMap can be either an Array of
    // legal values or an Object where each property maps a stored value to a user-displayable
    // value.
    // <P>
    // To set the initial selection for a form item with a valueMap, use
    // +link{formItem.defaultValue}.
    // <P>
    // See also +link{dataSourceField.valueMap}.
    //
    // @group valueMap
    // @visibility external
    //<

    // optionDataSource
    // ----------------------------------------------------------------------------------------

    //> @attr formItem.optionDataSource        (DataSource | String : null : IR)
    // If set, this FormItem will map stored values to display values as though a
    // +link{valueMap} were specified, by fetching records from the
    // specified <code>optionDataSource</code> and extracting the
    // +link{formItem.valueField,valueField} and
    // +link{formItem.displayField,displayField} in loaded records, to derive one
    // valueMap entry per record loaded from the optionDataSource.
    // <P>
    // With the default setting of +link{formItem.fetchMissingValues,fetchMissingValues}, fetches will be initiated against
    // the optionDataSource any time the FormItem has a non-null value and no corresponding
    // display value is available.  This includes when the form is first initialized, as well
    // as any subsequent calls to +link{formItem.setValue()}, such as may happen when
    // +link{DynamicForm.editRecord()} is called.  Retrieved values are automatically cached by
    // the FormItem.
    // <P>
    // Note that if a normal, static +link{formItem.valueMap,valueMap} is <b>also</b> specified for
    // the field (either directly in the form item or as part of the field definition in the
    // dataSource), it will be preferred to the data derived from the optionDataSource for
    // whatever mappings are present.
    // <P>
    // In a databound form, if +link{FormItem.displayField} is specified for a FormItem and
    // <code>optionDataSource</code> is unset, <code>optionDataSource</code> will default to
    // the form's current DataSource
    //
    // @see FormItem.invalidateDisplayValueCache()
    // @group display_values
    // @visibility external
    // @getter getOptionDataSource()
    // @example listComboBox
    //<

    //> @attr FormItem.optionFilterContext     (RPCRequest Properties : null : IRA)
    // If this item has a specified <code>optionDataSource</code>, and this property is
    // not null, this will be passed to the datasource as +link{rpcRequest} properties when
    // performing the fetch operation on the dataSource to obtain a data-value to display-value
    // mapping
    // @visibility external
    //<

    //> @attr FormItem.optionCriteria     (Criteria : null : IR)
    // If this item has a specified <code>optionDataSource</code>, and this property may be used
    // to specify criteria to pass to the datasource when
    // performing the fetch operation on the dataSource to obtain a data-value to display-value
    // mapping.
    // <p>
    // The criteria generated for this fetch will consist of the specified optionCriteria,
    // combined with criteria required to identify the current item value.<br>
    // For example, if a developer's use case was DataSource of user records, with
    // +link{formItem.valueField} set to <i>"userID"</i>" and +link{formItem.displayField}
    // set to <i>"userName"</i>, the generated criteria to retrieve the display value
    // for the item would look for an exact match between the current item value and the
    // userID field in the dataSource. The <i>optionCriteria</i> would allow additional
    // restrictions on this fetch (searching for records matching some other
    // <i>"region"</i> field, say).<br>
    // The sub-criterion containing the current valueField value will always look for an
    // exact match (rather than any kind of substring match), so if +link{optionTextMatchStyle}
    // is set to something other than "exact", developers may expect to see AdvancedCriteria
    // passed to the server
    // <p>
    // This property supports +link{group:dynamicCriteria} - use +link{criterion.valuePath}
    // to refer to values in the +link{canvas.ruleScope}. Criteria are re-evaluated when
    // the +link{canvas.getRuleContext,rule context} changes.
    //
    // @group databinding
    // @group searchCriteria
    // @visibility external
    //<

    //> @attr FormItem.optionTextMatchStyle (TextMatchStyle : "exact" : IRA)
    // If this item has a specified <code>optionDataSource</code>, this property determines
    // the textMatchStyle to use when interpretating any +link{optionCriteria} during the
    // fetch to map valueField values to displayField values.
    // @group databinding
    // @group searchCriteria
    // @visibility external
    //<
    optionTextMatchStyle:"exact",

    //> @attr FormItem.optionOperationId     (String : null : IRA)
    // If this item has a specified <code>optionDataSource</code>, this attribute may be set
    // to specify an explicit +link{DSRequest.operationId} when performing a fetch against the
    // option dataSource to pick up display value mapping.
    // @group databinding
    // @visibility external
    //<

    //> @attr formItem.valueField  (String : null : IR)
    // If this form item maps data values to display values by retrieving the
    // +link{FormItem.displayField} values from an
    // +link{FormItem.optionDataSource,optionDataSource}, this property
    // denotes the the field to use as the underlying data value in records from the
    // optionDataSource.<br>
    // If not explicitly supplied, the valueField name will be derived as
    // described in +link{formitem.getValueFieldName()}.
    // @group databinding
    // @visibility external
    // @getter getValueFieldName()
    //<

    //> @attr formItem.displayField   (String : null : IR)
    // If set, this item will display a value from another field to the user instead of
    // showing the underlying data value for the +link{formItem.name,field name}.
    // <P>
    // This property is used in two ways:
    // <P>
    // The item will display the displayField value from the
    // +link{dynamicForm.getValues(),record currently being edited} if
    // +link{formItem.useLocalDisplayFieldValue} is true, (or if unset and the conditions
    // outlined in the documentation for that property are met).
    // <P>
    // If this field has an +link{FormItem.optionDataSource}, this property is used by
    // default to identify which value to use as a display value in records from this
    // related dataSource. In this usage the specified displayField must be
    // explicitly defined in the optionDataSource to be used - see
    // +link{getDisplayFieldName()} for more on this behavior.<br>
    // If not using +link{useLocalDisplayFieldValue,local display values}, the display
    // value for this item will be derived by performing a fetch against the
    // +link{formItem.getOptionDataSource(),option dataSource}
    // to find a record where the +link{FormItem.getValueFieldName(),value field} matches
    // this item's value, and use the <code>displayField</code> value from that record.<br>
    // In addition to this, PickList-based form items that provide a list of possible
    // options such as the +link{SelectItem} or +link{ComboBoxItem} will show the
    // <code>displayField</code> values to the user by default, allowing them to choose
    // a new data value (see +link{formItem.valueField}) from a list of user-friendly
    // display values.
    // <P>
    // This essentially allows the specified <code>optionDataSource</code> to be used as
    // a server based +link{group:valueMap}.
    // <P>
    // If +link{formItem.useLocalDisplayFieldValue,local display values}
    // are being used and +link{formItem.storeDisplayValues} is true, selecting a new value
    // will update both the value for this field and the associated display-field value
    // on the record being edited.
    // <P>
    // Note: Developers may specify the +link{formItem.foreignDisplayField} property
    // in addition to <code>displayField</code>. This is useful for cases where the
    // display field name in the local dataSource differs from the display field name in
    // the optionDataSource. See the documentation for
    // +link{dataSourceField.foreignDisplayField} for more on this.<br>
    // If a foreignDisplayField is specified, as with just displayField, if
    // +link{formItem.useLocalDisplayFieldValue,local display values}
    // are being used and +link{formItem.storeDisplayValues} is true, when the user
    // chooses a value the associated display-field value
    // on the record being edited will be updated. In this case it would be set to the
    // foreignDisplayField value from the related record. This means foreignDisplayField
    // is always expected to be set to the equivalent field in the related dataSources.<br>
    // Developers looking to display some <i>other</i> arbitrary field(s) from the
    // related dataSource during editing should consider using custom
    // +link{pickList.pickListFields} instead of setting a foreignDisplayField.
    // <P>
    // Note that if <code>optionDataSource</code> is set and no valid display field is
    // specified,
    // +link{formItem.getDisplayFieldName()} will return the dataSource title
    // field by default.
    // <P>
    // If a displayField is specified for a freeform text based item (such as a
    // +link{ComboBoxItem}), any user-entered value will be treated as a display value.
    // In this scenario, items will derive the data value for the item from the
    // first record where the displayField value matches the user-entered value.
    // To avoid ambiguity, developers may wish to avoid this usage if display values
    // are not unique.
    //
    // @see FormItem.getDisplayFieldName()
    // @see FormItem.invalidateDisplayValueCache()
    // @group databinding
    // @visibility external
    // @getter getDisplayFieldName()
    //<

    //> @attr formItem.useLocalDisplayFieldValue (Boolean : null : IR)
    // If +link{formitem.displayField} is specified for a field, should the
    // display value for the field be picked up from the
    // +link{dynamicForm.getValues(),record currently being edited}?
    // <P>
    // This behavior is typically valuable for dataBound components where the
    // displayField is specified at the DataSourceField level. See
    // +link{dataSourceField.displayField} for more on this.
    // <P>
    // Note that for DataSources backed by the
    // +link{group:serverDataIntegration,SmartClient server}, fields with a specified
    // +link{DataSourceField.foreignKey} and +link{DataSourceField.displayField} will
    // automatically have this property set to true if not explicitly set to false
    // in the dataSource configuration.
    // <P>
    // Otherwise, if not explicitly set, local display value will be used unless:
    // <ul>
    //  <li>This item has an explicitly specified optionDataSource, rather than
    //      deriving its optionDataSource from a specified
    //      +link{dataSourceField.foreignKey} specification</li>
    //  <li>The +link{formItem.name} differs from the
    //      +link{formItem.getValueFieldName(),valueField} for the item</li>
    // </ul>
    //
    // @visibility external
    //<

    //> @attr formItem.foreignDisplayField (String : null : IR)
    // For items with an +link{optionDataSource}, this property specifies an explicit
    // display field for records within the option dataSource. Typically this property
    // will be set in conjunction with +link{formItem.displayField} in the case where
    // the name of the displayField within the record being edited differs from the
    // displayField in the optionDataSource.
    // <P>
    // See +link{dataSourceField.foreignDisplayField} for additional details.
    //
    // @see FormItem.getDisplayFieldName()
    // @visibility external
    //<


    //> @attr formItem.multipleValueSeparator   (String : ', ' : IR)
    // If this item is displaying multiple values, this property will be the
    // string that separates those values for display purposes.
    //
    // @group display_values
    // @visibility external
    //<
    multipleValueSeparator: ", ",

    //> @attr formItem.fetchMissingValues   (Boolean : true : IRWA)
    // If this form item has a specified +link{FormItem.optionDataSource}, should the
    // item ever perform a fetch against this dataSource to retrieve the related record.
    // <P>
    // The fetch occurs if the item value is non null on initial draw of the form
    // or whenever setValue() is called. Once the fetch completes, the returned record
    // is available via the +link{FormItem.getSelectedRecord()} api.
    // <P>
    // By default, a fetch will only occur if +link{formItem.displayField} is specified, and
    // the item does not have an explicit +link{formItem.valueMap} containing the
    // data value as a key.<br>
    // However you can also set +link{formItem.alwaysFetchMissingValues} to have a fetch occur
    // even if no <code>displayField</code> is specified. This ensures
    // +link{formItem.getSelectedRecord()} will return a record if possible - useful for
    // custom formatter functions, etc.
    // <P>
    // Note - for efficiency we cache the associated record once a fetch has been performed, meaning
    // if the value changes, then reverts to a previously seen value, we do not kick
    // off an additional fetch to pick up the display value for the previously seen data value.
    // If necessary this cache may be explicitly invalidated via a call to
    // +link{formItem.invalidateDisplayValueCache()}
    //
    // @group display_values
    // @see formItem.optionDataSource
    // @see formItem.getSelectedRecord()
    // @see formItem.filterLocally
    // @visibility external
    //<
    fetchMissingValues:true,

    //> @attr formItem.alwaysFetchMissingValues (Boolean : false : IRWA)
    // If this form item has a specified +link{FormItem.optionDataSource} and
    // +link{formItem.fetchMissingValues} is true, when the item value changes, a fetch will be
    // performed against the optionDataSource to retrieve the related record
    // if +link{formItem.displayField} is specified and the new item value is not present in any
    // valueMap explicitly specified on the item.
    // <P>
    // Setting this property to true means that a fetch will occur against the optionDataSource
    // to retrieve the related record even if +link{formItem.displayField} is unset, or the
    // item has a valueMap which explicitly contains this field's value.
    // <P>
    // An example of a use case where this might be set would be if +link{formItem.formatValue}
    // or +link{formItem.formatEditorValue} were written to display properties from the
    // +link{formItem.getSelectedRecord(),selected record}.
    // <P>
    // Note - for efficiency we cache the associated record once a fetch has been performed, meaning
    // if the value changes, then reverts to a previously seen value, we do not kick
    // off an additional fetch even if this property is true. If necessary this cache may be
    // explicitly invalidated via a call to +link{formItem.invalidateDisplayValueCache()}
    //
    // @group display_values
    // @visibility external
    //<
    alwaysFetchMissingValues:false,

    //> @attr formItem.loadingDisplayValue (String : "Loading..." : IRW)
    // Value shown in field when +link{fetchMissingValues,fetchMissingValues} is active and a
    // fetch is pending. The field is read-only while a fetch is pending.
    // <P>
    // Set to <code>null</code> to show actual value until display value is loaded.
    // @group display_values
    // @group i18nMessages
    // @visibility external
    //<
    loadingDisplayValue:"Loading...",


    //> @attr formItem.filterLocally (boolean : null : IRA)
    // If this form item is mapping data values to a display value by fetching records from a
    // dataSource (see +link{FormItem.optionDataSource}, +link{FormItem.displayField}
    // and +link{FormItem.fetchMissingValues}), setting this property to true ensures that when
    // the form item value is set, entire data-set from the dataSource is loaded at once and
    // used as a valueMap, rather than just loading the display value for the current value.
    // This avoids the need to perform fetches each time setValue() is called with a new value.
    // <P>
    // See also +link{PickList.filterLocally} for behavior on form items such as SelectItems
    // that show pick-lists.
    //
    // @group display_values
    // @visibility external
    //<

    // Data Type Formatters
    // ---------------------------------------------------------------------------------------
    // Note: dateFormatter and timeFormatter provide a way to control format of date or
    // time data in a generic form item such as a static text item.
    // Consistent name with ListGrid.dateFormatter / timeFormatter

    //> @attr formItem.dateFormatter (DateDisplayFormat : null : [IRWA])
    // Display format to use for date type values within this formItem.
    // <P>
    // Note that Fields of type <code>"date"</code>, <code>"datetime"</code> or
    // <code>"time"</code> will be edited using a +link{DateItem} or +link{TimeItem} by
    // default, but this can be overridden - for <code>canEdit:false</code> fields, a
    // +link{StaticTextItem} is used by default, and the developer can always specify
    // a custom +link{formItem.editorType} as well as +link{formItem.type,data type}.
    // <P>
    // The +link{formItem.timeFormatter} may also be used to format underlying Date values as
    // times (ommitting the date part entirely). If both <code>dateFormatter</code> and
    // <code>timeFormatter</code> are specified on an item, for
    // fields specified as +link{formItem.type,type "time"} the
    // <code>timeFormatter</code> will be used, otherwise the <code>dateFormatter</code>
    // <P>
    // If <code>item.dateFormatter</code> and <code>item.timeFormatter</code> is unspecified,
    // date display format may be defined at the component level via
    // +link{DynamicForm.dateFormatter}, or for fields of type <code>"datetime"</code>
    // +link{DynamicForm.datetimeFormatter}. Otherwise the
    // default is to use the system-wide default short date format, configured via
    // +link{DateUtil.setShortDisplayFormat()}.  Specify any valid +link{type:DateDisplayFormat}
    // to change the format used by this item.
    // <P>
    // Note that if this is a freeform editable field, such a +link{TextItem}, with type
    // specified as <code>"date"</code> or <code>"datetime"</code> the system will automatically
    // attempt to parse user entered values back to a Date value, assuming the entered string
    // matches the date format for the field. Developers may further customize this via an
    // explicit +link{formItem.inputFormat} or via entirely custom
    // <smartclient>
    // +link{formItem.formatEditorValue} and +link{formItem.parseEditorValue} methods.
    // </smartclient>
    // <smartgwt>
    // <code>setEditorValueFormatter</code> and <code>setEditorValueParser</code> methods.
    // </smartgwt>
    //
    // @see formItem.timeFormatter
    // @see formItem.format
    //
    // @group appearance
    // @visibility external
    //<
    //dateFormatter:null

    // Undocumented flag -- if no formatter is explicitly specified and we're looking at
    // a js date value should we use "normal" or "short" formatter by default.
    // Won't effect fields of type "date" since we never want to show the time (which is
    // always displayed in the "normal" format.
    useShortDateFormat:true,

    //> @attr formItem.timeFormatter (TimeDisplayFormat : null : [IRWA])
    // Time-format to apply to date type values within this formItem.  If specified, any
    // dates displayed in this item will be formatted as times using the appropriate format.
    // This is most commonly only applied to fields specified as type <code>"time"</code> though
    // if no explicit +link{formItem.dateFormatter} is specified it will be respected for other
    // fields as well.
    // <P>
    // If unspecified, a timeFormatter may be defined
    // +link{DynamicForm.timeFormatter,at the component level} and will be respected by fields
    // of type <code>"time"</code>.
    //
    // @see formItem.format
    // @group appearance
    // @visibility external
    //<
    //timeFormatter:null

    //> @attr formItem.displayFormat (Varies : null : [IRWA])
    // Fields of type <code>"date"</code> or <code>"time"</code> will be edited using
    // a +link{DateItem} or +link{TimeItem} by default.
    // <P>
    // However this can be overridden - for <code>canEdit:false</code> fields, a
    // +link{StaticTextItem} is used by default, and the developer can always specify
    // a custom +link{formItem.editorType} as well as +link{formItem.type,data type}.
    // <P>
    // For fields of type <code>"date"</code>, set this property to a valid
    // +link{dateDisplayFormat} to specify how the date should be formatted.
    // <br>
    // For fields of type <code>"time"</code>, set this property to a valid
    // +link{type:TimeDisplayFormat, TimeDisplayFormat} to specify how the time should be formatted.
    // <br>
    // Note that if +link{formItem.dateFormatter} or +link{formItem.timeFormatter} are specified
    // they will take precedence over this setting.
    // <P>
    // If this field is of type <code>"date"</code> and is editable, the
    // +link{formItem.inputFormat} may be used to specify how user-edited date strings will
    // be parsed.
    //
    // @deprecated in favor of +link{formItem.format}, +link{formItem.dateFormatter} and
    // +link{formItem.timeFormatter}
    // @see formItem.format
    // @see formItem.inputFormat
    // @see formItem.dateFormatter
    // @see formItem.timeFormatter
    // @visibility external
    //<

    //> @attr formItem.inputFormat (DateInputFormat : null : [IRWA])
    // For fields of type <code>"date"</code>, if this is an editable field such as a
    // +link{TextItem}, this property
    // allows you to specify the +link{DateItem.inputFormat, inputFormat} applied to the item.
    // @see formItem.dateFormatter
    // @visibility external
    //<

    //> @attr formItem.decimalPrecision (number : null : [IRW])
    // @include dataSourceField.decimalPrecision
    //
    // @group appearance
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr formItem.decimalPad (number : null : [IRW])
    // @include dataSourceField.decimalPad
    //
    // @group appearance
    // @serverDS allowed
    // @visibility external
    //<

    //> @attr formItem.format (FormatString : null : IR)
    // +link{FormatString} for numeric or date formatting.  See +link{dataSourceField.format}.
    // @group appearance
    // @visibility external
    //<

    //> @attr formItem.exportFormat (FormatString : null : IR)
    // +link{FormatString} used during exports for numeric or date formatting.  See
    // +link{dataSourceField.exportFormat}.
    // @group exportFormatting
    // @visibility external
    //<


    //> @attr formItem.showInputElement (boolean : true : IRWA)
    // When set to false, prevents this item's input element from being written into the DOM.
    // If there are +link{formItem.valueIcons, valueIcons} or a
    // +link{formItem.showPickerIcon, picker icon}, these are displayed as normal, and the item
    // will auto-sizing to that content if its +link{formItem.width, width} is set to null.
    // @visibility internal
    //<

    showInputElement: true,


    // ValueIcons
    // ---------------------------------------------------------------------------------------
    //> @attr formItem.valueIcons   (Object : null : IRW)
    // A mapping of logical form item values to +link{SCImgURL}s or the special value "blank",
    // which means that no image will be displayed.
    // If specified, when the form item is set to the value in question, an icon will be
    // displayed with the appropriate source URL.
    // @group   valueIcons
    // @setter  setValueIcons()
    // @see     formItem.getValueIcon()
    // @visibility external
    //<

    //> @attr formItem.emptyValueIcon (String : null : IRW)
    // This property allows the developer to specify an icon to display when this item has
    // no value. It is configured in the same way as any other valueIcon
    // (see +link{formItem.valueIcons})
    // @group valueIcons
    // @visibility external
    //<

    //> @attr formItem.showValueIconOnly (boolean : null : IRWA)
    // If +link{FormItem.valueIcons} is set, this property may be set to show the valueIcon
    // only and prevent the standard form item element or text from displaying
    // @group valueIcons
    // @visibility external
    //<
    //> @attr formItem.suppressValueIcon (boolean : null : IRWA)
    // If +link{FormItem.valueIcons} is set, this property may be set to prevent the value
    // icons from showing up next to the form items value
    // @group valueIcons
    // @visibility external
    //<

    // If we're showing the valueIcon only, should horizontally fit to it?
    // We use this in the CheckboxItem class where we want to have a default width
    // specified (150), but essentially ignore it and allow a very thin column if
    // showLabel is false
    fitWidthToValueIcon : function () {
        return false;
    },

    //> @attr formItem.valueIconWidth (number : null : IRW)
    // If +link{formItem.valueIcons} is specified, use this property to specify a width for
    // the value icon written out.
    // @see FormItem.valueIconHeight
    // @see FormItem.valueIconSize
    // @group valueIcons
    // @visibility external
    //<

    //> @attr formItem.valueIconHeight (number : null : IRW)
    // If +link{formItem.valueIcons} is specified, use this property to specify a height for the
    // value icon written out.
    // @see FormItem.valueIconWidth
    // @see FormItem.valueIconSize
    // @group valueIcons
    // @visibility external
    //<

    //> @attr formItem.valueIconSize (number : 16 : IRW)
    // If +link{formItem.valueIcons} is specified, this property may be used to specify both
    // the width and height of the icon written out.
    // Note that +link{FormItem.valueIconWidth} and +link{formItem.valueIconHeight} take
    // precedence over this value, if specified.
    // @see FormItem.valueIconWidth
    // @see FormItem.valueIconHeight
    // @group valueIcons
    // @visibility external
    //<
    valueIconSize:16,

    //> @attr formItem.valueIconLeftPadding (number : 0 :  IRW)
    // If we're showing a value icon, this attribute governs the amount of space between the
    // icon and the start edge of the form item cell.
    // <p>
    // <b>NOTE:</b> In RTL mode, the valueIconLeftPadding is applied to the <em>right</em> of
    // the value icon.
    // @see FormItem.valueIcons
    // @visibility external
    // @group valueIcons
    //<
    valueIconLeftPadding:0,

    //> @attr formItem.valueIconRightPadding (number : 3 :  IRW)
    // If we're showing a value icon, this attribute governs the amount of space between the
    // icon and the value text.
    // <p>
    // <b>NOTE:</b> In RTL mode, the valueIconRightPadding is applied to the <em>left</em> of
    // the value icon.
    // @see FormItem.valueIcons
    // @visibility external
    // @group valueIcons
    //<
    valueIconRightPadding:3,

    //> @method formItem.valueIconClick()
    // Notification method fires when the user clicks a +link{valueIcons,value icon} for
    // this item.
    // @param form (DynamicForm) the form containing this item
    // @param item (FormItem) the FormItem containing the valueIcon
    // @param value (Any) the current value of the item.
    // @return (boolean) Return false to suppress standard click handling for the item.
    // @visibility external
    //<
    valueIconClick : function () {},

    //> @attr formItem.imageURLPrefix (String : null : IRWA)
    // Prefix to apply to the beginning of any +link{FormItem.valueIcons} when determining the
    // URL for the image.
    // Will not be applied if the <code>valueIcon</code> URL is absolute.
    // @group valueIcons
    // @visibility external
    //<

    //> @attr formItem.imageURLSuffix (String : null : IRWA)
    // Suffix to apply to the end of any +link{FormItem.valueIcons} when determining the URL for
    // the image. A common usage would be to specify a suffix of <code>".gif"</code> in which
    // case the <code>valueIcons</code> property would map values to the names of images without
    // the <code>".gif"</code> extension.
    // @group valueIcons
    // @visibility external
    //<

    // Internal
    // ---------------------------------------------------------------------------------------

    //> @attr formItem.form     (DynamicForm : null : R)
    // A Read-Only pointer to this formItem's DynamicForm widget.
    // @visibility external
    //<
    // Handles values for the form item.  Also handles writing the item's HTML by default.

    //> @attr formItem.containerWidget  (Canvas : null : RA)
    // A Read-Only pointer to the SmartClient canvas that holds this form item. In most cases this
    // will be the +link{formItem.form,DynamicForm} containing the item but in some cases
    // editable components handle writing out form items directly. An example of this
    // is +link{group:editing,Grid Editing} - when a listGrid shows per-field editors, the
    // <code>containerWidget</code> for each item will be the listGrid body.
    // <P>
    // Note that even if the <code>containerWidget</code> is not a DynamicForm, a DynamicForm
    // will still exist for the item (available as +link{formItem.form}), allowing access
    // to standard APIs such as +link{dynamicForm.getValues()}
    // @visibility external
    //<



    //> @method formItem.isInGrid()
    // Returns true if this item's +link{containerWidget,containerWidget} is a
    // +link{class:GridRenderer} or GridRenderer subclass
    //
    // @return (Boolean) whether the item's container is a GridRenderer (and thus ultimately
    //                   a ListGrid)
    // @visibility external
    //<
    isInGrid : function () {

        return this._inGrid ? true : isc.isA.GridRenderer(this.containerWidget);
    },

    //> @method formItem.getListGrid()
    // If this item is being used to edit cells in a ListGrid (see +link{formItem.isInGrid()}),
    // this method returns the grid in question.
    //
    // @return (ListGrid) For listGrid edit items, the listGrid containing the item. Will
    //   return null for items that are edit items of a listGrid.
    // @visibility external
    //<
    // This helper is useful as otherwise you'd need to pick up the ListGrid from the
    // parent grid renderer (which may not be a direct child of the ListGrid if there
    // are frozen fields).

    getListGrid : function () {
        return this.isInGrid() ? this.form && this.form.grid : null;
    },

    //> @method formItem.getGridRowNum()
    // If this formItem is part of a +link{class:ListGrid}'s
    // +link{listGrid.canEdit,inline edit form}, returns the number of the row currently being
    // edited.  If the formItem is not part of a ListGrid inline edit for any reason, this
    // method returns null.  Reasons for a formItem not being part of an inline edit include<ul>
    // <li>The item is part of an ordinary DynamicForm, not an inline edit form</li>
    // <li>There is no row in the grid currently being edited</li>
    // <li>A row is being edited, but this formItem is not currently visible and is being
    // excluded because of horizontal incremental rendering (where SmartClient avoids drawing
    // grid columns that would not be visible without scrolling)</li>
    // </ul>
    //
    // @return (Integer) The grid row number being edited or null, as described above
    // @visibility external
    //<
    getGridRowNum : function () {
        return this.rowNum;
    },

    //> @method formItem.getGridColNum()
    // If this formItem is part of a +link{class:ListGrid}'s
    // +link{listGrid.canEdit,inline edit form}, returns the number of the grid column this
    // formItem is responsible for editing, but <b>only</b> if a row is currently being
    // edited.  If the formItem is not part of a ListGrid inline edit for any reason, this
    // method returns null.  Reasons for a formItem not being part of an inline edit include<ul>
    // <li>The item is part of an ordinary DynamicForm, not an inline edit form</li>
    // <li>There is no row in the grid currently being edited</li>
    // <li>A row is being edited, but this formItem is not currently visible and is being
    // excluded because of horizontal incremental rendering (where SmartClient avoids drawing
    // grid columns that would not be visible without scrolling)</li>
    // </ul>
    //
    // @return (Integer) The grid column number being edited by this formItem, or null, as
    //                   described above
    // @visibility external
    //<
    getGridColNum : function () {
        return this.colNum;
    },

    // Helper to get the top level ancestor of our containerWidget

    getTopLevelCanvas : function () {
        return this.containerWidget ? this.containerWidget.getTopLevelCanvas() : null;
    },


    // RelationItem
    // ---------------------------------------------------------------------------------------

    //> @attr formItem.dataSource (DataSource | String : null : [IRWA])
    //
    // If this FormItem represents a foreignKey relationship into the dataSource of the form
    // containing this item, specify it here.
    //
    //  @visibility experimental
    //<


    // Picker Icon
    // -----------------------------------------------------------------------------------------

    //> @attr formItem.showPickerIcon (Boolean : null : IRW)
    // Should we show a special 'picker' +link{FormItemIcon,icon} for this form item? Picker
    // icons are customizable via +link{formItem.pickerIconProperties,pickerIconProperties}. By default
    // they will be rendered inside the form item's +link{formItem.controlStyle,"control box"}
    // area. By default clicking the pickerIcon will call +link{FormItem.showPicker()}.
    //
    // @group pickerIcon
    // @visibility external
    //<


    //> @attr formItem.showFocusedPickerIcon (Boolean : false : [IRW])
    // If +link{FormItem.showPickerIcon} is true for this item, should the picker icon show
    // a focused image when the form item has focus?
    // @group pickerIcon
    // @visibility external
    //<
    showFocusedPickerIcon:false,

    // We draw the icon into an exactly sized table cell - don't draw with any margin

    pickerIconHSpace:0,

    //> @attr formItem.pickerIconDefaults (FormItemIcon Properties : ... : IRWA)
    // Block of default properties to apply to the pickerIcon for this widget.
    // Intended for class-level customization: To modify this value we recommend using
    // +link{Class.changeDefaults()} rather than directly assigning a value to the property.
    // @group pickerIcon
    // @visibility external
    //<
    pickerIconDefaults: {
    },

    //> @attr formItem.pickerIconProperties (FormItemIcon Properties : null : IRWA)
    // If +link{showPickerIcon,showPickerIcon} is true for this item, this block of properties will
    // be applied to the pickerIcon. Allows for advanced customization of this icon.
    // @group pickerIcon
    // @visibility external
    //<

    //> @attr formItem.pickerIconName (Identifier : "picker" : IRA)
    // If +link{showPickerIcon,showPickerIcon} is true, this attribute specifies the
    // +link{formItemIcon.name} applied to the picker icon
    // @group pickerIcon
    // @visibility external
    //<
    pickerIconName:"picker",

    //> @attr formItem.pickerIconSrc (SCImgURL : "" : IRWA)
    // If +link{showPickerIcon,showPickerIcon} is true for this item, this property governs the
    // +link{FormItemIcon.src,src} of the picker icon image to be displayed.
    // <P>
    // +link{group:skinning,Spriting} can be used for this image, by setting this property to
    // a +link{type:SCSpriteConfig} formatted string.
    //
    // @group pickerIcon
    // @visibility external
    //<
    pickerIconSrc:"",

    //> @attr formItem.pickerIconWidth (int : null : IRWA)
    // If +link{showPickerIcon,showPickerIcon} is true for this item, this property governs the
    // size of the picker icon. If unset, the picker icon will be sized as a square to fit in the
    // available height for the icon.
    // <p>
    // Note that if spriting is being used, and the image to be displayed is specified
    // using css properties such as <code>background-image</code>, <code>background-size</code>,
    // changing this value may result in an unexpected appearance as the image will not
    // scale.<br>
    // Scaleable spriting can be achieved using the +link{SCSpriteConfig} format.
    // See the section on spriting in the +link{group:skinning,skinning overview} for
    // further information.
    // @group pickerIcon
    // @visibility external
    //<

    //> @attr formItem.pickerIconHeight (int : null : IRWA)
    // If +link{showPickerIcon,showPickerIcon} is true for this item, this property governs the
    // size of the picker icon. If unset, the picker icon will be sized as a square to fit in the
    // available height for the icon.
    // <p>
    // Note that if spriting is being used, and the image to be displayed is specified
    // using css properties such as <code>background-image</code>, <code>background-size</code>,
    // changing this value may result in an unexpected appearance as the image will not
    // scale.<br>
    // Scaleable spriting can be achieved using the +link{SCSpriteConfig} format.
    // See the section on spriting in the +link{group:skinning,skinning overview} for
    // further information.
    //
    // @group pickerIcon
    // @visibility external
    //<

    //> @attr formItem.pickerIconPrompt (HTMLString : null : IR)
    // Prompt to show when the user hovers the mouse over the picker icon.
    // @group pickerIcon
    // @group i18nMessages
    // @visibility external
    //<

    //> @type PickerIconName
    // Standard pickers
    // @value "clear" Picker icon to clear a field value.
    // @value "search" Picker icon to start a search.
    // @value "refresh" Picker icon to refresh a value.
    // @value "date" Picker icon for date value.
    // @value "comboBox" Picker icon for a general combobox.
    //
    // @visibility external
    //<

    // Picker Widget (pop-up launched by picker icon)
    // -----------------------------------------------------------------------------------------

    //> @attr formItem.picker (AutoChild Canvas : null : [IRW])
    // The component that will be displayed when +link{showPicker()} is called due to a click
    // on the +link{showPickerIcon,picker icon}.
    // <P>
    // Can be specified directly as a Canvas, or created automatically via the
    // +link{type:AutoChild} pattern. The default autoChild configuration for the picker is
    // a Canvas with backgroundColor set and no other modifications.
    // <P>
    // Note that the picker is not automatically destroyed with the FormItem that uses it, in
    // order to allow recycling of picker components.  To destroy a single-use picker, override
    // +link{Canvas.destroy()}.
    //
    // @visibility external
    //<

    pickerDefaults:{
        backgroundColor:"lightgray"
    },

    //> @attr formItem.pickerConstructor (SCClassName : null : [IRW])
    // Class name of the picker to be created.
    //
    // @visibility external
    //<

    //> @attr formItem.pickerProperties (Canvas Properties : {} : [IRW])
    // Default properties for the picker.
    //
    // @visibility external
    //<


    // Validation
    // -----------------------------------------------------------------------------------------

    //> @attr formItem.validators     (Array of Validator : null : IR)
    // Validators for this form item.
    // <P>
    // <b>Note:</b> these validators will only be run on the client; to
    // do real client-server validation, validators must be specified via
    // +link{dataSourceField.validators}.
    // @visibility external
    //<

    //> @attr formItem.required (Boolean : null : [IR])
    // Whether a non-empty value is required for this field to pass validation.
    // <P>
    // If the user does not fill in the required field, the error message to be shown will
    // be taken from these properties in the following order: +link{FormItem.requiredMessage},
    // +link{DynamicForm.requiredMessage}, +link{DataSource.requiredMessage},
    // +link{Validator.requiredField}.
    // <P>
    // <b>Note:</b> if specified on a FormItem, <code>required</code> is only enforced on the
    // client.  <code>required</code> should generally be specified on a
    // +link{class:DataSourceField}.
    //
    // @group validation
    // @visibility external
    // @example formShowAndHide
    //<

    //> @attr   formItem.requiredMessage     (HTMLString : null : [IRW])
    // The required message for required field errors.
    // @group validation
    // @visibility external
    //<

    //> @attr formItem.requiredWhen (Criteria : null : IR)
    // Criteria to be evaluated to determine whether this FormItem should be +link{required,required}.
    // <p>
    // Criteria are evaluated against the +link{dynamicForm.getValues,form's current values} as well as
    // the current +link{canvas.ruleScope,rule context}.  Criteria are re-evaluated every time
    // form values or the rule context changes, whether by end user action or by programmatic calls.
    // <P>
    // A basic criteria uses textMatchStyle:"exact". When specified in
    // +link{group:componentXML,Component XML} this property allows
    // +link{group:xmlCriteriaShorthand,shorthand formats} for defining criteria.
    // <p>
    // Note: A FormItem using requiredWhen must have a +link{name} defined.
    // @group ruleCriteria
    // @group validation
    // @visibility external
    //<


    // Status
    // -----------------------------------------------------------------------------------------

    //> @attr formItem.visible (Boolean : true : IRW)
    // Whether this item is currently visible.
    // <P>
    // <code>visible</code> can only be set on creation.  After creation, use
    // +link{formItem.show()} and +link{formItem.hide()} to manipulate visibility.
    //
    // @group appearance
    // @visibility external
    //<
    visible:true,

    //> @attr formItem.visibleWhen (AdvancedCriteria : null : IR)
    // Criteria to be evaluated to determine whether this FormItem should be visible.
    // <p>
    // Criteria are evaluated against the +link{dynamicForm.getValues,form's current values} as well as
    // the current +link{canvas.ruleScope,rule context}.  Criteria are re-evaluated every time
    // form values or the rule context changes, whether by end user action or by programmatic calls.
    // <p>
    // If both +link{showIf} and <code>visibleWhen</code> are specified, <code>visibleWhen</code> is
    // ignored.
    // <P>
    // A basic criteria uses textMatchStyle:"exact". When specified in
    // +link{group:componentXML,Component XML} this property allows
    // +link{group:xmlCriteriaShorthand,shorthand formats} for defining criteria.
    // <p>
    // Note: A FormItem using visibleWhen must have a +link{name} defined. +link{shouldSaveValue} can
    // be set to <code>false</code> to prevent the field from storing its value
    // into the form's values.
    // @group ruleCriteria
    // @group appearance
    // @visibility external
    //<

    //>    @attr    formItem.alwaysTakeSpace    (boolean : false : IRW)
    // If this form item is not visible, should they form it is contained in re-layout to
    // take advantage of the additional space, or should it continue to flow as if the
    // item were visible.  Set to true to have the form continue to flow around the item
    // even if it's not written out.
    //
    // @group appearance
    // @visibility internal
    //<

    //> @attr formItem.canEdit  (boolean : null : IRW)
    // Is this form item editable (canEdit:true) or read-only (canEdit:false)? Setting the
    // form item to non-editable causes it to render as read-only. Can be updated at runtime via
    // the +link{formItem.setCanEdit(),setCanEdit()} method.
    // <P>
    // Read-only appearance may be specified via +link{formItem.readOnlyDisplay}.
    // The default setting for this value (<code>"readOnly"</code>) differs from
    // the disabled state in that the form item is not rendered with disabled styling and
    // most form items will allow copying of the contents while read-only but do not while
    // disabled.
    // <P>
    // Note that for forms bound to a +link{DataSource}, if this property is not explicitly
    // set at the item level, its default value will match the
    // +link{DynamicForm.canEditFieldAttribute} on the associated dataSource field.
    // <P>
    // Developers should also be aware that the +link{readOnlyDisplay} attribute is
    // unrelated to the +link{dataSourceField.readOnlyEditorType} attribute. When a
    // DynamicForm is first bound to a dataSource, for
    // +link{dataSourceField.canEdit,canEdit:false} DataSourceFields,
    // +link{dataSourceField.readOnlyEditorType} will determine what +link{FormItemType}
    // should be created for the field. Once created, a FormItem's type can not be changed.
    // Setting +link{formItem.canEdit} at runtime will simply change the appearance
    // of the item to allow or disallow editing of the item.
    //
    // <smartgwt><P>Note that this property may validly be <code>null</code> as a distinct state
    // from <code>false</code>.  See +link{dynamicForm.fieldIsEditable()} for an API that will
    // always return <code>true</code> or <code>false</code> and give a definitive answer as to
    // whether editing is possible.</smartgwt>
    //
    // @setter setCanEdit()
    // @group readOnly
    // @see FormItem.setCanEdit()
    // @see DynamicForm.setCanEdit()
    // @visibility external
    //<
    //canEdit: null,

    //> @attr formItem.readOnlyDisplay (ReadOnlyDisplayAppearance : null : IRW)
    // If this item is +link{FormItem.getCanEdit(),read-only}, how should this item be displayed
    // to the user? If set, overrides the form-level +link{DynamicForm.readOnlyDisplay} default.
    // @see DynamicForm.readOnlyDisplay
    // @group appearance
    // @group readOnly
    // @visibility external
    //<
    //readOnlyDisplay: null,

    //> @attr formItem.readOnlyTextBoxStyle (FormItemBaseStyle : null : IRW)
    // Base text box style to apply when this item is +link{FormItem.getCanEdit(),read-only} and
    // is using +link{FormItem.readOnlyDisplay,readOnlyDisplay}
    // <smartclient>"static".</smartclient>
    // <smartgwt>{@link com.smartgwt.client.types.ReadOnlyDisplayAppearance#STATIC}.</smartgwt>
    // If set, overrides the form-level +link{DynamicForm.readOnlyTextBoxStyle} default.
    // @see DynamicForm.readOnlyTextBoxStyle
    // @visibility external
    //<
    //readOnlyTextBoxStyle: null,

    //> @attr formItem.readOnlyControlStyle (FormItemBaseStyle : null : IRW)
    // Modified +link{controlStyle,control style} to apply when this item is +link{FormItem.getCanEdit(),read-only} and
    // is using +link{FormItem.readOnlyDisplay,readOnlyDisplay}
    // <smartclient>"static".</smartclient>
    // <smartgwt>{@link com.smartgwt.client.types.ReadOnlyDisplayAppearance#STATIC}.</smartgwt>
    // @visibility external
    //<


    //> @attr formItem.clipStaticValue (Boolean : null : IR)
    // If this item is +link{FormItem.getCanEdit(),read-only} and is using
    // +link{FormItem.readOnlyDisplay,readOnlyDisplay}
    // <smartclient>"static",</smartclient>
    // <smartgwt>{@link com.smartgwt.client.types.ReadOnlyDisplayAppearance#STATIC},</smartgwt>
    // should the item value be clipped if it overflows the specified size of the item?
    // If set, overrides the form-level +link{DynamicForm.clipStaticValue} default.
    // @see DynamicForm.clipStaticValue
    // @visibility external
    //<
    //clipStaticValue: null,

    //> @attr formItem.readOnlyWhen (AdvancedCriteria : null : IR)
    // Criteria to be evaluated to determine whether this FormItem should be made
    // +link{setCanEdit,read-only}.  Appearance when read-only is determined by
    // +link{readOnlyDisplay}.
    // <p>
    // Criteria are evaluated against the +link{dynamicForm.getValues,form's current values} as well as
    // the current +link{canvas.ruleScope,rule context}.  Criteria are re-evaluated every time
    // form values or the rule context changes, whether by end user action or by programmatic calls.
    // <P>
    // A basic criteria uses textMatchStyle:"exact". When specified in
    // +link{group:componentXML,Component XML} this property allows
    // +link{group:xmlCriteriaShorthand,shorthand formats} for defining criteria.
    // <p>
    // Note: A FormItem using readOnlyWhen must have a +link{name} defined. +link{shouldSaveValue} can
    // be set to <code>false</code> to prevent the field from storing its value
    // into the form's values.
    //
    // @group ruleCriteria
    // @group readOnly
    // @visibility external
    //<

    //>    @attr    formItem.disabled        (Boolean : false : IRW)
    // Whether this item is disabled.  Can be updated at runtime via the <code>setDisabled()</code>
    // method.  Note that if the widget containing this formItem is disabled, the formItem will
    // behave in a disabled manner regardless of the setting of the item.disabled property.
    // <p>
    // Note that not all items can be disabled, and not all browsers show an obvious disabled style
    // for native form elements.
    // @group appearance
    // @setter setDisabled()
    // @see FormItem.setDisabled()
    // @visibility external
    // @example fieldEnableDisable
    //<

    //> @attr formItem.disableIconsOnReadOnly (Boolean : true : IRW)
    // If +link{formItem.canEdit} is set to false, should +link{formItem.icons,icons} be disabled
    // by default?
    // <P>
    // This may also be specified at the icon level. See +link{formItemIcon.disableOnReadOnly}.
    // @group formIcons
    // @visibility external
    //<
    disableIconsOnReadOnly:true,

    // Keyboard handling
    // -----------------------------------------------------------------------------------------

    //>@attr formItem.canFocus  (boolean : null : IRA)
    // Is this form item focusable? Setting this property to true on an otherwise
    // non-focusable element such as a +link{StaticTextItem} will cause the item to be
    // included in the page's tab order and respond to keyboard events.
    // @group focus
    // @visibility external
    //<
    // If not set focusability is determined by whether this item has a data element by default.
    // If set to true, and this item has no data element we write out HTML to allow focus
    // on the item's text-box.

    //> @attr formItem.accessKey  (String : null : IRW)
    // If specified this governs the HTML accessKey for the item.
    // <P>
    // This should be set to a character - when a user hits the html accessKey modifier for
    // the browser, plus this character, focus will be given to the item.
    // The accessKey modifier can vary by browser and platform.
    // <P>
    // The following list of default behavior is for reference only, developers should also
    // consult browser documentation for additional information.
    // <ul>
    // <li><b>Internet Explorer (all platforms)</b>: <code>Alt</code> + <i>accessKey</i></li>
    // <li><b>Mozilla Firefox (Windows, Unix)</b>: <code>Alt+Shift</code> + <i>accessKey</i></li>
    // <li><b>Mozilla Firefox (Mac)</b>: <code>Ctrl+Opt</code> + <i>accessKey</i></li>
    // <li><b>Chrome and Safari (Windows, Unix)</b>:  <code>Alt</code> + <i>accessKey</i></li>
    // <li><b>Chrome and Safari (Mac)</b>:  <code>Ctrl+Opt</code> + <i>accessKey</i></li>
    // </ul>
    //
    // @group focus
    // @visibility external
    //<

    accessKey:null,

    //> @attr formItem.tabIndex (Integer : null : IRW)
    // TabIndex for the form item within the form, which controls the order in which controls
    // are visited when the user hits the tab or shift-tab keys to navigate between items.
    // <P>
    // tabIndex is automatically assigned as the order that items appear in the
    // +link{dynamicForm.items} list.
    // <P>
    // To specify the tabindex of an item within the page as a whole (not just this form), use
    // +link{globalTabIndex} instead.
    //
    //  @visibility external
    // @setter formItem.setTabIndex()
    //  @group focus
    //<
    //tabIndex:null,

    //> @attr formItem.globalTabIndex (Integer : null : IRWA)
    // TabIndex for the form item within the page. Takes precedence over any local tab index
    // specified as +link{tabIndex,item.tabIndex}.
    // <P>
    // Use of this API is <b>extremely</b> advanced and essentially implies taking over
    // management of tab index assignment for all components on the page.
    //
    // @group focus
    // @visibility external
    //<
    //globalTabIndex:null,

    //> @attr   formItem.selectOnFocus  (boolean : null : IRW)
    // Allows the +link{dynamicForm.selectOnFocus,selectOnFocus} behavior to be configured on a
    // per-FormItem basis.  Normally all items in a form default to the value of
    // +link{dynamicForm.selectOnFocus}.
    //
    // @group focus
    // @visibility external
    //<
    // Exposed on TextItem and TextAreaItem directly since it won't apply to other items.

    //> @attr   formItem.selectOnClick  (boolean : null : IRW)
    // Allows the +link{dynamicForm.selectOnClick,selectOnClick} behavior to be configured on a
    // per-FormItem basis.  Normally all items in a form default to the value of
    // +link{dynamicForm.selectOnClick}.
    //
    // @group focus
    // @visibility external
    //<
    // Exposed on TextItem and TextAreaItem directly since it won't apply to other items.


    //> @attr formItem.changeOnKeypress (Boolean : true : IRW)
    // Should this form item fire its +link{formItem.change(),change} handler (and store its
    // value in the form) on every keypress? Set to <code>false</code> to suppress the 'change'
    // handler firing (and the value stored) on every keypress.
    // <p>
    // Note: If <code>false</code>, the value returned by +link{formItem.getValue(),getValue}
    // will not reflect the value displayed in the form item element as long as focus is in
    // the form item element.
    //
    // @group  eventHandling, values
    // @visibility external
    //<
    changeOnKeypress:true,

    // maintainSelectionOnTransform
    // Internal, but non obfuscated property.
    // Ensure selection is maintained if:
    // - the value is reverted due to a change handler returning false during typing
    // - the value is modified during typing, but either the value is unchanged except for
    //   case shifting, or the entire value was selected before typing.
    // If this causes a performance hit in any cases, we can disable it.
    maintainSelectionOnTransform:true,


    //> @attr   formItem.dirtyOnKeyDown (boolean : true : RW)
    //  Should this form item get marked as dirty on every keyDown?
    //  @group  eventHandling, values
    //<
    dirtyOnKeyDown:true,

    // Titles
    // --------------------------------------------------------------------------------------------
    //> @attr formItem.showTitle (Boolean : true : IRW)
    // Should we show a title cell for this formItem?
    // <p>
    // Note: the default value of this attribute is overridden by some subclasses.
    //
    // @group title
    // @visibility external
    //<
    showTitle:true,

    //> @attr formItem.titleOrientation (TitleOrientation : isc.Canvas.LEFT : IRW)
    // On which side of this item should the title be placed.  +link{type:TitleOrientation}
    // lists valid options.
    // <P>
    // Note that titles on the left or right take up a cell in tabular
    // +link{group:formLayout,form layouts}, but titles on top do not.
    //
    // @group title
    // @see DynamicForm.titleOrientation
    // @visibility external
    //<
// titleOrientation:isc.Canvas.LEFT, // dynamically defaulted in DynamicForm

    //> @attr formItem.titleAlign (Alignment : null : IRW)
    // Alignment of this item's title in its cell.
    // <p>
    // If null, dynamically set according to text direction.
    // @group title
    // @visibility external
    //<

    //> @attr formItem.titleVAlign (VerticalAlignment : isc.Canvas.CENTER : IRW)
    // Vertical alignment of this item's title in its cell. Only applies when
    // +link{formItem.titleOrientation} is <code>"left"</code> or <code>"right"</code>.
    // @group title
    // @visibility external
    //<
//    titleVAlign:isc.Canvas.CENTER, // dynamically defaulted in getTitleVAlign

    //> @attr formItem.clipTitle (boolean : null : [IRW])
    // If the title for this form item is showing, and is too large for the available space
    // should the title be clipped?
    // <p>
    // Null by default - if set to true or false, overrides +link{DynamicForm.clipItemTitles}.
    // @group title
    // @visibility external
    //<
    clipTitle:null,

    //> @attr formItem.wrapTitle (boolean : null : [IRW])
    // If specified determines whether this items title should wrap.
    // Overrides +link{DynamicForm.wrapItemTitles,wrapItemTitles} at the DynamicForm level.
    // @group title
    // @visibility external
    //<
//    wrapTitle:null,

    // Change handling
    // --------------------------------------------------------------------------------------------

    //> @attr formItem.redrawOnChange (Boolean : false : IRW)
    // If true, this item will cause the entire form to be redrawn
    // when the item's "elementChanged" event is done firing
    // @group changeHandling
    // @visibility external
    //<

    //> @attr formItem.validateOnChange (Boolean : false : IRW)
    // If true, form items will be validated when each item's "change" handler is fired
    // as well as when the entire form is submitted or validated.
    // <p>
    // Note that this property can also be set at the form level or on each validator;
    // If true at the form or field level, validators not explicitly set with
    // <code>validateOnChange:false</code> will be fired on change - displaying errors and
    // rejecting the change on validation failure.
    // @group changeHandling
    // @visibility external
    // @see DynamicForm.validateOnChange
    //<


    //> @attr formItem.validateOnExit (Boolean : false : IRW)
    // If true, form items will be validated when each item's "editorExit" handler is fired
    // as well as when the entire form is submitted or validated.
    // <p>
    // Note that this property can also be set at the form level.
    // If true at either level the validator will be fired on editorExit.
    // @visibility external
    // @see dynamicForm.validateOnExit
    //<

    //> @attr formItem.stopOnError (boolean : null : IR)
    // Indicates that if validation fails, the user should not be allowed to exit
    // the field - focus will be forced back into the field until the error is corrected.
    // <p>
    // This property defaults to +link{DynamicForm.stopOnError} if unset.
    // <p>
    // Enabling this property also implies +link{FormItem.validateOnExit} is automatically
    // enabled. If there are server-based validators on this item, setting this property
    // also implies that +link{FormItem.synchronousValidation} is forced on.
    //
    // @visibility external
    //<

    //> @attr formItem.rejectInvalidValueOnChange (Boolean : false : IRWA)
    // If validateOnChange is true, and validation fails for this item on change, with no suggested
    // value, should we revert to the previous value, or continue to display the bad value entered
    // by the user. May be set at the item or form level.
    // @visibility external
    //<
    // Introduced for back-compat: pre 7.0beta2 this was the default behavior, so enable this flag
    // at the item or form level if required for backcompat.
    //rejectInvalidValueOnChange:null,


    //>    @attr formItem.changeOnBlur (boolean : false : IRWA)
    // If true, this item will fire it's elementChanged message on BLUR in a field (eg: when the
    // user tabs through without making changes as well as when they actually change something), if
    // false, the message will only fire when the field is actually changed.  This is useful for
    // fields that do validation/value setting on change (such as the TimeItem), to work around a
    // bug in IE where the change event doesn't always fire correctly when you manually set the
    // value of the field in its ONCHANGE handler.  Note that it is not recommended that you set
    // both changeOnBlur==true AND redrawOnChange==true, as this will cause the form to redraw every
    // time you tab through that item.
    // @group changeHandling
    //<


    //> @attr  formItem.synchronousValidation (boolean : null : IR)
    // If enabled, whenever validation is triggered and a request to the server is required,
    // user interactivity will be blocked until the request returns. Can be set for the entire
    // form or individual FormItems.
    // <p>
    // If false, the form will try to avoid blocking user interaction until it is strictly
    // required. That is until the user attempts to use a FormItem whose state could be
    // affected by a server request that has not yet returned.
    //
    // @visibility external
    //<

    // Size and Layout
    // --------------------------------------------------------------------------------------------
    //> @attr formItem.width (int | String : "*" : IRW)
    // Width of the FormItem.  Can be either a number indicating a fixed width in pixels, or
    // "*" indicating the FormItem fills the space allocated to it's column (or columns, for a
    // +link{colSpan,column spanning} item).  You may also use "100%" as a synonym for "*", but
    // other percentages are not supported.
    // <P>
    // Note that for "absolute" item layout rather than the default "table" layout, the rules
    // for specifying the width are slightly different.  All percent sizes are allowed, but not
    // "*".  See +link{dynamicForm.itemLayout} for further details.
    // <P>
    // <smartgwt>If width is specified as a String, getWidth() will return -1.  Use
    // +sgwtLink{getWidthAsString()} in this case.<p></smartgwt>
    // See the +link{group:formLayout} overview for details.
    //
    // @group formLayout
    // @see linearWidth
    // @see group:formLayout
    // @see formItem.height
    // @see dynamicForm.itemLayout
    // @example columnSpanning
    // @visibility external
    //<
    width:"*",

    //> @attr formItem.linearWidth (int | String : null: IRW)
    // Specifies a width for an item in +link{dynamicForm.linearMode,linearMode}, overriding
    // the default width of "*" in that mode.
    // @see width
    // @group formLayout
    // @visibility external
    //<

    //> @attr formItem.height (int | String : 20 : IRW)
    // Height of the FormItem.  Can be either a number indicating a fixed height in pixels, a
    // percentage indicating a percentage of the overall form's height, or "*" indicating take
    // whatever remaining space is available. See the +link{group:formLayout} overview for details.
    // <p>
    // <smartgwt>If height is specified as a String, getHeight() will return -1.  Use
    // +sgwtLink{getHeightAsString()} in this case.<p></smartgwt>
    // For form items having a +link{showPickerIcon,picker icon} (e.g. +link{SelectItem},
    // +link{ComboBoxItem}) and +link{SpinnerItem}s, if there is no explicit
    // +link{formItem.pickerIconHeight}, the pickerIcon will be sized to match the available
    // space based on the specified item height.<br>
    // Note that if spriting is being used, and the image to be displayed in these icons
    // is specified
    // using css properties such as <code>background-image</code>, <code>background-size</code>,
    // changing this value may result in an unexpected appearance as the image will not
    // scale.<br>
    // Scaleable spriting can be achieved using the +link{SCSpriteConfig} format.
    // See the section on spriting in the +link{group:skinning,skinning overview} for
    // further information.<br>
    // Alternatively, the +link{pickerIconStyle,pickerIconStyle} could be changed to a
    // custom CSS style name, and in the case of +link{SpinnerItem}s,
    // the +link{FormItemIcon.baseStyle,baseStyle} and
    // +link{FormItemIcon.src,src} of the +link{SpinnerItem.increaseIcon}
    // and +link{SpinnerItem.decreaseIcon} AutoChildren could be customized.
    // <p>
    // Note that when FormItem is rendered as read-only with <code>readOnlyDisplay</code> as "static"
    // the property +link{formItem.staticHeight} is used instead.
    //
    // @group formLayout
    // @see group:formLayout
    // @see formItem.width
    // @see dynamicForm.itemLayout
    // @example formLayoutFilling
    // @visibility external
    //<

    height:20,

    //> @attr formItem.staticHeight (Integer : null : IR)
    // Height of the FormItem when <code>canEdit</code> is false and
    // <code>readOnlyDisplay</code> is "static". The normal +link{height} is used
    // if this property is not set.
    //
    // @group formLayout
    // @see height
    // @visibility external
    //<

    //> @attr formItem.cellHeight (number : null : IRW)
    // If specified, this property will govern the height of the cell in which this form
    // item is rendered.
    // Will not apply when the containing DynamicForm sets <code>itemLayout:"absolute"</code>.
    // @group formItemStyling
    // @visibility external
    //<


    //> @attr formItem.titleColSpan  (number : 1 : IRW)
    // Number of columns that this item's title spans.
    // <P>
    // This setting only applies for items that are showing a title and whose
    // +link{titleOrientation} is either "left" or "right".
    //
    // @group formLayout
    // @visibility external
    //<
    titleColSpan:1,

    //> @attr formItem.colSpan (int | String : 1 : IRW)
    // Number of columns that this item spans.
    // <P>
    // The <code>colSpan</code> setting does not include the title shown for items with
    // +link{showTitle}:true, so the effective <code>colSpan</code> is one higher than this
    // setting for items that are showing a title and whose +link{titleOrientation} is either
    // "left" or "right".
    //
    // @see linearColSpan
    // @group formLayout
    // @visibility external
    //<
    colSpan:1,

    //> @attr formItem.linearColSpan (int | String : null: IRW)
    // Specifies a column span for an item in +link{dynamicForm.linearMode,linearMode},
    // overriding the default value of "*" in that mode.
    // @see colSpan
    // @group formLayout
    // @visibility external
    //<

    //> @attr formItem.rowSpan (number : 1 : IRW)
    // Number of rows that this item spans
    // @group formLayout
    // @visibility external
    //<
    rowSpan:1,

    //> @attr formItem.startRow (Boolean : false : IRW)
    // Whether this item should always start a new row in the form layout.
    // @see linearStartRow
    // @group formLayout
    // @visibility external
    //<

    //> @attr formItem.endRow (Boolean : false : IRW)
    // Whether this item should end the row it's in in the form layout
    // @see linearEndRow
    // @group formLayout
    // @visibility external
    //<

    //> @attr formItem.linearStartRow (int | String : null: IRW)
    // Specifies +link{startRow} for an item in +link{dynamicForm.linearMode,linearMode},
    // overriding the default of <code>false</code> in that mode.
    // @group formLayout
    // @visibility external
    //<

    //> @attr formItem.linearEndRow (int | String : null: IRW)
    // Specifies +link{endRow} for an item in +link{dynamicForm.linearMode,linearMode},
    // overriding the default of <code>true</code> in that mode.
    // @group formLayout
    // @visibility external
    //<

    // The align property is used by the dynamic form to align the item as a whole (control table
    // and all) in its cell.
    // In addition to this we support textAlign to align the contents within the text-box


    //> @attr formItem.align (Alignment : null : IRW)
    // Alignment of this item in its cell. Note that the alignment of text / content within this
    // item is controlled separately via +link{formItem.textAlign} (typically <code>textAlign</code>
    // applies to items showing a "textBox", such as a +link{TextItem} or +link{SelectItem},
    // as well as text-only form item types such as +link{StaticTextItem} and +link{HeaderItem}).
    // If +link{FormItem.applyAlignToText,applyAlignToText} is true, then the <code>textAlign</code>
    // setting, if unset, will default to the <code>align</code> setting if set.
    // @see FormItem.applyAlignToText
    // @group appearance
    // @visibility external
    //<

    //> @attr formItem.vAlign (VerticalAlignment : isc.Canvas.CENTER : IRW)
    // Vertical alignment of this item within its cell. This property governs the position
    // of the item's text box within the cell (not the content within the text box).
    // If +link{shouldApplyHeightToTextBox()} is true, for this to have a visible effect,
    // the cell height must exceed the specified height of the item, either due to
    // an explicit +link{cellHeight} specification, or due to the row being expanded
    // by another taller item.
    // <P>
    // Has no effect if +link{dynamicForm.itemLayout} is set to <code>"absolute"</code> for the
    // form.
    //
    // @getter formItem.getVAlign()
    // @group title
    // @visibility external
    //<
    //> @method formItem.getVAlign()
    // Returns the vertical-alignment for this item within its cell.  By default, when
    // +link{formItem.titleOrientation, titleOrientation} is "top", this method will
    // return "top", so that items of varying height are top-aligned, beneath their titles.
    // @return (VerticalAlignment) vertical alignment for this item
    // @visibility external
    //<
    getVAlign : function () {
        if (this.form && this.form.getTitleOrientation(this) == "top") return "top";
        return this.vAlign;
    },
    //> @attr formItem.textAlign (Alignment : null : IRW)
    // Alignment of the text / content within this form item. Note that +link{formItem.align} may
    // be used to control alignment of the entire form item within its cell. <code>textAlign</code>
    // does not apply to all form item types; typically it applies only to items showing a "textBox",
    // such as a +link{TextItem} or +link{SelectItem}, as well as text-only form item types
    // such as +link{StaticTextItem} and +link{HeaderItem}.
    // <p>
    // If +link{FormItem.applyAlignToText,applyAlignToText} is true, then <code>textAlign</code>
    // will default to the <code>align</code> setting if set. Otherwise, if this item has
    // +link{FormItem.icons,icons}, then <code>textAlign</code> will default to
    // <smartclient>"left"</smartclient>
    // <smartgwt>{@link com.smartgwt.client.types.Alignment#LEFT}</smartgwt>
    // <smartclient>("right"</smartclient>
    // <smartgwt>({@link com.smartgwt.client.types.Alignment#RIGHT}</smartgwt>
    // in +link{isc.Page.isRTL,RTL mode}).
    // @see FormItem.applyAlignToText
    // @group appearance
    // @visibility external
    //<

    //> @attr formItem.applyAlignToText (boolean : false : IRA)
    // If the +link{FormItem.textAlign,textAlign} is unset, should the +link{FormItem.align,align}
    // setting, if set, be used for this item's <code>textAlign</code>?
    // <p>
    // <code>applyAlignToText</code> defaults to false for most form item types. It defaults
    // to true for +link{StaticTextItem} and +link{HeaderItem}, which are text-based form item
    // types that do not have a natural distinction between the item and its cell.
    // @group appearance
    // @visibility external
    //<
    applyAlignToText: false,

    //> @attr formItem.left (int : 0 : IRWA)
    // Left coordinate of this item in pixels.  Applies only when the containing DynamicForm
    // sets <code>itemLayout:"absolute"</code>.
    // @visibility absForm
    //<
    left: 0,

    //> @attr formItem.top (int : 0 : IRWA)
    // Top coordinate of this item in pixels.  Applies only when the containing DynamicForm
    // sets <code>itemLayout:"absolute"</code>.
    // @visibility absForm
    //<
    top: 0,

    //> @attr formItem.wrap (boolean : null : IRW)
    // If true, item contents can wrap. If false, all the contents should appear on a single line.
    // @visibility internal
    //<

    //> @attr formItem.wrapStaticValue (boolean : null : IRW)
    // If this item is +link{FormItem.getCanEdit(),read-only} and is using
    // +link{FormItem.readOnlyDisplay,readOnlyDisplay}
    // <smartclient>"static",</smartclient>
    // <smartgwt>{@link com.smartgwt.client.types.ReadOnlyDisplayAppearance#STATIC},</smartgwt>
    // should the item value wrap?
    // @visibility external
    //<

    shouldWrap : function () {
        if (this.renderAsStatic() && this.wrapStaticValue != null) return this.wrapStaticValue
        return this.wrap;
    },


    //> @attr formItem.clipValue  (Boolean : null : IRW)
    // If true, text that exceeds the specified size of the form item will be clipped.
    // @visibility internal
    //<


    //> @attr formItem.autoCompleteKeywords (Array of String : null : IR)
    // Set of autocompletion keywords to be used with the native "autocomplete" attribute,
    // in accordance with the
    // +externalLink{https://html.spec.whatwg.org/multipage/form-control-infrastructure.html#autofill,HTML5 Autofill specification}.
    // <p>
    // When autoCompleteKeywords are provided, the +link{formItem.autoComplete} setting is ignored.
    // @group autoComplete
    // @visibility external
    //<

    // AutoComplete
    // --------------------------------------------------------------------------------------------
    //> @attr formItem.autoComplete   (AutoComplete : null : IRW)
    // Should this item allow browser auto-completion of its value?
    // Applies only to items based on native HTML form elements (+link{TextItem},
    // +link{PasswordItem}, etc), and will only have a user-visible impact for browsers
    // where native autoComplete behavior is actually supported and enabled via user settings.
    // <P>
    // Alternatively, +link{formItem.autoCompleteKeywords} can be specified, in which case
    // this setting is ignored.  If <code>autoCompleteKeywords</code> are not provided, and
    // <code>autoComplete</code> is not set on this FormItem, the value of
    // +link{dynamicForm.autoComplete} is used.
    // <P>
    // Note that even with this value set to <code>"none"</code>, native browser
    // auto-completion may occur for log in forms (forms containing username and
    // +link{PasswordItem,password} fields). This behavior varies by browser, and is
    // a result of an
    // +externalLink{https://www.google.com/search?q=password+ignores+autocomplete+off,intentional change by some browser developers}
    // to disregard the HTML setting <i>autocomplete=off</i> for password items or
    // log-in forms.
    // <P>
    // In some browsers any form redraw (including a redraw from  a call to
    // +link{DynamicForm.setValues()}) will re-populate the form with the natively
    // remembered login credentials. This can make it very difficult to control the
    // values displayed to the user, as a call to 'setValues()' may appear to be ignored.
    // While behavior varies by browser we have specifically
    // observed this behavior in Safari. Moreover in this browser, if the user
    // asks the browser to remember login credentials for a URL, any form with a password
    // item and a text item may be auto-filled with the remembered login credentials,
    // even if the form's configuration and field names differ from those on the
    // login form.
    // <P>
    // If an application has both an initial log in form, and a separate form within
    // the application which makes contains a Password item (a use case might be an
    // interface for a user with manager privileges for modifying other users' passwords),
    // this will cause the second form to autofill with unexpected values.
    // <P>
    // Should this arise, developers can avoid this by making the initial log in
    // interface into a separate log in page from the main application page.
    // This is often good practice in any case for reasons outlined in the
    // "Authentication" section of the Quick Start guide.
    //
    // @see dynamicForm.autoComplete
    // @group autoComplete
    // @visibility external
    //<
    // Some discussions of the decision to ignore native autocomplete on login forms:
    // Chrome: https://groups.google.com/a/chromium.org/forum/#!topic/chromium-dev/zhhj7hCip5c
    // and http://www.theregister.co.uk/2014/04/09/chrome_makes_new_password_grab_in_version_34/
    // IE11: http://blogs.msdn.com/b/ieinternals/archive/2009/09/10/troubleshooting-stored-login-problems-in-ie.aspx
    // (Search for "Internet Explorer 11 Update")
    // Mozilla - still respects this setting at least for now: http://blog.gerv.net/2013/10/ie-11-ignoring-autocompleteoff/

    //
    // "Smart" autoComplete - third mode where we provide autoComplete options from
    // specified valueMap, etc. not currently exposed


    //> @attr formItem.uniqueMatch    (boolean : null : IRW)
    // When +link{formItem.autoComplete} is set to <code>"smart"</code>,
    // whether to offer only unique matches to the user.
    // <p>
    // If unset, defaults to form.uniqueMatch.
    //
    // @see dynamicForm.uniqueMatch
    // @visibility autoComplete
    //<

    //> @attr formItem.autoCompleteCandidates (Array : null : IRW)
    // When +link{formItem.autoComplete} is set to <code>"smart"</code>,
    // optional set of candidate completions.
    // <p>
    // If candidates are not specified, the values in the valueMap, if any, will be used, or
    // within a DataBound form, the other values currently present in the loaded portion of the
    // dataset.
    // @visibility autoComplete
    //<


    //>@attr    formItem.browserSpellCheck  (boolean : null : IRWA)
    // If this browser supports spell-checking of text editing elements, do we want this
    // enabled for this item? If unset the property will be inherited from the containing form.
    // <P>
    // Notes:<br>
    // - this property only applies to text based items such as TextItem and TextAreaItem.<br>
    // - this property is not supported on all browsers.
    // @see dynamicForm.browserSpellCheck
    // @visibility external
    //<

    // In addition to spell-check Safari on iPhone / iPad supports the following features on
    // text items:
    // - auto capitalizing
    //>@attr formItem.browserAutoCapitalize (Boolean : null : IRA)
    // @visibility internal
    //<

    // - auto correct
    //>@attr formItem.browserAutoCorrect (Boolean : null : IRA)
    // In Mobile Safari, should automatic correction be offered for text in the item's text box?
    // If <code>null</code>, then Mobile Safari determines automatically whether to enable
    // autocorrect.
    // <p>
    // When enabled, Mobile Safari displays "autocorrect bubbles" to suggest automatic corrections:<br>
    // <img src="data:image/png;base64,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" width="150" height="45" alt="Screenshot of Mobile Safari suggesting &quot;On my way!&quot; to replace &quot;omw&quot;">
    //<

    // - which keyboard to display (text, phone, url, email, zip)
    //>@attr formItem.browserInputType (String : null : IRA)
    // Form item input type - governs which keyboard should be displayed for
    // mobile devices (supported on iPhone / iPad)
    // @visibility external
    //<
    browserInputTypeMap:{
        "digits": "number",

        // likely synonym
        "phone": "tel"
    },

    // Icons
    // --------------------------------------------------------------------------------------------

    //>@attr    formItem.icons      (Array of FormItemIcon Properties : null  : IRW)
    //  An array of descriptor objects for icons to display in a line after this form item.
    //  These icons are clickable images, often used to display some kind of helper for
    //  populating a form item.
    //  @group formIcons
    //  @see    class:FormItemIcon
    //  @visibility external
    //  @example formIcons
    //<
    icons: null,
    // An array containing all FormItemIcon objects in `this.icons' that are inline:true.
    _inlineIcons: null,
    // An array containing all "left"-aligned inline icons
    _leftInlineIcons: null,
    // The total width of the "left"-aligned inline icons (the sum of the icons' with and hspace).
    _leftInlineIconsWidth: 0,
    // An array containing all "right"-aligned inline icons
    _rightInlineIcons: null,
    // The total width of the "right"-aligned inline icons (the sum of the icons' with and hspace).
    _rightInlineIconsWidth: 0,

    //> @attr   formItem.defaultIconSrc      (SCImgURL : "[SKIN]/DynamicForm/default_formItem_icon.gif" : IRWA)
    // Default icon image source.
    // Specify as the partial URL to an image, relative to the imgDir of this component.
    // To specify image source for a specific icon use the <code>icon.src</code> property.<br>
    // If this item is drawn in the disabled state, the url will be modified by adding
    // "_Disabled" to get a disabled state image for the icon.
    // If <code>icon.showOver</code> is true, this url will be modified by adding "_Over" to get
    // an over state image for the icon.
    // <P>
    // +link{group:skinning,Spriting} can be used for this image, by setting this property to
    // a +link{type:SCSpriteConfig} formatted string.
    //
    //  @group  formIcons
    //  @visibility external
    //<
    defaultIconSrc:"[SKIN]/DynamicForm/default_formItem_icon.gif",

    //> @attr   formItem.showOverIcons  (boolean : null : IRWA)
    //  If we're showing icons, should we change their image source to the appropriate <i>over</i>
    //  source when the user rolls over (or puts focus onto) them?  Can be overridden on a per
    //  icon basis by the formItemIcon <code>showOver</code> property.
    //  @group formIcons
    //  @visibility external
    //<

    //> @attr   formItem.showFocusedIcons (boolean : null : IRWA)
    //  If we're showing icons, should we change their image source to the appropriate
    //  <i>focused</i>  source when this item has focus?  Can be overridden on a per
    //  icon basis by the formItemIcon <code>showFocused</code> property.
    //  @group formIcons
    //  @visibility external
    //<

    //> @attr formItem.iconHSpace (int : 3 : IR)
    // Horizontal space (in px) to leave between form item icons. The space appears either on
    // the left or right of each icon. May be overridden at the icon level via +link{FormItemIcon.hspace}.
    // Must be non-negative.
    // @group formIcons
    // @visibility external
    //<
    iconHSpace: 3,

    //> @attr   formItem.iconVAlign (VerticalAlignment: "bottom" : [IRWA])
    //      How should icons be aligned vertically for this form item.
    //  @group  formIcons
    //  @visibility external
    //<
    // Options are "top", "center", "bottom" - Implemented via the css 'vertical-alignment'
    // property
    iconVAlign:isc.Canvas.BOTTOM,

    //> @attr formItem.iconWidth (int : 20 : IRA)
    // Default width for form item icons. May be overridden at the icon level by +link{FormItemIcon.width}.
    // @group formIcons
    // @visibility external
    //<
    iconWidth: 20,

    //> @attr formItem.iconHeight (int : 20 : IRA)
    // Default height for form item icons. May be overridden at the icon level by +link{FormItemIcon.height}.
    // @group formIcons
    // @visibility external
    //<
    iconHeight: 20,

    //> @attr formItem.prompt (HTMLString : null : IRW)
    // This text is shown as a tooltip prompt when the cursor hovers over this item.
    // <P>
    // When item is +link{FormItem.setCanEdit,read-only} a different hover can be shown with
    // +link{FormItem.readOnlyHover}. Or, when item is +link{FormItem.disabled,disabled} or
    // read-only with +link{readOnlyDisplay,readOnlyDisplay:disabled} a different hover can be shown
    // with +link{FormItem.disabledHover}.
    // <P>
    // Note that when the form is +link{DynamicForm.disabled, disabled} this prompt will not
    // be shown.
    //
    // @group basics
    // @visibility external
    //<

    // FormItem.implementsPromptNatively:
    // By default we show prompts in an ISC hover. However for some form items we'll write
    // out HTML that will cause a native hover prompt to show up instead. In these cases
    // we suppress the ISC hover

    //implementsPromptNatively:false,

    //> @attr formItem.readOnlyHover (HTMLString : null : IRW)
    // This text is shown as a tooltip prompt when the cursor hovers over this item
    // and the item is +link{FormItem.setCanEdit,read-only}.
    // <P>
    // Note that when the form is +link{DynamicForm.disabled, disabled} this prompt will not
    // be shown.
    //
    // @visibility external
    //<

    //> @attr formItem.disabledHover (HTMLString : null : IRW)
    // This text is shown as a tooltip prompt when the cursor hovers over this item
    // and the item is +link{FormItem.disabled,disabled} or
    // +link{FormItem.setCanEdit,read-only} with +link{readOnlyDisplay,readOnlyDisplay:disabled}.
    // <P>
    // You can also override +link{formItem.itemHoverHTML, itemHoverHTML} on the item to show
    // a custom hover, whether or not the item is disabled.
    // <P>
    // Note that when the form itself is +link{DynamicForm.disabled, disabled}, no prompt will
    // be shown.
    // @visibility external
    //<

    //> @attr formItem.iconPrompt (HTMLString : "" : IRWA)
    // Default prompt (and tooltip-text) for icons.
    // @group formIcons
    // @visibility external
    //<

    iconPrompt:"",

    //> @attr   formItem.showIcons (Boolean : true : IRWA)
    // Set to false to suppress writing out any +link{formItem.icons} for this item.
    //  @group  formIcons
    //  @visibility external
    //<

    showIcons:true,

    //> @attr formItem.showIconsOnFocus (Boolean : null : IRWA)
    // Show the +link{formItem.icons} when the item gets focus, and hide them when it loses focus.
    // Can be overridden at the icon level by +link{formItemicon.showOnFocus}.
    // <P>
    // Note that icons marked as disabled will not be shown on focus even if this flag is
    // true by default. This may be overridden by +link{formItem.showDisabledIconsOnFocus}.
    // @group formIcons
    // @visibility external
    //<

    //> @attr formItem.showDisabledIconsOnFocus (Boolean : false : IRWA)
    // If +link{formItem.showIconsOnFocus} is true, should icons marked as disabled be
    // shown on focus?
    // <P>
    // Default setting is <code>false</code> - it is not commonly desirable to
    // present a user with a disabled icon on focus.
    // <P>
    // Can be overridden at the icon level by +link{formItemIcon.showDisabledOnFocus}
    // @group formIcons
    // @visibility external
    //<

    //> @attr formItem.showPickerIconOnFocus (Boolean : null : IRWA)
    // Show the picker icon when the item gets focus, and hide it when it loses focus.  Can be
    // overridden at the icon level by +link{formItemicon.showOnFocus}.
    // <P>
    // Note that a pickerIcon marked as disabled will not be shown on focus even if this flag is
    // true by default. This may be overridden by +link{formItem.showDisabledIconsOnFocus}.
    // @group formIcons
    // @visibility external
    //<


    //> @attr formItem.showDisabledPickerIconOnFocus (Boolean : false : IRWA)
    // If +link{formItem.showPickerIconOnFocus} is true, should the picker icon be
    // shown on focus if it is disabled (as in a read-only item, for example?)
    // <P>
    // Default setting is <code>false</code> - it is not commonly desirable to
    // present a user with a disabled icon on focus.
    // <P>
    // Can be overridden at the icon level by +link{formItemIcon.showDisabledOnFocus}
    // @group formIcons
    // @visibility external
    //<

    //> @attr formItem.hideIconsOnKeypress (Boolean : null : IRWA)
    // Hide the +link{formItem.icons} as the user types into a form item, to provide more
    // space.  Completing interaction such as by tabbing away will show the icons again.
    // @group formIcons
    //<

    //> @attr   formItem.redrawOnShowIcon (boolean : true : IRWA)
    //      When dynamically showing/hiding icons for this form  item, should we force a
    //      redraw of the entire form?
    //  @group  formIcons
    //<

    redrawOnShowIcon:false,

    //> @attr   formItem.canTabToIcons  (Boolean : null : IRWA)
    // Should this item's +link{formItem.icons,icons} and
    // +link{formItem.showPickerIcon,picker icon} be included in
    // the page's tab order by default? If not explicitly set, this property
    // will be derived from +link{dynamicForm.canTabToIcons}.
    // <P>
    // Developers may also suppress tabbing to individual icons by
    // setting +link{formItemIcon.tabIndex} to <code>-1</code>.
    // <P>
    // Note that if this form item has tabIndex -1, neither the form item nor the icons
    // will be included in the page's tab order.
    //
    // @group  formIcons
    // @visibility external
    //<
    //canTabToIcons:null,

    // Validation Error Icon
    // We write out a special icon to indicate validation errors. This will not be part of the
    // icons array but will be rendered using some of the same code.

    //> @attr   formItem.errorIconHeight    (number : 16 : IRW)
    // Height of the error icon, if we're showing icons when validation errors occur.
    // @group  errorIcon
    // @see FormItem.showErrorIcon
    // @visibility external
    //<
    errorIconHeight: 16,

    //> @attr   formItem.errorIconWidth    (number : 16 : IRW)
    // Height of the error icon, if we're showing icons when validation errors occur.
    // @group  errorIcon
    // @see FormItem.showErrorIcon
    // @visibility external
    //<
    errorIconWidth: 16,

    //> @attr   formItem.errorIconSrc    (SCImgURL : "[SKIN]/DynamicForm/validation_error_icon.png" : IRW)
    // URL of the image to show as an error icon, if we're showing icons when validation
    // errors occur.
    // @group  errorIcon
    // @see FormItem.showErrorIcon
    // @visibility external
    //<
    errorIconSrc: "[SKIN]/DynamicForm/validation_error_icon.png",

    //> @attr   formItem.showErrorIcon (boolean : null : IRW)
    // @include dynamicForm.showErrorIcons
    //  @group  errorIcon, validation, appearance
    //  @visibility external
    //<
    // Note Actually writing this item (and the error text) into the DOM is handled by the
    // Form (or containerWidget) - but this property governs whether we include the icon in the
    // errorHTML we return.
    //showErrorIcon: null,

    //> @attr   formItem.showErrorText (boolean : null : IRW)
    // @include dynamicForm.showErrorIcons
    // @group  validation, appearance
    // @visibility external
    //<
    //showErrorText: null,

    //> @attr formItem.showErrorStyle     (boolean : null : IRW)
    // @include dynamicForm.showErrorIcons
    // @group validation, appearance
    // @visibility external
    // @see FormItem.cellStyle
    //<
    //showErrorStyle: null,

    //> @attr formItem.errorOrientation (Align : null : IRW)
    // If +link{dynamicForm.showInlineErrors} is true, where should the error icon and text appear
    // relative to the form item itself. Valid options are <code>"top"</code>,
    // <code>"bottom"</code>, <code>"left"</code> or <code>"right"</code>.<br>
    // If unset the orientation will be derived from +link{dynamicForm.errorOrientation}.
    // @group validation, appearance
    // @visibility external
    //<
    //errorOrientation: null,

    // Define a jsdoc pseudo-class for form item icon descriptor objects.
    // ------

        //> @object FormItemIcon
        //
        //  Form item icon descriptor objects used by Form Items to specify the appearance and
        //  behavior of icons displayed after the item in the page flow.
        //
        //  @treeLocation   Client Reference/Forms/Form Items/FormItem
        //  @see attr:FormItem.icons
        //  @group formIcons
        //  @visibility external
        //  @example formIcons
        //<

        //> @attr formItemIcon.baseStyle (CSSStyleName : null : IRWA)
        // Base CSS style. If set, as the component changes state and/or is focused, suffixes
        // will be added to the base style. Possible suffixes include "Over" if the user mouses
        // over the icon and +link{FormItemIcon.showOver,this.showOver} is true, "Disabled" if
        // the icon is disabled, and "Focused". In addition, if +link{FormItemIcon.showRTL,showRTL}
        // is enabled, then an "RTL" suffix will be added.
        // @visibility external
        //<

        //> @attr formItemIcon.backgroundColor (CSSColor : null : IR)
        // Optional background color for the icon. Settable via +link{FormItem.setIconBackgroundColor()}.
        // @visibility internal
        //<

        //> @attr formItemIcon.name (Identifier : null : IR)
        // Identifier for this form item icon. This identifier (if set) should be unique
        // within this form item and may be used to get a pointer to the icon object
        // via +link{FormItem.getIcon()}.
        // @visibility external
        //<
        // Note: Also used by the AutoTest subsystem - if the name is autoGenerated, we can't
        // guarantee it won't change as the application changes (specifically the order of
        // icons for this form item changes).
        // For auto-generated icons, such as the picker we should always provide a reliable
        // standard name

        //> @attr formItemIcon.inline (Boolean : false : IR)
        // When set, this icon is rendered inside the +link{formItem.textBoxStyle,textBox} area
        // of the <code>FormItem</code> (where input occurs in a +link{TextItem}, +link{TextAreaItem} or
        // +link{ComboBoxItem}) as opposed to as a trailing icon.
        // <p>
        // Use +link{FormItemIcon.inlineIconAlign,inlineIconAlign} to control alignment of the
        // icon.  Multiple icons can be inlined on both the left and right side of the
        // <code>textBox</code> area.  +link{FormItemIcon.hspace,hspace} is honored for spacing
        // between multiple adjacent icons.
        // <p>
        // Inline icons are not supported in Internet Explorer 6, or when the <code>FormItem</code>
        // is not a <code>TextItem</code>, <code>TextAreaItem</code> or <code>ComboBoxItem</code>.
        // When unsupported, the icon will fall back to non-inline mode.
        // <p>
        // The +link{formItem.showPickerIcon,picker icon}, if any, cannot be inlined.
        // <p>
        // As an alternative to displaying an image, an inline icon may display a string of
        // HTML instead. See +link{FormItemIcon.text}.
        // @example inlineFormIcons
        // @visibility external
        //<


        //> @attr formItemIcon.inlineIconAlign (Alignment : null : IR)
        // Horizontal alignment for icons marked +link{FormItemIcon.inline,inline}.
        // <p>
        // By default, the first icon that specifies inline is aligned left, and the second and all
        // subsequent icons to the right.  <code>"center"</code> alignment is invalid and will be
        // ignored.
        // <p>
        // In RTL mode, the alignment is automatically mirrored; <code>inlineIconAlign:"left"</code>
        // results in the icon being placed on the right and <code>inlineIconAlign:"right"</code>
        // results in the icon being placed on the left.
        // @visibility external
        //<

        //> @attr formItemIcon.src (SCImgURL | SCStatefulImgConfig : null : IRW)
        // If set, this property determines this icon's image source.
        // If unset the form item's <code>defaultIconSrc</code> property will be used
        // instead.<br>
        // As with <code>defaultIconSrc</code> this URL will be modified by adding
        // "_Over" or "_Disabled" if appropriate to show the icon's over or disabled state.
        // If +link{FormItemIcon.showRTL,showRTL} is enabled, then "_rtl" will be added to the
        // source URL before the extension.
        // <p>
        // The special value "blank" means that no image will be shown for this icon. This
        // is particularly useful together with +link{FormItemIcon.baseStyle} to implement
        // spriting of the different icon states.
        // <p>
        // For an +link{FormItemIcon.inline,inline} <code>FormItemIcon</code>,
        // +link{FormItemIcon.text,text} may be specified to show a string of HTML instead of
        // an image.
        // <P>
        // +link{group:skinning,Spriting} can be used for this image, by setting this property to
        // a +link{type:SCSpriteConfig} formatted string.
        //
        // @group formIcons
        // @see attr:formItem.defaultIconSrc
        // @example formIcons
        // @visibility external
        //<

        //> @attr formItemIcon.text (HTMLString : null : IRWA)
        // As an alternative to displaying an image, an +link{FormItemIcon.inline,inline}
        // <code>FormItemIcon</code> can display a string of HTML where the icon's image would
        // have appeared. This enables advanced customizations such as using text, icon font symbols,
        // Unicode dingbats and emoji, and/or SVG in place of an image.
        // <p>
        // Setting an inline icon's text property will cause the HTML to be used instead of an
        // image, as long as the browser and form item support inline icons.
        // <p>
        // This property only has an effect on inline icons.  If the inline property is false,
        // or the browser or form item does not support inline icons, then the image specified
        // by +link{FormItemIcon.src} (or the form item's +link{FormItem.defaultIconSrc,defaultIconSrc})
        // will be used.
        // <p>
        // Typically, the HTML is styled via +link{FormItemIcon.baseStyle}.
        // <p>
        // Auto-sizing of the HTML is not supported; the HTML will be clipped to the icon's
        // +link{FormItemIcon.width,width} and +link{FormItemIcon.height,height}.
        // @example textIcons
        // @group formIcons
        // @visibility external
        //<

        //> @attr formItemIcon.cursor (Cursor : Canvas.POINTER : IRWA)
        // Specifies the cursor image to display when the mouse pointer is
        // over this icon. It corresponds to the CSS cursor attribute. See Cursor type for
        // different cursors.
        // <p>
        // See also +link{formItemIcon.disabledCursor}.
        // @visibility external
        // @group cues
        //<

        //> @attr formItemIcon.disabledCursor (Cursor : Canvas.DEFAULT : IRWA)
        // Specifies the cursor image to display when the mouse pointer is
        // over this icon if this icon is disabled. It corresponds to the CSS cursor
        // attribute. See Cursor type for different cursors.
        // @visibility external
        // @group cues
        //<

        //> @attr formItemIcon.showOver (boolean : null : IRWA)
        // Should this icon's image and/or +link{FormItemIcon.baseStyle,baseStyle} switch to the
        // appropriate "Over" value when the user rolls over or focuses on the icon?
        // <P>
        // Note if +link{formItem.showOver} is true and +link{formItemIcon.showOverWhen}
        // is set to "textBox", this icon will show over state when the user rolls over the
        // text box (or control table, if visible) for the item. This is most commonly used
        // for +link{formItemIcon.inline,inline} icons.
        //
        // @group  formIcons
        // @visibility external
        // @see attr:formItem.showOverIcons
        //<

        //> @type IconOverTrigger
        // Property to govern when the 'over' styling is applied to
        // a formItemIcon.
        // @value "icon" Show rollover styling and media when the user is over the icon only
        // @value "textBox" Show rollover styling and media when the user is over the icon
        //  or over the textBox (or control-table, if present) for this icon. Only has
        //  an effect when +link{FormItem.showOver} is true.
        // @value "item" Show rollover styling and media when the user is over any part of the
        //  FormItem, including the entire cell within a DynamicForm table containing the item.
        //
        // @visibility external
        //<

        //> @attr formItemIcon.showOverWhen (IconOverTrigger : null : IRWA)
        // If +link{formItemIcon.showOver} or +link{formItem.showOverIcons} is true,
        // this property may be set to customize when the 'over' styling is applied to
        // the item. If unset, rollover styling will be applied when the user is over
        // the icon only.
        //
        // @group formIcons
        // @visibility external
        //<

        //> @attr formItemIcon.showFocused (Boolean : null : IRWA)
        // Should this icon's image and/or +link{FormItemIcon.baseStyle,baseStyle} switch to the
        // appropriate "Focused" value when the user puts focus on the form item or icon?
        // @see formItem.showFocusedIcons
        // @see formItemIcon.showFocusedWithItem
        // @group  formIcons
        // @visibility external
        //<

        //> @attr formItemIcon.showRTL (Boolean : null : IRA)
        // Should this icon's +link{FormItemIcon.src,src} and/or +link{FormItemIcon.baseStyle,baseStyle}
        // switch to the appropriate RTL value when the FormItem is in RTL mode? If true, then
        // the image URL for all states will have "_rtl" added before the extension. Also, if
        // baseStyle is set, all style names will have an "RTL" suffix. This should only be
        // enabled if RTL media is available.
        // <p>
        // For example, if an icon's src is "[SKINIMG]formItemIcons/myFormIcon.png" and the baseStyle
        // is "myFormIcon", then in the "Down" state, SmartClient will use "[SKINIMG]formItemIcons/myFormIcon_Down_rtl.png"
        // for the image source and "myFormIconDownRTL" for the style name.
        // @group RTL
        // @group formIcons
        // @visibility external
        //<

        //> @attr formItemIcon.showFocusedWithItem (boolean : null : IRWA)
        // If this icon will be updated to show focus (see +link{formItemIcon.showFocused},
        // +link{formItem.showFocusedIcons}), this property governs whether the focused state should
        // be shown when the item as a whole receives focus or just if the icon receives focus.
        // If this property is unset, default behavior is to show focused state when the item
        // receives focus.
        // @see formItem.showFocusedIcons
        // @see formItemIcon.showFocused
        // @group  formIcons
        // @visibility external
        //<

        //> @attr formItemIcon.canFocus (Boolean : null : IRWA)
        // Set to false to suppress all focus features for this icon. Clicking the
        // icon will not apply focus to the icon or to the form item.
        // @group  formIcons
        // @visibility external
        //<

        //> @attr formItemIcon.neverDisable (boolean : null : IRWA)
        // If <code>icon.neverDisable</code> is true, when this form item is disabled, the
        // icon will remain enabled.
        // Note that disabling the entire form will disable all items, together with their
        // icons including those marked as neverDisable - this property only has an effect
        // if the form is enabled and a specific item is disabled within it.
        // <P>
        // If this property is true, the icons will also remain enabled if a form item
        // is marked as +link{formItem.canEdit,canEdit:false}. For finer grained control over
        // whether icons are enabled for read-only icons see +link{formItem.disableIconsOnReadOnly}
        // and +link{formItemIcon.disableOnReadOnly}
        //
        // @group  formIcons
        // @visibility external
        //<

        //> @attr formItemIcon.disableOnReadOnly (boolean : null : IRWA)
        // If +link{formItem.canEdit} is set to false, should this icon be disabled.
        // If unset this is determined by +link{formItem.disableIconsOnReadOnly}.
        // Note that if +link{formItemIcon.neverDisable} is set to true, the icons will
        // be rendered enabled regardless of this setting and whether the item is editable.
        // @group formIcons
        // @visibility external
        //<

        //> @attr formItemIcon.disabled (Boolean : null : IRW)
        // Whether this icon is disabled.  Can be updated at runtime via the +link{formItem.setIconDisabled}
        // method.  Note that if the formItem containing this icon is disabled, the icon will
        // behave in a disabled manner regardless of the setting of the icon.disabled property.
        // @group appearance
        // @see FormItem.setIconDisabled()
        // @visibility external
        //<

        //> @attr formItemIcon.enableWhen (AdvancedCriteria : null : IR)
        // Criteria to be evaluated to determine whether this icon should appear enabled.
        // <p>
        // Criteria are evaluated against the +link{dynamicForm.getValues,form's current values} as well as
        // the current +link{canvas.ruleScope,rule context}.  Criteria are re-evaluated every time
        // form values or the rule context changes, whether by end user action or by programmatic calls.
        // <P>
        // A basic criteria uses textMatchStyle:"exact". When specified in
        // +link{group:componentXML,Component XML} this property allows
        // +link{group:xmlCriteriaShorthand,shorthand formats} for defining criteria.
        // <p>
        // Note: A FormItemIcon using enableWhen must have a +link{formItem.name,name} defined on
        // its FormItem.
        // @group ruleCriteria
        // @visibility external
        //<

        //> @attr formItemIcon.tabIndex (int : null : IRA)
        // TabIndex for this formItemIcon.
        // <P>
        // Set to -1 to remove the icon from the tab order, but be cautious doing so: if the
        // icon triggers important application functionality that cannot otherwise be accessed
        // via the keyboard, it would be a violation of accessibility standard to remove the
        // icon from the tab order.
        // <P>
        // Any usage other than setting to -1 is extremely advanced in the same way as using
        // +link{formItem.globalTabIndex}.
        //
        // @group formIcons
        // @visibility external
        //<

        //> @method formItemIcon.click()
        // Click handler for this icon.
        // <P>
        // <smartclient>
        // Return false to cancel this event.
        // </smartclient>
        // <smartgwt>
        // This event may be cancelled.
        // </smartgwt>
        // If this event is not cancelled by the icon-level click handler, it may also
        // be handled at the FormItem level via +link{formItem.pickerIconClick()} [for the
        // picker icon only], and then +link{formItem.iconClick()}
        //
        //  @param  form (DynamicForm)  The Dynamic Form to which this icon's item belongs.
        //  @param  item (FormItem)     The Form Item containing this icon
        //  @param  icon (FormItemIcon) A pointer to the form item icon clicked
        // @return (boolean) Return false to cancel the event.
        //  @group  formIcons
        //  @visibility external
        //  @example formIcons
        //<

        //> @method formItemIcon.keyPress()
        //      StringMethod action to fire when this icon has focus and receives a keypress
        //      event.
        //      If unset the form item's <code>iconKeyPress</code> method will be fired instead
        //      (if specified).
        //  @param  keyName (KeyName)    Name of the key pressed
        //  @param  character (Character) character produced by the keypress
        //  @param  form (DynamicForm)  The Dynamic Form to which this icon's item belongs.
        //  @param  item (FormItem)     The Form Item containing this icon
        //  @param  icon (FormItemIcon) A pointer to the form item icon
        //  @group  formIcons
        //  @visibility external
        //<

        //> @attr   formItemIcon.width (number : null : IRW)
        //      If set, this property determines the width of this icon in px.
        //      If unset the form item's <code>iconWidth</code> property will be used instead.
        //  @group  formIcons
        //  @visibility external
        //  @see    attr:formItem.iconWidth
        //<

        //> @attr   formItemIcon.height (number : null : IRW)
        //      If set, this property determines the height of this icon in px.
        //      If unset the form item's <code>iconHeight</code> property will be used instead.
        //  @group  formIcons
        //  @visibility external
        //  @see    attr:formItem.iconHeight
        //<

        //> @attr formItemIcon.prompt (HTMLString : null : IRWA)
        // If set, this property will be displayed as a prompt (and tooltip text) for this form
        // item icon.
        // <P>
        // If unset the form item's <code>iconPrompt</code> property will be used instead.
        //
        //  @group  formIcons
        //  @visibility external
        //  @see    attr:formItem.iconPrompt
        //<

        //> @attr formItemIcon.showOnFocus (Boolean : null : IRWA)
        // Show this icon when its item gets focus, and hide it when it loses focus.  If
        // non-null, overrides the default behavior specified by
        // +link{formItem.showIconsOnFocus} or +link{formItem.showPickerIconOnFocus}, as
        // appropriate.  This feature allows space to be saved in the form for items not being
        // interacted with, and helps draw attention to the item currently in focus.
        //
        // @group formIcons
        // @visibility external
        // @see method:formItem.setIconShowOnFocus
        //<


        //> @attr formItemIcon.showDisabledOnFocus (Boolean : null : IRWA)
        // If show-on-focus behavior is enabled for this icon via +link{formItemIcon.showOnFocus}
        // or related properties at the item level, and this icon is marked as disabled,
        // should it be shown on focus? If unset, will be derived from the
        // +link{formItem.showDisabledIconsOnFocus} or
        // +link{formItem.showDisabledPickerIconOnFocus} settings.
        //
        // @group formIcons
        // @visibility external
        //<

        //> @attr formItemIcon.hspace (Integer : null : IR)
        // If set, this property determines the number of pixels space to be displayed on
        // the left of this form item icon, or for +link{FormItemIcon.inline,inline} icons
        // whose +link{FormItemIcon.inlineIconAlign,inlineIconAlign} is
        // <smartclient><code>"left"</code>,</smartclient>
        // <smartgwt>{@link com.smartgwt.client.types.Alignment#LEFT},</smartgwt>
        // on the right of this form item icon. Must be non-negative.
        // If unset, the form item's +link{FormItem.iconHSpace,iconHSpace} will be used instead.
        // @group formIcons
        // @visibility external
        //<

        //> @method formItemIcon.showIf ()
        // If specified, <code>icon.showIf</code> will be evaluated when the form item is
        // drawn or redrawn. Return true if the icon should be visible, or false if it
        // should be hidden. Note that if +link{formItem.showIcon()} or +link{formItem.hideIcon()}
        // is called, this method will be overridden.
        // @param form (DynamicForm) the DynamicForm in which the icon is embedded
        // @param item (FormItem) the item to which this icon is attached.
        // @return (boolean) Return true if the icon should be visible, false otherwise.
        // @visibility external
        //<

        //> @attr formItemIcon.visibleWhen (AdvancedCriteria : null : IR)
        // Criteria to be evaluated to determine whether this icon should be visible.
        // <p>
        // Criteria are evaluated against the +link{dynamicForm.getValues(),form's current values} as well as
        // the current +link{canvas.ruleScope,rule context}.  Criteria are re-evaluated every time
        // form values or the rule context changes, whether by end user action or by programmatic calls.
        // <P>
        // A basic criteria uses textMatchStyle:"exact". When specified in
        // +link{group:componentXML,Component XML} this property allows
        // +link{group:xmlCriteriaShorthand,shorthand formats} for defining criteria.
        // <p>
        // Note: A FormItemIcon using visibleWhen must have a +link{formItem.name,name} defined on
        // its FormItem.
        // @group ruleCriteria
        // @visibility external
        //<



    // Hints
    // --------------------------------------------------------------------------------------------

    //> @attr formItem.hint (HTMLString : null : IRW)
    // Specifies "hint" string to show next to the form item to indicate something to the user.
    // This string generally appears to the right of the form item.
    //
    // @see hintStyle
    // @group appearance
    // @visibility external
    // @example formHints
    //<

    //> @attr formItem.showHint (Boolean : true : IRWA)
    // If a hint is defined for this form item, should it be shown?
    //
    // @group appearance
    // @visibility external
    //<
    showHint:true,

    //> @attr formItem.wrapHintText (Boolean : null : IR)
    // If this item is showing a +link{FormItem.hint}, should the hint text be allowed to
    // wrap? Setting this property to <code>false</code> will render the hint on a single line
    // without wrapping, expanding the width required to render the item if necessary.
    // <P>
    // If unset this property will be picked up from the +link{DynamicForm.wrapHintText}
    // setting.
    // <P>
    // This setting does not apply to hints that are +link{TextItem.showHintInField,shown in field}.
    // @see FormItem.minHintWidth
    // @visibility external
    //<
    //wrapHintText: null,

    //> @attr formItem.minHintWidth (Integer : null : IR)
    // If this item is showing a +link{FormItem.hint}, this setting specifies how much
    // horizontal space is made available for rendering the hint text by default.
    // Typically this reflects how much space the hint text takes up before it wraps.
    // <P>
    // Note that the presence of a hint may cause a form item to expand horizontally past its
    // specified +link{FormItem.width}.
    // This property value acts as a minimum - if the hint text can not wrap within this width
    // (either due to +link{FormItem.wrapHintText} being set to <code>false</code>, or
    // due to it containing long, un-wrappable content), it will further expand to take
    // up the space it needs.
    // <P>
    // If unset this property will be picked up from the +link{DynamicForm.minHintWidth}
    // setting.
    // <P>
    // This setting does not apply to hints that are +link{TextItem.showHintInField,shown in field}.
    // @see FormItem.wrapHintText
    // @visibility external
    //<
    //minHintWidth: null,


    // Styles
    // --------------------------------------------------------------------------------------------

    //> @attr formItem.showFocused     (Boolean : false : IRWA)
    // When this item receives focus, should it be re-styled to indicate it has focus?
    // <P>
    // See +link{group:formItemStyling} for more details on formItem styling.
    //
    // @group formItemStyling
    // @visibility external
    // @see cellStyle
    //<
    showFocused:false,

    //> @attr formItem.showOver (boolean : false : IRWA)
    // When the user rolls over this item, should it be re-styled to indicate it has focus?
    // <P>
    // When enabled, the "Over" styling is applied to the text box,
    // control table (if present), and pickerIcon (if present), and any icons
    // where +link{formItemIcon.showOver} is true and +link{formItemIcon.showOverWhen} is
    // set to "textBox".<br>
    // These behaviors can be disabled piecemeal via +link{updateTextBoxOnOver},
    // +link{updateControlOnOver} and +link{updatePickerIconOnOver} properties.
    // <P>
    // Developers may also show rollover styling for other icons (see
    // +link{formItem.showOverIcons} and +link{formItemIcon.showOverWhen}).
    // <P>
    // See +link{group:formItemStyling} for more details on formItem styling.
    //
    // @group formItemStyling
    // @visibility external
    //
    //<

    // We also support rollover styling for valueIcons - used for the CheckboxItem class.
    // That's not explicitly linked to showOver at present - we might want to add this.
    //
    // We don't currently offer to style the cell on over - we could fairly easily add this
    // but it seems an unlikely use-case

    //> @attr formItem.updateTextBoxOnOver (Boolean : null : IRWA)
    // If +link{formItem.showOver} is true, setting this property to false will explicitly
    // disable showing the "Over" state for the TextBox element of this item.
    //
    // @see showOver
    // @group formItemStyling
    // @visibility external
    //<

    getUpdateTextBoxOnOver : function () {
        return this.updateTextBoxOnOver;
    },

    //> @attr formItem.updateControlOnOver (Boolean : null : IRWA)
    // If +link{formItem.showOver} is true, setting this property to false will explicitly
    // disable showing the "Over" state for the control table element of
    // this item (if present).
    //
    // @see showOver
    // @group formItemStyling
    // @visibility external
    //<

    getUpdateControlOnOver : function () {
        return this.updateControlOnOver;
    },

    //> @attr formItem.updatePickerIconOnOver (Boolean : null : IRWA)
    // If +link{formItem.showOver} is true, setting this property to false will explicitly
    // disable showing the "Over" state for the PickerIcon of this item (if present)
    //
    // @see showOver
    // @group formItemStyling
    // @visibility external
    //<


    //> @attr formItem.showDisabled (Boolean : true : IRWA)
    // When this item is disabled, should it be re-styled to indicate its disabled state?
    // <P>
    // See +link{group:formItemStyling} for more details on formItem styling.
    //
    // @group formItemStyling
    // @visibility external
    // @see cellStyle
    //<
    showDisabled:true,

    //> @attr formItem.showRTL (boolean : false : IRA)
    // When this item is in RTL mode, should its style name include an "RTL" suffix?
    // @group RTL
    // @group appearance
    // @visibility external
    // @see cellStyle
    //<
    showRTL:false,

    //> @attr formItem.showPending (Boolean : null : IRA)
    // When <code>true</code>, causes the "Pending" optional suffix to be added if the item's
    // current value differs from the value that would be restored by a call to +link{DynamicForm.resetValues()}.
    // <p>
    // +link{attr:shouldSaveValue,shouldSaveValue} must be <code>true</code> for this setting
    // to have an effect.
    // <p>
    // Styling of the value is updated only after the +link{method:change()} event is processed,
    // so depending on the value of +link{attr:changeOnKeypress,changeOnKeypress}, styling may
    // be updated immediately on keystroke or only when the user leaves the field.
    // <p>
    // Default styling is provided for the Enterprise, EnterpriseBlue, and Graphite skins only.
    // <code>showPending</code> should not be enabled for an item when using a skin without
    // default styling unless the default +link{FormItem.pendingStatusChanged()} behavior is
    // canceled and a custom pending visual state is implemented by the item.
    // <p>
    // <strong>NOTE:</strong> Whether an item is shown as pending is not reflected to screen
    // readers. Therefore, it is not advisable to design a UI where it is necessary for the user
    // to know whether an item is shown as pending in order to work with the form.
    // @see FormItem.pendingStatusChanged()
    // @example pendingValues
    // @visibility external
    //<
    showPending:null,

    //> @attr formItem.pendingStatus (Boolean : null : RA)
    // Whether this form item is displaying its pending visual state.
    // @see attr:showPending
    //<
    //pendingStatus: null,

    //> @attr formItem.fixedPendingStatus (Boolean : null : IRWA)
    // When set and +link{attr:showPending,showPending} is <code>true</code>, overrides the
    // value-based detection of the pending status. If <code>true</code>, then this item will
    // be shown in the pending visual state; if <code>false</code>, then this item will not be
    // shown in the pending visual state.
    //<
    //fixedPendingStatus:null,

    //> @attr formItem.showDeletions (Boolean : null : IRA)
    // For items that support +link{SelectItem.multiple,multiple values}, this causes distinct CSS styling
    // to be applied to values that the user has unselected.
    // <p>
    // Only allowed when +link{attr:showPending,showPending} is <code>true</code>. Defaults
    // to the form-level +link{DynamicForm.showDeletions} setting if set; otherwise, to the
    // value of <code>showPending</code>.
    // <p>
    // Only supported for +link{MultiComboBoxItem} and for +link{SelectItem} when
    // +link{SelectItem.multiple,multiple:true} is set. The specific default behaviors are:
    // <ul>
    // <li>For <code>MultiComboBoxItem</code>, buttons corresponding to deleted values
    //     (also called "deselected buttons") will be disabled and have their +link{Button.baseStyle}
    //     set to +link{MultiComboBoxItem.deselectedButtonStyle}.
    // <li>For a multiple <code>SelectItem</code>, +link{FormItem.valueDeselectedCSSText} is
    //     applied to any deleted value in the text box. In addition, "Deselected" is appended
    //     to the cells' +link{ListGrid.baseStyle} for cells in the pickList menu corresponding
    //     to deleted values.
    // </ul>
    // <p>
    // <strong>NOTE:</strong> When a value is shown as deleted, this is not reflected to screen
    // readers, and screen readers are instructed to ignore the deleted value. Therefore, it is
    // not advisable to design a UI where it is necessary for the user to know whether a value
    // is shown as deleted in order to work with the form.
    // @see DynamicForm.showDeletions
    // @visibility external
    //<
    //showDeletions: null,

    // Overview of form item styling. Given the way different items produce different
    // DOM structures etc, it's good to have an overview of what the actual stylable
    // parts are, and what properties apply to them
    // - Does not expose the "outerTable", or other structure which is not publicly
    //   styleable / is subject to change in the future.
    //> @groupDef formItemStyling
    // Different FormItem types are rendered using different DOM structures. This is
    // an overview explaining the various elements that may be produced and how they can
    // be styled:
    // <P>
    // Form items written out by a DynamicForm with
    // +link{dynamicForm.itemLayout,itemLayout:"table"} are written into table cells.
    // A formItem can govern the appearance of these cells using properties such as
    // +link{formItem.cellStyle}, +link{formItem.cellHeight}. These properties have no effect for formItems
    // rendered outside a form (for example the during +link{ListGrid.canEdit,grid editing}),
    // or if <code>itemLayout</code> is "absolute".
    // <P>
    // If a formItem is showing a +link{formItem.showPickerIcon,picker icon}, the picker icon and
    // text box will be written into an element referred to as the control table. Styling
    // applied to this element (via +link{formItem.controlStyle}) will extend around both the
    // text box and the picker (but not other icons, hints, etc). The control table is not
    // written out if the pickerIcon is not visible except in the case where the
    // +link{formItem.showPickerIconOnFocus} is true, and the item does not have focus, or
    // if a developer explicitly sets +link{formItem.alwaysShowControlBox} to true.
    // <P>
    // The textBox of an item is the area containing its main textual content. This may
    // natively be achieved as a data element (such as an &lt;input ...&gt;), or a static
    // DOM element. See +link{formItem.textBoxStyle}, and related +link{formItem.readOnlyTextBoxStyle} and
    // +link{formItem.printTextBoxStyle} for styling options.
    // See also +link{formItem.shouldApplyHeightToTextBox()} for a discussion on sizing the text box.
    // <P>
    // Any visible +link{formItem.valueIcons,valueIcon} will be rendered inside the text box for
    // static items, or adjacent to it for items where the text is editable (such as
    // +link{TextItem}). Explicit styling for the valueIcon can be specified via
    // the +link{formItem.getValueIconStyle()} method.
    // <P>
    // FormItems can also show explicitly defined +link{formItem.icons}. By default these
    // show up next to the item, outside its text box and control table / after the
    // +link{formItem.showPickerIcon,picker icon} (if present), though
    // +link{formitemIcon.inline,inline positioning} is also supported for some cases.
    // Their appearance and behavior are heavily customizable - see
    // +link{formItemIcon.baseStyle}, +link{formItemIcon.src} and related properties.
    // <P>
    // +link{formItem.hint,FormItem hints} may be written out as static text
    // after any icons, and styled according to the +link{formItem.hintStyle} - or where supported,
    // written directly into the text box with styling derived from the textBoxStyle plus
    // a suffix of <code>"Hint"</code>. (See +link{TextItem.showHintInField}).
    // <P>
    // In addition to this, form items may show validation error icons or text
    // (see +link{dynamicForm.showInlineErrors}, +link{formItem.showErrorIcon} and
    // +link{formItem.showErrorText}). The position of these error indicators is controlled
    // by +link{dynamicForm.errorOrientation}.
    // <P>
    // Most formItem user-interface elements support stateful styling - showing a different
    // appearance for +link{formItem.showFocused,focused}, +link{formItem.showOver,over},
    // +link{formItem.showDisabled,disabled} and +link{formItem.showErrorStyle,error} states.
    // <P>
    // Default styling for items will vary by skin, and note that subclasses of
    // FormItem may have additional styling properties not explicitly called out here.<br>
    // Developers performing global styling modifications for formItems should also be
    // aware of compound items (such as +link{DateItem}) which achieve their user interface
    // by embedding simpler items in an outer structure. See +link{CompoundFormItem_skinning}.
    //
    // @treeLocation Client Reference/Forms/Form Items
    // @title FormItem Styling
    // @visibility external
    //<

    // Discussion on compound item / skinning for jsdoc. This is referred to by other JSDoc
    // entries but doesn't need to show up in the doc-tree.
    //> @groupDef CompoundFormItem_skinning
    // When skinning basic FormItems like SelectItem and TextItem, consider that compound form
    // items like DateItem and ComboBox reuse simpler items like SelectItem and TextItem, so adding
    // a border to SelectItem would also apply a border to each select item within DateItem.<br>
    // To avoid such side-effects, if you want to add styling to all SelectItems used in your
    // application, you can create an application-specific subclass like MySelectItem and apply
    // properties there.<br>
    // @visibility external
    //<

    //> @type FormItemBaseStyle
    // This string is the base CSS class name applied to a FormItem  (or some part of a form item).
    // See the +link{group:formItemStyling,formItem styling overview} for more information about
    // styling formItems.
    // <P>
    // The specified style name will be modified as the 'state' of the form item changes.
    // Developers should provide appropriately named CSS classes for each stateful style
    // described below:<ul>
    // <li>If +link{FormItem.showPending} is true, when the current value differs from the
    //     value that would be restored by a call to +link{DynamicForm.resetValues()}, this style
    //     will have the suffix "Pending"  appended to it.</li>
    // <li>If +link{FormItem.showFocused} is true, when the form item receives focus, this
    //     style will have the suffix "Focused" appended to it.</li>
    // <li>If +link{FormItem.showOver} is true, roll-over will be indicated by appending the
    //     suffix "Over" appended to the style name. This applies to the
    //     +link{FormItem.textBoxStyle,textBoxStyle} and
    //     +link{FormItem.controlStyle,controlStyle} only.</li>
    // <li>If +link{FormItem.showErrorStyle} is true, if the form item has errors, this
    //     style will have the suffix "Error" appended to it.</li>
    // <li>If +link{FormItem.showDisabled} is true, when the form item is disabled, this
    //     style will have the suffix "Disabled" appended to it.</li>
    // <li>Finally, if +link{FormItem.showRTL} is true, when the form item is in RTL mode, this
    //     style will have the suffix "RTL" appended to it.</ul>
    // So for example if the cellStyle for some form item is set to "formCell" and showFocused
    // is true, when the form item receives focus, the form item's cell will have the "formCellFocused"
    // style applied to it.
    // @baseType String
    // @visibility external
    // @group formItemStyling
    //<

    //> @attr formItem.cellStyle  (FormItemBaseStyle : "formCell" : IRW)
    // CSS style applied to the form item as a whole, including the text element, any icons, and
    // any hint text for the item. Applied to the cell containing the form item.
    // <P>
    // See +link{group:formItemStyling} for an overview of formItem styling, and
    // the +link{group:CompoundFormItem_skinning} discussion for special
    // skinning considerations.
    // @visibility external
    // @group formItemStyling
    //<
    cellStyle:"formCell",

    //> @attr formItem.hintStyle      (CSSStyleName : "formHint" : IRW)
    // CSS class for the "hint" string. For items that support
    // +link{TextItem.showHintInField}, this only applies when showHintInField is false.
    //
    // @see hint
    // @group formItemStyling
    // @visibility external
    //<

    hintStyle:"formHint",

    //> @attr formItem.useDisabledHintStyleForReadOnly (boolean : null : IRW)
    // By default, +link{formItem.canEdit,read-only} fields use the same style name as editable
    // fields for in-field hints, unless they are +link{formItem.isDisabled(),disabled} or
    // configured to use a disabled +link{type:ReadOnlyDisplayAppearance}.  This is described
    // under +link{textItem.showHintInField}
    // <p>
    // If <code>useDisabledHintStyleForReadOnly</code> is set, the "HintDisabled" style will be
    // used for read-only fields regardless of their <code>ReadOnlyDisplayAppearance</code>.  This
    // allows you to use a different in-field hint style for read-only fields without having to
    // use a general disabled appearance for those fields
    //
    // @group appearance
    // @visibility external
    //<

    //> @attr formItem.titleStyle (FormItemBaseStyle : "formTitle" : IRW)
    // Base CSS class name for a regular form-item's title. Note that this is a +link{FormItemBaseStyle}
    // so will pick up stateful suffixes on focus, disabled state change etc. by default.
    // <p>
    // When the +link{formItem.title, title} is shown +link{formItem.titleOrientation, above}
    // the item, the title element is given the
    // +link{formItem.verticalTitleStyle, verticalTitleStyle} if it's set, as it is in some
    // skins - otherwise, it will fall back to <code>titleStyle</code>.
    // <p>
    // Note the appearance of the title is also affected by
    // +link{dynamicForm.titlePrefix}/+link{dynamicForm.titleSuffix,titleSuffix} and
    // +link{dynamicForm.requiredTitlePrefix}/+link{dynamicForm.requiredTitleSuffix,requiredTitleSuffix}.
    //
    // @group formItemStyling
    // @visibility external
    // @see formItem.cellStyle
    //<
    titleStyle:"formTitle",

    //> @attr formItem.verticalTitleStyle (FormItemBaseStyle : null : IRW)
    // Base CSS class name for a form item's title when
    // +link{formItem.titleOrientation, titleOrientation is 'top'} . Note that this is a
    // +link{FormItemBaseStyle} so
    // will pick up stateful suffixes on focus, disabled state change etc. by default.
    // <p>
    // Note the appearance of the title is also affected by
    // +link{dynamicForm.titlePrefix}/+link{dynamicForm.titleSuffix,titleSuffix} and
    // +link{dynamicForm.requiredTitlePrefix}/+link{dynamicForm.requiredTitleSuffix,requiredTitleSuffix}.
    //
    // @group formItemStyling
    // @visibility internal
    // @see formItem.cellStyle
    //<
    //verticalTitleStyle:"formTitle",

    //> @attr formItem.printTitleStyle (FormItemBaseStyle : null : IRW)
    // Base CSS stylename for a form item's title when generating print HTML for the item.
    // If unset +link{formItem.titleStyle} will be used instead.
    // @group printing
    // @visibility external
    //<

    //> @attr formItem.textBoxStyle (FormItemBaseStyle : null : IRW)
    // Base CSS class name for a form item's text box element.
    // <p>
    // See +link{group:formItemStyling} for an overview of formItem styling, and
    // the +link{group:CompoundFormItem_skinning} discussion for special
    // skinning considerations.
    // <p>
    // If the <code>textBoxStyle</code> is changed at runtime, +link{formItem.updateState(),updateState()}
    // must be called to update the visual state of this item.
    // @group formItemStyling
    // @visibility external
    // @see formItem.cellStyle
    //<
    //textBoxStyle:null,

    //> @attr formItem.printTextBoxStyle (FormItemBaseStyle : null : IRW)
    // Base CSS class name for a form item's text box element when getting printable HTML for the
    // form. If unset +link{formItem.textBoxStyle} will be used instead. Note that focused styling
    // will never be displayed while printing, though error and disabled styling will.
    // <P>
    // By default this style will be used for printHTML for the item even if the item is
    // +link{canEdit,canEdit:false} with +link{readOnlyDisplay,readOnlyDisplay:static}.<br>
    // To override this behavior, developers may also specify a custom print style for this
    // state via the
    // +link{formitem.printReadOnlyTextBoxStyle}.
    //
    // @group printing, formItemStyling
    // @visibility external
    //<
    //printTextBoxStyle:null,

    //> @attr formItem.printReadOnlyTextBoxStyle (FormItemBaseStyle : null : IRW)
    // CSS class name to apply to the print view of an item's text box if the item
    // is +link{canEdit,canEdit:false}, with +link{readOnlyDisplay,readOnlyDisplay:static}.
    // <P>
    // If specified this will take precedence over +link{formItem.printTextBoxStyle} for
    // static readonly items.
    //
    // @group printing, formItemStyling
    // @visibility external
    //<


    //> @attr formItem.pickerIconStyle (FormItemBaseStyle : null : IRW)
    // Base CSS class name for a form item's picker icon cell. If unset, inherits from
    // this item's +link{controlStyle,controlStyle}.
    // @group pickerIcon
    // @group formItemStyling
    // @see formItem.cellStyle
    // @visibility external
    //<
    //pickerIconStyle:null,

    //> @attr formItem.controlStyle (FormItemBaseStyle : null : IRW)
    // Base CSS class name for a form item's "control box". This is an HTML element
    // which contains the text box and picker icon for the item.
    // <P>
    // See +link{formItem.alwaysShowControlBox} for details on when the control box
    // is written out.
    // <P>
    // See +link{group:formItemStyling} for an overview of formItem styling, and
    // the +link{group:CompoundFormItem_skinning} discussion for special
    // skinning considerations.
    // @group formItemStyling, pickerIcon
    // @visibility external
    // @see formItem.cellStyle
    //<
    //controlStyle:null,

    //> @attr formItem.editPendingCSSText (CSSText : "color:#0066CC;" : [IRWA])
    // Custom CSS text to be applied to cells with pending edits that have not yet been
    // submitted.
    // @visibility external
    // @group appearance
    //<
    editPendingCSSText:"color:#0066CC;",

    //> @attr formItem.valueDeselectedCSSText (CSSText : "color:#A8A8A8;text-decoration:line-through;" : IRA)
    // Custom CSS text to be applied to values that have been deleted, when
    // +link{attr:showDeletions,showDeletions} is enabled.
    // @visibility external
    //<
    valueDeselectedCSSText:"color:#A8A8A8;text-decoration:line-through;",

    // textColor clobbers the color in the textBoxStyle - used by ImageItem to show apparently
    // disabled text in an otherwise normal TextItem
    //textColor: null,

    //> @attr formItem.showFocusedErrorState (Boolean : false : IRWA)
    // If set to true, when an item has errors and is focused, an "ErrorFocused" suffix
    // will appear on the stylename.
    //
    // @group appearance
    // @visibility external
    // @see formItem.cellStyle
    //<
    showFocusedErrorState:false,

    // -------------------------------
    // Deprecated styling properties:

    //> @attr formItem.cellClassName (CSSStyleName : null : IR)
    // CSS class for a form item's cell in the form layout
    //
    // @group appearance
    // @visibility external
    // @deprecated As of SmartClient version 5.5, deprecated in favor of +link{formItem.cellStyle}
    //<

    //> @attr formItem.errorCellClassName (CSSStyleName : null : IR)
    // CSS class for a form item's cell when a validation error is showing.
    //
    // @group appearance
    // @visibility external
    // @deprecated As of SmartClient version 5.5 deprecated in favor of +link{formItem.cellStyle}
    //<

    //> @attr formItem.titleClassName (CSSStyleName : null : IR)
    // CSS class for the form item's title.
    // @group title
    // @visibility external
    // @deprecated As of SmartClient Version 5.5, use +link{formItem.titleStyle} instead
    //<

    //> @attr formItem.titleErrorClassName (CSSStyleName : null : IR)
    // CSS class for a form item's title when a validation error is showing.
    // @group title
    // @visibility external
    // @deprecated As of SmartClient Version 5.5, use +link{formItem.titleStyle} instead
    //<

    //> @attr formItem.hintClassName (CSSStyleName : null : IR)
    // CSS class for the "hint" string.
    //
    // @see hint
    // @group appearance
    // @visibility external
    // @deprecated As of SmartClient version 5.5, deprecated in favor of +link{FormItem.hintStyle}
    //<

    // Internal flag designating whether this element type has a data element
    // (an actual HTML form element, holding a value).  Accessed via the 'hasDataElement()'
    // method.
    _hasDataElement:false,

    // Hovers
    // -----------------------------------------------------------------------------------------
    //> @attr formItem.hoverDelay (number : null : IRWA)
    // If specified, this is the number of milliseconds to wait between the user rolling over
    // this form item, and triggering any hover action for it.<br>
    // If not specified <code>this.form.itemHoverDelay</code> will be used instead.
    // @group Hovers
    // @visibility external
    //<
    //,hoverDelay:null

    //> @attr formItem.hoverWidth (Number | String : null : [IRW])
    // Option to specify a width for any hover shown for this item.
    // @see DynamicForm.itemHoverWidth
    // @group Hovers
    // @visibility external
    //<

    //> @attr FormItem.hoverHeight  (Number | String : null : [IRW])
    // Option to specify a height for any hover shown for this item.
    // @see DynamicForm.itemHoverHeight
    // @group Hovers
    // @visibility external
    //<

    //> @attr FormItem.hoverAlign (Alignment  : null : [IRW])
    // Text alignment  for text displayed in this item's hover canvas, if shown.
    // @see DynamicForm.itemHoverAlign
    // @group Hovers
    // @visibility external
    //<

    //> @attr FormItem.hoverVAlign (VerticalAlignment : null : [IRW])
    // Vertical text alignment  for text displayed in this item's hover canvas, if shown.
    // @see DynamicForm.itemHoverVAlign
    // @group Hovers
    // @visibility external
    //<

    //> @attr FormItem.hoverStyle (CSSStyleName  : null : [IRW])
    // Explicit CSS Style for any hover shown for this item.
    // @see DynamicForm.itemHoverStyle
    // @group Hovers
    // @visibility external
    //<

    //> @attr FormItem.hoverOpacity (number : null : [IRW])
    // Opacity for any hover shown for this item
    // @see DynamicForm.itemHoverOpacity
    // @group Hovers
    // @visibility external
    //<

    //> @attr FormItem.hoverRect (Object : null : [IRWA])
    // Explicit placement information for any hover shown for this item.
    // Should be specified as an object of the form <br>
    // <code>{left:[value], top:[value], width:[value], height:[value]}</code>
    // @see DynamicForm.itemHoverRect
    // @group Hovers
    // @visibility internal
    //<


    //> @attr formItem.showClippedTitleOnHover (boolean : true : [IRW])
    // If true and the title is clipped, then a hover containing the full title of this item
    // is enabled.
    // <p>
    // <smartclient>The +link{formItem.titleHover()} method is called before the
    // hover is displayed, allowing the hover to be canceled if desired. The HTML shown in the
    // hover can be customized by overriding +link{formItem.titleHoverHTML()}.</smartclient>
    // <smartgwt>A <code>TitleHoverEvent</code> is fired before the hover is displayed,
    // allowing the hover to be canceled if desired. The HTML shown in the hover can be customized
    // by setting a <code>FormItemHoverFormatter</code> on either this <code>FormItem</code>
    // or the <code>DynamicForm</code>. See <code>setItemTitleHoverFormatter()</code>.</smartgwt>
    // @group Hovers
    // @visibility external
    //<
    showClippedTitleOnHover:true,

    //> @attr FormItem.showClippedValueOnHover (Boolean : true : [IRW])
    // If true and the value is clipped, then a hover containing the full value of this item
    // is enabled.
    // <p>
    // <smartclient>The +link{FormItem.valueHover()} method is called before the
    // hover is displayed, allowing the hover to be canceled if desired. The HTML shown in the
    // hover can be customized by overriding +link{FormItem.valueHoverHTML()}.</smartclient>
    // <smartgwt>A <code>ValueHoverEvent</code> is fired before the hover is displayed,
    // allowing the hover to be canceled if desired. The HTML shown in the hover can be customized
    // by setting a <code>FormItemHoverFormatter</code> on either this <code>FormItem</code>
    // or the <code>DynamicForm</code>. See <code>setItemValueHoverFormatter()</code>.</smartgwt>
    // @group Hovers
    // @visibility external
    //<
    showClippedValueOnHover:true

    //> @attr formItem.showOldValueInHover (Boolean : null : IRWA)
    // Causes the original value to be shown to the end user when the user hovers over the
    // FormItem as such (when the +link{FormItem.itemHover()} event would fire).
    // <p>
    // When +link{attr:showOldValueInHover} and the form's +link{DynamicForm.showOldValueInHover}
    // are both unset, defaults to the value of +link{attr:showPending}.
    // <p>
    // The message shown is controlled by +link{attr:originalValueMessage}, unless the item is
    // +link{formItem.disabled, disabled} and +link{formItem.disabledHover, disabledHover} is
    // set - in this case, the hover shows the <code>disabledHover</code> HTML.
    // @visibility external
    //<
    //, showOldValueInHover: null

    //> @attr formItem.originalValueMessage (HTMLString : null : IRWA)
    // Message shown when +link{attr:showOldValueInHover,showOldValueInHover} is enabled and
    // the value has been modified.
    // <p>
    // If unset, defaults to the form's +link{DynamicForm.originalValueMessage}. Otherwise,
    // overrides the form-default <code>originalValueMessage</code> for this item.
    // @visibility external
    //<
    //, originalValueMessage: null

    //> @attr formItem.nullOriginalValueText (HTMLString : "None" : IRWA)
    // Text shown as the value in the +link{FormItem.originalValueMessage} when
    // +link{attr:showOldValueInHover,showOldValueInHover} is enabled, and when
    // the value has been modified but was originally unset.
    // @visibility external
    //<
    , nullOriginalValueText: "None"

    // Criteria and Operators
    // -----------------------------------------------------------------------------------------

    //> @attr formItem.operator (OperatorId : null : IR)
    // +link{OperatorId} to be used when +link{dynamicForm.getValuesAsCriteria()} is called.
    // <P>
    // <code>item.operator</code> can be used to create a form that offers search functions such
    // as numeric range filtering, without the more advanced user interface of the
    // +link{FilterBuilder}.  For example, two SpinnerItems could be created with
    // <code>formItem.operator</code> set to "greaterThan" and "lessThan" respectively to
    // enable filtering by a numeric range.
    // <P>
    // When <code>item.operator</code> is set for any FormItem in a form,
    // <code>form.getValuesAsCriteria()</code> will return an +link{AdvancedCriteria} object
    // instead of a normal +link{Criteria} object.  Each FormItem will produce one
    // +link{Criterion} affecting the DataSource field specified by +link{formItem.criteriaField}.
    // The criteria produced by the FormItems will be grouped under the logical operator
    // provided by +link{dynamicForm.operator}.
    // <P>
    // If <code>operator</code> is set for some fields but not others, the default operator is
    // "equals" for fields with a valueMap or an optionDataSource, and for fields of type "enum"
    // (or of a type that inherits from "enum").  The default operator for all other fields is
    // controlled by +link{dynamicForm.defaultSearchOperator}.
    // <P>
    // <b>Note:</b> <code>formItem.operator</code> is only supported for a form that has a
    // +link{dataBoundComponent.dataSource,dataSource}.  In