<%@ page contentType="text/html;charset=UTF-8" %>
<%@ taglib uri="/WEB-INF/struts-bean.tld" prefix="bean" %>
<%@ taglib uri="/WEB-INF/struts-html.tld" prefix="html" %>
<%@ taglib uri="/WEB-INF/struts-logic.tld" prefix="logic" %>
<%@ taglib uri="/WEB-INF/iscTaglib.xml" prefix="isomorphic" %>


<html:html>
<head>
<title><bean:message key="exampleForm.title"/></title>
<html:base/>
<!-- load SmartClient -->
<isomorphic:loadISC skin="SmartClient"/>
</head>
<body bgcolor="white">

<SCRIPT>

DynamicForm.create({
    ID: "exampleForm",
    autoDraw: false,
    action: "dynamic_form_submit.do",
    submitParamsOnly: true,
    fields : [
        { name:"firstName", title: "<bean:message key="exampleForm.firstname.displayname"/>",
          type: "text", length: 30},
        { name:"lastName", title: "<bean:message key="exampleForm.lastname.displayname"/>",
          type: "text", length: 60},
        { name:"addr", title: "<bean:message key="exampleForm.addr.displayname"/>",
          type: "text", length: 2000},
        { name:"cityStateZip.city", title: "<bean:message key="exampleForm.city.displayname"/>",
          type: "text", length: 60},
        { name:"cityStateZip.stateProv", title: "<bean:message key="exampleForm.stateprov.displayname"/>",
          type: "text", length: 60},
        { name:"cityStateZip.zipPostal[1]", title: "<bean:message key="exampleForm.zippostal.displayname"/>",
          type: "text", length: 25},
        { name:"phone", title: "<bean:message key="exampleForm.phone.displayname"/>",
          type: "text", length: 20},
        { name:"email", title: "<bean:message key="exampleForm.email.displayname"/>",
          type: "text", length: 20},
        { name: "<bean:message key="button.cancel"/>", type:"hidden" }
    ]
});

// error strings are output into this block
var errorStrings = {
    firstName : "<html:errors property="firstName"/>",
    lastName : "<html:errors property="lastName"/>",
    addr : "<html:errors property="addr"/>",
    "cityStateZip.city" : "<html:errors property="cityStateZip.city"/>",
    "cityStateZip.stateProv" : "<html:errors property="cityStateZip.stateProv"/>",
    "cityStateZip.zipPostal[1]" : "<html:errors property="cityStateZip.zipPostal[1]"/>",
    "phone" : "<html:errors property="phone"/>",
    "email" : "<html:errors property="email"/>"
};

// we only want to setErrors() on the form if there are actual errors. If there was no error,
// the string for that error will be the empty string "", so create a new errors object that
// only contains non-empty error strings and then pass it to the form via setErrors() if
// there's at least on entry.
var errors = {};
for (var key in errorStrings) {
    if (errorStrings[key] != "") {
        errors[key] = errorStrings[key];
    }
}
if (!isc.isA.emptyObject(errors)) exampleForm.setErrors(errors);


ToolStrip.create({
    ID: "buttons",
    autoDraw: false,
    backgroundColor: "white",
    membersMargin: 10,
    members: [
        isc.AutoFitButton.create({ title: "<bean:message key="button.save"/>", click: "exampleForm.submitForm()" }),
        isc.AutoFitButton.create({ title: "<bean:message key="button.reset"/>", click: "exampleForm.reset()" }),
        isc.AutoFitButton.create({ title: "<bean:message key="button.cancel"/>", click: "exampleForm.cancel()" }) 
    ]
});


VLayout.create({
    members: [ exampleForm, buttons ]
});


</SCRIPT>
</body>
</html:html>


