/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.examples;

import com.isomorphic.collections.DataTypeMap;
import com.isomorphic.datasource.DSRequest;
import com.isomorphic.datasource.DSResponse;
import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.util.DataTools;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HugeTreeOpenNodesDMI {
    private final Logger log = new Logger(HugeTreeOpenNodesDMI.class.getName());
    private static final String ID_PROPERTY = "id";
    private static final String PARENT_ID_PROPERTY = "parent";
    private static final String CHILDREN_PROPERTY = "children";
    private static final String OPEN_PROPERTY = "isOpen";
    private static final String CHILD_COUNT_PROPERTY = "childCount";
    private static final String CAN_RETURN_OPEN_SUBFOLDERS_PROPERTY = "canReturnOpenSubfolders";
    private static final long CHILDREN_PAGE_SIZE = 50L;

    public DSResponse execute(DSRequest dsRequest) throws Exception {
        DSResponse dsResponse = dsRequest.execute();
        if (dsResponse.statusIsSuccess() && "fetch".equals(dsResponse.getOperationType())) {
            HashMap criteria = dsRequest.getCriteria();
            criteria = criteria == null ? new HashMap() : new HashMap(criteria);
            HashMap<String, Boolean> openCriteria = new HashMap<String, Boolean>(criteria);
            openCriteria.put(OPEN_PROPERTY, true);
            this.addChildrenToRecords(dsRequest, criteria, openCriteria, dsResponse.getDataList());
        }
        return dsResponse;
    }

    private void addChildrenToRecords(DSRequest dsRequest, Map criteria, Map openCriteria, List records) throws Exception {
        if (records != null) {
            DataSource dataSource = dsRequest.getDataSource();
            for (Object record : records) {
                if (!Boolean.TRUE.equals(dataSource.getProperties(record).get(OPEN_PROPERTY))) continue;
                this.addChildrenToRecord(dsRequest, criteria, openCriteria, record);
            }
        }
    }

    private void addChildrenToRecord(DSRequest dsRequest, Map criteria, Map openCriteria, Object record) throws Exception {
        DataSource dataSource = dsRequest.getDataSource();
        Object recordId = dataSource.getProperties(record).get(ID_PROPERTY);
        criteria.put(PARENT_ID_PROPERTY, recordId);
        dsRequest.setCriteria((Object)criteria);
        dsRequest.setStartRow(0L);
        dsRequest.setEndRow(50L);
        DSResponse dsResponse = dsRequest.execute();
        long startRow = dsResponse.getStartRow();
        long endRow = dsResponse.getEndRow();
        long totalRows = dsResponse.getTotalRows();
        long size = endRow - startRow + 1L;
        List children = dsResponse.getDataList();
        openCriteria.put(PARENT_ID_PROPERTY, recordId);
        dsRequest.setStartRow(0L);
        dsRequest.setEndRow(1L);
        dsRequest.setCriteria((Object)openCriteria);
        dsResponse = dsRequest.execute();
        List data = dsResponse.getDataList();
        boolean canReturnOpenSubfolders = data != null && !data.isEmpty();
        DataTypeMap properties = totalRows != -1L && (startRow == -1L || endRow == -1L || size < totalRows) ? DataTools.buildMap((Object[])new Object[]{CHILDREN_PROPERTY, children, CHILD_COUNT_PROPERTY, totalRows, CAN_RETURN_OPEN_SUBFOLDERS_PROPERTY, canReturnOpenSubfolders}) : DataTools.buildMap((Object[])new Object[]{CHILDREN_PROPERTY, children, CAN_RETURN_OPEN_SUBFOLDERS_PROPERTY, canReturnOpenSubfolders});
        this.setProperties(dataSource, (Map)properties, record);
        if (children != null) {
            for (Object child : children) {
                if (!Boolean.TRUE.equals(dataSource.getProperties(child).get(OPEN_PROPERTY))) continue;
                this.addChildrenToRecord(dsRequest, criteria, openCriteria, child);
            }
        }
    }

    private void setProperties(DataSource dataSource, Map properties, Object target) {
        if (target instanceof Map) {
            DataTools.mapMerge((Map)properties, (Map)((Map)target));
        } else {
            dataSource.setProperties(properties, target);
        }
    }
}

