var ds = isc.DataSource.get("productRevenue");

isc.FacetChart.create({
    ID: "dynamicChart",
    title: "Revenue",

    // You use facets to define the ways in which you would like the chart to
    // break down the data. In this case, our data has two dimensions: scenario and region
    facets: [{
        id: "Regions",  // the key used for this facet in the data
        title: "Region" // the user-visible title you want in the chart
    },{
        id: "Scenarios",  
        title: "Scenario" 
    }],
    
    chartType: "Area",
    stacked: false, // we unstack to see the comparison between the two scenarios (budget vs. actual)
    valueProperty: "value", // the property in the data that is the numerical value to chart

    // This is a function to update the chart's data from the dataSource. We combine some fixed
    // criteria with any additional criteria supplied as a parameter.
    updateData : function (dynamicCriteria, title) {
        var self = this; // So we can refer to ourself in the callback below, where "this" will have changed
        ds.fetchData(
            // The first parameter is the critera ... we combine fixed criteria with those passed in
            isc.DataSource.combineCriteria({
                Products: "Prod01",
                Regions: ["North", "South", "East", "West"]
            }, dynamicCriteria),
            // The second parameter is the callback once the data arrives
            function (dsResponse, data, dsRequest) {
                self.setProperty("title", title);
                self.setData(data);
            }
        );
    }
});

// Note that the dataSource has pre-computed subtotals in the "Time" field ... we start
// with "sum", which is the grand total, and use the form defined below to pick out others
dynamicChart.updateData({
    Time: "sum"
}, "Revenue for All Years");

// This is a form which you can use to change the chart type

isc.DynamicForm.create({
    ID: "chartSelector",
    wrapItemTitles: false,
    width: "25%",
    items: [{
        name: "chartType",
        title: "Chart Type",
        type: "select",
        valueMap: ["Area", "Column", "Bar", "Line", "Pie", "Doughnut", "Radar"],
        defaultValue: "Area",
        changed : function (form, item, value) {
            dynamicChart.setChartType(value)
        }
    }]
});

// Have the chartSelector update itself if the context menu is used to change chartType
chartSelector.observe(dynamicChart, "setChartType", "chartSelector.setValue('chartType', dynamicChart.chartType)");

// For simplicity, define time values manually.  These could also be derived from the database.

isc.Tree.create({
    ID: "timeTree",
    modelType: "parent",
    rootValue: "sum",
    showRoot: true,
    data: [
        {id:"sum", title:"All Years", collapsed:false},
        {id:"2014", parentId:"sum", title:"2014"},
        {id:"2015", parentId:"sum", title:"2015"},
        {id:"2016", parentId:"sum", title:"2016", collapsed:false},
        {id:"Q1-2014", parentId:"2014", title:"Q1-2014"},
        {id:"Q2-2014", parentId:"2014", title:"Q2-2014"},
        {id:"Q3-2014", parentId:"2014", title:"Q3-2014"},
        {id:"Q4-2014", parentId:"2014", title:"Q4-2014"},
        {id:"Q1-2015", parentId:"2015", title:"Q1-2015"},
        {id:"Q2-2015", parentId:"2015", title:"Q2-2015"},
        {id:"Q3-2015", parentId:"2015", title:"Q3-2015"},
        {id:"Q4-2015", parentId:"2015", title:"Q4-2015"},
        {id:"Q1-2016", parentId:"2016", title:"Q1-2016"},
        {id:"Q2-2016", parentId:"2016", title:"Q2-2016"},
        {id:"Q3-2016", parentId:"2016", title:"Q3-2016"},
        {id:"Q4-2016", parentId:"2016", title:"Q4-2016"},
        {id:"1/1/2014", parentId:"Q1-2014", title:"1/1/2014"},
        {id:"2/1/2014", parentId:"Q1-2014", title:"2/1/2014"},
        {id:"3/1/2014", parentId:"Q1-2014", title:"3/1/2014"},
        {id:"4/1/2014", parentId:"Q2-2014", title:"4/1/2014"},
        {id:"5/1/2014", parentId:"Q2-2014", title:"5/1/2014"},
        {id:"6/1/2014", parentId:"Q2-2014", title:"6/1/2014"},
        {id:"7/1/2014", parentId:"Q3-2014", title:"7/1/2014"},
        {id:"8/1/2014", parentId:"Q3-2014", title:"8/1/2014"},
        {id:"9/1/2014", parentId:"Q3-2014", title:"9/1/2014"},
        {id:"10/1/2014", parentId:"Q4-2014", title:"10/1/2014"},
        {id:"11/1/2014", parentId:"Q4-2014", title:"11/1/2014"},
        {id:"12/1/2014", parentId:"Q4-2014", title:"12/1/2014"},
        {id:"1/1/2015", parentId:"Q1-2015", title:"1/1/2015"},
        {id:"2/1/2015", parentId:"Q1-2015", title:"2/1/2015"},
        {id:"3/1/2015", parentId:"Q1-2015", title:"3/1/2015"},
        {id:"4/1/2015", parentId:"Q2-2015", title:"4/1/2015"},
        {id:"5/1/2015", parentId:"Q2-2015", title:"5/1/2015"},
        {id:"6/1/2015", parentId:"Q2-2015", title:"6/1/2015"},
        {id:"7/1/2015", parentId:"Q3-2015", title:"7/1/2015"},
        {id:"8/1/2015", parentId:"Q3-2015", title:"8/1/2015"},
        {id:"9/1/2015", parentId:"Q3-2015", title:"9/1/2015"},
        {id:"10/1/2015", parentId:"Q4-2015", title:"10/1/2015"},
        {id:"11/1/2015", parentId:"Q4-2015", title:"11/1/2015"},
        {id:"12/1/2015", parentId:"Q4-2015", title:"12/1/2015"},
        {id:"1/1/2016", parentId:"Q1-2016", title:"1/1/2016"},
        {id:"2/1/2016", parentId:"Q1-2016", title:"2/1/2016"},
        {id:"3/1/2016", parentId:"Q1-2016", title:"3/1/2016"},
        {id:"4/1/2016", parentId:"Q2-2016", title:"4/1/2016"},
        {id:"5/1/2016", parentId:"Q2-2016", title:"5/1/2016"},
        {id:"6/1/2016", parentId:"Q2-2016", title:"6/1/2016"},
        {id:"7/1/2016", parentId:"Q3-2016", title:"7/1/2016"},
        {id:"8/1/2016", parentId:"Q3-2016", title:"8/1/2016"},
        {id:"9/1/2016", parentId:"Q3-2016", title:"9/1/2016"},
        {id:"10/1/2016", parentId:"Q4-2016", title:"10/1/2016"},
        {id:"11/1/2016", parentId:"Q4-2016", title:"11/1/2016"},
        {id:"12/1/2016", parentId:"Q4-2016", title:"12/1/2016"}
    ]
});

// The form that lets you select a time period

isc.DynamicForm.create({
    ID: "timeSelector",
    wrapItemTitles: false,
    items: [{
        name: "timePeriod",
        title: "Time Period",
        type: "pickTree",
        valueTree: timeTree,
        canSelectParentItems: true,
        displayField: "title",
        valueField: "id",
        changed : function (form, item, value) {
            dynamicChart.updateData({
                Time: value
            }, "Revenue for " + timeTree.findById(value).title);
        }
    }]
});

// Overall layout

isc.VLayout.create({
    ID: "dynamicChartLayout",
    width: "100%",
    height: "100%",
    membersMargin: 20,
    members: [
        isc.HLayout.create({
            height: 40,
            members: [chartSelector, timeSelector]
        }),
        dynamicChart
    ]
});

