/*

  SmartClient Ajax RIA system
  Version v12.0p_2025-11-27/LGPL Development Only (2025-11-27)

  Copyright 2000 and beyond Isomorphic Software, Inc. All rights reserved.
  "SmartClient" is a trademark of Isomorphic Software, Inc.

  LICENSE NOTICE
     INSTALLATION OR USE OF THIS SOFTWARE INDICATES YOUR ACCEPTANCE OF
     ISOMORPHIC SOFTWARE LICENSE TERMS. If you have received this file
     without an accompanying Isomorphic Software license file, please
     contact licensing@isomorphic.com for details. Unauthorized copying and
     use of this software is a violation of international copyright law.

  DEVELOPMENT ONLY - DO NOT DEPLOY
     This software is provided for evaluation, training, and development
     purposes only. It may include supplementary components that are not
     licensed for deployment. The separate DEPLOY package for this release
     contains SmartClient components that are licensed for deployment.

  PROPRIETARY & PROTECTED MATERIAL
     This software contains proprietary materials that are protected by
     contract and intellectual property law. You are expressly prohibited
     from attempting to reverse engineer this software or modify this
     software for human readability.

  CONTACT ISOMORPHIC
     For more information regarding license rights and restrictions, or to
     report possible license violations, please contact Isomorphic Software
     by email (licensing@isomorphic.com) or web (www.isomorphic.com).

*/

if(window.isc&&window.isc.module_Core&&!window.isc.module_SkinUtil){isc.module_SkinUtil=1;isc._moduleStart=isc._SkinUtil_start=(isc.timestamp?isc.timestamp():new Date().getTime());if(isc._moduleEnd&&(!isc.Log||(isc.Log&&isc.Log.logIsDebugEnabled('loadTime')))){isc._pTM={message:'SkinUtil load/parse time: '+(isc._moduleStart-isc._moduleEnd)+'ms',category:'loadTime'};if(isc.Log&&isc.Log.logDebug)isc.Log.logDebug(isc._pTM.message,'loadTime');else if(isc._preLog)isc._preLog[isc._preLog.length]=isc._pTM;else isc._preLog=[isc._pTM]}isc.definingFramework=true;(function(){function skinColor(_8,_80){if(!(this instanceof skinColor)){return new skinColor(_8,_80)}
if(typeof _8=="object"){return _8}
this.attachValues(toColorObject(_8));if(_80){_80.style.backgroundColor=this.toRgbString()}}
skinColor.prototype={toRgbString:function(){return"rgb("+this.red+", "+this.green+", "+this.blue+")"},toRgbaString:function(){return"rgba("+this.red+", "+this.green+", "+this.blue+", "+this.opacity+")"},toHwbString:function(){return"hwb("+this.hue+", "+Math.round(this.whiteness*100)+"%, "+Math.round(this.blackness*100)+"%)"},toHwbStringDecimal:function(){return"hwb("+this.hue+", "+this.whiteness+", "+this.blackness+")"},toHwbaString:function(){return"hwba("+this.hue+", "+Math.round(this.whiteness*100)+"%, "+Math.round(this.blackness*100)+"%, "+this.opacity+")"},toHslString:function(){return"hsl("+this.hue+", "+Math.round(this.sat*100)+"%, "+Math.round(this.lightness*100)+"%)"},toHslStringDecimal:function(){return"hsl("+this.hue+", "+this.sat+", "+this.lightness+")"},toHslaString:function(){return"hsla("+this.hue+", "+Math.round(this.sat*100)+"%, "+Math.round(this.lightness*100)+"%, "+this.opacity+")"},toCmykString:function(){return"cmyk("+Math.round(this.cyan*100)+"%, "+Math.round(this.magenta*100)+"%, "+Math.round(this.yellow*100)+"%, "+Math.round(this.black*100)+"%)"},toCmykStringDecimal:function(){return"cmyk("+this.cyan+", "+this.magenta+", "+this.yellow+", "+this.black+")"},toNcolString:function(){return this.ncol+", "+Math.round(this.whiteness*100)+"%, "+Math.round(this.blackness*100)+"%"},toNcolStringDecimal:function(){return this.ncol+", "+this.whiteness+", "+this.blackness},toNcolaString:function(){return this.ncol+", "+Math.round(this.whiteness*100)+"%, "+Math.round(this.blackness*100)+"%, "+this.opacity},toName:function(){var r,g,b,_4=getColorArr('hexs');for(i=0;i<_4.length;i++){r=parseInt(_4[i].substr(0,2),16);g=parseInt(_4[i].substr(2,2),16);b=parseInt(_4[i].substr(4,2),16);if(this.red==r&&this.green==g&&this.blue==b){return getColorArr('names')[i]}}
return""},toHexString:function(){var r=toHex(this.red);var g=toHex(this.green);var b=toHex(this.blue);return"#"+r+g+b},toRgb:function(){return{r:this.red,g:this.green,b:this.blue,a:this.opacity}},toHsl:function(){return{h:this.hue,s:this.sat,l:this.lightness,a:this.opacity}},toHwb:function(){return{h:this.hue,w:this.whiteness,b:this.blackness,a:this.opacity}},toCmyk:function(){return{c:this.cyan,m:this.magenta,y:this.yellow,k:this.black,a:this.opacity}},toNcol:function(){return{ncol:this.ncol,w:this.whiteness,b:this.blackness,a:this.opacity}},isDark:function(_80){var m=(_80||128);return(((this.red*299+this.green*587+this.blue*114)/1000)<m)},saturate:function(_80){var x,_7,_8;x=(_80/100||0.1);this.sat+=x;if(this.sat>1){this.sat=1}
_7=hslToRgb(this.hue,this.sat,this.lightness);_8=colorObject(_7,this.opacity,this.hue,this.sat);this.attachValues(_8)},desaturate:function(_80){var x,_7,_8;x=(_80/100||0.1);this.sat-=x;if(this.sat<0){this.sat=0}
_7=hslToRgb(this.hue,this.sat,this.lightness);_8=colorObject(_7,this.opacity,this.hue,this.sat);this.attachValues(_8)},lighten:function(_80){var x,_7,_8;x=(_80/100||0.1);this.lightness+=x;if(this.lightness>1){this.lightness=1}
_7=hslToRgb(this.hue,this.sat,this.lightness);_8=colorObject(_7,this.opacity,this.hue,this.sat);this.attachValues(_8)},darken:function(_80){var x,_7,_8;x=(_80/100||0.1);this.lightness-=x;if(this.lightness<0){this.lightness=0}
_7=hslToRgb(this.hue,this.sat,this.lightness);_8=colorObject(_7,this.opacity,this.hue,this.sat);this.attachValues(_8)},attachValues:function(_8){this.red=_8.red;this.green=_8.green;this.blue=_8.blue;this.hue=_8.hue;this.sat=_8.sat;this.lightness=_8.lightness;this.whiteness=_8.whiteness;this.blackness=_8.blackness;this.cyan=_8.cyan;this.magenta=_8.magenta;this.yellow=_8.yellow;this.black=_8.black;this.ncol=_8.ncol;this.opacity=_8.opacity;this.valid=_8.valid}};function toColorObject(c){var x,y,_10,_11=[],_12,i,_14,_15,a,_17,_18,_7,_19=[],_4=[];c=w3trim(c.toLowerCase());x=c.substr(0,1).toUpperCase();y=c.substr(1);a=1;if((x=="R"||x=="Y"||x=="G"||x=="C"||x=="B"||x=="M"||x=="W")&&!isNaN(y)){c="ncol("+c+")"}
if(c.length!=3&&c.length!=6&&!isNaN(c)){c="ncol("+c+")"}
if(c.indexOf(",")>0&&c.indexOf("(")==-1){c="ncol("+c+")"}
if(c.substr(0,3)=="rgb"||c.substr(0,3)=="hsl"||c.substr(0,3)=="hwb"||c.substr(0,4)=="ncol"||c.substr(0,4)=="cmyk"){if(c.substr(0,4)=="ncol"){if(c.split(",").length==4&&c.indexOf("ncola")==-1){c=c.replace("ncol","ncola")}
_10="ncol";c=c.substr(4)}else if(c.substr(0,4)=="cmyk"){_10="cmyk";c=c.substr(4)}else{_10=c.substr(0,3);c=c.substr(3)}
_12=3;_14=false;if(c.substr(0,1).toLowerCase()=="a"){_12=4;_14=true;c=c.substr(1)}else if(_10=="cmyk"){_12=4;if(c.split(",").length==5){_12=5;_14=true}}
c=c.replace("(","");c=c.replace(")","");_11=c.split(",");if(_10=="rgb"){if(_11.length!=_12){return emptyObject()}
for(i=0;i<_12;i++){if(_11[i]==""||_11[i]==" "){_11[i]="0"}
if(_11[i].indexOf("%")>-1){_11[i]=_11[i].replace("%","");_11[i]=Number(_11[i]/100);if(i<3){_11[i]=Math.round(_11[i]*255)}}
if(isNaN(_11[i])){return emptyObject()}
if(parseInt(_11[i])>255){_11[i]=255}
if(i<3){_11[i]=parseInt(_11[i])}
if(i==3&&Number(_11[i])>1){_11[i]=1}}
_7={r:_11[0],g:_11[1],b:_11[2]};if(_14==true){a=Number(_11[3])}}
if(_10=="hsl"||_10=="hwb"||_10=="ncol"){while(_11.length<_12){_11.push("0")}
if(_10=="hsl"||_10=="hwb"){if(parseInt(_11[0])>=360){_11[0]=0}}
for(i=1;i<_12;i++){if(_11[i].indexOf("%")>-1){_11[i]=_11[i].replace("%","");_11[i]=Number(_11[i]);if(isNaN(_11[i])){return emptyObject()}
_11[i]=_11[i]/100}else{_11[i]=Number(_11[i])}
if(Number(_11[i])>1){_11[i]=1}
if(Number(_11[i])<0){_11[i]=0}}
if(_10=="hsl"){_7=hslToRgb(_11[0],_11[1],_11[2]);_17=Number(_11[0]);_18=Number(_11[1])}
if(_10=="hwb"){_7=hwbToRgb(_11[0],_11[1],_11[2])}
if(_10=="ncol"){_7=ncolToRgb(_11[0],_11[1],_11[2])}
if(_14==true){a=Number(_11[3])}}
if(_10=="cmyk"){while(_11.length<_12){_11.push("0")}
for(i=0;i<_12;i++){if(_11[i].indexOf("%")>-1){_11[i]=_11[i].replace("%","");_11[i]=Number(_11[i]);if(isNaN(_11[i])){return emptyObject()}
_11[i]=_11[i]/100}else{_11[i]=Number(_11[i])}
if(Number(_11[i])>1){_11[i]=1}
if(Number(_11[i])<0){_11[i]=0}}
_7=cmykToRgb(_11[0],_11[1],_11[2],_11[3]);if(_14==true){a=Number(_11[4])}}}else if(c.substr(0,3)=="ncs"){_7=ncsToRgb(c)}else{_15=false;_19=getColorArr('names');for(i=0;i<_19.length;i++){if(c.toLowerCase()==_19[i].toLowerCase()){_4=getColorArr('hexs');_15=true;_7={r:parseInt(_4[i].substr(0,2),16),g:parseInt(_4[i].substr(2,2),16),b:parseInt(_4[i].substr(4,2),16)};break}}
if(_15==false){c=c.replace("#","");if(c.length==3){c=c.substr(0,1)+c.substr(0,1)+c.substr(1,1)+c.substr(1,1)+c.substr(2,1)+c.substr(2,1)}
_11[0]=parseInt(c.substr(0,2),16);_11[1]=parseInt(c.substr(2,2),16);_11[2]=parseInt(c.substr(4,2),16);for(i=0;i<3;i++){if(isNaN(_11[i])){return emptyObject()}}
_7={r:_11[0],g:_11[1],b:_11[2]}}}
return colorObject(_7,a,_17,_18)}
function colorObject(_7,a,h,s){var _20,_21,_22,_23,_8,_17,_18;if(!_7){return emptyObject()}
if(!a){a=1}
_20=rgbToHsl(_7.r,_7.g,_7.b);_21=rgbToHwb(_7.r,_7.g,_7.b);_22=rgbToCmyk(_7.r,_7.g,_7.b);_17=(h||_20.h);_18=(s||_20.s);_23=hueToNcol(_17);_8={red:_7.r,green:_7.g,blue:_7.b,hue:_17,sat:_18,lightness:_20.l,whiteness:_21.w,blackness:_21.b,cyan:_22.c,magenta:_22.m,yellow:_22.y,black:_22.k,ncol:_23,opacity:a,valid:true};_8=roundDecimals(_8);return _8}
function emptyObject(){return{red:0,green:0,blue:0,hue:0,sat:0,lightness:0,whiteness:0,blackness:0,cyan:0,magenta:0,yellow:0,black:0,ncol:"R",opacity:1,valid:false}}
function getColorArr(x){if(x=="names"){return['AliceBlue','AntiqueWhite','Aqua','Aquamarine','Azure','Beige','Bisque','Black','BlanchedAlmond','Blue','BlueViolet','Brown','BurlyWood','CadetBlue','Chartreuse','Chocolate','Coral','CornflowerBlue','Cornsilk','Crimson','Cyan','DarkBlue','DarkCyan','DarkGoldenRod','DarkGray','DarkGrey','DarkGreen','DarkKhaki','DarkMagenta','DarkOliveGreen','DarkOrange','DarkOrchid','DarkRed','DarkSalmon','DarkSeaGreen','DarkSlateBlue','DarkSlateGray','DarkSlateGrey','DarkTurquoise','DarkViolet','DeepPink','DeepSkyBlue','DimGray','DimGrey','DodgerBlue','FireBrick','FloralWhite','ForestGreen','Fuchsia','Gainsboro','GhostWhite','Gold','GoldenRod','Gray','Grey','Green','GreenYellow','HoneyDew','HotPink','IndianRed','Indigo','Ivory','Khaki','Lavender','LavenderBlush','LawnGreen','LemonChiffon','LightBlue','LightCoral','LightCyan','LightGoldenRodYellow','LightGray','LightGrey','LightGreen','LightPink','LightSalmon','LightSeaGreen','LightSkyBlue','LightSlateGray','LightSlateGrey','LightSteelBlue','LightYellow','Lime','LimeGreen','Linen','Magenta','Maroon','MediumAquaMarine','MediumBlue','MediumOrchid','MediumPurple','MediumSeaGreen','MediumSlateBlue','MediumSpringGreen','MediumTurquoise','MediumVioletRed','MidnightBlue','MintCream','MistyRose','Moccasin','NavajoWhite','Navy','OldLace','Olive','OliveDrab','Orange','OrangeRed','Orchid','PaleGoldenRod','PaleGreen','PaleTurquoise','PaleVioletRed','PapayaWhip','PeachPuff','Peru','Pink','Plum','PowderBlue','Purple','RebeccaPurple','Red','RosyBrown','RoyalBlue','SaddleBrown','Salmon','SandyBrown','SeaGreen','SeaShell','Sienna','Silver','SkyBlue','SlateBlue','SlateGray','SlateGrey','Snow','SpringGreen','SteelBlue','Tan','Teal','Thistle','Tomato','Turquoise','Violet','Wheat','White','WhiteSmoke','Yellow','YellowGreen']}
if(x=="hexs"){return['f0f8ff','faebd7','00ffff','7fffd4','f0ffff','f5f5dc','ffe4c4','000000','ffebcd','0000ff','8a2be2','a52a2a','deb887','5f9ea0','7fff00','d2691e','ff7f50','6495ed','fff8dc','dc143c','00ffff','00008b','008b8b','b8860b','a9a9a9','a9a9a9','006400','bdb76b','8b008b','556b2f','ff8c00','9932cc','8b0000','e9967a','8fbc8f','483d8b','2f4f4f','2f4f4f','00ced1','9400d3','ff1493','00bfff','696969','696969','1e90ff','b22222','fffaf0','228b22','ff00ff','dcdcdc','f8f8ff','ffd700','daa520','808080','808080','008000','adff2f','f0fff0','ff69b4','cd5c5c','4b0082','fffff0','f0e68c','e6e6fa','fff0f5','7cfc00','fffacd','add8e6','f08080','e0ffff','fafad2','d3d3d3','d3d3d3','90ee90','ffb6c1','ffa07a','20b2aa','87cefa','778899','778899','b0c4de','ffffe0','00ff00','32cd32','faf0e6','ff00ff','800000','66cdaa','0000cd','ba55d3','9370db','3cb371','7b68ee','00fa9a','48d1cc','c71585','191970','f5fffa','ffe4e1','ffe4b5','ffdead','000080','fdf5e6','808000','6b8e23','ffa500','ff4500','da70d6','eee8aa','98fb98','afeeee','db7093','ffefd5','ffdab9','cd853f','ffc0cb','dda0dd','b0e0e6','800080','663399','ff0000','bc8f8f','4169e1','8b4513','fa8072','f4a460','2e8b57','fff5ee','a0522d','c0c0c0','87ceeb','6a5acd','708090','708090','fffafa','00ff7f','4682b4','d2b48c','008080','d8bfd8','ff6347','40e0d0','ee82ee','f5deb3','ffffff','f5f5f5','ffff00','9acd32']}}
function roundDecimals(c){c.red=Number(c.red.toFixed(0));c.green=Number(c.green.toFixed(0));c.blue=Number(c.blue.toFixed(0));c.hue=Number(c.hue.toFixed(0));c.sat=Number(c.sat.toFixed(2));c.lightness=Number(c.lightness.toFixed(2));c.whiteness=Number(c.whiteness.toFixed(2));c.blackness=Number(c.blackness.toFixed(2));c.cyan=Number(c.cyan.toFixed(2));c.magenta=Number(c.magenta.toFixed(2));c.yellow=Number(c.yellow.toFixed(2));c.black=Number(c.black.toFixed(2));c.ncol=c.ncol.substr(0,1)+Math.round(Number(c.ncol.substr(1)));c.opacity=Number(c.opacity.toFixed(2));return c}
function hslToRgb(_17,_18,_80){var _24,_25,r,g,b;_17=_17/60;if(_80<=0.5){_25=_80*(_18+1)}else{_25=_80+_18-(_80*_18)}
_24=_80*2-_25;r=hueToRgb(_24,_25,_17+2)*255;g=hueToRgb(_24,_25,_17)*255;b=hueToRgb(_24,_25,_17-2)*255;return{r:r,g:g,b:b}}
function hueToRgb(_24,_25,_17){if(_17<0)_17+=6;if(_17>=6)_17-=6;if(_17<1)return(_25-_24)*_17+_24;else if(_17<3)return _25;else if(_17<4)return(_25-_24)*(4-_17)+_24;else return _24}
function hwbToRgb(_17,_80,_31){var i,_7,_26=[];_7=hslToRgb(_17,1,0.50);_26[0]=_7.r/255;_26[1]=_7.g/255;_26[2]=_7.b/255;for(i=0;i<3;i++){_26[i]*=(1-(_80)-(_31));_26[i]+=(_80);_26[i]=Number(_26[i]*255)}
return{r:_26[0],g:_26[1],b:_26[2]}}
function cmykToRgb(c,m,y,k){var r,g,b;r=255-((Math.min(1,c*(1-k)+k))*255);g=255-((Math.min(1,m*(1-k)+k))*255);b=255-((Math.min(1,y*(1-k)+k))*255);return{r:r,g:g,b:b}}
function ncolToRgb(_23,_80,_31){var _27,_28,h,w,b;h=_23;if(isNaN(_23.substr(0,1))){_27=_23.substr(0,1).toUpperCase();_28=_23.substr(1);if(_28==""){_28=0}
_28=Number(_28);if(isNaN(_28)){return false}
if(_27=="R"){h=0+(_28*0.6)}
if(_27=="Y"){h=60+(_28*0.6)}
if(_27=="G"){h=120+(_28*0.6)}
if(_27=="C"){h=180+(_28*0.6)}
if(_27=="B"){h=240+(_28*0.6)}
if(_27=="M"){h=300+(_28*0.6)}
if(_27=="W"){h=0;_80=1-(_28/100);_31=(_28/100)}}
return hwbToRgb(h,_80,_31)}
function hueToNcol(_17){while(_17>=360){_17=_17-360}
if(_17<60){return"R"+(_17/0.6)}
if(_17<120){return"Y"+((_17-60)/0.6)}
if(_17<180){return"G"+((_17-120)/0.6)}
if(_17<240){return"C"+((_17-180)/0.6)}
if(_17<300){return"B"+((_17-240)/0.6)}
if(_17<360){return"M"+((_17-300)/0.6)}}
function ncsToRgb(_80){var _31,_32,_33,_28,_34,_35,_36,_37,_38,_36,_39,_40,_41,_42,_43,_44,r,g,b;_80=w3trim(_80).toUpperCase();_80=_80.replace("(","");_80=_80.replace(")","");_80=_80.replace("NCS","NCS ");_80=_80.replace(/  /g," ");if(_80.indexOf("NCS")==-1){_80="NCS "+_80}
_80=_80.match(/^(?:NCS|NCS\sS)\s(\d{2})(\d{2})-(N|[A-Z])(\d{2})?([A-Z])?$/);if(_80===null)return false;_31=parseInt(_80[1],10);_32=parseInt(_80[2],10);_33=_80[3];if(_33!="N"&&_33!="Y"&&_33!="R"&&_33!="B"&&_33!="G"){return false}
_28=parseInt(_80[4],10)||0;if(_33!=='N'){_34=(1.05*_31-5.25);_35=_32;if(_33==='Y'&&_28<=60){_36=1}else if((_33==='Y'&&_28>60)||(_33==='R'&&_28<=80)){if(_33==='Y'){_37=_28-60}else{_37=_28+40}
_36=((Math.sqrt(14884-Math.pow(_37,2)))-22)/100}else if((_33==='R'&&_28>80)||(_33==='B')){_36=0}else if(_33==='G'){_37=(_28-170);_36=((Math.sqrt(33800-Math.pow(_37,2)))-70)/100}
if(_33==='Y'&&_28<=80){_38=0}else if((_33==='Y'&&_28>80)||(_33==='R'&&_28<=60)){if(_33==='Y'){_37=(_28-80)+20.5}else{_37=(_28+20)+20.5}
_38=(104-(Math.sqrt(11236-Math.pow(_37,2))))/100}else if((_33==='R'&&_28>60)||(_33==='B'&&_28<=80)){if(_33==='R'){_37=(_28-60)-60}else{_37=(_28+40)-60}
_38=((Math.sqrt(10000-Math.pow(_37,2)))-10)/100}else if((_33==='B'&&_28>80)||(_33==='G'&&_28<=40)){if(_33==='B'){_37=(_28-80)-131}else{_37=(_28+20)-131}
_38=(122-(Math.sqrt(19881-Math.pow(_37,2))))/100}else if(_33==='G'&&_28>40){_38=0}
if(_33==='Y'){green1=(85-17/20*_28)/100}else if(_33==='R'&&_28<=60){green1=0}else if(_33==='R'&&_28>60){_37=(_28-60)+35;green1=(67.5-(Math.sqrt(5776-Math.pow(_37,2))))/100}else if(_33==='B'&&_28<=60){_37=(1*_28-68.5);green1=(6.5+(Math.sqrt(7044.5-Math.pow(_37,2))))/100}else if((_33==='B'&&_28>60)||(_33==='G'&&_28<=60)){green1=0.9}else if(_33==='G'&&_28>60){_37=(_28-60);green1=(90-(1/8*_37))/100}
_37=(_36+green1+_38)/3;_39=((_37-_36)*(100-_35)/100)+_36;_40=((_37-green1)*(100-_35)/100)+green1;_41=((_37-_38)*(100-_35)/100)+_38;if(_39>_40&&_39>_41){_42=_39}else if(_40>_39&&_40>_41){_42=_40}else if(_41>_39&&_41>_40){_42=_41}else{_42=(_39+_40+_41)/3}
_43=1/_42;r=parseInt((_39*_43*(100-_34)/100)*255,10);g=parseInt((_40*_43*(100-_34)/100)*255,10);b=parseInt((_41*_43*(100-_34)/100)*255,10);if(r>255){r=255}
if(g>255){g=255}
if(b>255){b=255}
if(r<0){r=0}
if(g<0){g=0}
if(b<0){b=0}}else{_44=parseInt((1-_31/100)*255,10);if(_44>255){_44=255}
if(_44<0){_44=0}
r=_44;g=_44;b=_44}
return{r:r,g:g,b:b}}
function rgbToHsl(r,g,b){var _45,_42,i,l,s,_48,h,_7=[];_7[0]=r/255;_7[1]=g/255;_7[2]=b/255;_45=_7[0];_42=_7[0];_48=0;for(i=0;i<_7.length-1;i++){if(_7[i+1]<=_45){_45=_7[i+1]}
if(_7[i+1]>=_42){_42=_7[i+1];_48=i+1}}
if(_48==0){h=(_7[1]-_7[2])/(_42-_45)}
if(_48==1){h=2+(_7[2]-_7[0])/(_42-_45)}
if(_48==2){h=4+(_7[0]-_7[1])/(_42-_45)}
if(isNaN(h)){h=0}
h=h*60;if(h<0){h=h+360}
l=(_45+_42)/2;if(_45==_42){s=0}else{if(l<0.5){s=(_42-_45)/(_42+_45)}else{s=(_42-_45)/(2-_42-_45)}}
s=s;return{h:h,s:s,l:l}}
function rgbToHwb(r,g,b){var h,w,_49;r=r/255;g=g/255;b=b/255;_42=Math.max(r,g,b);_45=Math.min(r,g,b);_32=_42-_45;if(_32==0){h=0}else if(r==_42){h=(((g-b)/_32)%6)*360}else if(g==_42){h=((((b-r)/_32)+2)%6)*360}else{h=((((r-g)/_32)+4)%6)*360}
w=_45;_49=1-_42;return{h:h,w:w,b:_49}}
function rgbToCmyk(r,g,b){var c,m,y,k;r=r/255;g=g/255;b=b/255;_42=Math.max(r,g,b);k=1-_42;if(k==1){c=0;m=0;y=0}else{c=(1-r-k)/(1-k);m=(1-g-k)/(1-k);y=(1-b-k)/(1-k)}
return{c:c,m:m,y:y,k:k}}
function toHex(_80){var _52=_80.toString(16);while(_52.length<2){_52="0"+_52}
return _52}
function cl(x){console.log(x)}
function w3trim(x){return x.replace(/^\s+|\s+$/g,'')}
window.skinColor=skinColor;function rgbToXyz(r,g,b){var _53=(r/255);var _54=(g/255);var _55=(b/255);if(_53>0.04045){_53=Math.pow(((_53+0.055)/1.055),2.4)}
else{_53=_53/12.92}
if(_54>0.04045){_54=Math.pow(((_54+0.055)/1.055),2.4)}
else{_54=_54/12.92}
if(_55>0.04045){_55=Math.pow(((_55+0.055)/1.055),2.4)}
else{_55=_55/12.92}
_53=_53*100;_54=_54*100;_55=_55*100;X=_53*0.4124+_54*0.3576+_55*0.1805;Y=_53*0.2126+_54*0.7152+_55*0.0722;Z=_53*0.0193+_54*0.1192+_55*0.9505;return[X,Y,Z]};function rgbTolab(r,g,b){return xyzToLab(rbgToXyz(r,g,b))}
function xyzToLab(x,y,_80){var _56=95.047;var _57=100.000;var _58=108.883;var _59=x/_56;var _60=y/_57;var _61=_80/_58;if(_59>0.008856){_59=Math.pow(_59,(1/3))}
else{_59=(7.787*_59)+(16/116)}
if(_60>0.008856){_60=Math.pow(_60,(1/3))}
else{_60=(7.787*_60)+(16/116)}
if(_61>0.008856){_61=Math.pow(_61,(1/3))}
else{_61=(7.787*_61)+(16/116)}
var _62=(116*_60)-16;var _63=500*(_59-_60);var _64=200*(_60-_61);return[_62,_63,_64]};function cie1994(x,y,_80){var x={l:x[0],a:x[1],b:x[2]};var y={l:y[0],a:y[1],b:y[2]};labx=x;laby=y;var _65;var _66;var _67;var _68=1;var _69=1;if(_80){_65=0.014;_66=0.048;_67=2}
else{_65=0.015;_66=0.045;_67=1}
var _70=Math.sqrt(x.a*x.a+x.b*x.b);var _71=Math.sqrt(y.a*y.a+y.b*y.b);var _72=1+_65*_70;var _73=1+_66*_70;var _74=1;var _75=x.a-y.a;var _76=x.b-y.b;var _77=_70-_71;var _78=x.l-y.l;var _79=Math.sqrt(_75*_75+_76*_76-_77*_77);return Math.sqrt(Math.pow((_78/(_67*_74)),2)+Math.pow((_77/(_69*_73)),2)+Math.pow((_79/(_68*_72)),2))}})();isc.defineClass("SkinUtil");isc.A=isc.SkinUtil;isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.colorArrays=["background","color","border","borderTop","borderLeft","borderBottom","borderRight"];isc.A.skinColorWindowDefaults={_constructor:"Window",autoDraw:false,autoCenter:true,overflow:"visible",canDragResize:true,title:"Palette Tools",colorEditorDefaults:{_constructor:"SkinPaletteTools"},bodyProperties:{overflow:"visible"},draw:function(){this.Super("draw",arguments);this.addAutoChild("colorEditor");this.body.addMember(this.colorEditor)}};isc.B.push(isc.A.toHexString=function isc_c_SkinUtil_toHexString(_1){var _2=skinColor(_1);if(_2.valid)return _2.toHexString();else return""},isc.A.getSkinColor=function isc_c_SkinUtil_getSkinColor(_1){return skinColor(_1)},isc.A.createDataSources=function isc_c_SkinUtil_createDataSources(){var _1=isc.clone(isc.Canvas.$1937);var _2="";var _3=[];for(var i=0;i<_1.length;i++){var _5=_1[i];_5.backgroundCount=_5.background.length;_5.colorCount=_5.color.length;_5.borderCount=_5.border.length;_5.borderTopCount=_5.borderTop.length;_5.borderLeftCount=_5.borderLeft.length;_5.borderBottomCount=_5.borderBottom.length;_5.borderRightCount=_5.borderRight.length;var _6=isc.SkinUtil.getSkinColor(_5.original);isc.addProperties(_5,_6);_2+="\n"+_5.original+" background: "+_5.backgroundCount+", font-color: "+_5.colorCount+", border: "+_5.borderCount+", borderTop: "+_5.borderTopCount+", borderLeft: "+_5.borderLeftCount+", borderBottom: "+_5.borderBottomCount+", borderRight: "+_5.borderRightCount;var _7=0;var _8=isc.SkinUtil.colorArrays;for(var j=0;j<_8.length;j++){var _10=_5[_8[j]+"Count"];if(_10>_7){_7=_10;if(_8[j].contains("border")){_5.mostlyType="Borders"}else if(_8[j].contains("background")){_5.mostlyType="Backgrounds"}else{_5.mostlyType="Fonts"}}}
_3.add(_5)}
isc.DataSource.create({ID:"colorSearchDS",clientOnly:true,fields:[{name:"original",primaryKey:true},{name:"current"},{name:"isSkinCSS",type:"boolean"},{name:"background",multiple:true},{name:"color",multiple:true},{name:"border",multiple:true},{name:"borderTop",multiple:true},{name:"borderLeft",multiple:true},{name:"borderBottom",multiple:true},{name:"borderRight",multiple:true},{name:"backgroundCount",type:"integer"},{name:"colorCount",type:"integer"},{name:"borderCount",type:"integer"},{name:"borderTopCount",type:"integer"},{name:"borderLeftCount",type:"integer"},{name:"borderBottomCount",type:"integer"},{name:"borderRightCount",type:"integer"},{name:"mostlyType"},{name:"red",type:"integer"},{name:"green",type:"integer"},{name:"blue",type:"integer"},{name:"hue",type:"integer"},{name:"sat",type:"integer"},{name:"lightness",type:"integer"},{name:"lab",type:"number"}],cacheData:_3});isc.SkinUtil.colorSearchDS=colorSearchDS},isc.A.showSkinPaletteTools=function isc_c_SkinUtil_showSkinPaletteTools(_1){if(_1||!isc.Canvas.$1937)isc.Canvas.getSkinColors();if(isc.SkinUtil.$1938==null){isc.SkinUtil.$1938=isc.Window.create(isc.SkinUtil.skinColorWindowDefaults)}
var _2=isc.SkinUtil.$1938;_2.setTitle("Palette Tools - "+isc.getCurrentSkinName());_2.show();return _2},isc.A.getClosestColors=function isc_c_SkinUtil_getClosestColors(_1,_2){var _3=isc.SkinUtil,_4=_3.colorSearchDS,_5=_4.cacheData,_6=[];if(!_2)_2=10;for(var i=0;i<_5.length;i++){var _8=_5[i].current;if(_1==_8)continue;var _9=_3.colorDistance(_1,_8);if(_9<=_2){_6.add(_5[i])}}
return _6},isc.A.colorDistance=function isc_c_SkinUtil_colorDistance(_1,_2){var _3=isc.SkinUtil.getSkinColor(_1);var _4=isc.SkinUtil.getSkinColor(_2);var _5=(_3.red+_4.red)/2;var r=_3.red-_4.red;var g=_3.green-_4.green;var b=_3.blue-_4.blue;return Math.sqrt((((512+_5)*r*r)>>8)+4*g*g+(((767-_5)*b*b)>>8))},isc.A.getContrastYIQ=function isc_c_SkinUtil_getContrastYIQ(_1){var r=parseInt(_1.substr(0,2),16);var g=parseInt(_1.substr(2,2),16);var b=parseInt(_1.substr(4,2),16);var _5=((r*299)+(g*587)+(b*114))/1000;return(_5>=128)?'black':'white'});isc.B._maxIndex=isc.C+7;isc.defineClass("SkinColorPalette","Canvas");isc.A=isc.SkinColorPalette.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.overflow="visible";isc.A.titleLabelDefaults={_constructor:"Canvas",autoDraw:true,autoSize:true,wrap:false,height:20,overflow:"visible"};isc.B.push(isc.A.initWidget=function isc_SkinColorPalette_initWidget(){this.Super("initWidget",arguments);this.addAutoChild("titleLabel");this.addChild(this.titleLabel);if(this.title)this.titleLabel.setContents(this.title);this.titleLabel.redraw();this.drawColors()},isc.A.selectColor=function isc_SkinColorPalette_selectColor(_1){var _2=null;if(this.selectedCanvas){this.selectedCanvas.setProperty("border","2px solid "+this.selectedCanvas.color)}
for(var i=0;i<this.children.length;i++){if(this.children[i].isColorCanvas&&this.children[i].color==_1){this.selectedCanvas=this.children[i];this.selectedCanvas.setProperty("border","2px solid white");break}}},isc.A.drawColors=function isc_SkinColorPalette_drawColors(_1){if(this.children){for(var i=this.children.length-1;i>0;i--){var _3=this.children[i];if(_3.isColorCanvas){this.removeChild(_3);_3.destroy();_3=null}}}
_1=_1||this.colors||isc.Canvas.$1937.findAll({isSkinCSS:true});_1.setSort([{property:"original",direction:"ascending"}]);var _4=this.titleLabel.getHeight();var _5=0,_6=0;var _7=0,_8=0;for(var i=0;i<_1.length;i++){if(_8==10){_8=0;_7++}
var _3=this.getColorCanvas(_1[i].original);this.addChild(_3)
_3.moveTo(_8*20,_4+(_7*20));_8++}},isc.A.getColorCanvas=function isc_SkinColorPalette_getColorCanvas(_1){return isc.Canvas.create({width:20,height:20,color:_1,isColorCanvas:true,autoDraw:false,border:"2px solid "+_1,backgroundColor:_1,prompt:_1})});isc.B._maxIndex=isc.C+4;isc.defineClass("ColorConverter","VLayout");isc.A=isc.ColorConverter.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.width=270;isc.A.height=180;isc.A.overflow="auto";isc.A.autoDraw=true;isc.A.formDefaults={_constructor:"DynamicForm",colWidths:[100,150],fields:[{name:"inputColor",width:"*",changed:function(_1,_2,_3){_1.creator.setColor(_3)}},{name:"changeTo",editorType:"ColorItem",title:"Change To",width:"*",changed:function(_1,_2,_3){_1.creator.changeColor(_1.getValue("Hex"),_3)}},{name:"Hex",editorType:"ColorItem",width:"*"},{name:"Name",width:"*"},{name:"Rgb",width:"*"},{name:"Hsl",width:"*"},{name:"Hwb",width:"*"},{name:"Cmyk",width:"*"}]};isc.B.push(isc.A.initWidget=function isc_ColorConverter_initWidget(){this.Super("initWidget",arguments);this.addAutoChild("form");this.addMember(this.form);if(this.color)this.setColor(this.color)},isc.A.setColor=function isc_ColorConverter_setColor(_1){this.inputColor=_1;this.color=isc.SkinUtil.getSkinColor(_1);this.updateForm()},isc.A.changeColor=function isc_ColorConverter_changeColor(_1,_2){var _3={};_3[_1]=_2;isc.Canvas.changeSkinColors(_3);this.creator.changeConfigColor(_1,_2)},isc.A.updateForm=function isc_ColorConverter_updateForm(){var c=this.color;if(c.valid){var _2=c.toHexString();var _3=isc.Canvas.$1937.find("original",_2);this.form.setValues({"inputColor":this.inputColor,"Hex":_2,"changeTo":_3?_3.current:_2,"Name":c.toName(),"Rgb":c.toRgbString(),"Hsl":c.toHslString(),"Hwb":c.toHwbString(),"Cmyk":c.toCmykString()})}else{this.form.setValues({"inputColor":this.inputColor})}});isc.B._maxIndex=isc.C+4;isc.defineClass("SkinPaletteTools","HLayout");isc.A=isc.SkinPaletteTools.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.membersMargin=5;isc.A.layoutMargin=5;isc.A.leftPaneDefaults={_constructor:"VLayout",membersMargin:5};isc.A.gridDefaults={_constructor:"ListGrid",height:400,headerHeight:56,dataSource:"colorSearchDS",autoFetchData:true,autoFitData:"horizontal",autoFitFieldWidths:true,autoFitWidthApproach:"both",getCellCSSText:function(_1,_2,_3){return"background-color: "+_1.original+";"},canHover:true,showHover:true,cellHoverHTML:function(_1,_2,_3,_4){if(_3>2)return _1[this.creator.colorArrays[_3-3]].join("\n");return _4},fields:[{name:"original",title:"Original",width:100},{name:"isSkinCSS",type:"boolean",title:"From Skin"},{name:"mostlyType",editorType:"SelectItem",valueMap:["","Backgrounds","Fonts","Borders"]},{name:"backgroundCount",title:"Background"},{name:"colorCount",title:"Text"},{name:"borderCount",title:"Border"},{name:"borderTopCount",title:"Top"},{name:"borderLeftCount",title:"Left"},{name:"borderBottomCount",title:"Bottom"},{name:"borderRightCount",title:"Right"},{name:"background",hidden:true},{name:"color",hidden:true},{name:"border",hidden:true},{name:"borderTop",hidden:true},{name:"borderLeft",hidden:true},{name:"borderBottom",hidden:true},{name:"borderRight",hidden:true},{name:"red",type:"integer",hidden:true},{name:"green",type:"integer",hidden:true},{name:"blue",type:"integer",hidden:true},{"name":"lab",hidden:true}],headerSpans:[{fields:["original","isSkinCSS","mostlyType","backgroundCount","colorCount"],title:"Color"},{fields:["borderCount","borderTopCount","borderLeftCount","borderBottomCount","borderRightCount"],title:"Borders"}],recordClick:function(_1,_2,_3,_4,_5,_6,_7){_1.creator.converter.setColor(_2.original)},showFilterEditor:true,canGroupby:true,canMultiGroup:true,allowFilterExpressions:true,dataArrived:function(){this.creator.rowCountLabel.setContents(this.data.getLength()+" filtered rows...")},initialCriteria:{_constructor:"AdvancedCriteria",operator:"and",criteria:[{fieldName:"isSkinCSS",operator:"equals",value:true}]},initialSort:[{property:"lab",direction:"ascending"}]};isc.A.buttonBarDefaults={_constructor:"HLayout",overflow:"visible",membersMargin:5,height:40};isc.A.loadConfigButtonDefaults={_constructor:"IButton",title:"Load Config",autoFit:true,click:function(){this.creator.loadConfig()}};isc.A.saveConfigButtonDefaults={_constructor:"IButton",title:"Save Config",autoFit:true,click:function(){this.creator.saveConfig()}};isc.A.allButtonDefaults={_constructor:"IButton",title:"All",autoFit:true,click:function(){this.creator.grid.setCriteria({})}};isc.A.only1RefButtonDefaults={_constructor:"IButton",title:"Only 1 ref",autoFit:true,click:function(){this.creator.grid.setCriteria(this.creator.getSearchCrit("lessThan",2))}};isc.A.lessThan5RefsButtonDefaults={_constructor:"IButton",title:"Less than 5 refs",autoFit:true,click:function(){this.creator.grid.setCriteria(this.creator.getSearchCrit("lessThan",5))}};isc.A.rowCountLabelDefaults={_constructor:"Label",autoFit:true,wrap:false,color:"white"};isc.A.rightPaneDefaults={_constructor:"VLayout",membersMargin:5,height:"100%"};isc.A.paletteDefaults={_constructor:"SkinColorPalette",title:"Palette Colors"};isc.A.closestPaletteDefaults={_constructor:"SkinColorPalette",title:"Closest Colors"};isc.A.converterDefaults={_constructor:"ColorConverter",setColor:function(_1){this.Super("setColor",arguments);this.creator.converterColorChanged(this.inputColor)}};isc.A.repo=null;isc.B.push(isc.A.initWidget=function isc_SkinPaletteTools_initWidget(){this.Super("initWidget",arguments);this.colorArrays=isc.SkinUtil.colorArrays;this.config={colors:[],fonts:[]};this.createDataSources();this.addAutoChild("leftPane");this.addMember(this.leftPane);this.addAutoChild("grid");this.leftPane.addMember(this.grid);this.addAutoChild("buttonBar");this.leftPane.addMember(this.buttonBar,0);this.addAutoChildren(["loadConfigButton","saveConfigButton","allButton","only1RefButton","lessThan5RefsButton","rowCountLabel"]);this.buttonBar.addMembers([this.loadConfigButton,this.saveConfigButton,this.allButton,this.only1RefButton,this.lessThan5RefsButton,this.rowCountLabel])
this.addAutoChild("rightPane")
this.addMember(this.rightPane);this.addAutoChild("converter");this.rightPane.addMember(this.converter);this.addAutoChild("palette",{title:"Palette Colors"});this.rightPane.addMember(this.palette);this.addAutoChild("closestPalette",{title:"Closest Colors",colors:[]});this.rightPane.addMember(this.closestPalette)},isc.A.converterColorChanged=function isc_SkinPaletteTools_converterColorChanged(_1){this.palette.selectColor(_1);this.closestPalette.drawColors(isc.SkinUtil.getClosestColors(_1,50))},isc.A.getSearchCrit=function isc_SkinPaletteTools_getSearchCrit(_1,_2){var _3={_constructor:"AdvancedCriteria",operator:"and",criteria:[]};for(var i=0;i<this.colorArrays.length;i++){_3.criteria.add({fieldName:this.colorArrays[i]+"Count",operator:_1,value:_2})}
return _3},isc.A.createDataSources=function isc_SkinPaletteTools_createDataSources(){isc.SkinUtil.createDataSources();this.colorSearchDS=isc.SkinUtil.colorSearchDS},isc.A.getRepo=function isc_SkinPaletteTools_getRepo(){if(!this.repo)this.repo=isc.ViewRepo.create();return this.repo},isc.A.loadConfig=function isc_SkinPaletteTools_loadConfig(_1,_2){var _3=_1;if(!_2&&this.configChanged){isc.ask("Config has been changed - proceed anyway (changes will be lost)?",function(_5){if(_5!=null&&_5==true){this.loadConfig(_3,true)}});return}
var _4=this;this.loadFile("/isomorphic/skins/$1939/tools/skinColors/skin.config",function(_5){_4.configLoaded(_5,_3)})},isc.A.configLoaded=function isc_SkinPaletteTools_configLoaded(_1,_2){this.config=isc.JSON.decode(_1);isc.logWarn(isc.echoFull(_1));var _3=this.config.colors.length,_4={};if(_3>0){for(var i=0;i<_3;i++){var _6=this.config.colors[i];_4[_6.original]=_6.current}
isc.Canvas.changeSkinColors(_4)}
if(_2)this.fireCallback(_2,"data",[_1])},isc.A.loadFile=function isc_SkinPaletteTools_loadFile(_1,_2){var _3=this.getRepo();var _4=_2;_3.loadObject({criteria:{path:_1}},function(_5,_6,_2){_4(_5)})},isc.A.saveFile=function isc_SkinPaletteTools_saveFile(_1,_2,_3){var _4=this.getRepo();var _5=_3;var _6=this;var _7=isc.DS.get("Filesystem");var _8={path:_2,name:_2,fileName:_2,contents:isc.JSON.encode(_1)};_7.updateData(_8,function(_9){_6.saveObjectReply(_9,_5,_8)})},isc.A.saveObjectReply=function isc_SkinPaletteTools_saveObjectReply(_1,_2,_3){this.configChanged=false;if(_2)this.fireCallback(_2,"success",[true])},isc.A.saveConfig=function isc_SkinPaletteTools_saveConfig(_1,_2){_1=_1||this.config
this.saveFile(_1,"/isomorphic/skins/$1939/tools/skinColors/skin.config",function(_3){isc.logWarn(_3)})},isc.A.changeConfigColor=function isc_SkinPaletteTools_changeConfigColor(_1,_2,_3){var _4=this.config.colors.find("original",_1);if(_4){_4.current=_2}else{if(!_3)_3={background:true,border:true,color:true}
_4={original:_1,current:_2,types:_3};this.config.colors.add(_4)}
this.configChanged=true});isc.B._maxIndex=isc.C+12;isc.showPaletteTools=isc.SkinUtil.showSkinPaletteTools;isc.defineClass("SkinFunc");isc.A=isc.SkinFunc;isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.repo=null;isc.A.seriesSassPath="/isomorphic/skins/$1939/FlatSeries/sass/";isc.A.skinsFolderPath="/isomorphic/skins/";isc.A.currentSeries=null;isc.A.shouldImportSkinVars=false;isc.A.transformTypes={"none":"None","lighten":"Lighten","darken":"Darken","saturate":"Saturate","desaturate":"Desaturate","custom":"Custom"};isc.B.push(isc.A.loadFile=function isc_c_SkinFunc_loadFile(_1,_2){if(!_1){isc.say("loadFile called with no file-path");return null}
var _3=_2;if(!isc.SkinFunc.repo){isc.SkinFunc.repo=isc.ViewRepo.create({dataSource:isc.DS.get("Filesystem")})}
isc.SkinFunc.repo.loadObject({criteria:{path:_1}},function(_4,_5,_2){_3(_4)});return},isc.A.saveFile=function isc_c_SkinFunc_saveFile(_1,_2,_3){if(!_2){isc.say("saveFile called with no file-path");return null}
var _4=_3;var _5=(isc.isA.String(_1)?_1:isc.JSON.encode(_1,{prettyPrint:false}));var _6=isc.DS.get("Filesystem");var _7={path:_2,name:_2,fileName:_2,contents:_5};_6.updateData(_7,function(_8){if(_4)_4(_7)})},isc.A.init=function isc_c_SkinFunc_init(){var _1=isc.SkinFunc;_1.createDataSources()},isc.A.createDataSources=function isc_c_SkinFunc_createDataSources(){isc.SkinFunc.storeVariableGroups();var _1=isc.SkinFunc;_1.skinOutputGroupsDS=isc.DataSource.create({ID:"skinOutputGroupsDS",clientOnly:true,fields:[{name:"name",type:"text",primaryKey:true},{name:"parentId",type:"text"},{name:"index",type:"integer"},{name:"title",type:"text"},{name:"comment",type:"text"}],cacheData:[{index:0,name:"global",title:"Global Settings",comment:"Flags and other settings that have skin-wide effects"},{index:10,name:"font",title:"Fonts",comment:"Variables for fonts"},{index:15,name:"colors",title:"Standard Colors",comment:"Variables for Colors"},{index:20,name:"standard",title:"Standard Settings",comment:"Base settings that are derived by more localized variables"},{index:40,name:"button",title:"Buttons",comment:"Variables for Button styles"},{index:45,name:"window",title:"Windows and Dialogs",comment:"Variables used for styling Windows and Dialogs"},{index:50,name:"menu",title:"Menus and MenuButtons",comment:"Variables for styling Menus and MenuButtons"},{index:60,name:"tab",title:"Tabs",comment:"Variables for Tab styles"},{index:70,name:"headerButton",title:"HeaderButtons",comment:"Variables for HeaderButton styles"},{index:80,name:"sectionStack",title:"SectionStacks",comment:"Variables for SectionStack styles"},{index:90,name:"navigationBar",title:"Navigation Bar",comment:"Variables for Navigation Bar styles"},{index:100,name:"listGrid",title:"ListGrids",comment:"Variables for ListGrid styles"},{index:105,name:"treeGrid",title:"Trees",comment:"Variables for TreeGrid styles"},{index:110,name:"cube",title:"CubeGrid",comment:"Variables for CubeGrid styles"},{index:115,name:"pickList",title:"PickLists",comment:"Variables for PickList styles"},{index:120,name:"tileGrid",title:"TileGrids",comment:"Variables for TileGrid styles"},{index:130,name:"splitBar",title:"SplitBars",comment:"Variables used for styling SplitBars"},{index:140,name:"richTextEditor",title:"RichTextEditors",comment:"Variables used for styling RichTextEditors"},{index:150,name:"toolStrip",title:"ToolStrips",comment:"Variables used for styling ToolStrips"},{index:160,name:"ribbon",title:"Ribbons and IconButtons",comment:"Variables used for styling Ribbons and IconButtons"},{index:170,name:"scrollBar",title:"Scrollbars",comment:"Variables used for styling Scrollbars"},{index:180,name:"form",title:"DynamicForms and FormItems",comment:"Variables used for styling DynamicForms and the various FormItem types"},{index:185,name:"detailViewer",title:"DetailViewers",comment:"Variables used for styling DetailViewers"},{index:190,name:"slider",title:"Sliders",comment:"Variables used for styling Sliders"},{index:200,name:"dateChooser",title:"DateChoosers",comment:"Variables used for styling DateChoosers"},{index:210,name:"colorPicker",title:"ColorPickers",comment:"Variables used for styling ColorPickers"},{index:220,name:"calendar",title:"Calendars",comment:"Variables used for styling Calendars"},{index:300,name:"filterBuilder",title:"FilterBuilder",comment:"Settings that affect FilterBuilder widgets"},{index:310,name:"charts",title:"Charting",comment:"Settings that affect Charts"},{index:320,name:"hoverCanvas",title:"Hover Canvas",comment:"Settings that affect the hover canvas"},{index:990,name:"misc",title:"Miscellaneous",comment:"Miscellaneous variables"},{index:1990,name:"showcase",title:"Showcase",comment:"Styles for the Isomorphic Showcases"}]});_1.skinVariableDS=isc.DataSource.create({ID:"skinVariablesDS",clientOnly:true,fields:[{name:"id",type:"integer",primaryKey:true,width:80},{name:"name",type:"text",title:"Name"},{name:"usageType",type:"text",title:"Usage Type"},{name:"superKey",type:"text",title:"Super Key"},{name:"derivesFrom",type:"text",title:"Derives From"},{name:"transform",type:"text",title:"Transform"},{name:"category",type:"text",title:"Category"},{name:"value",type:"text",title:"Value"},{name:"defaultValue",type:"text",title:"Default Value"},{name:"valueType",type:"text",width:80,title:"Value Type"},{name:"valueSubType",type:"text",width:80,title:"Value Sub-type"},{name:"usedBy",type:"text",multiple:true,title:"Used By"},{name:"keywords",type:"text",multiple:true,title:"Keywords"},{name:"usedInSeriesFile",type:"boolean",hidden:true,title:"Used In Series"},{name:"usedInThemeFile",type:"boolean",hidden:true,title:"Used in Theme"},{name:"exclude",type:"boolean",title:"Exclude"},{name:"flagAsImportant",type:"boolean",title:"Important"},{name:"outputIndex",type:"integer",title:"Output Index"},{name:"outputGroup",type:"text",title:"Group"}]})},isc.A.getVariablesDS=function isc_c_SkinFunc_getVariablesDS(_1,_2){var _3=isc.DataSource.create({ID:_1,clientOnly:true,inheritsFrom:"skinVariables"});if(_2){try{if(isc.isA.String(_2)){var d=eval(_2);_2=d}}catch(e){}
_3.cacheData=_2}
return _3},isc.A.editVariableName=function isc_c_SkinFunc_editVariableName(_1,_2,_3){_2=_2||isc.SkinFunc.currentSeries;var _4=(isc.isAn.Object(_1)?_1.name:_1);if(_4.startsWith("$"))_4=_4.substring(1);isc.askForValue("Rename '"+_4+"' to:",function(_5){if(!_5){isc.say("No value entered");return}
_5=_5.trim();if(!_5.startsWith("$"))_5="$"+_5;isc.SkinFunc.changeVariableName(_2,_1,_5);if(_3)_3.invalidateCache()},{defaultValue:_4,width:400})},isc.A.changeVariableName=function isc_c_SkinFunc_changeVariableName(_1,_2,_3){_1.changeVariableName(_2,_3)},isc.A.getThemeOutputPath=function isc_c_SkinFunc_getThemeOutputPath(_1,_2){if(_2)return"/tools/skinTools/variableEditor/";return isc.SkinFunc.skinsFolderPath+_1+"/$1939/sass/"},isc.A.getOutputPath=function isc_c_SkinFunc_getOutputPath(_1){if(_1)return"/tools/skinTools/variableEditor/";return isc.SkinFunc.seriesSassPath},isc.A.loadSeries=function isc_c_SkinFunc_loadSeries(_1,_2,_3){var _4=isc.SkinSeries.create({ID:"series_"+_1,seriesName:_1,themeNames:_2,$76b:_3});_4.loadSeries(_1,_2)},isc.A.readSection=function isc_c_SkinFunc_readSection(_1,_2){if(!_2)return"";var _3="//>"+_1,_4=_2.indexOf(_3)+_3.length,_5=_2.indexOf("//<"+_1);return _2.substring(_4,_5)},isc.A.getSectionContent=function isc_c_SkinFunc_getSectionContent(_1,_2){_2=_2||"";var _3="//>"+_1+"\n"+_2.trim()+"\n//<"+_1+"\n";isc.logWarn("writing section "+_1+"\n\n"+_3);return _3},isc.A.remapOutputIndices=function isc_c_SkinFunc_remapOutputIndices(){var _1=isc.SkinFunc.variableGroupCache;var _2=[];for(var i=0;i<_1.length;i++){if(_1[i].parentId==null)_2.add(_1[i])}
_2.setSort([{property:"index",direction:"ascending"}]);skinVariables.fetchData({},function(_9,_10){for(var i=0;i<_2.length;i++){var _4=_2[i];var _5=_1.findAll("parentId",_4.name)||[];_5.setSort([{property:"index",direction:"ascending"}]);if(_5.length>0){for(var j=0;j<_5.length;j++){var _7=_10.findAll({outputGroup:_5[j].name})||[];_7.setSort([{property:"outputIndex",direction:"ascending"}]);for(var i=0;i<_7.getLength();i++){var _8=_7.get(i);_8.outputIndex=i*10;skinVariables.updateData(_8)}}}}})},isc.A.storeVariableGroups=function isc_c_SkinFunc_storeVariableGroups(){skinVariableGroups.fetchData({},function(_1,_2){isc.SkinFunc.variableGroupCache=_2})},isc.A.getVariableScript=function isc_c_SkinFunc_getVariableScript(_1,_2){var _3=(isc.isA.ResultSet(_1)?_1.allRows:_1),_4=[];var _5=isc.SkinFunc.variableGroupCache;var _6=[];for(var i=0;i<_5.length;i++){if(_5[i].parentId==null)_6.add(_5[i])}
_6.setSort([{property:"index",direction:"ascending"}]);for(var i=0;i<_6.length;i++){var _8=_6[i];var _9=_5.findAll("parentId",_8.name)||[];_9.setSort([{property:"index",direction:"ascending"}]);if(_9.length>0){_4.add("\n// ==== "+_8.title+(_8.comment?" - "+_8.comment:""));for(var j=0;j<_9.length;j++){var _11=_3.findAll({outputGroup:_9[j].name})||[];_11.setSort([{property:"outputIndex",direction:"ascending"}]);if(_11.length>0){if(_9[j].comment)_4.add("// "+_9[j].comment);else if(_9[j].title){_4.add("// "+_9[j].title)}
for(var k=0;k<_11.getLength();k++){var _13=_11.get(k);if(!_2.includeAll&&_13.exclude)continue;var _14=null;if(_2.exportFieldName){if(_13[_2.exportFieldName])_14=_13[_2.exportFieldName]}
if(_14==null)_14=(_2.returnDefaults?_13.defaultValue:_13.value);if(_14==null)_14=_13.value;_14=_14.replaceAll("!default").trim();if(_14.endsWith(";"))_14=_14.substring(0,_14.length-1).trim();var _15=_13.name+": "+_14;if(_13.flagAsImportant)_15+=" !important";if(_2.returnDefaults)_15+=" !default";if(!_15.endsWith(";"))_15+=";";_4.add(_15)}}}}}
var _4=_4.join("\n");return _4},isc.A.getExcludedRecords=function isc_c_SkinFunc_getExcludedRecords(_1){_1=_1||isc.SkinFunc.currentSeries.variablesRS.allRows;var _2=",",_3=0;for(var i=0;i<_1.length;i++){if(_1[i].exclude){_3++;_2+=","+_1[i].name}}
_2=_2.replaceAll(",,","");isc.logWarn("Returning "+_3+" excluded skin-attributes:\n\n"+isc.echoFull(_2))},isc.A.importSkinVars=function isc_c_SkinFunc_importSkinVars(_1){var _2=[],_3=-1,_4,_5=-1,_6,_7;var _8=isc.SkinFunc,_9=0;var _10=_1.themeVariableData;while(2>1){_3=_10.indexOf("$",_5+1);if(_3==-1){break}
_4=_10.indexOf(":",_3);_5=_10.indexOf(";",_4+1)
var _11={id:_9++,name:_6,value:_7,usedBy:[],name:_10.substring(_3,_4),defaultValue:_10.substring(_4+1,_5).replaceAll("\n").trim()};if(_11.defaultValue.contains("!important")){_11.flagAsImportant=true;_11.defaultValue=_11.replaceAll("!important")}else{_11.flagAsImportant=false}
_11.defaultValue=_11.defaultValue.trim();_11.value=_11.defaultValue;_11.keywords=_11.name.substring(1).split("_");_11.usageType=_11.keywords?_11.keywords[0]:"none";_2.add(_11)}
var _12=_8.currentSeries,_13=_12.baseFileContent,_14=_12.themes[0].themeVariableData;for(var i=0;i<_2.length;i++){var _16=_2[i];for(var j=0;j<_2.length;j++){if(_2[j].value==_16.name){_2[j].superKey=!_2[j].superKey?"":_2[j].superKey+":";_2[j].superKey+=_16.name}else if(_2[j].value.contains(_16.name)){_16.usedBy.add(_2[j].name)}}
if(_13.contains(_16.name+";")||_13.contains(_16.name+",")||_13.contains(_16.name+" ")||_13.contains(_16.name+")")){_16.usedInSeriesFile=true}else _16.usedInSeriesFile=false;if(_14.contains(_16.name+";")||_14.contains(_16.name+",")||_14.contains(_16.name+" ")||_14.contains(_16.name+")")){_16.usedInThemeFile=true}else _16.usedInThemeFile=false;if(!_16.usedInSeriesFile&&!_16.usedInThemeFile){_16.exclude=(_16.name.endsWith("$194a")||_16.name.endsWith("$194b")||_16.name.endsWith("$194c"))}else{_16.exclude=false}
if(_16.category)continue;if(_16.name.endsWith("$194d")){_16.category="color";_16.valueType="color";_16.valueSubType="background"}else if(_16.name.endsWith("$194e")){_16.category="color";_16.valueType="color";_16.valueSubType="border"}else if(_16.name.endsWith("$194f")){_16.category="color";_16.valueType="color";_16.valueSubType="text"}else if(_16.name.endsWith("$194a")){_16.category="color";_16.valueType="color";_16.valueSubType="hue"}else if(_16.name.endsWith("$194b")){_16.category="color";_16.valueType="color";_16.valueSubType="saturation"}else if(_16.name.endsWith("$194c")){_16.category="color";_16.valueType="color";_16.valueSubType="lightness"}else if(_16.name.contains("font_size")){_16.category="font";_16.valueType="font";_16.valueSubType="size"}else if(_16.name.contains("font")){_16.category="font";_16.valueType="font";_16.valueSubType="font"}}
return _2},isc.A.transformColor=function isc_c_SkinFunc_transformColor(_1,_2,_3){var _4=isc.SkinUtil;_1=_4.getSkinColor(_1);if(_2=="custom"){}else if(_2!="none"){if(_1[_2])_1[_2](_3)}
return _4.toHexString(_1)},isc.A.updateVariableMetaData=function isc_c_SkinFunc_updateVariableMetaData(_1,_2){var _3=skinVariables,_4=_1.variablesRS.allRows,_5=_1.baseFileContent;var _6=0,_7=0;_2=_2||{};if(_2.updateSuperKeys==null)_2.updateSuperKeys=false;if(_2.updateUsageAndExclude==null)_2.updateUsageAndExclude=false;if(_2.removeUsedBy==null)_2.removeUsedBy=true;for(var i=0;i<_4.length;i++){var _9=isc.addProperties({},_4[i]);if(_2.updateSuperKeys){delete _9.derivesFrom;delete _9.transform;if(_9.superKey==null){if(_9.value&&_9.value.startsWith("$")){if(!_9.value.contains(" ")&&_9.value.contains(",")){_9.superKey=_9.value}}}else if(_9.superKey.contains(" ")||_9.superKey.contains(",")){delete _9.superKey}
if(_9.superKey&&!_9.derivesFrom){_9.derivesFrom=_9.superKey;_9.transform="none"}}
if(_2.updateUsageAndExclude){var _10=_9.usedInSeriesFile,_11=_9.usedInThemeFile;if(_5.contains(_9.name+";")||_5.contains(_9.name+",")||_5.contains(_9.name+" ")||_5.contains(_9.name+")")){_9.usedInSeriesFile=true}else _9.usedInSeriesFile=false;var _12=false;for(var k=0;k<_1.themes.length;k++){var _14=_1.themes[k].themeVariableData;if(_14.contains(_9.name+";")||_14.contains(_9.name+",")||_14.contains(_9.name+" ")||_14.contains(_9.name+")")){_12=true;break}
var _15=_1.themes[k].customFileContent;if(_15.contains(_9.name+";")||_15.contains(_9.name+",")||_15.contains(_9.name+" ")||_15.contains(_9.name+")")){_12=true;break}}
_9.usedInThemeFile=_12;if(_10!=_9.usedInSeriesFile||_11!=_9.usedInThemeFile){}
if(!_9.usedInSeriesFile&&!_9.usedInThemeFile){_6++
if(!_9.exclude)isc.logWarn("newly excluding record... "+_9.name);_9.exclude=true}else if(_9.usedInSeriesFile||_9.usedInThemeFile){_7++;if(_9.exclude)isc.logWarn("newly including record... "+_9.name);_9.exclude=false}
continue;if(!_9.usedInSeriesFile&&!_9.usedInThemeFile){_9.exclude=(_9.name.endsWith("$194a")||_9.name.endsWith("$194b")||_9.name.endsWith("$194c"))}else{_9.exclude=false}}
if(_2.removeUsedBy){delete _9.usedBy}
_3.updateData(_9)}},isc.A.exportToNewDSFormat=function isc_c_SkinFunc_exportToNewDSFormat(_1){var _2=_1.cacheData,_3=skinVariables,_4=0;_2.setSort({property:"id",direction:"ascending"});for(var i=0;i<_2.length;i++){var _6=isc.addProperties({},_2[i]);if(_6.exclude==true)continue;if(_6.exclude==null)_6.exclude=false;if(_6.superKey==_6.derivesFrom)delete _6.superKey;delete _6.usedInThemeFile;delete _6.usedBy;_6.id=++_4;_3.addData(_6)}});isc.B._maxIndex=isc.C+20;isc.defineClass("SkinVariable");isc.A=isc.SkinVariable;isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.B.push(isc.A.fromRecordArray=function isc_c_SkinVariable_fromRecordArray(_1){var a=[];for(var i=0;i<_1.length;i++){a.add(isc.SkinVariable.create(_1[i]))}
return a});isc.B._maxIndex=isc.C+1;isc.A=isc.SkinVariable.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.id=null;isc.A.name=null;isc.A.usageType=null;isc.A.superKey=null;isc.A.category=null;isc.A.value=null;isc.A.defaultValue=null;isc.A.valueType=null;isc.A.valueSubType=null;isc.A.usedBy=null;isc.A.keywords=null;isc.A.usedInSeriesFile=null;isc.A.usedInThemeFile=null;isc.A.exclude=null;isc.A.flagAsImportant=null;isc.B.push(isc.A.init=function isc_SkinVariable_init(){this.Super("init",arguments);if(!this.usedBy)this.usedBy=[];if(!this.keywords)this.keywords=[];if(this.record){this.fromRecord(this.record)}},isc.A.fromRecord=function isc_SkinVariable_fromRecord(_1){isc.addProperties(this,_1)},isc.A.getValue=function isc_SkinVariable_getValue(){if(this.derivesFrom){var _1=isc.SkinFunc,_2=_1.currentSeries.variablesRS.allRows,_3=_2.find("name",this.superKey),_4=_3?isc.SkinVariable.create({record:_3}):null;if(_4)return _4.getValue()}
return this.value});isc.B._maxIndex=isc.C+3;isc.defineClass("SkinSeries");isc.A=isc.SkinSeries.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.seriesName="Flat";isc.A.seriesFilePath="$194g.scss";isc.A.baseFileContent=null;isc.A.seriesDefaultVariableData=null;isc.A.seriesHeaderDocData=null;isc.A.seriesBaseStylesData=null;isc.A.seriesMetadataPath="$194h.scss";isc.A.seriesMetadataContent=null;isc.A.generatorProps={};isc.B.push(isc.A.init=function isc_SkinSeries_init(){this.Super("init",arguments)},isc.A.loadSeries=function isc_SkinSeries_loadSeries(_1,_2,_3){isc.logWarn("Loading '"+this.seriesName+"' Series...");var _4=isc.SkinFunc,_5=_3,_6=this;_1=_1||this.seriesName;_2=_2||this.themeNames;_6.seriesName=_1;_6.seriesFilePath=_4.getOutputPath()+"$194i"+_6.seriesName+".scss";_6.seriesMetadataPath=_4.getOutputPath(true)+"_"+_6.seriesName+"$194j.js";if(_2&&!isc.isAn.Array(_2))_2=[_2];_4.currentSeries=this;skinVariables.fetchData(null,function(_10,_11,_12){var _7=isc.ResultSet.create({dataSource:skinVariables,fetchMode:"local",allRows:_11});_6.variablesRS=_7;_4.loadFile(_6.seriesMetadataPath,function(_11){try{var d=eval(_11)
_11=d}catch(e){}
if(isc.isA.String(_11))_11=isc.JSON.decode(_11);for(var i=0;i<_11.variables.length;i++){if(_11.variables[i].outputSubgroupId==null){_11.variables[i].outputSubgroupId="standard"}}
_6.seriesMetadataContent=_11;_4.loadFile(_6.seriesFilePath,function(_11){_6.parseSeriesFile(_11);if(_6.themeNames&&_6.themeNames.length>0){_6.loadThemes(_6.themeNames,_5)}else{_6.seriesLoaded(_5)}})})})},isc.A.parseSeriesFile=function isc_SkinSeries_parseSeriesFile(_1){this.baseFileContent=_1;this.seriesDefaultVariableData=this.readSection("skin_default_variables");this.seriesHeaderDocData=this.readSection("skin_header_doc");this.seriesBaseStylesData=this.readSection("skin_base_styles")},isc.A.writeSeriesBaseFile=function isc_SkinSeries_writeSeriesBaseFile(_1){this.$195j=_1;this.getDefaultVariableScript(_1,{target:this,methodName:"$195k"})},isc.A.$195k=function isc_SkinSeries__writeSeriesBaseFile(_1){var _2=isc.SkinFunc,_3=this.baseFileContent;var _4=this.$195j||(_2.getOutputPath()+"$194i"+this.seriesName+".scss");var _5=_3.substring(0,_3.indexOf("//>skin_default_variables"));_5+=_1;_5+=_3.substring(_3.indexOf("//<skin_default_variables")+"//<skin_default_variables".length+1,_3.length);_2.saveFile(_5,_4)},isc.A.writeMetadataFile=function isc_SkinSeries_writeMetadataFile(_1){return;var _2=isc.SkinFunc,_3=this;var _4=_1||(_2.getOutputPath(true)+"_"+this.seriesName+"$194j.js");var _5=this.variablesRS.allRows;this.variablesDS.fetchData(null,function(_7,_5){var _6={};_6.seriesName=_3.seriesName;_2.remapOutputIndices(_5);_6.variables=_5;_2.saveFile(_6,_4)})},isc.A.getDefaultVariableScript=function isc_SkinSeries_getDefaultVariableScript(_1,_2){var _3=this;skinVariables.fetchData({},function(_5,_6){var _4=isc.SkinFunc.getVariableScript(_6,isc.addProperties({},_3.generatorProps,{returnDefaults:true}));_4=isc.SkinFunc.getSectionContent("skin_default_variables",_4);if(_2){this.fireCallback(_2,["variableScript"],[_4])}})},isc.A.loadThemes=function isc_SkinSeries_loadThemes(_1,_2){var _3=_2,_4=this;this.themes=[];this.$194k=isc.shallowClone(_1);isc.logWarn("Loading '"+this.seriesName+"' Themes...");for(var i=0;i<_1.length;i++){var _6=_1[i];var _7=isc.SkinTheme.create({ID:"theme_"+_6,series:_4,themeName:_6,themeLoaded:function(){_4.themeLoaded(this,_3)}});this.themes.add(_7);_7.loadTheme(_6)}},isc.A.themeLoaded=function isc_SkinSeries_themeLoaded(_1,_2){isc.logWarn("Theme '"+_1.themeName+"' loaded ("+this.seriesName+" series)");this.$194k.remove(_1.themeName);if(this.$194k.length==0){this.themesLoaded(_2)}},isc.A.themesLoaded=function isc_SkinSeries_themesLoaded(_1){isc.logWarn("All '"+this.seriesName+"' series Themes loaded ("+isc.echoFull(this.themes.getProperty("themeName"))+")");this.seriesLoaded(_1)},isc.A.seriesLoaded=function isc_SkinSeries_seriesLoaded(_1){isc.logWarn("'"+this.seriesName+"' series loaded...");if(this.$76b)this.$76b(this);if(_1)_1(this)},isc.A.replaceVariableNameInValue=function isc_SkinSeries_replaceVariableNameInValue(_1,_2,_3){var _4=""+_3;_4=_4.replaceAll(_1+";",_2+";");_4=_4.replaceAll(_1+",",_2+",");_4=_4.replaceAll(_1+" ",_2+" ");_4=_4.replaceAll(_1+")",_2+")");return _4},isc.A.renameVariables=function isc_SkinSeries_renameVariables(_1,_2){var _3=this.variablesRS.allRows,_4=[];if(!_1.startsWith("$"))_1="$"+_1;for(var i=0;i<_3.length;i++){var _6=isc.addProperties({},_3[i]);if(_6.name.startsWith(_1)){var _7=_6.name,_8=_6.name.replace(_1,_2);this.changeVariableName(_7,_8)}}},isc.A.changeVariableName=function isc_SkinSeries_changeVariableName(_1,_2){var _3=this.variablesRS.allRows,_4=[];for(var i=0;i<_3.length;i++){var _6={};var _7=_3[i];if(_7.name==_1)_6.name=_2;if(_7.derivesFrom==_1)_6.derivesFrom=_2;if(_7.defaultValue==_1)_6.defaultValue=_2;else if(_7.defaultValue&&_7.defaultValue.contains(_1)){_6.defaultValue=this.replaceVariableNameInValue(_1,_2,_7.defaultValue)}
if(_7.value==_1)_6.value=_2;else if(_7.value&&_7.value.contains(_1)){_6.value=this.replaceVariableNameInValue(_1,_2,_7.value)}
if(_6.name||_6.derivesFrom||_6.value||_6.defaultValue){_6.id=_7.id;_4.add(_6)}}
for(var i=0;i<_4.length;i++){skinVariables.updateData(_4[i])}
this.baseFileContent=this.replaceVariableNameInValue(_1,_2,this.baseFileContent);this.seriesBaseStylesData=this.replaceVariableNameInValue(_1,_2,this.seriesBaseStylesData);for(var i=0;i<this.themes.length;i++){var _8=this.themes[i],_3=_8.variablesDS.cacheData;for(var j=0;j<_3.length;j++){var _7=_3[j];if(_7.name==_1)_7.name=_2;if(_7.superKey==_1)_7.superKey=_2;if(_7.derivesFrom==_1)_7.derivesFrom=_2;if(_7.defaultValue==_1)_7.defaultValue=_2;else if(_7.defaultValue&&_7.defaultValue.contains("$")){_7.defaultValue=this.replaceVariableNameInValue(_1,_2,_7.defaultValue)}
if(_7.value==_1)_7.value=_2;else if(_7.value&&_7.value.contains("$")){_7.value=this.replaceVariableNameInValue(_1,_2,_7.value)}}
_8.customFileContent=this.replaceVariableNameInValue(_1,_2,_8.customFileContent)}},isc.A.addSeriesVariable=function isc_SkinSeries_addSeriesVariable(_1){skinVariables.addData(_1)},isc.A.readSection=function isc_SkinSeries_readSection(_1,_2){_2=_2||this.baseFileContent;return isc.SkinFunc.readSection(_1,_2)},isc.A.writeAllMetadata=function isc_SkinSeries_writeAllMetadata(){this.writeMetadataFile();for(var i=0;i<this.themes.length;i++){this.themes[i].writeMetadataFile()}},isc.A.writeAllOther=function isc_SkinSeries_writeAllOther(){this.writeSeriesBaseFile();for(var i=0;i<this.themes.length;i++){this.themes[i].writeThemeFile()}});isc.B._maxIndex=isc.C+18;isc.defineClass("SkinTheme");isc.A=isc.SkinTheme.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.themeName="Tahoe";isc.A.themeFilePath="$194l.scss";isc.A.themeFileContent=null;isc.A.themeFontData=null;isc.A.themeVariableData=null;isc.A.themeCustomFilePath="$194m.scss";isc.A.customFileContent=null;isc.B.push(isc.A.init=function isc_SkinTheme_init(){this.Super("init",arguments)},isc.A.loadTheme=function isc_SkinTheme_loadTheme(_1,_2){var _3=isc.SkinFunc,_4=this;_4.themeName=_1;var _5=_3.getThemeOutputPath(_4.themeName)+"$194n"+_4.themeName;_4.themeFilePath=_5+".scss";_4.themeCustomFilePath=_5+"$194o.scss";var _6=_2;_3.loadFile(_4.themeFilePath,function(_7){_4.parseThemeFile(_7);_3.loadFile(_4.themeCustomFilePath,function(_7){_4.customFileContent=_7;_4.themeLoaded(_6)})})},isc.A.themeLoaded=function isc_SkinTheme_themeLoaded(_1){if(_1)_1()},isc.A.readSection=function isc_SkinTheme_readSection(_1,_2){_2=_2||this.themeFileContent;return isc.SkinFunc.readSection(_1,_2)},isc.A.parseThemeFile=function isc_SkinTheme_parseThemeFile(_1){var _2=[],_3=-1,_4,_5=-1,_6,_7;this.themeFileContent=_1;this.themeHeaderContent=this.readSection("theme_header")
this.themeFontData=this.readSection("theme_fonts");this.themeVariableData=this.readSection("theme_variables");var _8=this.themeVariableData;while(2>1){_3=_8.indexOf("$",_5+1);if(_3==-1){break}
_4=_8.indexOf(":",_3);_5=_8.indexOf(";",_4+1)
var _9={name:_8.substring(_3,_4),value:_8.substring(_4+1,_5).trim()};_2.add(_9)}
var _10=this.series.variablesRS.allRows,_11=[];for(var i=0;i<_10.length;i++){var _13=isc.addProperties({},_10[i]),_14=_2.find("name",_13.name);if(_14)_13.value=_14.value;if(_13.outputSubgroupId==null)_13.outputSubgroupId="standard";_11.add(_13)}
this.variablesDS=isc.SkinFunc.getVariablesDS(this.themeName+"VariablesDS",_11)},isc.A.readMetadataFile=function isc_SkinTheme_readMetadataFile(_1){var _2=isc.SkinFunc,_3=this;var _4=_1||(_2.getOutputPath(true)+"_"+this.themeName+"$194p.js");_2.loadFile(_4,function(_5){_3.themeMetadata=_5;_3.variablesDS=isc.SkinFunc.getVariablesDS(this.themeName+"VariablesDS",_5.variables)})},isc.A.writeMetadataFile=function isc_SkinTheme_writeMetadataFile(_1){var _2=isc.SkinFunc,_3=this;var _4=_1||(_2.getOutputPath(true)+"_"+this.themeName+"$194p.js");this.variablesDS.fetchData(null,function(_6,_7){var _5={};_5.themeName=_3.themeName;_5.variables=_7;_2.saveFile(_5,_4)})},isc.A.writeThemeFile=function isc_SkinTheme_writeThemeFile(_1){var _2=isc.SkinFunc;var _3=_1;if(!_3){_3=_2.getThemeOutputPath(this.themeName)+"$194n"+this.themeName+".scss"}
var _4=_2.getSectionContent("theme_header",this.themeHeaderContent);_4+=_2.getSectionContent("theme_fonts",this.themeFontData)
var _5=this;this.variablesDS.fetchData(null,function(_7,_8){var _6=isc.SkinFunc.getVariableScript(_8,isc.addProperties({},_5.generatorProps,{returnDefaults:false}));_4+=_2.getSectionContent("theme_variables",_6);_2.saveFile(_4,_3)})});isc.B._maxIndex=isc.C+8;isc.defineClass("SkinVariablesGrid","ListGrid");isc.A=isc.SkinVariablesGrid.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A._constructor="ListGrid";isc.A.width="100%";isc.A.height="*";isc.A.showResizesBar=true;isc.A.autoFetchData=true;isc.A.dataFetchMode="local";isc.A.autoSaveEdits=true;isc.A.canEdit=true;isc.A.canGroupBy=true;isc.A.canMultiGroup=true;isc.A.showFilterEditor=true;isc.A.filterOnEnter=true;isc.A.showRowNumbers=true;isc.A.allowFilterExpressions=true;isc.A.showClippedValuesOnHover=true;isc.A.defaultFields=[{name:"name",width:"*"},{name:"value",width:"*"},{name:"category",width:100},{name:"valueType",width:120},{name:"valueSubType",width:120},{name:"flagAsImportant",width:100},{name:"outputGroup",width:150,editorProperties:{valueField:"name",displayField:"title"}},{name:"outputIndex",title:"Index",width:60},{name:"exclude",canToggle:true}];isc.A.initialCriteria={_constructor:"AdvancedCriteria",operator:"and",criteria:[{fieldName:"exclude",operator:"equals",value:false}]};isc.B.push(isc.A.recordClick=function isc_SkinVariablesGrid_recordClick(){this.creator.variableEditor.editRecord(this.getSelectedRecord())},isc.A.recordDoubleClick=function isc_SkinVariablesGrid_recordDoubleClick(){},isc.A.initWidget=function isc_SkinVariablesGrid_initWidget(){this.Super("initWidget",arguments)});isc.B._maxIndex=isc.C+3;isc.defineClass("SkinEditor","VLayout");isc.A=isc.SkinEditor.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.defaultSeriesName="Flat";isc.A.defaultSeriesThemeNames=["Tahoe","Stratus","Obsidian","Cascade","FSE"];isc.A.loadSeriesButtonDefaults={_constructor:"IButton",title:"Load Series",autoFit:true,click:function(){this.creator.loadSeries()}};isc.A.loadSeriesMetadataButtonDefaults={_constructor:"IButton",title:"Load Series Metadata",autoFit:true,click:function(){this.creator.currentSeries.readMetadataFile()}};isc.A.saveSeriesMetadataButtonDefaults={_constructor:"IButton",title:"Save Series Metadata",autoFit:true,click:function(){this.creator.currentSeries.writeMetadataFile()}};isc.A.saveSeriesBaseFileButtonDefaults={_constructor:"IButton",title:"Save Series SCSS file",autoFit:true,click:function(){this.creator.currentSeries.writeSeriesBaseFile()}};isc.A.renameVariableButtonDefaults={_constructor:"IButton",title:"Rename Variable",autoFit:true,click:function(){var _1=this.creator.variablesGrid,_2=_1.getSelectedRecord();if(!_2)return;isc.SkinFunc.editVariableName(_2,null,_1)}};isc.A.buttonLayoutDefaults={_constructor:"HLayout",width:"100%",height:1,layoutMargin:5,membersMargin:5};isc.A.bodyLayoutDefaults={_constructor:"HLayout",width:"100%",height:"100%",layoutMargin:5,membersMargin:5};isc.A.rightLayoutDefaults={_constructor:"VLayout",width:"100%",height:"100%",layoutMargin:5,membersMargin:5};isc.A.gridButtonLayoutDefaults={_constructor:"HLayout",width:"100%",height:1,layoutMargin:5,membersMargin:5};isc.A.viewAllButtonDefaults={_constructor:"IButton",icon:"[SKINIMG]actions/add.png",title:"View All",autoFit:true,autoParent:"gridButtonLayout",click:function(){var _1=this.creator.variablesGrid;_1.clearGroupBy();_1.setSort({property:"name",direction:"ascending"})}};isc.A.viewForOutputButtonDefaults={_constructor:"IButton",icon:"[SKINIMG]actions/sort.png",title:"View for Output",autoFit:true,autoParent:"gridButtonLayout",click:function(){this.creator.gridViewForOutput()}};isc.A.skinVariablesGridDefaults={_constructor:"SkinVariablesGrid",dataSource:"skinVariables"};isc.A.variablesGridDefaults={_constructor:"SkinVariablesGrid"};isc.A.variableEditorDefaults={_constructor:"SkinVariableEditor",width:"100%",height:1,overflow:"visible"};isc.A.skinTreeDefaults={_constructor:"TreeGrid",width:300,height:"100%",showResizeBar:true,dataFetchMode:"local",fields:[{name:"name"}],showOpenIcons:false,showDropIcons:false,showSelectedIcons:true,closedIconSuffix:"",nodeClick:function(_1,_2){this.creator.nodeClicked(_2)}};isc.B.push(isc.A.nodeClicked=function isc_SkinEditor_nodeClicked(_1){if(!_1)return;if(_1.id=="styleTester"){var _2="../colorTester.jsp?skin="+isc.getCurrentSkinName();window.open(_2)}else if(_1.id=="paletteTools"){isc.showPaletteTools(true)}else if(_1.id=="stateEditor"){var _2="./stateEditor.jsp?skin="+isc.getCurrentSkinName();window.open(_2)}
if(_1.hasVariablesDS){this.setVariablesGridDataSource(_1.variablesDS||_1.classObj.variablesDS,_1.classObj.variablesRS)}},isc.A.showNodePane=function isc_SkinEditor_showNodePane(_1){switch(_1.id){case"seriesMetadata":this.setVariablesGridDataSource(this.currentSeries);default:}},isc.A.gridViewForOutput=function isc_SkinEditor_gridViewForOutput(){var _1=this.variablesGrid;_1.setCriteria({exclude:false});_1.groupBy(["outputGroup"]);_1.setSort([{property:"outputIndex",direction:"ascending"}])},isc.A.initWidget=function isc_SkinEditor_initWidget(_1){this.Super("initWidget",arguments);this.initRibbon();this.addAutoChild("bodyLayout");this.addMember(this.bodyLayout);this.addAutoChild("skinTree");this.bodyLayout.addMember(this.skinTree);this.initSkinTree();this.addAutoChild("rightLayout");this.bodyLayout.addMember(this.rightLayout);this.addAutoChild("gridButtonLayout");this.rightLayout.addMember(this.gridButtonLayout);this.addAutoChildren(["viewAllButton","viewForOutputButton"]);this.gridButtonLayout.addMembers([this.viewAllButton,this.viewForOutputButton]);this.addAutoChild("variablesGrid",{dataSource:"skinVariables"});this.rightLayout.addMember(this.variablesGrid);this.addAutoChild("variableEditor",{dataSource:"skinVariables"});this.rightLayout.addMember(this.variableEditor);this.autoLoadSeries=true;if(this.autoLoadSeries){this.loadSeries()}},isc.A.initRibbon=function isc_SkinEditor_initRibbon(){var _1=function(_6,_7,_8){return isc.IconButton.create(isc.addProperties({title:_6,icon:"pieces/16/cube_blue.png",largeIcon:"pieces/48/cube_blue.png",click:_7},_8))};var _2=function(_6,_7,_8){return isc.IconMenuButton.create(isc.addProperties({title:_6,icon:"pieces/16/piece_blue.png",largeIcon:"pieces/48/piece_blue.png",click:_7},_8))}
var _3=[];if(2==1){_3.add(_1("Load Series",function(){var _4=this.seriesUI.defaultSeriesName,_5=this.seriesUI.defaultSeriesThemeNames.duplicate();this.seriesUI.loadSeries(_4,_5)},{seriesUI:this}));_3.add(_1("Read Metadata",function(){this.seriesUI.currentSeries.readAllMetadata()},{seriesUI:this}))}
_3.add(_1("Write Metadata",function(){this.seriesUI.currentSeries.writeAllMetadata()},{seriesUI:this}));_3.add(_1("Write SCSS Files",function(){this.seriesUI.currentSeries.writeAllOther()},{seriesUI:this}));this.seriesRibbonGroup=isc.RibbonGroup.create({title:"Series",numRows:1,colWidths:[40,"*"],controls:_3,autoDraw:false});this.ribbonBar=isc.RibbonBar.create({groupTitleAlign:"center",groupTitleOrientation:"top"});this.ribbonBar.addGroup(this.seriesRibbonGroup,0);this.addMember(this.ribbonBar,0)},isc.A.initSkinTree=function isc_SkinEditor_initSkinTree(){var _1=this.skinTree;var _2=isc.DS.get("variablesDS");_1.setData(isc.Tree.create({modelType:"children",nameProperty:"name",root:{id:"top",name:"Skin Manager",children:[{id:"seriesEditor",name:"Series Editor",children:[]},{id:"utilities",name:"Tools & Utilities",children:[{id:"styleTester",name:"Style Tester",children:[]},{id:"paletteTools",name:"Palette Tools",children:[]},{id:"stateEditor",name:"State Editor",children:[]}]}]}}));_1.getData().openAll()},isc.A.loadSeries=function isc_SkinEditor_loadSeries(_1,_2){_1=_1||this.defaultSeriesName;_2=_2||this.defaultSeriesThemeNames.duplicate();var _3=this;isc.SkinFunc.loadSeries(_1,_2,function(_4){_3.seriesLoaded(_4)})},isc.A.setVariablesGridDataSource=function isc_SkinEditor_setVariablesGridDataSource(_1,_2){this.variablesGrid.setDataSource(_1,this.variablesGrid.getFields());this.variablesGrid.setData(_2);this.variableEditor.setDataSource(_1)},isc.A.seriesLoaded=function isc_SkinEditor_seriesLoaded(_1){this.currentSeries=_1;var _2=this.skinTree.getData(),_3=_2.find("id","seriesEditor");var _4=_2.add({id:"_series_"+_1.seriesName,name:_1.seriesName+" Series",classObj:_1},_3);var _5=_2.add({id:_1.seriesName+"MetadataFile",name:"Skin Variables",hasVariablesDS:true,classObj:_1},_4);var _6=_2.add({id:_1.seriesName+"BaseFile",name:"Base SCSS File",classObj:_1},_4);var _7=_2.add({id:_1.seriesName+"SeriesThemes",name:"Themes",children:[]},_4);for(var i=0;i<_1.themes.length;i++){var _9=_1.themes[i],_10={};_10.id="_theme_"+_9.themeName;_10.name=_9.themeName;_10.hasVariablesDS=true
_10.classObj=_9;_10.children=[{id:"_theme_file_"+_10.name,name:"Theme SCSS File",classObj:_9},{id:"_theme_variables_"+_10.name,name:"Theme Variables",hasVariablesDS:true,classObj:_9},{id:"_theme_custom_"+_10.name,name:"Custom Styles",classObj:_9},{id:"_theme_showcase_"+_10.name,name:"Showcase Styles",classObj:_9},{id:"_theme_fonts_"+_10.name,name:"Theme Fonts",classObj:_9}];_2.add(_10,_7)}
_2.openFolders([_3,_4,_7]);this.skinTree.selectRecord(_5);this.nodeClicked(_5);this.delayCall("gridViewForOutput")});isc.B._maxIndex=isc.C+9;isc.SkinFunc.editSkinVariable=function(_1,_2){var _3=isc.SkinVariableEditor.create({dataSource:_2});isc.Window.create({width:"80%",height:"80%",backgroundColor:"white",title:"Edit Skin Variable",children:[_3],autoCenter:true});_3.editRecord(_1)}
isc.defineClass("SkinVariableEditor","VLayout");isc.A=isc.SkinVariableEditor.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.membersMargin=10;isc.A.layoutMargin=10;isc.A.buttonLayoutDefaults={_constructor:"HLayout",width:"100%",height:1,membersMargin:10};isc.A.addButtonDefaults={_constructor:"IButton",icon:"[SKINIMG]actions/add.png",title:"Add Variable",click:function(){this.creator.addRecord()}};isc.A.editButtonDefaults={_constructor:"IButton",icon:"[SKINIMG]actions/edit.png",title:"Edit",click:function(){this.creator.disableUI(false)}};isc.A.saveButtonDefaults={_constructor:"IButton",icon:"[SKINIMG]actions/save.png",title:"Save",showDisabledIcon:false,click:function(){this.creator.saveRecord()}};isc.A.cancelButtonDefaults={_constructor:"IButton",icon:"[SKINIMG]actions/cancel.png",title:"Cancel",showDisabledIcon:false,click:function(){this.creator.cancelEdit()}};isc.A.renameButtonDefaults={_constructor:"IButton",icon:"[SKINIMG]actions/exclamation.png",title:"Rename",showDisabledIcon:false,click:function(){this.creator.renameVariable()}};isc.A.editorDefaults={_constructor:"DynamicForm",width:"100%",numCols:8};isc.B.push(isc.A.initWidget=function isc_SkinVariableEditor_initWidget(){this.Super("initWidget",arguments);this.addAutoChild("buttonLayout");this.addMember(this.buttonLayout);this.addAutoChildren(["addButton","editButton","saveButton","cancelButton","renameButton"]);this.buttonLayout.addMembers([this.addButton,this.editButton,this.saveButton,this.cancelButton,this.renameButton]);this.defaultFields=[{name:"id",showIf:"false"},{name:"name",blur:function(){var v=this.getValue();if(v&&v.length>0){v=v.trim();while(v.startsWith("$")){v=v.substring(1)};while(v.endsWith(":")){v=v.substring(0,v.length-1)};v="$"+v;this.setValue(v)}}},{name:"value",blur:function(){var v=value=this.getValue();if(v&&v.length>0){v=v.trim();while(v.endsWith(";")){v=v.substring(0,v.length-1)};if(v!=value)this.setValue(v);if(v.startsWith("$")&&!v.contains(" ")){var _2=this.form;skinVariables.fetchData({"name":v},function(_3,_4){if(_4&&_4.length==1){_2.getItem("derivesFrom").setValue(_4[0].name)}})}}}},{name:"derivesFrom",editorProperties:{autoFetchData:true,addUnknownValues:false},editorType:"ComboBoxItem",optionDataSource:skinVariables,valueField:"name",displayField:"name"},{name:"outputGroup",editorProperties:{dataSetType:"tree",valueField:"name",displayField:"title"}},{name:"outputIndex"},{name:"category"}];this.addAutoChild("editor",{dataSource:this.dataSource,fields:this.defaultFields});this.addMember(this.editor);if(this.record)this.editRecord(this.record);this.disableUI(true)},isc.A.disableUI=function isc_SkinVariableEditor_disableUI(_1){this.addButton.setDisabled(!_1);this.editButton.setDisabled(!_1);this.renameButton.setDisabled(!_1);this.saveButton.setDisabled(_1);this.cancelButton.setDisabled(_1);this.editor.setDisabled(_1)},isc.A.setDataSource=function isc_SkinVariableEditor_setDataSource(_1){this.dataSource=_1;this.editor.setDataSource(this.dataSource,isc.shallowClone(this.defaultFields))},isc.A.editRecord=function isc_SkinVariableEditor_editRecord(_1){this.$194q="edit";this.editor.editRecord(_1)},isc.A.cancelEdit=function isc_SkinVariableEditor_cancelEdit(){this.$194q="none";this.disableUI(true);this.editor.resetValues()},isc.A.getNextDSId=function isc_SkinVariableEditor_getNextDSId(){var _1=this.creator.grid.data.allRows.getProperty("id").max();return _1+1},isc.A.addRecord=function isc_SkinVariableEditor_addRecord(_1){_1=_1||{};if(_1.id==null){_1.id=this.getNextDSId()}
_1.exclude=false;this.$194q="add";this.disableUI(false);this.editor.editNewRecord(_1)},isc.A.clearRecord=function isc_SkinVariableEditor_clearRecord(){this.$194q=null;this.disableUI(true);this.editor.clearValues()},isc.A.renameVariable=function isc_SkinVariableEditor_renameVariable(){var _1=isc.SkinFunc.currentSeries,_2=this.editor.getItem("name").getValue();isc.logWarn("name is "+_2);isc.SkinFunc.editVariableName(_2,_1,this.creator.variablesGrid)},isc.A.saveRecord=function isc_SkinVariableEditor_saveRecord(_1){var _2=this;this.editor.saveData(function(_3,_4){if(_3.status==0){isc.say("Variable saved.");_2.clearRecord();if(_2.$194q=="add")_2.recordAdded(_4);else _2.recordSaved(_4)}})},isc.A.recordAdded=function isc_SkinVariableEditor_recordAdded(_1){},isc.A.recordSaved=function isc_SkinVariableEditor_recordSaved(_1){});isc.B._maxIndex=isc.C+12;isc.defineClass("SkinColorEditor","DynamicForm");isc.A=isc.SkinColorEditor.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.membersMargin=10;isc.A.layoutMargin=10;isc.A.buttonLayoutDefaults={_constructor:"HLayout",width:"100%",height:1,membersMargin:10};isc.A.addButtonDefaults={_constructor:"IButton",icon:"[SKINIMG]actions/add.png",title:"Add Variable",click:function(){this.creator.addRecord()}};isc.A.saveButtonDefaults={_constructor:"IButton",icon:"[SKINIMG]actions/save.png",title:"Save",click:function(){this.creator.saveRecord()}};isc.A.editorDefaults={_constructor:"DynamicForm",width:"100%",numCols:6};isc.B.push(isc.A.initWidget=function isc_SkinColorEditor_initWidget(){this.Super("initWidget",arguments);this.addAutoChild("buttonLayout");this.addMember(this.buttonLayout);this.addAutoChildren(["addButton","saveButton"]);this.buttonLayout.addMembers([this.addButton,this.saveButton]);this.addAutoChild("editor",{dataSource:this.dataSource});this.addMember(this.editor)},isc.A.setDataSource=function isc_SkinColorEditor_setDataSource(_1){this.dataSource=_1;this.editor.setDataSource(this.dataSource)},isc.A.editRecord=function isc_SkinColorEditor_editRecord(_1){this.$194q="edit";this.editor.editRecord(_1)},isc.A.addRecord=function isc_SkinColorEditor_addRecord(_1){this.$194q="add";this.editor.editNewRecord(_1)},isc.A.clearRecord=function isc_SkinColorEditor_clearRecord(){this.$194q=null;this.editor.clearValues()},isc.A.saveRecord=function isc_SkinColorEditor_saveRecord(_1){var _2=this;this.editor.saveData(function(_3,_4){if(!_3.status==0){isc.say("Variable saved.");_2.clearRecord();if(_2.$194q=="add")_2.recordAdded(_4);else _2.recordSaved(_4)}})},isc.A.recordAdded=function isc_SkinColorEditor_recordAdded(_1){},isc.A.recordSaved=function isc_SkinColorEditor_recordSaved(_1){});isc.B._maxIndex=isc.C+8;isc.defineClass("ColorTransformer","VLayout");isc.A=isc.ColorTransformer.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.autoDraw=true;isc.A.formDefaults={_constructor:"DynamicForm",numCols:6,minWidth:600,minColWidth:900,colWidths:[100,120,100,120,100,120],fields:[{name:"inputColor",width:"*",editorType:"ColorItem",title:"Color",changed:function(_1,_2,_3){_1.creator.setColor(_3)}},{name:"transform",editorType:"SelectItem",title:"Transform",width:"*",valueMap:isc.SkinFunc.transformTypes,changed:function(_1,_2,_3){if(_3=="custom"||_3=="none"){_1.hideItem("transformDelta");if(_3=="custom"){_1.showItem("customTransform")}}else{_1.hideItem("customTransform");_1.showItem("transformDelta")}
_1.creator.changeTransform(_3)}},{name:"transformedColor",editorType:"ColorItem",width:"*",title:"Result"},{name:"transformDelta",type:"integer",width:"*",editorType:"SliderItem",title:"Change By %",height:30,min:0,max:100,colSpan:"*",sliderProperties:{showRange:false},visible:false,changed:function(_1,_2,_3){_1.creator.changeTransformDelta(_3)}},{name:"customTransform",editorType:"TextAreaItem",title:"Custom",showHintInField:true,hint:"Javascript function-body that returns a color value",width:"*",height:60,colSpan:"*",visible:false,changeOnKeypress:false,changeOnEnter:true,changed:function(_1,_2,_3){_1.creator.changeCustomTransform(_3)}}]};isc.A.transform="none";isc.A.transformDelta=0;isc.B.push(isc.A.initWidget=function isc_ColorTransformer_initWidget(){this.Super("initWidget",arguments);this.addAutoChild("form");this.addMember(this.form);if(this.color)this.setColor(this.color)},isc.A.setColor=function isc_ColorTransformer_setColor(_1){this.inputColor=_1;this.color=isc.SkinUtil.getSkinColor(_1);if(this.transformDelta)this.startTransformDelta=this.transformDelta;this.updateForm()},isc.A.changeTransform=function isc_ColorTransformer_changeTransform(_1){this.transform=_1;this.updateForm()},isc.A.changeTransformDelta=function isc_ColorTransformer_changeTransformDelta(_1){this.transformDelta=_1;this.updateForm()},isc.A.changeCustomTransform=function isc_ColorTransformer_changeCustomTransform(_1){this.customTransform=_1;this.updateForm()},isc.A.updateForm=function isc_ColorTransformer_updateForm(){var c=this.color;if(c.valid){var _2=c.toHexString();if(this.transform=="custom"){var _3=isc.isA.Function(this.customTransform)?this.customTransform:isc.$aq("color",this.customTransform);this.transformedColor=_3.apply(this,[isc.SkinUtil.getSkinColor(_2)])}else if(this.transform=="none"){this.transformedColor=_2}else{this.transformedColor=isc.SkinFunc.transformColor(_2,this.transform,this.transformDelta)}
this.form.setValues({"inputColor":_2,"transform":this.transform,"transformDelta":this.transformDelta,"customTransform":this.customTransform,"transformedColor":this.transformedColor})}else{this.form.setValues({"inputColor":this.inputColor})}
if(this.transform=="custom")this.form.showItem("customTransform")
else if(this.transform!="none"){this.form.showItem("transformDelta")}});isc.B._maxIndex=isc.C+6;isc.defineClass("ColorTransformerItem","CanvasItem");isc.A=isc.ColorTransformerItem.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.height=1;isc.A.overflow="visible";isc.A.canvasConstructor="ColorTransformer";isc.B.push(isc.A.setValue=function isc_ColorTransformerItem_setValue(_1){var _2=_1==null?null:_1.split("::");if(_2&&_2.length>0){this.canvas.transformDelta=0;this.canvas.customTransform=null;this.canvas.transform=_2[1];if(_2[1]!="none"){if(_2.length>2){if(this.transform=="custom"){this.canvas.customTransform=_2[1]}else{this.canvas.transformDelta=_2[1]}}}
this.canvas.setColor(_2[0])}},isc.A.getValue=function isc_ColorTransformerItem_getValue(){var f=this.canvas,_2=f.transform;if(_2!="none"){_2+="::";if(_2=="custom"){_2+=f.customTransform}else{_2+=f.transformDelta}}
return _2});isc.B._maxIndex=isc.C+2;isc.defineClass("SkinVariableGroupEditor","VLayout");isc.A=isc.SkinVariableGroupEditor.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.buttonLayoutDefaults={_constructor:"HLayout",width:"100%",height:1};isc.A.addButtonDefaults={_constructor:"IButton",title:"Add Group",autoFit:true,autoParent:"buttonLayout",click:function(){this.creator.addGroup()}};isc.A.editButtonDefaults={_constructor:"IButton",title:"Edit",autoFit:true,autoParent:"buttonLayout",click:function(){this.creator.startEditing()}};isc.A.saveButtonDefaults={_constructor:"IButton",title:"Save",autoFit:true,autoParent:"buttonLayout",click:function(){this.creator.saveRecord()}};isc.A.cancelButtonDefaults={_constructor:"IButton",title:"Cancel",autoFit:true,autoParent:"buttonLayout",click:function(){this.creator.cancelEdit()}};isc.A.formDefaults={_constructor:"DynamicForm",fields:[{name:"parentId",title:"Group",valueField:"name",displayField:"title"},{name:"name"},{name:"title"},{name:"comment"},{name:"index"}]};isc.B.push(isc.A.initWidget=function isc_SkinVariableGroupEditor_initWidget(){this.Super("initWidget",arguments);this.addAutoChild("buttonLayout");this.addMember(this.buttonLayout);this.addAutoChildren(["addButton","editButton","saveButton","cancelButton"]);this.addAutoChild("form",{dataSource:skinVariableGroups});this.addMember(this.form)},isc.A.editRecord=function isc_SkinVariableGroupEditor_editRecord(_1){this.form.editRecord(_1)},isc.A.editNewRecord=function isc_SkinVariableGroupEditor_editNewRecord(_1){this.form.editNewRecord(_1)},isc.A.saveRecord=function isc_SkinVariableGroupEditor_saveRecord(){this.form.saveData();this.hide()},isc.A.cancelEdit=function isc_SkinVariableGroupEditor_cancelEdit(){this.hide()});isc.B._maxIndex=isc.C+5;isc.defineClass("SkinVariableGroupTree","TreeGrid");isc.A=isc.SkinVariableGroupTree.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.dataSource="skinVariableGroups";isc.A.autoFetchData=true;isc.A.canAcceptDroppedRecords=true;isc.A.canReparentNodes=true;isc.A.dataProperties={fetchMode:"local",loadDataOnDemand:false,autoOpenRoot:"root"};isc.A.fields=[{name:"name",showIf:"false"},{name:"title",width:"*"},{name:"index",width:70}];isc.A.initialSort=[{property:"index",direction:"ascending"}];isc.A.sortByGroupfirst=true;isc.A.groupEditorDefaults={_constructor:"SkinVariableGroupEditor",backgroundColor:"white"};isc.A.contextMenu={_constructor:"Menu",autoDraw:false,data:[{title:"Add Child Group",click:function(_1,_2,_3,_4){_1.addChildGroup(_1.getSelectedRecord())}},{title:"Add Root Group",click:function(_1,_2,_3,_4){_1.addChildGroup(null)}},{title:"Edit Group",click:function(_1,_2,_3,_4){_1.editGroup(_1.getSelectedRecord())}}],width:150};isc.B.push(isc.A.dataArrived=function isc_SkinVariableGroupTree_dataArrived(){this.data.openAll();var _1=this.data.getOpenList();_1.map(function(_2){_2.isFolder=true})},isc.A.dataChanged=function isc_SkinVariableGroupTree_dataChanged(){this.data.openAll();var _1=this.data.getOpenList();_1.map(function(_2){_2.isFolder=true})},isc.A.nodeClick=function isc_SkinVariableGroupTree_nodeClick(_1,_2,_3){if(!this.data.isOpen(_2))this.openFolder(_2);this.Super("nodeClick",arguments)},isc.A.initWidget=function isc_SkinVariableGroupTree_initWidget(){this.Super("initWidget",arguments);this.nodeIcon=this.folderIcon},isc.A.getGroupEditor=function isc_SkinVariableGroupTree_getGroupEditor(){if(!this.groupEditor){this.groupEditor=this.createAutoChild("groupEditor")}
return this.groupEditor},isc.A.addChildGroup=function isc_SkinVariableGroupTree_addChildGroup(_1){var _2=this.getGroupEditor(),_3={};if(_1){_3.parentId=_1.name;_3.name=_1.name+"_"}
_2.editNewRecord(_3);this.showEditor()},isc.A.showEditor=function isc_SkinVariableGroupTree_showEditor(){var _1=this.getGroupEditor();if(!_1.isDrawn())_1.draw();_1.moveTo((isc.Page.getWidth()/2)-(_1.getWidth()/2),(isc.Page.getHeight()/2)-(_1.getHeight()/2));_1.show()},isc.A.editGroup=function isc_SkinVariableGroupTree_editGroup(_1){var _2=this.getGroupEditor();_2.editRecord(_1);this.showEditor()});isc.B._maxIndex=isc.C+8;isc.defineClass("SkinVariableGroupLayout","VLayout");isc.A=isc.SkinVariableGroupLayout.getPrototype();isc.B=isc._allFuncs;isc.C=isc.B._maxIndex;isc.D=isc._funcClasses;isc.D[isc.C]=isc.A.Class;isc.A.groupTreeDefaults={_constructor:"SkinVariableGroupTree",width:300,showResizeBar:true,autoParent:"bodyLayout",canEdit:true,nodeClick:function(_1,_2,_3){this.creator.showGroupVariables(_2)}};isc.A.gridDefaults={_constructor:"ListGrid",width:"*",dataSource:"skinVariables",autoFetchData:true,dataFetchMode:"local",canEdit:true,autoParent:"bodyLayout",initialSort:{property:"outputIndex",direction:"ascending"},canDragRecordsOut:true,fields:[{name:"name",width:300},{name:"value",width:300},{name:"comment",width:300},{name:"outputIndex"}]};isc.A.bodyLayoutDefaults={_constructor:"HLayout",width:"100%",height:"*"};isc.B.push(isc.A.initWidget=function isc_SkinVariableGroupLayout_initWidget(){this.Super("initWidget",arguments);this.addAutoChild("bodyLayout");this.addMember(this.bodyLayout);this.addAutoChildren(["groupTree","grid"])},isc.A.showGroupVariables=function isc_SkinVariableGroupLayout_showGroupVariables(_1){this.grid.fetchData({fieldName:"outputGroup",operator:"iStartsWith",value:_1.name},null,{invalidateCache:true})},isc.A.getGroupEditor=function isc_SkinVariableGroupLayout_getGroupEditor(){return this.groupTree&&this.groupTree.groupEditor},isc.A.addChildGroup=function isc_SkinVariableGroupLayout_addChildGroup(_1){if(this.groupTree)this.groupTree.addChildGroup(_1)},isc.A.editGroupRecord=function isc_SkinVariableGroupLayout_editGroupRecord(_1){if(this.groupTree)this.groupTree.editGroup(_1)});isc.B._maxIndex=isc.C+5;isc.getButtonsPane=function(){isc.Menu.create({ID:"menu",autoDraw:false,showShadow:true,shadowDepth:10,data:[{title:"New",keyTitle:"Ctrl+N",icon:"icons/16/document_plain_new.png"},{title:"Open",keyTitle:"Ctrl+O",icon:"icons/16/folder_out.png"},{isSeparator:true},{title:"Save",keyTitle:"Ctrl+S",icon:"icons/16/disk_blue.png"},{title:"Save As",icon:"icons/16/save_as.png"},{isSeparator:true},{title:"Recent Documents",icon:"icons/16/folder_document.png",submenu:[{title:"data.xml",checked:true},{title:"Component Guide.doc"},{title:"SmartClient.doc",checked:true},{title:"AJAX.doc"}]},{isSeparator:true},{title:"Export as...",icon:"icons/16/export1.png",submenu:[{title:"XML"},{title:"CSV"},{title:"Plain text"}]},{isSeparator:true},{title:"Print",enabled:false,keyTitle:"Ctrl+P",icon:"icons/16/printer3.png"}]});isc.ToolStripMenuButton.create({ID:"menuButton",title:"File",menu:menu});isc.ToolStripButton.create({ID:"printButton",icon:"[SKIN]/RichTextEditor/print.png",title:"Print"});isc.ToolStripButton.create({ID:"alignLeft",icon:"[SKIN]/RichTextEditor/text_align_left.png",actionType:"radio",radioGroup:"textAlign"});isc.ToolStripButton.create({ID:"alignRight",icon:"[SKIN]/RichTextEditor/text_align_right.png",actionType:"radio",radioGroup:"textAlign"});isc.ToolStripButton.create({ID:"alignCenter",icon:"[SKIN]/RichTextEditor/text_align_center.png",actionType:"radio",radioGroup:"textAlign"});isc.ToolStripButton.create({ID:"bold",icon:"[SKIN]/RichTextEditor/text_bold.png",actionType:"checkbox",showFocused:false,showFocusOutline:true});isc.ToolStripButton.create({ID:"italics",icon:"[SKIN]/RichTextEditor/text_italic.png",actionType:"checkbox",showFocused:false,showFocusOutline:true});isc.ToolStripButton.create({ID:"underlined",icon:"[SKIN]/RichTextEditor/text_underline.png",actionType:"checkbox",showFocused:false,showFocusOutline:true});isc.DynamicForm.create({ID:"fontSelector",showResizeBar:true,width:120,minWidth:50,numCols:1,fields:[{name:"selectFont",showTitle:false,width:"*",valueMap:{"courier":"<span style='font-family:courier'>Courier</span>","verdana":"<span style='font-family:verdana'>Verdana</span>","times":"<span style='font-family:times'>Times</span>"},defaultValue:"courier"}]});isc.DynamicForm.create({ID:"zoomSelector",width:100,minWidth:50,numCols:1,fields:[{name:"selectZoom",showTitle:false,width:"*",valueMap:["50%","75%","100%","150%","200%","Fit"],defaultValue:"100%"}]});isc.ToolStrip.create({ID:"toolStrip",members:[menuButton,"separator",printButton,"resizer",bold,italics,underlined,"separator",alignLeft,alignRight,alignCenter,"separator",fontSelector,"resizer",zoomSelector]});var _1={_constructor:"Menu",autoDraw:false,showShadow:true,shadowDepth:10,data:[{title:"Document",keyTitle:"Ctrl+D",icon:"[SKINIMG]actions/edit.png"},{title:"Picture",keyTitle:"Ctrl+P",icon:"[SKINIMG]actions/close.png"},{title:"Email",keyTitle:"Ctrl+E",icon:"[SKINIMG]actions/accept.png"}]};function getIconButton(_2,_3){return isc.IconButton.create(isc.addProperties({title:_2,icon:"[SKINIMG]actions/add.png",largeIcon:"[SKINIMG]actions/add.png",click:"isc.say(this.title + ' button clicked');"},_3))}
function getIconMenuButton(_2,_3){return isc.IconMenuButton.create(isc.addProperties({title:_2,icon:"[SKINIMG]actions/edit.png",largeIcon:"[SKINIMG]actions/edit.png",click:"isc.say(this.title + ' button clicked');"},_3))}
isc.RibbonGroup.create({ID:"fileGroup",title:"File (vertical icons)",numRows:3,colWidths:[40,"*"],titleAlign:"left",controls:[getIconMenuButton("New",{orientation:"vertical",menu:_1,showMenuIconOver:false}),getIconButton("Open",{orientation:"vertical",largeIcon:"[SKINIMG]actions/accept.png"}),getIconButton("Save",{orientation:"vertical",largeIcon:"[SKINIMG]actions/save.png"}),getIconMenuButton("Save As",{orientation:"vertical",menu:_1,largeIcon:"[SKINIMG]actions/add.png"})],autoDraw:false});isc.RibbonGroup.create({ID:"editGroup",title:"Editing Tools",numRows:3,colWidths:[40,"*"],controls:[getIconButton("Edit",{icon:"[SKINIMG]actions/edit.png"}),getIconButton("Copy",{icon:"[SKINIMG]actions/refresh.png"}),getIconButton("Paste"),getIconMenuButton("Undo",{menu:_1,showMenuIconOver:false,icon:"[SKINIMG]actions/add.png"}),getIconMenuButton("Redo",{menu:_1,icon:"[SKINIMG]actions/accept.png"})],autoDraw:false});isc.RibbonGroup.create({ID:"insertGroup",title:"Insert",numRows:3,colWidths:[40,"*"],controls:[getIconMenuButton("Picture",{orientation:"vertical",menu:_1,largeIcon:"[SKINIMG]actions/add.png"}),getIconButton("Link",{icon:"[SKINIMG]actions/edit.png"}),getIconButton("Document",{icon:"[SKINIMG]actions/accept.png"}),getIconButton("Video",{icon:"[SKINIMG]actions/help.png"})],autoDraw:false});isc.RibbonBar.create({ID:"ribbonBar",groupTitleAlign:"center",groupTitleOrientation:"top"});ribbonBar.addGroup(fileGroup,0);ribbonBar.addGroup(editGroup,1);ribbonBar.addGroup(insertGroup,2);isc.Menu.create({ID:"customColumnMenu",autoDismiss:false,fields:["title",{name:"canDismiss",width:16,showValueIconOnly:true,valueIcons:{"true":"[SKINIMG]actions/close.png"}}],data:[{name:"Item 1"},{name:"Item 2",canDismiss:true},{name:"Item 3",canDismiss:true}],itemClick:function(_2,_3){if(_3==1&&_2.canDismiss){this.removeItem(_2)}else{isc.say("You Selected '"+_2.name+"'.");this.hide()}}});isc.MenuButton.create({ID:"menuButton1",autoDraw:false,title:"Show Menu",menu:customColumnMenu});isc.Button.create({ID:"buttonCSSButton",autoFit:true,title:"CSS Button",icon:"[SKINIMG]actions/add.png"});isc.IButton.create({ID:"buttonIButton",title:"Stretch Button",width:150,icon:"[SKINIMG]actions/find.png"});isc.ImgButton.create({ID:"buttonImgButton",width:18,height:18,src:"[SKIN]/ImgButton/button.png"});isc.NavigationBar.create({ID:"navBar1",width:500,leftButtonTitle:"Back",rightButtonTitle:"Forward",showRightButton:true,title:"NavBar Title",navigationClick:function(_2){if(_2==="back"){isc.say("Back button clicked!")}else if(_2==="forward"){isc.say("Forward button clicked!")}}});isc.HLayout.create({ID:"buttonRowLayout1",membersMargin:20,members:[ribbonBar]});isc.HLayout.create({ID:"buttonRowLayout2",membersMargin:20,members:[menuButton1,buttonCSSButton,buttonIButton,buttonImgButton]});isc.VLayout.create({ID:"buttonsPane",layoutMargin:10,membersMargin:20,top:60,autoDraw:false,members:[navBar1,toolStrip,buttonRowLayout1,buttonRowLayout2]});return buttonsPane}
isc.getCubesPane=function(){var _1=[{quarter:"Q1, 2016",month:"January",region:"Western U.S.",product:"Pens",metric:"Revenue",_value:10000,percentNational:25},{quarter:"Q1, 2016",month:"January",region:"Western U.S.",product:"Chairs",metric:"Revenue",_value:50000,percentNational:45},{quarter:"Q1, 2016",month:"January",region:"Western U.S.",product:"Monitors",metric:"Revenue",_value:120000,percentNational:49},{quarter:"Q1, 2016",month:"January",region:"Western U.S.",product:"Pens",metric:"Profit",_value:2000,percentNational:25},{quarter:"Q1, 2016",month:"January",region:"Western U.S.",product:"Chairs",metric:"Profit",_value:5000,percentNational:45},{quarter:"Q1, 2016",month:"January",region:"Western U.S.",product:"Monitors",metric:"Profit",_value:44000,percentNational:59,_hilite:"over50"},{quarter:"Q1, 2016",month:"January",region:"Midwest U.S.",product:"Pens",metric:"Revenue",_value:8000,percentNational:20},{quarter:"Q1, 2016",month:"January",region:"Midwest U.S.",product:"Chairs",metric:"Revenue",_value:22000,percentNational:20},{quarter:"Q1, 2016",month:"January",region:"Midwest U.S.",product:"Monitors",metric:"Revenue",_value:20000,percentNational:8,_hilite:"under10"},{quarter:"Q1, 2016",month:"January",region:"Midwest U.S.",product:"Pens",metric:"Profit",_value:2000,percentNational:25},{quarter:"Q1, 2016",month:"January",region:"Midwest U.S.",product:"Chairs",metric:"Profit",_value:2000,percentNational:18},{quarter:"Q1, 2016",month:"January",region:"Midwest U.S.",product:"Monitors",metric:"Profit",_value:5000,percentNational:7,_hilite:"under10"},{quarter:"Q1, 2016",month:"January",region:"Eastern U.S.",product:"Pens",metric:"Revenue",_value:22000,percentNational:55,_hilite:"over50"},{quarter:"Q1, 2016",month:"January",region:"Eastern U.S.",product:"Chairs",metric:"Revenue",_value:40000,percentNational:36},{quarter:"Q1, 2016",month:"January",region:"Eastern U.S.",product:"Monitors",metric:"Revenue",_value:105000,percentNational:43},{quarter:"Q1, 2016",month:"January",region:"Eastern U.S.",product:"Pens",metric:"Profit",_value:4000,percentNational:50,_hilite:"over50"},{quarter:"Q1, 2016",month:"January",region:"Eastern U.S.",product:"Chairs",metric:"Profit",_value:4000,percentNational:36},{quarter:"Q1, 2016",month:"January",region:"Eastern U.S.",product:"Monitors",metric:"Profit",_value:25000,percentNational:34},{quarter:"Q1, 2016",month:"February",region:"Western U.S.",product:"Pens",metric:"Revenue",_value:12000,percentNational:23},{quarter:"Q1, 2016",month:"February",region:"Western U.S.",product:"Chairs",metric:"Revenue",_value:42000,percentNational:47},{quarter:"Q1, 2016",month:"February",region:"Western U.S.",product:"Monitors",metric:"Revenue",_value:160000,percentNational:40},{quarter:"Q1, 2016",month:"February",region:"Western U.S.",product:"Pens",metric:"Profit",_value:4000,percentNational:23},{quarter:"Q1, 2016",month:"February",region:"Western U.S.",product:"Chairs",metric:"Profit",_value:4000,percentNational:47},{quarter:"Q1, 2016",month:"February",region:"Western U.S.",product:"Monitors",metric:"Profit",_value:68000,percentNational:40},{quarter:"Q1, 2016",month:"February",region:"Midwest U.S.",product:"Pens",metric:"Revenue",_value:10000,percentNational:19},{quarter:"Q1, 2016",month:"February",region:"Midwest U.S.",product:"Chairs",metric:"Revenue",_value:12000,percentNational:13},{quarter:"Q1, 2016",month:"February",region:"Midwest U.S.",product:"Monitors",metric:"Revenue",_value:75000,percentNational:19},{quarter:"Q1, 2016",month:"February",region:"Midwest U.S.",product:"Pens",metric:"Profit",_value:3000,percentNational:20},{quarter:"Q1, 2016",month:"February",region:"Midwest U.S.",product:"Chairs",metric:"Profit",_value:1000,percentNational:11},{quarter:"Q1, 2016",month:"February",region:"Midwest U.S.",product:"Monitors",metric:"Profit",_value:32000,percentNational:17},{quarter:"Q1, 2016",month:"February",region:"Eastern U.S.",product:"Pens",metric:"Revenue",_value:31000,percentNational:58,_hilite:"over50"},{quarter:"Q1, 2016",month:"February",region:"Eastern U.S.",product:"Chairs",metric:"Revenue",_value:35000,percentNational:39},{quarter:"Q1, 2016",month:"February",region:"Eastern U.S.",product:"Monitors",metric:"Revenue",_value:164000,percentNational:41},{quarter:"Q1, 2016",month:"February",region:"Eastern U.S.",product:"Pens",metric:"Profit",_value:8000,percentNational:53,_hilite:"over50"},{quarter:"Q1, 2016",month:"February",region:"Eastern U.S.",product:"Chairs",metric:"Profit",_value:4000,percentNational:44},{quarter:"Q1, 2016",month:"February",region:"Eastern U.S.",product:"Monitors",metric:"Profit",_value:88000,percentNational:47},{quarter:"Q1, 2016",month:"March",region:"Western U.S.",product:"Pens",metric:"Revenue",_value:18000,percentNational:26},{quarter:"Q1, 2016",month:"March",region:"Western U.S.",product:"Chairs",metric:"Revenue",_value:25000,percentNational:54,_hilite:"over50"},{quarter:"Q1, 2016",month:"March",region:"Western U.S.",product:"Monitors",metric:"Revenue",_value:220000,percentNational:40},{quarter:"Q1, 2016",month:"March",region:"Western U.S.",product:"Pens",metric:"Profit",_value:9000,percentNational:29},{quarter:"Q1, 2016",month:"March",region:"Western U.S.",product:"Chairs",metric:"Profit",_value:2000,percentNational:40},{quarter:"Q1, 2016",month:"March",region:"Western U.S.",product:"Monitors",metric:"Profit",_value:112000,percentNational:38},{quarter:"Q1, 2016",month:"March",region:"Midwest U.S.",product:"Pens",metric:"Revenue",_value:7000,percentNational:10},{quarter:"Q1, 2016",month:"March",region:"Midwest U.S.",product:"Chairs",metric:"Revenue",_value:6000,percentNational:13},{quarter:"Q1, 2016",month:"March",region:"Midwest U.S.",product:"Monitors",metric:"Revenue",_value:135000,percentNational:25},{quarter:"Q1, 2016",month:"March",region:"Midwest U.S.",product:"Pens",metric:"Profit",_value:2000,percentNational:6,_hilite:"under10"},{quarter:"Q1, 2016",month:"March",region:"Midwest U.S.",product:"Chairs",metric:"Profit",_value:1000,percentNational:20},{quarter:"Q1, 2016",month:"March",region:"Midwest U.S.",product:"Monitors",metric:"Profit",_value:66000,percentNational:23},{quarter:"Q1, 2016",month:"March",region:"Eastern U.S.",product:"Pens",metric:"Revenue",_value:44000,percentNational:64,_hilite:"over50"},{quarter:"Q1, 2016",month:"March",region:"Eastern U.S.",product:"Chairs",metric:"Revenue",_value:15000,percentNational:33},{quarter:"Q1, 2016",month:"March",region:"Eastern U.S.",product:"Monitors",metric:"Revenue",_value:190000,percentNational:35},{quarter:"Q1, 2016",month:"March",region:"Eastern U.S.",product:"Pens",metric:"Profit",_value:20000,percentNational:65,_hilite:"over50"},{quarter:"Q1, 2016",month:"March",region:"Eastern U.S.",product:"Chairs",metric:"Profit",_value:2000,percentNational:40},{quarter:"Q1, 2016",month:"March",region:"Eastern U.S.",product:"Monitors",metric:"Profit",_value:115000,percentNational:39}];isc.CubeGrid.create({ID:"cubeBasic",data:_1,width:800,height:400,hideEmptyFacetValues:true,valueFormat:"\u00A4,0.00",columnFacets:["quarter","month","metric"],rowFacets:["region","product"]});isc.HLayout.create({ID:"cubeRowLayout1",membersMargin:20,members:[cubeBasic]});isc.VLayout.create({ID:"cubesPane",layoutMargin:10,membersMargin:20,top:60,autoDraw:false,members:[cubeRowLayout1]});return cubesPane}
isc.getFormItemsPane=function(){function fUpdateReadOnlyDisplay(_7){_7=_7||readOnlyDisplayPickerForm.getValue("readOnlyDisplayPicker");_5.setReadOnlyDisplay(_7);form1.setReadOnlyDisplay(_7);form2.setReadOnlyDisplay(_7);dateForm.setReadOnlyDisplay(_7)}
function fSetCanEdit(_1){fUpdateReadOnlyDisplay();_5.setCanEdit(_1);form1.setCanEdit(_1);form2.setCanEdit(_1);dateForm.setCanEdit(_1)}
isc.IButton.create({ID:"toggleCanEdit",title:"setCanEdit(false)",autoFit:true,click:function(){if(this.title=="setCanEdit(false)")this.setTitle("setCanEdit(true)");else this.setTitle("setCanEdit(false)");var _1=this.title=="setCanEdit(false)";fSetCanEdit(_1)}});isc.DynamicForm.create({ID:"readOnlyDisplayPickerForm",numCols:2,colWidths:[120,140],wrapItemTitles:false,fields:[{name:"readOnlyDisplayPicker",title:"ReadOnly Display",width:"*",valueMap:["static","readOnly","disabled"],defaultValue:"disabled",changed:function(){fUpdateReadOnlyDisplay(this.getValue())}}]});isc.ToolStrip.create({ID:"uiToolstripFI",members:[toggleCanEdit,readOnlyDisplayPickerForm]});isc.DynamicForm.create({ID:"form1",width:360,colWidths:[190,"*"],fields:[{name:"text",title:"Text",type:"text"},{name:"colorPicker",title:"Color Picker",type:"color"},{name:"textArea",title:"TextArea",type:"textArea"},{name:"stackedSpinner",title:"Stacked Spinner",editorType:"SpinnerItem",writeStackedIcons:true,defaultValue:5,min:0,max:10,step:0.5,wrapTitle:false},{name:"unstackedSpinner",title:"Unstacked Spinner",editorType:"SpinnerItem",writeStackedIcons:false,defaultValue:5,min:0,max:10,step:0.5},{name:"slider",title:"Slider",editorType:"SliderItem",minValue:1,maxValue:5,numValues:5,height:isc.Browser.isTouch?52:36},{name:"link",title:"LinkItem",type:"link",height:80,target:"javascript",click:"isc.say('Hello world!')",linkTitle:"Click Me"},{name:"checkbox",title:"Checkbox",type:"checkbox",height:25},{name:"radioGroup",title:"Radio Group",type:"radioGroup",valueMap:["Option 1","Option 2"]}],values:{slider:4}});var _2={"US":"<b>United States</b>","CH":"China","JA":"<b>Japan</b>","IN":"India","GM":"Germany","FR":"France","IT":"Italy","RS":"Russia","BR":"<b>Brazil</b>","CA":"Canada","MX":"Mexico","SP":"Spain"}
var _3={"US":"US","CH":"CH","JA":"JA","IN":"IN","GM":"GM","FR":"FR","IT":"IT","RS":"RS","BR":"BR","CA":"CA","MX":"MX","SP":"SP"}
isc.DynamicForm.create({ID:"form2",width:500,colWidths:[170,"*"],isGroup:true,groupTitle:"Select / Combo Controls",fields:[{name:"bugStatus",title:"Select",hint:"<nobr>A simple comboBox</nobr>",editorType:"ComboBoxItem",valueMap:{"cat":"Cat","dog":"Dog","giraffe":"Giraffe","goat":"Goat","marmoset":"Marmoset","mouse":"Mouse"}},{name:"itemName",title:"Item Name",hint:"<nobr>A databound comboBox</nobr>",editorType:"ComboBoxItem",optionDataSource:"supplyItem"},{name:"selectItem",title:"Select",hint:"<nobr>A select with icons</nobr>",editorType:"SelectItem",valueMap:_2,valueIcons:_3,imageURLPrefix:"../../../isomorphic/client/reference/exampleImages/flags/16/",imageURLSuffix:".png"},{name:"selectItem2",title:"Select",hint:"<nobr>A select with styled entries</nobr>",editorType:"SelectItem",valueMap:{"red":"<span style='color:#FF0000;'>Red</span>","green":"<span style='color:#00FF00;'>Green</span>","blue":"<span style='color:#0000FF;'>Blue</span>"}},{name:"selectItemMultipleGrid",title:"Select Multiple (Grid)",editorType:"SelectItem",multiple:true,multipleAppearance:"grid",valueMap:{"cat":"Cat","dog":"Dog","giraffe":"Giraffe","goat":"Goat","marmoset":"Marmoset","mouse":"Mouse"}},{name:"selectItemMultiplePickList",title:"Select Multiple (PickList)",editorType:"SelectItem",multiple:true,multipleAppearance:"picklist",valueMap:{"cat":"Cat","dog":"Dog","giraffe":"Giraffe","goat":"Goat","marmoset":"Marmoset","mouse":"Mouse"}}]});isc.DynamicForm.create({ID:"dateForm",width:500,fixedColWidths:true,colWidths:[120,"*"],isGroup:true,groupTitle:"Date Controls",fields:[{name:"dateItem",title:"Date",hint:"<nobr>Picklist based date input</nobr>",editorType:"DateItem"},{name:"dateItem2",title:"Date",hint:"<nobr>Direct date input</nobr>",editorType:"DateItem",useTextField:true},{name:"timeItem",title:"Time",editorType:"TimeItem"},{name:"timeItem",title:"Time",hint:"Picklist based time input",editorType:"TimeItem",useTextField:false},{name:"dri",title:"Date Range",width:400,editorType:"DateRangeItem",allowRelativeDates:true,fromDate:"$today",toDate:"-1m"},{name:"mdri",title:"Mini Date Range",editorType:"MiniDateRangeItem"},{name:"rdi",title:"Relative Date",editorType:"RelativeDateItem"}]});var _4=isc.Tree.create({modelType:"children",root:{name:"root",children:[{id:1000,name:"Marketing",children:[{id:1001,name:"Advertising"},{id:1002,name:"Community Relations"}]},{id:2000,name:"Sales",children:[{id:2001,name:"Channel Sales"},{id:2002,name:"Direct Sales"}]},{id:3000,name:"Manufacturing",children:[{id:3001,name:"Design"},{id:3002,name:"Development"},{id:3003,name:"QA"}]},{id:4000,name:"Services",children:[{id:4001,name:"Support"},{id:4002,name:"Consulting"}]}]}});isc.DataSource.create({ID:"clientOnlyUsersDS",clientOnly:true,fields:[{name:"id",title:"ID",type:"integer",primaryKey:true,hidden:true},{name:"name",title:"Name"}],cacheData:[{id:1,name:"Max"},{id:2,name:"Bethany"},{id:3,name:"Zach"},{id:4,name:"Francesca"}]});isc.DataSource.create({ID:"clientOnlyUserFavoritesDS",clientOnly:true,fields:[{name:"id",title:"ID",type:"integer",primaryKey:true,hidden:true},{name:"userID",type:"integer",foreignKey:"clientOnlyUsersDS.id",title:"User ID"},{name:"favoriteAnimal",title:"Favorite Animal"},{name:"favoriteNumber",type:"number",title:"Favorite Integer (0 - 100)"},{name:"hasFavoriteColor",title:"Has a Favorite Color?",type:"boolean"},{name:"favoriteColor",valueMap:["Red","Orange","Yellow","Green","Blue","Indigo","Violet"]},{name:"favoriteDate",type:"date",title:"Favorite Date"},{name:"favoriteTime",type:"time",title:"Favorite Time"},{name:"favoriteMusicGenres",multiple:true,title:"Favorite Music Genres",valueMap:["Alternative","Classical","Country","Folk","Hip Hop","Jazz","Pop","R&B","Rock","World","Other"]},{name:"favoriteVacationDestination",title:"Favorite Vacation Destination",valueMap:{"AS":"Australia","BR":"Brazil","CA":"Canada","CH":"China","FR":"France","GM":"Germany","IN":"India","ID":"Indonesia","IT":"Italy","JA":"Japan","MX":"Mexico","RS":"Russia","KS":"South Korea","SP":"Spain","UK":"United Kingdom","US":"United States"}},{name:"favoriteCuisines",multiple:true,title:"Favorite Cuisines",valueMap:{"US":"American","AS":"Australian","BR":"Brazilian","UK":"British","CA":"Canadian","CH":"Chinese","FR":"French","GM":"German","IN":"Indian","ID":"Indonesian","IT":"Italian","JA":"Japanese","KS":"Korean","MX":"Mexican","RS":"Russian","SP":"Spanish"}},{name:"favoriteDepartment",title:"Favorite Department"}],cacheData:[{id:1,userID:1,favoriteAnimal:"Lemur",favoriteNumber:90,hasFavoriteColor:false,favoriteDate:isc.Date.createLogicalDate(2000,0,1),favoriteTime:isc.Date.createLogicalTime(0,0),favoriteMusicGenres:["Classical","Rock","World"],favoriteVacationDestination:"JA",favoriteCuisines:["CA","CH","IN","RS"],favoriteDepartment:4002},{id:2,userID:2,favoriteAnimal:"Zebra",favoriteNumber:12,hasFavoriteColor:true,favoriteColor:"Orange",favoriteDate:isc.Date.createLogicalDate(2012,11,12),favoriteTime:isc.Date.createLogicalTime(12,12),favoriteMusicGenres:["Alternative","Hip Hop"],favoriteVacationDestination:"US",favoriteCuisines:["US","AS","BR","UK"],favoriteDepartment:3002},{id:3,userID:3,favoriteAnimal:"Elephant",favoriteNumber:10,hasFavoriteColor:true,favoriteColor:"Green",favoriteDate:isc.Date.createLogicalDate(2010,9,10),favoriteTime:isc.Date.createLogicalTime(10,10),favoriteMusicGenres:["Country","Folk"],favoriteVacationDestination:"MX",favoriteCuisines:["GM","ID","JA","MX"],favoriteDepartment:1001},{id:4,userID:4,favoriteAnimal:"Blue Whale",favoriteNumber:55,hasFavoriteColor:true,favoriteColor:"Blue",favoriteDate:isc.Date.createLogicalDate(2005,4,5),favoriteTime:isc.Date.createLogicalTime(12,0),favoriteMusicGenres:["Pop","R&B","Other"],favoriteVacationDestination:"SP",favoriteCuisines:["FR","IT","KS","SP"],favoriteDepartment:3001}]});var _5=isc.DynamicForm.create({ID:"favoritesForm",autoDraw:false,autoFetchData:true,initialCriteria:{userID:1},width:500,colWidths:[175,"*"],dataSource:clientOnlyUserFavoritesDS,revertValueKey:"Escape",items:[{name:"userID",title:"User",editorType:"SelectItem",optionDataSource:"clientOnlyUsersDS",valueField:"id",displayField:"name",changed:function(_7,_8,_9){_7.fetchData({userID:_9},function(_10,_11,_12){var _6=(_11!=null&&_11.length>=1&&!!_11[0].hasFavoriteColor)
_7.getItem("favoriteColor").setDisabled(!_6)})}},{name:"favoriteAnimal",showPending:true},{name:"favoriteAnimal2",editorType:"TextAreaItem",height:40,showPending:true},{name:"favoriteNumber",editorType:"SliderItem",height:30,minValue:0,maxValue:100,showPending:true},{name:"spinner",title:"Spinner",editorType:"SpinnerItem",writeStackedIcons:true,min:0,max:10,step:0.5,wrapTitle:false,showPending:true},{name:"hasFavoriteColor",editorType:"CheckboxItem",showPending:true,changed:function(_7,_8,_9){_7.getItem("favoriteColor").setDisabled(!_9)}},{name:"favoriteColor",editorType:"RadioGroupItem",disabled:true,showPending:true},{name:"favoriteDate",editorType:"DateItem",showPending:true},{name:"favoriteTime",editorType:"TimeItem",showPending:true},{name:"favoriteMusicGenres",editorType:"MultiComboBoxItem",useInsertionOrder:false,showPending:true},{name:"favoriteVacationDestination",wrapTitle:false,editorType:"SelectItem",showPending:true,imageURLPrefix:"../../../isomorphic/client/reference/exampleImages/flags/16/",imageURLSuffix:".png",getValueIcon:function(_7){return _7}},{name:"favoriteCuisines",editorType:"SelectItem",width:"*",showPending:true,showOldValueInHover:true,imageURLPrefix:"../../../isomorphic/client/reference/exampleImages/flags/16/",imageURLSuffix:".png",getValueIcon:function(_7){if(isc.isAn.Array(_7)){return null}
return _7}},{name:"favoriteDepartment",editorType:"PickTreeItem",width:140,displayField:"name",valueField:"id",valueTree:_4,showPending:true}]});_5.fetchData({userId:1},function(_7,_8){_5.setValue("favoriteAnimal","Changed value");_5.setValue("favoriteAnimal2","Changed value");_5.setValue("favoriteNumber",73);_5.setValue("spinner",5);_5.setValue("hasFavoriteColor",false);_5.setValue("favoriteColor","Red");_5.setValue("favoriteDate",isc.Date.createLogicalDate(2012,11,12));_5.setValue("favoriteTime",isc.Date.createLogicalTime(12,12));_5.setValue("favoriteMusicGenres",["Country","Folk"]);_5.setValue("favoriteVacationDestination","US");_5.setValue("favoriteCuisines",["US","AS","BR","UK"]);_5.setValue("favoriteDepartment",3002);_5.setValue("favoriteMusicGenres",["Country","Folk","Jazz"]);_5.setValue("hasFavoriteColor",true);_5.getItem("favoriteColor").setDisabled(!_5.getValue("hasFavoriteColor"))});isc.HLayout.create({ID:"fiRowLayout1",membersMargin:20,members:[_5,form1,form2,dateForm]});isc.VLayout.create({ID:"formItemsPane",layoutMargin:10,membersMargin:20,top:60,autoDraw:false,members:[uiToolstripFI,fiRowLayout1]});return formItemsPane}
isc.getGridsPane=function(){isc.ListGrid.create({ID:"lgFilter",width:400,height:200,dataSource:worldDS,canEdit:true,fields:[{name:"countryName",title:"Country"},{name:"capital",title:"Capital"},{name:"continent",title:"Continent"}],autoFetchData:true,showFilterEditor:true,initialCriteria:{fieldName:"countryName",operator:"iNotContains",value:"x"},initialSort:{property:"countryName",direction:"ascending"},selectionAppearance:"checkbox",dataArrived:function(){if(!this.$194r){this.$194r=true;this.selectRecord(this.data.find({countryName:"Albania"}))}}})
isc.ListGrid.create({ID:"lgHeaderSpans",width:400,height:224,headerHeight:65,dataSource:worldDS,autoFetchData:true,dataFetchMode:"local",canEdit:true,initialSort:{property:"countryName",direction:"ascending"},showGridSummary:true,fields:[{name:"countryName",title:"Country"},{name:"capital"},{name:"government"},{name:"population",summaryFunction:"sum",showGridSummary:true}],headerSpans:[{fields:["countryCode","countryName"],title:"Identification"},{fields:["capital","government","population"],title:"Government & Politics"}],dataArrived:function(){if(!this.$194r){this.$194r=true;this.selectRecord(this.data.find({countryName:"Albania"}))}}});isc.ListGrid.create({ID:"lgExpandingRows",width:500,height:300,alternateRecordStyles:true,dataSource:supplyCategory,expansionFieldImageShowSelected:false,autoFetchData:true,canExpandRecords:true,expansionMode:"related",detailDS:"supplyItem",expansionRelatedProperties:{border:"1px solid inherit",margin:5,autoFitMaxRecords:3,fields:[{name:"itemName"},{name:"SKU"},{name:"description"}]},dataArrived:function(){if(!this.$194r){this.$194r=true;this.$194s=true;this.expandRecord(this.data.get(1))}}});isc.ListGrid.create({ID:"lgGrouped",width:400,height:224,dataSource:worldDS,fields:[{name:"countryName",width:100},{name:"government"},{name:"population",width:100,summaryFunction:"sum",showGroupSummary:true}],canEdit:true,groupStartOpen:"all",groupByField:'government',autoFetchData:true,initialSort:{property:"countryName",direction:"ascending"},showGroupSummary:true,dataArrived:function(){if(!this.$194r){this.$194r=true;this.$194s=true;this.selectRecord(this.data.find({countryName:"Albania"}))}},groupByComplete:function(){if(this.$194s){this.$194s=false;var _1=this.originalData.find({countryName:"Albania"});this.selectRecord(_1)}}});isc.ListGrid.create({ID:"lgGroupedHeaderSummaries",width:400,height:224,dataSource:worldDS,fields:[{name:"countryName",width:100},{name:"population",width:90,summaryFunction:"sum",showGroupSummary:true}],canEdit:true,groupStartOpen:"all",groupByField:'government',autoFetchData:true,initialSort:{property:"countryName",direction:"ascending"},showGroupSummary:true,showGroupSummaryInHeader:true,dataArrived:function(){if(!this.$194r){this.$194r=true;this.$194s=true;this.selectRecord(this.data.find({countryName:"Albania"}))}},groupByComplete:function(){if(this.$194s){this.$194s=false;var _1=this.originalData.find({countryName:"Albania"});this.selectRecord(_1)}}});isc.TreeGrid.create({ID:"tgMultiColumn",width:400,height:300,dataSource:"employees",autoFetchData:true,nodeIcon:"icons/16/person.png",folderIcon:"icons/16/person.png",showOpenIcons:false,showDropIcons:false,closedIconSuffix:"",showSelectedIcons:true,dataProperties:{autoOpenRoot:true},fields:[{name:"Name"},{name:"Job"},{name:"Salary",formatCellValue:"isc.NumberUtil.format(value, '\u00A4,0.00')"}]});isc.HLayout.create({ID:"lgRowLayout1",membersMargin:20,members:[lgFilter,lgHeaderSpans,lgExpandingRows]});isc.HLayout.create({ID:"lgRowLayout2",membersMargin:20,members:[lgGrouped,lgGroupedHeaderSummaries,tgMultiColumn]});isc.VLayout.create({ID:"gridsPane",layoutMargin:10,membersMargin:20,top:60,autoDraw:false,members:[lgRowLayout1,lgRowLayout2]});return gridsPane}
isc.getTabsPane=function(){function getTabs(_2){var _1=[{title:_2?"Edit":null,icon:"[SKINIMG]actions/edit.png",iconSize:16,pane:isc.Img.create({autoDraw:true,width:48,height:48,src:"[SKINIMG]actions/edit.png"})},{title:_2?"Save":null,icon:"[SKINIMG]actions/save.png",iconSize:16,canEditTitle:true,canClose:true,pane:isc.Img.create({autoDraw:true,width:48,height:48,src:"[SKINIMG]actions/save.png"})},{title:_2?"Approve":null,icon:"[SKINIMG]actions/approve.png",iconSize:16,disabled:true,showDisabledIcon:true,pane:isc.Img.create({autoDraw:true,width:48,height:48,src:"[SKINIMG]actions/approve.png"})},{title:_2?"A Particularly Long Title":null,icon:"[SKINIMG]actions/filter.png",iconSize:16,minWidth:200,pane:isc.Img.create({autoDraw:true,width:48,height:48,src:"[SKINIMG]actions/filter.png"})}];return _1}
isc.TabSet.create({ID:"tabSetTop",tabBarPosition:"top",width:540,height:100,titleEditEvent:"doubleClick",tabs:getTabs(true)});isc.TabSet.create({ID:"tabSetBottom",tabBarPosition:"bottom",width:540,height:100,titleEditEvent:"doubleClick",tabs:getTabs(true)});isc.TabSet.create({ID:"tabSetLeft",tabBarPosition:"left",width:200,height:300,defaultTabHeight:24,tabs:getTabs()});isc.TabSet.create({ID:"tabSetRight",tabBarPosition:"right",width:200,height:300,showTabTitle:false,defaultTabHeight:24,tabs:getTabs()});isc.HLayout.create({ID:"tabsRowLayout1",membersMargin:20,members:[tabSetTop,tabSetBottom]});isc.HLayout.create({ID:"tabsRowLayout2",membersMargin:20,members:[tabSetLeft,tabSetRight]});isc.VLayout.create({ID:"tabsPane",layoutMargin:10,membersMargin:20,top:60,autoDraw:false,members:[tabsRowLayout1,tabsRowLayout2]});return tabsPane}
isc.getWidgetsPane=function(){isc.ListGrid.create({fields:[{type:"text",title:"System",name:"system"},{type:"text",title:"Monitor Name",name:"monitor"}],ID:"lgTest1",canEdit:true,editEvent:"click",autoDraw:false})
isc.HTMLFlow.create({ID:"statusReport",padding:5,border:"1px solid #808080",setNewStatus:function(_1){this.setContents(_1+": <span style='color:green;font-weight:bold'>Normal</span><br>")}})
isc.ImgButton.create({ID:"addButton",autoDraw:false,src:"[SKIN]actions/add.png",size:16,showFocused:false,showRollOver:false,showDown:false,click:"lgTest1.startEditingNew();return false;"});isc.ImgButton.create({ID:"removeButton",autoDraw:false,src:"[SKIN]actions/remove.png",size:16,showFocused:false,showRollOver:false,showDown:false,click:"lgTest1.removeSelectedData();return false;"});isc.DynamicForm.create({ID:"systemSelector",height:1,width:75,numCols:1,fields:[{name:"system",type:"select",width:150,showTitle:false,valueMap:["Development","Staging","Production"],defaultValue:"Development",change:"statusReport.setNewStatus(value)",click:"return false;"}]});isc.SectionStack.create({ID:"sectionStack1",sections:[{items:lgTest1,title:"Monitors",controls:[addButton,removeButton],expanded:true},{items:statusReport,title:"Status",controls:systemSelector,expanded:true}],visibilityMode:"multiple",animateSections:true,height:300,width:300,overflow:"hidden"})
statusReport.setNewStatus(systemSelector.getValue("system"));isc.ColorPicker.create({ID:"colorPicker",autoDismiss:false});isc.DateChooser.create({ID:"dateChooserNormal"});isc.DateChooser.create({ID:"dateChooserFiscal",showWeekChooser:true,showFiscalYearChooser:true});isc.Menu.create({ID:"menuTest",autoDraw:true,autoDismiss:false,autoDismissOnBlur:false,data:[{title:"New",keyTitle:"Ctrl+N",icon:"icons/16/document_plain_new.png"},{title:"Open",keyTitle:"Ctrl+O",icon:"icons/16/folder_out.png"},{isSeparator:true},{title:"Save",keyTitle:"Ctrl+S",icon:"icons/16/disk_blue.png"},{title:"Save As",icon:"icons/16/save_as.png"},{isSeparator:true},{title:"Recent Documents",icon:"icons/16/folder_document.png",submenu:[{title:"data.xml",checked:true},{title:"Component Guide.doc"},{title:"SmartClient.doc",checked:true},{title:"AJAX.doc"}]},{isSeparator:true},{title:"Export as...",icon:"icons/16/export1.png",submenu:[{title:"XML"},{title:"CSV"},{title:"Plain text"}]},{isSeparator:true},{title:"Print",enabled:false,keyTitle:"Ctrl+P",icon:"icons/16/printer3.png"}]});menuTest.show();isc.TabSet.create({ID:"tabSet1",tabBarPosition:"top",width:550,height:200,canEditTabTitles:true,titleEditEvent:"doubleClick",titleEditorTopOffset:2,tabs:[{title:"Blue",canClose:true,pane:isc.Img.create({autoDraw:false,width:48,height:48,src:"pieces/48/pawn_blue.png"})},{title:"Green",canClose:true,pane:isc.Img.create({autoDraw:false,width:48,height:48,src:"pieces/48/pawn_green.png"})},{title:"123-Yellow",canClose:true,ID:"validatedTab",pane:isc.Img.create({autoDraw:false,width:48,height:48,src:"pieces/48/pawn_yellow.png"})},{title:"Can't Change Me",canEditTitle:false,pane:isc.Img.create({autoDraw:false,width:48,height:48,src:"pieces/48/pawn_red.png"})}],titleChanged:function(_1,_2,_3){if(_3.ID=="validatedTab"&&(!_1||_1.substring(0,4)!="123-")){isc.warn("Tab title must start with the prefix \"123-\"");return false}}});isc.RichTextEditor.create({ID:"rteNormal",height:200});isc.HLayout.create({ID:"widgetsRowLayout1",membersMargin:20,members:[sectionStack1,dateChooserNormal,dateChooserFiscal,menuTest,colorPicker]});isc.HLayout.create({ID:"widgetsRowLayout2",membersMargin:20,members:[rteNormal]});isc.VLayout.create({ID:"widgetsPane",layoutMargin:10,membersMargin:20,top:60,autoDraw:false,members:[widgetsRowLayout1,tabSet1,widgetsRowLayout2]});return widgetsPane}
isc.getWindowsPane=function(){isc.defineClass("HelpCanvas","Canvas").addProperties({autoDraw:false,defaultWidth:300,padding:10,contents:"<b>Severity 1</b> - Critical problem<br>System is unavailable in production or is corrupting data, and the error severely impacts the user's operations.<br><br><b>Severity 2</b> - Major problem<br>An important function of the system is not available in production, and the user's operations are restricted.<br><br><b>Severity 3</b> - Minor problem<br>Inability to use a function of the system occurs, but it does not seriously affect the user's operations."});isc.Window.create({ID:"winNormal",title:"Auto-sizing window",autoSize:true,canDragReposition:true,canDragResize:true,items:[isc.HelpCanvas.create()]});isc.Window.create({ID:"winScrollbar",width:200,height:200,title:"Normal window",canDragReposition:true,canDragResize:true,items:[isc.HelpCanvas.create()]});isc.Window.create({ID:"winFooter",title:"Window with footer",width:300,height:200,canDragResize:true,showFooter:true,items:[isc.Label.create({contents:"Click me",align:"center",padding:5,height:"100%",click:function(){winFooter.setStatus("Click at: "+isc.EventHandler.getX()+", "+isc.EventHandler.getY())}})]});isc.MultiSortDialog.create({ID:"multiSort",fields:isc.getValues(animals.getFields()),initialSort:[{property:"Animal",direction:"ascending"}]});isc.MultiGroupDialog.create({ID:"multiGroup",fields:isc.getValues(animals.getFields())});isc.HLayout.create({ID:"winRowLayout1",membersMargin:20,members:[winNormal,winScrollbar,winFooter]});isc.HLayout.create({ID:"winRowLayout2",membersMargin:20,members:[multiSort,multiGroup]});isc.VLayout.create({ID:"windowsPane",layoutMargin:10,membersMargin:20,top:60,autoDraw:false,members:[winRowLayout1,winRowLayout2]});return windowsPane}
isc.getCalendarsPane=function(){var _1=new Date;var _2=_1.getDate()-_1.getDay();var _3=_1.getMonth();var _4=_1.getFullYear();var _5=[{eventId:1,name:"Meeting",description:"Shareholders meeting: monthly forecast report",startDate:new Date(_4,_3,_2+2,9),endDate:new Date(_4,_3,_2+2,14)},{eventId:2,name:"Realtor",description:"This canvas is styled by color settings on the CalendarEvent",startDate:new Date(_4,_3,_2+3,8),endDate:new Date(_4,_3,_2+3,10),headerTextColor:"black",headerBackgroundColor:"orange",headerBorderColor:"darkorange",textColor:"darkgreen",borderColor:"darkorange",backgroundColor:"#ffffcc"},{eventId:3,name:"Soccer",description:"Little league soccer finals",startDate:new Date(_4,_3,_2+4,13),endDate:new Date(_4,_3,_2+4,16)},{eventId:4,name:"Sleep",description:"Catch up on sleep",startDate:new Date(_4,_3,_2+4,5),endDate:new Date(_4,_3,_2+4,9)},{eventId:5,name:"Inspection",description:"This canvas is styled and disabled by custom styleName and canEdit settings on the CalendarEvent",startDate:new Date(_4,_3,_2+4,10),endDate:new Date(_4,_3,_2+4,12),styleName:"testStyle",canEdit:false},{eventId:6,name:"Airport run",description:"This canvas is styled by color settings on the CalendarEvent",startDate:new Date(_4,_3,_2+4,1),endDate:new Date(_4,_3,_2+4,3),headerTextColor:"white",headerBackgroundColor:"green",headerBorderColor:"green",textColor:"darkgreen",borderColor:"darkgreen",backgroundColor:"lightgreen"},{eventId:7,name:"Dinner Party",description:"Prepare elaborate meal for friends",startDate:new Date(_4,_3,_2+4,17),endDate:new Date(_4,_3,_2+4,20)},{eventId:8,name:"Poker",description:"Poker at Steve's house",startDate:new Date(_4,_3,_2+4,21),endDate:new Date(_4,_3,_2+4,23)},{eventId:9,name:"Meeting",description:"Board of directors meeting: discussion of next months strategy",startDate:new Date(_4,_3,_2+5,11),endDate:new Date(_4,_3,_2+5,15)}];isc.DataSource.create({ID:"eventDS",fields:[{name:"eventId",primaryKey:true,type:"sequence"},{name:"name"},{name:"description"},{name:"startDate",type:"datetime"},{name:"endDate",type:"datetime"}],clientOnly:true,testData:_5});var _1=new Date();var y=_1.getFullYear();var m=_1.getMonth();var d=_1.getDate();var _9=[{eventId:1,startDate:new Date(y,m,d,8,0),endDate:new Date(y,m,d,12,0),name:"Development Meeting",description:"This canvas is styled and disabled by custom styleName and canEdit settings on the CalendarEvent",lane:"charlesMadigen",styleName:"testStyle",canEdit:false},{eventId:2,startDate:new Date(y,m,d,14,0),endDate:new Date(y,m,d,18,0),name:"Mgmt Meeting",description:"Management Meeting",lane:"charlesMadigen"},{eventId:3,startDate:new Date(y,m,d,4,0),endDate:new Date(y,m,d,12,0),name:"Data Cleansing",description:"This canvas is styled by color settings on the CalendarEvent",lane:"tamaraKane",headerTextColor:"black",headerBackgroundColor:"orange",headerBorderColor:"darkorange",textColor:"darkgreen",borderColor:"darkorange",backgroundColor:"#ffffcc"},{eventId:4,startDate:new Date(y,m,d,7,30),endDate:new Date(y,m,d,12,0),name:"Data Migration",description:"Data Migration",lane:"tamaraKane"},{eventId:5,startDate:new Date(y,m,d,13,0),endDate:new Date(y,m,d,16,0),name:"Documentation",description:"Product documentation",lane:"tamaraKane"},{eventId:6,startDate:new Date(y,m,d,8,0),endDate:new Date(y,m,d,20,0),name:"Support",description:"Telephone Support",lane:"darcyFeeney"},{eventId:7,startDate:new Date(y,m,d,11,0),endDate:new Date(y,m,d,11,30),name:"Break",description:"Morning break",lane:"darcyFeeney"},{eventId:8,startDate:new Date(y,m,d,16,0),endDate:new Date(y,m,d,16,30),name:"Break",description:"Afternoon break",lane:"darcyFeeney"},{eventId:9,startDate:new Date(y,m,d,0,0),endDate:new Date(y,m,d,8,0),name:"Premium Support",description:"This canvas is styled by color settings on the CalendarEvent",lane:"kaiKong",headerTextColor:"white",headerBackgroundColor:"green",headerBorderColor:"green",textColor:"darkgreen",borderColor:"darkgreen",backgroundColor:"lightgreen"},{eventId:10,startDate:new Date(y,m,d,20,0),endDate:new Date(y,m,d,23,59),name:"Support",description:"Premium Support (overnight response)",lane:"kaiKong"},{eventId:11,startDate:new Date(y,m,d,8,0),endDate:new Date(y,m,d,12,0),name:"Development Meeting",description:"Development Meeting",lane:"shellyFewel"},{eventId:12,startDate:new Date(y,m,d,13,30),endDate:new Date(y,m,d,17,30),name:"Team Meeting",description:"Developer Team Meeting",lane:"shellyFewel"}];isc.Calendar.create({ID:"calDay",width:500,height:300,autoDraw:false,dataSource:eventDS,autoFetchData:true,showWeekView:false,showMonthView:false});isc.Calendar.create({ID:"calWeek",width:500,height:300,autoDraw:false,dataSource:eventDS,autoFetchData:true,showDayView:false,showMonthView:false});isc.Calendar.create({ID:"calMonth",width:500,height:300,autoDraw:false,dataSource:eventDS,autoFetchData:true,showDayView:false,showWeekView:false});var _10=[{name:"charlesMadigen",title:"Charles Madigen"},{name:"tamaraKane",title:"Tamara Kane"},{name:"darcyFeeney",title:"Darcy Feeney"},{name:"kaiKong",title:"Kai Kong"},{name:"shellyFewel",title:"Shelly Fewel"}];isc.Calendar.create({ID:"calDayLanes",width:400,height:300,autoDraw:false,data:_9,lanes:_10,showWeekView:false,showMonthView:false,showTimelineView:false,chosenDate:new Date(),showDayLanes:true,canEditLane:true});isc.Calendar.create({ID:"calCompact",width:400,height:220,autoDraw:false,showDayView:false,showWeekView:false,showOtherDays:false,showDayHeaders:false,showDateChooser:false,showDatePickerButton:false,showAddEventButton:false,disableWeekends:false,dataSource:eventDS,autoFetchData:true,canCreateEvents:false,getDayBodyHTML:function(_13,_14,_15,_16,_17){returnStr=_13.getDate()+" ";if(_14&&_14.length>0){returnStr+=this.imgHTML("icons/16/approved.png",16,16,"image")}
return returnStr},dayBodyClick:function(_13,_14,_15,_16,_17){var _11="";if(_14.length==0)_11="No events";for(var i=0;i<_14.length;i++){_11+=_14[i].name+"<BR/>"}
isc.say(_11,{title:_13.toUSShortDate()})}});isc.Calendar.create({ID:"calWorkDay",width:400,height:300,autoDraw:false,dataSource:eventDS,autoFetchData:true,showDayView:false,showMonthView:false,showWeekends:false,showWorkday:true,scrollToWorkday:true});isc.HLayout.create({ID:"calendarRowLayout1",membersMargin:20,members:[calDay,calWeek,calMonth]});isc.HLayout.create({ID:"calendarRowLayout2",membersMargin:20,members:[calDayLanes,calWorkDay,calCompact]});isc.VLayout.create({ID:"calendarsPane",layoutMargin:10,membersMargin:20,top:60,autoDraw:false,members:[calendarRowLayout1,calendarRowLayout2]});return calendarsPane}
isc.getTimelinesPane=function(){var _1=[{name:"charlesMadigen",title:"Charles Madigen",devGroup:"Managers"},{name:"tamaraKane",title:"Tamara Kane",devGroup:"Developers"},{name:"darcyFeeney",title:"Darcy Feeney",devGroup:"Managers"},{name:"kaiKong",title:"Kai Kong",devGroup:"Developers"},{name:"shellyFewel",title:"Shelly Fewel",devGroup:"Managers"},{name:"garretMonroe",title:"Garret Monroe",devGroup:"Developers"}];var _2=isc.DateUtil.getStartOf(new Date(2016,6,5),"W");var _3=_2.duplicate();_3.setDate(_3.getDate()+20);isc.Timeline.create({ID:"timeline1",height:451,width:500,autoDraw:false,startDate:_2,endDate:_3,dataSource:tasks,autoFetchData:true,lanes:_1,headerLevels:[{unit:"week"},{unit:"day"}],laneFields:[{name:"title",title:"Developer",minWidth:120,autoFitWidth:true}],canEditLane:true,showEventDescriptions:false,columnsPerPage:5});var _2=isc.DateUtil.getStartOf(new Date(2016,6,5),"W");var _3=_2.duplicate();_3.setDate(_3.getDate()+20);isc.Timeline.create({ID:"timelineGrouped",width:500,height:451,autoDraw:false,startDate:_2,endDate:_3,dataSource:"tasks",lanes:_1,headerLevels:[{unit:"week"},{unit:"day"}],canEditLane:true,showEventDescriptions:false,columnsPerPage:5,laneEventPadding:2,disableWeekends:false,canGroupLanes:true,laneGroupByField:"devGroup",laneFields:[{name:"title",title:"Developer",minWidth:120,autoFitWidth:true},{name:"devGroup",hidden:true}]});isc.HLayout.create({ID:"timelineRowLayout1",membersMargin:20,members:[timeline1,timelineGrouped]});isc.HLayout.create({ID:"timelineRowLayout2",membersMargin:20,members:[]});isc.VLayout.create({ID:"timelinesPane",layoutMargin:10,membersMargin:20,top:60,autoDraw:false,members:[timelineRowLayout1,timelineRowLayout2]});return timelinesPane}
isc._nonDebugModules=(isc._nonDebugModules!=null?isc._nonDebugModules:[]);isc._nonDebugModules.push('SkinUtil');isc.checkForDebugAndNonDebugModules();isc._moduleEnd=isc._SkinUtil_end=(isc.timestamp?isc.timestamp():new Date().getTime());if(isc.Log&&isc.Log.logIsInfoEnabled('loadTime'))isc.Log.logInfo('SkinUtil module init time: '+(isc._moduleEnd-isc._moduleStart)+'ms','loadTime');delete isc.definingFramework;if(isc.Page)isc.Page.handleEvent(null,"moduleLoaded",{moduleName:'SkinUtil',loadTime:(isc._moduleEnd-isc._moduleStart)});}else{if(window.isc&&isc.Log&&isc.Log.logWarn)isc.Log.logWarn("Duplicate load of module 'SkinUtil'.");}
