/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.auth;

import com.isomorphic.auth.AuthenticatedUser;
import com.isomorphic.auth.IAuthenticator;
import com.isomorphic.base.Base;
import com.isomorphic.base.IAutoConfigurable;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.ISCHttpServletRequest;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.ServletTools;
import com.isomorphic.util.DataTools;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileUpload;

public abstract class Authenticator
extends Base
implements IAutoConfigurable,
IAuthenticator {
    public Boolean basicAuth = new Boolean(false);
    public String superUserRole = "SuperUser";
    public List<String> clientSafeFields = new ArrayList<String>();
    public String usernameParameter = "username";
    public String passwordParameter = "password";
    protected Logger log = new Logger(this.getClass().getName());
    private String userKey = "user";
    private String realmKey = "isc.auth.realm";
    private String loginCounterKey = "loginCounter";
    private String initialTargetKey = "initialTarget";
    private String jsCallbackKey = "jsCallback";

    @Override
    public boolean containsCredentials(RequestContext context) throws Exception {
        return this.getSubmittedUsername(context) != null && this.getSubmittedPassword(context) != null;
    }

    public String getUsername(RequestContext context, Object user) throws Exception {
        return this.getSubmittedUsername(context);
    }

    protected String getSubmittedUsername(RequestContext context) throws Exception {
        if (this.basicAuth.booleanValue()) {
            List<String> authCreds = this.basicAuthCreds(context);
            if (authCreds != null) {
                return authCreds.get(0);
            }
            return null;
        }
        return this.getRequestParameter(this.usernameParameter, context);
    }

    protected String getSubmittedPassword(RequestContext context) throws Exception {
        if (this.basicAuth.booleanValue()) {
            List<String> authCreds = this.basicAuthCreds(context);
            if (authCreds != null) {
                return authCreds.get(1);
            }
            return null;
        }
        return this.getRequestParameter(this.passwordParameter, context);
    }

    protected List<String> basicAuthCreds(RequestContext context) throws Exception {
        String authHeader = context.request.getHeader("Authorization");
        if (authHeader == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(authHeader);
        if (st.hasMoreTokens()) {
            String basic = st.nextToken();
            if (basic.equalsIgnoreCase("Basic")) {
                String credentials = new String(DataTools.base64DecodeToBytes(st.nextToken()), "UTF-8");
                int p = credentials.indexOf(":");
                if (p != -1) {
                    String login = credentials.substring(0, p).trim();
                    String password = credentials.substring(p + 1).trim();
                    return DataTools.buildList(login, password);
                }
                throw new Exception("Invalid authentication token in Authorization header");
            }
            throw new Exception("Unsupported Authorization style '" + basic + "'");
        }
        return null;
    }

    protected String getRequestParameter(String parameterName, RequestContext context) {
        if (FileUpload.isMultipartContent((HttpServletRequest)context.request)) {
            Map queryParams = null;
            try {
                queryParams = ServletTools.parseQueryString(context.request.getQueryString());
            }
            catch (Exception e) {
                RequestContext.staticLog.error((Object)"Authenticator can't parse queryParams", e);
                return null;
            }
            return (String)queryParams.get(parameterName);
        }
        return context.request.getParameter(parameterName);
    }

    @Override
    public void logout(RequestContext context) throws Exception {
        this.clearAuthInfo(context);
    }

    @Override
    public Principal authenticate(RequestContext context) throws Exception {
        throw new Exception("Attempt to call authenticate() on base Authenticator class - invalid");
    }

    @Override
    public void setUser(RequestContext context, Principal user) throws Exception {
        this.setContextValue(context, this.userKey, user);
        if (context.request instanceof ISCHttpServletRequest) {
            context.request.setUserPrincipal(user);
        }
    }

    @Override
    public Principal getUser(RequestContext context) throws Exception {
        return (Principal)this.getContextValue(context, this.userKey);
    }

    @Override
    public void setRealm(RequestContext context, String realm) throws Exception {
        context.request.setAttribute(this.realmKey, realm);
    }

    @Override
    public String getRealm(RequestContext context) throws Exception {
        return (String)context.request.getAttribute(this.realmKey);
    }

    @Override
    public void setLoginCounter(RequestContext context, int counter) throws Exception {
        this.setContextValue(context, this.loginCounterKey, new Integer(counter));
    }

    @Override
    public int getLoginCounter(RequestContext context) throws Exception {
        Integer counter = (Integer)this.getContextValue(context, this.loginCounterKey);
        if (counter == null) {
            return 0;
        }
        return counter;
    }

    @Override
    public String getInitialTarget(RequestContext context) throws Exception {
        return (String)this.getContextValue(context, this.initialTargetKey);
    }

    @Override
    public void setInitialTarget(RequestContext context, String initialTarget) throws Exception {
        if (ServletTools.isRealtimeMessaging(initialTarget)) {
            return;
        }
        this.setContextValue(context, this.initialTargetKey, initialTarget);
    }

    @Override
    public String getInitialTargetJsCallback(RequestContext context) throws Exception {
        return (String)this.getContextValue(context, this.jsCallbackKey);
    }

    @Override
    public void setInitialTargetJsCallback(RequestContext context, String jsCallback) throws Exception {
        this.setContextValue(context, this.jsCallbackKey, jsCallback);
    }

    public void clearAuthInfo(RequestContext context) throws Exception {
        String authStateKey = (String)context.request.getAttribute(this.realmKey);
        if (authStateKey == null) {
            return;
        }
        if (context.session == null) {
            context.session = context.request.getSession(true);
        }
        context.session.setAttribute(authStateKey, null);
    }

    protected Object getContextValue(RequestContext context, String key) throws Exception {
        Map contextStore;
        String authStateKey = (String)context.request.getAttribute(this.realmKey);
        if (authStateKey == null) {
            throw new Exception("No context for getContextValue() with key: " + key + " (make sure your authenticator covers this URI: " + context.request.getRequestURI());
        }
        if (context.session == null) {
            context.session = context.request.getSession(true);
        }
        if ((contextStore = (Map)context.session.getAttribute(authStateKey)) == null) {
            return null;
        }
        return contextStore.get(key);
    }

    protected void setContextValue(RequestContext context, String key, Object value) throws Exception {
        HashMap<String, Object> contextStore;
        String authStateKey = (String)context.request.getAttribute(this.realmKey);
        if (authStateKey == null) {
            throw new Exception("No context for getContextValue() with key: " + key + " (make sure your authenticator covers this URI: " + context.request.getRequestURI());
        }
        if (context.session == null) {
            context.session = context.request.getSession(true);
        }
        if ((contextStore = (HashMap<String, Object>)context.session.getAttribute(authStateKey)) == null) {
            contextStore = new HashMap<String, Object>();
            context.session.setAttribute(authStateKey, contextStore);
        }
        contextStore.put(key, value);
    }

    @Override
    public Object getUserId(RequestContext context) throws Exception {
        Principal user = this.getUser(context);
        if (user != null) {
            return user.getName();
        }
        return null;
    }

    @Override
    public void track(RequestContext context) throws Exception {
    }

    @Override
    public List<String> getUserRoles(RequestContext context) throws Exception {
        Principal user = this.getUser(context);
        if (user instanceof Map) {
            return this.getUserRoles((Map)((Object)user));
        }
        if (user == null) {
            return new ArrayList<String>();
        }
        throw new Exception("Expected the user to implement Map, but got: " + user.getClass().getName());
    }

    @Override
    public List<String> getUserRoles(Map userData) throws Exception {
        return new ArrayList<String>();
    }

    @Override
    public String getSuperUserRole() {
        return this.superUserRole;
    }

    @Override
    public List<String> getClientSafeFields() {
        return this.clientSafeFields;
    }

    @Override
    public abstract AuthenticatedUser getUserById(Object var1) throws Exception;
}

