/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.ie;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.ie.InternetExplorerDriverEngine;
import org.openqa.selenium.ie.InternetExplorerDriverLogLevel;
import org.openqa.selenium.remote.service.DriverService;

public class InternetExplorerDriverService
extends DriverService {
    public static final String IE_DRIVER_EXE_PROPERTY = "webdriver.ie.driver";
    public static final String IE_DRIVER_LOGFILE_PROPERTY = "webdriver.ie.driver.logfile";
    public static final String IE_DRIVER_LOGLEVEL_PROPERTY = "webdriver.ie.driver.loglevel";
    public static final String IE_DRIVER_ENGINE_PROPERTY = "webdriver.ie.driver.engine";
    public static final String IE_DRIVER_HOST_PROPERTY = "webdriver.ie.driver.host";
    public static final String IE_DRIVER_EXTRACT_PATH_PROPERTY = "webdriver.ie.driver.extractpath";
    public static final String IE_DRIVER_SILENT_PROPERTY = "webdriver.ie.driver.silent";

    private InternetExplorerDriverService(File executable, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) throws IOException {
        super(executable, port, args, environment);
    }

    public static InternetExplorerDriverService createDefaultService() {
        return (InternetExplorerDriverService)((Builder)new Builder().usingAnyFreePort()).build();
    }

    public static class Builder
    extends DriverService.Builder<InternetExplorerDriverService, Builder> {
        private InternetExplorerDriverLogLevel logLevel;
        private InternetExplorerDriverEngine engineImplementation;
        private String host = null;
        private File extractPath = null;
        private Boolean silent = null;
        private Boolean forceCreateProcess = null;
        private String ieSwitches = null;

        public Builder withLogLevel(InternetExplorerDriverLogLevel logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        public Builder withEngineImplementation(InternetExplorerDriverEngine engineImplementation) {
            this.engineImplementation = engineImplementation;
            return this;
        }

        public Builder withHost(String host) {
            this.host = host;
            return this;
        }

        public Builder withExtractPath(File extractPath) {
            this.extractPath = extractPath;
            return this;
        }

        public Builder withSilent(Boolean silent) {
            this.silent = silent;
            return this;
        }

        @Override
        protected File findDefaultExecutable() {
            return InternetExplorerDriverService.findExecutable("IEDriverServer", InternetExplorerDriverService.IE_DRIVER_EXE_PROPERTY, "https://github.com/SeleniumHQ/selenium/wiki/InternetExplorerDriver", "http://selenium-release.storage.googleapis.com/index.html");
        }

        @Override
        protected ImmutableList<String> createArgs() {
            String silentProperty;
            String extractPathProperty;
            String hostProperty;
            String engineToUse;
            String level;
            String logFilePath;
            if (this.getLogFile() == null && (logFilePath = System.getProperty(InternetExplorerDriverService.IE_DRIVER_LOGFILE_PROPERTY)) != null) {
                this.withLogFile(new File(logFilePath));
            }
            if (this.logLevel == null && (level = System.getProperty(InternetExplorerDriverService.IE_DRIVER_LOGLEVEL_PROPERTY)) != null) {
                this.logLevel = InternetExplorerDriverLogLevel.valueOf(level);
            }
            if (this.engineImplementation == null && (engineToUse = System.getProperty(InternetExplorerDriverService.IE_DRIVER_ENGINE_PROPERTY)) != null) {
                this.engineImplementation = InternetExplorerDriverEngine.valueOf(engineToUse);
            }
            if (this.host == null && (hostProperty = System.getProperty(InternetExplorerDriverService.IE_DRIVER_HOST_PROPERTY)) != null) {
                this.host = hostProperty;
            }
            if (this.extractPath == null && (extractPathProperty = System.getProperty(InternetExplorerDriverService.IE_DRIVER_EXTRACT_PATH_PROPERTY)) != null) {
                this.extractPath = new File(extractPathProperty);
            }
            if (this.silent == null && (silentProperty = System.getProperty(InternetExplorerDriverService.IE_DRIVER_SILENT_PROPERTY)) != null) {
                this.silent = Boolean.valueOf(silentProperty);
            }
            ImmutableList.Builder argsBuilder = ImmutableList.builder();
            argsBuilder.add((Object)String.format("--port=%d", this.getPort()));
            if (this.getLogFile() != null) {
                argsBuilder.add((Object)String.format("--log-file=\"%s\"", this.getLogFile().getAbsolutePath()));
            }
            if (this.logLevel != null) {
                argsBuilder.add((Object)String.format("--log-level=%s", this.logLevel.toString()));
            }
            if (this.engineImplementation != null) {
                argsBuilder.add((Object)String.format("--implementation=%s", this.engineImplementation.toString()));
            }
            if (this.host != null) {
                argsBuilder.add((Object)String.format("--host=%s", this.host));
            }
            if (this.extractPath != null) {
                argsBuilder.add((Object)String.format("--extract-path=\"%s\"", this.extractPath.getAbsolutePath()));
            }
            if (this.silent != null && this.silent.equals(Boolean.TRUE)) {
                argsBuilder.add((Object)"--silent");
            }
            return argsBuilder.build();
        }

        @Override
        protected InternetExplorerDriverService createDriverService(File exe, int port, ImmutableList<String> args, ImmutableMap<String, String> environment) {
            try {
                return new InternetExplorerDriverService(exe, port, args, environment);
            }
            catch (IOException e) {
                throw new WebDriverException(e);
            }
        }
    }
}

