/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.server;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.net.MediaType;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.server.CommandHandler;

class ExceptionHandler
implements CommandHandler {
    private static final ErrorCodes ERRORS = new ErrorCodes();
    private static final BeanToJsonConverter toJson = new BeanToJsonConverter();
    private final Throwable exception;

    public ExceptionHandler(Throwable e) {
        if (e == null) {
            e = new WebDriverException("Unknown error");
        }
        if (e instanceof ExecutionException && e.getCause() != null) {
            e = e.getCause();
        }
        this.exception = e;
    }

    @Override
    public void execute(HttpRequest req, HttpResponse resp) {
        int code = ERRORS.toStatusCode(this.exception);
        String status = ERRORS.toState(code);
        HashMap<String, Serializable> toSerialise = new HashMap<String, Serializable>();
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("message", this.exception.getMessage());
        value.put("stacktrace", Throwables.getStackTraceAsString((Throwable)this.exception));
        value.put("error", status);
        toSerialise.put("status", Integer.valueOf(code));
        value.put("stackTrace", (String)Stream.of(this.exception.getStackTrace()).map(ste -> {
            HashMap<String, Object> line = new HashMap<String, Object>();
            line.put("fileName", ste.getFileName());
            line.put("lineNumber", ste.getLineNumber());
            line.put("className", ste.getClassName());
            line.put("methodName", ste.getMethodName());
            return line;
        }).collect(ImmutableList.toImmutableList()));
        toSerialise.put("value", value);
        byte[] bytes = toJson.convert(toSerialise).getBytes(StandardCharsets.UTF_8);
        resp.setStatus(500);
        resp.setHeader("Content-Type", MediaType.JSON_UTF_8.toString());
        resp.setHeader("Content-Length", String.valueOf(bytes.length));
        resp.setContent(bytes);
    }
}

