/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.servlet;

import com.isomorphic.base.Base;
import com.isomorphic.base.Config;
import com.isomorphic.base.Reflection;
import com.isomorphic.interfaces.IAssembly;
import com.isomorphic.interfaces.InterfaceProvider;
import com.isomorphic.io.ISCFile;
import com.isomorphic.log.Logger;
import com.isomorphic.servlet.ProxyHttpServletResponse;
import com.isomorphic.servlet.ProxyServletOutputStream;
import com.isomorphic.servlet.RequestContext;
import com.isomorphic.servlet.URLDecoder;
import com.isomorphic.util.DataTools;
import com.isomorphic.util.IOUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.net.URLCodec;

public class ServletTools
extends Base {
    public static final String SERVER_BASE_PATH = config.getString("webserverBasePath");
    public static final boolean devenv = config.getBoolean((Object)"devenv", false);
    private static Logger log = new Logger(ServletTools.class.getName());
    static final String httpDateFormat = "EEE, d MMM yyyy HH:mm:ss z";
    private static final int DEFAULT_FLUSH_BUFFER_SIZE = 1024;
    private static String spaces = "                ";
    static Map sampleUAs = new HashMap();
    static boolean recordURIs = false;
    static List staticFileURIs;
    public static final String EXPIRATION_PROP_BASE = "servlet.static.expiration.";
    private static final Pattern SSE_EOL_PATTERN;
    private static String htmlStart;
    private static String htmlEnd;

    public void delay(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String isc_delay = request.getParameter("isc_delay");
        if (isc_delay != null) {
            int delay = Integer.decode(isc_delay);
            log.debug(ServletTools.getCurrentRequestURI(request) + " - delaying send by: " + delay + "ms");
            Thread.currentThread();
            Thread.sleep(delay);
        }
    }

    public static Map parseQueryString(String queryString) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        if (queryString != null) {
            if (queryString.startsWith("?")) {
                queryString = queryString.substring(1);
            }
            URLCodec urlCodec = new URLCodec("UTF-8");
            List<String> paramPairs = DataTools.simpleSplit(queryString, "&");
            for (String paramPairString : paramPairs) {
                String value;
                String key;
                if (paramPairString == null || paramPairString.length() == 0) continue;
                int eqPos = paramPairString.indexOf(61);
                if (eqPos < 0) {
                    key = paramPairString;
                    value = null;
                } else {
                    key = paramPairString.substring(0, eqPos);
                    value = paramPairString.substring(eqPos + 1);
                }
                params.put(urlCodec.decode(key), value == null ? null : urlCodec.decode(value));
            }
        }
        return params;
    }

    public static boolean ignoreLog(HttpServletRequest request) {
        String queryString = request.getQueryString();
        return queryString != null && queryString.indexOf("isc_noLog") != -1;
    }

    public static String rpcContext(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString != null && queryString.indexOf("isc_rctx") != -1) {
            try {
                return (String)ServletTools.parseQueryString(queryString).get("isc_rctx");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Map paramsToMap(ServletRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration paramNames = request.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String name = (String)paramNames.nextElement();
            String[] values = request.getParameterValues(name);
            if (values.length == 0) {
                map.put(name, "");
                continue;
            }
            if (values.length == 1) {
                map.put(name, values[0]);
                continue;
            }
            map.put(name, Arrays.asList(values));
        }
        return map;
    }

    public static Map sessionToMap(HttpSession session) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Enumeration e = session.getAttributeNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            map.put(key, session.getAttribute(key));
        }
        return map;
    }

    public static String getFullURL(RequestContext context) {
        String URL2 = context.requestPath;
        String queryString = context.request.getQueryString();
        if (queryString != null) {
            URL2 = URL2 + "?" + queryString;
        }
        return URL2;
    }

    public static String getRequestRoot(ServletRequest request, Config config) throws UnknownHostException {
        StringBuffer requestRoot = new StringBuffer();
        String scheme = request.getScheme();
        requestRoot.append(scheme);
        requestRoot.append("://");
        String serverName = request.getServerName();
        if (config.getBoolean((Object)"inet.useIPAddress", false)) {
            serverName = InetAddress.getByName(serverName).toString();
        }
        requestRoot.append(serverName);
        int port = request.getServerPort();
        if (!(port == 80 && scheme.equals("http") || port == 443 && scheme.equals("https"))) {
            requestRoot.append(":");
            requestRoot.append(port);
        }
        return requestRoot.toString();
    }

    public static String buildGetRequestFromMap(Map data) {
        String result = "";
        if (data.size() < 1) {
            return result;
        }
        result = result + "?";
        Iterator dataEnum = data.keySet().iterator();
        while (dataEnum.hasNext()) {
            String dataKey = (String)dataEnum.next();
            result = result + URLEncoder.encode(dataKey) + "=" + URLEncoder.encode(data.get(dataKey).toString());
            if (!dataEnum.hasNext()) continue;
            result = result + "&";
        }
        return result;
    }

    public static String addTimestamp(String url) {
        String result = url;
        result = "'" + result;
        result = result.indexOf("?") == -1 ? result + "?" : result + "&";
        result = result + "ts=' + new Date().getTime()";
        return result;
    }

    public static String addQueryParameter(String url, String name, Object value) {
        if (url == null || name == null) {
            return null;
        }
        url = url + (url.indexOf("?") == -1 ? "?" : "&") + name + "=" + (value != null ? value.toString() : "");
        return url;
    }

    public static String getRealPath(Servlet servlet, HttpServletRequest request) {
        return servlet.getServletConfig().getServletContext().getRealPath(request.getRequestURI());
    }

    public static InputStream loadWebRootFile(String path) throws IOException {
        return DataTools.inputStreamForFilename(DataTools.makePathAbsolute(path));
    }

    public static void include(RequestContext c, String target) throws ServletException, IOException {
        ServletTools.include(c.servletContext, (ServletRequest)c.request, (ServletResponse)c.response, c.out(), target);
    }

    public static void include(Servlet serv, ServletRequest request, ServletResponse response, Writer out, String target) throws ServletException, IOException {
        ServletTools.include(serv.getServletConfig().getServletContext(), request, response, target);
    }

    public static void include(ServletContext servletContext, ServletRequest request, ServletResponse response, Writer out, String target) throws ServletException, IOException {
        out.flush();
        ServletTools.include(servletContext, request, response, target);
    }

    public static void include(Servlet serv, ServletRequest request, ServletResponse response, String target) throws ServletException, IOException {
        ServletTools.include(serv.getServletConfig().getServletContext(), request, response, target);
    }

    public static void include(ServletContext servletContext, ServletRequest request, ServletResponse response, String target) throws ServletException, IOException {
        log.info((Object)"include() with target", target);
        servletContext.getRequestDispatcher(target).include(request, response);
    }

    public static void forward(ServletContext servletContext, ServletRequest request, ServletResponse response, String target) throws ServletException, IOException {
        log.info((Object)"forward()- passing handling to target servlet", target);
        servletContext.getRequestDispatcher(target).forward(request, response);
    }

    public static void forward(RequestContext context, String target) throws ServletException, IOException {
        ServletTools.forward(context.servletContext, (ServletRequest)context.request, (ServletResponse)context.response, target);
    }

    public static void bufferedDoFilter(ServletContext servletContext, FilterChain chain, HttpServletRequest request, HttpServletResponse response, OutputStream out, String creator) throws ServletException, IOException {
        ByteArrayOutputStream wrapBuf = new ByteArrayOutputStream();
        ProxyHttpServletResponse wrapResponse = new ProxyHttpServletResponse(response, new ProxyServletOutputStream(wrapBuf), creator);
        chain.doFilter((ServletRequest)request, (ServletResponse)wrapResponse);
        try {
            wrapResponse.flushBuffer();
        }
        catch (Exception exception) {
            // empty catch block
        }
        wrapBuf.flush();
        wrapBuf.writeTo(out);
        try {
            out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void bufferedInclude(ServletContext servletContext, String target, HttpServletRequest request, HttpServletResponse response, OutputStream out, String creator) throws ServletException, IOException {
        ByteArrayOutputStream wrapBuf = new ByteArrayOutputStream();
        ProxyHttpServletResponse wrapResponse = new ProxyHttpServletResponse(response, new ProxyServletOutputStream(wrapBuf), creator);
        servletContext.getRequestDispatcher(target).include((ServletRequest)request, (ServletResponse)wrapResponse);
        try {
            wrapResponse.flushBuffer();
        }
        catch (Exception exception) {
            // empty catch block
        }
        wrapBuf.flush();
        wrapBuf.writeTo(out);
        try {
            out.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void sendJSRedirect(Writer out, String target) {
        log.info((Object)"JSRedirect to", target);
        try {
            out.write("<SCRIPT>window.location.replace('" + target + "');</SCRIPT>\n");
        }
        catch (IOException ioe) {
            log.error((Object)"IOException trying to write out JS Redirect", ioe);
        }
    }

    public static void sendTopLevelJSRedirect(Writer out, String target) {
        log.info((Object)"TopLevelJSRedirect to", target);
        try {
            out.write("<SCRIPT>parent.window.location.replace('" + target + "');</SCRIPT>\n");
        }
        catch (IOException ioe) {
            log.error((Object)"IOException trying to write out JS Redirect", ioe);
        }
    }

    public static String adjustForContextPath(String path, HttpServletRequest request) {
        String contextPath = request.getContextPath();
        return ISCFile.canonicalizePath(contextPath + path);
    }

    public static void sendJSReload(Writer out) {
        try {
            out.write("<SCRIPT>window.location.reload();</SCRIPT>\n");
        }
        catch (IOException ioe) {
            log.error((Object)"IOException trying to write out JS Reload block", ioe);
        }
    }

    public static void sendJSRedirectNoQuote(Writer out, String target) {
        log.info((Object)"JSRedirectNoQuote to", target);
        try {
            out.write("<SCRIPT>window.location.replace(" + target + ");</SCRIPT>\n");
        }
        catch (IOException ioe) {
            log.error((Object)"IOException trying to write out JS Redirect", ioe);
        }
    }

    public static void logAndRedirect(Throwable t, Writer out, String redirectTarget) {
        log.error((Object)"Top-level exception", t);
        ServletTools.sendJSRedirect(out, redirectTarget);
    }

    public static Cookie getCookie(String targetCookieName, HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (int ii = 0; ii < cookies.length; ++ii) {
                String currentCookieName = cookies[ii].getName();
                if (!cookies[ii].getName().equals(targetCookieName)) continue;
                if (cookies[ii].getValue().equals("__null__")) {
                    return null;
                }
                return cookies[ii];
            }
        }
        return null;
    }

    public static void clearCookie(String cookieName, RequestContext context, String path, String domain) {
        ServletTools.clearCookie(ServletTools.getCookie(cookieName, (HttpServletRequest)context.request), context, path, domain);
    }

    public static void clearCookie(Cookie cookie, RequestContext context, String path, String domain) {
        if (cookie == null) {
            return;
        }
        cookie.setMaxAge(0);
        if (path != null) {
            cookie.setPath(path);
        }
        if (domain != null) {
            cookie.setDomain(domain);
        }
        context.response.addCookie(cookie);
    }

    public static String getCookieValue(String targetCookieName, HttpServletRequest request) {
        Cookie theCookie = ServletTools.getCookie(targetCookieName, request);
        if (theCookie == null) {
            return null;
        }
        return theCookie.getValue();
    }

    public static Cookie setCookie(RequestContext context, String name, String value, int maxAge) {
        return ServletTools.setCookie(context, name, value, null, null, maxAge, false);
    }

    public static Cookie setCookie(RequestContext context, String name, String value, String path) {
        return ServletTools.setCookie(context, name, value, path, null, -1, false);
    }

    public static Cookie setCookie(RequestContext context, String name, String value, String path, String domain, int maxAge) {
        return ServletTools.setCookie(context, name, value, path, domain, -1, false);
    }

    public static Cookie setCookie(RequestContext context, String name, String value, String path, String domain, int maxAge, boolean httpOnly) {
        return ServletTools.setCookie(context, name, value, path, domain, maxAge, httpOnly, false, null);
    }

    public static Cookie setCookie(RequestContext context, String name, String value, String path, String domain, int maxAge, boolean httpOnly, boolean secure, String sameSite) {
        log.debug("setting cookie '" + name + "' to: '" + value + "'");
        Cookie cookie = new Cookie(name, value);
        if (path == null) {
            path = "/";
        }
        cookie.setPath(path);
        if (maxAge != -1) {
            String maxAgeWarning = "setCookie() called with maxAge: " + maxAge + ".  Some (primarily older) servlet containers do not automatically emit an Expires parameter on such cookies. If this is true of your container, the maxAge will likely be ignored by Internet Explorer clients.";
            if (context.servletContext != null && context.servletContext.getMajorVersion() >= 3) {
                log.debug(maxAgeWarning);
            } else {
                log.warn(maxAgeWarning);
            }
            cookie.setMaxAge(maxAge);
        }
        if (domain != null) {
            log.debug("setting domain to: " + domain + " for cookie: " + name);
            if (devenv && !context.request.getServerName().endsWith(domain)) {
                log.warn("request to set cookie: " + name + " to: " + value + " for domain: " + domain + ", but request hostname (" + context.request.getServerName() + ") doesn't match - cookie will be ignored by browser");
            }
            cookie.setDomain(domain);
        }
        cookie.setSecure(secure);
        if (!secure && sameSite == null) {
            sameSite = "Lax";
        }
        boolean useHeader = false;
        if (sameSite != null) {
            try {
                Reflection.invokeMethod(cookie, "setSameSite", sameSite);
            }
            catch (Exception e) {
                useHeader = true;
            }
        }
        if (httpOnly) {
            try {
                Reflection.invokeMethod(cookie, "setHttpOnly", true);
            }
            catch (Exception e) {
                useHeader = true;
            }
        }
        if (useHeader) {
            String expiresValue = null;
            if (maxAge != -1) {
                SimpleDateFormat cookieDateFormat = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US);
                cookieDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                expiresValue = maxAge == 0 ? cookieDateFormat.format(new Date(1000L)) : cookieDateFormat.format(new Date(System.currentTimeMillis() + (long)maxAge * 1000L));
            }
            context.response.addHeader("Set-Cookie", cookie.getName() + "=\"" + cookie.getValue() + "\";" + (domain != null ? " Domain=" + cookie.getDomain() + ";" : "") + " Path=" + cookie.getPath() + ";" + (maxAge != -1 ? " Max-Age=" + Integer.toString(cookie.getMaxAge()) + ";" : "") + (maxAge != -1 ? " Expires=" + expiresValue + ";" : "") + (secure ? " Secure;" : "") + (sameSite != null ? " SameSite=" + sameSite + ";" : "") + (httpOnly ? " HttpOnly;" : ""));
            return cookie;
        }
        context.response.addCookie(cookie);
        return cookie;
    }

    public static boolean browserIsNav4(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        return userAgent != null && DataTools.contains(userAgent, "Mozilla/4") && !DataTools.contains(userAgent, "MSIE") && !DataTools.contains(userAgent, "Opera");
    }

    public static boolean browserIsMSIE(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        return userAgent != null && DataTools.contains(userAgent, "MSIE");
    }

    public static boolean browserIsMoz(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        return userAgent != null && DataTools.contains(userAgent, "Gecko/");
    }

    public static boolean browserIsSafari(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        return userAgent != null && DataTools.contains(userAgent, "Safari");
    }

    public static String browserShortName(HttpServletRequest request) {
        if (ServletTools.browserIsMSIE(request)) {
            return "MSIE";
        }
        if (ServletTools.browserIsNav4(request)) {
            return "Nav4";
        }
        if (ServletTools.browserIsMoz(request)) {
            return "Moz (Gecko)";
        }
        if (ServletTools.browserIsSafari(request)) {
            return "Safari";
        }
        return "Unsupported";
    }

    public static boolean browserIsSupported(HttpServletRequest request) {
        String userAgent = request.getHeader("User-Agent");
        return ServletTools.browserIsSupported(userAgent);
    }

    public static boolean browserIsSupported(String userAgent) {
        int mozIndex = userAgent.indexOf("Mozilla/");
        if (mozIndex == -1) {
            return false;
        }
        int msieIndex = userAgent.indexOf("MSIE");
        if (msieIndex > -1) {
            if (DataTools.contains(userAgent, "Opera")) {
                return false;
            }
            if (DataTools.contains(userAgent, "Macintosh")) {
                return false;
            }
            int afterMSIE = msieIndex + "MSIE ".length();
            float version = ServletTools.parseVersion(userAgent.substring(afterMSIE));
            return (double)version > 4.0;
        }
        int afterMoz = mozIndex + "Mozilla/".length();
        float version = ServletTools.parseVersion(userAgent.substring(afterMoz));
        return (double)version >= 4.5;
    }

    public static float parseVersion(String ua) {
        int i;
        if (ua == null) {
            return Float.NaN;
        }
        boolean gotDecimalPoint = false;
        for (i = 0; i < ua.length(); ++i) {
            char theChar = ua.charAt(i);
            if (theChar == '.') {
                if (gotDecimalPoint) break;
                gotDecimalPoint = true;
                continue;
            }
            if (theChar < '0' || theChar > '9') break;
        }
        try {
            return Float.valueOf(ua.substring(0, i)).floatValue();
        }
        catch (NumberFormatException e) {
            return Float.NaN;
        }
    }

    public static String mimeTypeForContext(RequestContext context) throws Exception {
        return DataTools.mimeTypeForFileName(context.requestPath);
    }

    public static String defaultMimeType() throws Exception {
        return config.getString("servlet.defaultMimeType");
    }

    public static void enableCompression(RequestContext context) throws Exception {
        String target = context.request.getParameter("target");
        ServletTools.enableCompression(context, target);
    }

    public static void enableCompression(RequestContext context, String target) throws Exception {
        log.info("Enabling compression for target: " + target);
        context.setNoCacheHeaders();
        ServletTools.setCompressionReadyCookie(context);
        context.response.setContentType("text/html; charset=UTF-8");
        context.compressIfPossible();
        ServletTools.sendJSRedirect(context.out(), target);
        context.completeResponse();
    }

    public static boolean compressionEnabled() {
        return config.getBoolean((Object)"servlet.compress", false);
    }

    public static boolean jscriptContentEncodingCompressionEnabled() {
        return ServletTools.compressionEnabled() && config.getBoolean((Object)"servlet.compress.jscriptContentEncoding", false);
    }

    public static boolean jscriptNav4JarCompressionEnabled() {
        return ServletTools.compressionEnabled() && config.getBoolean((Object)"servlet.compress.jscriptNav4Jar", false);
    }

    public static boolean browserClaimsGZSupport(HttpServletRequest request) {
        String viaHeader = request.getHeader("via");
        if (viaHeader != null) {
            log.debug("Client sent Via header: " + viaHeader);
            int indexHttp10 = viaHeader.indexOf("1.0");
            if (indexHttp10 != -1 && config.getBoolean((Object)"servlet.disableCompressionIfProxyChainContainsHTTP10", true)) {
                String encodingHeader = request.getHeader("Accept-Encoding");
                log.info("Disallowing compression for request whose proxy chain contains an HTTP 1.0 proxy. Via header: " + viaHeader + " Accept-Encoding header: " + (encodingHeader == null ? "not set" : encodingHeader));
                return false;
            }
        }
        if (config.getBoolean((Object)"servlet.useCompressionThroughProxies", false) && (ServletTools.browserIsMSIE(request) || ServletTools.browserIsNav4(request) || ServletTools.browserIsMoz(request))) {
            return true;
        }
        String encodingHeader = request.getHeader("Accept-Encoding");
        return encodingHeader != null && encodingHeader.indexOf("gzip") != -1;
    }

    public static boolean compressionWorksForMimeType(RequestContext context, String mimeType) {
        if (mimeType == null) {
            return false;
        }
        if (DataTools.contains(mimeType, "zip")) {
            return false;
        }
        if (DataTools.contains(mimeType, "css") && (ServletTools.browserIsNav4((HttpServletRequest)context.request) || ServletTools.browserIsMSIE((HttpServletRequest)context.request) && (double)ServletTools.IEBrowserVersion((HttpServletRequest)context.request).floatValue() <= 5.5)) {
            return false;
        }
        if (!DataTools.contains(mimeType, "javascript")) {
            return true;
        }
        if (ServletTools.browserIsNav4((HttpServletRequest)context.request)) {
            return false;
        }
        return ServletTools.IEReadyForCompressedJS(context);
    }

    public static boolean alwaysCompressMimeType(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        String lcMimeType = mimeType.toLowerCase();
        List alwaysCompressMimeTypes = config.getList("compression.alwaysCompressMimeTypes");
        for (String compressableMimeType : alwaysCompressMimeTypes) {
            if (lcMimeType.indexOf(compressableMimeType.toLowerCase()) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean compressionEnabledForMimeType(String mimeType) {
        return ServletTools.compressionEnabledForMimeType(mimeType, null);
    }

    public static boolean compressionEnabledForMimeType(String mimeType, List overrides) {
        if (mimeType == null) {
            return false;
        }
        String lcMimeType = mimeType.toLowerCase();
        if (overrides != null) {
            for (String compressableMimeType : overrides) {
                if (lcMimeType.indexOf(compressableMimeType.toLowerCase()) == -1) continue;
                return true;
            }
            return false;
        }
        if (ServletTools.alwaysCompressMimeType(mimeType)) {
            return true;
        }
        List compressableMimeTypes = config.getList("compression.compressableMimeTypes");
        if (compressableMimeTypes == null) {
            compressableMimeTypes = config.getList("compressionFilter.compressableMimeTypes");
        }
        if (compressableMimeTypes == null) {
            log.debug("compression.compressableMimeTypes is null, assuming compression enabled for all mime types.");
            return true;
        }
        for (String compressableMimeType : compressableMimeTypes) {
            if (lcMimeType.indexOf(compressableMimeType.toLowerCase()) == -1) continue;
            return true;
        }
        return false;
    }

    public static boolean compressionWorksForContext(RequestContext context, Logger compressionLog) {
        if (ServletTools.isRealtimeMessaging(context)) {
            compressionLog.debug("Realtime messaging responses are not compressable - not compresssing");
            return false;
        }
        return true;
    }

    public static boolean isRealtimeMessaging(RequestContext context) {
        return ServletTools.isRealtimeMessaging(context.requestPath);
    }

    public static boolean isRealtimeMessaging(String URI2) {
        if (URI2 == null) {
            return false;
        }
        return URI2.contains(config.getString("isomorphicPathRootRelative", "isomorphic") + "/messaging") || URI2.contains(config.getString("messaging.websocket.URI", "/isomorphic/websocket")) || URI2.contains("sc/messaging");
    }

    public static void setCompressionReadyCookie(RequestContext context) throws Exception {
        ServletTools.setCookie(context, "isc_cState", "ready", "/");
    }

    public static boolean compressionReadyCookieIsSet(RequestContext context) {
        String cookieValue = ServletTools.getCookieValue("isc_cState", (HttpServletRequest)context.request);
        return cookieValue != null && !cookieValue.equals("__null__");
    }

    public static boolean IEReadyForCompressedJS(RequestContext context) {
        if (!ServletTools.browserIsMSIE((HttpServletRequest)context.request)) {
            return true;
        }
        if (!ServletTools.jscriptContentEncodingCompressionEnabled()) {
            return false;
        }
        if (!ServletTools.browserClaimsGZSupport((HttpServletRequest)context.request)) {
            return false;
        }
        if (ServletTools.IEIsOlderThanIE6SP2((HttpServletRequest)context.request)) {
            return ServletTools.compressionReadyCookieIsSet(context);
        }
        return true;
    }

    public static boolean IEIsOlderThanIE6SP2(HttpServletRequest request) {
        String UA = request.getHeader("User-Agent");
        if (UA == null) {
            return true;
        }
        try {
            Float browserVersion = ServletTools.IEBrowserVersion(UA);
            Float platformVersion = ServletTools.IEPlatformVersion(UA);
            Float sixZero = new Float("6.0");
            Float fiveOne = new Float("5.1");
            if (browserVersion.compareTo(sixZero) == -1 || platformVersion.compareTo(fiveOne) == -1) {
                return true;
            }
            if (browserVersion.compareTo(sixZero) == 0 && platformVersion.compareTo(fiveOne) == 0) {
                return UA.indexOf("SV1") == -1;
            }
        }
        catch (Exception e) {
            log.warn("Couldn't parser browser or platform version in UA: " + UA);
            return true;
        }
        return false;
    }

    public static Float IEBrowserVersion(HttpServletRequest request) {
        return ServletTools.IEBrowserVersion(request.getHeader("User-Agent"));
    }

    public static Float IEBrowserVersion(String UA) {
        int start = UA.indexOf("MSIE");
        UA = UA.substring(start + 5);
        int end = UA.indexOf(";");
        String browserVersion = UA = UA.substring(0, end);
        while (browserVersion.length() > 0) {
            try {
                return new Float(browserVersion);
            }
            catch (NumberFormatException nfe) {
                browserVersion = browserVersion.substring(0, browserVersion.length() - 1);
            }
        }
        return new Float(4.0f);
    }

    public static Float IEPlatformVersion(HttpServletRequest request) {
        return ServletTools.IEPlatformVersion(request.getHeader("User-Agent"));
    }

    public static Float IEPlatformVersion(String UA) {
        int start = UA.indexOf("Windows NT");
        if (start == -1) {
            return new Float(3.0f);
        }
        int end = (UA = UA.substring(start + 11)).indexOf(";");
        if (end == -1) {
            end = UA.indexOf(")");
        }
        String platformVersion = UA = UA.substring(0, end);
        return new Float(platformVersion);
    }

    public static boolean IENeedsToSeeACompressedPage(RequestContext context) {
        return ServletTools.browserIsMSIE((HttpServletRequest)context.request) && ServletTools.browserClaimsGZSupport((HttpServletRequest)context.request) && ServletTools.jscriptContentEncodingCompressionEnabled() && !ServletTools.IEReadyForCompressedJS(context);
    }

    public static boolean IEReadyForCompressedJSOrRedirect(RequestContext context) throws Exception {
        if (ServletTools.IENeedsToSeeACompressedPage(context)) {
            String compressionEnabler = config.getString("servlet.compress.enablerURL");
            if (compressionEnabler == null) {
                throw new Exception("Must enable compression, but compression.enabler is undefined!");
            }
            context.setNoCacheHeaders();
            log.debug("sending client to compressionEnabler: " + compressionEnabler);
            ServletTools.sendJSRedirect(context.out(), compressionEnabler + "?target=" + URLEncoder.encode(ServletTools.getFullURL(context)));
            return false;
        }
        return true;
    }

    public static String getBrowserSummary(RequestContext context) {
        return ServletTools.browserShortName((HttpServletRequest)context.request) + (ServletTools.browserClaimsGZSupport((HttpServletRequest)context.request) ? " with" : " WITHOUT") + " Accept-Encoding header" + (ServletTools.browserIsMSIE((HttpServletRequest)context.request) && ServletTools.IEReadyForCompressedJS(context) ? ", ready for compressed JS" : "");
    }

    public static void markContextAsIncluded(RequestContext context) {
        context.request.setAttribute("_isIncluded", new Object());
    }

    public static boolean contextIsIncluded(RequestContext context) {
        if (context.request.getAttribute("javax.servlet.include.request_uri") != null) {
            return true;
        }
        if (context.request.getAttribute("javax.servlet.forward.request_uri") != null) {
            return true;
        }
        if (context.response.isCommitted()) {
            return true;
        }
        return context.request.getAttribute("_isIncluded") != null;
    }

    public static void jsInclude(RequestContext context, String jsFile) throws IOException {
        ServletTools.jsInclude(context, SERVER_BASE_PATH, jsFile, null);
    }

    public static void jsInclude(RequestContext context, String jsFile, String queryString) throws IOException {
        ServletTools.jsInclude(context, SERVER_BASE_PATH, jsFile, queryString);
    }

    public static void jsInclude(RequestContext context, String webserverBasePath, String jsFile, String queryString) throws IOException {
        String fullPath;
        String queryAppend = "";
        if (queryString != null && queryString.length() > 0) {
            queryAppend = queryString.startsWith("?") ? queryString : "?" + queryString;
        }
        String string = fullPath = jsFile.startsWith("/") ? jsFile : webserverBasePath + jsFile;
        if (ServletTools.browserIsNav4((HttpServletRequest)context.request) && ServletTools.browserClaimsGZSupport((HttpServletRequest)context.request) && ServletTools.jscriptNav4JarCompressionEnabled()) {
            String filename = new File(jsFile).getName();
            context.out().write("<SCRIPT ARCHIVE=" + fullPath + ".jar" + queryAppend + " src=" + filename + "></SCRIPT>\n");
        } else {
            context.out().write("<SCRIPT SRC=" + fullPath + queryAppend + "></SCRIPT>\n");
        }
    }

    public static boolean usingContainerIO() {
        return DataTools.isContainerIOPath(config.getPath("webRoot"));
    }

    public static String stripPathComponents(String path, int numToStrip) {
        if (numToStrip <= 0) {
            return path;
        }
        int index = 0;
        for (int i = 0; i < numToStrip; ++i) {
            if ((index = path.indexOf(47, index + 1)) != -1) continue;
            log.warn((Object)("Less than " + numToStrip + " path components, returning unchanged path"), path);
            return path;
        }
        return path.substring(index);
    }

    public static void recordStaticFileURIs() {
        staticFileURIs = new ArrayList();
        recordURIs = true;
    }

    public static List getStaticFileURIs() {
        List l = staticFileURIs;
        recordURIs = false;
        staticFileURIs = null;
        return l;
    }

    public static void sendFileForRequestPath(String requestPath, RequestContext context) throws ServletException, IOException {
        if (requestPath.startsWith("/NASApp/extranet")) {
            requestPath = requestPath.substring(16);
        }
        Logger.download.debug("Request for static file: " + context.requestPath);
        String filePath = null;
        try {
            String assembledFileName = null;
            if (InterfaceProvider.exists("IAssembler")) {
                IAssembly fileAssembler = (IAssembly)InterfaceProvider.load("IAssembly");
                assembledFileName = fileAssembler.assembleFile(requestPath);
            }
            filePath = assembledFileName != null ? assembledFileName : config.getPath("webRoot") + requestPath;
            ServletTools.sendStaticFile(context, filePath);
        }
        catch (Exception e) {
            Logger.download.error((Object)("Problem sending static file: requestPath: " + requestPath + ", filePath: " + filePath), e);
        }
    }

    public static ISCFile getStaticFile(String filePath) throws ServletException, IOException {
        ISCFile file = ISCFile.newInstance(filePath);
        if (file.isDirectory()) {
            filePath = filePath + "/index.html";
            file = ISCFile.newInstance(filePath);
        }
        return file;
    }

    public static void sendStaticFile(RequestContext context, String filePath) throws ServletException, IOException {
        ServletTools.sendStaticFile(context, filePath, null);
    }

    public static void sendStaticFile(RequestContext context, String filePath, String extension) throws ServletException, IOException {
        ServletTools.sendStaticFile(context, filePath, extension, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void sendStaticFile(RequestContext context, String filePath, String extension, Map expiresOverrides, Map charsetMap, boolean noExpires) throws ServletException, IOException {
        InputStream in = null;
        try {
            int contentLength;
            String cgetHeader;
            String mimeType;
            ServletOutputStream output;
            ISCFile file = ISCFile.newInstance(filePath);
            String fileName = file.getCanonicalPath();
            if (recordURIs) {
                staticFileURIs.add(DataTools.buildMap("URI", context.request.getRequestURI(), "queryString", context.request.getQueryString()));
            }
            Logger.download.debug("request for file: " + fileName);
            if (file.isDirectory()) {
                String canonicalizedFilePath = filePath.endsWith("/") ? filePath : filePath + "/";
                List welcomeFileList = config.getList("servlet.static.welcomeFileList");
                for (int i = 0; i < welcomeFileList.size(); ++i) {
                    String welcomeFile = (String)welcomeFileList.get(i);
                    String newFilePath = canonicalizedFilePath + welcomeFile;
                    file = ISCFile.newInstance(newFilePath);
                    if (!file.exists()) continue;
                    filePath = newFilePath;
                    break;
                }
            }
            if (!file.exists()) {
                String fileNotFound = "File " + filePath + " not found, sending 404";
                if (devenv) {
                    Logger.download.warn(fileNotFound);
                } else {
                    Logger.download.info(fileNotFound);
                }
                context.response.sendError(404);
                return;
            }
            long fileLength = file.length();
            long lastMod = file.lastModified();
            try {
                output = context.response.getOutputStream();
            }
            catch (IllegalStateException ise) {
                IOUtil.copyCharacterStreams(file.getReader(), (Writer)context.response.getWriter(), false);
                if (in == null) return;
                try {
                    in.close();
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            lastMod = lastMod / 1000L * 1000L;
            if (extension == null) {
                int lastDotIndex = filePath.lastIndexOf(".");
                String string = extension = lastDotIndex != -1 ? filePath.substring(lastDotIndex + 1) : "";
            }
            if ((mimeType = DataTools.mimeTypeForExtension(extension)) == null) {
                mimeType = ServletTools.defaultMimeType();
            }
            if ((cgetHeader = context.request.getHeader("If-Modified-Since")) != null) {
                boolean noLastModifiedAvailable;
                long cgetDate = ServletTools.parseDateHeader(cgetHeader);
                boolean bl = noLastModifiedAvailable = lastMod == -1L;
                if (noLastModifiedAvailable) {
                    lastMod = System.currentTimeMillis();
                    log.warn("Container does not provide last modified timestamp, using current time as last modified.");
                }
                int cgetWindow = config.getInt("servlet.containerIO.cgetWindow", 0);
                if (cgetDate != -1L && lastMod <= cgetDate || noLastModifiedAvailable && lastMod - (long)(cgetWindow * 1000) <= cgetDate) {
                    Logger.download.info((Object)"Returning 304: Not modified on conditional get of", fileName);
                    context.response.setStatus(304);
                    if (!noExpires) {
                        ServletTools.setExpiresHeaders(context.response, ServletTools.expirationForMimeType(mimeType, expiresOverrides));
                    }
                    context.response.setContentLength(0);
                    try {
                        output.flush();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        context.response.flushBuffer();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        output.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Logger.download.debug("done sending 304 for file: " + fileName);
                    return;
                }
            }
            boolean compress = false;
            String compressedFilePath = filePath + ".gz";
            ISCFile compressedFile = null;
            if (ServletTools.compressionEnabled() && (ServletTools.browserClaimsGZSupport((HttpServletRequest)context.request) || ServletTools.alwaysCompressMimeType(mimeType)) && ServletTools.compressionWorksForMimeType(context, mimeType) && ServletTools.compressionEnabledForMimeType(mimeType)) {
                compressedFile = ISCFile.newInstance(compressedFilePath);
                compress = compressedFile.exists();
            }
            ISCFile fileToSend = compress ? compressedFile : file;
            String charset = null;
            if (charsetMap != null) {
                charset = (String)charsetMap.get(mimeType);
            }
            String contentType = mimeType + (charset != null ? "; charset=" + charset : "");
            context.response.setContentType(contentType);
            context.response.setStatus(200);
            if (!noExpires) {
                context.response.setDateHeader("Last-Modified", lastMod);
                ServletTools.setExpiresHeaders(context.response, ServletTools.expirationForMimeType(mimeType, expiresOverrides));
            }
            if (compress) {
                Logger.download.info((Object)"Using gzipped form of request file", filePath);
                context.response.setHeader("Content-Encoding", "gzip");
            }
            boolean bufferring = (contentLength = (int)fileToSend.length()) == -1;
            in = fileToSend.getInputStream();
            ByteArrayOutputStream byteOut = null;
            if (bufferring) {
                log.warn("Container does not provide content length, bufferring to determine file size.");
                byteOut = new ByteArrayOutputStream();
                IOUtil.copyStreams(in, (OutputStream)byteOut, false);
                byteOut.flush();
                contentLength = byteOut.size();
            }
            context.response.setContentLength(contentLength);
            try {
                if (bufferring) {
                    byteOut.writeTo((OutputStream)output);
                } else {
                    IOUtil.copyStreams(in, (OutputStream)output, false);
                }
            }
            catch (SocketException se) {
                log.warn(se.toString());
            }
            try {
                output.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                context.response.flushBuffer();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                output.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            Logger.download.info("done streaming: " + filePath);
            return;
        }
        catch (Exception e) {
            Logger.download.error((Object)("Problem sending static file: " + filePath), e);
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static long parseDateHeader(String headerValue) {
        int separatorPos = headerValue.indexOf(";");
        if (separatorPos != -1) {
            headerValue = headerValue.substring(0, separatorPos);
        }
        try {
            return new SimpleDateFormat(httpDateFormat, Locale.ENGLISH).parse(headerValue).getTime();
        }
        catch (Exception e) {
            Logger.download.warning("Exception parsing date header with value: '" + headerValue + "': " + e);
            return -1L;
        }
    }

    public static long expirationForMimeType(String mimeType) {
        return ServletTools.expirationForMimeType(mimeType, null);
    }

    public static long expirationForMimeType(String mimeType, Map expiresOverride) {
        if (mimeType == null) {
            return 0L;
        }
        long delta = 0L;
        if (expiresOverride != null) {
            Long expiry = (Long)expiresOverride.get(mimeType);
            if (expiry == null) {
                expiry = (Long)expiresOverride.get("*");
            }
            if (expiry != null) {
                delta = expiry;
            }
        } else {
            delta = config.getLong((Object)(EXPIRATION_PROP_BASE + mimeType), 0L);
            if (delta == 0L) {
                delta = config.getLong((Object)"servlet.static.expiration.default", 0L);
            }
        }
        if (delta == 0L) {
            return 0L;
        }
        Logger.download.debug("Expiration for static file: " + delta + " seconds from download");
        return delta;
    }

    public static long expirationTime(long delta) {
        return System.currentTimeMillis() + delta * 1000L;
    }

    public static boolean responseContainsExpires(HttpServletResponse response) {
        return response.containsHeader("Expires") || response.containsHeader("Cache-Control") || response.containsHeader("Pragma");
    }

    public static void setExpiresHeaders(HttpServletResponse response, long expiration) {
        if (!ServletTools.responseContainsExpires(response) && expiration != 0L) {
            boolean setPublic = config.getBoolean((Object)"servlet.static.enableProxyCache", true);
            response.setHeader("Cache-Control", (setPublic ? "public" : "") + "," + " max-age=" + expiration);
            long expirationTime = ServletTools.expirationTime(expiration);
            response.setDateHeader("Expires", expirationTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _sendFile(String filename, Object out) throws IOException {
        long start = System.currentTimeMillis();
        String path = DataTools.makePathAbsolute(filename);
        InputStream in = DataTools.inputStreamForFilename(path);
        try {
            if (out instanceof OutputStream) {
                IOUtil.copyStreams(in, (OutputStream)out, false);
            } else {
                IOUtil.copyCharacterStreams((Reader)new InputStreamReader(in), (Writer)out, false);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
        long end = System.currentTimeMillis();
        Logger.timing.debug("Streamed " + filename + ": " + (end - start) + "ms");
    }

    public static void sendFile(String filename, OutputStream out) throws IOException {
        ServletTools._sendFile(filename, out);
    }

    public static void sendFile(String filename, Writer out) throws IOException {
        ServletTools._sendFile(filename, out);
    }

    public static void handleServletError(HttpServletResponse response, String errorMessage, Throwable t) {
        PrintWriter out = null;
        try {
            out = response.getWriter();
        }
        catch (Exception e) {
            try {
                out = new PrintWriter((OutputStream)response.getOutputStream());
            }
            catch (Exception ee) {
                log.error((Object)"Top-level servlet error: ", ee);
            }
        }
        if (config.getBoolean((Object)"debug", false)) {
            response.setContentType("text/html");
            if (config.getBoolean((Object)"servlet.sendStackTraceToClient", false)) {
                out.print(DataTools.escapeHTML(DataTools.getStackTrace(t)));
            } else {
                out.print(DataTools.escapeHTML(t.getMessage()));
            }
        } else {
            String defaultErrorPage = config.getString("defaultErrorPage");
            if (defaultErrorPage != null) {
                try {
                    response.sendRedirect(defaultErrorPage);
                }
                catch (Exception e) {
                    log.error((Object)("Unable to redirect to defaultErrorPage: " + defaultErrorPage), e);
                }
            }
        }
    }

    public static void sendFormattedError(HttpServletResponse response, String error) throws IOException {
        response.setStatus(200);
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        out.println("<CODE><PRE>");
        out.println(error);
        out.println("</PRE></CODE>");
        out.close();
    }

    public static void sendFormattedError(HttpServletResponse response, Exception e) throws IOException {
        ServletTools.sendFormattedError(response, DataTools.getStackTrace(e));
    }

    public static String scriptBlock(String data) {
        StringBuilder sb = new StringBuilder();
        sb.append("<SCRIPT>\n");
        sb.append(data);
        sb.append("</SCRIPT>\n");
        return sb.toString();
    }

    public static Appendable messageEvent(Appendable out, CharSequence data) throws IOException {
        Matcher matcher = SSE_EOL_PATTERN.matcher(data);
        if (!matcher.find()) {
            out.append("data: ");
            out.append(data);
            out.append("\n\n");
        } else {
            int lastLineStartPos = 0;
            do {
                out.append("data: ");
                out.append(data, lastLineStartPos, matcher.start());
                out.append(data, matcher.start(), matcher.end());
            } while (matcher.find(lastLineStartPos = matcher.end()));
            if (lastLineStartPos < data.length()) {
                out.append("data: ");
                out.append(data, lastLineStartPos, data.length());
                out.append('\n');
            }
            out.append('\n');
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendScriptBlock(String data, Writer out) throws Exception {
        Writer writer = out;
        synchronized (writer) {
            data = ServletTools.scriptBlock(data);
            out.write(data);
        }
    }

    public static ByteArrayOutputStream getFlushBuffer(int dataSize) {
        ByteArrayOutputStream flushBuffer = new ByteArrayOutputStream();
        int bufferSize = config.getInt("messaging.flushBufferSize", 1024);
        if (bufferSize == 0) {
            return flushBuffer;
        }
        bufferSize -= dataSize % bufferSize;
        for (int i = 0; i < bufferSize; ++i) {
            flushBuffer.write(32);
        }
        return flushBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendScriptBlockWithPadding(String data, Writer out) throws Exception {
        Writer writer = out;
        synchronized (writer) {
            ServletTools.sendScriptBlock(data, out);
            out.write(ServletTools.getFlushBuffer(data.length()).toString());
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMessageEventWithPadding(String data, Writer out) throws IOException {
        Writer writer = out;
        synchronized (writer) {
            int bufferSize = config.getInt("messaging.flushBufferSize", 1024);
            int dataSize = data.length();
            int padSize = bufferSize - dataSize % bufferSize;
            if (padSize != 0) {
                out.append(':');
                while (spaces.length() < padSize) {
                    spaces = spaces + spaces;
                }
                out.append(spaces, 0, padSize);
                out.append('\n');
            }
            ServletTools.messageEvent(out, data);
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendHTMLStart(Writer out) throws Exception {
        Writer writer = out;
        synchronized (writer) {
            out.write(htmlStart);
            out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendHTMLEnd(Writer out) throws Exception {
        Writer writer = out;
        synchronized (writer) {
            out.write(htmlEnd);
            out.flush();
        }
    }

    public static String getInitialRequestURI(HttpServletRequest request) {
        String contextPath;
        String requestURI;
        String forwardURI = (String)request.getAttribute("javax.servlet.forward.request_uri");
        if (forwardURI != null) {
            requestURI = forwardURI;
            contextPath = (String)request.getAttribute("javax.servlet.forward.context_path");
        } else {
            requestURI = request.getRequestURI();
            contextPath = request.getContextPath();
        }
        if (contextPath.length() > 0) {
            requestURI = requestURI.substring(contextPath.length());
        }
        String decodedURI = URLDecoder.decode(requestURI);
        String canonicalURI = ISCFile.canonicalizePath(decodedURI);
        if (decodedURI.endsWith("/") && !canonicalURI.endsWith("/")) {
            canonicalURI = canonicalURI + "/";
        }
        return canonicalURI;
    }

    public static String getCurrentRequestURI(HttpServletRequest request) {
        String contextPath;
        String requestURI;
        String includeURI = (String)request.getAttribute("javax.servlet.include.request_uri");
        if (includeURI != null) {
            requestURI = includeURI;
            contextPath = (String)request.getAttribute("javax.servlet.include.context_path");
        } else {
            requestURI = request.getRequestURI();
            contextPath = request.getContextPath();
        }
        if (contextPath.length() > 0) {
            requestURI = requestURI.substring(contextPath.length());
        }
        String decodedURI = URLDecoder.decode(requestURI);
        String canonicalURI = ISCFile.canonicalizePath(decodedURI);
        if (decodedURI.endsWith("/") && !canonicalURI.endsWith("/")) {
            canonicalURI = canonicalURI + "/";
        }
        return canonicalURI;
    }

    public static void applyConfigToServletOrFilter(Object target, Object targetConfig) {
        String className;
        String shortClassName = className = target.getClass().getName();
        if (className.lastIndexOf(".") != -1) {
            shortClassName = className.substring(className.lastIndexOf(".") + 1);
        }
        try {
            String targetName = targetConfig instanceof FilterConfig ? ((FilterConfig)targetConfig).getFilterName() : ((ServletConfig)targetConfig).getServletName();
            Config overlayConfig = (Config)((Object)DataTools.cascadeMaps(new Map[]{config.getSubtree(shortClassName), shortClassName.equals(targetName) ? null : config.getSubtree(targetName), ServletTools.servletOrFilterParametersToMap(targetConfig), new Config()}));
            Config.initClassInstance(target, overlayConfig);
        }
        catch (Exception e) {
            Throwable t = Reflection.getRealTargetException(e);
            log.warn((Object)("Problem setting config on " + target + " - configuration may be incomplete"), t);
        }
    }

    public static Map servletOrFilterParametersToMap(Object targetConfig) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (targetConfig instanceof FilterConfig) {
            FilterConfig filterConfig = (FilterConfig)targetConfig;
            Enumeration e = filterConfig.getInitParameterNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                result.put(key, filterConfig.getInitParameter(key));
            }
        } else {
            ServletConfig servletConfig = (ServletConfig)targetConfig;
            Enumeration e = servletConfig.getInitParameterNames();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                result.put(key, servletConfig.getInitParameter(key));
            }
        }
        return result;
    }

    public static boolean doNotTrackRPC(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (queryString == null) {
            return false;
        }
        return queryString.indexOf("isc_doNotTrackRPC=1") != -1;
    }

    static {
        SSE_EOL_PATTERN = Pattern.compile("\r\n|\r|\n");
        htmlStart = "<HTML><BODY>";
        htmlEnd = "</BODY></HTML>";
    }
}

