/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.taglib;

import com.isomorphic.taglib.LoadTag;
import com.isomorphic.util.DataTools;
import java.io.IOException;
import java.io.Writer;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;

public class LoadSkinTag
extends LoadTag {
    public String skin = null;
    public String skinDir = null;

    public int doStartTag() throws JspException {
        this.init();
        try {
            JspWriter out = this.pageContext.getOut();
            LoadSkinTag.outputSkin((Writer)out, this.skin, this.skinDir, this);
        }
        catch (Throwable e) {
            this.log.error((Object)"Exception while attempting to process a loadSkin tag.", e);
            throw new JspException(DataTools.getStackTrace(e));
        }
        return 0;
    }

    public static void outputSkin(Writer out, String skin, String skinDir, LoadTag tag) throws IOException {
        String isomorphicURI = tag.getIsomorphicURI();
        boolean cacheOnly = "true".equals(tag.getCacheOnly());
        boolean defer = "true".equals(tag.getDefer());
        if (skinDir != null && skin != null) {
            throw new IOException("can only specify one of 'skin' or 'skinDir'");
        }
        String skinName = "standard";
        if (skin != null && (skinName = skin).indexOf(".js") != -1) {
            skinName = skinName.substring(0, skinName.indexOf(".js"));
        }
        boolean useSkinDir = false;
        if (skinDir == null) {
            skinDir = isomorphicURI + "skins/" + skinName + "/";
        } else {
            useSkinDir = true;
        }
        if (!skinDir.endsWith("/")) {
            skinDir = skinDir + "/";
        }
        String skinJSFile = tag.addVersion(skinDir + "load_skin.js");
        if (cacheOnly || defer) {
            out.write("<SCRIPT>");
            if (cacheOnly) {
                out.write("isc.FileLoader.cacheSkin('" + (useSkinDir ? skinDir : skinName) + "'");
            } else {
                out.write("isc.FileLoader.loadSkin('" + (useSkinDir ? skinDir : skinName) + "'");
            }
            String onload = tag.getOnload();
            if (onload != null) {
                out.write(", \"" + onload + "\"");
            }
            out.write(");");
            out.write("</SCRIPT>");
        } else {
            out.write("<SCRIPT SRC=" + skinJSFile + "></SCRIPT>\n");
        }
    }

    public void setSkin(String skin) {
        this.skin = skin;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkinDir(String skinDir) {
        this.skinDir = skinDir;
    }

    public String getSkinDir() {
        return this.skinDir;
    }
}

