/*
 * Decompiled with CFR 0.152.
 */
package com.opera.core.systems.internal;

import com.opera.core.systems.OperaSettings;
import com.opera.core.systems.internal.WatirUtils;
import java.io.File;
import java.util.logging.Logger;
import org.openqa.selenium.io.FileHandler;

public class ProfileUtils {
    private String largePrefsFolder;
    private String smallPrefsFolder;
    private String cachePrefsFolder;
    private OperaSettings settings;
    protected final Logger logger = Logger.getLogger(this.getClass().getName());

    public ProfileUtils(String largePrefsFolder, String smallPrefsFolder, String cachePrefsFolder, OperaSettings settings) {
        this.settings = settings;
        this.largePrefsFolder = largePrefsFolder;
        this.smallPrefsFolder = smallPrefsFolder;
        this.cachePrefsFolder = cachePrefsFolder;
    }

    public boolean isMac() {
        return System.getProperty("os.name").startsWith("Mac");
    }

    public boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    public boolean isMainProfile(String prefsPath) {
        File prefsFile = new File(prefsPath);
        String absolutePrefsPath = prefsFile.getAbsolutePath();
        String path = System.getProperty("user.home");
        if (this.isMac()) {
            File appSupport = new File(path + "/Library/Application Support/Opera");
            File cache = new File(path + "/Library/Caches/Opera");
            File prefs = new File(path + "/Library/Preferences/Opera Preference");
            if (absolutePrefsPath.startsWith(appSupport.getAbsolutePath()) || absolutePrefsPath.startsWith(cache.getAbsolutePath()) || absolutePrefsPath.startsWith(prefs.getAbsolutePath())) {
                return true;
            }
        } else if (this.isWindows()) {
            String appData = System.getenv("APPDATA");
            File appFile = new File(appData + "\\Opera");
            if (absolutePrefsPath.startsWith(appFile.getAbsolutePath())) {
                return true;
            }
            String homeDrive = System.getenv("HOMEDRIVE");
            String homePath = System.getenv("HOMEPATH");
            File homeOpera = new File(homeDrive + homePath + "\\Local Settings\\Application Data\\Opera");
            if (absolutePrefsPath.startsWith(homeOpera.getAbsolutePath())) {
                return true;
            }
            String localAppData = System.getenv("LOCALAPPDATA");
            File localAppDataFile = new File(localAppData + "\\Opera");
            if (absolutePrefsPath.startsWith(localAppDataFile.getAbsolutePath())) {
                return true;
            }
            File exeFile = this.settings.getBinary();
            String parentPath = exeFile.getParent();
            File profileFolder = new File(parentPath + "\\profile");
            if (prefsFile.equals(profileFolder)) {
                return true;
            }
        } else {
            File dotOpera = new File(path + "/.opera");
            if (prefsFile.equals(dotOpera)) {
                return true;
            }
        }
        return false;
    }

    public boolean deleteProfile() {
        String[] profileDirs;
        for (String profileDir : profileDirs = new String[]{this.smallPrefsFolder, this.largePrefsFolder, this.cachePrefsFolder}) {
            if (!this.isMainProfile(profileDir)) continue;
            this.logger.finer("Skipping profile deletion since '" + profileDir + "' is the main profile.");
            return false;
        }
        for (String profileDir : profileDirs) {
            File currentDirHandle = new File(profileDir);
            if (!currentDirHandle.exists()) {
                this.logger.finer("Skipping profile deletion for '" + profileDir + "' since it doesn't exist.");
                continue;
            }
            boolean deleted = this.deleteFolder(profileDir);
            if (!deleted) {
                int retryIntervalMs = 500;
                int retryMaxCount = 10;
                int retryCount = 0;
                boolean ok = false;
                this.logger.warning("Profile could not be deleted, retrying...");
                do {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    ok = this.deleteFolder(profileDir);
                } while (++retryCount <= 10 && !ok);
                if (!ok) {
                    this.logger.severe("Could not delete profile in '" + profileDir + "'. Skipping further deletion.");
                    return false;
                }
                this.logger.warning("Deleted profile, retry count = " + retryCount);
                continue;
            }
            this.logger.finer("Deleted profile in '" + profileDir + "'");
        }
        return true;
    }

    public boolean copyProfile(String newPrefs) {
        File newPrefsFile = new File(newPrefs);
        if (!newPrefsFile.exists()) {
            this.logger.warning("The directory '" + newPrefs + "' doesn't exist, failed to copy profile.");
            return false;
        }
        File smallPrefsFolderFile = new File(this.smallPrefsFolder);
        this.logger.finer("Copying profile from '" + newPrefs + "'");
        return WatirUtils.copyDirAndFiles(newPrefsFile, smallPrefsFolderFile);
    }

    private boolean deleteFolder(String folderPath) {
        return FileHandler.delete((File)new File(folderPath));
    }
}

