/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.velocity;

import com.isomorphic.datasource.DataSource;
import com.isomorphic.log.Logger;
import com.isomorphic.velocity.IOWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;

public class ISCReferenceInsertionEventHandler
implements ReferenceInsertionEventHandler {
    private static final String[] ESCAPING_EXCEPTIONS = new String[]{"$defaultSelectClause", "$defaultTableClause", "$defaultWhereClause", "$defaultValuesClause", "$defaultGroupClause", "$defaultGroupWhereClause", "$defaultOrderClause", "$rawValue", "$filter", "$equals", "$substringMatches", "$fields", "$qfields", "$defaultJoinWhereClause", "$defaultAnsiJoinClause", "$log", "$defaultGroupWithAliasClause"};
    private static Logger log = new Logger(ISCReferenceInsertionEventHandler.class.getName());
    private boolean escapeValues;
    private DataSource ds;
    private List externals = new ArrayList();
    public Object foundObject;
    boolean nullReferences = false;
    private Set<String> additionalEscapingExclusions;

    public ISCReferenceInsertionEventHandler(Context ctx) {
        this(ctx, null, false, null);
    }

    public ISCReferenceInsertionEventHandler(Context ctx, DataSource ds, boolean escapeValues, Set<String> additionalEscapingExclusions) {
        this.escapeValues = escapeValues;
        this.ds = ds;
        EventCartridge ec = new EventCartridge();
        ec.addEventHandler((EventHandler)this);
        ec.attachToContext(ctx);
        Object[] keys = ctx.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            this.externals.add(keys[i].toString());
        }
        this.additionalEscapingExclusions = additionalEscapingExclusions;
    }

    public Object referenceInsert(String reference, Object data) {
        if (data instanceof IOWrapper) {
            data = data.toString();
        }
        if (data == null) {
            this.nullReferences = true;
        }
        this.foundObject = data;
        if (this.escapeValues && this.ds == null) {
            log.warn("getParameter() called but DataSource has not been set - returning warning");
            return "'Unsafe to retrieve " + reference + " - DataSource has not been set'";
        }
        if (reference.charAt(1) == '{') {
            reference = reference.substring(0, 1) + reference.substring(2, reference.length() - 1);
        }
        if (this.escapeValues) {
            for (int i = 0; i < ESCAPING_EXCEPTIONS.length; ++i) {
                if (!reference.equals(ESCAPING_EXCEPTIONS[i]) && !reference.startsWith(ESCAPING_EXCEPTIONS[i] + ".")) continue;
                return data;
            }
            String trimmedReference = reference.substring(1);
            if (this.additionalEscapingExclusions != null) {
                for (String snippetName : this.additionalEscapingExclusions) {
                    if (!trimmedReference.equals(snippetName) && !trimmedReference.startsWith(snippetName + ".")) continue;
                    return data;
                }
            }
            boolean escape = false;
            for (int i = 0; i < this.externals.size(); ++i) {
                String external = "$" + (String)this.externals.get(i);
                if (!reference.equals(external) && !reference.startsWith(external + ".")) continue;
                escape = true;
                break;
            }
            if (escape) {
                try {
                    return this.ds.escapeValueForWhereClause(data, reference);
                }
                catch (Exception e) {
                    log.error((Object)"Unable to escape value for where clause", e);
                    return data;
                }
            }
            return data;
        }
        return data;
    }
}

