/*
 * Decompiled with CFR 0.152.
 */
package com.isomorphic.examples;

import com.isomorphic.base.Reflection;
import com.isomorphic.util.DataTools;
import com.isomorphic.xml.XML;
import java.beans.PropertyDescriptor;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DataSourceGenerator {
    public static Map generateDataSourceConfig(String className) throws Exception {
        Class classObj = Reflection.classForName((String)className);
        Map propertyDescriptors = DataTools.getPropertyDescriptors((Class)classObj);
        String shortName = className;
        int lastPeriod = className.lastIndexOf(46);
        if (lastPeriod > 0) {
            shortName = className.substring(lastPeriod + 1);
        }
        HashMap<String, Object> dsConfig = new HashMap<String, Object>();
        dsConfig.put("ID", shortName);
        ArrayList fields = new ArrayList();
        for (String propertyName : propertyDescriptors.keySet()) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)propertyDescriptors.get(propertyName);
            String type = propertyDescriptor.getPropertyType().getName();
            String fieldType = null;
            if ("java.lang.String".equals(type) || "java.lang.Character".equals(type) || "char".equals(type)) {
                fieldType = "text";
            } else if ("java.lang.Boolean".equals(type) || "boolean".equals(type)) {
                fieldType = "boolean";
            } else if ("java.util.Date".equals(type)) {
                fieldType = "date";
            } else if ("java.lang.Byte".equals(type) || "byte".equals(type) || "java.lang.Short".equals(type) || "short".equals(type) || "java.lang.Integer".equals(type) || "int".equals(type) || "java.lang.Long".equals(type) || "long".equals(type) || "java.math.BigInteger".equals(type)) {
                fieldType = "integer";
            } else if ("java.lang.Float".equals(type) || "float".equals(type) || "java.lang.Double".equals(type) || "double".equals(type) || "java.math.BigDecimal".equals(type)) {
                fieldType = "float";
            }
            if (fieldType == null) continue;
            HashMap<String, String> field = new HashMap<String, String>();
            field.put("name", propertyName);
            field.put("type", fieldType);
            fields.add(field);
        }
        dsConfig.put("fields", fields);
        return dsConfig;
    }

    public static String generateDataSource(String className) throws Exception {
        Map dsConfig = DataSourceGenerator.generateDataSourceConfig(className);
        StringWriter out = new StringWriter();
        out.write("<DataSource ID=\"" + dsConfig.get("ID") + "\">\n");
        out.write("<fields>\n");
        List fields = (List)dsConfig.get("fields");
        Iterator i = fields.iterator();
        while (i.hasNext()) {
            XML.recordToXML((String)"field", (Map)((Map)i.next()), (Writer)out, (boolean)true, null);
        }
        out.write("</fields>\n");
        out.write("</DataSource>");
        return out.toString();
    }
}

